#ifndef CGIMAGE_H
#define CGIMAGE_H



#include <CoreGraphics/CGBase.h>
#include <CoreGraphics/CGColorSpace.h>
#include <CoreGraphics/CGDataProvider.h>
#include <CoreFoundation/CFBase.h>
#include <AvailabilityMacros.h>

/*CGImageRef

Defines an opaque type that encapsulates bitmap image information.

typedef struct CGImage *CGImageRef;
Discussion

A bitmap image is a rectangular array of pixels, with each pixel representing a single point in an image. Quartz uses CGImage to represent bitmap images and bitmap image masks.

To create a Quartz image, you call CGImageCreate or CGImageMaskCreate with parameters that describe the precise format of the bitmap. To draw the image, you use CGContextDrawImage. In addition to the actual image data and information related to it, a CGImage may have a decode array, a CGColorRenderingIntent constant, and an interpolation setting.

For each color component in the image’s color space, a decode array provides a pair of values denoting the upper and lower limits of a range. For example, the decode array for a source image in the RGB color space would contain six entries total, consisting of one pair each for red, green, and blue. When the image is rendered, Quartz uses a linear transform to map the original component value into a relative number within your designated range that is appropriate for the destination color space.

A CGColorRenderingIntent constant specifies how Quartz should handle colors that are not located within the gamut of the destination color space of a graphics context. The rendering intent determines the exact method used to map colors from one color space to another. For descriptions of the defined rendering-intent constants, see CGColorRenderingIntent.

The interpolation setting is a Boolean value that specifies whether Quartz should apply a pixel-smoothing algorithm to the image. Without interpolation, the image may appear jagged or pixelated when drawn on an output device with higher resolution than the image data.

In Mac OS X version 10.2 and later, CGImageRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct CGImage *CGImageRef;

/*CGImageRelease

Decrements the retain count of a Quartz image.

void CGImageRelease (
   CGImageRef image
);
Parameters
image

The image to release. 
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the image parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
void CGImageRelease (
   CGImageRef image
);

#endif