#ifndef CGLTYPES_H
#define CGLTYPES_H
#include <HYS/OpenGL/CGLTypes.h>

#ifdef __cplusplus
extern "C" {
#endif

/*CGLPixelFormatObj

Represents a pointer to an opaque pixel format object.

typedef struct _CGLPixelFormatObject *CGLPixelFormatObj;
Discussion

This data type points to a structure that CGL uses to maintain pixel format and virtual screen information for a given set of renderer and buffer options. Use the functions described in “Managing Pixel Format Objects” to create, manage, access, and free a pixel format object.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGLTypes.h*/
typedef struct _CGLPixelFormatObject *CGLPixelFormatObj;

/*CGLContextObj

Represents a pointer to an opaque CGL context object.

typedef struct _CGLContextObject *CGLContextObj;
Discussion

This data type points to a structure that CGL uses to maintain state and other information associated with an OpenGL rendering context. Use the functions described in “Managing Contexts” and “Getting and Setting Context Options” to create, manage, access, and free a CGL context object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGLTypes.h*/
typedef struct _CGLContextObject *CGLContextObj;

#ifdef __cplusplus
}
#endif

#endif