#ifndef   CVBUFFER_H
#define  CVBUFFER_H

#include <TargetConditionals.h>

#include <QuartzCore/CVBase.h>
#include <QuartzCore/CVReturn.h>
#include <CoreFoundation/CFDictionary.h>
#include <stddef.h>
#include <stdint.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*CVBufferRef

Defines the base type for all Core Video buffers.

typedef struct __CVBuffer *CVBufferRef;
Discussion

CVBuffers represent an abstract type from which all Core Video buffers derive. 
Availability
Available in Mac OS X v10.3 and later.*/

typedef struct __CVBuffer *CVBufferRef;

/*CVBufferRelease

Releases a Core Video buffer. 

void CVBufferRelease (CVBufferRef buffer);
Parameters
buffer

The Core Video buffer that you want to release.
Discussion

Like CFRelease CVBufferRelease decrements the retain count of a Core Video buffer. If that count consequently becomes zero the memory allocated to the object is deallocated and the object is destroyed. Unlike CFRelease, you can pass NULL to CVBufferRelease without causing a crash. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVBuffer.h*/
void CVBufferRelease (CVBufferRef buffer);

#ifdef __cplusplus
}
#endif
#endif