#ifndef IOKITLIB_H
#include <IOKit/IOKitLib.h>
#endif

/*IOServiceMatching


Creates a matching dictionary that specifies an
 IOService class match. 
CFMutableDictionaryRef IOServiceMatching( 
    const char *name );  
Parameters
name
The class name, as a const C string. Class matching is successful on IOService objects of this class or any subclass.
Return Value

The matching dictionary created, is returned on success, or zero on failure. The dictionary is commonly passed to IOServiceGetMatchingServices or IOServiceAddMatchingNotification which will consume a reference, otherwise it should be released with CFRelease by the caller. 
Discussion 

A very common matching criteria for an IOService object is based on its class. IOServiceMatching will create a matching dictionary that specifies any IOService object of a class, or its subclasses. The class is specified by C string name.*/
CFMutableDictionaryRef IOServiceMatching( 
    const char *name ){
//TODO
};  


/*IOServiceGetMatchingServices


Look up registered IOService objects that match a matching dictionary. 
kern_return_t IOServiceGetMatchingServices( 
    mach_port_t masterPort, 
    CFDictionaryRef matching, 
    io_iterator_t *existing );  
Parameters
masterPort
The master port obtained from IOMasterPort. Pass kIOMasterPortDefault to look up the default master port.
matching
A CF dictionary containing matching information, of which one reference is always consumed by this function. (Note that prior to the Tiger release there was a small chance that the dictionary might not be released if there was an error attempting to serialize the dictionary). IOKitLib can construct matching dictionaries for common criteria with helper functions such as IOServiceMatching, IOServiceNameMatching, IOBSDNameMatching, IOOpenFirmwarePathMatching.
existing
An iterator handle is returned on success, and should be released by the caller when the iteration is finished.
Return Value

A kern_return_t error code. 
Discussion 

This is the preferred method of finding IOService objects currently registered by the I/O Kit (that is, objects that have had their registerService methods invoked). To find IOService objects that aren't yet registered, use an iterator as created by IORegistryEntryCreateIterator. IOServiceAddMatchingNotification can also supply this information and install a notification of new IOService objects. The matching information used in the matching dictionary may vary depending on the class of service being looked up.*/
kern_return_t IOServiceGetMatchingServices( 
    mach_port_t masterPort, 
    CFDictionaryRef matching, 
    io_iterator_t *existing ){
//TODO
};  


/*IOObjectGetClass


Returns the class name of an I/O Kit object. 
kern_return_t IOObjectGetClass( 
    io_object_t object, 
    io_name_t className );  
Parameters
object
The I/O Kit object.
className
Caller allocated buffer to receive the name string.
Return Value

A kern_return_t error code. 
Discussion 

This function uses the OSMetaClass system in the kernel to derive the name of the class the object is an instance of.*/
kern_return_t IOObjectGetClass( 
    io_object_t object, 
    io_name_t className ){
//TODO
};  


/*IORegistryEntryCreateIterator


Creates an iterator rooted at a given registry entry. 
kern_return_t IORegistryEntryCreateIterator( 
    io_registry_entry_t entry, 
    const io_name_t plane, 
    IOOptionBits options, 
    io_iterator_t *iterator );  
Parameters
entry
The root entry to begin the iteration at.
plane
The name of an existing I/O Registry plane. Plane names are defined in IOKitKeys.h, eg. kIOServicePlane.
options
kIORegistryIterateRecursively may be set to recurse automatically into each entry as it is returned from calls on the registry iterator. kIORegistryIterateParents may be set to iterate the parents of each entry, by default the children are iterated.
iterator
A created iterator handle, to be released by the caller when it has finished with it.
Return Value

A kern_return_t error code. 
Discussion 

This method creates an IORegistryIterator object in the kernel that is set up with options to iterate over the children or parents of a root entry, and to recurse automatically into entries as they are returned, or only when instructed with calls to IORegistryIteratorEnterEntry. The iterator object keeps track of entries that have been recursed into previously to avoid loops.*/
kern_return_t IORegistryEntryCreateIterator( 
    io_registry_entry_t entry, 
    const io_name_t plane, 
    IOOptionBits options, 
    io_iterator_t *iterator ){
//TODO
};  


/*IOObjectRetain


Retains an object handle previously returned by IOKitLib. 
kern_return_t IOObjectRetain( 
    io_object_t object );  
Parameters
object
The I/O Kit object to retain.
Return Value

A kern_return_t error code. 
Discussion 

Gives the caller an additional reference to an existing object handle previously returned by IOKitLib.*/
kern_return_t IOObjectRetain( 
    io_object_t object ){
//TODO
};  


/*IOBSDNameMatching


Creates a matching dictionary that specifies an IOService match based on BSD device name. 
CFMutableDictionaryRef IOBSDNameMatching( 
    mach_port_t masterPort, 
    unsigned int options, 
    const char *bsdName );  
Parameters
masterPort
The master port obtained from IOMasterPort. Pass kIOMasterPortDefault to look up the default master port.
options
No options are currently defined.
bsdName
The BSD name, as a const char pointer.
Return Value

The matching dictionary created, is returned on success, or zero on failure. The dictionary is commonly passed to IOServiceGetMatchingServices or IOServiceAddMatchingNotification which will consume a reference, otherwise it should be released with CFRelease by the caller. 
Discussion 

IOService objects that represent BSD devices have an associated BSD name. This function creates a matching dictionary that will match IOService objects with a given BSD name.*/
CFMutableDictionaryRef IOBSDNameMatching( 
    mach_port_t masterPort, 
    unsigned int options, 
    const char *bsdName ){
//TODO
};  



/*IOIteratorNext


Returns the next object in an iteration. 
io_object_t IOIteratorNext( 
    io_iterator_t iterator );  
Parameters
iterator
An I/O Kit iterator handle.
Return Value

If the iterator handle is valid, the next element in the iteration is returned, otherwise zero is returned. The element should be released by the caller when it is finished. 
Discussion 

This function returns the next object in an iteration, or zero if no more remain or the iterator is invalid.*/
io_object_t IOIteratorNext( 
    io_iterator_t iterator ){
//TODO
};  


/*IOObjectRelease


Releases an object handle previously returned by IOKitLib. 
kern_return_t IOObjectRelease( 
    io_object_t object );  
Parameters
object
The I/O Kit object to release.
Return Value

A kern_return_t error code. 
Discussion 

All objects returned by IOKitLib should be released with this function when access to them is no longer needed. Using the object after it has been released may or may not return an error, depending on how many references the task has to the same object in the kernel.*/
kern_return_t IOObjectRelease( 
    io_object_t object ){
//TODO
};  

/*IORegistryEntryCreateCFProperty


Creates a CF representation of a registry entry's property. 
CFTypeRef IORegistryEntryCreateCFProperty( 
    io_registry_entry_t entry, 
    CFStringRef key, 
    CFAllocatorRef allocator, 
    IOOptionBits options );  
Parameters
entry
The registry entry handle whose property to copy.
key
A CFString specifying the property name.
allocator
The CF allocator to use when creating the CF container.
options
No options are currently defined.
Return Value

A CF container is created and returned the caller on success. The caller should release with CFRelease. 
Discussion 

This function creates an instantaneous snapshot of a registry entry property, creating a CF container analogue in the caller's task. Not every object available in the kernel is represented as a CF container; currently OSDictionary, OSArray, OSSet, OSSymbol, OSString, OSData, OSNumber, OSBoolean are created as their CF counterparts.*/
CFTypeRef IORegistryEntryCreateCFProperty( 
    io_registry_entry_t entry, 
    CFStringRef key, 
    CFAllocatorRef allocator, 
    IOOptionBits options ){
//TODO
};  


/*IOObjectConformsTo


Performs an OSDynamicCast operation on an I/O Kit object. 
boolean_t IOObjectConformsTo( 
    io_object_t object, 
    const io_name_t className );  
Parameters
object
An I/O Kit object.
className
The name of the class, as a C string.
Return Value

If the object handle is valid, and represents an object in the kernel that dynamic casts to the class true is returned, otherwise false. 
Discussion 

This function uses the OSMetaClass system in the kernel to determine if the object will dynamic cast to a class, specified as a C string (in other words, if the object is of that class or a subclass).*/
boolean_t IOObjectConformsTo( 
    io_object_t object, 
    const io_name_t className ){
//TODO
};  


/*IOServiceGetMatchingService


Look up a registered IOService object that matches a matching dictionary. 
io_service_t IOServiceGetMatchingService( 
    mach_port_t masterPort, 
    CFDictionaryRef matching );  
Parameters
masterPort
The master port obtained from IOMasterPort. Pass kIOMasterPortDefault to look up the default master port.
matching
A CF dictionary containing matching information, of which one reference is always consumed by this function. (Note that prior to the Tiger release there was a small chance that the dictionary might not be released if there was an error attempting to serialize the dictionary). IOKitLib can construct matching dictionaries for common criteria with helper functions such as IOServiceMatching, IOServiceNameMatching, IOBSDNameMatching, IOOpenFirmwarePathMatching.
Return Value

The first service matched is returned on success. The service must be released by the caller. 
Discussion 

This is the preferred method of finding an IOService object currently registered by the I/O Kit (that is, an object that has had its registerService method invoked). To find IOService objects that aren't yet registered, use an iterator as created by IORegistryEntryCreateIterator. IOServiceAddMatchingNotification can also supply this information and install a notification of new IOService objects. The matching information used in the matching dictionary may vary depending on the class of service being looked up. */
io_service_t IOServiceGetMatchingService( 
    mach_port_t masterPort, 
    CFDictionaryRef matching ){
//TODO
};  


/*IONotificationPortCreate


Creates and returns a notification object for receiving I/O Kit notifications of new devices or state changes. 
IONotificationPortRef IONotificationPortCreate( 
    mach_port_t masterPort );  
Parameters
masterPort
The master port obtained from IOMasterPort. Pass kIOMasterPortDefault to look up the default master port.
Return Value

A reference to the notification object. 
Discussion 

Creates the notification object to receive notifications from the I/O Kit of new device arrivals or state changes. The notification object can be supply a CFRunLoopSource, or mach_port_t to be used to listen for events.*/
IONotificationPortRef IONotificationPortCreate( 
    mach_port_t masterPort ){
//TODO
};  


/*IORegistryEntryGetName


Returns a C string name assigned to a registry entry. 
kern_return_t IORegistryEntryGetName( 
    io_registry_entry_t entry, 
    io_name_t name );  
Parameters
entry
The registry entry handle whose name to look up.
name
The caller's buffer to receive the name.
Return Value

A kern_return_t error code. 
Discussion 

Registry entries can be named in a particular plane or globally. This function returns the entry's global name. The global name defaults to the entry's meta class name if it has not been named.*/
kern_return_t IORegistryEntryGetName( 
    io_registry_entry_t entry, 
    io_name_t name ){
//.TODO
};  

int IOCreatePlugInInterfaceForService(int a, int b, int c, int d, int e){
//TODO
};


/*IOServiceAddInterestNotification


Register for notification of state changes in an IOService object. 
kern_return_t IOServiceAddInterestNotification( 
    IONotificationPortRef notifyPort, 
    io_service_t service, 
    const io_name_t interestType, 
    IOServiceInterestCallback callback, 
    void *refCon, 
    io_object_t *notification );  
Parameters
notifyPort
A IONotificationPortRef object that controls how messages will be sent when the notification is fired. See IONotificationPortCreate.
interestType
A notification type from IOKitKeys.h: 
kIOGeneralInterest General state changes delivered via the IOService::message API. 
kIOBusyInterest Delivered when the IOService object changes its busy state to or from zero. The message argument contains the new busy state causing the notification.
callback
A callback function called when the notification fires, with messageType and messageArgument for the state change.
refCon
A reference constant for the callback's use.
notification
An object handle is returned on success, and should be released by the caller when the notification is to be destroyed.
Return Value

A kern_return_t error code. 
Discussion 

IOService objects deliver notifications of their state changes to their clients via the IOService::message API, and to other interested parties including callers of this function. Message types are defined IOMessage.*/
kern_return_t IOServiceAddInterestNotification( 
    IONotificationPortRef notifyPort, 
    io_service_t service, 
    const io_name_t interestType, 
    IOServiceInterestCallback callback, 
    void *refCon, 
    io_object_t *notification ){
//TODO
};  


/*IONotificationPortGetRunLoopSource


Returns a CFRunLoopSource to be used to listen for notifications. 
CFRunLoopSourceRef IONotificationPortGetRunLoopSource( 
    IONotificationPortRef notify );  
Parameters
notify
The notification object.
Return Value

A CFRunLoopSourceRef for the notification object. 
Discussion 

A notification object may deliver notifications to a CFRunLoop client by adding the run loop source returned by this function to the run loop.*/
CFRunLoopSourceRef IONotificationPortGetRunLoopSource( 
    IONotificationPortRef notify ){
//TODO
};  



/*IOServiceAddMatchingNotification


Looks up registered IOService objects that match a matching dictionary, and install a notification request of new IOService objects that match. 
kern_return_t IOServiceAddMatchingNotification( 
    IONotificationPortRef notifyPort, 
    const io_name_t notificationType, 
    CFDictionaryRef matching, 
    IOServiceMatchingCallback callback, 
    void *refCon, 
    io_iterator_t *notification );  
Parameters
notifyPort
A IONotificationPortRef object that controls how messages will be sent when the armed notification is fired. When the notification is delivered, the io_iterator_t representing the notification should be iterated through to pick up all outstanding objects. When the iteration is finished the notification is rearmed. See IONotificationPortCreate.
notificationType
A notification type from IOKitKeys.h: 
kIOPublishNotification Delivered when an IOService object is registered. 
kIOFirstPublishNotification Delivered when an IOService object is registered, but only once per IOService instance. Some IOService objects may be reregistered when their state is changed. 
kIOMatchedNotification Delivered when an IOService object has had all matching drivers in the kernel probed and started. 
kIOFirstMatchNotification Delivered when an IOService object has had all matching drivers in the kernel probed and started, but only once per IOService instance. Some IOService objects may be reregistered when their state is changed. 
kIOTerminatedNotification Delivered after an IOService object has been terminated.
matching
A CF dictionary containing matching information, of which one reference is always consumed by this function. (Note that prior to the Tiger release there was a small chance that the dictionary might not be released if there was an error attempting to serialize the dictionary). IOKitLib can construct matching dictionaries for common criteria with helper functions such as IOServiceMatching, IOServiceNameMatching, IOBSDNameMatching, IOOpenFirmwarePathMatching.
callback
A callback function called when the notification fires.
refCon
A reference constant for the callback's use.
notification
An iterator handle is returned on success, and should be released by the caller when the notification is to be destroyed. The notification is armed when the iterator is emptied by calls to IOIteratorNext - when no more objects are returned, the notification is armed. Note that the notification is not armed when first created.
Return Value

A kern_return_t error code. 
Discussion 

This is the preferred method of finding IOService objects that may arrive at any time. The type of notification specifies the state change the caller is interested in, on IOService objects that match the matching dictionary. Notification types are identified by name, and are defined in IOKitKeys.h. The matching information used in the matching dictionary may vary depending on the class of service being looked up.*/
kern_return_t IOServiceAddMatchingNotification( 
    IONotificationPortRef notifyPort, 
    const io_name_t notificationType, 
    CFDictionaryRef matching, 
    IOServiceMatchingCallback callback, 
    void *refCon, 
    io_iterator_t *notification ){
//TODO
};  

