#ifndef COREFOUNDATION_H
#include <CoreFoundation/CoreFoundation.h>
#endif

#ifndef COREGRAPHICS_H
#include <CoreGraphics/CoreGraphics.h>
#endif


/*CFBundleCopyResourceURL

Returns the location of a resource contained in the specified bundle.

CFURLRef CFBundleCopyResourceURL (
   CFBundleRef bundle,
   CFStringRef resourceName,
   CFStringRef resourceType,
   CFStringRef subDirName
);
Parameters
bundle

The bundle to examine. 
resourceName

The name of the requested resource. 
resourceType

The abstract type of the requested resource. The type is expressed as a filename extension, such as jpg. Pass NULL if you dont need to search by type.
subDirName

The name of the subdirectory of the bundles resources directory to search. Pass NULL to search the standard CFBundle resource locations.
Return Value

A CFURL object describing the location of the requested resource, or NULL if the resource cannot be found. Ownership follows the Create Rule.
Discussion

For example, if a bundle contains a subdirectory WaterSounds that includes a file Water1.aiff, you can retrieve the URL for the file using:CFBundleCopyResourceURL(bundle, CFSTR("Water1"), CFSTR("aiff"), CFSTR("WaterSounds"));

Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyResourceURL (
   CFBundleRef bundle,
   CFStringRef resourceName,
   CFStringRef resourceType,
   CFStringRef subDirName){
//TODO
};

/*CFBundleCopyResourcesDirectoryURL

Returns the location of a bundles Resources directory.

CFURLRef CFBundleCopyResourcesDirectoryURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFURL object describing the location of bundles resources directory, or NULL if it could not be found. Ownership follows the Create Rule.
Discussion

In general, you should never need to use this function. Use CFBundleCopyResourceURL and similar functions instead. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyResourcesDirectoryURL (
   CFBundleRef bundle){
//TODO
};

/*CFBundleCreate

Creates a CFBundle object.

CFBundleRef CFBundleCreate (
   CFAllocatorRef allocator,
   CFURLRef bundleURL
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
bundleURL

The location of the bundle for which to create a CFBundle object.
Return Value

A CFBundle object created from the bundle at bundleURL. Ownership follows the Create Rule.

Returns NULL if there was a memory allocation problem. May return an existing CFBundle object with the reference count incremented. May return NULL if the bundle doesn’t exist at bundleURL (see Discussion). 
Discussion

Once a bundle has been created, it is cached; the bundle cache is flushed only periodically. CFBundleCreate does not check that a cached bundle still exists in the filesystem. If a bundle is deleted from the filesystem, it is therefore possible for CFBundleCreate to return a cached bundle that has actually been deleted.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFBundleRef CFBundleCreate (
   CFAllocatorRef allocator,
   CFURLRef bundleURL){
//TODO
};

/*CFBundleGetFunctionPointerForName

Returns a pointer to a function in a bundle’s executable code using the function name as the search key.

void *CFBundleGetFunctionPointerForName (
   CFBundleRef bundle,
   CFStringRef functionName
);
Parameters
bundle

The bundle to examine. 
functionName

The name of the function to locate. 
Return Value

A pointer to a function in a bundle’s executable code, or NULL if functionName cannot be found. Ownership follows the Get Rule.
Discussion

Calling this function will cause the bundle’s code to be loaded if necessary. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void *CFBundleGetFunctionPointerForName (
   CFBundleRef bundle,
   CFStringRef functionName){
//TODO
};

/*CFBundleCopyExecutableURL

Returns the location of a bundle’s main executable code.

CFURLRef CFBundleCopyExecutableURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFURL object describing the location of bundle’s executable code, or NULL if none is found. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyExecutableURL (
   CFBundleRef bundle){
///TODO
};

/*CFBundleGetMainBundle

Returns an application’s main bundle.

CFBundleRef CFBundleGetMainBundle ();
Return Value

A CFBundle object representing the application’s main bundle, or NULL if it is not possible to create a bundle. Ownership follows the Get Rule.
Discussion

CFBundle creates a main bundle whenever it possibly can, even for unbundled apps. There are a few situations in which it is not possible, so you should check the return value against NULL, but this happens only in exceptional circumstances.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFBundleRef CFBundleGetMainBundle (){
//TODO
};

/*CFSTR

Creates an immutable string from a constant compile-time string.

CFStringRef CFSTR (
   const char *cStr
);
Parameters
cStr

A C string (that is, text enclosed in double-quotation marks) from which the string is to be created. The characters enclosed by the quotation marks must be ASCII characters, otherwise the behavior is undefined.
Return Value

An immutable string, or NULL if there was a problem creating the object. The returned object is a constant. You may retain and release it, similar to other immutable CFString objects, but are not required to do so—it will remain valid until the program terminates.
Discussion

The CFSTR macro is a convenient way to create CFString representations of constant compile-time strings.

A value returned by CFSTR has the following semantics:
Values returned from CFSTR are not released by CFString—they are guaranteed to be valid until the program terminates. 
Values returned from CFSTR can be retained and released in a balanced fashion, like any other CFString, but you are not required to do so. 

Non-ASCII characters (that is, character codes greater than 127) are not supported. If you use them, the result is undefined. Even if using them works for you in testing, it might not work if the user selects a different language preference. 

Note that when using this macro as an initializer, you must compile using the flag -fconstant-cfstrings (see Options Controlling C Dialect).
Availability
Available in Mac OS X v10.0 and later.*/

CFStringRef CFSTR (
   const char *cStr){
//TODO
};

/*CFShow

Prints a description of a Core Foundation object.

void CFShow (
   CFTypeRef obj
);
Parameters
obj

A Core Foundation object derived from CFType. If obj is not a Core Foundation object, an assertion is raised. 
Discussion

This function is useful as a debugging aid for Core Foundation objects. Because these objects are based on opaque types, it is difficult to examine their contents directly. However, the opaque types implement description function callbacks that return descriptions of their objects. This function invokes these callbacks. 
Special Considerations

You can use CFShow in one of two general ways. If your debugger supports function calls (such as gdb does), call CFShow in the debugger:(gdb) call (void) CFShow(string)
Hello World


You can also incorporate calls to CFShow in a test version of your code to print out "snapshots" of Core Foundation objects to the console.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFString.h*/
void CFShow (
   CFTypeRef obj){
//TODO
};


/*CFURLCreateFromFSRef

Creates a URL from a given directory or file.

CFURLRef CFURLCreateFromFSRef (
   CFAllocatorRef allocator,
   const FSRef *fsRef
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
fsRef

The file or directory representing the URL. 
Return Value

A new CFURL object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateFromFSRef (
   CFAllocatorRef allocator,
   const FSRef *fsRef){
//TODO
};


/*CFURLGetFSRef

Converts a given URL to a file or directory object.

Boolean CFURLGetFSRef (
   CFURLRef url,
   FSRef *fsRef
);
Parameters
url

The CFURL object to convert to a file or directory object.
fsRef

Upon return, contains the file or directory object representing url.
Return Value

true if the conversion was successful, otherwise false.
Special Considerations

The function cannot create an FSRef object if the path specified by url contains an alias. The function can, however, traverse symbolic links.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
Boolean CFURLGetFSRef (
   CFURLRef url,
   FSRef *fsRef){
//TODO
};


/*CFURLCreateCopyAppendingPathComponent

Creates a copy of a given URL and appends a path component.

CFURLRef CFURLCreateCopyAppendingPathComponent (
   CFAllocatorRef allocator,
   CFURLRef url,
   CFStringRef pathComponent,
   Boolean isDirectory
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
url

The CFURL object to which to append a path component. 
pathComponent

The path component to append to url. 
isDirectory

A Boolean value that specifies whether the string is treated as a directory path when resolving against relative path components. Pass true if the new component indicates a directory, false otherwise. 
Return Value

A copy of url appended with pathComponent. Ownership follows the Create Rule.
Discussion

The isDirectory argument specifies whether or not the new path component points to a file or a to directory. Note that the URL syntax for a directory and for a file at otherwise the same location are slightly different—directory URLs must end in “/”. If you have the URL http://www.apple.com/foo/ and you append the path component bar, then if isDirectory is YES then the resulting URL is http://www.apple.com/foo/bar/, whereas if isDirectory is NO then the resulting URL is http://www.apple.com/foo/bar. This difference is particularly important if you resolve another URL against this new URL. file.html relative to http://www.apple.com/foo/bar is http://www.apple.com/foo/file.html, whereas file.html relative to http://www.apple.com/foo/bar/ is http://www.apple.com/foo/bar/file.html.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateCopyAppendingPathComponent (
   CFAllocatorRef allocator,
   CFURLRef url,
   CFStringRef pathComponent,
   Boolean isDirectory){
//TODO
};


/*CFStringHasPrefix

Determines if the character data of a string begin with a specified sequence of characters.

Boolean CFStringHasPrefix (
   CFStringRef theString,
   CFStringRef prefix
);
Parameters
theString

The string to search. 
prefix

The prefix to search for.
Return Value

true if theString begins with prefix, false if otherwise. 
Availability
Available in Mac OS X v10.0 and later.*/
Boolean CFStringHasPrefix (
   CFStringRef theString,
   CFStringRef prefix){
//TODO
};


/*CFStringGetBytes

Fetches a range of the characters from a string into a byte buffer after converting the characters to a specified encoding.

CFIndex CFStringGetBytes (
   CFStringRef theString,
   CFRange range,
   CFStringEncoding encoding,
   UInt8 lossByte,
   Boolean isExternalRepresentation,
   UInt8 *buffer,
   CFIndex maxBufLen,
   CFIndex *usedBufLen
);
Parameters
theString

The string upon which to operate. 
range

The range of characters in theString to process. The specified range must not exceed the length of the string.
encoding

The string encoding of the characters to copy to the byte buffer. 
lossByte

A character (for example, '?') that should be substituted for characters that cannot be converted to the specified encoding. Pass 0 if you do not want lossy conversion to occur. 
isExternalRepresentation

true if you want the result to be in an “external representation” format. In such a format, it may contain a byte order marker (BOM) specifying endianness and this function might have to perform byte swapping. 
buffer

The byte buffer into which the converted characters are written. The buffer can be allocated on the heap or stack. Pass NULL if you do not want conversion to take place but instead want to know if conversion will succeed (the function result is greater than 0) and, if so, how many bytes are required (usedBufLen).
maxBufLen

The size of buffer and the maximum number of bytes that can be written to it. 
usedBufLen

On return, the number of converted bytes actually in buffer. You may pass NULL if you are not interested in this information.
Return Value

The number of characters converted. 
Discussion

This function is the basic encoding-conversion function for CFString objects. As with the other functions that get the character contents of CFString objects, it allows conversion to a supported 8-bit encoding. Unlike most of those other functions, it also allows “lossy conversion.” The function permits the specification of a “loss byte” in a parameter; if a character cannot be converted this character is substituted and conversion proceeds. (With the other functions, conversion stops at the first error and the operation fails.)

Because this function takes a range and returns the number of characters converted, it can be called repeatedly with a small fixed size buffer and different ranges of the string to do the conversion incrementally.

This function also handles any necessary manipulation of character data in an “external representation” format. This format makes the data portable and persistent (disk-writable); in Unicode it often includes a BOM (byte order marker) that specifies the endianness of the data.

The CFStringCreateExternalRepresentation function also handles external representations and performs lossy conversions. The complementary function CFStringCreateWithBytes creates a string from the characters in a byte buffer.
Availability
Available in Mac OS X v10.0 and later.*/
CFIndex CFStringGetBytes (
   CFStringRef theString,
   CFRange range,
   CFStringEncoding encoding,
   UInt8 lossByte,
   Boolean isExternalRepresentation,
   UInt8 *buffer,
   CFIndex maxBufLen,
   CFIndex *usedBufLen){
//TODO
};

/*CFStringGetLength

Returns the number (in terms of UTF-16 code pairs) of characters in a string.

CFIndex CFStringGetLength (
   CFStringRef theString
);
Parameters
theString

The string to examine. 
Return Value

The number (in terms of UTF-16 code pairs) of characters stored in theString. 
Availability
Available in Mac OS X v10.0 and later.*/
CFIndex CFStringGetLength (
   CFStringRef theString){
//TODO
};


/*CFDictionarySetValue

Sets the value corresponding to a given key.

void CFDictionarySetValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);
Parameters
theDict

The dictionary to modify. If this parameter is a fixed-capacity dictionary and it is full before this operation, and the key does not exist in the dictionary, the behavior is undefined. 
key

The key of the value to set in theDict. If a key which matches key is already present in the dictionary, only the value for the key is changed ("add if absent, replace if present"). If no key matches key, the key-value pair is added to the dictionary.

If a key-value pair is added, both key and value are retained by the dictionary, using the retain callback provided when theDict was created. key must be of the type expected by the key retain callback. 
value

The value to add to or replace in theDict. value is retained using the value retain callback provided when theDict was created, and the previous value if any is released. value must be of the type expected by the retain and release callbacks.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDictionarySetValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value){
//TODO
};

/*CFStringGetCString

Copies the character contents of a string to a local C string buffer after converting the characters to a given encoding.

Boolean CFStringGetCString (
   CFStringRef theString,
   char *buffer,
   CFIndex bufferSize,
   CFStringEncoding encoding
);
Parameters
theString

The string whose contents you wish to access. 
buffer

The C string buffer into which to copy the string. The buffer must be at least bufferSize bytes in length. On return, the buffer contains the converted characters. If there is an error in conversion, the buffer contains only partial results.
bufferSize

The length of the local buffer in bytes (accounting for the NULL-terminator byte). 
encoding

The string encoding to which the character contents of theString should be converted. 
Return Value

true upon success or false if the conversion fails or the provided buffer is too small. 
Discussion

This function is useful when you need your own copy of a strings character data as a C string. You also typically call it as a backup when a prior call to the CFStringGetCStringPtr function fails. 
Availability
Available in Mac OS X v10.0 and later.*/
Boolean CFStringGetCString (
   CFStringRef theString,
   char *buffer,
   CFIndex bufferSize,
   CFStringEncoding encoding){
//TODO
};


/*CFStringCreateWithCString

Creates an immutable string from a C string.

CFStringRef CFStringCreateWithCString (
   CFAllocatorRef alloc,
   const char *cStr,
   CFStringEncoding encoding
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator.
cStr

The NULL-terminated C string to be used to create the CFString object.
encoding

The encoding of the characters in the C string. 
Return Value

An immutable string containing cStr (after stripping off the NULL terminating character), or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

A C string is a string of 8-bit characters terminated with an 8-bit NULL. Unichar and Unichar32 are not considered C strings.
Availability
Available in Mac OS X v10.0 and later.*/
CFStringRef CFStringCreateWithCString (
   CFAllocatorRef alloc,
   const char *cStr,
   CFStringEncoding encoding){
//TODO
};

/*CFBundleGetVersionNumber

Returns a bundle’s version number.

UInt32 CFBundleGetVersionNumber (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. The bundle’s version number can be number or a string of the standard form “2.5.3d5”. 
Return Value

A Mac OS vers resource style version number. If the bundle’s version number is a number, it is interpreted as the unsigned long integer format defined by the vers resource on Mac OS 9. If it is a string, it is automatically converted to the numeric representation, where the major version number is restricted to 2 BCD digits (in other words, it must be in the range 0-99) and the minor and bug fix version numbers are each restricted to a single BCD digit (0-9). See Technical Note TN1132 for more details.
Discussion

This function is only supported for the Mac OS vers resource style version numbers. Where other version number styles—namely X, or X.Y, or X.Y.Z—are used, you can use CFBundleGetValueForInfoDictionaryKey with the key kCFBundleVersionKey to extract the version number as a string from the bundle’s information dictionary.

Some version numbers of the form X, X.Y, and X.Y.Z may work with this function, if X <= 99, Y <= 9, and Z <= 9. Thus a version number 76.5.4 will work, but 76.12 will not work.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
UInt32 CFBundleGetVersionNumber (
   CFBundleRef bundle){
//TODO
};

/*CFStringCreateArrayBySeparatingStrings

Creates an array of CFString objects from a single CFString object.

CFArrayRef CFStringCreateArrayBySeparatingStrings (
   CFAllocatorRef alloc,
   CFStringRef theString,
   CFStringRef separatorString
);
Parameters
alloc

The allocator to use to allocate memory for the new CFArray object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
theString

The string to be divided into substrings. The substrings should be separated by separatorString. 
separatorString

A string containing the character or characters used to separate the substrings in theString.
Return Value



/*CFDataGetBytes

Copies the byte contents of a CFData object to an external buffer.

void CFDataGetBytes (
   CFDataRef theData,
   CFRange range,
   UInt8 *buffer
);
Parameters
theData

The CFData object to examine. 
range

The range of bytes in theData to get. To get all of the contents, pass CFRangeMake(0,CFDataGetLength(theData)). 
buffer

A pointer to the byte buffer of length range.length that is allocated on the stack or heap. On return, the buffer contains the requested range of bytes. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDataGetBytes (
   CFDataRef theData,
   CFRange range,
   UInt8 *buffer){
//TODO
};

/*A new array that contains CFString objects that represent substrings of theString, or NULL if there was a problem creating the object. The order of elements in the array is identical to the order of the substrings in theString. If separatorString does not occur in theString, the result is an array containing theString. If separatorString is equal to theString, then the result is an array containing two empty strings. Ownership follows the Create Rule.
Discussion

This function provides a convenient way to convert units of data captured in a single string to a form (an array) suitable for iterative processing. One or more delimiter characters (or “separator string”) separates the substrings in the source string—these characters are frequently whitespace characters such as tabs and newlines (carriage returns). For example, you might have a file containing a localized list of place names with each name separated by a tab character. You could create a CFString object from this file and call this function on the string to obtain a CFArray object whose elements are these place names.

See also CFStringCreateByCombiningStrings. 
Availability
Available in Mac OS X v10.0 and later.*/

CFArrayRef CFStringCreateArrayBySeparatingStrings (
   CFAllocatorRef alloc,
   CFStringRef theString,
   CFStringRef separatorString){
//TODO
};



/*CFArrayGetValueAtIndex

Retrieves a value at a given index.

const void *CFArrayGetValueAtIndex (
   CFArrayRef theArray,
   CFIndex idx
);
Parameters
theArray

The array to examine. 
idx

The index of the value to retrieve. If the index is outside the index space of theArray (0 to N-1 inclusive (where N is the count of theArray), the behavior is undefined. 
Return Value

The value at the idx index in theArray. If the return value is a Core Foundation Object, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
const void *CFArrayGetValueAtIndex (
   CFArrayRef theArray,
   CFIndex idx){
//TODO
};

/*CFDataGetLength

Returns the number of bytes contained by a CFData object.

CFIndex CFDataGetLength (
   CFDataRef theData
);
Parameters
theData

The CFData object to examine. 
Return Value

An index that specifies the number of bytes in theData. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFDataGetLength (
   CFDataRef theData){
//TODO
};

/*CFPreferencesCopyAppValue

Obtains a preference value for the specified key and application.

CFPropertyListRef CFPreferencesCopyAppValue (
   CFStringRef key,
   CFStringRef applicationID
);
Parameters
key

The preference key whose value to obtain. 
applicationID

The identifier of the application whose preferences to search, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, com.foosoft.
Return Value

The preference data for the specified key and application. The data is returned as a Core Foundation Property List data type. Use the function CFGetTypeID to determine the values type. If no value was located, returns NULL. Ownership follows the Create Rule.
Discussion

Note that values returned from this function are immutable, even if you have recently set the value using a mutable object.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFPropertyListRef CFPreferencesCopyAppValue (
   CFStringRef key,
   CFStringRef applicationID){
//TODO
};


/*CFPreferencesAppSynchronize

Writes to permanent storage all pending changes to the preference data for the application, and reads the latest preference data from permanent storage.

Boolean CFPreferencesAppSynchronize (
   CFStringRef applicationID
);
Parameters
applicationID

The ID of the application whose preferences to write to storage, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, com.foosoft.
Return Value

true if synchronization was successful, otherwise false. 
Discussion

Calling the function CFPreferencesSetAppValue is not in itself sufficient for storing preferences. The CFPreferencesAppSynchronize function writes to permanent storage all pending preference changes for the application. Typically you would call this function after multiple calls to CFPreferencesSetAppValue. Conversely, preference data is cached after it is first read. Changes made externally are not automatically incorporated. The CFPreferencesAppSynchronize function reads the latest preferences from permanent storage.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFPreferencesAppSynchronize (
   CFStringRef applicationID){
//TODO
};


/*CFPreferencesSetAppValue

Adds, modifies, or removes a preference.

void CFPreferencesSetAppValue (
   CFStringRef key,
   CFPropertyListRef value,
   CFStringRef applicationID
);
Parameters
key

The preference key whose value you wish to set. 
value

The value to set for the specified key and application. Pass NULL to remove the specified key from the applications preferences. 
applicationID

The ID of the application whose preferences you wish to create or modify, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, com.foosoft.
Discussion

New preference values are stored in the standard application preference location, ~/Library/Preferences/. When called with kCFPreferencesCurrentApplication, modifications are performed in the preference domain Current User, Current Application, Any Host. If you need to create preferences in some other domain, use the low-level function CFPreferencesSetValue.

You must call the CFPreferencesAppSynchronize function in order for your changes to be saved to permanent storage. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFPreferencesSetAppValue (
   CFStringRef key,
   CFPropertyListRef value,
   CFStringRef applicationID){
//TODO
};

/*CFStringAppend

Appends the characters of a string to those of a CFMutableString object.

void CFStringAppend (
   CFMutableStringRef theString,
   CFStringRef appendedString
);
Parameters
theString

The string to which appendedString is appended. If theString is not a CFMutableString object, an assertion is raised.
appendedString

The string to append. 
Discussion

This function reallocates the backing store of theString to accommodate the new length.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringAppend (
   CFMutableStringRef theString,
   CFStringRef appendedString){
//TODO
};


/*CFStringReplaceAll

Replaces all characters of a CFMutableString object with other characters.

void CFStringReplaceAll (
   CFMutableStringRef theString,
   CFStringRef replacement
);
Parameters
theString

The string to modify. If this value is not a CFMutableString object, an assertion is raised. 
replacement

The replacement string to put into theString.
Discussion

The character buffer of theString is resized according to the length of the new characters.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringReplaceAll (
   CFMutableStringRef theString,
   CFStringRef replacement){
//TODO
};


/*CFStringCreateMutable

Creates an empty CFMutableString object.

CFMutableStringRef CFStringCreateMutable (
   CFAllocatorRef alloc,
   CFIndex maxLength
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
maxLength

The maximum number of Unicode characters that can be stored by the returned string. Pass 0 if there should be no character limit. Note that initially the string still has a length of 0; this parameter simply specifies what the maximum size is. CFMutableString might try to optimize its internal storage by paying attention to this value. 
Return Value

A new empty CFMutableString object or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function creates an empty (that is, content-less) CFMutableString object. You can add character data to this object with any of the CFStringAppend... functions, and thereafter you can insert, delete, replace, pad, and trim characters with the appropriate CFString functions. If the maxLength parameter is greater than 0, any attempt to add characters beyond this limit results in a run-time error. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableStringRef CFStringCreateMutable (
   CFAllocatorRef alloc,
   CFIndex maxLength){
//TODO
};


/*CFStringCompare

Compares one string with another string.

CFComparisonResult CFStringCompare (
   CFStringRef theString1,
   CFStringRef theString2,
   CFOptionFlags compareOptions
);
Parameters
theString1

The first string to use in the comparison. 
theString2

The second string to use in the comparison.
compareOptions

Flags that select different types of comparisons, such as localized comparison, case-insensitive comparison, and non-literal comparison. If you want the default comparison behavior, pass 0. See String Comparison Flags for the available flags.
Return Value

A CFComparisonResult value that indicates whether theString1 is equal to, less than, or greater than theString2. 
Discussion

You can affect how the comparison proceeds by specifying one or more option flags in compareOptions. Not all comparison options are currently implemented. 
Availability
Available in Mac OS X v10.0 and later.*/
CFComparisonResult CFStringCompare (
   CFStringRef theString1,
   CFStringRef theString2,
   CFOptionFlags compareOptions){
//TODO
};


/*CFStringGetSystemEncoding

Returns the default encoding used by the operating system when it creates strings.

CFStringEncoding CFStringGetSystemEncoding ();
Return Value

The default string encoding. 
Discussion

This function returns the default text encoding used by the OS when it creates strings. In Mac OS X, this encoding is determined by the user's preferred language setting. The preferred language is the first language listed in the International pane of the System Preferences.

In most situations you will not want to use this function, however, because your primary interest will be your application's default text encoding. The application encoding is required when you create a CFStringRef from strings stored in Resource Manager resources, which typically use one of the Mac encodings such as MacRoman or MacJapanese.

To get your application's default text encoding, call the GetApplicationTextEncoding Carbon function.
Availability
Available in Mac OS X v10.0 and later.*/
CFStringEncoding CFStringGetSystemEncoding (){
//TODO
};

/*CFStringCreateMutableCopy

Creates a mutable copy of a string.

CFMutableStringRef CFStringCreateMutableCopy (
   CFAllocatorRef alloc,
   CFIndex maxLength,
   CFStringRef theString
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
maxLength

The maximum number of Unicode characters that can be stored by the returned object. Pass 0 if there should be no character limit. Note that initially the returned object still has the same length as the string argument; this parameter simply specifies what the maximum size is. CFString might try to optimize its internal storage by paying attention to this value. 
theString

A string to copy. 
Return Value

A string that has the same contents as theString. Returns NULL if there was a problem copying the object. Ownership follows the Create Rule.
Discussion

The returned mutable string is identical to the original string except for (perhaps) the mutability attribute. You can add character data to the returned string with any of the CFStringAppend... functions, and you can insert, delete, replace, pad, and trim characters with the appropriate CFString functions. If the maxLength parameter is greater than 0, any attempt to add characters beyond this limit results in a run-time error. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/CFMutableStringRef CFStringCreateMutableCopy (
   CFAllocatorRef alloc,
   CFIndex maxLength,
   CFStringRef theString){
//TODO
};


/*CFStringInsert

Inserts a string at a specified location in the character buffer of a CFMutableString object.

void CFStringInsert (
   CFMutableStringRef str,
   CFIndex index,
   CFStringRef insertedStr
);
Parameters
str

The string to be modified. If this value is not a CFMutableString object, an assertion is raised. 
index

The index of the character in str after which the new characters are to be inserted. If the index is out of bounds, an assertion is raised. 
insertedStr

The string to insert into str. 
Discussion

To accommodate the new characters, this function moves any existing characters to the right of the inserted characters the appropriate number of positions. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringInsert (
   CFMutableStringRef str,
   CFIndex index,
   CFStringRef insertedStr){
//TODO
};

/*CFDataCreate

Creates an immutable CFData object using data copied from a specified byte buffer.

CFDataRef CFDataCreate (
   CFAllocatorRef allocator,
   const UInt8 *bytes,
   CFIndex length
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
bytes

A pointer to the byte buffer that contains the raw data to be copied into theData. 
length

The number of bytes in the buffer (bytes). 
Return Value

A new CFData object, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

You must supply a count of the bytes in the buffer. This function always copies the bytes in the provided buffer into internal storage. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDataRef CFDataCreate (
   CFAllocatorRef allocator,
   const UInt8 *bytes,
   CFIndex length){
//TODO
};

/*CFStringGetCStringPtr

Quickly obtains a pointer to a C-string buffer containing the characters of a string in a given encoding.

const char *CFStringGetCStringPtr (
   CFStringRef theString,
   CFStringEncoding encoding
);
Parameters
theString

The string whose contents you wish to access. 
encoding

The string encoding to which the character contents of theString should be converted. 
Return Value

A pointer to a C string or NULL if the internal storage of theString does not allow this to be returned efficiently. 
Discussion

This function either returns the requested pointer immediately, with no memory allocations and no copying, in constant time, or returns NULL. If the latter is the result, call an alternative function such as the CFStringGetCString function to extract the characters.

Whether or not this function returns a valid pointer or NULL depends on many factors, all of which depend on how the string was created and its properties. In addition, the function result might change between different releases and on different platforms. So do not count on receiving a non-NULL result from this function under any circumstances. 
Availability
Available in Mac OS X v10.0 and later.*/
const char *CFStringGetCStringPtr (
   CFStringRef theString,
   CFStringEncoding encoding){
//TODO
};

/*CFURLCopyPath

Returns the path portion of a given URL.

CFStringRef CFURLCopyPath (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to examine. 
Return Value

The path of anURL, or NULL if the URL cannot be decomposed (doesn't conform to RFC 1808). Ownership follows the Create Rule.
Discussion

This function does not resolve the URL against its base and replaces all percent escape sequences. This function's return value includes any leading slash (giving the path the normal POSIX appearance), if present. If this behavior is not appropriate, use CFURLCopyStrictPath whose return value omits any leading slash. You may also want to use the function CFURLCopyFileSystemPath, which returns the URL's path as a file system path for the given path style. If the path is to be passed to file system calls, you may also want to use the function CFURLGetFileSystemRepresentation, which returns a C string.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCopyPath (
   CFURLRef anURL){
//TODO
};


/*CFArrayAppendValue

Adds a value to an array giving it the new largest index.

void CFArrayAppendValue (
   CFMutableArrayRef theArray,
   const void *value
);
Parameters
theArray

The array to which value is to be added. If theArray is a limited-capacity array and it is full before this operation, the behavior is undefined. 
value

A CFType object or a pointer value to add to theArray. 
Discussion

The value parameter is retained by theArray using the retain callback provided when theArray was created. If value is not of the type expected by the retain callback, the behavior is undefined. The value parameter is assigned to the index one larger than the previous largest index and the count of theArray is increased by one.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayAppendValue (CFMutableArrayRef theArray,const void *value){
//TODO
};

/*CFArrayGetCount

Returns the number of values currently in an array.

CFIndex CFArrayGetCount (
   CFArrayRef theArray
);
Parameters
theArray

The array to examine. 
Return Value

The number of values in theArray. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later*/
CFIndex CFArrayGetCount ( CFArrayRef theArray){
//TODO
};

/*CFArrayCreateMutable

Creates a new empty mutable array.

CFMutableArrayRef CFArrayCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFArrayCallBacks *callBacks
);
Parameters
allocator

The allocator to use to allocate memory for the new array and its storage for values. Pass NULL or kCFAllocatorDefault to use the current default allocator.
capacity

The maximum number of values that can be contained by the new array. The array starts empty and can grow to this number of values (and it can have less). If this parameter is 0, the array’s maximum capacity is not limited. The value must not be negative. 
callBacks

A pointer to a CFArrayCallBacks structure initialized with the callbacks for the array to use on each value in the array. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple array creations. This parameter may be NULL, which is treated as if a valid structure of version 0 with all fields NULL had been passed in. 

If any of the fields are not valid pointers to functions of the correct type, or this parameter is not a valid pointer to a CFArrayCallBacks structure, the behavior is undefined. If any value put into the array is not one understood by one of the callback functions, the behavior when that callback function is used is undefined. If the array contains CFType objects only, then pass kCFTypeArrayCallBacks as this parameter to use the default callback functions.
Return Value

A new mutable array, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableArrayRef CFArrayCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFArrayCallBacks *callBacks){
//TODO
};

/*CFStringGetMaximumSizeForEncoding

Returns the maximum number of bytes a string of a specified length (in Unicode characters) will take up if encoded in a specified encoding.

CFIndex CFStringGetMaximumSizeForEncoding (
   CFIndex length,
   CFStringEncoding encoding
);
Parameters
length

The number of Unicode characters to evaluate. 
encoding

The string encoding for the number of characters specified by length. 
Return Value

The maximum number of bytes that could be required to represent length number of Unicode characters with the string encoding encoding. The number of bytes that the encoding actually ends up requiring when converting any particular string could be less than this, but never more.
Availability
Available in Mac OS X v10.0 and later.*/
CFIndex CFStringGetMaximumSizeForEncoding (
   CFIndex length,
   CFStringEncoding encoding){
//TODO
};

/*CFStringAppendCString

Appends a C string to the character contents of a CFMutableString object.

void CFStringAppendCString (
   CFMutableStringRef theString,
   const char *cStr,
   CFStringEncoding encoding
);
Parameters
theString

The string to which the characters from cStr are appended. If this value is not a CFMutableString object, an assertion is raised. 
cStr

A pointer to a C string buffer.
encoding

The encoding of the characters in cStr. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringAppendCString (
   CFMutableStringRef theString,
   const char *cStr,
   CFStringEncoding encoding){
//TODO
};

/*CFStringFindAndReplace

Replaces all occurrences of a substring within a given range.

CFIndex CFStringFindAndReplace (
   CFMutableStringRef theString,
   CFStringRef stringToFind,
   CFStringRef replacementString,
   CFRange rangeToSearch,
   CFOptionFlags compareOptions
);
Parameters
theString

The string to modify. 
stringToFind

The substring to search for in theString.
replacementString

The replacement string for stringToFind. 
rangeToSearch

The range within which to search in theString. 
compareOptions

Flags that select different types of comparisons, such as localized comparison, case-insensitive comparison, and non-literal comparison. If you want the default comparison behavior, pass 0. See “String Comparison Flags” for the available flags.
Return Value

The number of instances of stringToFind that were replaced. 
Discussion

The possible values of compareOptions are combinations of the kCFCompareCaseInsensitive, kCFCompareBackwards, kCFCompareNonliteral, and kCFCompareAnchored constants. 

The kCFCompareBackwards option can be used to replace a substring starting from the end, which could produce different results. For example, if the parameter theString is “AAAAA”, stringToFind is “AA”, and replacementString is “B”, then the result is normally “BBA”. However, if the kCFCompareBackwards constant is used, the result is “ABB.” 

The kCFCompareAnchored option assures that only anchored but multiple instances are found (the instances must be consecutive at start or end). For example, if the parameter theString is “AAXAA”, stringToFind is “A”, and replacementString is “B”, then the result is normally “BBXBB.” However, if the kCFCompareAnchored constant is used, the result is “BBXAA.”
Availability
Available in Mac OS X v10.2 and later.*/
CFIndex CFStringFindAndReplace (
   CFMutableStringRef theString,
   CFStringRef stringToFind,
   CFStringRef replacementString,
   CFRange rangeToSearch,
   CFOptionFlags compareOptions){
//TODO
};

/*CFRunLoopRun

Runs the current thread’s CFRunLoop object in its default mode indefinitely.

void CFRunLoopRun ();
Discussion

The current thread’s run loop runs in the default mode (see "Default Run Loop Mode") until the run loop is stopped with CFRunLoopStop or all the sources and timers are removed from the default run loop mode.

Run loops can be run recursively. You can call CFRunLoopRun from within any run loop callout and create nested run loop activations on the current thread’s call stack.
Availability
Available in Mac OS X v10.0 and later.*/
void CFRunLoopRun (){
//TODO
};

/*CFRunLoopAddSource

Adds a CFRunLoopSource object to a run loop mode.

void CFRunLoopAddSource (
   CFRunLoopRef rl,
   CFRunLoopSourceRef source,
   CFStringRef mode
);
Parameters
rl

The run loop to modify. 
source

The run loop source to add. 
mode

The run loop mode to which to add source. Use the constant kCFRunLoopCommonModes to add source to the set of objects monitored by all the common modes. 
Discussion

If source is a version 0 source, this function calls the schedule callback function specified in the context structure for source. See CFRunLoopSourceContext for more details.

A run loop source can be registered in multiple run loops and run loop modes at the same time. When the source is signaled, whichever run loop that happens to detect the signal first will fire the source.

If rl already contains source in mode, this function does nothing.
Availability
Available in Mac OS X v10.0 and later.*/
void CFRunLoopAddSource (
   CFRunLoopRef rl,
   CFRunLoopSourceRef source,
   CFStringRef mode){
//TODO
};

/*CFRunLoopGetCurrent

Returns the CFRunLoop object for the current thread.

CFRunLoopRef CFRunLoopGetCurrent ();
Return Value

Current thread’s run loop. Ownership follows the Get Rule.
Discussion

Each thread has exactly one run loop associated with it.
Availability
Available in Mac OS X v10.0 and later.*/
CFRunLoopRef CFRunLoopGetCurrent (){
//TODO
};
/*CFRunLoopSourceCreate

Creates a CFRunLoopSource object.

CFRunLoopSourceRef CFRunLoopSourceCreate (
   CFAllocatorRef allocator,
   CFIndex order,
   CFRunLoopSourceContext *context
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
order

A priority index indicating the order in which run loop sources are processed. When multiple run loop sources are firing in a single pass through the run loop, the sources are processed in increasing order of this parameter. If the run loop is set to process only one source per loop, only the highest priority source, the one with the lowest order value, is processed. This value is ignored for version 1 sources. Pass 0 unless there is a reason to do otherwise.
context

A structure holding contextual information for the run loop source. The function copies the information out of the structure, so the memory pointed to by context does not need to persist beyond the function call.
Return Value

The new CFRunLoopSource object. You are responsible for releasing this object.
Discussion

The run loop source is not automatically added to a run loop. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFRunLoopSourceRef CFRunLoopSourceCreate (
   CFAllocatorRef allocator,
   CFIndex order,
   CFRunLoopSourceContext *context){
//TODO
};

/*CFURLGetFileSystemRepresentation

Fills a buffer with the file system's native string representation of a given URL's path.

Boolean CFURLGetFileSystemRepresentation (
   CFURLRef url,
   Boolean resolveAgainstBase,
   UInt8 *buffer,
   CFIndex maxBufLen
);
Parameters
url

The CFURL object whose native file system representation you want to obtain. 
resolveAgainstBase

Pass true to return an absolute path name. 
buffer

A pointer to a character buffer. On return, the buffer holds the native file system's representation of url. The buffer is null-terminated. This parameter must be at least maxBufLen in size for the file system in question to avoid failures for insufficiently large buffers.
maxBufLen

The maximum number of characters that can be written to buffer.
Return Value

true if successful, false if an error occurred. 
Discussion

No more than maxBufLen bytes are written to buffer. If url requires more than maxBufLen bytes to represent itself, including the terminating null byte, this function returns false. To avoid this possible failure, you should pass a buffer with size of at least the maximum path length for the file system in question.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
Boolean CFURLGetFileSystemRepresentation (
   CFURLRef url,
   Boolean resolveAgainstBase,
   UInt8 *buffer,
   CFIndex maxBufLen){
//TODO
};

/*CFBundleCopyBundleURL

Returns the location of a bundle.

CFURLRef CFBundleCopyBundleURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFURL object describing the location of bundle, or NULL if the specified bundle does not exist. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyBundleURL (
   CFBundleRef bundle){
//TODO
};

/*CFBundleGetBundleWithIdentifier

Locate a bundle given its program-defined identifier.

CFBundleRef CFBundleGetBundleWithIdentifier (
   CFStringRef bundleID
);
Parameters
bundleID

The identifier of the bundle to locate. Note that identifier names are case-sensitive.
Return Value

A CFBundle object, or NULL if the bundle was not found. Ownership follows the Get Rule.
Discussion

For a bundle to be located using its identifier, the bundle object must have already been created. The principal intended purpose for locating bundles by identifier is so that code (in frameworks, plugins, etc.) can find its own bundle. If a bundle is created, then the bundle deleted from the filesystem and this function invoked afterwards, it will still return the original bundle.

Bundle identifiers are created by entering a value for the key CFBundleIdentifier in the bundle’s Info.plist file. 

To guarantee uniqueness, bundle identifiers take the form of Java style package names, such as com.myCompany.foo.bar.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFBundleRef CFBundleGetBundleWithIdentifier (
   CFStringRef bundleID){
//TODO
};


/*CGRectIsInfinite

Checks whether a rectangle is infinite.

bool CGRectIsInfinite (
   CGRect rect
);
Parameters
rect

The rectangle to examine.
Return Value

Returns true if the specified rectangle is infinite, false otherwise.
Discussion

An infinite rectangle is one that has no defined bounds. Infinite rectangles can be created as output from a tiling filter. For example, the Core Image framework perspective tile filter creates an image whose extent is described by an infinite rectangle.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGGeometry.h*/
bool CGRectIsInfinite (
   CGRect rect){
//TODO
};


/*CFBooleanGetValue

Returns the value of a CFBoolean object as a standard C type Boolean.

Boolean CFBooleanGetValue (
   CFBooleanRef boolean
);
Parameters
boolean

The boolean to examine. 
Return Value

The value of boolean. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFBooleanGetValue (
   CFBooleanRef boolean){
//TODO
};


/*CFStringCreateWithCharacters

Creates a string from a buffer of Unicode characters.

CFStringRef CFStringCreateWithCharacters (
   CFAllocatorRef alloc,
   const UniChar *chars,
   CFIndex numChars
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
chars

The buffer of Unicode characters to copy into the new string. 
numChars

The number of characters in the buffer pointed to by chars. Only this number of characters will be copied to internal storage. 
Return Value

An immutable string containing chars, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function creates an immutable string from a client-supplied Unicode buffer. You must supply a count of the characters in the buffer. This function always copies the characters in the provided buffer into internal storage.

To save memory, this function might choose to store the characters internally in a 8-bit backing store. That is, just because a buffer of UniChar characters was used to initialize the object does not mean you will get back a non-NULL result from CFStringGetCharactersPtr. 
Availability
Available in Mac OS X v10.0 and later.*/
CFStringRef CFStringCreateWithCharacters (
   CFAllocatorRef alloc,
   const UniChar *chars,
   CFIndex numChars){
//TODO
};


/*CFUUIDGetUUIDBytes

Returns the value of a UUID object as raw bytes.

CFUUIDBytes CFUUIDGetUUIDBytes (
   CFUUIDRef uuid
);
Parameters
uuid

The CFUUID object to examine. 
Return Value

The value of uuid represented as raw bytes. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFUUIDBytes CFUUIDGetUUIDBytes (
   CFUUIDRef uuid){
//TODO
};


/*CFNumberCreate

Creates a CFNumber object using a specified value.

CFNumberRef CFNumberCreate (
   CFAllocatorRef allocator,
   CFNumberType theType,
   const void *valuePtr
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the default allocator.
theType

A constant that specifies the data type of the value to convert. See Number Types for a list of possible values. 
valuePtr

A pointer to the value for the returned number object.
Return Value

A new number with the value specified by valuePtr. Ownership follows the Create Rule.
Discussion

The theType parameter is not necessarily preserved when creating a new CFNumber object. The CFNumber object will be created using whatever internal storage type the creation function deems appropriate. Use the function CFNumberGetType to find out what type the CFNumber object used to store your value. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFNumberRef CFNumberCreate (
   CFAllocatorRef allocator,
   CFNumberType theType,
   const void *valuePtr){
//TODO
};


/*CFUUIDGetConstantUUIDWithBytes

Returns a CFUUID object from raw UUID bytes.

CFUUIDRef CFUUIDGetConstantUUIDWithBytes (
   CFAllocatorRef alloc,
   UInt8 byte0,
   UInt8 byte1,
   UInt8 byte2,
   UInt8 byte3,
   UInt8 byte4,
   UInt8 byte5,
   UInt8 byte6,
   UInt8 byte7,
   UInt8 byte8,
   UInt8 byte9,
   UInt8 byte10,
   UInt8 byte11,
   UInt8 byte12,
   UInt8 byte13,
   UInt8 byte14,
   UInt8 byte15
);
Parameters
alloc

The allocator to use to allocate memory for the new CFUUID object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
byte0

Raw byte number 0.
byte1

Raw byte number 1.
byte2

Raw byte number 2.
byte3

Raw byte number 3.
byte4

Raw byte number 4.
byte5

Raw byte number 5.
byte6

Raw byte number 6.
byte7

Raw byte number 7.
byte8

Raw byte number 8.
byte9

Raw byte number 9.
byte10

Raw byte number 10.
byte11

Raw byte number 11.
byte12

Raw byte number 12.
byte13

Raw byte number 13.
byte14

Raw byte number 14.
byte15

Raw byte number 15.
Return Value

A CFUUID object. Ownership follows the Get Rule.
Discussion

This function can be used in headers to declare a UUID constant with #define. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFUUIDRef CFUUIDGetConstantUUIDWithBytes (
   CFAllocatorRef alloc,
   UInt8 byte0,
   UInt8 byte1,
   UInt8 byte2,
   UInt8 byte3,
   UInt8 byte4,
   UInt8 byte5,
   UInt8 byte6,
   UInt8 byte7,
   UInt8 byte8,
   UInt8 byte9,
   UInt8 byte10,
   UInt8 byte11,
   UInt8 byte12,
   UInt8 byte13,
   UInt8 byte14,
   UInt8 byte15){
//TODO
};



/*CFStringAppendFormat

Appends a formatted string to the character contents of a CFMutableString object.

void CFStringAppendFormat (
   CFMutableStringRef theString,
   CFDictionaryRef formatOptions,
   CFStringRef format,
   ...
);
Parameters
theString

The string to which the formatted characters from format are appended. If this value is not a CFMutableString object, an assertion is raised.
formatOptions

A dictionary containing formatting options for the string (such as the thousand-separator character, which is dependent on locale). Currently, these options are an unimplemented feature. 
format

A formatted string with printf-style specifiers. 
...

Variable list of the values to be inserted in format.
Discussion

A formatted string is one with printf-style format specifiers embedded in the text such as %d (decimal), %f (double), and %@ (Core Foundation object). The subsequent arguments, in order, are substituted for the specifiers in the character data appended to theString. You can also reorder the arguments in the string by using modifiers of the form "n$" with the format specifiers (for example, %2$d).

For more information on supported specifiers, see the relevant section in “Strings”. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringAppendFormat (
   CFMutableStringRef theString,
   CFDictionaryRef formatOptions,
   CFStringRef format,
   ...
){
//TODO
};


/*CFStringCreateWithFormat

Creates an immutable string from a formatted string and a variable number of arguments.

CFStringRef CFStringCreateWithFormat (
   CFAllocatorRef alloc,
   CFDictionaryRef formatOptions,
   CFStringRef format,
   ...
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
formatOptions

A CFDictionary object containing formatting options for the string (such as the thousand-separator character, which is dependent on locale). Currently, these options are an unimplemented feature. 
format

The formatted string with printf-style specifiers. For information on supported specifiers, see String Format Specifiers.
...

Variable list of the values to be inserted in format.
Return Value

An immutable string, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/

CFStringRef CFStringCreateWithFormat (
   CFAllocatorRef alloc,
   CFDictionaryRef formatOptions,
   CFStringRef format,
   ...){
//TODO
};


/*CFSwapInt32BigToHost

Converts a 32-bit integer from big-endian format to the host’s native byte order.

uint32_t CFSwapInt32BigToHost (
   uint32_t arg
);
Parameters
arg

The integer whose bytes should be swapped.
Return Value

The integer with its bytes swapped. If the host is big-endian, this function returns arg unchanged.
Availability
Available in Mac OS X v10.0 and later.*/
uint32_t CFSwapInt32BigToHost (
   uint32_t arg){
//TODO
};


/*CFSwapInt32HostToBig

Converts a 32-bit integer from the host’s native byte order to big-endian format.

uint32_t CFSwapInt32HostToBig (
   uint32_t arg
);
Parameters
arg

The integer whose bytes should be swapped.
Return Value

The integer with its bytes swapped. If the host is big-endian, this function returns arg unchanged.
Availability
Available in Mac OS X v10.0 and later.*/

uint32_t CFSwapInt32HostToBig (
   uint32_t arg){
//TODO
};


/*CFURLCreateFromFileSystemRepresentation

Creates a new CFURL object for a file system entity using the native representation.

CFURLRef CFURLCreateFromFileSystemRepresentation (
   CFAllocatorRef allocator,
   const UInt8 *buffer,
   CFIndex bufLen,
   Boolean isDirectory
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
buffer

The character bytes to convert into a CFURL object. This should be the path as you would use in POSIX function calls.
bufLen

The number of bytes in the buffer. 
isDirectory

A Boolean value that specifies whether the string is treated as a directory path when resolving against relative path components—true if the pathname indicates a directory, false otherwise. 
Return Value

A new CFURL object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateFromFileSystemRepresentation (
   CFAllocatorRef allocator,
   const UInt8 *buffer,
   CFIndex bufLen,
   Boolean isDirectory){
//TODO
};


/*CFNotificationCenterAddObserver

Registers an observer to receive notifications.

void CFNotificationCenterAddObserver (
   CFNotificationCenterRef center,
   const void *observer,
   CFNotificationCallback callBack,
   CFStringRef name,
   const void *object,
   CFNotificationSuspensionBehavior suspensionBehavior
);
Parameters
center

The notification center to which to add the observer. 
observer

The observer. In Mac OS X v10.3 and later, this parameter may be NULL.

If the notification center is a Darwin notification center, this value must not be NULL.
callBack

The callback function to call when object posts the notification named name. 
name

The name of the notification to observe. If NULL, callback is called for any notification posted by object. 
object

The object to observe. For distributed notifications, object must be a CFString object. If NULL, callback is called when a notification named name is posted by any object.

If the notification center is a Darwin notification center, this value is ignored.
suspensionBehavior

Flag indicating how notifications should be handled when the application is in the background. See “Notification Delivery Suspension Behavior” for the list of available values.

If the notification center is a Darwin notification center, this value is ignored.
Discussion

The first time an observer is registered with a distributed notification center, the notification center creates a connection with the system-wide notification server and places a listening port into the common modes of the current thread’s run loop. When a notification is delivered, it is processed on this initial thread, even if the observer that is receiving the notification registered for the notification on a different thread.

Because loaded frameworks may potentially spawn threads and add their own observers before your code executes, you cannot know for certain which thread will receive distributed notifications. If you need to control which thread processes a notification, your callback function must be able to forward the notification to the proper thread. You can use a CFMessagePort object or a custom CFRunLoopSource object to send notifications to the correct thread’s run loop.
Availability
Available in Mac OS X v10.0 and later.*/

void CFNotificationCenterAddObserver (
   CFNotificationCenterRef center,
   const void *observer,
   CFNotificationCallback callBack,
   CFStringRef name,
   const void *object,
   CFNotificationSuspensionBehavior suspensionBehavior){
//TODO
};


/*CFNotificationCenterGetDistributedCenter

Returns the application’s distributed notification center.

CFNotificationCenterRef CFNotificationCenterGetDistributedCenter();
Return Value

The application’s distributed notification center. An application has only one distributed notification center, so this function returns the same value each time it is called. 
Discussion

A distributed notification center delivers notifications between applications. A notification object used with a distributed notification center must always be a CFString object and the notification dictionary must contain only property list values.
Availability
Available in Mac OS X v10.0 and later.*/
CFNotificationCenterRef CFNotificationCenterGetDistributedCenter(){
//TODO
};


/*CFNotificationCenterRemoveObserver

Stops an observer from receiving certain notifications.

void CFNotificationCenterRemoveObserver (
   CFNotificationCenterRef center,
   const void *observer,
   CFStringRef name,
   const void *object
);
Parameters
center

The notification center to modify. 
observer

The observer. This value must not be NULL.
name

The name of the notification to stop observing. If NULL, observer stops receiving callbacks for all notifications posted by object. 
object

The object to stop observing. For distributed notifications, object must be a CFString object. If NULL, observer stops receiving callbacks for all objects posting notifications named name.

If the notification center is a Darwin notification center, this value is ignored.
Discussion

If both name and object are NULL, this function unregisters observer from all the notifications for which it had previously registered with center.
Availability
Available in Mac OS X v10.0 and later.*/
void CFNotificationCenterRemoveObserver (
   CFNotificationCenterRef center,
   const void *observer,
   CFStringRef name,
   const void *object){
//TODO
};


/*CFArrayGetTypeID

Returns the type identifier for the CFArray opaque type.

CFTypeID CFArrayGetTypeID();
Return Value

The type identifier for the CFArray opaque type.
Discussion

CFMutableArray objects have the same type identifier as CFArray objects.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFArrayGetTypeID(){
//TODO
};


/*CFEqual

Determines whether two Core Foundation objects are considered equal.

Boolean CFEqual (
   CFTypeRef cf1,
   CFTypeRef cf2
);
Parameters
cf1

A CFType object to compare to cf2.
cf2

A CFType object to compare to cf1.
Return Value

true if cf1 and cf2 are of the same type and considered equal, otherwise false. 
Discussion

Equality is something specific to each Core Foundation opaque type. For example, two CFNumber objects are equal if the numeric values they represent are equal. Two CFString objects are equal if they represent identical sequences of characters, regardless of encoding. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFEqual (
   CFTypeRef cf1,
   CFTypeRef cf2){
//TODO
};


/*CFDictionaryGetTypeID

Returns the type identifier of all CFDictionary objects.

CFTypeID CFDictionaryGetTypeID ();
Return Value

The type identifier for the CFDictionary opaque type. 
Discussion

CFMutableDictionary objects have the same type identifier as CFDictionary objects.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFDictionaryGetTypeID (){
//TODO
};


/*CFGetTypeID

Returns the unique identifier of an opaque type to which a Core Foundation object belongs.

CFTypeID CFGetTypeID (
   CFTypeRef cf
);
Parameters
cf

The CFType object to examine. 
Return Value

A value of type CFTypeID that identifies the opaque type of cf. 
Discussion

This function returns a value that uniquely identifies the opaque type of any Core Foundation object. You can compare this value with the known CFTypeID identifier obtained with a “GetTypeID” function specific to a type, for example CFDateGetTypeID. These values might change from release to release or platform to platform.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFGetTypeID (
   CFTypeRef cf){
//TODO
};




