#ifndef ENDIAN_H
#define ENDIAN_H

#ifndef CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*wide

Stores a signed 64-bit value as a signed 32-bit integer and an unsigned 32-bit integer.

struct wide {        // big-endian version
   SInt32    hi;
   UInt32    lo;
};
struct wide {        // little-endian version
   UInt32    lo;
   SInt32    hi;
};
Fields
hi
Discussion

The signed high-order 32-bit integer.
lo
Discussion

The unsigned low-order 32-bit integer.
Programming Info
C interface file: Endian.h*/
//struct wide {        // big-endian version
//   SInt32    hi;
//   UInt32    lo;
//};
struct wide {        // little-endian version
   UInt32    lo;
   SInt32    hi;
};
typedef  struct wide wide;

#ifdef __cplusplus
}
#endif

#endif
