#ifndef MACMEMORY_H
#define MACMEMORY_H


#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef  MACTYPES_H
//#include <CarbonCore/MacTypes.h> //hys
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*DisposeHandle

Releases memory occupied by a relocatable block.

void DisposeHandle (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The DisposeHandle function releases the memory occupied by the relocatable block whose handle is h. It also frees the handles master pointer for other uses.

Do not use DisposeHandle to dispose of a handle obtained from the Resource Manager (for example, by a previous call to GetResource), use ReleaseResource instead. If, however, you have called DetachResource on a resource handle, you should dispose of the storage by calling DisposeHandle.

Call the function MemError to get the result code. See Memory Manager Result Codes.
Special Considerations

After a call to DisposeHandle, all handles to the released block become invalid and should not be used again. Any subsequent calls to DisposeHandle using an invalid handle might crash your application.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void DisposeHandle (
   Handle h
);

/*BlockZero


void BlockZero (
   void * destPtr,
   Size byteCount
);
Parameters
destPtr
byteCount
Special Considerations

Beginning in Mac OS X v10.4, the BlockZero function is inlined to a direct call to the POSIX bzero function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockZero (
   void * destPtr,
   Size byteCount
);

/*NewHandle

Allocates a new relocatable memory block of a specified size in the current heap zone.

Handle NewHandle (
   Size byteCount
);
Parameters
byteCount

The requested size, in bytes, of the relocatable block. Maximum size is 2 GB, the maximum size for variables of type Size.
Return Value

A handle to the new block. If NewHandle cannot allocate a block of the requested size, it returns NULL. 
Discussion

The NewHandle function pursues all available avenues to create a block of the requested size, including compacting the heap zone, increasing its size, and purging blocks from it. If all of these techniques fail and the heap zone has a grow-zone function installed, NewHandle calls the function. Then NewHandle tries again to free the necessary amount of memory, once more compacting and purging the heap zone if necessary. If NewHandle still cannot allocate memory, NewHandle calls the grow-zone function again, unless that function had returned 0, in which case NewHandle gives up and returns NULL.

If the NewHandle function succeeds in creating the requested block, this new block is unlocked and unpurgeable.

If you allocate a relocatable block that you plan to lock for long periods of time, you can prevent heap fragmentation by allocating the block as low as possible in the heap zone. To do this, see the description of the function ReserveMem.

If you plan to lock a relocatable block for short periods of time, you might want to move it to the top of the heap zone to prevent heap fragmentation. For more information, see the description of the function MoveHHi.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewHandle allocates memory, you should not call it at interrupt time.

Do not try to manufacture your own handles without this function by simply assigning the address of a variable of type Ptr to a variable of type Handle. The resulting “fake handle” would not reference a relocatable block and could cause a system crash. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle NewHandle (
   Size byteCount
);

/*GetHandleSize

Returns the logical size of the relocatable block corresponding to a handle.

Size GetHandleSize (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Return Value

The logical size, in bytes, of the relocatable block whose handle is h. In case of error, the function return 0. 
Discussion

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

You should not call GetHandleSize at interrupt time because the heap might be in an inconsistent state. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Size GetHandleSize (
   Handle h
);

/*BlockMove

Copies a sequence of bytes from one location in memory to another.

void BlockMove (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);
Parameters
srcPtr

The address of the first byte to copy. 
destPtr

The destination address.
byteCount

The number of bytes to copy. If the value of byteCount is 0, BlockMove does nothing. 
Discussion

The BlockMove function copies the specified number of bytes from the address designated by srcPtr to that designated by destPtr. It updates no pointers.

The BlockMove function works correctly even if the source and destination blocks overlap.

You can safely call BlockMove at interrupt time. Even though it moves memory, BlockMove does not move relocatable blocks, but simply copies bytes.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

The BlockMove function currently flushes the processor caches whenever it moves more than 12 bytes. This behavior can adversely affect your application’s performance. You might want to avoid calling BlockMove to move small amounts of data in memory if there is no possibility of moving stale data or instructions. For more information about stale data and instructions, see the discussion of the processor caches in the chapter “Memory Management Utilities” in Inside Macintosh: Memory. 
Special Considerations

Beginning in Mac OS X v10.4, the BlockMove function is inlined to a direct call to the POSIX memmove function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockMove (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);

/*BlockMoveData


void BlockMoveData (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);
Parameters
srcPtr
destPtr
byteCount
Discussion

You should not make any assumptions about the state of the destination memory while BlockMoveData is executing. In the intermediate state, values may be present that are neither the original nor the final ones. For example, this function may use the 'dcbz' instruction. If the underlying memory is not cacheable, if the memory is write-through instead of copy-back, or if the cache block is flushed for some reason, the 'dcbz' instruction will write zeros to the destination. You can avoid the use of the 'dcbz' instruction by calling BlockMoveDataUncached, but even that function makes no other guarantees about the memory block's intermediate state. 
Special Considerations

Beginning in Mac OS X v10.4, the BlockMoveData function is inlined to a direct call to the POSIX memmove function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockMoveData (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);

/*MemError

Determines if an application’s last direct call to a Memory Manager function executed successfully.

OSErr MemError (void);
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

For each thread, MemError yields the result code produced by the last Memory Manager function your application called directly.

MemError is useful during application debugging. You might also use MemError as one part of a memory-management scheme to identify instances in which the Memory Manager rejects overly large memory requests by returning the error code memFullErr.

To view the result codes that MemError can produce, see “Memory Manager Result Codes”.

Do not rely on MemError as the only component of a memory-management scheme. For example, suppose you call NewHandle or NewPtr and receive the result code noErr, indicating that the Memory Manager was able to allocate sufficient memory. In this case, you have no guarantee that the allocation did not deplete your application’s memory reserves to levels so low that simple operations might cause your application to crash. Instead of relying on MemError, check before making a memory request that there is enough memory both to fulfill the request and to support essential operations. 
Version Notes

Starting with Mac OS X v10.3, the MemError function provides error codes on a per-thread basis.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr MemError (void);

/*NewHandleClear

Allocates a relocatable block of memory of a specified size with all its bytes set to 0.

Handle NewHandleClear (
   Size byteCount
);
Parameters
byteCount

The requested size (in bytes) of the relocatable block. The NewHandleClear function sets each of these bytes to 0. 
Return Value

A handle to the new block. If NewHandleClear cannot allocate a block of the requested size, it returns NULL. 
Discussion

The NewHandleClear function works like the NewHandle function, but sets all bytes in the new block to 0 instead of leaving the contents of the block undefined.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewHandleClear allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle NewHandleClear (
   Size byteCount
);

/*PtrToHand

Copies data referenced by a pointer to a new relocatable block.

OSErr PtrToHand (
   const void * srcPtr,
   Handle * dstHndl,
   long size
);
Parameters
srcPtr

The address of the first byte to copy. 
dstHndl

A handle for which you have not yet allocated any memory. The PtrToHand function allocates memory for the handle and copies the specified number of bytes beginning at srcPtr into it. The dstHndl parameter is an output parameter that will hold the result. Its value on entry is ignored. If no error occurs, on exit it points to an unlocked, non-purgeable Handle of the requested size. 
size

The number of bytes to copy. 
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

If you dereference and lock a handle, the PtrToHand function can copy its data to a new handle. However, for copying data from one handle to another, the HandToHand function is more efficient.

Because PtrToHand allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr PtrToHand (
   const void * srcPtr,
   Handle * dstHndl,
   long size
);

/*PtrAndHand

Concatenates part or all of a memory block to the end of a relocatable block.

OSErr PtrAndHand (
   const void * ptr1,
   Handle hand2,
   long size
);
Parameters
ptr1

A pointer to the beginning of the data that the Memory Manager is to concatenate onto the end of the relocatable block. 
hand2

A handle to the relocatable block, whose size the Memory Manager expands so that it can concatenate the information from ptr1 onto the end of this block. 
size

The number of bytes of the block referenced by ptr1 to copy. 
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

The PtrAndHand function takes the number of bytes specified by the size parameter, beginning at the location specified by ptr1, and concatenates them onto the end of the relocatable block to which hand2 is a handle. The contents of the source block remain unchanged.

Because PtrAndHand allocates memory, you should not call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr PtrAndHand (
   const void * ptr1,
   Handle hand2,
   long size
);

/*HLock

Prevents a relocatable block from moving within its heap zone.

void HLock (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

If you plan to dereference a handle and then allocate, move, or purge memory (or call a function that does so), then you should lock the handle before using the dereferenced handle.

If the block is already locked, HLock does nothing.

If you plan to lock a relocatable block for long periods of time, you can prevent fragmentation by ensuring that the block is as low as possible in the heap zone. To do this, see the description of the ReserveMem function.

If you plan to lock a relocatable block for short periods of time, you can prevent heap fragmentation by moving the block to the top of the heap zone before locking. For more information, see the description of the MoveHHi function.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void HLock (
   Handle h
);

#ifdef __cplusplus
}
#endif

#endif