#ifndef TEXTUTILS_H
#define TEXTUTILS_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef NUMBERFORMATTING_H
#include <CarbonCore/NumberFormatting.h>
#endif

#ifndef STRINGCOMPARE_H
#include <CarbonCore/StringCompare.h>
#endif

#ifndef DATETIMEUTILS_H
#include <CarbonCore/DateTimeUtils.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Munger

Searches text for a specified string pattern and replaces it with another string.

long Munger (
   Handle h,
   long offset,
   const void * ptr1,
   long len1,
   const void * ptr2,
   long len2
);
Parameters
h

A handle to the text string that is being manipulated. 
offset

The byte offset in the destination string at which Munger begins its operation. 
ptr1

A pointer to the first character in the string for which Munger is searching. 
len1

The number of bytes in the string for which Munger is searching.
ptr2

A pointer to the first character in the substitution string.
len2

The number of bytes in the substitution string.
Return Value

A negative value if Munger cannot find the designated string. 
Discussion

Munger manipulates bytes in a string to which you specify a handle in the h parameter. The manipulation begins at a byte offset, specified in offset, in the string. Munger searches for the string specified by ptr1 and len1; when it finds an instance of that string, it replaces it with the substitution string, which is specified by ptr2 and len2.

Munger operates on a byte-by-byte basis, which can produce inappropriate results for 2-byte script systems. The ReplaceText function works properly for all languages. You are encouraged to use ReplaceText instead of Munger whenever possible.

Munger takes special action if either of the specified pointer values is NULL or if either of the length values is 0.
If ptr1 is NULL, Munger replaces characters without searching. It replaces len1 characters starting at the offset location with the substitution string. 
If ptr1 is NULL and len1 is negative, Munger replaces all of the characters from the offset location to the end of the string with the substitution string. 
If len1 is 0, Munger inserts the substitution string without replacing anything. Munger inserts the string at the offset location and returns the offset of the first byte past where the insertion occurred. 
If ptr2 is NULL, Munger searches but does not replace. In this case, Munger returns the offset at which the string was found. 
If len2 is 0 and ptr2 is not NULL, Munger searches and deletes. In this case, Munger returns the offset at which it deleted. 
If the portion of the string from the offset location to its end matches the beginning of the string that Munger is searching for, Munger replaces that portion with the substitution string. 

Be careful not to specify an offset with a value that is greater than the length of the destination string. Unpredictable results may occur.

Munger calls the GetHandleSize and SetHandleSize functions to access or modify the length of the string it is manipulating. 
Special Considerations

Munger may move memory; your application should not call this function at interrupt time.

The destination string must be in a relocatable block that was allocated by the Memory Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
TextUtils.h*/
long Munger (
   Handle h,
   long offset,
   const void * ptr1,
   long len1,
   const void * ptr2,
   long len2
);


#ifdef __cplusplus
}
#endif

#endif
