#ifndef CFDICTIONARY_H
#define CFDICTIONARY_H

#include <CoreFoundation/CFBase.h>

 
#include <ETC/CoreFoundation/CFDictionary.h>

#if defined(__cplusplus)
extern "C" {
#endif


/*CFDictionaryHashCallBack

Prototype of a callback function invoked to compute a hash code for a key. Hash codes are used when key-value pairs are accessed, added, or removed from a collection.

typedef CFHashCode    (*CFDictionaryHashCallBack) (
   const void *value
);

If you name your function MyDictionaryHashCallBack, you would declare it like this:

CFHashCode MyDictionaryHashCallBack (
   const void *value
);
Parameters
value

The value used to compute the hash code.
Return Value

An integer that can be used as a table address in a hash table structure.
Discussion

This callback is passed to CFDictionaryCreate in a CFDictionaryKeyCallBacks and CFDictionaryValueCallBacks structure.*/
typedef CFHashCode    (*CFDictionaryHashCallBack) (
   const void *value
);

/*CFDictionaryEqualCallBack

Prototype of a callback function used to determine if two values or keys in a dictionary are equal.

typedef Boolean  (*CFDictionaryEqualCallBack) (
   const void *value1,
   const void *value2
);

If you name your function MyCallBack, you would declare it like this:

Boolean MyCallBack (
   const void *value1,
   const void *value2
);
Parameters
value1

A value in the dictionary.
value2

Another value in the dictionary.
Discussion

This callback is passed to CFDictionaryCreate in a CFDictionaryKeyCallBacks and CFDictionaryValueCallBacks structure.*/
typedef Boolean  (*CFDictionaryEqualCallBack) (
   const void *value1,
   const void *value2
);


/*CFMutableDictionaryRef

A reference to a mutable dictionary object.

typedef struct __CFDictionary *CFMutableDictionaryRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct __CFDictionary *CFMutableDictionaryRef;


/*CFDictionaryCopyDescriptionCallBack

Prototype of a callback function used to get a description of a value or key in a dictionary.

typedef CFStringRef (*CFDictionaryCopyDescriptionCallBack)(
   const void *value
);

If you name your function MyCallBack, you would declare it like this:

CFStringRef MyCallback (
   const void *value
);
Parameters
value

The value to be described.
Return Value

A text description of value.
Discussion

This callback is passed to CFDictionaryCreate in a CFDictionaryKeyCallBacks structure or CFDictionaryValueCallBacks. This callback is used by the CFCopyDescription function.*/
typedef CFStringRef (*CFDictionaryCopyDescriptionCallBack)(
   const void *value
);


/*CFDictionaryRetainCallBack

Prototype of a callback function used to retain a value or key being added to a dictionary.

typedef const void *(*CFDictionaryRetainCallBack) (
   CFAllocatorRef allocator,
   const void *value
);

If you name your function MyCallBack, you would declare it like this:

const void *MyCallBack (
   CFAllocatorRef allocator,
   const void *value
);
Parameters
allocator

The dictionary’s allocator.
value

The value being added to the dictionary.
Return Value

The value or key to store in the dictionary, which is usually the value parameter passed to this callback, but may be a different value if a different value should be stored in the collection.
Discussion

This callback is passed to CFDictionaryCreate in a CFDictionaryKeyCallBacks and CFDictionaryValueCallBacks structure.*/
typedef const void *(*CFDictionaryRetainCallBack) (
   CFAllocatorRef allocator,
   const void *value
);

/*CFDictionaryReleaseCallBack

Prototype of a callback function used to release a key-value pair before it’s removed from a dictionary.

typedef void (*CFDictionaryReleaseCallBack) (
   CFAllocatorRef allocator,
   const void *value
);

If you name your function MyCallBack, you would declare it like this:

void MyCallBack (
   CFAllocatorRef allocator,
   const void *value
);
Parameters
allocator

The dictionary’s allocator.
value

The value being removed from the dictionary.*/
typedef void (*CFDictionaryReleaseCallBack) (
   CFAllocatorRef allocator,
   const void *value
);
/*CFDictionaryValueCallBacks

This structure contains the callbacks used to retain, release, describe, and compare the values in a dictionary.

struct CFDictionaryValueCallBacks {
   CFIndex version;
   CFDictionaryRetainCallBack retain;
   CFDictionaryReleaseCallBack release;
   CFDictionaryCopyDescriptionCallBack copyDescription;
   CFDictionaryEqualCallBack equal;
};
typedef struct CFDictionaryValueCallBacks CFDictionaryValueCallBacks;
Fields
version

The version number of this structure. If not one of the defined version numbers for this opaque type, the behavior is undefined. The current version of this structure is 0.
retain

The callback used to retain each value as they are added to the collection. This callback returns the value to use as the value in the dictionary, which is usually the value parameter passed to this callback, but may be a different value if a different value should be used as the value. If NULL, values are not retained. See CFDictionaryRetainCallBack for a descriptions of this function’s parameters. 
release

The callback used to release values as they are removed from the dictionary. If NULL, values are not released. See CFDictionaryValueCallBacks for a description of this callback.
copyDescription

The callback used to create a descriptive string representation of each value in the dictionary. If NULL, the collection will create a simple description of each value. See CFDictionaryCopyDescriptionCallBack for a description of this callback.
equal

The callback used to compare values in the dictionary for equality. If NULL, the collection will use pointer equality to compare values in the collection. See CFDictionaryEqualCallBack for a description of this callback.*/
struct CFDictionaryValueCallBacks {
   CFIndex version;
   CFDictionaryRetainCallBack retain;
   CFDictionaryReleaseCallBack release;
   CFDictionaryCopyDescriptionCallBack copyDescription;
   CFDictionaryEqualCallBack equal;
};
typedef struct CFDictionaryValueCallBacks CFDictionaryValueCallBacks;


/*CFDictionaryKeyCallBacks

This structure contains the callbacks used to retain, release, describe, and compare the keys in a dictionary.

struct CFDictionaryKeyCallBacks {
   CFIndex version;
   CFDictionaryRetainCallBack retain;
   CFDictionaryReleaseCallBack release;
   CFDictionaryCopyDescriptionCallBack copyDescription;
   CFDictionaryEqualCallBack equal;
   CFDictionaryHashCallBack hash;
};
typedef struct CFDictionaryKeyCallBacks CFDictionaryKeyCallBacks;
Fields
version

The version number of this structure. If not one of the defined version numbers for this opaque type, the behavior is undefined. The current version of this structure is 0.
retain

The callback used to retain each key as they are added to the collection. This callback returns the value to use as the key in the dictionary, which is usually the value parameter passed to this callback, but may be a different value if a different value should be used as the key. If NULL, keys are not retained. See CFDictionaryRetainCallBack for a descriptions of this function’s parameters.
release

The callback used to release keys as they are removed from the dictionary. If NULL, keys are not released. See CFDictionaryValueCallBacks for a description of this callback. 
copyDescription

The callback used to create a descriptive string representation of each key in the dictionary. If NULL, the collection will create a simple description of each key. See CFDictionaryCopyDescriptionCallBack for a description of this callback.
equal

The callback used to compare keys in the dictionary for equality. If NULL, the collection will use pointer equality to compare keys in the collection. See CFDictionaryEqualCallBack for a description of this callback. 
hash

The callback used to compute a hash code for keys as they are used to access, add, or remove values in the dictionary. If NULL, the collection computes a hash code by converting the pointer value to an integer. See CFDictionaryHashCallBack for a description of this callback.*/
struct CFDictionaryKeyCallBacks {
   CFIndex version;
   CFDictionaryRetainCallBack retain;
   CFDictionaryReleaseCallBack release;
   CFDictionaryCopyDescriptionCallBack copyDescription;
   CFDictionaryEqualCallBack equal;
   CFDictionaryHashCallBack hash;
};
typedef struct CFDictionaryKeyCallBacks CFDictionaryKeyCallBacks;





/*CFDictionaryRetainCallBack

Prototype of a callback function used to retain a value or key being added to a dictionary.

typedef const void *(*CFDictionaryRetainCallBack) (
   CFAllocatorRef allocator,
   const void *value
);

If you name your function MyCallBack, you would declare it like this:

const void *MyCallBack (
   CFAllocatorRef allocator,
   const void *value
);
Parameters
allocator

The dictionary’s allocator.
value

The value being added to the dictionary.
Return Value

The value or key to store in the dictionary, which is usually the value parameter passed to this callback, but may be a different value if a different value should be stored in the collection.
Discussion

This callback is passed to CFDictionaryCreate in a CFDictionaryKeyCallBacks and CFDictionaryValueCallBacks structure.*/
typedef const void *(*CFDictionaryRetainCallBack) (
   CFAllocatorRef allocator,
   const void *value
);


/*Predefined Callback Structures

CFDictionary provides some predefined callbacks for your convenience.

const CFDictionaryKeyCallBacks kCFCopyStringDictionaryKeyCallBacks;
const CFDictionaryKeyCallBacks kCFTypeDictionaryKeyCallBacks;
const CFDictionaryValueCallBacks kCFTypeDictionaryValueCallBacks;
Constants
kCFCopyStringDictionaryKeyCallBacks

Predefined CFDictionaryKeyCallBacks structure containing a set of callbacks appropriate for use when the keys of a CFDictionary are all CFString objects, which may be mutable and need to be copied in order to serve as constant keys for the values in the dictionary.

You typically use a pointer to this constant when creating a new dictionary.

Important: For performance reasons, the default kCFCopyStringDictionaryKeyCallBacks behavior uses CFEqual which does not normalize the strings. This means that, for example, it does not consider CFStrings to be equal when they are the same but one is in pre-composed form (say, originating from a UTF-16 text file) and the other in decomposed form (say, originating from a file name). In cases where you use strings from different sources, you may want to pre-normalize the keys or else use a different set of functions to perform the comparison.


Available in Mac OS X v10.0 and later.
kCFTypeDictionaryKeyCallBacks

Predefined CFDictionaryKeyCallBacks structure containing a set of callbacks appropriate for use when the keys of a CFDictionary are all CFType-derived objects.

The retain callback is CFRetain, the release callback is CFRelease, the copy callback is CFCopyDescription, the equal callback is CFEqual. Therefore, if you use a pointer to this constant when creating the dictionary, keys are automatically retained when added to the collection, and released when removed from the collection.

Available in Mac OS X v10.0 and later.
kCFTypeDictionaryValueCallBacks

Predefined CFDictionaryValueCallBacks structure containing a set of callbacks appropriate for use when the values in a CFDictionary are all CFType-derived objects.

The retain callback is CFRetain, the release callback is CFRelease, the copy callback is CFCopyDescription, and the equal callback is CFEqual. Therefore, if you use a pointer to this constant when creating the dictionary, values are automatically retained when added to the collection, and released when removed from the collection.

Available in Mac OS X v10.0 and later.*/
const CFDictionaryKeyCallBacks kCFCopyStringDictionaryKeyCallBacks;
const CFDictionaryKeyCallBacks kCFTypeDictionaryKeyCallBacks;
const CFDictionaryValueCallBacks kCFTypeDictionaryValueCallBacks;



/*CFDictionarySetValue

Sets the value corresponding to a given key.

void CFDictionarySetValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);
Parameters
theDict

The dictionary to modify. If this parameter is a fixed-capacity dictionary and it is full before this operation, and the key does not exist in the dictionary, the behavior is undefined. 
key

The key of the value to set in theDict. If a key which matches key is already present in the dictionary, only the value for the key is changed ("add if absent, replace if present"). If no key matches key, the key-value pair is added to the dictionary.

If a key-value pair is added, both key and value are retained by the dictionary, using the retain callback provided when theDict was created. key must be of the type expected by the key retain callback. 
value

The value to add to or replace in theDict. value is retained using the value retain callback provided when theDict was created, and the previous value if any is released. value must be of the type expected by the retain and release callbacks.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDictionarySetValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);

/*CFDictionaryGetTypeID

Returns the type identifier of all CFDictionary objects.

CFTypeID CFDictionaryGetTypeID ();
Return Value

The type identifier for the CFDictionary opaque type. 
Discussion

CFMutableDictionary objects have the same type identifier as CFDictionary objects.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFDictionaryGetTypeID ();

/*CFDictionaryContainsKey

Reports whether or not a key is in a dictionary.

Boolean CFDictionaryContainsKey (
   CFDictionaryRef theDict,
   const void *key
);
Parameters
theDict

The dictionary to examine. 
key

The key for which to find matches in the dictionary. The key hash and equal callbacks provided when the dictionary was created, are used to compare. If the hash callback is NULL, key is treated as a pointer and converted to an integer. If the equal callback is NULL, pointer equality (in C, ==) is used. If key, or any of the keys in the dictionary, is not understood by the equal callback, the behavior is undefined. 
Return Value

true, if key is in the dictionary, otherwise false. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFDictionaryContainsKey (
   CFDictionaryRef theDict,
   const void *key
);

/*CFDictionaryCreate

Creates an immutable dictionary containing the specified key-value pairs.

CFDictionaryRef CFDictionaryCreate (
   CFAllocatorRef allocator,
   const void **keys,
   const void **values,
   CFIndex numValues,
   const CFDictionaryKeyCallBacks *keyCallBacks,
   const CFDictionaryValueCallBacks *valueCallBacks
);
Parameters
allocator

The allocator to use to allocate memory for the new dictionary. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
keys

A C array of the pointer-sized keys to be in the new dictionary. This value may be NULL if the numValues parameter is 0. This C array is not changed or freed by this function. The value must be a valid pointer to a C array of at least numValues pointers. 
values

A C array of the pointer-sized values to be in the new dictionary. This value may be NULL if the numValues parameter is 0. This C array is not changed or freed by this function. The value must be a valid pointer to a C array of at least numValues elements.
numValues

The number of key-value pairs to copy from the keys and values C arrays into the new dictionary. This number will be the count of the dictionary; it must be non-negative and less than or equal to the actual number of keys or values. 
keyCallBacks

A pointer to a CFDictionaryKeyCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare keys in the dictionary. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as if a valid structure of version 0 with all fields NULL had been passed in. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this parameter is not a valid pointer to a CFDictionaryKeyCallBacks structure, the behavior is undefined. If any of the keys put into the collection is not one understood by one of the callback functions the behavior when that callback function is used is undefined.

If the collection will contain CFType objects only, then pass a pointer to kCFTypeDictionaryKeyCallBacks as this parameter to use the default callback functions.
valueCallBacks

A pointer to a CFDictionaryValueCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare values in the dictionary. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as if a valid structure of version 0 with all fields NULL had been passed in. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this parameter is not a valid pointer to a CFDictionaryValueCallBacks structure, the behavior is undefined. If any value put into the collection is not one understood by one of the callback functions the behavior when that callback function is used is undefined.

If the collection will contain CFType objects only, then pass a pointer to kCFTypeDictionaryValueCallBacks as this parameter to use the default callback functions.
Return Value

A new dictionary, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDictionaryRef CFDictionaryCreate (
   CFAllocatorRef allocator,
   const void **keys,
   const void **values,
   CFIndex numValues,
   const CFDictionaryKeyCallBacks *keyCallBacks,
   const CFDictionaryValueCallBacks *valueCallBacks
);

/*CFDictionaryGetValue

Returns the value associated with a key.

const void *CFDictionaryGetValue (
   CFDictionaryRef theDict,
   const void *key
);
Parameters
theDict

The dictionary examine.
key

The key for which to find a match in theDict. The key hash and equal callbacks provided when the dictionary was created are used to compare. If the hash callback was NULL, the key is treated as a pointer and converted to an integer. If the equal callback was NULL, pointer equality (in C, ==) is used. If key, or any of the keys in theDict, is not understood by the equal callback, the behavior is undefined. 
Return Value

The value associated with key in theDict, or NULL if no key-value pair matching key exists. Since NULL is also a valid value in some dictionaries, use CFDictionaryGetValueIfPresent to distinguish between a value that is not found, and a NULL value. If the value is a Core Foundation object, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
const void *CFDictionaryGetValue (
   CFDictionaryRef theDict,
   const void *key
);

/*CFDictionaryAddValue

Adds a key-value pair to a dictionary if the specified key is not already present.

void CFDictionaryAddValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);
Parameters
theDict

The dictionary to modify. If the dictionary is a fixed-capacity dictionary and it is full before this operation, the behavior is undefined. 
key

The key for the value to add to the dictionary—a CFType object or a pointer value. The key is retained by the dictionary using the retain callback provided when the dictionary was created, so must be of the type expected by the callback. If a key which matches key is already present in the dictionary, this function does nothing ("add if absent"). 
value

A CFType object or a pointer value to add to the dictionary. The value is retained by the dictionary using the retain callback provided when the dictionary was created, so must be of the type expected by the callback.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDictionaryAddValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);

/*CFDictionaryCreateMutable

Creates a new mutable dictionary.

CFMutableDictionaryRef CFDictionaryCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFDictionaryKeyCallBacks *keyCallBacks,
   const CFDictionaryValueCallBacks *valueCallBacks
);
Parameters
allocator

The allocator to use to allocate memory for the new dictionary and its storage for key-value pairs. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
capacity

The maximum number of key-value pairs that can be contained by the dictionary. The dictionary starts empty and can grow to this number of key-value pairs (and it can have less). Pass 0 to specify no limit. The value must not be negative.
keyCallBacks

A pointer to a CFDictionaryKeyCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare keys in the dictionary. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as a valid structure of version 0 with all fields NULL. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this value is not a valid pointer to a CFDictionaryKeyCallBacks structure, the behavior is undefined. If any of the keys put into the collection is not one understood by one of the callback functions, the behavior when that callback function is used is undefined.

If the dictionary will contain only CFType objects, then pass a pointer to kCFTypeDictionaryKeyCallBacks as this parameter to use the default callback functions. 
valueCallBacks

A pointer to a CFDictionaryValueCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare values in the dictionary. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as a valid structure of version 0 with all fields NULL. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this value is not a valid pointer to a CFDictionaryValueCallBacks structure, the behavior is undefined. If any value put into the collection is not one understood by one of the callback functions, the behavior when that callback function is used is undefined.

If the dictionary will contain CFType objects only, then pass a pointer to kCFTypeDictionaryValueCallBacks as this parameter to use the default callback functions. 
Return Value

A new dictionary, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableDictionaryRef CFDictionaryCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFDictionaryKeyCallBacks *keyCallBacks,
   const CFDictionaryValueCallBacks *valueCallBacks
);

#ifdef __cplusplus
}
#endif
#endif