#ifndef CGCONTEXT_H
#define CGCONTEXT_H


#include <CoreGraphics/CGBase.h>
#include <CoreGraphics/CGAffineTransform.h>
#include <CoreGraphics/CGColor.h>
#include <CoreGraphics/CGColorSpace.h>
#include <CoreGraphics/CGFont.h>
#include <CoreGraphics/CGImage.h>
#include <CoreGraphics/CGPath.h>
#include <CoreGraphics/CGPattern.h>
#include <CoreGraphics/CGPDFDocument.h>
#include <CoreGraphics/CGShading.h>
#include <CoreFoundation/CFBase.h>
#include <limits.h>
#include <stddef.h>
#include <AvailabilityMacros.h>

/*Line Cap Styles

Specify how to render the endpoint of a line when stroking.

enum CGLineCap {
   kCGLineCapButt,
   kCGLineCapRound,
   kCGLineCapSquare
};
typedef enum CGLineCap CGLineCap;
Constants
kCGLineCapButt

A line with a squared-off end. Quartz draws the line to extend only to the exact endpoint of the path. This is the default.

Available in Mac OS X v10.0 and later.
kCGLineCapRound

A line with a rounded end. Quartz draws the line to extend beyond the endpoint of the path. The line ends with a semicircular arc with a radius of 1/2 the line’s width, centered on the endpoint.

Available in Mac OS X v10.0 and later.
kCGLineCapSquare

A line with a squared-off end. Quartz extends the line beyond the endpoint of the path for a distance equal to half the line width.

Available in Mac OS X v10.0 and later.
Discussion

A line cap specifies the method used by CGContextStrokePath to draw the endpoint of the line. To change the line cap style in a graphics context, you use the function CGContextSetLineCap.*/
enum CGLineCap {
   kCGLineCapButt,
   kCGLineCapRound,
   kCGLineCapSquare
};
typedef enum CGLineCap CGLineCap;

/*CGContextRef

Defines an opaque type that represents a Quartz 2D drawing environment.

typedef struct CGContext * CGContextRef;
Discussion

All objects in Quartz are drawn in, or contained by, a graphics context. Quartz provides several different kinds of context, including the following:
A bitmap graphics context allows you to paint into a bitmap. 
A window graphics context is a bitmap graphics context that you can use to draw into a window. 
A graphics context obtained from the printing framework, is used to draw images directly to a printer. 
A PDF graphics context allows you to create a PDF document. 
A GL graphics contexts lets you draw to an Open GL context.

For detailed information on how to create each flavor of graphics context, including sample code, see Quartz 2D Programming Guide.

In Mac OS X version 10.2 and later, CGContextRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct CGContext * CGContextRef;

/*CGContextDrawImage

Draws an image into a graphics context.

void CGContextDrawImage (
   CGContextRef context,
   CGRect rect,
   CGImageRef image
);
Parameters
context

The graphics context in which to draw the image. 
rect

The location and dimensions in user space of the bounding box in which to draw the image. 
image

The image to draw. 
Discussion

Quartz scales the image—disproportionately, if necessary—to fit the bounds specified by the rect parameter.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/void CGContextDrawImage (
   CGContextRef context,
   CGRect rect,
   CGImageRef image
);

/*CGContextAddRect

Adds a new subpath, consisting of a single rectangle, to a graphics context.

void CGContextAddRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context to which to add the rectangular subpath. 
rect

A CGRect value that specifies, in the user space, the dimensions and location of the rectangle to create. 
Discussion

This function adds a subpath consisting of a single rectangle to the specified context’s path. You can add multiple rectangular subpaths at the same time using the function CGContextAddRects. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddRect (
   CGContextRef context,
   CGRect rect
);

/*CGContextSetGrayFillColor

Sets the current fill color to a value in the DeviceGray color space.

void CGContextSetGrayFillColor (
   CGContextRef context,
   float gray,
   float alpha
);
Parameters
context

The graphics context for which to set the current fill color. 
gray

A value that specifies the desired gray level. The DeviceGray color space permits the specification of a value ranging from 0.0 (absolute black) to 1.0 (absolute white). Values outside this range are clamped to 0.0 or 1.0.
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current fill color space to DeviceGray.
Quartz sets the current fill color to the value you specify in the gray and alpha parameters.

See also CGContextSetGrayStrokeColor. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetGrayFillColor (
   CGContextRef context,
   float gray,
   float alpha
);

/*CGContextRestoreGState

Sets the current graphics state to the state most recently saved.

void CGContextRestoreGState (
   CGContextRef context
);
Parameters
context

The graphics context to modify.
Discussion

When you call CGContextRestoreGState, Quartz removes the most recently saved graphics state from the top of the stack and uses that state’s saved settings for the current graphics state. See CGContextSaveGState.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextRestoreGState (
   CGContextRef context
);

/*CGContextStrokePath

Paints a line along the current path.

void CGContextStrokePath (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to stroke.
Discussion

This function strokes the current path. See also CGContextDrawPath, CGContextEOFillPath, and CGContextFillPath.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextStrokePath (
   CGContextRef context
);

/*CGContextFillPath

Paints the area within the current path, using the nonzero winding number rule.

void CGContextFillPath (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to fill. 
Discussion

When you fill the current path, Quartz fills each subpath independently. Any subpath that has not been explicitly closed is closed implicitly by the fill routines. 

There are two different methods of filling paths. The CGContextFillPath function uses the nonzero winding number rule. The function CGContextEOFillPath uses the even-odd rule to fill a path.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextFillPath (
   CGContextRef context
);

/*CGContextAddArc

Adds an arc of a circle to the current path, using a center point, radius, and end point.

void CGContextAddArc (
   CGContextRef context,
   float x,
   float y,
   float radius,
   float startAngle,
   float endAngle,
   int clockwise
);
Parameters
context

The graphics context to which to add the arc.
x

The x-coordinate of the user space for the center of the arc.
y

The y-coordinate of the user space for the center of the arc.
radius

The radius of the arc, in user space coordinates.
startAngle

The angle to the starting point of the arc, measured in radians from the positive x-axis.
endAngle

The angle to the end point of the arc, measured in radians from the positive x-axis.
clockwise

Pass 1 if the arc is to be drawn clockwise; 0 otherwise.
Discussion

When you call this function, Quartz builds an arc of a circle centered on the point you provide. The arc is of the specified radius and extends between the start and end point. (You can also use CGContextAddArc as a convenient way to draw a circle, by setting the start point to 0 and the end point to 2*Pi.)

If the current path already contains a subpath, Quartz additionally appends a straight line segment from the current point to the starting point of the arc. If the current path is empty, Quartz creates a new subpath for the arc and does not add the initial straight line segment.

After adding the arc, the current point is reset to the end point of arc (the second tangent point).

See also CGContextAddArcToPoint. 
Availability
Available in Mac OS X version 10.0 and later.*/
void CGContextAddArc (
   CGContextRef context,
   float x,
   float y,
   float radius,
   float startAngle,
   float endAngle,
   int clockwise
);

/*CGContextBeginPath

Creates a new empty path in a graphics context.

void CGContextBeginPath (
   CGContextRef context
);
Parameters
context

The graphics context in which to begin a new path.
Discussion

A graphics context can have only a single path in use at any time. Therefore, if the specified context already contains a current path when you call this function, Quartz replaces the previous current path with the new path. In this case, Quartz discards the old path and any data associated with it.

The current path is not part of the graphics state. Consequently, saving and restoring the graphics state has no effect on the current path.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextBeginPath (
   CGContextRef context
);

/*CGContextSetRGBStrokeColor

Sets the current stroke color to a value in the DeviceRGB color space.

void CGContextSetRGBStrokeColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha
);
Parameters
context

The graphics context for which to set the current stroke color. 
red

The red intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
green

The green intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
blue

The blue intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current stroke color space to DeviceRGB.
Quartz sets the current stroke color to the value specified by the red, green, blue, and alpha parameters.

See also CGContextSetRGBFillColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetRGBStrokeColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha
);

/*CGContextSetLineWidth

Sets the line width for a graphics context.

void CGContextSetLineWidth (
   CGContextRef context,
   float width
);
Parameters
context

The graphics context for which to set the line width parameter of the current graphics state. 
width

The new line width to be used, in user space units. The value must be greater than 0.
Discussion

The line width is the total width of the line, expressed in units of the user space. The line surrounds the center of the path, with half of the total width on either side. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextSetLineWidth (
   CGContextRef context,
   float width
);

/*CGContextSaveGState

Pushes a copy of the current graphics state on the top of a context’s graphics state stack.

void CGContextSaveGState (
   CGContextRef context
);
Parameters
context

The graphics context for which to save the current graphics state. 
Discussion

Each graphics context maintains a stack of graphics states. When you call CGContextSaveGState, Quartz saves the current graphics state to the top of the context’s graphics state stack.

Note that not all aspects of the current drawing environment are elements of the graphics state. For example, the current path is not considered part of the graphics state and is therefore not saved when you call the CGContextSaveGState function. The graphics state parameters that are saved are:
CTM (current transformation matrix) 
clip region
image interpolation quality 
line width 
line join 
miter limit 
line cap 
line dash 
flatness 
should anti-alias 
rendering intent 
fill color space 
stroke color space 
fill color 
stroke color 
alpha value 
font 
font size 
character spacing 
text drawing mode
shadow parameters
the pattern phase
the font smoothing parameter
blend mode

To restore your drawing environment to a previously saved state, you can use the function CGContextRestoreGState. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSaveGState (
   CGContextRef context
);

/*CGContextSetRGBFillColor

Sets the current fill color to a value in the DeviceRGB color space.

void CGContextSetRGBFillColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha
);
Parameters
context

The graphics context for which to set the current fill color. 
red

The red intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
green

The green intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
blue

The blue intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current fill color space to DeviceRGB. 
Quartz sets the current fill color to the value specified by the red, green, blue, and alpha parameters.

See also CGContextSetRGBStrokeColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetRGBFillColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha
);

/*CGContextFillRect

Paints the area contained within a rectangle.

void CGContextFillRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context in which to paint the rectangle.
rect

A CGRect value that specifies the dimensions and location in the user space of the rectangle to paint. 
Discussion

This function paints the area contained within the specified rectangle, using the fill color specified in the current graphics state. As a side effect when you call this function, Quartz clears the current path.

See also CGContextFillRects.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextFillRect (
   CGContextRef context,
   CGRect rect
);


/*CGContextRelease

Decrements the retain count of a graphics context.

void CGContextRelease (
   CGContextRef context
);
Parameters
context

The graphics context to release.
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the context parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextRelease (
   CGContextRef context
);

/*CGContextMoveToPoint

Begins a new subpath at the point you specify.

void CGContextMoveToPoint (
   CGContextRef context,
   float x,
   float y
);
Parameters
context

A graphics context. 
x

A value for the x-coordinate of the user space at which to begin the subpath.
y

A value for the y-coordinate of the user space at which to begin the subpath.
Discussion

The CGContextMoveToPoint function begins a new subpath starting at the point you specify. This point is defined to be the “current” point, and it defines the starting point of the next line segment.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextMoveToPoint (
   CGContextRef context,
   float x,
   float y
);

/*CGContextAddCurveToPoint

Appends a cubic Bézier curve from the current point, using control points and an end point you specify.

void CGContextAddCurveToPoint (
   CGContextRef context,
   float cp1x,
   float cp1y,
   float cp2x,
   float cp2y,
   float x,
   float y
);
Parameters
context

The graphics context to which to add the curve. The context’s path must not be empty.
cp1x

The x-coordinate of the user space for the first control point of the curve.
cp1y

The y-coordinate of the user space for the first control point of the curve.
cp2x

The x-coordinate of the user space for the second control point of the curve.
cp2y

The y-coordinate of the user space for the second control point of the curve.
x

The x-coordinate of the user space at which to end the curve.
y

The y-coordinate of the user space at which to end the curve.
Discussion

This function appends a cubic curve to the current path. After adding the segment, the current point is reset from the beginning of the new segment to the end point of that segment.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddCurveToPoint (
   CGContextRef context,
   float cp1x,
   float cp1y,
   float cp2x,
   float cp2y,
   float x,
   float y
);

/*CGContextAddLineToPoint

Appends a straight line segment from the current point to the point you specify.

void CGContextAddLineToPoint (
   CGContextRef context,
   float x,
   float y
);
Parameters
context

The graphics context to which to add a line segment. The context’s path must not be empty.
x

A value for the x-coordinate of the user space at which to end the line segment.
y

A value for the y-coordinate of the user space at which to end the line segment.
Discussion

This function appends a single straight line segment to the current subpath. After adding the line segment, the current point is reset from the beginning of the new line segment to the endpoint of that line segment. You can add a subpath consisting of multiple straight line segments using the function CGContextAddLines.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddLineToPoint (
   CGContextRef context,
   float x,
   float y
);

/*CGContextSetLineCap

Sets the style for the endpoints of lines in a graphics context.

void CGContextSetLineCap (
   CGContextRef context,
   CGLineCap cap
);
Parameters
context

The graphics context for which to set the line cap parameter of the current graphics state. 
cap

A CGLineCap value that specifies the line cap style to be used. For a discussion of the available line cap styles, see Line Cap Styles.
Discussion

The line cap style specifies how Quartz draws the endpoint of a line. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetLineCap (
   CGContextRef context,
   CGLineCap cap
);

/*CGContextClipToMask

Maps a mask into the specified rectangle and intersects it with the current clipping area of the graphics context.

void CGContextClipToMask(
CGContextRef c,
CGRect rect,
CGImageRef mask
);
Parameters
c

A graphics context. 
rect

The rectangle to map the mask parameter to.
mask

An image or an image mask. If mask is an image, then it must be in the DeviceGray color space, may not have an alpha component, and may not be masked by an image mask or masking color.
Discussion

If the mask parameter is an image mask, then Quartz clips in a manner identical to the behavior seen with the function CGContextDrawImage—the mask indicates an area to be left unchanged when drawing. The source samples of the image mask determine which points of the clipping area are changed, acting as an "inverse alpha" value. If the value of a source sample in the image mask is S, then the corresponding point in the current clipping area is multiplied by an alpha value of (1–S). For example, if S is 1 then the point in the clipping area becomes transparent. If S is 0, the point in the clipping area is unchanged.

If the mask parameter is an image, then mask acts like an alpha mask and is blended with the current clipping area. The source samples of mask determine which points of the clipping area are changed. If the value of the source sample in mask is S, then the corresponding point in the current clipping area is multiplied by an alpha of S. For example, if S is 0, then the point in the clipping area becomes transparent. If S is 1, the point in the clipping area is unchanged.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGContext.h*/
void CGContextClipToMask(
CGContextRef c,
CGRect rect,
CGImageRef mask
);

#endif