#ifndef CGDATAPROVIDER_H
#define CGDATAPROVIDER_H

#include <CoreGraphics/CGBase.h>
#include <CoreFoundation/CFURL.h>
#include <stddef.h>

/*CGDataProviderRef

Defines an opaque type that supplies Quartz with data.

typedef struct CGDataProvider *CGDataProviderRef;
Discussion

Some Quartz routines supply blocks of data to your program. Rather than reading through a raw memory buffer, data provider objects of type CGDataProviderRef allow you to supply Quartz functions with data. 

In Mac OS X version 10.2 and later, CGDataProviderRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct CGDataProvider *CGDataProviderRef;

/*CGDataProviderRelease

Decrements the retain count of a data provider.

void CGDataProviderRelease (
   CGDataProviderRef provider
);
Parameters
provider

The data provider to release. 
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the provider parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGDataProvider.h*/
void CGDataProviderRelease (
   CGDataProviderRef provider
);

/*CGDataProviderCreateWithData

Creates a Quartz direct-access data provider that uses data your program supplies.

CGDataProviderRef CGDataProviderCreateWithData (
   void *info,
   const void *data,
   size_t size,
   void (*releaseData)(void *info, const void *data, size_t size)
);
Parameters
info

A pointer to data of any type, or NULL. When Quartz calls the function specified in the releaseData parameter, Quartz sends it this pointer as its first argument.
data

A pointer to the array of data that the provider contains.
size

A value that specifies the number of bytes that the data provider contains.
releaseData

A pointer to a release callback for the data provider, or NULL. Your release function is called when Quartz frees the data provider. For more information, see CGDataProviderReleaseDataCallback.
Return Value

A new data provider. You are responsible for releasing this object using CGDataProviderRelease.
Discussion

You use this function to create a direct-access data provider that uses callback functions to read data from your program an entire block at one time. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGDataProvider.h*/
CGDataProviderRef CGDataProviderCreateWithData (
   void *info,
   const void *data,
   size_t size,
   void (*releaseData)(void *info, const void *data, size_t size)
);


#endif