#ifndef AEINTERACTION_H
#define AEINTERACTION_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef NOTIFICATION_H
#include <HIToolbox/Notification.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*AEFilterProcPtr

Defines a pointer to a function the Apple Event Manager calls while your application waits for a reply to an Apple event. Your filter function determines which high-level events your application is willing to handle.

typedef Boolean (*AEFilterProcPtr) (
   EventRecord * theEvent,
   long returnID,
   long transactionID,
   const AEAddressDesc * sender
);

If you name your function MyAEFilterCallback, you would declare it like this:

Boolean MyAEFilterCallback (
   EventRecord * theEvent,
   long returnID,
   long transactionID,
   const AEAddressDesc * sender
);
Parameters
theEvent

A pointer to the event record for a high-level event. The next three parameters contain valid information only if the event is an Apple event. See the Event Manager documentation for a description of the EventRecord data type.
returnID

Return ID for the Apple event.
transactionID

Transaction ID for the Apple event.
sender

A pointer to the address of the process that sent the Apple event. See AEAddressDesc.
Return Value

Your filter routine returns TRUE to accept the Apple event or FALSE to filter it out.
Discussion

If your application provides a universal procedure pointer to a reply filter function as a parameter to the AESend function, the reply filter function can indicate any high-level events that it is willing to handle while your application is waiting for a reply.

If your filter function returns true, the Apple Event Manager will dispatch the event through the standard dispatch mechanism (equivalent to calling AEProcessAppleEvent).

To provide a pointer to your reply filter callback function, you create a universal procedure pointer (UPP) of type AEFilterUPP, using the function NewAEFilterUPP. You can do so with code like the following:*/

typedef Boolean (*AEFilterProcPtr) (
   EventRecord * theEvent,
   long returnID,
   long transactionID,
   const AEAddressDesc * sender
);


/*AEIdleProcPtr

Defines a pointer to a function the Apple Event Manager calls while your application waits for a reply to an Apple event. Your idle function must handle update, null, operating-system, and activate events.

typedef Boolean (*AEIdleProcPtr) (
   EventRecord * theEvent,
   long * sleepTime,
   RgnHandle * mouseRgn
);

If you name your function MyAEIdleCallback, you would declare it like this:

Boolean MyAEIdleCallback (
   EventRecord * theEvent,
   long * sleepTime,
   RgnHandle * mouseRgn
);
Parameters
theEvent

A pointer to the event record of the event to process. See the Event Manager documentation for a description of the EventRecord data type.
sleepTime

A pointer to a value that specifies the amount of time (in ticks) your application is willing to relinquish the processor if no events are pending.
mouseRgn

A pointer to a value that specifies a screen region that determines the conditions under which your application is to receive notice of mouse-moved events. See the QuickDraw Manager documentation for a description of the RgnHandle data type.
Return Value

Your idle routine returns TRUE if your application is no longer willing to wait for a reply from the server or for the user to bring the application to the front. It returns FALSE if your application is still willing to wait.
Discussion

If your application provides a pointer to an idle function as a parameter to the AESend function or the AEInteractWithUser function, the Apple Event Manager will call the idle function to handle any update event, null event, operating-system event, or activate event received for your application while it is waiting for a reply.

To provide a pointer to your idle callback function, you create a universal procedure pointer (UPP) of type AEIdleUPP, using the function NewAEIdleUPP. You can do so with code like the following:AEIdleUPP MyIdleUPP;
MyIdleUPP = NewAEIdleUPP (&MyIdleCallback)


You can then pass the UPP MyIdleUPP as a parameter to either the AESend function or the AEInteractWithUser function.

If you wish to call your idle callback function directly, you can use the InvokeAEIdleUPP function.

After you are finished with your idle callback function, you can dispose of the UPP with the DisposeAEIdleUPP function. However, if you will use the same idle function in subsequent calls to AESend or AEInteractWithUser, you can reuse the same UPP, rather than dispose of it and later create a new UPP.*/
typedef Boolean (*AEIdleProcPtr) (
   EventRecord * theEvent,
   long * sleepTime,
   RgnHandle * mouseRgn
);
/*AEFilterUPP

Defines a data type for the universal procedure pointer for the AEFilterProcPtr callback function pointer.

typedef AEFilterProcPtr AEFilterUPP;
Discussion

For a description of a filter callback function, see AEFilterProcPtr.*/
typedef AEFilterProcPtr AEFilterUPP;

/*AEIdleUPP

Defines a data type for the universal procedure pointer for the AEIdleProcPtr callback function pointer.

typedef AEIdleProcPtr AEIdleUPP;
Discussion

For a description of an idle callback function, see AEIdleProcPtr.*/
typedef AEIdleProcPtr AEIdleUPP;

/*AESend

Sends the specified Apple event.

OSErr AESend (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   AESendMode sendMode,
   AESendPriority sendPriority,
   long timeOutInTicks,
   AEIdleUPP idleProc,
   AEFilterUPP filterProc
);
Parameters
theAppleEvent

A pointer to the Apple event to send. See AppleEvent.
reply

A pointer to a reply Apple event. On return, contains the reply Apple event from the server application, if you specified the kAEWaitReply flag in the sendMode parameter. If you specify the kAEQueueReply flag in the sendMode parameter, you receive the reply Apple event in your event queue. If you specify kAENoReply flag, the reply Apple event is a null descriptor (one with descriptor type typeNull). If you specify kAEWaitReply in the sendMode parameter, and if the function returns successfully (see function result below), your application is responsible for using the AEDisposeDesc function to dispose of the descriptor returned in the reply parameter.
sendMode

Specifies various options for how the server application should handle the Apple event. To obtain a value for this parameter, you add together constants to set bits that specify the reply mode, the interaction level, the application switch mode, the reconnection mode, and the return receipt mode. For more information, see AESendMode.
sendPriority

See the Version Notes section below for important information. A value that specifies the priority for processing the Apple event. You can specify normal or high priority, using the constants described in AESendMode. See AESendPriority.
timeOutInTicks

If the reply mode specified in the sendMode parameter is kAEWaitReply, or if a return receipt is requested, this parameter specifies the length of time (in ticks) that the client application is willing to wait for the reply or return receipt from the server application before timing out. Most applications should use the kAEDefaultTimeout constant, which tells the Apple Event Manager to provide an appropriate timeout duration. If the value of this parameter is kNoTimeOut, the Apple event never times out. These constants are described in “Timeout Constants”.
idleProc

A universal procedure pointer to a function that handles events (such as update, operating-system, activate, and null events) that your application receives while waiting for a reply. Your idle function can also perform other tasks (such as displaying a wristwatch or spinning beach ball cursor) while waiting for a reply or a return receipt.

If your application specifies the kAEWaitReply flag in the sendMode parameter and you wish your application to get periodic time while waiting for the reply to return, you must provide an idle function. Otherwise, you can pass a value of NULL for this parameter. For more information on the idle function, see AEIdleProcPtr.
filterProc

A universal procedure pointer to a function that determines which incoming Apple events should be received while the handler waits for a reply or a return receipt. If your application doesn’t need to filter Apple events, you can pass a value of NULL for this parameter. If you do so, no application-oriented Apple events are processed while waiting. For more information on the filter function, see AEFilterProcPtr.
Return Value

A result code. See “Apple Event Manager Result Codes”. The AESend function returns noErr if the Event Manager successfully sends the Apple event—this value does not indicate that the Apple event was handled successfully. If the handler returns a result code other than noErr, and if the client is waiting for a reply, AESend returns the result code in the keyErrorNumber parameter of the reply Apple event. For a result code other than noErr, you should not call the AEDisposeDesc function to dispose of the descriptor returned in the reply parameter, because the descriptor is invalid.
Discussion

You typically create an Apple event to send with the AECreateAppleEvent function and add information to it with the functions described in “Adding Parameters and Attributes to an Apple Event”.

If the Apple Event Manager cannot find a handler for the Apple event in the server application’s dispatch table or in the system dispatch table, it returns the result code errAEEventNotHandled to the server application (as the result of the AEProcessAppleEvent function). If the client application is waiting for a reply, the Apple Event Manager also returns this result code to the client in the keyErrorNumber parameter of the reply event.

In addition to specifying the wait duration for replies, the timeOutInTicks parameter is used as a wait value when queuing events for other applications. The Apple Event Manager waits for the specified duration as it attempts to queue the event. If you specify kAEWaitReply and the target application quits or crashes after the event is queued but before the reply is returned, the Apple Event Manager returns a sessionClosedErr result code. 

In some situations, there are advantages to sending Apple events with the AESendMessage function. That function requires less overhead than AESend and it allows you to send Apple events while linking with just the Application Services framework, and not the entire Carbon framework (and window server), as required by AESend. For more information on sending Apple events, see “Sending an Apple Event” in Apple Events Programming Guide.
Version Notes

In Mac OS 9 and earlier, you use the sendMode parameter to specify how the server should handle the Apple event. AESendMode provides a complete description of the constants you use with this parameter. The sendPriority parameter is deprecated in Mac OS X and later.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/
OSErr AESend (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   AESendMode sendMode,
   AESendPriority sendPriority,
   long timeOutInTicks,
   AEIdleUPP idleProc,
   AEFilterUPP filterProc
);

#ifdef __cplusplus
}
#endif

#endif