/*
http://compilers.iecc.com/comparch/article/99-06-036
header conversion?
Waverly <Waverly@Macol.net>
6 Jun 1999 23:04:53 -0400
          From comp.compilersRelated articles
header conversion? Waverly@Macol.net (Waverly) (1999-06-06)

| List of all articles for this month | 
 From: 	Waverly <Waverly@Macol.net>
Newsgroups: 	comp.compilers
Date: 	6 Jun 1999 23:04:53 -0400
Organization: 	Compilers Central
Keywords: 	question, tools


I am currently working on a project in which I need to convert
macintosh universal header files for another language. What I really
need is to analyze the header files and keep track of variables,
types, struct, etc. I believe what I need is to create a
cross-referencer. To add more pain to my misery, I also need to
preprocess the file.

The end result is to anlayze and reconstitute the file to create my own
headers with the equivalent data structures and constructs. I'll worry
about recovering comments after I've gotten everything working. That
will likely be the easy part.


Has this been done before?


Thanks to anyone who can point into the right and hopefully the
simplest direction. If it is not too much to ask, would you email me
with your response.



Waverly@macol.com


This is a small but common snip of what I have to handle from
<mixemode.h> which is critical to nearly all the header files.



* * * * * * * * * * * * * * *
  * STACK_UPP_TYPE - used in typedefs to create =UPP type
  * REGISTER_UPP_TYPE - used in typedefs to create =UPP type
  *
  * Example:
  *
  * typedef STACK_UPP_TYPE(ModalFilterProcPtr) ModalFilterUPP;
  * typedef REGISTER_UPP_TYPE(IOCompletionProcPtr) IOCompletionUPP;
  *
  *
#if TARGET_OS_MAC && TARGET_CPU_68K && !TARGET_RT_MAC_CFM
                // classic 68k runtime 
                #define STACK_UPP_TYPE(name) name
                #define REGISTER_UPP_TYPE(name) Register68kProcPtr
#elif TARGET_OS_MAC && TARGET_RT_MAC_CFM
                // PowerPC and CFM68K runtime 
                #define STACK_UPP_TYPE(name) UniversalProcPtr
                #define REGISTER_UPP_TYPE(name) UniversalProcPtr
#else
                //other runtimes 
                #define STACK_UPP_TYPE(name) name
                #define REGISTER_UPP_TYPE(name) name
#endif


/* * * * * * * * * * * * * * *
  * CALL_=_PARAMETER_UPP - used in Call=Proc macros
  *
  * Example:
  *
  * #define CallIOCompletionProc(userRoutine, paramBlock) \
  * CALL_TWO_PARAMETER_UPP((userRoutine),
uppIOCompletionProcInfo, (paramBlock))
  *
  *


#if TARGET_OS_MAC && TARGET_RT_MAC_CFM
                #define CALL_ZERO_PARAMETER_UPP( upp, procInfo)
CallUniversalProc(upp, procInfo)
#else
                #define CALL_ZERO_PARAMETER_UPP( upp, procInfo) (*(upp))()
#endif
Post a followup to this message 
 

 Return to the comp.compilers page. 
 Search the comp.compilers archives again.*/
#if TARGET_OS_MAC && TARGET_CPU_68K && !TARGET_RT_MAC_CFM
                // classic 68k runtime 
                #define STACK_UPP_TYPE(name) name
                #define REGISTER_UPP_TYPE(name) Register68kProcPtr
#elif TARGET_OS_MAC && TARGET_RT_MAC_CFM
                // PowerPC and CFM68K runtime 
                #define STACK_UPP_TYPE(name) UniversalProcPtr
                #define REGISTER_UPP_TYPE(name) UniversalProcPtr
#else
                //other runtimes 
                #define STACK_UPP_TYPE(name) name
                #define REGISTER_UPP_TYPE(name) name
#endif
