#ifndef NAVIGATION_H
#define NAVIGATION_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef TRANSLATION_H
#include <HIToolbox/Translation.h>
#endif

#ifndef MACWINDOWS_H
#include <HIToolbox/MacWindows.h>
#endif


#include <HYS/NavigationServices/Navigation.h>



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*NavReplyRecord

Contains information about user interaction with a dialog.

struct NavReplyRecord {
   UInt16 version;
   Boolean validRecord;
   Boolean replacing;
   Boolean isStationery;
   Boolean translationNeeded;
   AEDescList selection;
   ScriptCode keyScript;
   FileTranslationSpecArrayHandle fileTranslation;
   UInt32 reserved1;
   CFStringRef saveFileName;
   Boolean saveFileExtensionHidden;
   UInt8 reserved2;
   char reserved[225];
};
typedef struct NavReplyRecord NavReplyRecord;
Fields
version

Identifies the version of this structure. The structure version is represented by the constant kNavReplyRecordVersion.
validRecord

A Boolean value of true if the user closes a dialog by pressing Return or Enter, or by clicking the default button in an Open or Save dialog. If this field is false, all other fields are unused and do not contain valid data.
replacing

A Boolean value of true if the user chooses to save a file by replacing an existing file (thereby necessitating the removal or renaming of the existing file).
isStationery

A Boolean value informing your application whether the file about to be saved should be saved as a stationery document.
translationNeeded

A Boolean value indicating whether translation was or will be needed for files selected in Open and Save dialogs.
selection

For a file-opening or file-choosing dialog, this is an Apple event descriptor list (AEDescList) containing references to items selected by the user. Navigation Services creates this list, which is automatically disposed of when your application calls the NavDisposeReply function. Some dialogs may return one or more items; you can determine the number of items in the list by calling the Apple Event Manager function AECountItems. Each selected HFS file object is described in an AEDesc structure of type 'typeFSS' or 'typeFSRef'. You can coerce this descriptor into a file reference to perform operations such as opening the file. If you use one of the Carbon-compliant dialog creation functions described in“Choosing Files, Folders and Volumes” and “Saving Files”, the descriptor is of type 'typeFSS' on Mac OS 8 or 9; on Mac OS X systems, this descriptor is of type 'typeFSRef'.File-saving dialogs always return a single descriptor in the list. If you use the NavCreatePutFileDialog function, this descriptor specifies the directory where the file is to be saved. You can obtain the name for the save file from the saveFileName field. 
keyScript

The keyboard script system used for the filename.
fileTranslation

A handle to a Translation Manager structure of type FileTranslationSpec. This structure contains a corresponding translation array for each file reference returned in the selection field. When opening files, Navigation Services performs the translation automatically unless you set the kNavDontAutoTranslate flag in the dialogOptionFlags field of the NavDialogCreationOptions structure. When Navigation Services performs an automatic translation, the FileTranslationSpec structure is strictly for the Translation Manager’s use. If you turn off automatic translation, your application may use the FileTranslationSpec structure for your own translation scheme. If the user chooses a translation for a saved file, the FileTranslationSpec structure contains a single translation reference for the saved file and the translationNeeded field of the NavReplyRecord structure is set to true. The handle to the FileTranslationSpec structure is locked, so you can safely use dereferenced pointers. 
reserved1

Reserved.
saveFileName

If the reply record is filled out by a dialog created with the NavCreatePutFileDialog function, this field contains a string specifying the name of a file to be saved. This field contains the entire name of the file, regardless of whether or not any file extension is visible to the user. You can identify the directory in which the file is to be saved by checking the selection field.

This field was added in structure version 1. 
saveFileExtensionHidden

A Boolean value indicating whether the extension on the name of the saved file should be hidden. Once the file has been saved, the client call the NavCompleteSave function. NavCompleteSave hides the extension on the file. However, the client needs to know that the extension is hidden so that it can display the document name correctly in the user interface, such as in window titles and menus. This field is only used if the client has requested extension preservation using the kNavPreserveSaveFileExtension dialog option flag. This field was added in structure version 2.
reserved2

Reserved.
reserved

Reserved.
Discussion

Navigation Services uses the NavReplyRecord structure to provide your application with information about the user’s interactions with a Navigation Services dialog. If the dialog is created with the Carbon-compliant NavCreate...Dialog functions, you obtain the NavReplyRecord by calling the NavDialogGetReply function after your event-handling function receives the kNavCBUserAction event. If you create the dialog using one of the older functions, you pass the address of a NavReplyRecord directly to the function that invokes the dialog. When your application is through using the structure, remember to dispose of it by calling the function NavDisposeReply. 
Availability
Available in Mac OS X v10.0 and later.*/
struct NavReplyRecord {
   UInt16 version;
   Boolean validRecord;
   Boolean replacing;
   Boolean isStationery;
   Boolean translationNeeded;
   AEDescList selection;
   ScriptCode keyScript;
   FileTranslationSpecArrayHandle fileTranslation;
   UInt32 reserved1;
   CFStringRef saveFileName;
   Boolean saveFileExtensionHidden;
   UInt8 reserved2;
   char reserved[225];
};
typedef struct NavReplyRecord NavReplyRecord;

/*NavEventDataInfo

Provides event??handling data to your application.

union NavEventDataInfo {
   EventRecord * event;
   void * param;
};
typedef union NavEventDataInfo NavEventDataInfo;
Fields
event

A pointer to the EventRecord structure describing an event to be handled by your event-handling function. 
param

A pointer to additional event data. In most cases, this data consists of an Apple event descriptor list (AEDescList) for the file or files affected by the event described in the event field. For example, if the event consists of the user making a selection in the browser list, the AEDescList specifies the file or files selected.
Availability
Available in Mac OS X v10.0 and later.*/
union NavEventDataInfo {
   EventRecord * event;
   void * param;
};
typedef union NavEventDataInfo NavEventDataInfo;





/*NavEventData

Contains event data for Navigation Services dialogs.

struct NavEventData {
   NavEventDataInfo eventDataParms;
   SInt16 itemHit;
};
typedef struct NavEventData NavEventData;
Fields
eventDataParms

A structure of type NavEventDataInfo.
itemHit

A signed integer value. On return, this value represents the item number of the dialog item last clicked by the user. If the user clicks something other than a valid Navigation Services-generated control item, this value is -1.
Discussion

The NavEventData structure is passed to your application-defined event-handling or preview function in the eventData field of the NavCBRec structure.

The NavEventData structure contains a structure of type NavEventDataInfo. In Navigation Services 1.1 or later, the NavEventData structure also contains a field describing the dialog item last clicked by the user.
Version Notes

itemHit field added in Navigation Services 1.1.
Availability
Available in Mac OS X v10.0 and later.*/
struct NavEventData {
   NavEventDataInfo eventDataParms;
   SInt16 itemHit;
};
typedef struct NavEventData NavEventData;



/*NavDialogRef

An opaque reference to an instance of a Navigation Services dialog.

typedef struct __NavDialog * NavDialogRef;
Discussion

Your application obtains a NavDialogRef by calling one of the dialog creation functions described in ??Choosing Files, Folders and Volumes?? and ??Saving Files??. Once you obtain a valid reference, you pass it to other functions in order to display and process dialogs. When you are completely finished using the reference, dispose of it by calling the function NavDialogDispose. This data type is available in CarbonLib 1.1 and later and in Mac OS X. It replaces the NavContext data type previously used by Navigation Services. 
Availability
Available in Mac OS X v10.0 and later*/
typedef struct __NavDialog * NavDialogRef;


/*User Actions

typedef UInt32 NavUserAction;
enum {
   kNavUserActionNone = 0,
   kNavUserActionCancel = 1,
   kNavUserActionOpen = 2,
   kNavUserActionSaveAs = 3,
   kNavUserActionChoose = 4,
   kNavUserActionNewFolder = 5,
   kNavUserActionSaveChanges = 6,
   kNavUserActionDontSaveChanges = 7,
   kNavUserActionDiscardChanges = 8,
   kNavUserActionReviewDocuments = 9,
   kNavUserActionDiscardDocuments = 10
};
Constants
kNavUserActionNone

The dialog is still running or was terminated programmatically.

Available in Mac OS X v10.0 and later.
kNavUserActionCancel

The user pressed the Cancel button.

Available in Mac OS X v10.0 and later.
kNavUserActionOpen

The user pressed the Open button in a file-opening dialog.

Available in Mac OS X v10.0 and later.
kNavUserActionSaveAs

The user pressed the Save button in a file-saving dialog.

Available in Mac OS X v10.0 and later.
kNavUserActionChoose

The user pressed the Choose button in a Choose dialog.

Available in Mac OS X v10.0 and later.
kNavUserActionNewFolder

The user pressed the New Folder button in a New Folder dialog and Navigation Services created a folder.

Available in Mac OS X v10.0 and later.
kNavUserActionSaveChanges

The user pressed the Save button in a Save Changes dialog.

Available in Mac OS X v10.0 and later.
kNavUserActionDontSaveChanges

The user pressed the Don??t Save button in a Save Changes dialog.

Available in Mac OS X v10.0 and later.
kNavUserActionDiscardChanges

The user pressed the Discard button in a Discard Changes dialog.

Available in Mac OS X v10.0 and later.
kNavUserActionReviewDocuments

The user clicked the Review Unsaved button in the Review Documents dialog (used only on Mac OS X).

Available in Mac OS X v10.1 and later.
kNavUserActionDiscardDocuments

The user clicked the Discard Changes button in the Review Documents dialog (used only on Mac OS X).

Available in Mac OS X v10.1 and later.
Discussion

Navigation Services passes one of the constants defined by the NavUserAction enumeration to your application in the userAction field of a NavCBRec structure in order to indicate which action was taken by the user during a Navigation Services dialog.*/

typedef UInt32 NavUserAction;
enum {
   kNavUserActionNone = 0,
   kNavUserActionCancel = 1,
   kNavUserActionOpen = 2,
   kNavUserActionSaveAs = 3,
   kNavUserActionChoose = 4,
   kNavUserActionNewFolder = 5,
   kNavUserActionSaveChanges = 6,
   kNavUserActionDontSaveChanges = 7,
   kNavUserActionDiscardChanges = 8,
   kNavUserActionReviewDocuments = 9,
   kNavUserActionDiscardDocuments = 10
};


/*NavCBRec

Provides information you can use for event-handling and customization.

struct NavCBRec {
   UInt16 version;
   NavDialogRef context;
   WindowRef window;
   Rect customRect;
   Rect previewRect;
   NavEventData eventData;
   NavUserAction userAction;
   char reserved[218];
};
typedef struct NavCBRec NavCBRec;
typedef NavCBRec * NavCBRecPtr;
Fields
version

Identifies the version of this structure. This value is defined by the kNavCBRecVersion constant.
context

An opaque object identifying the dialog instance. 
window

An opaque object identifying the dialog??s window.
customRect

A local coordinate rectangle describing the customization area available to your application. This determines how much room your application has to install custom controls.
previewRect

A local coordinate rectangle describing the preview area available to your application??s preview function. The minimum size is 145 pixels wide by 118 pixels high.
eventData

A structure of type NavEventData. This structure provides event-specific data to your NavEventProcPtr function.
userAction

A constant specifying the action taken by the user, generating a kNavCBUserAction event. See ??User Actions?? for a description of the possible values for this field.

This field is available in CarbonLib 1.1 and later or in Mac OS X version 10.0 and later.
reserved

Reserved.*/
struct NavCBRec {
   UInt16 version;
   NavDialogRef context;
   WindowRef window;
   Rect customRect;
   Rect previewRect;
   NavEventData eventData;
   NavUserAction userAction;
   char reserved[218];
};
typedef struct NavCBRec NavCBRec;
typedef NavCBRec * NavCBRecPtr;

/*NavPreviewProcPtr

A pointer to a preview function that displays custom file previews.

typedef Boolean (*NavPreviewProcPtr)
(
   NavCBRecPtr callBackParms,
   void * callBackUD);

If you name your function MyNavPreviewProc, you would declare it like this:

Boolean MyNavPreviewProc (
   NavCBRecPtr callBackParms,
   void * callBackUD);
Parameters
callBackParms

A pointer to a NavCBRec structure. Navigation Services uses this structure to provide data needed for your function to draw the preview.
callBackUD

A pointer to a value set by your application when it calls a Navigation Services function such as NavCreateGetFileDialog. When Navigation Services calls your preview function, the callBackUD value is passed back to your application in this parameter. 
Return Value

A Boolean value. Your application returns true if your preview function successfully draws the custom file preview. If your preview function returns false, Navigation Services displays the preview if the file contains a valid 'pnot' resource. If your preview function returns false and a 'pnot' resource is not available, Navigation Services displays a blank preview area.
Discussion

Register your preview function by passing the resulting Universal Procedure Pointer (UPP) in the previewProc parameter of a Navigation Services dialog creation function. You obtain this UPP by calling the function NewNavPreviewUPP and passing a pointer to your preview-drawing function. When the user selects a file, Navigation Services calls your preview-drawing function. Your preview function, in turn, calls the function NavCustomControl to determine if the preview area is visible and, if so, what its dimensions are.*/
typedef Boolean (*NavPreviewProcPtr)
(
   NavCBRecPtr callBackParms,
   void * callBackUD);


/*NavPreviewUPP

Defines a universal procedure pointer (UPP) to an application-defined preview function.

typedef NavPreviewProcPtr NavPreviewUPP;
Discussion

For more information, see the description of the NavPreviewProcPtr callback function.*/
typedef NavPreviewProcPtr NavPreviewUPP;










/*Event Messages

Define messages sent to your event-handling function.

typedef SInt32 NavEventCallbackMessage;
enum {
   kNavCBEvent = 0,
   kNavCBCustomize = 1,
   kNavCBStart = 2,
   kNavCBTerminate = 3,
   kNavCBAdjustRect = 4,
   kNavCBNewLocation = 5,
   kNavCBShowDesktop = 6,
   kNavCBSelectEntry = 7,
   kNavCBPopupMenuSelect = 8,
   kNavCBAccept = 9,
   kNavCBCancel = 10,
   kNavCBAdjustPreview = 11,
   kNavCBUserAction = 12,
   kNavCBOpenSelection = (long)x80000000
};
Constants
kNavCBEvent

Tells your application that an event has occurred (including an idle event), which provides an opportunity for your application to track controls, update other windows, and so forth. Your application can obtain the event record describing this event from the event field of the NavCBRec structure. The kNavCBEvent constant is the only message that needs to be processed by most applications that do not customize Open and Save dialogs.

Available in Mac OS X v10.0 and later.
kNavCBCustomize

Tells your application to supply a dialog customization request. The customRect field of the NavCBRec structure defines a rectangle in the local coordinates of the dialog; the top-left coordinates define the anchor point for a customization rectangle. If you want to customize the dialog, your application responds to the kNavCBCustomize message by setting a value in the customRect field that completes the dimensions of the customization rectangle. After your application responds, Navigation Services inspects the customRect field to determine if the requested dimensions result in a dialog that can fit on the screen. If the dimensions are too large, then Navigation Services responds by setting the rectangle to the largest size that the screen can accommodate. Your application can continue to "negotiate" by examining the customRect field and requesting a different size until Navigation Services provides an acceptable rectangle value, at which time you should create your custom control or item list. The minimum size for the customization area is 400 pixels wide by 40 pixels high.

Note: Don??t add new dialog items until your application receives the kNavCBStart event message constant.

Available in Mac OS X v10.0 and later.
kNavCBStart

Tells your application that a dialog is ready to be displayed. After receiving the kNavCBCustomize event message constant, your event-handling function should wait for the kNavCBStart event message constant to ensure that your application can safely add dialog items. No additional data is provided to your application with this constant.

Available in Mac OS X v10.0 and later.
kNavCBTerminate

Tells your application that the dialog is about to be closed, which means you must remove any user-interface items that were created in response to the kNavCBStart message. You can determine which user action closed the dialog by checking the userAction field of the NavCBRec structure.

Available in Mac OS X v10.0 and later.
kNavCBAdjustRect

Tells your application that the dialog has been resized and the customization rectangle has been accordingly resized. Use the customRect field from the NavCBRec structure to determine the new customization rectangle size. Your application does not need to offset the controls; Navigation Services moves them automatically. Your application is responsible for any redrawing of the controls or handling events beyond moving the controls, however.

Available in Mac OS X v10.0 and later.
kNavCBNewLocation

Tells your application that a new location is being viewed in the dialog. The param field of the NavCBRec structure contains a pointer to an AEDesc structure of type 'typeFSS' describing the new location. This pointer is valid only during the execution of your event-handling function.

Available in Mac OS X v10.0 and later.
kNavCBShowDesktop

Tells your application that the Open or Save dialog is showing the desktop view, consisting of the composite of all desktop folders from all mounted volumes. The param field of the NavCBRec structure contains a pointer to an AEDescList structure identifying the desktop location. This pointer is valid only during the execution of your event-handling function.

Available in Mac OS X v10.0 and later.
kNavCBSelectEntry

Tells your application that an entry in the browser list has been selected or deselected by the user. The param field of the NavEventDataInfo structure contains a pointer to an AEDescList record of type 'typeFSS' identifying the current selection. If the user deselects the current selection, the AEDescList record contains an empty reference. This pointer is valid only during the execution of your event-handling function.

Available in Mac OS X v10.0 and later.
kNavCBPopupMenuSelect

Tells your application that a selection was made from the Open dialog??s Show pop-up menu or Save dialog??s Format pop-up menu. TheNavCBRec.eventData.eventDataParms.param field contains a pointer to a NavMenuItemSpec structure describing the pop-up menu item selected. If the dialog was created using the Carbon-only NavCreateXXXDialog APIs, then the menuType field of the NavMenuItemSpec structure is set to the index into the client's CFArray of popupExtension strings in the NavDialogCreationOptions structure. This data is valid only during the execution of your event-handling function.

Available in Mac OS X v10.0 and later.
kNavCBAccept

Tells your application that the user has pressed the Accept button.

Available in Mac OS X v10.0 and later.
kNavCBCancel

Tells your application that the user has pressed the Cancel button.

Available in Mac OS X v10.0 and later.
kNavCBAdjustPreview

Tells your application that the user has toggled the preview area on or off. The param field of the NavCBRec structure contains a pointer to a Boolean value of true if the preview area is toggled on and false if toggled off. This information is useful if your application creates custom controls in the preview area.

Available in Mac OS X v10.0 and later.
kNavCBUserAction

(Available only in CarbonLib 1.1 and later and in Mac OS X version 10.0 and later.) Tells your application that the user has taken an action. To determine which action the user took, call the NavDialogGetUserAction function.

Available in Mac OS X v10.0 and later.
kNavCBOpenSelection

(Navigation Services 2.0 or later.) Tells your application that the user has opened a file or chosen a file object. After detecting this constant, you can call the NavCustomControl function and specify one of the NavActionState constants, described in ??Action State Constants??, in order to block the opening or choosing action.

Available in Mac OS X v10.0 and later.*/
typedef SInt32 NavEventCallbackMessage;
enum {
   kNavCBEvent = 0,
   kNavCBCustomize = 1,
   kNavCBStart = 2,
   kNavCBTerminate = 3,
   kNavCBAdjustRect = 4,
   kNavCBNewLocation = 5,
   kNavCBShowDesktop = 6,
   kNavCBSelectEntry = 7,
   kNavCBPopupMenuSelect = 8,
   kNavCBAccept = 9,
   kNavCBCancel = 10,
   kNavCBAdjustPreview = 11,
   kNavCBUserAction = 12,
   kNavCBOpenSelection = (long)'x80000000'
};

/*NavEventProcPtr

A pointer to an event-handling function that handles events such as window updating and resizing.

typedef void (*NavEventProcPtr) (
   NavEventCallbackMessage callBackSelector,
   NavCBRecPtr callBackParms,
   void * callBackUD);

If you name your function MyNavEventProc, you would declare it like this:

void MyNavEventProc (
   NavEventCallbackMessage callBackSelector,
   NavCBRecPtr callBackParms,
   void * callBackUD);
Parameters
callBackSelector

One of the values specified by the NavEventCallbackMessage data type. These values indicate which type of event your function must respond to. For a description of the constants that represent these values, see ??Event Messages??. 
callBackParms

A pointer to a NavCBRec structure. Your application uses the data supplied in this structure to process the event.
callBackUD

A pointer to a value set by your application when it calls a Navigation Services dialog creation function. When Navigation Services calls your event-handling function, the callBackUD value is passed back to your application in this parameter. 
Discussion

Register your event-handling function by passing a Universal Procedure Pointer (UPP) in the eventProc parameter of a Navigation Services dialog creation function. You obtain this UPP by calling the function NewNavEventUPP and passing a pointer to your event-handling function. If you determine that an event is appropriate for your event-handling function, you can call other functions to handle custom control drawing.

When events involve controls, your event-handling function must respond to events only for your application-defined controls. To determine which control is affected by an event, pass the kNavCtlGetFirstControlID constant, described in ??Custom Control Settings??, in the selector parameter of the function NavCustomControl.*/
typedef void (*NavEventProcPtr) (
   NavEventCallbackMessage callBackSelector,
   NavCBRecPtr callBackParms,
   void * callBackUD);


/*Object Filtering Constants

Inform you which part of a dialog contains object being filtered.

typedef SInt16 NavFilterModes;
enum {
   kNavFilteringBrowserList = 0,
   kNavFilteringFavorites = 1,
   kNavFilteringRecents = 2,
   kNavFilteringShortCutVolumes = 3,
   kNavFilteringLocationPopup = 4
};
Constants
kNavFilteringBrowserList

The browser list contains the object being filtered.

Available in Mac OS X v10.0 and later.
kNavFilteringFavorites

The Favorites pop-up menu contains the object being filtered.

Available in Mac OS X v10.0 and later.
kNavFilteringRecents

The Recent pop-up menu contains the object being filtered.

Available in Mac OS X v10.0 and later.
kNavFilteringShortCutVolumes

The Shortcuts pop-up menu contains the object being filtered.

Available in Mac OS X v10.0 and later.
kNavFilteringLocationPopup

The object being filtered is the path described by the Location menu.

Available in Mac OS X v10.0 and later.
Discussion

Navigation Services passes one of the constants defined by the NavFilterModes data type to the filterMode parameter of your application-defined filter function to tell your application whether the browser list or one of the navigation option pop-up menus contains the object currently being filtered.*/
typedef SInt16 NavFilterModes;
enum {
   kNavFilteringBrowserList = 0,
   kNavFilteringFavorites = 1,
   kNavFilteringRecents = 2,
   kNavFilteringShortCutVolumes = 3,
   kNavFilteringLocationPopup = 4
};


/*NavObjectFilterProcPtr

A pointer to a filter function that determines whether file objects should be displayed in the browser list and navigation menus.

typedef Boolean (*NavObjectFilterProcPtr)
(
   AEDesc * theItem,
   void * info,
   void * callBackUD,
   NavFilterModes filterMode);

If you name your function MyNavObjectFilterProc, you would declare it like this:

Boolean MyNavObjectFilterProc (
   AEDesc * theItem,
   void * info,
   void * callBackUD,
   NavFilterModes filterMode);
Parameters
theItem

A pointer to an Apple event descriptor structure (AEDesc). Navigation Services uses this structure to provide information about the object being passed to your filter function. Always check the Apple event descriptor type before deciding if an object needs to be filtered. Never assume that an object is a file specification, because the browser or pop-up menus may contain objects of other types. Make sure that your function only returns false if it recognizes the object. 
info

A pointer to a NavFileOrFolderInfo structure. Navigation Services uses this structure to provide file or folder information about the item being passed to your filter function. This information is only valid for objects of descriptor types 'typeFSS' or 'typeFSRef'. 
callBackUD

A pointer to a value set by your application when it calls a Navigation Services dialog creation function. When Navigation Services calls your filter function, the callBackUD value is passed back to your application in this parameter.
filterMode

A value representing which list of objects is currently being filtered. For a description of the constants used to represent these values, see ??Object Filtering Constants??. 
Return Value

A Boolean value. If your application returns true, Navigation Services displays the object. If your application returns false, Navigation Services displays the object as dimmed. 
Discussion

Register your filter function by passing a Universal Procedure Pointer (UPP) in the filterProc parameter of a dialog creation function. You obtain this UPP by calling the function NewNavObjectFilterUPP and passing a pointer to your filter function. Navigation Services calls your filter function to determine whether a file object should be displayed in the browser list or the pop-up menus.

If you use a filter function in conjunction with built-in translation, you should provide a list of file types to inform Navigation Services which document types your application can open. You can do so using the following methods:
Call the NavDialogSetFilterTypeIdentifiers function on an existing dialog to filter by uniform type identifiers. This method is preferable in Mac OS X v10.4 and later. 
Provide a list of allowable OSType file types in the inTypeList parameter of a file-opening function such as NavCreateGetFileDialog

If you provide a list of file types, your filter callback is called only for the files that match the specified type list. For example, if you wanted to enable only text files below a certain size, you could use NavDialogSetFilterTypeIdentifiers to enable only text files, and then use a filter callback to screen for file size. You should make sure that your filter callback doesn??t automatically eliminate a document type in the filter list (for example, if the list allows JPEG files and the callback eliminates everything but PICT files). This is to ensure that the user can always see some files when a particular file type is selected from the Enable popup menu. 

If your filter function returns a result of true, Navigation Services displays the object. Note that this is the opposite of Standard File filter functions.*/
typedef Boolean (*NavObjectFilterProcPtr)
(
   AEDesc * theItem,
   void * info,
   void * callBackUD,
   NavFilterModes filterMode);




/*NavEventUPP

Defines a universal procedure pointer (UPP) to an application-defined event??handling function.

typedef NavEventProcPtr NavEventUPP;
Discussion

For more information, see the description of the NavEventProcPtr callback function.*/
typedef NavEventProcPtr NavEventUPP;


/*NavObjectFilterUPP

Defines a universal procedure pointer (UPP) to an application-defined filter function.

typedef NavObjectFilterProcPtr NavObjectFilterUPP;
Discussion

For more information, see the description of the NavObjectFilterProcPtr callback function.*/
typedef NavObjectFilterProcPtr NavObjectFilterUPP;









/*NavDialogRef

An opaque reference to an instance of a Navigation Services dialog.

typedef struct __NavDialog * NavDialogRef;
Discussion

Your application obtains a NavDialogRef by calling one of the dialog creation functions described in ??Choosing Files, Folders and Volumes?? and ??Saving Files??. Once you obtain a valid reference, you pass it to other functions in order to display and process dialogs. When you are completely finished using the reference, dispose of it by calling the function NavDialogDispose. This data type is available in CarbonLib 1.1 and later and in Mac OS X. It replaces the NavContext data type previously used by Navigation Services. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 NavDialogOptionFlags;
enum {
   kNavDefaultNavDlogOptions = 0x000000E4,
   kNavNoTypePopup = 0x00000001,
   kNavDontAutoTranslate = 0x00000002,
   kNavDontAddTranslateItems = 0x00000004,
   kNavAllFilesInPopup = 0x00000010,
   kNavAllowStationery = 0x00000020,
   kNavAllowPreviews = 0x00000040,
   kNavAllowMultipleFiles = 0x00000080,
   kNavAllowInvisibleFiles = 0x00000100,
   kNavDontResolveAliases = 0x00000200,
   kNavSelectDefaultLocation = 0x00000400,
   kNavSelectAllReadableItem = 0x00000800,
   kNavSupportPackages = 0x00001000,
   kNavAllowOpenPackages = 0x00002000,
   kNavDontAddRecents = 0x00004000,
   kNavDontUseCustomFrame = 0x00008000,
   kNavDontConfirmReplacement = 0x00010000,
   kNavPreserveSaveFileExtension = 0x00020000
};typedef struct __NavDialog * NavDialogRef;

/*alog Configuration Options

Specify dialog configuration options.

typedef UInt32 NavDialogOptionFlags;
enum {
   kNavDefaultNavDlogOptions = 0x000000E4,
   kNavNoTypePopup = 0x00000001,
   kNavDontAutoTranslate = 0x00000002,
   kNavDontAddTranslateItems = 0x00000004,
   kNavAllFilesInPopup = 0x00000010,
   kNavAllowStationery = 0x00000020,
   kNavAllowPreviews = 0x00000040,
   kNavAllowMultipleFiles = 0x00000080,
   kNavAllowInvisibleFiles = 0x00000100,
   kNavDontResolveAliases = 0x00000200,
   kNavSelectDefaultLocation = 0x00000400,
   kNavSelectAllReadableItem = 0x00000800,
   kNavSupportPackages = 0x00001000,
   kNavAllowOpenPackages = 0x00002000,
   kNavDontAddRecents = 0x00004000,
   kNavDontUseCustomFrame = 0x00008000,
   kNavDontConfirmReplacement = 0x00010000,
   kNavPreserveSaveFileExtension = 0x00020000
};
Constants
kNavDefaultNavDlogOptions

Tells Navigation Services to use default configuration options. These default options include:
no custom control titles
no banner or prompt message
automatic resolution of aliases
support for file previews
no display of invisible file objects
support for multiple file selection
support for stationery
no package support
all chosen items added to Recent list
customization area is framed

Available in Mac OS X v10.0 and later.
kNavNoTypePopup

Tells Navigation Services not to display the Show pop-up menu in the Open dialog or the Format pop-up menu in the Save dialog.

Available in Mac OS X v10.0 and later.
kNavDontAutoTranslate

Tells Navigation Services not to do automatic file translation. Normally a file chosen in an Open dialog that requires translation is automatically translated. Navigation Services informs your application that a file needs translating by setting the translationNeeded field of the NavReplyRecord structure to true. A translation specification array specified in the fileTranslation field of the NavReplyRecord structure contains the associated translation specification records. When you set the kNavDontAutoTranslate flag, your application is responsible for translation, either by calling the function NavTranslate or by performing the translation itself.

Available in Mac OS X v10.0 and later.
kNavDontAddTranslateItems

Tells Navigation Services not to display file translation options in the Show pop-up menu.

Available in Mac OS X v10.0 and later.
kNavAllFilesInPopup

Tells Navigation Services to add a pop-up menu item called All Documents, so the user can see a display of all files in the current directory.

Available in Mac OS X v10.0 and later.
kNavAllowStationery

Tells Navigation Services to display a Stationery Option command in the Format pop-up menu of Save dialogs, so users can choose to save a file as a document or as stationery. This is a default option.

Available in Mac OS X v10.0 and later.
kNavAllowPreviews

Tells Navigation Services to provide previews, when available, of selected files. This is a default option.

Available in Mac OS X v10.0 and later.
kNavAllowMultipleFiles

Tells Navigation Services to allow users to select and open multiple files in the browser list by shift-clicking or using the Select All command. If you don??t specify this constant, users can select multiple files for drag-and-drop operations, but the default button (normally titled Open) is disabled when multiple items are selected. Note that the user cannot add folders or volumes to a multiple selection.

Available in Mac OS X v10.0 and later.
kNavAllowInvisibleFiles

Tells Navigation Services to show invisible file objects in the browser list.

Available in Mac OS X v10.0 and later.
kNavDontResolveAliases

Tells Navigation Services not to resolve any alias selected by the user. If the user selects an alias with this option set, the file system specification returned by Navigation Services designates the alias file instead of its referenced original.

Available in Mac OS X v10.0 and later.
kNavSelectDefaultLocation

Tells Navigation Services to select the default location in the browser list. By default, Navigation Services will open the browser list with the default location displayed, not selected. For example, if you define the System Folder as the default location and specify the kNavSelectDefaultLocation constant, the System Folder appears as the current selection in the browser list. Without this constant, the browser list displays the contents of the System Folder.

Available in Mac OS X v10.0 and later.
kNavSelectAllReadableItem

Tells Navigation Services to show All Readable Documents as the default selection in the Show pop-up menu when the Open dialog is first displayed. If you do not specify this constant, Navigation Services shows the All [AppName] Documents menu item as the default selection in the Show pop-up menu when the Open dialog is first displayed.

Available in Mac OS X v10.0 and later.
kNavSupportPackages

(Available in Navigation Services 2.0 and later.) Tells Navigation Services to allow packages to be displayed in the browser list.

Available in Mac OS X v10.0 and later.
kNavAllowOpenPackages

(Available in Navigation Services 2.0 and later.) Tells Navigation Services to allow packages to be opened and navigated in the browser list.

Available in Mac OS X v10.0 and later.
kNavDontAddRecents

(Available in Navigation Services 2.0 and later.) Tells Navigation Services not to add file objects to the Recent list after a dialog is closed. This is useful if you want to allow users to choose long lists of items without cluttering up the Recent list.

Available in Mac OS X v10.0 and later.
kNavDontUseCustomFrame

(Available in Navigation Services 2.0 and later.) Tells Navigation Services not to draw a bevelled border around the customization area. The border is drawn by default, so you must specify this constant if you want to turn it off.

Note: Keep in mind that turning off the border may affect the placement of any controls you create in the customization area. This means your controls may appear differently in different versions of Navigation Services.

Available in Mac OS X v10.0 and later.
kNavDontConfirmReplacement

(Mac OS X only.) Tells Navigation Services not to display an alert when the user attempts to save a file over another file with the same name.

Available in Mac OS X v10.0 and later.
kNavPreserveSaveFileExtension

(Available in Navigation Services 3.1 and later.) Tells Navigation Services that the extension in the default filename should be preserved between dialog invocations and is initially hidden.

Available in Mac OS X v10.1 and later.*/

/*NavObjectFilterUPP

Defines a universal procedure pointer (UPP) to an application-defined filter function.

typedef NavObjectFilterProcPtr NavObjectFilterUPP;
Discussion

For more information, see the description of the NavObjectFilterProcPtr callback function.*/
struct NavDialogCreationOptions {
   UInt16 version;
   NavDialogOptionFlags optionFlags;
   Point location;
   CFStringRef clientName;
   CFStringRef windowTitle;
   CFStringRef actionButtonLabel;
   CFStringRef cancelButtonLabel;
   CFStringRef saveFileName;
   CFStringRef message;
   UInt32 preferenceKey;
   CFArrayRef popupExtension;
   WindowModality modality;
   WindowRef parentWindow;
   char reserved[16];
};
typedef struct NavDialogCreationOptions NavDialogCreationOptions;


/*NavDialogCreationOptions

Contains dialog configuration settings you can pass to Navigation Services dialog creation functions.

struct NavDialogCreationOptions {
   UInt16 version;
   NavDialogOptionFlags optionFlags;
   Point location;
   CFStringRef clientName;
   CFStringRef windowTitle;
   CFStringRef actionButtonLabel;
   CFStringRef cancelButtonLabel;
   CFStringRef saveFileName;
   CFStringRef message;
   UInt32 preferenceKey;
   CFArrayRef popupExtension;
   WindowModality modality;
   WindowRef parentWindow;
   char reserved[16];
};
typedef struct NavDialogCreationOptions NavDialogCreationOptions;
Fields
version

Identifies the version of this structure. The structure version is represented by the kNavDialogCreationOptionsVersion constant.
optionFlags

One of several constants defined by the NavDialogOptionFlags data type as described in ??Dialog Configuration Options??. 
location

A point describing the location of the upper-left corner of the dialog window, in global coordinates. If you set this field to (-1,-1), then the dialog window appears in the same location as when it was last closed. The size and location of the dialog window is persistent, but defaults to opening in the middle of the main screen if any portion is not visible when opened at the persistent location and size.

This field is ignored for sheet dialogs.
clientName

A string that identifies your application in the window title of file dialogs and in the message displayed for the Save Changes, Review Changes, and Ask Discard changes alerts. 

On Mac OS 8 and 9, Navigation Services cannot maintain persistence information for your application if you do not provide this string.

windowTitle

A string that you can provide to override the default window title. If you pass NULL, the default window title is used. 
actionButtonLabel

An alternative button title for the dialog??s default button. If you pass NULL, the button uses the default label (Open or Save, for example.
cancelButtonLabel

An alternative button title for the dialog??s Cancel button. If you pass NULL, the default button title is used.
saveFileName

The default filename for a file to be saved (Save dialog only). If you pass NULL, the filename field is blank.
message

For the file dialogs, a string for the banner, or prompt, below the browser list. This message can provide more descriptive instructions for the user. If you pass NULL, no banner appears and the browser list expands to fill that area.

For the Save Changes, Review Changes and Ask Discard Changes alerts, a string specifying a custom message that replaces the default message.
preferenceKey

An application-defined value that identifies which set of dialog preferences Navigation Services should use. If your application maintains multiple sets of preferences for a particular type of dialog, you can determine which set is active by specifying the appropriate value in the preferenceKey field. For example, an application may provide one set of preferences when it calls the function to open text files and a different set of preferences when opening movie files. If you do not wish to provide a preference key, specify 0 for the preferenceKey value.
popupExtension

A reference to an array of menu item strings. These strings are used to add extra menu items to the Show pop-up menu in an Open dialog or to the Format pop-up menu in a Save dialog. Your application can use this array to add additional document types to be opened or saved, or different ways of saving a file (with or without line breaks, for example). 
modality

This value allows you to specify the modality of the dialog. The default modality for all dialogs is kWindowModalityAppModal. If you specify the kWindowModalityWindowModal constant to make a dialog appear as a sheet, you must provide a valid window reference in the parentWindow field. If you specify the kWindowModalityWindowModal constant on Mac OS 8 or 9, the modality is set to kWindowModalityAppModal.

This field is available in CarbonLib 1.1 and later or in Mac OS X version 10.0 and later.
parentWindow

A reference to the parent window for a sheet.

This field is available in CarbonLib 1.1 and later or in Mac OS X version 10.0 and later.
reserved

Reserved.
Discussion

When you create a Navigation Services dialog, using one of the NavCreate...Dialog creation functions, you must supply a NavDialogCreationOptions structure to specify the appearance and behavior of the dialog. You can initialize a NavDialogCreationOptions structure using the NavGetDefaultDialogCreationOptions function; this fills out the structure with the default dialog creation settings.
Availability
Available in Mac OS X v10.0 and later.*/

/*NavDialogDispose

Disposes of a dialog reference.

void NavDialogDispose (
   NavDialogRef inDialog
);
Parameters
inDialog

A Navigation Services dialog reference previously obtained by your application. 
Discussion

Use this function to dispose of a dialog reference when you are completely finished with its associated dialog. You may call NavDialogDispose from within your application-defined event-handling function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

void NavDialogDispose (
   NavDialogRef inDialog
);

/*NewNavObjectFilterUPP

Creates a new universal procedure pointer to your application-defined filter function.

NavObjectFilterUPP NewNavObjectFilterUPP (
   NavObjectFilterProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your filter function. 
Return Value

On return, a universal procedure pointer (UPP) to the filter function. See the description of the NavObjectFilterUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
NavObjectFilterUPP NewNavObjectFilterUPP (
   NavObjectFilterProcPtr userRoutine
);

/*NavCreateChooseFileDialog

Creates a Choose File dialog, which prompts the user to select a single file as the target of an operation.

OSStatus NavCreateChooseFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inTypeList

A structure specifying a creator signature and a list of file types to show in the Choose File dialog.
inEventProc

A Universal Procedure Pointer (UPP) to your application??s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inPreviewProc

A Universal Procedure Pointer (UPP) to your application??s preview function. You may specify NULL if you don??t need to register a preview function. For more information on preview functions, see NavPreviewProcPtr.
inFilterProc

A Universal Procedure Pointer (UPP) to your application??s filter function. You may specify NULL if you don??t need to register a filter function. For more information on filter functions, see NavObjectFilterProcPtr.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of a Choose File dialog, A pointer to a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See ??Navigation Services Result Codes??. A result code.
Discussion

Once you have successfully created the Choose File dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavChooseFile function and adds support for Unicode and new window modalities.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavCreateChooseFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);

/*NavDisposeReply

Releases the memory allocated for a NavReplyRecord structure after your application has finished using the structure.

OSErr NavDisposeReply (
   NavReplyRecord * reply
);
Parameters
reply

A pointer to a structure of type NavReplyRecord that your application has created.
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

If your application calls a Navigation Services function that uses a structure of type NavReplyRecord, you must use the NavDisposeReply function afterward to release the memory allotted for the NavReplyRecord structure. 
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSErr NavDisposeReply (
   NavReplyRecord * reply
);

/*NavDialogRun

Displays a previously created dialog.

OSStatus NavDialogRun (
   NavDialogRef inDialog
);
Parameters
inDialog

A reference to a previously created Navigation Services dialog. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

You must create a dialog before displaying it. To create a dialog, call one of the NavCreate...Dialog functions described in “Choosing Files, Folders and Volumes” and “Saving Files”. If you specify an application-modal or system-modal dialog, the NavDialogRun function returns after the dialog is dismissed. If you specify a window-modal dialog (sheet) or a modeless dialog, the NavDialogRun function returns immediately; in order to know when the dialog has been dismissed, you must supply an event-handling function and watch for the kNavCBUserAction event. 

After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. 
Version Notes

On Mac OS 9 and earlier, all Navigation Services dialogs are modal, even if a window-modal or modeless dialog is requested. However, the kNavCBUserAction event is still sent to your event-handling function. It is possible to use a single programming model on both Mac OS 9 and on Mac OS X, provided you assume that the NavDialogRun function returns immediately after displaying the dialog.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavDialogRun (
   NavDialogRef inDialog
);

/*NavDialogGetReply

Reports the results of a dialog session (unless cancelled or programmatically terminated).

OSStatus NavDialogGetReply (
   NavDialogRef inDialog,
   NavReplyRecord * outReply
);
Parameters
inDialog

A reference to a previously created dialog. 
outReply

A pointer to a reply record you allocate to be filled out by Navigation Services. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

Call this function when you obtain a value other than kNavUserActionCancel or kNavUserActionNone from the NavDialogGetUserAction function. Upon completion of the NavDialogGetReply function, Navigation Services fills out the specified reply record with information about the dialog session. When you are finished with the reply record, remember to dispose of it by calling the NavDisposeReply function. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavDialogGetReply (
   NavDialogRef inDialog,
   NavReplyRecord * outReply
);

/*NavGetDefaultDialogCreationOptions

Determines the default attributes or behavior for dialogs. 

OSStatus NavGetDefaultDialogCreationOptions (
   NavDialogCreationOptions * outOptions
);
Parameters
outOptions

A pointer to a NavDialogCreationOptions structure that you provide. On return, Navigation Services fills out the structure with default dialog configuration values.
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

This function gives you a simple way to initialize a NavDialogCreationOptions structure and set default options before creating a Navigation Services dialog. After you create the NavDialogCreationOptions structure, you can change the configuration options before you call one of the dialog creation functions. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

OSStatus NavGetDefaultDialogCreationOptions (
   NavDialogCreationOptions * outOptions
);

/*NewNavEventUPP

Creates a new universal procedure pointer to your application-defined event–handling function.

NavEventUPP NewNavEventUPP (
   NavEventProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event–handling function. 
Return Value

On return, a universal procedure pointer (UPP) to the event–handling function. See the description of the NavEventUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
NavEventUPP NewNavEventUPP (
   NavEventProcPtr userRoutine
);

/*NavCreateChooseObjectDialog

Creates a Choose Object dialog, which prompts the user to select a file. folder or volume.

OSStatus NavCreateChooseObjectDialog (
   const NavDialogCreationOptions * inOptions,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inEventProc

A Universal Procedure Pointer (UPP) to your application’s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inPreviewProc

A Universal Procedure Pointer (UPP) to your application’s preview function. You may specify NULL if you don’t need to register a preview function. For more information on preview functions, see NavPreviewProcPtr.
inFilterProc

A Universal Procedure Pointer (UPP) to your application’s filter function. You may specify NULL if you don’t need to register a filter function. For more information on filter functions, see NavObjectFilterProcPtr.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of a Choose Object dialog, a pointer to a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See “Navigation Services Result Codes”. A result code.
Discussion

Once you have successfully created the Choose Object dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavChooseObject function and adds support for Unicode and new window modalities.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavCreateChooseObjectDialog (
   const NavDialogCreationOptions * inOptions,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);

/*NavDialogGetUserAction

Reports the user action taken to dismiss a dialog.

NavUserAction NavDialogGetUserAction (
   NavDialogRef inDialog
);
Parameters
inDialog

A reference to a previously created dialog. 
Return Value

One of the constants defined by the NavUserAction enumeration. This value indicates the user action that dismissed the dialog. See “User Actions” for a description of the values that may be returned here.
Discussion

If the dialog has not been dismissed or if the dialog was terminated by using the kNavCtlTerminate selector with the NavCustomControl function, the NavDialogGetUserAction function returns the kNavUserActionNone constant. When you obtain a value other than kNavUserActionCancel or kNavUserActionNone after returning from a file-handling dialog, Navigation Services fills out a reply record that you can obtain with the NavDialogGetReply function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

NavUserAction NavDialogGetUserAction (
   NavDialogRef inDialog
);

/*NavCreateGetFileDialog

Creates an Open dialog, which prompts the user to select a file or files to be opened.

OSStatus NavCreateGetFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inTypeList

A structure specifying an application signature and a list of file types to show in the Open dialog.
inEventProc

A Universal Procedure Pointer (UPP) to your application’s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inPreviewProc

A Universal Procedure Pointer (UPP) to your application’s preview function. You may specify NULL if you don’t need to register a preview function. For more information on creating a preview function, see NavPreviewProcPtr.
inFilterProc

A Universal Procedure Pointer (UPP) to your application’s filter function. You may specify NULL if you don’t need to register a filter function. For more information on creating a filter function, see NavObjectFilterProcPtr.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of an Open dialog instance, this value specifies a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See “Navigation Services Result Codes”. A result code.
Discussion

Once you have successfully created the Open dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavGetFile function and adds support for Unicode and new window modalities. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

OSStatus NavCreateGetFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);

#ifdef __cplusplus
}
#endif

#endif