#ifndef OC_CFBUNDLE_H
#define OC_CFBUNDLE_H
#endif 

/*CFBundleGetMainBundle

Returns an applications main bundle.

CFBundleRef CFBundleGetMainBundle ();
Return Value

A CFBundle object representing the applications main bundle, or NULL if it is not possible to create a bundle. Ownership follows the Get Rule.
Discussion

CFBundle creates a main bundle whenever it possibly can, even for unbundled apps. There are a few situations in which it is not possible, so you should check the return value against NULL, but this happens only in exceptional circumstances.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

/*CFBundleRef CFBundleGetMainBundle ();

CFBundleGetVersionNumber

Returns a bundles version number.

UInt32 CFBundleGetVersionNumber (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. The bundles version number can be number or a string of the standard form 2.5.3d5. 
Return Value

A Mac OS vers resource style version number. If the bundles version number is a number, it is interpreted as the unsigned long integer format defined by the vers resource on Mac OS 9. If it is a string, it is automatically converted to the numeric representation, where the major version number is restricted to 2 BCD digits (in other words, it must be in the range 0-99) and the minor and bug fix version numbers are each restricted to a single BCD digit (0-9). See Technical Note TN1132 for more details.
Discussion

This function is only supported for the Mac OS vers resource style version numbers. Where other version number styles?namely X, or X.Y, or X.Y.Z?are used, you can use CFBundleGetValueForInfoDictionaryKey with the key kCFBundleVersionKey to extract the version number as a string from the bundles information dictionary.

Some version numbers of the form X, X.Y, and X.Y.Z may work with this function, if X <= 99, Y <= 9, and Z <= 9. Thus a version number 76.5.4 will work, but 76.12 will not work.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
UInt32 CFBundleGetVersionNumber (
   CFBundleRef bundle
);

/*CFBundleGetMainBundle

Returns an applications main bundle.

CFBundleRef CFBundleGetMainBundle ();
Return Value

A CFBundle object representing the applications main bundle, or NULL if it is not possible to create a bundle. Ownership follows the Get Rule.
Discussion

CFBundle creates a main bundle whenever it possibly can, even for unbundled apps. There are a few situations in which it is not possible, so you should check the return value against NULL, but this happens only in exceptional circumstances.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFBundleRef CFBundleGetMainBundle ();