
#ifndef OC_CFSTRING_H
 #define OC_CFSTRING_H
#endif

#ifndef __TYPES_H
#include <CoreFoundation/Types.h>
#endif

#ifndef CFBASE_H
#include <CoreFoundation/CFBase.h>
#endif

#ifndef CFSTRING_H
#include <CoreFoundation/CFString.h>
#endif

/*CFStringEncoding

An integer type for constants used to specify supported string encodings in various CFString functions.

typedef UInt32 CFStringEncoding;
Discussion

This type is used to define the constants for the built-in encodings (see Built-in String Encodings for a list) and for platform-dependent encodings (see External String Encodings). If CFString does not recognize or support the string encoding of a particular string, CFString functions will identify the strings encoding as kCFStringEncodingInvalidId.
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 CFStringEncoding;


/*CFAllocatorCopyDescriptionCallBack

A prototype for a function callback that provides a description of the specified data.

typedef CFStringRef (*CFAllocatorCopyDescriptionCallBack) (
   const void *info
);

If you name your function MyCallBack, you would declare it like this:

CFStringRef MyCallBack (
   const void *info
);
Parameters
info

An untyped pointer to program-defined data.
Return Value

A CFString object that describes the allocator. The caller is responsible for releasing this object.
Discussion

A prototype for a function callback that provides a description of the data pointed to by the info field. In implementing this function, return a reference to a CFString object that describes your allocator, particularly some characteristics of your program-defined data.*/
typedef CFStringRef (*CFAllocatorCopyDescriptionCallBack) (
   const void *info
);


/*Built-in String Encodings

CFStringEncoding constants for the supported encodings that are built-in on all platforms on which Mac OS X runs.

enum {
   kCFStringEncodingMacRoman = 0,
   kCFStringEncodingWindowsLatin1 = 0x0500,
   kCFStringEncodingISOLatin1 = 0x0201,
   kCFStringEncodingNextStepLatin = 0x0B01,
   kCFStringEncodingASCII = 0x0600,
   kCFStringEncodingUnicode = 0x0100,
   kCFStringEncodingUTF8 = 0x08000100,
   kCFStringEncodingNonLossyASCII = 0x0BFF,
   
   kCFStringEncodingUTF16 = 0x0100,
   kCFStringEncodingUTF16BE = 0x10000100,
   kCFStringEncodingUTF16LE = 0x14000100,
   kCFStringEncodingUTF32 = 0x0c000100,
   kCFStringEncodingUTF32BE = 0x18000100,
   kCFStringEncodingUTF32LE = 0x1c000100
} CFStringBuiltInEncodings;
Constants
kCFStringEncodingMacRoman

An encoding constant that identifies the Mac Roman encoding.

Available in Mac OS X v10.0 and later.
kCFStringEncodingWindowsLatin1

An encoding constant that identifies the Windows Latin 1 encoding (ANSI codepage 1252).

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatin1

An encoding constant that identifies the ISO Latin 1 encoding (ISO 8859-1)

Available in Mac OS X v10.0 and later.
kCFStringEncodingNextStepLatin

An encoding constant that identifies the NextStep/OpenStep encoding.

Available in Mac OS X v10.0 and later.
kCFStringEncodingASCII

An encoding constant that identifies the ASCII encoding (decimal values 0 through 127).

Available in Mac OS X v10.0 and later.
kCFStringEncodingUnicode

An encoding constant that identifies the Unicode encoding. 

Available in Mac OS X v10.0 and later.
kCFStringEncodingUTF8

An encoding constant that identifies the UTF 8 encoding.

Available in Mac OS X v10.0 and later.
kCFStringEncodingNonLossyASCII

An encoding constant that identifies non-lossy ASCII encoding.

Available in Mac OS X v10.0 and later.
kCFStringEncodingUTF16

An encoding constant that identifies kTextEncodingUnicodeDefault + kUnicodeUTF16Format encoding (alias of kCFStringEncodingUnicode).

Available in Mac OS X v10.4 and later.
kCFStringEncodingUTF16BE

An encoding constant that identifies kTextEncodingUnicodeDefault + kUnicodeUTF16BEFormat encoding.

Available in Mac OS X v10.4 and later.
kCFStringEncodingUTF16LE

An encoding constant that identifies kTextEncodingUnicodeDefault + kUnicodeUTF16LEFormat encoding.

Available in Mac OS X v10.4 and later.
kCFStringEncodingUTF32

An encoding constant that identifies kTextEncodingUnicodeDefault + kUnicodeUTF32Format encoding.

Available in Mac OS X v10.4 and later.
kCFStringEncodingUTF32BE

An encoding constant that identifies kTextEncodingUnicodeDefault + kUnicodeUTF32BEFormat encoding.

Available in Mac OS X v10.4 and later.
kCFStringEncodingUTF32LE

An encoding constant that identifies kTextEncodingUnicodeDefault + kUnicodeUTF32LEFormat encoding.

Available in Mac OS X v10.4 and later.
Declared In
CFString.h*/

enum {
   kCFStringEncodingMacRoman = 0,
   kCFStringEncodingWindowsLatin1 = 0x0500,
   kCFStringEncodingISOLatin1 = 0x0201,
   kCFStringEncodingNextStepLatin = 0x0B01,
   kCFStringEncodingASCII = 0x0600,
   kCFStringEncodingUnicode = 0x0100,
   kCFStringEncodingUTF8 = 0x08000100,
   kCFStringEncodingNonLossyASCII = 0x0BFF,
   
   kCFStringEncodingUTF16 = 0x0100,
   kCFStringEncodingUTF16BE = 0x10000100,
   kCFStringEncodingUTF16LE = 0x14000100,
   kCFStringEncodingUTF32 = 0x0c000100,
   kCFStringEncodingUTF32BE = 0x18000100,
   kCFStringEncodingUTF32LE = 0x1c000100
} CFStringBuiltInEncodings;

/*CFStringGetCString

Copies the character contents of a string to a local C string buffer after converting the characters to a given encoding.

Boolean CFStringGetCString (
   CFStringRef theString,
   char *buffer,
   CFIndex bufferSize,
   CFStringEncoding encoding
);
Parameters
theString

The string whose contents you wish to access. 
buffer

The C string buffer into which to copy the string. The buffer must be at least bufferSize bytes in length. On return, the buffer contains the converted characters. If there is an error in conversion, the buffer contains only partial results.
bufferSize

The length of the local buffer in bytes (accounting for the NULL-terminator byte). 
encoding

The string encoding to which the character contents of theString should be converted. 
Return Value

true upon success or false if the conversion fails or the provided buffer is too small. 
Discussion

This function is useful when you need your own copy of a strings character data as a C string. You also typically call it as a backup when a prior call to the CFStringGetCStringPtr function fails. 
Availability
Available in Mac OS X v10.0 and later.*/
Boolean CFStringGetCString (
   CFStringRef theString,
   char *buffer,
   CFIndex bufferSize,
   CFStringEncoding encoding
);

/*CFStringCreateMutable

Creates an empty CFMutableString object.

CFMutableStringRef CFStringCreateMutable (
   CFAllocatorRef alloc,
   CFIndex maxLength
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
maxLength

The maximum number of Unicode characters that can be stored by the returned string. Pass 0 if there should be no character limit. Note that initially the string still has a length of 0; this parameter simply specifies what the maximum size is. CFMutableString might try to optimize its internal storage by paying attention to this value. 
Return Value

A new empty CFMutableString object or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function creates an empty (that is, content-less) CFMutableString object. You can add character data to this object with any of the CFStringAppend... functions, and thereafter you can insert, delete, replace, pad, and trim characters with the appropriate CFString functions. If the maxLength parameter is greater than 0, any attempt to add characters beyond this limit results in a run-time error. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableStringRef CFStringCreateMutable (
   CFAllocatorRef alloc,
   CFIndex maxLength
);

/*CFStringReplaceAll

Replaces all characters of a CFMutableString object with other characters.

void CFStringReplaceAll (
   CFMutableStringRef theString,
   CFStringRef replacement
);
Parameters
theString

The string to modify. If this value is not a CFMutableString object, an assertion is raised. 
replacement

The replacement string to put into theString.
Discussion

The character buffer of theString is resized according to the length of the new characters.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringReplaceAll (
   CFMutableStringRef theString,
   CFStringRef replacement
);

/*CFStringGetSystemEncoding

Returns the default encoding used by the operating system when it creates strings.

CFStringEncoding CFStringGetSystemEncoding ();
Return Value

The default string encoding. 
Discussion

This function returns the default text encoding used by the OS when it creates strings. In Mac OS X, this encoding is determined by the user's preferred language setting. The preferred language is the first language listed in the International pane of the System Preferences.

In most situations you will not want to use this function, however, because your primary interest will be your application's default text encoding. The application encoding is required when you create a CFStringRef from strings stored in Resource Manager resources, which typically use one of the Mac encodings such as MacRoman or MacJapanese.

To get your application's default text encoding, call the GetApplicationTextEncoding Carbon function.
Availability
Available in Mac OS X v10.0 and later.*/
CFStringEncoding CFStringGetSystemEncoding ();

/*CFStringGetCStringPtr

Quickly obtains a pointer to a C-string buffer containing the characters of a string in a given encoding.

const char *CFStringGetCStringPtr (
   CFStringRef theString,
   CFStringEncoding encoding
);
Parameters
theString

The string whose contents you wish to access. 
encoding

The string encoding to which the character contents of theString should be converted. 
Return Value

A pointer to a C string or NULL if the internal storage of theString does not allow this to be returned efficiently. 
Discussion

This function either returns the requested pointer immediately, with no memory allocations and no copying, in constant time, or returns NULL. If the latter is the result, call an alternative function such as the CFStringGetCString function to extract the characters.

Whether or not this function returns a valid pointer or NULL depends on many factors, all of which depend on how the string was created and its properties. In addition, the function result might change between different releases and on different platforms. So do not count on receiving a non-NULL result from this function under any circumstances. 
Availability
Available in Mac OS X v10.0 and later.*/
const char *CFStringGetCStringPtr (
   CFStringRef theString,
   CFStringEncoding encoding
);

/*CFStringCompare

Compares one string with another string.

CFComparisonResult CFStringCompare (
   CFStringRef theString1,
   CFStringRef theString2,
   CFOptionFlags compareOptions
);
Parameters
theString1

The first string to use in the comparison. 
theString2

The second string to use in the comparison.
compareOptions

Flags that select different types of comparisons, such as localized comparison, case-insensitive comparison, and non-literal comparison. If you want the default comparison behavior, pass 0. See String Comparison Flags for the available flags.
Return Value

A CFComparisonResult value that indicates whether theString1 is equal to, less than, or greater than theString2. 
Discussion

You can affect how the comparison proceeds by specifying one or more option flags in compareOptions. Not all comparison options are currently implemented. 
Availability
Available in Mac OS X v10.0 and later.*/
CFComparisonResult CFStringCompare (
   CFStringRef theString1,
   CFStringRef theString2,
   CFOptionFlags compareOptions
);

/*CFStringAppend

Appends the characters of a string to those of a CFMutableString object.

void CFStringAppend (
   CFMutableStringRef theString,
   CFStringRef appendedString
);
Parameters
theString

The string to which appendedString is appended. If theString is not a CFMutableString object, an assertion is raised.
appendedString

The string to append. 
Discussion

This function reallocates the backing store of theString to accommodate the new length.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringAppend (
   CFMutableStringRef theString,
   CFStringRef appendedString
);

/*CFStringCreateMutableCopy

Creates a mutable copy of a string.

CFMutableStringRef CFStringCreateMutableCopy (
   CFAllocatorRef alloc,
   CFIndex maxLength,
   CFStringRef theString
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
maxLength

The maximum number of Unicode characters that can be stored by the returned object. Pass 0 if there should be no character limit. Note that initially the returned object still has the same length as the string argument; this parameter simply specifies what the maximum size is. CFString might try to optimize its internal storage by paying attention to this value. 
theString

A string to copy. 
Return Value

A string that has the same contents as theString. Returns NULL if there was a problem copying the object. Ownership follows the Create Rule.
Discussion

The returned mutable string is identical to the original string except for (perhaps) the mutability attribute. You can add character data to the returned string with any of the CFStringAppend... functions, and you can insert, delete, replace, pad, and trim characters with the appropriate CFString functions. If the maxLength parameter is greater than 0, any attempt to add characters beyond this limit results in a run-time error. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/CFMutableStringRef CFStringCreateMutableCopy (
   CFAllocatorRef alloc,
   CFIndex maxLength,
   CFStringRef theString
);

/*CFStringAppend

Appends the characters of a string to those of a CFMutableString object.

void CFStringAppend (
   CFMutableStringRef theString,
   CFStringRef appendedString
);
Parameters
theString

The string to which appendedString is appended. If theString is not a CFMutableString object, an assertion is raised.
appendedString

The string to append. 
Discussion

This function reallocates the backing store of theString to accommodate the new length.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void CFStringAppend (
   CFMutableStringRef theString,
   CFStringRef appendedString
);

/*CFStringInsert

Inserts a string at a specified location in the character buffer of a CFMutableString object.

void CFStringInsert (
   CFMutableStringRef str,
   CFIndex index,
   CFStringRef insertedStr
);
Parameters
str

The string to be modified. If this value is not a CFMutableString object, an assertion is raised. 
index

The index of the character in str after which the new characters are to be inserted. If the index is out of bounds, an assertion is raised. 
insertedStr

The string to insert into str. 
Discussion

To accommodate the new characters, this function moves any existing characters to the right of the inserted characters the appropriate number of positions. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringInsert (
   CFMutableStringRef str,
   CFIndex index,
   CFStringRef insertedStr
);

/*CFStringGetBytes

Fetches a range of the characters from a string into a byte buffer after converting the characters to a specified encoding.

CFIndex CFStringGetBytes (
   CFStringRef theString,
   CFRange range,
   CFStringEncoding encoding,
   UInt8 lossByte,
   Boolean isExternalRepresentation,
   UInt8 *buffer,
   CFIndex maxBufLen,
   CFIndex *usedBufLen
);
Parameters
theString

The string upon which to operate. 
range

The range of characters in theString to process. The specified range must not exceed the length of the string.
encoding

The string encoding of the characters to copy to the byte buffer. 
lossByte

A character (for example, '?') that should be substituted for characters that cannot be converted to the specified encoding. Pass 0 if you do not want lossy conversion to occur. 
isExternalRepresentation

true if you want the result to be in an “external representation” format. In such a format, it may contain a byte order marker (BOM) specifying endianness and this function might have to perform byte swapping. 
buffer

The byte buffer into which the converted characters are written. The buffer can be allocated on the heap or stack. Pass NULL if you do not want conversion to take place but instead want to know if conversion will succeed (the function result is greater than 0) and, if so, how many bytes are required (usedBufLen).
maxBufLen

The size of buffer and the maximum number of bytes that can be written to it. 
usedBufLen

On return, the number of converted bytes actually in buffer. You may pass NULL if you are not interested in this information.
Return Value

The number of characters converted. 
Discussion

This function is the basic encoding-conversion function for CFString objects. As with the other functions that get the character contents of CFString objects, it allows conversion to a supported 8-bit encoding. Unlike most of those other functions, it also allows “lossy conversion.” The function permits the specification of a “loss byte” in a parameter; if a character cannot be converted this character is substituted and conversion proceeds. (With the other functions, conversion stops at the first error and the operation fails.)

Because this function takes a range and returns the number of characters converted, it can be called repeatedly with a small fixed size buffer and different ranges of the string to do the conversion incrementally.

This function also handles any necessary manipulation of character data in an “external representation” format. This format makes the data portable and persistent (disk-writable); in Unicode it often includes a BOM (byte order marker) that specifies the endianness of the data.

The CFStringCreateExternalRepresentation function also handles external representations and performs lossy conversions. The complementary function CFStringCreateWithBytes creates a string from the characters in a byte buffer.
Availability
Available in Mac OS X v10.0 and later.*/
CFIndex CFStringGetBytes (
   CFStringRef theString,
   CFRange range,
   CFStringEncoding encoding,
   UInt8 lossByte,
   Boolean isExternalRepresentation,
   UInt8 *buffer,
   CFIndex maxBufLen,
   CFIndex *usedBufLen
);

/*CFStringGetLength

Returns the number (in terms of UTF-16 code pairs) of characters in a string.

CFIndex CFStringGetLength (
   CFStringRef theString
);
Parameters
theString

The string to examine. 
Return Value

The number (in terms of UTF-16 code pairs) of characters stored in theString. 
Availability
Available in Mac OS X v10.0 and later.*/
CFIndex CFStringGetLength (
   CFStringRef theString
);

/*CFStringHasPrefix

Determines if the character data of a string begin with a specified sequence of characters.

Boolean CFStringHasPrefix (
   CFStringRef theString,
   CFStringRef prefix
);
Parameters
theString

The string to search. 
prefix

The prefix to search for.
Return Value

true if theString begins with prefix, false if otherwise. 
Availability
Available in Mac OS X v10.0 and later.*/
Boolean CFStringHasPrefix (
   CFStringRef theString,
   CFStringRef prefix
);