#ifndef  CVIMAGEBUFFER_H
#define CVIMAGEBUFFER_H

#include <TargetConditionals.h>

#include <ApplicationServices/ApplicationServices.h>
#include <QuartzCore/CVBuffer.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*CVImageBufferRef

Defines a Core Video image buffer. 

typedef CVBufferRef CVImageBufferRef;
Discussion

An image buffer is an abstract type representing Core Video buffers that hold images. In Core Video, pixel buffers, OpenGL buffers, and OpenGL textures all derive from the image buffer type. 
Availability
Available in Mac OS X v10.3 and later.*/
typedef CVBufferRef CVImageBufferRef;

/*CVImageBufferGetCleanRect

Returns the source rectangle of a Core Video image buffer that represents the clean aperture of the buffer in encoded pixels. 

CGRect CVImageBufferGetCleanRect (
   CVImageBufferRef imageBuffer
);
Parameters
imageBuffer

The image buffer that you want to retrieve the display size from.
Return Value

A CGRect structure returning the nominal display size of the buffer. Returns a rectangle of zero size if called with either a non-CVImageBufferRef type or NULL.
Discussion

The clean aperture size is smaller than the full size of the image. For example, an NTSC DV frame would return a CGRect structure with an origin of (8,0) and a size of (704,480). Note that the origin of this rectangle is always in the lower-left corner. This is the same coordinate system as that used by Quartz and Core Image.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVImageBuffer.h*/
CGRect CVImageBufferGetCleanRect (
   CVImageBufferRef imageBuffer
);

#ifdef __cplusplus
}
#endif
#endif