#ifndef QTML_H
#define QTML_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*QTMLMutex

Represents a type used by the Windows API API.

typedef long QTMLMutex;
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
typedef long QTMLMutex;

/*QTMLGrabMutex

Confers ownership of a mutex created by QTMLCreateMutex.

void QTMLGrabMutex (
   QTMLMutex    mu );
Parameters
mu

A mutex object.
Discussion

Call this function when you require exclusive ownership of the resource guarded by a mutex. This function will return when you have gained this ownership. In the case where another thread or process holds the mutex, this function waits until that process or thread relinquishes control. If you need to determine if you can grab the mutex, without actually grabbing it, call QTMLTryGrabMutex.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
void QTMLGrabMutex (
   QTMLMutex    mu );

/*QTMLCreateMutex

Creates a synchronization object to facilitate mutually exclusive access to a Windows data structure.

QTMLMutex QTMLCreateMutex ( void );
Discussion

This function creates a mutex object for guarded access to data structures and routines that require mutually exclusive access. In a multithreaded preemptive environment, such as Windows NT, you can use the various mutex utility functions such as QTMLGrabMutex to protect a shared resource from simultaneous access by multiple threads or processes. Mutex objects are used throughout QTML to provide such protection.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
QTMLMutex QTMLCreateMutex ( void );

/*QTMLDestroyMutex

Deallocates a synchronization object created by QTMLCreateMutex.

void QTMLDestroyMutex (
   QTMLMutex    mu );
Parameters
mu

A mutex object.
Discussion

Call this function to deallocate the mutex object created by QTMLCreateMutex.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
void QTMLDestroyMutex (
   QTMLMutex    mu );

/*QTMLReturnMutex

Releases ownership of a QTMLMutex object.

void QTMLReturnMutex (
   QTMLMutex    mu );
Parameters
mu

A mutex object.
Discussion

Call this function to balance a call to QTMLGrabMutex when you are ready to relinquish control of the mutex and corresponding shared resource. By making this call, you allow other processes or threads waiting for the release of this mutex to gain access.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
void QTMLReturnMutex (
   QTMLMutex    mu );


#ifdef __cplusplus
}
#endif
#endif