#ifndef OPENSCRIPTING_H
#include <OpenScripting/OpenScripting.h>
#endif

/*OSADisplay

Converts a script value to text. Your application can then use its own functions to display this text to the user. 

OSAError OSADisplay (
   ComponentInstance scriptingComponent,
   OSAID scriptValueID,
   DescType desiredType,
   long modeFlags,
   AEDesc * resultingText
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptValueID

The script ID for the script value to coerce. See the OSAID data type.
desiredType

The desired text descriptor type, such as typeChar, for the resulting descriptor record. 
modeFlags

Information used by individual scripting components. To avoid setting any mode ﬂags, specify kOSAModeNull. To make the resulting text readable by humans only, so that it can’t be recompiled, specify kOSAModeDisplayForHumans. 
resultingText

A pointer to the resulting descriptor record. 
Return Value

A result code. See “Result Codes”.
Discussion

The OSADisplay function coerces the script value identiﬁed by scriptValueID to a descriptor record of the text type speciﬁed by the desiredType parameter, if possible. Valid types include the standard text descriptor types, plus any special types supported by the scripting component.

Unlike OSAGetSource, OSADisplay can coerce only script values and always produces a descriptor record of a text descriptor type. In addition, if you specify the mode ﬂag kOSAModeDisplayForHumans, the resulting text cannot be recompiled. 

If you want to get a script value in a form that you can display for humans to read, use OSADisplay. If you want the descriptor type of the descriptor record returned in the resultingText parameter to be the same as the descriptor type returned by a scripting component, use OSACoerceToDesc and specify typeWildCard as the desired type.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/

OSAError OSADisplay (
   ComponentInstance scriptingComponent,
   OSAID scriptValueID,
   DescType desiredType,
   long modeFlags,
   AEDesc * resultingText){
//TODO
};


/*OSADispose

Reclaims the memory occupied by script data. 

OSAError OSADispose (
   ComponentInstance scriptingComponent,
   OSAID scriptID
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptID

The script ID for the script data to be disposed of. See the OSAID data type.
Return Value

A result code. See “Result Codes”.
Discussion

The OSADispose function releases the memory assigned to the script data identiﬁed by the scriptID parameter. The script ID passed to the OSADispose function is no longer valid if the function returns successfully. A scripting component can then reuse that script ID for other script data. 

A call to OSADispose returns noErr if the script ID is kOSANullScript, although it does not dispose of anything. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSADispose (
   ComponentInstance scriptingComponent,
   OSAID scriptID){
//TODO
};


/*OSAScriptError

Gets information about errors that occur during script execution. 

OSAError OSAScriptError (
   ComponentInstance scriptingComponent,
   OSType selector,
   DescType desiredType,
   AEDesc * resultingErrorDescription
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
selector

A value that determines what OSAScriptError returns. The value can be one of the constants described in “OSAScriptError Selectors”.
desiredType

The desired descriptor type of the resulting descriptor record. The description that follows explains how this is determined by the value passed in the selector parameter.
resultingErrorDescription

On return, a pointer to the resulting descriptor record. 
Return Value

A result code. See “Result Codes”.
Discussion

Whenever the OSAExecute function returns the error errOSAScriptError, you can use the OSAScriptError function to get more speciﬁc information about the error from the scripting component that encountered it. (This information remains available only until the next call to the same scripting component.) The information returned by OSAScriptError depends on the value passed in the selector parameter, which also determines the descriptor type you should specify in the desiredType parameter.

Every scripting component should support calls to OSAScriptError that pass kOSAErrorNumber, kOSAErrorMessage, or kOSAErrorPartialResult in the selector parameter.

Some scripting components may also support calls that pass other values in the selector parameter, including kOSAErrorRange, which provides start and end positions delimiting the errant expression in the source data. If the value of the selector parameter is kOSAErrorRange, the value of desiredType must be typeOSAErrorRange.

If the value of the selector parameter is kOSAErrorNumber, scripting components may return, in the resultingErrorDescription parameter, one of the general error codes described in “Result Codes”.

If you call OSAScriptError using an instance of the generic scripting component, the generic scripting component uses the same instance of a scripting component that it used for the previous call. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSAScriptError (
   ComponentInstance scriptingComponent,
   OSType selector,
   DescType desiredType,
   AEDesc * resultingErrorDescription){
//TODO
};

/*OSALoad

Loads script data. 

OSAError OSALoad (
   ComponentInstance scriptingComponent,
   const AEDesc * scriptData,
   long modeFlags,
   OSAID * resultingScriptID
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptData

A pointer to the descriptor record containing the script data to be loaded. 
modeFlags

Information used by individual scripting components. To avoid setting any mode ﬂags, specify kOSAModeNull. To indicate that only the minimum script data required to run the script should be loaded, pass kOSAModePreventGetSource in this parameter. 
resultingScriptID

On return, a pointer to the script ID for the compiled script. See the OSAID data type.
Return Value

A result code. See “Result Codes”.
Discussion

The OSALoad function loads script data and returns a script ID. The generic scripting component uses the descriptor record in the scriptData parameter to determine which scripting component should load the script. If the descriptor record is of type typeOSAGenericStorage, the generic scripting component uses the trailer at the end of the script data to identify the scripting component. If the descriptor record’s type is the subtype value for another scripting component, the generic scripting component uses the descriptor type to identify the scripting component.

If you want the script ID returned by OSALoad to identify only the minimum script data required to run the script and you are sure that you won’t need to display the source data to the user, specify the kOSAModePreventGetSource ﬂag in the modeFlags parameter.

Scripting components other than the generic scripting component can load script data only if it has been saved in a descriptor record whose descriptor type matches the scripting component’s subtype. 

Script data may change after it has been loaded—for example, if your application allows the user to edit a script’s source data. To test whether script data has been modiﬁed, pass its script ID to OSAGetScriptInfo. If it has changed, you can call OSAStore again to obtain a handle to the modiﬁed script data and save it. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSALoad (
   ComponentInstance scriptingComponent,
   const AEDesc * scriptData,
   long modeFlags,
   OSAID * resultingScriptID){
//TODO
};


/*OSAExecuteEvent

Handles an Apple event with the aid of a script context and obtains a script ID for the resulting script value. 

OSAError OSAExecuteEvent (
   ComponentInstance scriptingComponent,
   const AppleEvent * theAppleEvent,
   OSAID contextID,
   long modeFlags,
   OSAID * resultingScriptValueID
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
theAppleEvent

A pointer to the Apple event to be handled. 
contextID

The script ID for the script context to be used to handle the Apple event. See the OSAID data type.
modeFlags

Information used by individual scripting components. To avoid setting mode ﬂag values, specify kOSAModeNull. Other possible mode ﬂags are listed in “Mode Flags”. 
resultingScriptValueID

A pointer to the script ID for the resulting script value. 
Return Value

A result code. See “Result Codes”.
Discussion

The OSAExecuteEvent function attempts to use the script context speciﬁed by the contextID parameter to handle the Apple event specified by the theAppleEvent parameter. If the scripting component determines that the script context can’t handle the event (for example, if a script written in AppleScript doesn’t include statements that handle the event), OSAExecuteEvent immediately returns errAEEventNotHandled rather than errOSAScriptError. This causes the Apple Event Manager to look for an appropriate handler in the application’s Apple event dispatch table or elsewhere, using standard Apple event dispatching.

If the scripting component determines that the script context can handle the event, OSAExecuteEvent executes the script context’s handler and returns the resulting script ID. If execution of the script context’s handler for the event generates an error, OSAExecuteEvent returns errOSAScriptError, and you can get more detailed error information by calling the OSAScriptError function. 

If the script context identiﬁed by the contextID parameter speciﬁes that the Apple event should be passed to the application’s default handler for that event (for example, with an AppleScript continue statement), OSAExecuteEvent passes the event to the resume dispatch function currently being used by the scripting component. The resume dispatch function dispatches the event directly to the application’s standard handler for that event (that is, without calling OSAExecuteEvent again). If the contextID parameter is kOSANullScript, the OSAExecuteEvent function passes the event directly to the resume dispatch function. If a call to the resume dispatch function is successful, execution of the script context proceeds from the point at which the resume dispatch function was called. 
Special Considerations

The OSAExecuteEvent function can generate the result code errAEEventNotHandled in at least two ways. If the scripting component determines that a script context doesn’t declare a handler for a particular event, OSAExecuteEvent immediately returns errAEEventNotHandled. If a scripting component calls its resume dispatch function during script execution and the application’s standard handler for the event fails to handle it, OSAExecuteEvent returns errOSAScriptError and a call to OSAScriptError with kOSAErrorNumber in the selector parameter returns errAEEventNotHandled as the resulting error description.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/

OSAError OSAExecuteEvent (
   ComponentInstance scriptingComponent,
   const AppleEvent * theAppleEvent,
   OSAID contextID,
   long modeFlags,
   OSAID * resultingScriptValueID){
//TODO
};
