@class NSButton, NSButtonCell, NSColor, NSImage, NSPasteboard, NSScreen;
@class NSNotification, NSText, NSView, NSMutableSet, NSSet, NSDate;
@class NSToolbar, NSGraphicsContext;

@interface NSWindow (ADD)
//hys defiune
/*disableScreenUpdatesUntilFlush

Disables the receiver’s screen updates until the window is flushed.

- (void)disableScreenUpdatesUntilFlush
Discussion

This method can be invoked to synchronize hardware surface flushes with the window’s flushes. The receiver immediately disables screen updates using the function NSDisableScreenUpdates and re-enables screen updates when the window flushes. Sending this message multiple times during a window update cycle has no effect.
Availability
Available in Mac OS X v10.4 and later.*/
- (void)disableScreenUpdatesUntilFlush;
//hys
/*graphicsContext

Returns the graphics context associated with the receiver for the current thread.

- (NSGraphicsContext*)graphicsContext
Availability
Available in Mac OS X v10.4 and later.*/
- (NSGraphicsContext*)graphicsContext;

/*removeChildWindow:

Detaches childWin from the receiver.

- (void)removeChildWindow:(NSWindow *)childWin
Availability
Available in Mac OS X v10.2 and later.
See Also
– addChildWindow:ordered:
– childWindows
– parentWindow
– setParentWindow:*/
- (void)removeChildWindow:(NSWindow *)childWin;

/*addChildWindow:ordered:

childWin is ordered either above (NSWindowAbove) or below (NSWindowBelow) the receiver, and maintained in that relative place for subsequent ordering operations involving either window.

- (void)addChildWindow:(NSWindow *)childWin ordered:(NSWindowOrderingMode)place
Discussion

While this attachment is active, moving childWin will not cause the receiver to move (as in sliding a drawer in or out), but moving the receiver will cause childWin to move.

Note that you should not create cycles between parent and child windows. For example, you should not add window B as child of window A, then add window A as a child of window B.
Availability
Available in Mac OS X v10.2 and later.
See Also
– removeChildWindow:
– childWindows
– parentWindow
– setParentWindow:*/
- (void)addChildWindow:(NSWindow *)childWin ordered:(NSWindowOrderingMode)place;

/*setParentWindow:

For use by subclasses when setting the parent window in the receiver.

- (void)setParentWindow:(NSWindow *)window
Discussion

You should call super if overriding.
Availability
Available in Mac OS X v10.2 and later.
See Also
– removeChildWindow:
– childWindows
– parentWindow
– addChildWindow:ordered:*/
- (void)setParentWindow:(NSWindow *)window;

@end

/*NSWindowDidChangeScreenProfileNotification

Posted whenever the display profile for the screen containing the window changes.

This notification is sent only if the window returns YES from displaysWhenScreenProfileChanges. This notification may be sent when a majority of the window is moved to a different screen (whose profile is also different from the previous screen) or when the ColorSync profile for the current screen changes. 

The notification object is the NSWindow object whose profile changed. This notification does not contain a userInfo dictionary. 
Availability
Available in Mac OS X v10.4 and later*/
APPKIT_EXPORT NSString *NSWindowDidChangeScreenProfileNotification ; //hys
