//hys
/*BSD file type and mode bits. Note that the constants from the header shown below are in octal (base eight), not hexadecimal. #define S_ISUID 0004000     /* set user id on execution */
//#define S_ISGID 0002000     /* set group id on execution */
//#define S_ISTXT 0001000     /* sticky bit */

//#define S_IRWXU 0000700     /* RWX mask for owner */
//#define S_IRUSR 0000400     /* R for owner */
//#define S_IWUSR 0000200     /* W for owner */
//#define S_IXUSR 0000100     /* X for owner */

//#define S_IRWXG 0000070     /* RWX mask for group */
//#define S_IRGRP 0000040     /* R for group */
//#define S_IWGRP 0000020     /* W for group */
//#define S_IXGRP 0000010     /* X for group */

//#define S_IRWXO 0000007     /* RWX mask for other */
//#define S_IROTH 0000004     /* R for other */
//#define S_IWOTH 0000002     /* W for other */
//#define S_IXOTH 0000001     /* X for other */

//#define S_IFMT   0170000    /* type of file mask */
//#define S_IFIFO  0010000    /* named pipe (fifo) */
//#define S_IFCHR  0020000    /* character special */
//#define S_IFDIR  0040000    /* directory */
//#define S_IFBLK  0060000    /* block special */
//#define S_IFREG  0100000    /* regular */
//#define S_IFLNK  0120000    /* symbolic link */
//#define S_IFSOCK 0140000    /* socket */
//#define S_IFWHT  0160000    /* whiteout */

/*In some versions of Unix, the sticky bit, S_ISTXT, is used to indicate that an executable file's code should remain in memory after the executable finishes; this can help performance if the same executable is used again soon. Mac OS X does not use this optimization. If the sticky bit is set for a directory, then Mac OS X restricts movement, deletion, and renaming of files in that directory. Files may be removed or renamed only if the user has write access to the directory; and is the owner of the file or the directory, or is the super-user. 
special*/
#define S_ISUID 0004000     /* set user id on execution */
#define S_ISGID 0002000     /* set group id on execution */
#define S_ISTXT 0001000     /* sticky bit */

#define S_IRWXU 0000700     /* RWX mask for owner */
#define S_IRUSR 0000400     /* R for owner */
#define S_IWUSR 0000200     /* W for owner */
#define S_IXUSR 0000100     /* X for owner */

#define S_IRWXG 0000070     /* RWX mask for group */
#define S_IRGRP 0000040     /* R for group */
#define S_IWGRP 0000020     /* W for group */
#define S_IXGRP 0000010     /* X for group */

#define S_IRWXO 0000007     /* RWX mask for other */
#define S_IROTH 0000004     /* R for other */
#define S_IWOTH 0000002     /* W for other */
#define S_IXOTH 0000001     /* X for other */

#define S_IFMT   0170000    /* type of file mask */
#define S_IFIFO  0010000    /* named pipe (fifo) */
#define S_IFCHR  0020000    /* character special */
#define S_IFDIR  0040000    /* directory */
#define S_IFBLK  0060000    /* block special */
#define S_IFREG  0100000    /* regular */
#define S_IFLNK  0120000    /* symbolic link */
#define S_IFSOCK 0140000    /* socket */
#define S_IFWHT  0160000    /* whiteout */