
/*ROUND(3)                 BSD Library Functions Manual                 ROUND(3)

NAME
     round, lround, llround -- round to integral value, regardless of rounding
     direction

SYNOPSIS
     #include <math.h>

     double
     round(double x);

     long double
     roundl(long double x);

     float
     roundf(float x);

     long int
     lround(double x);

     long int
     lroundl(long double x);

     long int
     lroundf(float x);

     long long int
     llround(double x);

     long long int
     llroundl(long double x);

     long long int
     llroundf(float x);

DESCRIPTION
     The round() functions return the integral value nearest to x rounding
     half-way cases away from zero, regardless of the current rounding direc-direction.
     tion.

     The lround() and llround() functions return the integral value nearest to
     x (rounding half-way cases away from zero, regardless of the current
     rounding direction) in the return formats specified.  If the rounded
     value is outside the range of the return type, the numeric result is
     unspecified and the "invalid" floating-point exception is raised. A range
     error may occur if the magnitude of x is too large.

SPECIAL VALUES
     round(+-0) returns +-0.

     round(+-infinity) returns +-infinity.

     The round() functions may, but are not required to, raise the "inexact"
     floating-point exception for non-integer numeric arguments.

     The lround() and llround() functions need not raise the "inexact" float-floating-point
     ing-point exception for non-integer arguments that round to within the
     range of the return type.

SEE ALSO
     abs(3), fabs(3), ceil(3), floor(3), math(3), rint(3)

STANDARDS
     The round() , lround() , and llround() functions conform to ISO/IEC
     9899:1999(E).

BSD                              July 22, 2003                             BSD*/

  float roundf(float x);


/*FLOOR(3)                 BSD Library Functions Manual                 FLOOR(3)



NAME
     floor -- round to largest integral value not greater than x

SYNOPSIS
     #include <math.h>

     double
     floor(double x);

     long double
     floorl(long double x);

     float
     floorf(float x);

DESCRIPTION
     The floor() functions return the largest integral value less than or
     equal to x.

SPECIAL VALUES
     floor(+-0) returns +-0.

     floor(+-infinity) returns +-infinity.

SEE ALSO
     abs(3), ceil(3), fabs(3), rint(3), math(3)

STANDARDS
     The floor() functions conform to ISO/IEC 9899:1999(E).

BSD                            November 20, 2002                           BSD*/
// float
   //  floorf(float x);