#ifndef TEXTCOMMON_H
#define  TEXTCOMMON_H


#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*TextEncoding

Defines a data type for a text encoding value.

typedef UInt32 TextEncoding;
Discussion

A TextEncoding value is specified by a text encoding base, a text encoding variant, and a text encoding format. You can obtain a TextEncoding value by calling the function CreateTextEncoding. When you call this function, you can provide the TextEncodingBase, TextEncodingVariant, and TextEncodingFormat data types.

A TextEncoding value is used, for example, to identify the encoding of text passed to a text converter. Two TextEncoding values are needed?for source and destination encoding?when calling the Text Encoding Converter or the Unicode Converter to convert text. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 TextEncoding;

/*Special Text Encoding Values

Specify special cases of text encodings.

enum {
   kTextEncodingMultiRun = 0x0FFF,
   kTextEncodingUnknown = 0xFFFF
};
Constants
kTextEncodingMultiRun

This is a special value for multiple encoded text, external run information.

Available in Mac OS X v10.0 and later.
kTextEncodingUnknown

Available in Mac OS X v10.0 and later.*/
enum {
   kTextEncodingMultiRun = 0x0FFF,
   kTextEncodingUnknown = 0xFFFF
};

/*Base Text Encodings

Specify base text encodings.

typedef UInt32 TextEncodingBase;
enum {
   kTextEncodingMacRoman = 0,
   kTextEncodingMacJapanese = 1,
   kTextEncodingMacChineseTrad = 2,
   kTextEncodingMacKorean = 3,
   kTextEncodingMacArabic = 4,
   kTextEncodingMacHebrew = 5,
   kTextEncodingMacGreek = 6,
   kTextEncodingMacCyrillic = 7,
   kTextEncodingMacDevanagari = 9,
   kTextEncodingMacGurmukhi = 10,
   kTextEncodingMacGujarati = 11,
   kTextEncodingMacOriya = 12,
   kTextEncodingMacBengali = 13,
   kTextEncodingMacTamil = 14,
   kTextEncodingMacTelugu = 15,
   kTextEncodingMacKannada = 16,
   kTextEncodingMacMalayalam = 17,
   kTextEncodingMacSinhalese = 18,
   kTextEncodingMacBurmese = 19,
   kTextEncodingMacKhmer = 20,
   kTextEncodingMacThai = 21,
   kTextEncodingMacLaotian = 22,
   kTextEncodingMacGeorgian = 23,
   kTextEncodingMacArmenian = 24,
   kTextEncodingMacChineseSimp = 25,
   kTextEncodingMacTibetan = 26,
   kTextEncodingMacMongolian = 27,
   kTextEncodingMacEthiopic = 28,
   kTextEncodingMacCentralEurRoman = 29,
   kTextEncodingMacVietnamese = 30,
   kTextEncodingMacExtArabic = 31,
   kTextEncodingMacSymbol = 33,
   kTextEncodingMacDingbats = 34,
   kTextEncodingMacTurkish = 35,
   kTextEncodingMacCroatian = 36,
   kTextEncodingMacIcelandic = 37,
   kTextEncodingMacRomanian = 38,
   kTextEncodingMacCeltic = 39,
   kTextEncodingMacGaelic = 40,
   kTextEncodingMacKeyboardGlyphs = 41
};
Constants
kTextEncodingMacRoman

The encoding for Mac OS Roman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacJapanese

The encoding for Mac OS Japanese.

Available in Mac OS X v10.0 and later.
kTextEncodingMacChineseTrad

The encoding for Mac OS traditional Chinese.

Available in Mac OS X v10.0 and later.
kTextEncodingMacKorean

The encoding for Mac OS Korean.

Available in Mac OS X v10.0 and later.
kTextEncodingMacArabic

The encoding for Mac OS Arabic.

Available in Mac OS X v10.0 and later.
kTextEncodingMacHebrew

The encoding for Mac OS Hebrew.

Available in Mac OS X v10.0 and later.
kTextEncodingMacGreek

The encoding for Mac OS Greek.

Available in Mac OS X v10.0 and later.
kTextEncodingMacCyrillic

The encoding for Mac OS Cyrillic.

Available in Mac OS X v10.0 and later.
kTextEncodingMacDevanagari

The encoding for Mac OS Devanagari.

Available in Mac OS X v10.0 and later.
kTextEncodingMacGurmukhi

The encoding for Mac OS Gurmukhi.

Available in Mac OS X v10.0 and later.
kTextEncodingMacGujarati

The encoding for Mac OS Gujurati.

Available in Mac OS X v10.0 and later.
kTextEncodingMacOriya

The encoding for Mac OS Oriya.

Available in Mac OS X v10.0 and later.
kTextEncodingMacBengali

The encoding for Mac OS Bengali.

Available in Mac OS X v10.0 and later.
kTextEncodingMacTamil

The encoding for Mac OS Tamil.

Available in Mac OS X v10.0 and later.
kTextEncodingMacTelugu

The encoding for Mac OS Telugu.

Available in Mac OS X v10.0 and later.
kTextEncodingMacKannada

The encoding for Mac OS Kannada.

Available in Mac OS X v10.0 and later.
kTextEncodingMacMalayalam

The encoding for Mac OS Malayalam.

Available in Mac OS X v10.0 and later.
kTextEncodingMacSinhalese

The encoding for Mac OS Sinhalese.

Available in Mac OS X v10.0 and later.
kTextEncodingMacBurmese

The encoding for Mac OS Burmese.

Available in Mac OS X v10.0 and later.
kTextEncodingMacKhmer

The encoding for Mac OS Khmer.

Available in Mac OS X v10.0 and later.
kTextEncodingMacThai

The encoding for Mac OS Thai.

Available in Mac OS X v10.0 and later.
kTextEncodingMacLaotian

The encoding for Mac OS Laotian.

Available in Mac OS X v10.0 and later.
kTextEncodingMacGeorgian

The encoding for Mac OS Georgian.

Available in Mac OS X v10.0 and later.
kTextEncodingMacArmenian

The encoding for Mac OS Armenian.

Available in Mac OS X v10.0 and later.
kTextEncodingMacChineseSimp

The encoding for Mac OS simple Chinese.

Available in Mac OS X v10.0 and later.
kTextEncodingMacTibetan

The encoding for Mac OS Tibetan.

Available in Mac OS X v10.0 and later.
kTextEncodingMacMongolian

The encoding for Mac OS Mongolian.

Available in Mac OS X v10.0 and later.
kTextEncodingMacEthiopic

The encoding for Mac OS Ethiopic.

Available in Mac OS X v10.0 and later.
kTextEncodingMacCentralEurRoman

The encoding for Mac OS Central European Roman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacVietnamese

The encoding for Mac OS Vietnamese.

Available in Mac OS X v10.0 and later.
kTextEncodingMacExtArabic

The encoding for Mac OS ExtArabic.

Available in Mac OS X v10.0 and later.
kTextEncodingMacSymbol

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacDingbats

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacTurkish

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacCroatian

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacIcelandic

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacRomanian

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacCeltic

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacGaelic

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacKeyboardGlyphs

Available in Mac OS X v10.0 and later.
Discussion

You use a base text encoding data type to specify which text encoding or text encoding scheme you have used to express a given text. The text encoding base value is the primary specification of the source or target encoding. Values 0 through 32 correspond directly to Mac OS script codes. Values 33 through 254 are for other Mac OS encodings that do not have their own script codes, such as the Symbol encoding implemented by the Symbol font. You can also specify a meta-value as a base text encoding, such as kTextEncodingMacHFS and kTextEncodingUnicodeDefault. A meta-value is mapped to a real value. 

The function GetTextEncodingBase returns the text encoding base of a text encoding specification.

A base text encoding is defined by the TextEncodingBase data type.*/
typedef UInt32 TextEncodingBase;
enum {
   kTextEncodingMacRoman = 0,
   kTextEncodingMacJapanese = 1,
   kTextEncodingMacChineseTrad = 2,
   kTextEncodingMacKorean = 3,
   kTextEncodingMacArabic = 4,
   kTextEncodingMacHebrew = 5,
   kTextEncodingMacGreek = 6,
   kTextEncodingMacCyrillic = 7,
   kTextEncodingMacDevanagari = 9,
   kTextEncodingMacGurmukhi = 10,
   kTextEncodingMacGujarati = 11,
   kTextEncodingMacOriya = 12,
   kTextEncodingMacBengali = 13,
   kTextEncodingMacTamil = 14,
   kTextEncodingMacTelugu = 15,
   kTextEncodingMacKannada = 16,
   kTextEncodingMacMalayalam = 17,
   kTextEncodingMacSinhalese = 18,
   kTextEncodingMacBurmese = 19,
   kTextEncodingMacKhmer = 20,
   kTextEncodingMacThai = 21,
   kTextEncodingMacLaotian = 22,
   kTextEncodingMacGeorgian = 23,
   kTextEncodingMacArmenian = 24,
   kTextEncodingMacChineseSimp = 25,
   kTextEncodingMacTibetan = 26,
   kTextEncodingMacMongolian = 27,
   kTextEncodingMacEthiopic = 28,
   kTextEncodingMacCentralEurRoman = 29,
   kTextEncodingMacVietnamese = 30,
   kTextEncodingMacExtArabic = 31,
   kTextEncodingMacSymbol = 33,
   kTextEncodingMacDingbats = 34,
   kTextEncodingMacTurkish = 35,
   kTextEncodingMacCroatian = 36,
   kTextEncodingMacIcelandic = 37,
   kTextEncodingMacRomanian = 38,
   kTextEncodingMacCeltic = 39,
   kTextEncodingMacGaelic = 40,
   kTextEncodingMacKeyboardGlyphs = 41
};

#ifdef __cplusplus
}
#endif

#endif