#ifndef  CMTYPES_H
#define CMTYPES_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*CMDisplayIDType

Defines a data type for a display ID type.

typedef UInt32 CMDisplayIDType;
Discussion

This data type is passed as a parameter to the functions CMGetProfileByAVID and CMSetProfileByAVID.
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 CMDisplayIDType;

/*CMProfileAccessProcPtr

Defines a pointer to a profile access callback function that provides procedure-based access to a profile.

typedef OSErr (*CMProfileAccessProcPtr)
(
   SInt32 command,
   SInt32 offset,
   SInt32 *size,
   void *data,
   void *refCon
);

If you name your function MyCMProfileAccessProc, you would declare it like this:

OSErr MyCMProfileAccessProc (
   SInt32 command,
   SInt32 offset,
   SInt32 *size,
   void *data,
   void *refCon
);
Parameters
command

A command value indicating the operation to perform. Operation constants are described in “Profile Access Procedures”. 
offset

For read and write operations, the offset from the beginning of the profile at which to read or write data.
size

A pointer to a size value. On input, for the cmReadAccess and cmWriteAccess command constants, a pointer to a value indicating the number of bytes to read or write; for the cmOpenWriteAccess command, the total size of the profile. On return, after reading or writing, the actual number of bytes read or written.
data

A pointer to a buffer containing data to read or write. On return, for a read operation, contains the data that was read. 
refCon

A reference constant pointer that can store private data for the CMProfileAccessCallback function.
Return Value

An OSErr value.
Discussion

When your application calls the CMOpenProfile, CMNewProfile, CMCopyProfile, or CMNewLinkProfile functions, it may supply the ColorSync Manager with a profile location structure of type CMProfileLocation that specifies a procedure that provides access to a profile. In the structure, you provide a universal procedure pointer to a profile access procedure supplied by you and, optionally, a pointer to data your procedure can use. The ColorSync Manager calls your procedure when the profile is created, initialized, opened, read, updated, or closed.

When the ColorSync Manager calls your profile access procedure, it passes a constant indicating the operation to perform. The operations include creating a new profile, reading from the profile, writing the profile, and so on. Operation constants are described in “Profile Access Procedures”. Your procedure must be able to respond to each of these constants.*/
typedef OSErr (*CMProfileAccessProcPtr)
(
   SInt32 command,
   SInt32 offset,
   SInt32 *size,
   void *data,
   void *refCon
);


/*CMError

Defines a data type for a ColorSync Manager result code.

typedef  CMError;
Discussion

For a list of possible resutlt codes, see “ColorSync Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.*/
typedef  CMError;
//typedef  int CMError;

/*CMProfileRef

Defines a reference to an opaque data type that specifies profile information.

typedef struct OpaqueCMProfileRef * CMProfileRef;
Discussion

A profile reference is the means by which your application gains access to a profile. Several ColorSync Manager functions return a profile reference to your application. Your application then passes it as a parameter on subsequent calls to other ColorSync Manager functions that use profiles.

The ColorSync Manager returns a unique profile reference in response to each individual call to the CMOpenProfile, CMCopyProfile , and CMNewProfile functions. This allows multiple applications concurrent access to a profile. The ColorSync Manager defines an abstract private data structure of type OpaqueCMProfileRef for the profile reference. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueCMProfileRef * CMProfileRef;

#ifdef __cplusplus
}
#endif

#endif