#ifndef CFPREFERENCES_H
#define CFPREFERENCES_H


#include <CoreFoundation/CFBase.h>

#ifndef CFARRAY_H
#include <CoreFoundation/CFArray.h>
#endif

#include <CoreFoundation/CFString.h>


#if defined(__cplusplus)
extern "C" {
#endif



/*Application, Host, and User Keys

Keys used to specify the common preference domains.

const CFStringRef kCFPreferencesAnyApplication;
const CFStringRef kCFPreferencesAnyHost;
const CFStringRef kCFPreferencesAnyUser;
const CFStringRef kCFPreferencesCurrentApplication;
const CFStringRef kCFPreferencesCurrentHost;
const CFStringRef kCFPreferencesCurrentUser;
Constants
kCFPreferencesAnyApplication

Indicates a preference that applies to any application.

Available in Mac OS X v10.0 and later.
kCFPreferencesAnyHost

Indicates a preference that applies to any host.

Available in Mac OS X v10.0 and later.
kCFPreferencesAnyUser

Indicates a preference that applies to any user.

Available in Mac OS X v10.0 and later.
kCFPreferencesCurrentApplication

Indicates a preference that applies only to the current application.

Available in Mac OS X v10.0 and later.
kCFPreferencesCurrentHost

Indicates a preference that applies only to the current host.

Available in Mac OS X v10.0 and later.
kCFPreferencesCurrentUser

Indicates a preference that applies only to the current user.

Available in Mac OS X v10.0 and later.*/

const CFStringRef CFPreferencesAppValue;
const CFStringRef kCFPreferencesAnyHost;
const CFStringRef kCFPreferencesAnyUser;
const CFStringRef kCFPreferencesCurrentApplication;
const CFStringRef kCFPreferencesCurrentHost;
const CFStringRef kCFPreferencesCurrentUser;

/*CFPreferencesAppSynchronize

Writes to permanent storage all pending changes to the preference data for the application, and reads the latest preference data from permanent storage.

Boolean CFPreferencesAppSynchronize (
   CFStringRef applicationID
);
Parameters
applicationID

The ID of the application whose preferences to write to storage, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, com.foosoft.
Return Value

true if synchronization was successful, otherwise false. 
Discussion

Calling the function CFPreferencesSetAppValue is not in itself sufficient for storing preferences. The CFPreferencesAppSynchronize function writes to permanent storage all pending preference changes for the application. Typically you would call this function after multiple calls to CFPreferencesSetAppValue. Conversely, preference data is cached after it is first read. Changes made externally are not automatically incorporated. The CFPreferencesAppSynchronize function reads the latest preferences from permanent storage.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFPreferencesAppSynchronize (
   CFStringRef applicationID
);


/*CFPreferencesSetAppValue

Adds, modifies, or removes a preference.

void CFPreferencesSetAppValue (
   CFStringRef key,
   CFPropertyListRef value,
   CFStringRef applicationID
);
Parameters
key

The preference key whose value you wish to set. 
value

The value to set for the specified key and application. Pass NULL to remove the specified key from the applications preferences. 
applicationID

The ID of the application whose preferences you wish to create or modify, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, com.foosoft.
Discussion

New preference values are stored in the standard application preference location, ~/Library/Preferences/. When called with kCFPreferencesCurrentApplication, modifications are performed in the preference domain Current User, Current Application, Any Host. If you need to create preferences in some other domain, use the low-level function CFPreferencesSetValue.

You must call the CFPreferencesAppSynchronize function in order for your changes to be saved to permanent storage. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFPreferencesSetAppValue (
   CFStringRef key,
   CFPropertyListRef value,
   CFStringRef applicationID
);

/*CFPreferencesCopyAppValue

Obtains a preference value for the specified key and application.

CFPropertyListRef CFPreferencesCopyAppValue (
   CFStringRef key,
   CFStringRef applicationID
);
Parameters
key

The preference key whose value to obtain. 
applicationID

The identifier of the application whose preferences to search, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, com.foosoft.
Return Value

The preference data for the specified key and application. The data is returned as a Core Foundation Property List data type. Use the function CFGetTypeID to determine the values type. If no value was located, returns NULL. Ownership follows the Create Rule.
Discussion

Note that values returned from this function are immutable, even if you have recently set the value using a mutable object.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
extern CFPropertyListRef CFPreferencesCopyAppValue (
   CFStringRef key,
   CFStringRef applicationID
);

/*CFPreferencesGetAppBooleanValue

Convenience function that directly obtains a boolean preference value for the specified key.

Boolean CFPreferencesGetAppBooleanValue (
   CFStringRef key,
   CFStringRef applicationID,
   Boolean *keyExistsAndHasValidFormat
);
Parameters
key

The preference key whose value to obtain. The key must specify a preference whose value is of type Boolean. 
applicationID

The identifier of the application whose preferences are searched, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, such as com.foosoft.
keyExistsAndHasValidFormat

On return, true if the preference value for the specified key was located and found to be of type Boolean, otherwise false. 
Return Value

The preference data for the specified key and application, or if no value was located, false. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFPreferencesGetAppBooleanValue (
   CFStringRef key,
   CFStringRef applicationID,
   Boolean *keyExistsAndHasValidFormat
);

#ifdef __cplusplus
}
#endif

#endif