#ifndef APPERANCE_H
#define APPERANCE_H


#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef COLLECTIONS_H
#include <CarbonCore/Collections.h>
#endif

#ifndef PROCESSES_H
#include <HIServices/Processes.h>
#endif


#include <HYS/HIToolbox/Appearance.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Theme Cursors

Identify types of cursors.

enum {
   kThemeArrowCursor = 0,
   kThemeCopyArrowCursor = 1,
   kThemeAliasArrowCursor = 2,
   kThemeContextualMenuArrowCursor = 3,
   kThemeIBeamCursor = 4,
   kThemeCrossCursor = 5,
   kThemePlusCursor = 6,
   kThemeWatchCursor = 7,
   kThemeClosedHandCursor = 8,
   kThemeOpenHandCursor = 9,
   kThemePointingHandCursor = 10,
   kThemeCountingUpHandCursor = 11,
   kThemeCountingDownHandCursor = 12,
   kThemeCountingUpAndDownHandCursor = 13,
   kThemeSpinningCursor = 14,
   kThemeResizeLeftCursor = 15,
   kThemeResizeRightCursor = 16,
   kThemeResizeLeftRightCursor = 17,
   kThemeNotAllowedCursor = 18
};
typedef UInt32 ThemeCursor;
Constants
kThemeArrowCursor

The cursor identified by this constant is typically used as the standard cursor.

Available in Mac OS X v10.0 and later.
kThemeCopyArrowCursor

The cursor identified by this constant is typically used when the cursor is over a location where a drag action would initiate a copy.

Available in Mac OS X v10.0 and later.
kThemeAliasArrowCursor

The cursor identified by this constant is typically used when the cursor is over a location where a drag action would create an alias or link.

Available in Mac OS X v10.0 and later.
kThemeContextualMenuArrowCursor

The cursor identified by this constant is typically used when the Control key is being pressed and the cursor is over a location where a contextual menu can be activated. 

Available in Mac OS X v10.0 and later.
kThemeIBeamCursor

The cursor identified by this constant is typically used when the cursor is over an area where the user can select text.

Available in Mac OS X v10.0 and later.
kThemeCrossCursor

The cursor identified by this constant is typically used when the cursor is over an area where the user can draw graphics.

Available in Mac OS X v10.0 and later.
kThemePlusCursor

The cursor identified by this constant is typically used when the cursor is over an area where the user can select table cells.

Available in Mac OS X v10.0 and later.
kThemeWatchCursor

The cursor identified by this constant is typically used to indicate that an operation is in progress. You can animate this cursor so that a hand of the watch appears to move.

Available in Mac OS X v10.0 and later.
kThemeClosedHandCursor

The cursor identified by this constant is typically used to indicate that an object has been grabbed and is being moved by the user.

Available in Mac OS X v10.0 and later.
kThemeOpenHandCursor

The cursor identified by this constant is typically used to indicate that an object may be grabbed or moved by the user.

Available in Mac OS X v10.0 and later.
kThemePointingHandCursor

The cursor identified by this constant has the appearance of a pointing hand. You would typically use this constant to indicate that the user may select an object by pressing the mouse button.

Available in Mac OS X v10.0 and later.
kThemeCountingUpHandCursor

The cursor identified by this constant is typically used to indicate that an operation is in progress. You can animate this cursor so that the fingers appear to open from the palm one by one.

Available in Mac OS X v10.0 and later.
kThemeCountingDownHandCursor

The cursor identified by this constant is typically used to indicate that an operation is in progress. You can animate this cursor so that the fingers appear to fold into the palm one by one.

Available in Mac OS X v10.0 and later.
kThemeCountingUpAndDownHandCursor

The cursor identified by this constant is typically used to indicate that an operation is in progress. You can animate this cursor so that the fingers appear to alternate between opening from the palm one by one and folding into the palm one by one.

Available in Mac OS X v10.0 and later.
kThemeSpinningCursor

The cursor identified by this constant is typically used to indicate that an operation is in progress.

Available in Mac OS X v10.0 and later.
kThemeResizeLeftCursor

The cursor identified by this constant is typically used to indicate that an object may be resized by dragging to the left. 

Available in Mac OS X v10.0 and later.
kThemeResizeRightCursor

The cursor identified by this constant is typically used to indicate that an object may be resized by dragging to the right.

Available in Mac OS X v10.0 and later.
kThemeResizeLeftRightCursor

The cursor identified by this constant is typically used to indicate that an object may be resized in either direction horizontally.

Available in Mac OS X v10.0 and later.
Discussion

You can pass constants of type ThemeCursor to the functions SetThemeCursor and SetAnimatedThemeCursor to specify the category of cursor to be displayed for your application. The Appearance Manager substitutes the theme-specific instance of the cursor for the cursor category as is appropriate. The ThemeCursor constants are available with Appearance Manager 1.1 and later.*/
enum {
   kThemeArrowCursor = 0,
   kThemeCopyArrowCursor = 1,
   kThemeAliasArrowCursor = 2,
   kThemeContextualMenuArrowCursor = 3,
   kThemeIBeamCursor = 4,
   kThemeCrossCursor = 5,
   kThemePlusCursor = 6,
   kThemeWatchCursor = 7,
   kThemeClosedHandCursor = 8,
   kThemeOpenHandCursor = 9,
   kThemePointingHandCursor = 10,
   kThemeCountingUpHandCursor = 11,
   kThemeCountingDownHandCursor = 12,
   kThemeCountingUpAndDownHandCursor = 13,
   kThemeSpinningCursor = 14,
   kThemeResizeLeftCursor = 15,
   kThemeResizeRightCursor = 16,
   kThemeResizeLeftRightCursor = 17,
   kThemeNotAllowedCursor = 18
};
typedef UInt32 ThemeCursor;

/*Theme Drawing States

Specify the state in which human interface elements are drawn.

enum {
   kThemeStateInactive = 0,
   kThemeStateActive = 1,
   kThemeStatePressed = 2,
   kThemeStateRollover = 6,
   kThemeStateUnavailable = 7,
   kThemeStateUnavailableInactive = 8
   kThemeStatePressedUp = 2,
   kThemeStatePressedDown = 3
};
typedef UInt32 ThemeDrawState;
Constants
kThemeStateInactive

The element is drawn in the inactive state. 

Available in Mac OS X v10.0 and later.
kThemeStateActive

The element is drawn in the active state. 

Available in Mac OS X v10.0 and later.
kThemeStatePressed

The element is drawn in the selected state.

Available in Mac OS X v10.0 and later.
kThemeStatePressedUp

For increment/decrement buttons (also known as "little arrows" controls), the increment button is drawn in the selected state.

Available with Appearance Manager 1.1 and later.
kThemeStatePressedDown

For increment/decrement buttons (also known as "little arrows" controls), the decrement button is drawn in the selected state.

Available with Appearance Manager 1.1 and later.*/
enum {
   kThemeStateInactive = 0,
   kThemeStateActive = 1,
   kThemeStatePressed = 2,
   kThemeStateRollover = 6,
   kThemeStateUnavailable = 7,
   kThemeStateUnavailableInactive = 8,
   kThemeStatePressedUp = 2,
   kThemeStatePressedDown = 3
};

/*Theme Font IDs

Identify types of fonts.

enum {
   kThemeSystemFont = 0,
   kThemeSmallSystemFont = 1,
   kThemeSmallEmphasizedSystemFont = 2,
   kThemeViewsFont = 3,
   kThemeEmphasizedSystemFont = 4,
   kThemeApplicationFont = 5,
   kThemeLabelFont = 6,
   kThemeMenuTitleFont = 100,
   kThemeMenuItemFont = 101,
   kThemeMenuItemMarkFont = 102,
   kThemeMenuItemCmdKeyFont = 103,
   kThemeWindowTitleFont = 104,
   kThemePushButtonFont = 105,
   kThemeUtilityWindowTitleFont = 106,
   kThemeAlertHeaderFont = 107,
   kThemeSystemFontDetail = 7,
   kThemeSystemFontDetailEmphasized = 8,
   kThemeCurrentPortFont = 200,
   kThemeToolbarFont = 108
};
typedef UInt16 ThemeFontID;
Constants
kThemeSystemFont

The current (large) system font. This is the font used to draw most interface elements. If you can't find a more appropriate ThemeFontID constant, you should use this one. This font is suitable for drawing titles on most custom widgets and buttons, as well as most static text in dialogs and windows.

Available with Appearance Manager 1.1 and later.
kThemeSmallSystemFont

The current small system font. This is the font used to draw interface elements when space is at a premium.

Available with Appearance Manager 1.1 and later.
kThemeSmallEmphasizedSystemFont

The current small, emphasized system font. This constant is identical to kThemeSmallSystemFont, except it draws bold or otherwise emphasized text, as is appropriate for your application’s language and script.

Available with Appearance Manager 1.1 and later.
kThemeViewsFont

The current views font. This is the font used to draw file and folder names in Finder windows or other browsable lists.

Available with Appearance Manager 1.1 and later.
kThemeEmphasizedSystemFont

The current emphasized system font. This constant is identical to kThemeSystemFont, except it draws bold or otherwise emphasized text, as is appropriate for your application’s language and script. 

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeApplicationFont

An analog to the Script Manager's notion of the Application Font. This font is a suitable default choice for your application's document-style text editing areas.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeLabelFont

Generally smaller than kThemeSmallSystemFont, this font is appropriate for drawing text labels next to image content that reinforces the meaning of the text, such as you may use with a bevel button. 

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeMenuTitleFont

The font used to draw menu titles in the menu bar. 

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeMenuItemFont

The font used to draw menu items in menus.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeMenuItemMarkFont

The font used to draw menu item marks in menus.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeMenuItemCmdKeyFont

The font used to draw menu item command key equivalents in menus.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeWindowTitleFont

The font used to draw text in most window title bars.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemePushButtonFont

The font used to draw text labels on push buttons.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeUtilityWindowTitleFont

The font used to draw text in utility window title bars.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeAlertHeaderFont

The font used to draw the first and most important message of an alert window.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeCurrentPortFont

Unlike the other ThemeFontID constants, kThemeCurrentPortFont doesn't map to a font appropriate to your application's language or script. It maps directly to the font, size, and style of the current QuickDraw port. This allows you to get somewhat customized behavior out of the functions that take ThemeFontID constants. 

Note, however, that kThemeCurrentPortFont does not support all QuickDraw styles on all platforms; in particular, outline and shadow style are not supported on Mac OS X. Additionally, kThemeCurrentPortFont is not completely unicode savvy; use of kThemeCurrentPortFont may result in errors having to do with the current port's font not being appropriate for rendering or measuring all glyphs in a given unicode string.

Because of overhead associated with gathering QuickDraw font information and converting it to the native font format on Mac OS X, using kThemeCurrentPortFont may slow down your text drawing and measuring significantly compared to other ThemeFontID constants. Use kThemeCurrentPortFont only as a last resort.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeToolbarFont

The font used to draw the label of a toolbar item. 

Available in Mac OS X 10.2 and later.
Discussion

A ThemeFontID constant is a virtual font ID that you can pass to one of the Appearance Manager’s text-related functions. Within these functions, the ThemeFontID is mapped to the appropriate font or fonts, size, and style based on a number of factors, including:
the system appearance (Platinum on Mac OS 9 and Aqua on Mac OS X)
the string to be rendered, if any
the language or script that the application is running in

The ThemeFontID constants allow you to get the correct text appearance for the platform your application is currently running on.*/
enum {
   kThemeSystemFont = 0,
   kThemeSmallSystemFont = 1,
   kThemeSmallEmphasizedSystemFont = 2,
   kThemeViewsFont = 3,
   kThemeEmphasizedSystemFont = 4,
   kThemeApplicationFont = 5,
   kThemeLabelFont = 6,
   kThemeMenuTitleFont = 100,
   kThemeMenuItemFont = 101,
   kThemeMenuItemMarkFont = 102,
   kThemeMenuItemCmdKeyFont = 103,
   kThemeWindowTitleFont = 104,
   kThemePushButtonFont = 105,
   kThemeUtilityWindowTitleFont = 106,
   kThemeAlertHeaderFont = 107,
   kThemeSystemFontDetail = 7,
   kThemeSystemFontDetailEmphasized = 8,
   kThemeCurrentPortFont = 200,
   kThemeToolbarFont = 108
};

/*SetThemeCursor

Sets the cursor to a version of the specified cursor type that is consistent with the current theme.

OSStatus SetThemeCursor (
   ThemeCursor inCursor
);
Parameters
inCursor

A value of type ThemeCursor. Pass a constant specifying the type of cursor to set; see “Theme Cursors” for a description of possible values.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Appearance Manager 1.1 introduces cursors that can change appearance with a theme change. In order to be theme-compliant, your program should use these theme-specific cursors whenever possible, instead of the classic black-and-white cursors. Because these are color cursors, they currently cannot be set from interrupt time. 

Your application should call the SetThemeCursor function to ensure that its cursors are theme-compliant, rather than the QuickDraw cursor utilities functions SetCursor or SetCCursor. If you wish an animatable cursor to be theme-compliant, call the function SetAnimatedThemeCursor. 
Special Considerations

Do not call SetThemeCursor at interrupt time.
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus SetThemeCursor (
   ThemeCursor inCursor
);

/*SetAnimatedThemeCursor

Animates a version of the specified cursor type that is consistent with the current theme.

OSStatus SetAnimatedThemeCursor (
   ThemeCursor inCursor,
   UInt32 inAnimationStep
);
Parameters
inCursor

A value of type ThemeCursor. Pass a constant specifying the type of cursor to set; see “Theme Cursors” for a description of the possible values. Note that only cursors designated as able to be animated should be used for this function. If you specify an unanimatable cursor type, SetAnimatedThemeCursor returns the error themeBadCursorIndexErr (–30565).
inAnimationStep

An unsigned 32-bit value. Pass a value specifying the current animation step of the cursor. To animate the cursor, increment the value by 1 with each call to SetAnimatedThemeCursor.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Appearance Manager 1.1 introduces cursors that can change appearance with a theme change. In order to be theme-compliant, your program should use these theme-specific cursors whenever possible, instead of the classic black-and-white cursors.

Your application should call the SetAnimatedThemeCursor function to ensure that its animated cursors are theme-compliant, rather than using any QuickDraw cursor utilities functions such as SetCursor, SetCCursor, SpinCursor, or RotateCursor. If you wish a non-animated cursor to be theme-compliant, call the function SetThemeCursor.

Because these are color cursors, they currently cannot be set from interrupt time. Therefore, if you support animated cursors that are changed at interrupt time you should continue to use your own cursors for now. 
Special Considerations

Do not call SetAnimatedThemeCursor at interrupt time.
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus SetAnimatedThemeCursor (
   ThemeCursor inCursor,
   UInt32 inAnimationStep
);

#ifdef __cplusplus
}
#endif

#endif