#ifndef CGIMAGESOURCE_H
#define CGIMAGESOURCE_H
#include <CoreGraphics/CoreGraphics.h>

/*Individual Image Properties

Defines properties that apply to an individual image in an image source.

CFStringRef kCGImagePropertyDPIHeight;
CFStringRef kCGImagePropertyDPIWidth;
CFStringRef kCGImagePropertyPixelWidth;
CFStringRef kCGImagePropertyPixelHeight;
CFStringRef kCGImagePropertyDepth;
CFStringRef kCGImagePropertyOrientation;
CFStringRef kCGImagePropertyIsFloat;
CFStringRef kCGImagePropertyIsIndexed;
CFStringRef kCGImagePropertyHasAlpha;
CFStringRef kCGImagePropertyColorModel;
CFStringRef kCGImagePropertyProfileName;
CFStringRef kCGImagePropertyCompressQuality;
Constants
kCGImagePropertyDPIHeight

The resolution, in dots per inch, in the x dimension. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyDPIWidth

The resolution, in dots per inch, in the y dimension. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyPixelWidth

The number of pixels in the x dimension. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyPixelHeight

The number of pixels in the y dimension. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyDepth

The number of bits in each color sample of each pixel. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyOrientation

The intended display orientation of the image. If present, this key is a CFNumber value with the same value as defined by the TIFF and Exif specifications. The value specifies where the origin (0,0) of the image is locates, as shown in Table 1. If not present, a value of 1 is assumed.
Table 1  
Value	
Location of the origin of the image

1	
Top, left 

2	
Top, right 

3	
Bottom, right 

4	
Bottom, left 

5	
Left, top 

6	
Right, top 

7	
Right, bottom 

8	
Left, bottom 


Available in Mac OS X v10.4 and later.
kCGImagePropertyIsFloat

Specifies whether or not the image contains floating-point pixel samples. The value of this key is kCFBooleanTrue if the image contains them.

Available in Mac OS X v10.4 and later.
kCGImagePropertyIsIndexed

Specifies whether or not the image contains indexed pixel samples (sometimes called paletted samples). The value of this key is kCFBooleanTrue if the image contains them.

Available in Mac OS X v10.4 and later.
kCGImagePropertyHasAlpha

Specifies whether or not the image has an alpha channel. The value of this key is kCFBooleanTrue if the image contains an alpha channel.

Available in Mac OS X v10.4 and later.
kCGImagePropertyColorModel

The color model of the image such as, "RGB", "CMYK", "Gray", or "Lab". The value of this key is CFStringRef.

Available in Mac OS X v10.4 and later.
kCGImagePropertyProfileName

The name of the optional ICC profile embedded in the image, if known. If present, the value of this key is a CFStringRef.

Available in Mac OS X v10.4 and later.
kCGImagePropertyCompressionQuality

The desired compression quality to use when writing to an image destination. If present, this key is a CFNumber value in the range 0.0 to 1.0.
Discussion

These properties can be returned by the function CGImageSourceCopyPropertiesAtIndex.*/
CFStringRef kCGImagePropertyDPIHeight;
CFStringRef kCGImagePropertyDPIWidth;
CFStringRef kCGImagePropertyPixelWidth;
CFStringRef kCGImagePropertyPixelHeight;
CFStringRef kCGImagePropertyDepth;
CFStringRef kCGImagePropertyOrientation;
CFStringRef kCGImagePropertyIsFloat;
CFStringRef kCGImagePropertyIsIndexed;
CFStringRef kCGImagePropertyHasAlpha;
CFStringRef kCGImagePropertyColorModel;
CFStringRef kCGImagePropertyProfileName;
CFStringRef kCGImagePropertyCompressQuality;


/*CGImageSourceRef

Defines an opaque type that represents a Quartz image source.

typedef struct CGImageSource *CGImageSourceRef;
Discussion

In Mac OS X v10.4 and later, CGImageSourceRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.4 and later.*/
typedef struct CGImageSource *CGImageSourceRef;

/*CGImageSourceCreateImageAtIndex

Creates a CGImage object for the image data associated with the specified index in an image source.

CGImageRef CGImageSourceCreateImageAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);
Parameters
isrc

An image source.
index

The index that specifies the location of the image. The index is zero-based. 
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

Returns a CGImage object.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CGImageRef CGImageSourceCreateImageAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);

/*CGImageSourceCopyPropertiesAtIndex

Returns the properties of the image at a specified location in an image source.

CFDictionaryRef CGImageSourceCopyPropertiesAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);
Parameters
isrc

An image source.
index

The index of the image whose properties you want to obtain. The index is zero-based. 
options

A dictionary you can use to request additional options. See “Image Source Option Dictionary Keys” for the keys you can supply.
Return Value

A dictionary that contains the properties associated with the image.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CFDictionaryRef CGImageSourceCopyPropertiesAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);

/*CGImageSourceCreateWithURL

Creates an image source that reads from a location specified by a URL.

CGImageSourceRef CGImageSourceCreateWithURL(
   CFURLRef url,
   CFDictionaryRef options
);
Parameters
url

The URL to read from.
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

A Quartz image source. You are responsible for releasing this object using CFRelease.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CGImageSourceRef CGImageSourceCreateWithURL(
   CFURLRef url,
   CFDictionaryRef options
);

/*CGImageSourceCopyTypeIdentifiers

Returns an array of uniform type identifiers (UTIs) that are supported for Quartz image sources.

CFArrayRef CGImageSourceCopyTypeIdentifiers ();
Return Value

Returns an array of the UTIs that are supported for image sources.
Discussion

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CFArrayRef CGImageSourceCopyTypeIdentifiers ();

#endif