#ifndef MOVIES_H
#define MOVIES_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif

#ifndef COREAUDIO_H
#include <CoreAudio/CoreAudio.h>
#endif

#ifndef IMAGECOMPRESSION_H
#include <QuickTime/ImageCompression.h>
#endif

#ifndef  QUICKTIMEERRORS_H
#include <QuickTime/QuickTimeErrors.h>
#endif


#include <HYS/QuickTime/Movies.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Using pdActionCustomDoEditCommand to Handle Edit Commands

pdActionCustomDoEditCommand tells your control to handle edit commands if it allow focus and type in boxes.

All custom controls must implement this call if they support edit boxes. 
struct QTCustomControlDoEditCommandRecord {
    void * storage; / storage for the control*
    long command; /*command to execute, return 0 here if processed*
};
typedef struct QTCustomControlDoEditCommandRecord QTCustomControlDoEditCommandRecord;
 
typedef QTCustomControlDoEditCommandRecord * QTCustomControlDoEditCommandPtr;
typedef long QTParameterDialog;a
enum {
    elOptionsIncludeNoneInList  = 0x00000001 / "None" effect is included
                                                in list *
};
typedef long QTEffectListOptions;
enum {
    pdOptionsCollectOneValue = 0x00000001, / should collect a single
                                            value only*
pdOptionsAllowOptionalInterpolations = 0x00000002, / non-novice
                                    interpolation options are shown *
pdOptionsModalDialogBox = 0x00000004, /dialog box should be modal *
pdOptionsEditCurrentEffectOnly = 0x00000008, / List of effects will not
                                                be shown /
pdOptionsHidePreview = 0x00000010 / Preview item will not be shown *
enum {
    effectIsRealtime = 0 / effect can be rendered in real time *
};*/

struct QTCustomControlDoEditCommandRecord {
    void * storage; /* storage for the control*/
    long command; /* command to execute, return 0 here if processed*/
};
typedef struct QTCustomControlDoEditCommandRecord QTCustomControlDoEditCommandRecord;
 
typedef QTCustomControlDoEditCommandRecord * QTCustomControlDoEditCommandPtr;
typedef long QTParameterDialog;
enum {
    elOptionsIncludeNoneInList  = 0x00000001 /* "None" effect is included
                                                in list */
};
typedef long QTEffectListOptions;
enum {
    pdOptionsCollectOneValue = 0x00000001, /* should collect a single
                                            value only*/
pdOptionsAllowOptionalInterpolations = 0x00000002, /* non-novice
                                    interpolation options are shown */
pdOptionsModalDialogBox = 0x00000004, /* dialog box should be modal */
pdOptionsEditCurrentEffectOnly = 0x00000008, /* List of effects will not
                                                be shown */
pdOptionsHidePreview = 0x00000010 /* Preview item will not be shown */
};
enum {
    effectIsRealtime = 0 /* effect can be rendered in real time */
};
/*Properties of the movie that is extracted from kQTPropertyClass_MovieAudioExtraction_Movie include the following movie class IDs: 
kQTMovieAudioExtractionMoviePropertyID_CurrentTime. The value is a TimeRecord, which you can set and get. When setting, you set the timescale to anything you want (for example, the output audio sample rate or the movie timescale). When getting, the timescale will be output audio sample rate for best accuracy.
kQTMovieAudioExtractionMoviePropertyID_AllChannelsDiscrete. The value is Boolean (which is settable and gettable). Set to implement export of all audio channels without mixing. When this is set and the extraction audio stream basic description (ASBD) or channel layout are read back, you get information relating to the re-mapped movie.
kQTMovieAudioExtractionMoviePropertyID_CurrentTime = ‘time’. The value is a TimeRecord , which is gettable and settable.*/

enum{
kQTMovieAudioExtractionMoviePropertyID_CurrentTime = 'time'
};


/*Returns the load state of the target movie. <0 indicates an error.   
  kMovieLoadStateLoading      = 1000,    
 kMovieLoadStatePlayable     = 10000,    
 kMovieLoadStatePlaythroughOK = 20000,  
   kMovieLoadStateComplete     = 100000L
kOperandMovieTrackCount = 1034,*/
enum{
kMovieLoadStateLoading      = 1000,
 kMovieLoadStatePlayable     = 10000,
 kMovieLoadStatePlaythroughOK = 20000,
 kMovieLoadStateComplete     = 100000L,
kOperandMovieTrackCount = 1034,
};
/*QTPropertyClass_SampleTable

Constants grouped with kQTPropertyClass_SampleTable.

enum {
   /*
   * Property class for sample tables.
   */
//   kQTPropertyClass_SampleTable  = 'qtst',
   /*
   * The total decode duration of all samples in the sample table.
   * Read-only.
   */
//   kQTSampleTablePropertyID_TotalDecodeDuration = 'tded',
   /* TimeValue64,
   Read */
   /*
   * The least display offset in the table. (-50 is a lesser offset
   * than 20.)  Read-only.
   */
//   kQTSampleTablePropertyID_MinDisplayOffset = '<ddd',
   /* TimeValue64,
   Read */
   /*
   * The greatest display offset in the table. (20 is a greater offset
   * than -50.)  Read-only.
   */
//   kQTSampleTablePropertyID_MaxDisplayOffset = '>ddd',
   /* TimeValue64,
   Read */
   /*
   * The least display time of all samples in the table,
   relative to
   * the decode time of the first sample in the table.  Read-only.
   */
//   kQTSampleTablePropertyID_MinRelativeDisplayTime = '<dis',
   /* TimeValue64,
   Read */
   /*
   * The greatest display time of all samples in the table,
   relative to
   * the decode time of the first sample in the table.  Read-only.
   */
  // kQTSampleTablePropertyID_MaxRelativeDisplayTime = '>dis' /* TimeValue64,
//   Read */
//};
//Declared In
//Movies.h*/

enum {
   /*
   * Property class for sample tables.
   */
   kQTPropertyClass_SampleTable  = 'qtst',
   /*
   * The total decode duration of all samples in the sample table.
   * Read-only.
   */
   kQTSampleTablePropertyID_TotalDecodeDuration = 'tded',
   /* TimeValue64,
   Read */
   /*
   * The least display offset in the table. (-50 is a lesser offset
   * than 20.)  Read-only.
   */
   kQTSampleTablePropertyID_MinDisplayOffset = '<ddd',
   /* TimeValue64,
   Read */
   /*
   * The greatest display offset in the table. (20 is a greater offset
   * than -50.)  Read-only.
   */
   kQTSampleTablePropertyID_MaxDisplayOffset = '>ddd',
   /* TimeValue64,
   Read */
   /*
   * The least display time of all samples in the table,
   relative to
   * the decode time of the first sample in the table.  Read-only.
   */
   kQTSampleTablePropertyID_MinRelativeDisplayTime = '<dis',
   /* TimeValue64,
   Read */
   /*
   * The greatest display time of all samples in the table,
   relative to
   * the decode time of the first sample in the table.  Read-only.
   */
   kQTSampleTablePropertyID_MaxRelativeDisplayTime = '>dis' /* TimeValue64,
   Read */
};



/*QTSampleTableGetSampleFlags Values

Constants passed to QTSampleTableGetSampleFlags.

enum {
   mediaSampleNotSync            = 1 << 0,
   // sample is not a sync sample (eg. is frame differenced 
   mediaSampleShadowSync         = 1 << 1,
   // sample is a shadow sync 
   mediaSampleDroppable          = 1 << 27,
   // sample is not required to be decoded for later samples to be decoded properly
   mediaSamplePartialSync        = 1 << 16,
   //sample is a partial sync (e.g
   //I frame after open GOP)
   mediaSampleHasRedundantCoding = 1 << 24,
   // sample is known to contain redundant coding 
   mediaSampleHasNoRedundantCoding = 1 << 25,
   / sample is known not to contain redundant coding 
   mediaSampleIsDependedOnByOthers = 1 << 26,
   // one or more other samples depend upon the decode of this sample 
   mediaSampleIsNotDependedOnByOthers = 1 << 27,
   // synonym for mediaSampleDroppable 
   mediaSampleDependsOnOthers    = 1 << 28,
   // sample's decode depends upon decode of other samples 
   mediaSampleDoesNotDependOnOthers = 1 << 29,
   // sample's decode does not depend upon decode of other samples 
   mediaSampleEarlierDisplayTimesAllowed = 1 << 30 / samples later in decode order may have earlier display times 
};
Constants
mediaSampleNotSync

Returned for frame-differenced video sample data. 

Available in Mac OS X v10.0 and later.*/

enum {
   mediaSampleNotSync            = 1 << 0,
   /* sample is not a sync sample (eg. is frame differenced */
   mediaSampleShadowSync         = 1 << 1,
   /* sample is a shadow sync */
   mediaSampleDroppable          = 1 << 27,
   /* sample is not required to be decoded for later samples to be decoded properly */
   mediaSamplePartialSync        = 1 << 16,
   /* sample is a partial sync (e.g.,
   I frame after open GOP) */
   mediaSampleHasRedundantCoding = 1 << 24,
   /* sample is known to contain redundant coding */
   mediaSampleHasNoRedundantCoding = 1 << 25,
   /* sample is known not to contain redundant coding */
   mediaSampleIsDependedOnByOthers = 1 << 26,
   /* one or more other samples depend upon the decode of this sample */
   mediaSampleIsNotDependedOnByOthers = 1 << 27,
   /* synonym for mediaSampleDroppable */
   mediaSampleDependsOnOthers    = 1 << 28,
   /* sample's decode depends upon decode of other samples */
   mediaSampleDoesNotDependOnOthers = 1 << 29,
   /* sample's decode does not depend upon decode of other samples */
   mediaSampleEarlierDisplayTimesAllowed = 1 << 30 /* samples later in decode order may have earlier display times */
};
/*Metadata Property IDs

The property IDs in this section are used with functions of the form QTMetaData...

Following are constants for the QTMetaDataRef type:
kPropertyClass_QTMetaData = 'meta'

The QuickTime metadata property class.
kQTMetaDataPropertyID_StorageFormats = 'fmts'

The list of storage formats of type QTMetaDataStorageFormat associated with a QTMetaDataRef object. The read-only return value is a C-style array of OSType values.
kQTMetaDataPropertyID_OwnerType = 'ownt'

The owner type associated with a QTMetaDataRef object. The read-only return value is an OSType (QT_MOVIE_TYPE, QT_TRACK_TYPE, or QT_MEDIA_TYPE).
kQTMetaDataPropertyID_Owner = 'ownr'

The owner associated with a QTMetaDataRef object, which does not necessarily need an owner. The read-only return value is type Movie, Track, or Media.

Following are constants for the QTMetaDataItem type:
kPropertyClass_QTMetaDataItem = 'mdit'

The metadata item property class ID
kQTMetaDataItemPropertyID_Value = 'valu'

The value of the metadata item. The read-only return value is a C-style array of values of type UInt8.
kQTMetaDataItemPropertyID_DataType = 'dtyp'

The value type of the metadata item. The read/write return value is type UInt32.
kQTMetaDataItemPropertyID_StorageFormat = 'sfmt'

The storage format of the metadata item. The read-only return value is type QTMetaDataStorageFormat.
kQTMetaDataItemPropertyID_Key = 'key ' [last char is space]

The key associated with the metadata item. The read/write return value is a C-style array of values of type UInt8.
kQTMetaDataItemPropertyID_KeyFormat = 'keyf'

The format of the metadata item key. The read/write return value is type OSType.
kQTMetaDataItemPropertyID_Locale = 'loc '

The locale identifier based on the naming convention defined by the International Components for Unicode (ICU). The identifier consists of two pieces of ordered information: a language code and a region code. The language code is based on the ISO 639-1 standard, which defines two-character codes, such as en and fr, for the world’s most commonly used languages. If a two-letter code is not available, then ISO 639-2 three-letter identifiers are accepted as well; for example, haw for Hawaiian. The region code is defined by ISO 3166-1. It is all uppercase and is appended, with an underscore, after the language code; for example en_US, en_GB, and fr_FR. The read/write return value is a C string of type UInt32.*/
enum {
kPropertyClass_QTMetaData = 'meta' ,
kQTMetaDataPropertyID_StorageFormats = 'fmts',
kQTMetaDataPropertyID_OwnerType = 'ownt',
kQTMetaDataPropertyID_Owner = 'ownr'
};

enum {
kPropertyClass_QTMetaDataItem = 'mdit',
kQTMetaDataItemPropertyID_Value = 'valu',
kQTMetaDataItemPropertyID_DataType = 'dtyp',
kQTMetaDataItemPropertyID_StorageFormat = 'sfmt',
kQTMetaDataItemPropertyID_Key = 'key ' ,
kQTMetaDataItemPropertyID_KeyFormat = 'keyf',
kQTMetaDataItemPropertyID_Locale = 'loc '
};


/*inDataType

A data type from the following list: kQTMetaDataTypeBinary = 0, kQTMetaDataTypeUTF8 = 1, kQTMetaDataTypeUTF16BE = 2, kQTMetaDataTypeMacEncodedText = 3, kQTMetaDataTypeSignedIntegerBE = 21, kQTMetaDataTypeUnsignedIntegerBE = 22, kQTMetaDataTypeFloat32BE = 23, kQTMetaDataTypeFloat64BE = 24With kQTMetaDataTypeSignedIntegerBE and kQTMetaDataTypeUnsignedIntegerBE, the size of the integer is determined by the value size.*/
enum {
 kQTMetaDataTypeBinary = 0, 
kQTMetaDataTypeUTF8 = 1,
 kQTMetaDataTypeUTF16BE = 2,
 kQTMetaDataTypeMacEncodedText = 3, 
kQTMetaDataTypeSignedIntegerBE = 21, 
kQTMetaDataTypeUnsignedIntegerBE = 22,
 kQTMetaDataTypeFloat32BE = 23,
kQTMetaDataTypeFloat64BE = 24
};

/*Metadata Format Constants

The format constants in this section are used with functions of the form QTMetaData...

Following are constants for the QTMetaDataStorageFormat type:
kQTMetaDataStorageFormatQuickTime = 'mdta'

The QuickTime metadata storage format
kQTMetaDataKeyFormatQuickTime = 'mdta'

Reverse DNS format
kQTMetaDataStorageFormatiTunes = 'itms'

The iTunes metadata storage format

Following are constants for the QTMetaDataKeyFormat type:
kQTMetaDataKeyFormatiTunesShortForm = 'itsk'

A four-character code
kQTMetaDataKeyFormatiTunesLongForm = 'itlk'

Reverse DNS format

Following are constants for user data formats:
kQTMetaDataStorageFormatUserData = 'udta'

User data storage format
kQTMetaDataKeyFormatUserData = 'udta',

User data key storage format*/
enum {
kQTMetaDataStorageFormatQuickTime = 'mdta' ,
kQTMetaDataKeyFormatQuickTime = 'mdta',
kQTMetaDataStorageFormatiTunes = 'itms',
kQTMetaDataKeyFormatiTunesShortForm = 'itsk',
kQTMetaDataKeyFormatiTunesLongForm = 'itlk',
kQTMetaDataStorageFormatUserData = 'udta',
kQTMetaDataKeyFormatUserData = 'udta',
};

/*Hint Flags

Constants that represent hint flags.

enum {
   hintsScrubMode                = 1 << 0,
   // mask == && (if flags == scrub on,
   f//lags != scrub off) 
   hintsLoop                     = 1 << 1,
   hintsDontPurge                = 1 << 2,
   hintsUseScreenBuffer          = 1 << 5,
   hintsAllowInterlace           = 1 << 6,
   hintsUseSoundInterp           = 1 << 7,
   hintsHighQuality              = 1 << 8,
   // slooooow 
   hintsPalindrome               = 1 << 9,
   hintsInactive                 = 1 << 11,
   hintsOffscreen                = 1 << 12,
   hintsDontDraw                 = 1 << 13,
   hintsAllowBlacklining         = 1 << 14,
   hintsDontUseVideoOverlaySurface = 1 << 16,
   hintsIgnoreBandwidthRestrictions = 1 << 17,
   hintsPlayingEveryFrame        = 1 << 18,
   hintsAllowDynamicResize       = 1 << 19,
   hintsSingleField              = 1 << 20,
   hintsNoRenderingTimeOut       = 1 << 21,
   hintsFlushVideoInsteadOfDirtying = 1 << 22,
   hintsEnableSubPixelPositioning = 1L << 23,
   hintsRenderingMode            = 1L << 24,
   hintsAllowIdleSleep           = 1L << 25,
   // asks media handlers not to call UpdateSystemActivity etc 
   hintsDeinterlaceFields        = 1L << 26
};
Constants
hintsAllowIdleSleep

Asks media handlers not to call UpdateSystemActivity etc. 

Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
enum {
   hintsScrubMode                = 1 << 0,
   /* mask == && (if flags == scrub on,
   flags != scrub off) */
   hintsLoop                     = 1 << 1,
   hintsDontPurge                = 1 << 2,
   hintsUseScreenBuffer          = 1 << 5,
   hintsAllowInterlace           = 1 << 6,
   hintsUseSoundInterp           = 1 << 7,
   hintsHighQuality              = 1 << 8,
   /* slooooow */
   hintsPalindrome               = 1 << 9,
   hintsInactive                 = 1 << 11,
   hintsOffscreen                = 1 << 12,
   hintsDontDraw                 = 1 << 13,
   hintsAllowBlacklining         = 1 << 14,
   hintsDontUseVideoOverlaySurface = 1 << 16,
   hintsIgnoreBandwidthRestrictions = 1 << 17,
   hintsPlayingEveryFrame        = 1 << 18,
   hintsAllowDynamicResize       = 1 << 19,
   hintsSingleField              = 1 << 20,
   hintsNoRenderingTimeOut       = 1 << 21,
   hintsFlushVideoInsteadOfDirtying = 1 << 22,
   hintsEnableSubPixelPositioning = 1L << 23,
   hintsRenderingMode            = 1L << 24,
   hintsAllowIdleSleep           = 1L << 25,
   /* asks media handlers not to call UpdateSystemActivity etc */
   hintsDeinterlaceFields        = 1L << 26
};
/*loopTimeBase

Constants grouped with loopTimeBase.

enum {
   loopTimeBase                  = 1,
   palindromeLoopTimeBase        = 2,
   maintainTimeBaseZero          = 4
};
Declared In
Movies.h*/
enum {
   loopTimeBase                  = 1,
   palindromeLoopTimeBase        = 2,
   maintainTimeBaseZero          = 4
};


/*New Movie Property Codes

The following codes are stored in the propClass fields of QTNewMoviePropertyElement data structures, which pass them to NewMovieFromProperties.kQTPropertyClass_DataLocation = 'dloc',
        kQTDataLocationPropertyID_DataReference             = 'dref',
           // DataReferenceRecord *
        kQTDataLocationPropertyID_CFStringNativePath        = 'cfnp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringPosixPath         = 'cfpp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringHFSPath           = 'cfhp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringWindowsPath       = 'cfwp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFURL                     = 'cfur',
           // CFURLRef *
        kQTDataLocationPropertyID_QTDataHandler             = 'qtdh',
           // DataHandler *
        kQTDataLocationPropertyID_Scrap                     = 'scrp',
           // NULL
        kQTDataLocationPropertyID_LegacyMovieResourceHandle = 'rezh',
           // Handle *
        kQTDataLocationPropertyID_MovieUserProc             = 'uspr',
           // QTNewMovieUserProcRecord *
        kQTDataLocationPropertyID_ResourceFork              = 'rfrk',
           // SInt16 *
        kQTDataLocationPropertyID_DataFork                  = 'dfrk',
           // SInt16 *
 
kQTPropertyClass_Audio = 'audi',
        kQTAudioPropertyID_RateChangesPreservePitch         = 'aucp', // Boolean *
 
 kQTPropertyClass_Context = 'ctxt',
        kQTContextPropertyID_AudioContext       = 'audi',
           // QTAudioContextRef *
        kQTContextPropertyID_VisualContext      = 'visu',
           // QTVisualContextRef *
 
 kQTPropertyClass_MovieResourceLocator = 'rloc',
        kQTMovieResourceLocatorPropertyID_LegacyResID   = 'rezi',
           // SInt16 * (input/output property)
        kQTMovieResourceLocatorPropertyID_LegacyResName = 'rezn',
           // Str255   (output property)
        kQTMovieResourceLocatorPropertyID_FileOffset    = 'foff',
           // UInt64 *
        kQTMovieResourceLocatorPropertyID_Callback      = 'calb',
           // User-defined
 
 kQTPropertyClass_MovieInstantiation = 'mins',
        kQTMovieInstantiationPropertyID_DontResolveDataRefs         = 'rdrn',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAskUnresolvedDataRefs   = 'aurn',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAutoAlternates          = 'aaln',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontUpdateForeBackPointers  = 'fbpn',
           // Boolean *
        kQTMovieInstantiationPropertyID_AsyncOK                     = 'asok',
           // Boolean *
        kQTMovieInstantiationPropertyID_IdleImportOK                = 'imok',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAutoUpdateClock         = 'aucl',
           // Boolean *
        kQTMovieInstantiationPropertyID_ResultDataLocationChanged   = 'dlch',
           // Boolean * (output property)
 
 kQTPropertyClass_NewMovieProperty = 'mprp',
        kQTNewMoviePropertyID_DefaultDataRef        = 'ddrf',
           // DataReferenceRecord *
        kQTNewMoviePropertyID_Active                = 'actv',
           // Boolean *
        kQTNewMoviePropertyID_DontInteractWithUser  = 'intn',
           // Boolean **/
enum {
kQTPropertyClass_DataLocation = 'dloc',
        kQTDataLocationPropertyID_DataReference             = 'dref',
           // DataReferenceRecord *
        kQTDataLocationPropertyID_CFStringNativePath        = 'cfnp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringPosixPath         = 'cfpp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringHFSPath           = 'cfhp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringWindowsPath       = 'cfwp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFURL                     = 'cfur',
           // CFURLRef *
        kQTDataLocationPropertyID_QTDataHandler             = 'qtdh',
           // DataHandler *
        kQTDataLocationPropertyID_Scrap                     = 'scrp',
           // NULL
        kQTDataLocationPropertyID_LegacyMovieResourceHandle = 'rezh',
           // Handle *
        kQTDataLocationPropertyID_MovieUserProc             = 'uspr',
           // QTNewMovieUserProcRecord *
        kQTDataLocationPropertyID_ResourceFork              = 'rfrk',
           // SInt16 *
        kQTDataLocationPropertyID_DataFork                  = 'dfrk',
           // SInt16 *
 
kQTPropertyClass_Audio = 'audi',
        kQTAudioPropertyID_RateChangesPreservePitch         = 'aucp', // Boolean *
 
 kQTPropertyClass_Context = 'ctxt',
        kQTContextPropertyID_AudioContext       = 'audi',
           // QTAudioContextRef *
        kQTContextPropertyID_VisualContext      = 'visu',
           // QTVisualContextRef *
 
 kQTPropertyClass_MovieResourceLocator = 'rloc',
        kQTMovieResourceLocatorPropertyID_LegacyResID   = 'rezi',
           // SInt16 * (input/output property)
        kQTMovieResourceLocatorPropertyID_LegacyResName = 'rezn',
           // Str255   (output property)
        kQTMovieResourceLocatorPropertyID_FileOffset    = 'foff',
           // UInt64 *
        kQTMovieResourceLocatorPropertyID_Callback      = 'calb',
           // User-defined
 
 kQTPropertyClass_MovieInstantiation = 'mins',
        kQTMovieInstantiationPropertyID_DontResolveDataRefs         = 'rdrn',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAskUnresolvedDataRefs   = 'aurn',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAutoAlternates          = 'aaln',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontUpdateForeBackPointers  = 'fbpn',
           // Boolean *
        kQTMovieInstantiationPropertyID_AsyncOK                     = 'asok',
           // Boolean *
        kQTMovieInstantiationPropertyID_IdleImportOK                = 'imok',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAutoUpdateClock         = 'aucl',
           // Boolean *
        kQTMovieInstantiationPropertyID_ResultDataLocationChanged   = 'dlch',
           // Boolean * (output property)
 
 kQTPropertyClass_NewMovieProperty = 'mprp',
        kQTNewMoviePropertyID_DefaultDataRef        = 'ddrf',
           // DataReferenceRecord *
        kQTNewMoviePropertyID_Active                = 'actv',
           // Boolean *
        kQTNewMoviePropertyID_DontInteractWithUser  = 'intn',
           // Boolean *
};

/*QTNewMoviePropertyElement

Stores a movie property for NewMovieFromProperties.

struct QTNewMoviePropertyElement {
   QTPropertyClass       propClass;
   QTPropertyID          propID;
   ByteCount             propValueSize;
   QTPropertyValuePtr    propValueAddress;
   OSStatus              propStatus;
};
Fields
propClass
Discussion

A four-character code designating the class of a movie property. See New Movie Property Codes.
propID
Discussion

The ID of the property.
propValueSize
Discussion

The size in bytes of the property passed in propValueAddress.
propValueAddress
Discussion

A pointer to a movie property. Since the data type is fixed for each element's property class and ID, these is no ambiguity about the data type for its property value.
propStatus
Discussion

Indicates any problems with the property. For example, if a property is not understood by the function it is passed to, this field is set appropriately. See the discussion in NewMovieFromProperties.
Discussion

When you call NewMovieFromProperties, you allocate and own arrays of these elements to pass to it, as well as the property values that each element points to. You are responsible for disposing of all of these memory allocations.
Related Functions
Associated function: NewMovieFromProperties 
Declared In
Movies.h*/
struct QTNewMoviePropertyElement {
   QTPropertyClass       propClass;
   QTPropertyID          propID;
   ByteCount             propValueSize;
   QTPropertyValuePtr    propValueAddress;
   OSStatus              propStatus;
};
typedef struct QTNewMoviePropertyElement QTNewMoviePropertyElement;

/*/*Atom ID Codes

Identify the four-character type codes of atoms.

enum {
   ConnectionSpeedPrefsType      = 'cspd',
   ConnectionSpeedIsValidPrefsType = 'vspd'
};
enum {
   kEffectNameAtom               = 'name',
   // name of effect 
   kEffectTypeAtom               = 'type',
   //codec sub-type for effect 
   kEffectManufacturerAtom       = 'manu' // codec manufacturer for effect 
};
enum {
   kGraphicsExportGroup          = 'expo',
   kGraphicsExportFileType       = 'ftyp',
   kGraphicsExportMIMEType       = 'mime',
   kGraphicsExportExtension      = 'ext ',
   kGraphicsExportDescription    = 'desc'
};
enum {
   kInputMapSubInputID           = 'subi'
};
enum {
   kMovieMediaDataReference      = 'mmdr',
   // data reference
   kMovieMediaDefaultDataReferenceID = 'ddri',
   //atom id
   kMovieMediaSlaveTime          = 'slti',
   // boolean
   kMovieMediaSlaveAudio         = 'slau',
   // boolean
   kMovieMediaSlaveGraphicsMode  = 'slgr',
   // boolean
   kMovieMediaAutoPlay           = 'play',
   // boolean
   kMovieMediaLoop               = 'loop',
   / /UInt8 (0=no loop,
   1=loop,
   2=palindrome loop)
   kMovieMediaUseMIMEType        = 'mime',
   / string indicating the MIME type to use for the dataref (usually not required)
   kMovieMediaTitle              = 'titl',
   // string of the media's title (tooltips)
   kMovieMediaAltText            = 'altt',
   / string of alternate text if media isn't loaded
   kMovieMediaClipBegin          = 'clpb',
   / MovieMediaTimeRecord of start time of embedded media/
   kMovieMediaClipDuration       = 'clpd',
   /MovieMediaTimeRecord of duration of embedded media/
   kMovieMediaRegionAtom         = 'regi',
   / contains subatoms that describe layout/
   kMovieMediaSlaveTrackDuration = 'sltr',
   / Boolean indicating that media handler should adjust track and media based on actual embedded movie duration/
   kMovieMediaEnableFrameStepping = 'enfs',
   / boolean. if true stepping on external movie steps frames within embedded movie./
   kMovieMediaBackgroundColor    = 'bkcl',
   / RGBColor./
   kMovieMediaPrerollTime        = 'prer' / SInt32 indicating preroll time/
};
enum {
   kMovieMediaSpatialAdjustment  = 'fit ',
   / OSType from kMovieMediaFit/
   kMovieMediaRectangleAtom      = 'rect',
   kMovieMediaTop                = 'top ',
   kMovieMediaLeft               = 'left',
   kMovieMediaWidth              = 'wd  ',
   kMovieMediaHeight             = 'ht  '
};
enum {
   kQTEventType                  = 'evnt',
   kAction                       = 'actn',
   kWhichAction                  = 'whic',
   kActionParameter              = 'parm',
   kActionTarget                 = 'targ',
   kActionFlags                  = 'flag',
   kActionParameterMinValue      = 'minv',
   kActionParameterMaxValue      = 'maxv',
   kActionListAtomType           = 'list',
   kExpressionContainerAtomType  = 'expr',
   kConditionalAtomType          = 'test',
   kOperatorAtomType             = 'oper',
   kOperandAtomType              = 'oprn',
   kCommentAtomType              = 'why ',
   kCustomActionHandler          = 'cust',
   kCustomHandlerID              = 'id  ',
   kCustomHandlerDesc            = 'desc',
   kQTEventRecordAtomType        = 'erec'
};
enum {
   kQTParseTextHREFText          = 'text',
   / string/
   kQTParseTextHREFBaseURL       = 'burl',
   / string/
   kQTParseTextHREFClickPoint    = 'clik',
   / Point; if present,
   QTParseTextHREF will expand URLs to support server-side image maps/
   kQTParseTextHREFUseAltDelim   = 'altd',
   / boolean; if no kQTParseTextHREFDelimiter,
   delim is ':'/
   kQTParseTextHREFDelimiter     = 'delm',
   /character/
   kQTParseTextHREFRecomposeHREF = 'rhrf' / Boolean; if true,
   QTParseTextHREF returns recomposed HREF with URL expanded as appropriate/
};
enum {
   kQTResolutionSettings         = 'reso',
   kQTTargetDataSize             = 'dasz',
   kQTDontRecompress             = 'dntr',
   kQTInterlaceStyle             = 'ilac',
   kQTColorSyncProfile           = 'iccp',
   kQTThumbnailSettings          = 'thum',
   kQTEnableExif                 = 'exif',
   / UInt8 (boolean)/
   kQTMetaData                   = 'meta'
};
enum {
   kQTSConnectionPrefsType       = 'stcm',
   / root atom that all other atoms are contained in/
   /    kQTSNotUsedForProxyPrefsType = 'nopr',
   //        comma-delimited list of URLs that are never used for proxies/
   kQTSConnectionMethodPrefsType = 'mthd',
   /      connection method (OSType that matches one of the following three)/
   kQTSDirectConnectPrefsType    = 'drct',
   /       used if direct connect (QTSDirectConnectPrefsRecord)/
   /    kQTSRTSPProxyPrefsType =     'rtsp',
   //   used if RTSP Proxy (QTSProxyPrefsRecord)/
   kQTSSOCKSPrefsType            = 'sock' /      used if SOCKS Proxy (QTSProxyPrefsRecord)/
};
enum {
   kQTSNullNotification          = 'null',
   / NULL /
   kQTSErrorNotification         = 'err ',
   / QTSErrorParams,
   optional /
   kQTSNewPresDetectedNotification = 'newp',
   / QTSNewPresDetectedParams* /
   kQTSPresBeginChangingNotification = 'prcb',
   / NULL /
   kQTSPresDoneChangingNotification = 'prcd',
   / NULL /
   kQTSPresentationChangedNotification = 'prch',
   / NULL /
   kQTSNewStreamNotification     = 'stnw',
   / QTSNewStreamParams* /
   kQTSStreamBeginChangingNotification = 'stcb',
   / QTSStream /
   kQTSStreamDoneChangingNotification = 'stcd',
   / QTSStream /
   kQTSStreamChangedNotification = 'stch',
   / QTSStreamChangedParams/
   kQTSStreamGoneNotification    = 'stgn',
   / QTSStreamGoneParams/
   kQTSPreviewAckNotification    = 'pvak',
   / QTSStream /
   kQTSPrerollAckNotification    = 'pack',
   / QTSStream /
   kQTSStartAckNotification      = 'sack',
   / QTSStream /
   kQTSStopAckNotification       = 'xack',
   / QTSStream /
   kQTSStatusNotification        = 'stat',
   / QTSStatusParams/
   kQTSURLNotification           = 'url ',
   / QTSURLParams/
   kQTSDurationNotification      = 'dura',
   / QTSDurationAtom/
   kQTSNewPresentationNotification = 'nprs',
   / QTSPresentation /
   kQTSPresentationGoneNotification = 'xprs',
   / QTSPresentation /
   kQTSPresentationDoneNotification = 'pdon',
   / NULL /
   kQTSBandwidthAlertNotification = 'bwal',
   / QTSBandwidthAlertParams/
   kQTSAnnotationsChangedNotification = 'meta' / NULL /
};
enum {
   kQTSStatisticsInfo            = 'stat',
   / QTSStatisticsParams* /  
   kQTSMinStatusDimensionsInfo   = 'mstd',
   / QTSDimensionParams/
   kQTSNormalStatusDimensionsInfo = 'nstd',
   /QTSDimensionParams* /
   kQTSTotalDataRateInfo         = 'drtt',
   / UInt32,
   add to what's there /
   kQTSTotalDataRateInInfo       = 'drti',
   / UInt32,
   add to what's there /
   kQTSTotalDataRateOutInfo      = 'drto',
   / UInt32*,
   add to what's there * /
   kQTSLostPercentInfo           = 'lpct',
   / * QTSLostPercentParams*,
   add to what's there * /
   kQTSNumViewersInfo            = 'nviw',
   / *  UInt32* *  /
   kQTSMediaTypeInfo             = 'mtyp',
   / *  OSType* * /
   kQTSNameInfo                  = 'name',
   / * QTSNameParams* * /
   kQTSCanHandleSendDataType     = 'chsd',
   /* QTSCanHandleSendDataTypeParams* * /   
   kQTSAnnotationsInfo           = 'meta',
   / * QTAtomContainer * /
   kQTSRemainingBufferTimeInfo   = 'btms',
   / * UInt32* remaining buffer time before playback,
   in microseconds * /
   kQTSInfo_SettingsText         = 'sttx',
   / * QTSSettingsTextParams* * /
   kQTSInfo_AverageFrameRate     = 'fps ' / *   UnsignedFixed* * /
};
enum {
   kQTSStreamMediaType           = 'strm'
};
enum {
   kQTSTargetBufferDurationInfo  = 'bufr',
   / * Fixed* in seconds; expected,
   not actual * /
   kQTSDurationInfo              = 'dura',
   / * QTSDurationAtom* * /
   kQTSSoundLevelMeteringEnabledInfo = 'mtrn',
   /* Boolean* * /
   kQTSSoundLevelMeterInfo       = 'levm',
   /* LevelMeterInfoPtr * /
   kQTSSourceTrackIDInfo         = 'otid',
   / * UInt32* * /
   kQTSSourceLayerInfo           = 'olyr',
   / * UInt16* * /
   kQTSSourceLanguageInfo        = 'olng',
   / * UInt16* * /
   kQTSSourceTrackFlagsInfo      = 'otfl',
   / * SInt32* * /
   kQTSSourceDimensionsInfo      = 'odim',
   / * QTSDimensionParams* * /
   kQTSSourceVolumesInfo         = 'ovol',
   /* QTSVolumesParams* * /
   kQTSSourceMatrixInfo          = 'omat',
   / * MatrixRecord* * /
   kQTSSourceClipRectInfo        = 'oclp',
   / * Rect* * /
   kQTSSourceGraphicsModeInfo    = 'ogrm',
   /* QTSGraphicsModeParams* * /  
   kQTSSourceScaleInfo           = 'oscl',
   / * Point* * /
   kQTSSourceBoundingRectInfo    = 'orct',
   / * Rect* * /
   kQTSSourceUserDataInfo        = 'oudt',
   /* UserData * / 
   kQTSSourceInputMapInfo        = 'oimp',
   / * QTAtomContainer * /
   kQTSInfo_DataProc             = 'datp',
   /* QTSDataProcParams* * /
   kQTSInfo_SendDataExtras       = 'dext',
   / * QTSSendDataExtrasParams* * /
   kQTSInfo_HintTrackID          = 'htid',
   / * long* * /
   kQTSInfo_URL                  = 'url ',
   / * Handle*,
   cstring in handle * /
   kQTSInfo_Authentication       = 'auup',
   /* QTSAuthenticationParams * /
   kQTSInfo_MediaPacketizer      = 'rmpk' / * ComponentInstance * /
};
enum {
   kQTVRNodeHeaderAtomType       = 'ndhd',
   kQTVRHotSpotParentAtomType    = 'hspa',
   kQTVRHotSpotAtomType          = 'hots',
   kQTVRHotSpotInfoAtomType      = 'hsin',
   kQTVRLinkInfoAtomType         = 'link'
};
enum {
   kQTVRObjectInfoAtomID         = 1,
   kQTVRObjectImageTrackRefAtomID = 1,
   /* New with 2.1,
   it adds a track reference to select between multiple image tracks* /
   kQTVRObjectHotSpotTrackRefAtomID = 1  /* New with 2.1,
   it adds a track reference to select between multiple hotspot tracks* /
};
enum {
   kQTVRStringAtomType           = 'vrsg',
   kQTVRStringEncodingAtomType   = 'vrse',
   /* New with 2.1* /
   kQTVRPanoSampleDataAtomType   = 'pdat',
   kQTVRObjectInfoAtomType       = 'obji',
   kQTVRImageTrackRefAtomType    = 'imtr',
   /* Parent is kQTVRObjectInfoAtomType. Required if track ref is not 1 as required by 2.0 format.* /
   kQTVRHotSpotTrackRefAtomType  = 'hstr',
   / * Parent is kQTVRObjectInfoAtomType. Required if track ref is not 1 as required by 2.0 format.* /
   kQTVRAngleRangeAtomType       = 'arng',
   kQTVRTrackRefArrayAtomType    = 'tref',
   kQTVRPanConstraintAtomType    = 'pcon',
   kQTVRTiltConstraintAtomType   = 'tcon',
   kQTVRFOVConstraintAtomType    = 'fcon',
   kQTVRCubicViewAtomType        = 'cuvw',
   /* New with 5.0* /
   kQTVRCubicFaceDataAtomType    = 'cufa' / * New with 5.0* /
};
enum {
   kQTVRWorldHeaderAtomType      = 'vrsc',
   kQTVRImagingParentAtomType    = 'imgp',
   kQTVRPanoImagingAtomType      = 'impn',
   kQTVRObjectImagingAtomType    = 'imob',
   kQTVRNodeParentAtomType       = 'vrnp',
   kQTVRNodeIDAtomType           = 'vrni',
   kQTVRNodeLocationAtomType     = 'nloc',
   kQTVRCursorParentAtomType     = 'vrcp',
   /* New with 2.1* /
   kQTVRCursorAtomType           = 'CURS',
   /* New with 2.1* /
   kQTVRColorCursorAtomType      = 'crsr' /* New with 2.1* /
};
enum {
   kSpriteAtomType               = 'sprt',
   kSpriteImagesContainerAtomType = 'imct',
   kSpriteImageAtomType          = 'imag',
   kSpriteImageDataAtomType      = 'imda',
   kSpriteImageDataRefAtomType   = 'imre',
   kSpriteImageDataRefTypeAtomType = 'imrt',
   kSpriteImageGroupIDAtomType   = 'imgr',
   kSpriteImageRegistrationAtomType = 'imrg',
   kSpriteImageDefaultImageIndexAtomType = 'defi',
   kSpriteSharedDataAtomType     = 'dflt',
   kSpriteNameAtomType           = 'name',
   kSpriteImageNameAtomType      = 'name',
   kSpriteUsesImageIDsAtomType   = 'uses',
   /* leaf data is an array of QTAtomID's,
   one per image used* /
   kSpriteBehaviorsAtomType      = 'beha',
   kSpriteImageBehaviorAtomType  = 'imag',
   kSpriteCursorBehaviorAtomType = 'crsr',
   kSpriteStatusStringsBehaviorAtomType = 'sstr',
   kSpriteVariablesContainerAtomType = 'vars',
   kSpriteStringVariableAtomType = 'strv',
   kSpriteFloatingPointVariableAtomType = 'flov'
};
enum {
   kTargetMovie                  = 'moov',
   /* no data * /
   kTargetMovieName              = 'mona',
   / * (PString movieName) * /
   kTargetMovieID                = 'moid',
   /* (long movieID) * /
   kTargetRootMovie              = 'moro',
   /* no data * /
   kTargetParentMovie            = 'mopa',
   / * no data * /
   kTargetChildMovieTrackName    = 'motn',
   / * (PString childMovieTrackName) * /
   kTargetChildMovieTrackID      = 'moti',
   /* (long childMovieTrackID) *  /
   kTargetChildMovieTrackIndex   = 'motx',
   /* (long childMovieTrackIndex) * /
   kTargetChildMovieMovieName    = 'momn',
   /* (PString childMovieName) * /
   kTargetChildMovieMovieID      = 'momi',
   /* (long childMovieID) * /
   kTargetTrackName              = 'trna',
   /* (PString trackName) * /
   kTargetTrackID                = 'trid',
   / * (long trackID) * /
   kTargetTrackType              = 'trty',
   / * (OSType trackType) * /
   kTargetTrackIndex             = 'trin',
   /* (long trackIndex) * /
   kTargetSpriteName             = 'spna',
   / * (PString spriteName) * /
   kTargetSpriteID               = 'spid',
   /* (QTAtomID spriteID) * /
   kTargetSpriteIndex            = 'spin',
   / * (short spriteIndex) * /
   kTargetQD3DNamedObjectName    = 'nana',
   / * (CString objectName) * /
   kTargetCurrentQTEventParams   = 'evpa' / * no data * /
};
enum {
   kTrackModifierInput           = 0x696E,
   /* is really 'in'* /
   kTrackModifierType            = 0x7479,
   /* is really 'ty'* /
   kTrackModifierReference       = 'ssrc',
   kTrackModifierObjectID        = 'obid',
   kTrackModifierInputName       = 'name'
};
enum {
   kTrackPropertyMediaType       = 'mtyp',
   /* OSType* /
   kTrackPropertyInstantiation   = 'inst' /* MovieMediaInstantiationInfoRecord* /
};
enum {
   kTrackReferenceChapterList    = 'chap',
   kTrackReferenceTimeCode       = 'tmcd',
   kTrackReferenceModifier       = 'ssrc'
};
enum {
   kTweenEntry                   = 'twen',
   kTweenData                    = 'data',
   kTweenType                    = 'twnt',
   kTweenStartOffset             = 'twst',
   kTweenDuration                = 'twdu',
   kTweenFlags                   = 'flag',
   kTweenOutputMin               = 'omin',
   kTweenOutputMax               = 'omax',
   kTweenSequenceElement         = 'seqe',
   kTween3dInitialCondition      = 'icnd',
   kTweenInterpolationID         = 'intr',
   kTweenRegionData              = 'qdrg',
   kTweenPictureData             = 'PICT',
   kListElementType              = 'type',
   kListElementDataType          = 'daty',
   kNameAtom                     = 'name',
   kInitialRotationAtom          = 'inro',
   kNonLinearTweenHeader         = 'nlth'
};
enum {
   MovieAID                      = 'moov',
   MovieHeaderAID                = 'mvhd',
   ClipAID                       = 'clip',
   RgnClipAID                    = 'crgn',
   MatteAID                      = 'matt',
   MatteCompAID                  = 'kmat',
   TrackAID                      = 'trak',
   UserDataAID                   = 'udta',
   TrackHeaderAID                = 'tkhd',
   EditsAID                      = 'edts',
   EditListAID                   = 'elst',
   MediaAID                      = 'mdia',
   MediaHeaderAID                = 'mdhd',
   MediaInfoAID                  = 'minf',
   VideoMediaInfoHeaderAID       = 'vmhd',
   SoundMediaInfoHeaderAID       = 'smhd',
   GenericMediaInfoHeaderAID     = 'gmhd',
   GenericMediaInfoAID           = 'gmin',
   DataInfoAID                   = 'dinf',
   DataRefAID                    = 'dref',
   SampleTableAID                = 'stbl',
   STSampleDescAID               = 'stsd',
   STTimeToSampAID               = 'stts',
   STSyncSampleAID               = 'stss',
   STSampleToChunkAID            = 'stsc',
   STShadowSyncAID               = 'stsh',
   HandlerAID                    = 'hdlr',
   STSampleSizeAID               = 'stsz',
   STChunkOffsetAID              = 'stco',
   STChunkOffset64AID            = 'co64',
   STSampleIDAID                 = 'stid',
   STCompositionOffsetAID        = 'ctts',
   STSampleDependencyAID         = 'sdtp',
   STCompositionShiftLeastGreatestAID = 'cslg',
   STPartialSyncSampleAID        = 'stps',
   DataRefContainerAID           = 'drfc',
   TrackReferenceAID             = 'tref',
   ColorTableAID                 = 'ctab',
   LoadSettingsAID               = 'load',
   PropertyAtomAID               = 'code',
   InputMapAID                   = 'imap',
   MovieBufferHintsAID           = 'mbfh',
   MovieDataRefAliasAID          = 'mdra',
   SoundLocalizationAID          = 'sloc',
   CompressedMovieAID            = 'cmov',
   CompressedMovieDataAID        = 'cmvd',
   DataCompressionAtomAID        = 'dcom',
   ReferenceMovieRecordAID       = 'rmra',
   ReferenceMovieDescriptorAID   = 'rmda',
   ReferenceMovieDataRefAID      = 'rdrf',
   ReferenceMovieVersionCheckAID = 'rmvc',
   ReferenceMovieDataRateAID     = 'rmdr',
   ReferenceMovieComponentCheckAID = 'rmcd',
   ReferenceMovieQualityAID      = 'rmqu',
   ReferenceMovieLanguageAID     = 'rmla',
   ReferenceMovieCPURatingAID    = 'rmcs',
   ReferenceMovieAlternateGroupAID = 'rmag',
   ReferenceMovieNetworkStatusAID = 'rnet',
   CloneMediaAID                 = 'clon',
   FileTypeAID                   = 'ftyp',
   SecureContentInfoAID          = 'sinf',
   SecureContentSchemeTypeAID    = 'schm',
   SecureContentSchemeInfoAID    = 'schi'
};
enum {
   MovieResourceAtomType         = 'moov',
   MovieDataAtomType             = 'mdat',
   FreeAtomType                  = 'free',
   SkipAtomType                  = 'skip',
   WideAtomPlaceholderType       = 'wide'
};
enum {
   quickTimeImageFileImageDescriptionAtom = 'idsc',
   quickTimeImageFileImageDataAtom = 'idat',
   quickTimeImageFileMetaDataAtom = 'meta',
   quickTimeImageFileColorSyncProfileAtom = 'iicc'
};
Constants
kMovieMediaDefaultDataReferenceID

Atom id. 

Available in Mac OS X v10.0 and later.
kMovieMediaSlaveTime

Boolean. 

Available in Mac OS X v10.0 and later.
kMovieMediaSlaveGraphicsMode

Boolean. 

Available in Mac OS X v10.0 and later.
kMovieMediaBackgroundColor

RGBColor.. 

Available in Mac OS X v10.0 and later.
kMovieMediaPrerollTime

SInt32 indicating preroll time. 

Available in Mac OS X v10.0 and later.
kQTParseTextHREFText

String. 

Available in Mac OS X v10.0 and later.
kQTEnableExif

UInt8 (Boolean). 

Available in Mac OS X v10.1 and later.
kTargetChildMovieTrackIndex

(long childMovieTrackIndex). 

Available in Mac OS X v10.0 and later.
kTargetChildMovieMovieName

(PString childMovieName). 

Available in Mac OS X v10.0 and later.
kTargetTrackType

(OSType trackType). 

Available in Mac OS X v10.0 and later.
kTargetTrackIndex

(long trackIndex). 

Available in Mac OS X v10.0 and later.
kTargetSpriteName

(PString spriteName). 

Available in Mac OS X v10.0 and later.
kTargetSpriteID

(QTAtomID spriteID). 

Available in Mac OS X v10.0 and later.
kTargetQD3DNamedObjectName

(CString objectName). 

Available in Mac OS X v10.0 and later.
kTargetCurrentQTEventParams

No data. 

Available in Mac OS X v10.0 and later.*/
enum {
   ConnectionSpeedPrefsType      = 'cspd',
   ConnectionSpeedIsValidPrefsType = 'vspd'
};
enum {
   kEffectNameAtom               = 'name',
   /* name of effect */
   kEffectTypeAtom               = 'type',
   /* codec sub-type for effect */
   kEffectManufacturerAtom       = 'manu' /* codec manufacturer for effect */
};
enum {
   kGraphicsExportGroup          = 'expo',
   kGraphicsExportFileType       = 'ftyp',
   kGraphicsExportMIMEType       = 'mime',
   kGraphicsExportExtension      = 'ext ',
   kGraphicsExportDescription    = 'desc'
};
enum {
   kInputMapSubInputID           = 'subi'
};
enum {
   kMovieMediaDataReference      = 'mmdr',
   /* data reference*/
   kMovieMediaDefaultDataReferenceID = 'ddri',
   /* atom id*/
   kMovieMediaSlaveTime          = 'slti',
   /* boolean*/
   kMovieMediaSlaveAudio         = 'slau',
   /* boolean*/
   kMovieMediaSlaveGraphicsMode  = 'slgr',
   /* boolean*/
   kMovieMediaAutoPlay           = 'play',
   /* boolean*/
   kMovieMediaLoop               = 'loop',
   /* UInt8 (0=no loop,
   1=loop,
   2=palindrome loop)*/
   kMovieMediaUseMIMEType        = 'mime',
   /* string indicating the MIME type to use for the dataref (usually not required)*/
   kMovieMediaTitle              = 'titl',
   /* string of the media's title (tooltips)*/
   kMovieMediaAltText            = 'altt',
   /* string of alternate text if media isn't loaded*/
   kMovieMediaClipBegin          = 'clpb',
   /* MovieMediaTimeRecord of start time of embedded media*/
   kMovieMediaClipDuration       = 'clpd',
   /* MovieMediaTimeRecord of duration of embedded media*/
   kMovieMediaRegionAtom         = 'regi',
   /* contains subatoms that describe layout*/
   kMovieMediaSlaveTrackDuration = 'sltr',
   /* Boolean indicating that media handler should adjust track and media based on actual embedded movie duration*/
   kMovieMediaEnableFrameStepping = 'enfs',
   /* boolean. if true stepping on external movie steps frames within embedded movie.*/
   kMovieMediaBackgroundColor    = 'bkcl',
   /* RGBColor.*/
   kMovieMediaPrerollTime        = 'prer' /* SInt32 indicating preroll time*/
};
enum {
   kMovieMediaSpatialAdjustment  = 'fit ',
   /* OSType from kMovieMediaFit**/
   kMovieMediaRectangleAtom      = 'rect',
   kMovieMediaTop                = 'top ',
   kMovieMediaLeft               = 'left',
   kMovieMediaWidth              = 'wd  ',
   kMovieMediaHeight             = 'ht  '
};
enum {
   kQTEventType                  = 'evnt',
   kAction                       = 'actn',
   kWhichAction                  = 'whic',
   kActionParameter              = 'parm',
   kActionTarget                 = 'targ',
   kActionFlags                  = 'flag',
   kActionParameterMinValue      = 'minv',
   kActionParameterMaxValue      = 'maxv',
   kActionListAtomType           = 'list',
   kExpressionContainerAtomType  = 'expr',
   kConditionalAtomType          = 'test',
   kOperatorAtomType             = 'oper',
   kOperandAtomType              = 'oprn',
   kCommentAtomType              = 'why ',
   kCustomActionHandler          = 'cust',
   kCustomHandlerID              = 'id  ',
   kCustomHandlerDesc            = 'desc',
   kQTEventRecordAtomType        = 'erec'
};
enum {
   kQTParseTextHREFText          = 'text',
   /* string*/
   kQTParseTextHREFBaseURL       = 'burl',
   /* string*/
   kQTParseTextHREFClickPoint    = 'clik',
   /* Point; if present,
   QTParseTextHREF will expand URLs to support server-side image maps*/
   kQTParseTextHREFUseAltDelim   = 'altd',
   /* boolean; if no kQTParseTextHREFDelimiter,
   delim is ':'*/
   kQTParseTextHREFDelimiter     = 'delm',
   /* character*/
   kQTParseTextHREFRecomposeHREF = 'rhrf' /* Boolean; if true,
   QTParseTextHREF returns recomposed HREF with URL expanded as appropriate*/
};
enum {
   kQTResolutionSettings         = 'reso',
   kQTTargetDataSize             = 'dasz',
   kQTDontRecompress             = 'dntr',
   kQTInterlaceStyle             = 'ilac',
   kQTColorSyncProfile           = 'iccp',
   kQTThumbnailSettings          = 'thum',
   kQTEnableExif                 = 'exif',
   /* UInt8 (boolean)*/
   kQTMetaData                   = 'meta'
};
enum {
   kQTSConnectionPrefsType       = 'stcm',
   /* root atom that all other atoms are contained in*/
   /*    kQTSNotUsedForProxyPrefsType = 'nopr',
   //        comma-delimited list of URLs that are never used for proxies*/
   kQTSConnectionMethodPrefsType = 'mthd',
   /*      connection method (OSType that matches one of the following three)*/
   kQTSDirectConnectPrefsType    = 'drct',
   /*       used if direct connect (QTSDirectConnectPrefsRecord)*/
   /*    kQTSRTSPProxyPrefsType =     'rtsp',
   //   used if RTSP Proxy (QTSProxyPrefsRecord)*/
   kQTSSOCKSPrefsType            = 'sock' /*       used if SOCKS Proxy (QTSProxyPrefsRecord)*/
};
enum {
   kQTSNullNotification          = 'null',
   /* NULL */
   kQTSErrorNotification         = 'err ',
   /* QTSErrorParams*,
   optional */
   kQTSNewPresDetectedNotification = 'newp',
   /* QTSNewPresDetectedParams* */
   kQTSPresBeginChangingNotification = 'prcb',
   /* NULL */
   kQTSPresDoneChangingNotification = 'prcd',
   /* NULL */
   kQTSPresentationChangedNotification = 'prch',
   /* NULL */
   kQTSNewStreamNotification     = 'stnw',
   /* QTSNewStreamParams* */
   kQTSStreamBeginChangingNotification = 'stcb',
   /* QTSStream */
   kQTSStreamDoneChangingNotification = 'stcd',
   /* QTSStream */
   kQTSStreamChangedNotification = 'stch',
   /* QTSStreamChangedParams* */
   kQTSStreamGoneNotification    = 'stgn',
   /* QTSStreamGoneParams* */
   kQTSPreviewAckNotification    = 'pvak',
   /* QTSStream */
   kQTSPrerollAckNotification    = 'pack',
   /* QTSStream */
   kQTSStartAckNotification      = 'sack',
   /* QTSStream */
   kQTSStopAckNotification       = 'xack',
   /* QTSStream */
   kQTSStatusNotification        = 'stat',
   /* QTSStatusParams* */
   kQTSURLNotification           = 'url ',
   /* QTSURLParams* */
   kQTSDurationNotification      = 'dura',
   /* QTSDurationAtom* */
   kQTSNewPresentationNotification = 'nprs',
   /* QTSPresentation */
   kQTSPresentationGoneNotification = 'xprs',
   /* QTSPresentation */
   kQTSPresentationDoneNotification = 'pdon',
   /* NULL */
   kQTSBandwidthAlertNotification = 'bwal',
   /* QTSBandwidthAlertParams* */
   kQTSAnnotationsChangedNotification = 'meta' /* NULL */
};
enum {
   kQTSStatisticsInfo            = 'stat',
   /* QTSStatisticsParams* */
   kQTSMinStatusDimensionsInfo   = 'mstd',
   /* QTSDimensionParams* */
   kQTSNormalStatusDimensionsInfo = 'nstd',
   /* QTSDimensionParams* */
   kQTSTotalDataRateInfo         = 'drtt',
   /* UInt32*,
   add to what's there */
   kQTSTotalDataRateInInfo       = 'drti',
   /* UInt32*,
   add to what's there */
   kQTSTotalDataRateOutInfo      = 'drto',
   /* UInt32*,
   add to what's there */
   kQTSLostPercentInfo           = 'lpct',
   /* QTSLostPercentParams*,
   add to what's there */
   kQTSNumViewersInfo            = 'nviw',
   /* UInt32* */
   kQTSMediaTypeInfo             = 'mtyp',
   /* OSType* */
   kQTSNameInfo                  = 'name',
   /* QTSNameParams* */
   kQTSCanHandleSendDataType     = 'chsd',
   /* QTSCanHandleSendDataTypeParams* */
   kQTSAnnotationsInfo           = 'meta',
   /* QTAtomContainer */
   kQTSRemainingBufferTimeInfo   = 'btms',
   /* UInt32* remaining buffer time before playback,
   in microseconds */
   kQTSInfo_SettingsText         = 'sttx',
   /* QTSSettingsTextParams* */
   kQTSInfo_AverageFrameRate     = 'fps ' /* UnsignedFixed* */
};
enum {
   kQTSStreamMediaType           = 'strm'
};
enum {
   kQTSTargetBufferDurationInfo  = 'bufr',
   /* Fixed* in seconds; expected,
   not actual */
   kQTSDurationInfo              = 'dura',
   /* QTSDurationAtom* */
   kQTSSoundLevelMeteringEnabledInfo = 'mtrn',
   /* Boolean* */
   kQTSSoundLevelMeterInfo       = 'levm',
   /* LevelMeterInfoPtr */
   kQTSSourceTrackIDInfo         = 'otid',
   /* UInt32* */
   kQTSSourceLayerInfo           = 'olyr',
   /* UInt16* */
   kQTSSourceLanguageInfo        = 'olng',
   /* UInt16* */
   kQTSSourceTrackFlagsInfo      = 'otfl',
   /* SInt32* */
   kQTSSourceDimensionsInfo      = 'odim',
   /* QTSDimensionParams* */
   kQTSSourceVolumesInfo         = 'ovol',
   /* QTSVolumesParams* */
   kQTSSourceMatrixInfo          = 'omat',
   /* MatrixRecord* */
   kQTSSourceClipRectInfo        = 'oclp',
   /* Rect* */
   kQTSSourceGraphicsModeInfo    = 'ogrm',
   /* QTSGraphicsModeParams* */
   kQTSSourceScaleInfo           = 'oscl',
   /* Point* */
   kQTSSourceBoundingRectInfo    = 'orct',
   /* Rect* */
   kQTSSourceUserDataInfo        = 'oudt',
   /* UserData */
   kQTSSourceInputMapInfo        = 'oimp',
   /* QTAtomContainer */
   kQTSInfo_DataProc             = 'datp',
   /* QTSDataProcParams* */
   kQTSInfo_SendDataExtras       = 'dext',
   /* QTSSendDataExtrasParams* */
   kQTSInfo_HintTrackID          = 'htid',
   /* long* */
   kQTSInfo_URL                  = 'url ',
   /* Handle*,
   cstring in handle */
   kQTSInfo_Authentication       = 'auup',
   /* QTSAuthenticationParams */
   kQTSInfo_MediaPacketizer      = 'rmpk' /* ComponentInstance */
};
enum {
   kQTVRNodeHeaderAtomType       = 'ndhd',
   kQTVRHotSpotParentAtomType    = 'hspa',
   kQTVRHotSpotAtomType          = 'hots',
   kQTVRHotSpotInfoAtomType      = 'hsin',
   kQTVRLinkInfoAtomType         = 'link'
};
enum {
   kQTVRObjectInfoAtomID         = 1,
   kQTVRObjectImageTrackRefAtomID = 1,
   /* New with 2.1,
   it adds a track reference to select between multiple image tracks*/
   kQTVRObjectHotSpotTrackRefAtomID = 1  /* New with 2.1,
   it adds a track reference to select between multiple hotspot tracks*/
};
enum {
   kQTVRStringAtomType           = 'vrsg',
   kQTVRStringEncodingAtomType   = 'vrse',
   /* New with 2.1*/
   kQTVRPanoSampleDataAtomType   = 'pdat',
   kQTVRObjectInfoAtomType       = 'obji',
   kQTVRImageTrackRefAtomType    = 'imtr',
   /* Parent is kQTVRObjectInfoAtomType. Required if track ref is not 1 as required by 2.0 format.*/
   kQTVRHotSpotTrackRefAtomType  = 'hstr',
   /* Parent is kQTVRObjectInfoAtomType. Required if track ref is not 1 as required by 2.0 format.*/
   kQTVRAngleRangeAtomType       = 'arng',
   kQTVRTrackRefArrayAtomType    = 'tref',
   kQTVRPanConstraintAtomType    = 'pcon',
   kQTVRTiltConstraintAtomType   = 'tcon',
   kQTVRFOVConstraintAtomType    = 'fcon',
   kQTVRCubicViewAtomType        = 'cuvw',
   /* New with 5.0*/
   kQTVRCubicFaceDataAtomType    = 'cufa' /* New with 5.0*/
};
enum {
   kQTVRWorldHeaderAtomType      = 'vrsc',
   kQTVRImagingParentAtomType    = 'imgp',
   kQTVRPanoImagingAtomType      = 'impn',
   kQTVRObjectImagingAtomType    = 'imob',
   kQTVRNodeParentAtomType       = 'vrnp',
   kQTVRNodeIDAtomType           = 'vrni',
   kQTVRNodeLocationAtomType     = 'nloc',
   kQTVRCursorParentAtomType     = 'vrcp',
   /* New with 2.1*/
   kQTVRCursorAtomType           = 'CURS',
   /* New with 2.1*/
   kQTVRColorCursorAtomType      = 'crsr' /* New with 2.1*/
};
enum {
   kSpriteAtomType               = 'sprt',
   kSpriteImagesContainerAtomType = 'imct',
   kSpriteImageAtomType          = 'imag',
   kSpriteImageDataAtomType      = 'imda',
   kSpriteImageDataRefAtomType   = 'imre',
   kSpriteImageDataRefTypeAtomType = 'imrt',
   kSpriteImageGroupIDAtomType   = 'imgr',
   kSpriteImageRegistrationAtomType = 'imrg',
   kSpriteImageDefaultImageIndexAtomType = 'defi',
   kSpriteSharedDataAtomType     = 'dflt',
   kSpriteNameAtomType           = 'name',
   kSpriteImageNameAtomType      = 'name',
   kSpriteUsesImageIDsAtomType   = 'uses',
   /* leaf data is an array of QTAtomID's,
   one per image used*/
   kSpriteBehaviorsAtomType      = 'beha',
   kSpriteImageBehaviorAtomType  = 'imag',
   kSpriteCursorBehaviorAtomType = 'crsr',
   kSpriteStatusStringsBehaviorAtomType = 'sstr',
   kSpriteVariablesContainerAtomType = 'vars',
   kSpriteStringVariableAtomType = 'strv',
   kSpriteFloatingPointVariableAtomType = 'flov'
};
enum {
   kTargetMovie                  = 'moov',
   /* no data */
   kTargetMovieName              = 'mona',
   /* (PString movieName) */
   kTargetMovieID                = 'moid',
   /* (long movieID) */
   kTargetRootMovie              = 'moro',
   /* no data */
   kTargetParentMovie            = 'mopa',
   /* no data */
   kTargetChildMovieTrackName    = 'motn',
   /* (PString childMovieTrackName) */
   kTargetChildMovieTrackID      = 'moti',
   /* (long childMovieTrackID) */
   kTargetChildMovieTrackIndex   = 'motx',
   /* (long childMovieTrackIndex) */
   kTargetChildMovieMovieName    = 'momn',
   /* (PString childMovieName) */
   kTargetChildMovieMovieID      = 'momi',
   /* (long childMovieID) */
   kTargetTrackName              = 'trna',
   /* (PString trackName) */
   kTargetTrackID                = 'trid',
   /* (long trackID) */
   kTargetTrackType              = 'trty',
   /* (OSType trackType) */
   kTargetTrackIndex             = 'trin',
   /* (long trackIndex) */
   kTargetSpriteName             = 'spna',
   /* (PString spriteName) */
   kTargetSpriteID               = 'spid',
   /* (QTAtomID spriteID) */
   kTargetSpriteIndex            = 'spin',
   /* (short spriteIndex) */
   kTargetQD3DNamedObjectName    = 'nana',
   /* (CString objectName) */
   kTargetCurrentQTEventParams   = 'evpa' /* no data */
};
enum {
   kTrackModifierInput           = 0x696E,
   /* is really 'in'*/
   kTrackModifierType            = 0x7479,
   /* is really 'ty'*/
   kTrackModifierReference       = 'ssrc',
   kTrackModifierObjectID        = 'obid',
   kTrackModifierInputName       = 'name'
};
enum {
   kTrackPropertyMediaType       = 'mtyp',
   /* OSType*/
   kTrackPropertyInstantiation   = 'inst' /* MovieMediaInstantiationInfoRecord*/
};
enum {
   kTrackReferenceChapterList    = 'chap',
   kTrackReferenceTimeCode       = 'tmcd',
   kTrackReferenceModifier       = 'ssrc'
};
enum {
   kTweenEntry                   = 'twen',
   kTweenData                    = 'data',
   kTweenType                    = 'twnt',
   kTweenStartOffset             = 'twst',
   kTweenDuration                = 'twdu',
   kTweenFlags                   = 'flag',
   kTweenOutputMin               = 'omin',
   kTweenOutputMax               = 'omax',
   kTweenSequenceElement         = 'seqe',
   kTween3dInitialCondition      = 'icnd',
   kTweenInterpolationID         = 'intr',
   kTweenRegionData              = 'qdrg',
   kTweenPictureData             = 'PICT',
   kListElementType              = 'type',
   kListElementDataType          = 'daty',
   kNameAtom                     = 'name',
   kInitialRotationAtom          = 'inro',
   kNonLinearTweenHeader         = 'nlth'
};
enum {
   MovieAID                      = 'moov',
   MovieHeaderAID                = 'mvhd',
   ClipAID                       = 'clip',
   RgnClipAID                    = 'crgn',
   MatteAID                      = 'matt',
   MatteCompAID                  = 'kmat',
   TrackAID                      = 'trak',
   UserDataAID                   = 'udta',
   TrackHeaderAID                = 'tkhd',
   EditsAID                      = 'edts',
   EditListAID                   = 'elst',
   MediaAID                      = 'mdia',
   MediaHeaderAID                = 'mdhd',
   MediaInfoAID                  = 'minf',
   VideoMediaInfoHeaderAID       = 'vmhd',
   SoundMediaInfoHeaderAID       = 'smhd',
   GenericMediaInfoHeaderAID     = 'gmhd',
   GenericMediaInfoAID           = 'gmin',
   DataInfoAID                   = 'dinf',
   DataRefAID                    = 'dref',
   SampleTableAID                = 'stbl',
   STSampleDescAID               = 'stsd',
   STTimeToSampAID               = 'stts',
   STSyncSampleAID               = 'stss',
   STSampleToChunkAID            = 'stsc',
   STShadowSyncAID               = 'stsh',
   HandlerAID                    = 'hdlr',
   STSampleSizeAID               = 'stsz',
   STChunkOffsetAID              = 'stco',
   STChunkOffset64AID            = 'co64',
   STSampleIDAID                 = 'stid',
   STCompositionOffsetAID        = 'ctts',
   STSampleDependencyAID         = 'sdtp',
   STCompositionShiftLeastGreatestAID = 'cslg',
   STPartialSyncSampleAID        = 'stps',
   DataRefContainerAID           = 'drfc',
   TrackReferenceAID             = 'tref',
   ColorTableAID                 = 'ctab',
   LoadSettingsAID               = 'load',
   PropertyAtomAID               = 'code',
   InputMapAID                   = 'imap',
   MovieBufferHintsAID           = 'mbfh',
   MovieDataRefAliasAID          = 'mdra',
   SoundLocalizationAID          = 'sloc',
   CompressedMovieAID            = 'cmov',
   CompressedMovieDataAID        = 'cmvd',
   DataCompressionAtomAID        = 'dcom',
   ReferenceMovieRecordAID       = 'rmra',
   ReferenceMovieDescriptorAID   = 'rmda',
   ReferenceMovieDataRefAID      = 'rdrf',
   ReferenceMovieVersionCheckAID = 'rmvc',
   ReferenceMovieDataRateAID     = 'rmdr',
   ReferenceMovieComponentCheckAID = 'rmcd',
   ReferenceMovieQualityAID      = 'rmqu',
   ReferenceMovieLanguageAID     = 'rmla',
   ReferenceMovieCPURatingAID    = 'rmcs',
   ReferenceMovieAlternateGroupAID = 'rmag',
   ReferenceMovieNetworkStatusAID = 'rnet',
   CloneMediaAID                 = 'clon',
   FileTypeAID                   = 'ftyp',
   SecureContentInfoAID          = 'sinf',
   SecureContentSchemeTypeAID    = 'schm',
   SecureContentSchemeInfoAID    = 'schi'
};
enum {
   MovieResourceAtomType         = 'moov',
   MovieDataAtomType             = 'mdat',
   FreeAtomType                  = 'free',
   SkipAtomType                  = 'skip',
   WideAtomPlaceholderType       = 'wide'
};
enum {
   quickTimeImageFileImageDescriptionAtom = 'idsc',
   quickTimeImageFileImageDataAtom = 'idat',
   quickTimeImageFileMetaDataAtom = 'meta',
   quickTimeImageFileColorSyncProfileAtom = 'iicc'
};

/*QTAtomID

Abst_QTAtomID

typedef long QTAtomID;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long QTAtomID;

/*QTAtomType

Represents a type used by the Movie Toolkit API.

typedef long QTAtomType;
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
typedef long QTAtomType;


/*QTAtom

Abst_QTAtom

typedef long QTAtom;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long QTAtom;

/*QTAtomContainer

Abst_QTAtomContainer

typedef Handle QTAtomContainer;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Handle QTAtomContainer;

/*MovieController

Abst_MovieController

typedef ComponentInstance MovieController;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ComponentInstance MovieController;

/*Discussion

The following constants identify sound description properties.
enum {
    kQTSoundDescriptionPropertyID_AudioChannelLayout = 'clay',
    kQTSoundDescriptionPropertyID_MagicCookie = 'kuki',
    kQTSoundDescriptionPropertyID_AudioStreamBasicDescription = 'asbd',
    kQTSoundDescriptionPropertyID_UserReadableText = 'text'
};

Special Considerations
kQTSoundDescriptionPropertyID_AudioChannelLayout = 'clay'

Used to get or set an AudioChannelLayout value. This is a variable-size property because it may contain an array of Channel Descriptions. You must get the size by calling QTSoundDescriptionGetPropertyInfo, allocate a structure of that size, and then get the property.
kQTSoundDescriptionPropertyID_MagicCookie = 'kuki'

Used to get or set opaque bytes. This is a variable-size property, because it is completely defined by the codec that uses the cookie. You must get the size by calling QTSoundDescriptionGetPropertyInfo, allocate a structure of that size, and then get the property.
kQTSoundDescriptionPropertyID_AudioStreamBasicDescription = 'asbd'

Used to get an AudioStreamBasicDescription value.
kQTSoundDescriptionPropertyID_UserReadableText = 'text'

Used to get a CFStringRef value. QTSoundDescriptionGetProperty does a CFRetain of the returned CFString on behalf of the caller, so the caller is responsible for calling CFRelease on the returned CFString.
Version Notes

Introduced in QuickTime 7.
Availability
Carbon status: Supported C interface file: Movies.h*/
enum {
    kQTSoundDescriptionPropertyID_AudioChannelLayout = 'clay',
    kQTSoundDescriptionPropertyID_MagicCookie = 'kuki',
    kQTSoundDescriptionPropertyID_AudioStreamBasicDescription = 'asbd',
    kQTSoundDescriptionPropertyID_UserReadableText = 'text'
};


/*TimeRecord

Contains a time value with its scale and time base.

struct TimeRecord {
   CompTimeValue    value;
   TimeScale        scale;
   TimeBase         base;
};
Fields
value
Discussion

Contains the time value. The time value defines either a duration or an absolute time by specifying the corresponding number of units of time. For durations, this is the number of time units in the period. For an absolute time, this is the number of time units since the beginning of the time coordinate system. The unit for this value is defined by the scale field. The time value is expressed as a 64-bit integer quantity. This 64-bit quantity consists of two 32-bit integers and is defined by the Int64 data type.
scale
Discussion

Contains the time scale. This field specifies the number of units of time that pass each second. If you specify a value of 0, the time base uses its natural time scale.
base
Discussion

Contains a reference to the time base. You obtain a time base by calling GetMovieTimeBase or NewTimeBase. If the time structure defines a duration, set this field to NIL. Otherwise, this field must refer to a valid time base.
Related Functions
AddTime
ClockGetTime
GetMovieTime
GetTimeBaseStartTime
GetTimeBaseStatus
GetTimeBaseStopTime
GetTimeBaseTime
SetTimeBaseZero
SGGrabCompressComplete
SubtractTime
VDCompressDone
VDGetTimeCode 
Programming Info
C interface file: Movies.h*/
struct TimeRecord {
   CompTimeValue    value;
   TimeScale        scale;
   TimeBase         base;
};
typedef struct TimeRecord TimeRecord;

/*Media Identifiers

Identify media types in QuickTime.

enum {
   VideoMediaType                = 'vide',
   SoundMediaType                = 'soun',
   TextMediaType                 = 'text',
   BaseMediaType                 = 'gnrc',
   MPEGMediaType                 = 'MPEG',
   MusicMediaType                = 'musi',
   TimeCodeMediaType             = 'tmcd',
   SpriteMediaType               = 'sprt',
   FlashMediaType                = 'flsh',
   MovieMediaType                = 'moov',
   TweenMediaType                = 'twen',
   ThreeDeeMediaType             = 'qd3d',
   SkinMediaType                 = 'skin',
   HandleDataHandlerSubType      = 'hndl',
   PointerDataHandlerSubType     = 'ptr ',
   NullDataHandlerSubType        = 'null',
   ResourceDataHandlerSubType    = 'rsrc',
   URLDataHandlerSubType         = 'url ',
   AliasDataHandlerSubType       = 'alis',
   WiredActionHandlerType        = 'wire'
};
Constants
SoundMediaType

Sound channel. 

Available in Mac OS X v10.0 and later.
TextMediaType

Text media. 

Available in Mac OS X v10.0 and later.*/
enum {
   VideoMediaType                = 'vide',
   SoundMediaType                = 'soun',
   TextMediaType                 = 'text',
   BaseMediaType                 = 'gnrc',
   MPEGMediaType                 = 'MPEG',
   MusicMediaType                = 'musi',
   TimeCodeMediaType             = 'tmcd',
   SpriteMediaType               = 'sprt',
   FlashMediaType                = 'flsh',
   MovieMediaType                = 'moov',
   TweenMediaType                = 'twen',
   ThreeDeeMediaType             = 'qd3d',
   SkinMediaType                 = 'skin',
   HandleDataHandlerSubType      = 'hndl',
   PointerDataHandlerSubType     = 'ptr ',
   NullDataHandlerSubType        = 'null',
   ResourceDataHandlerSubType    = 'rsrc',
   URLDataHandlerSubType         = 'url ',
   AliasDataHandlerSubType       = 'alis',
   WiredActionHandlerType        = 'wire'
};

/*New Movie Properties

Constants that represent the properties of new movies.

enum {
   newMovieActive                = 1 << 0,
   newMovieDontResolveDataRefs   = 1 << 1,
   newMovieDontAskUnresolvedDataRefs = 1 << 2,
   newMovieDontAutoAlternates    = 1 << 3,
   newMovieDontUpdateForeBackPointers = 1 << 4,
   newMovieDontAutoUpdateClock   = 1 << 5,
   newMovieAsyncOK               = 1 << 8,
   newMovieIdleImportOK          = 1 << 10,
   newMovieDontInteractWithUser  = 1 << 11
};*/
enum {
   newMovieActive                = 1 << 0,
   newMovieDontResolveDataRefs   = 1 << 1,
   newMovieDontAskUnresolvedDataRefs = 1 << 2,
   newMovieDontAutoAlternates    = 1 << 3,
   newMovieDontUpdateForeBackPointers = 1 << 4,
   newMovieDontAutoUpdateClock   = 1 << 5,
   newMovieAsyncOK               = 1 << 8,
   newMovieIdleImportOK          = 1 << 10,
   newMovieDontInteractWithUser  = 1 << 11
};

/*SampleDescriptionPtr

Abst_SampleDescriptionPtr

typedef SampleDescription * SampleDescriptionPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SampleDescription * SampleDescriptionPtr;

/*SoundDescriptionPtr

Abst_SoundDescriptionPtr

typedef SoundDescription * SoundDescriptionPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SoundDescription * SoundDescriptionPtr;


/*SampleDescriptionHandle

Abst_SampleDescriptionHandle

typedef SampleDescriptionPtr * SampleDescriptionHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SampleDescriptionPtr * SampleDescriptionHandle;


/*SoundDescriptionHandle

Abst_SoundDescriptionHandle

typedef SoundDescriptionPtr * SoundDescriptionHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SoundDescriptionPtr * SoundDescriptionHandle;

/*TrackRecord

Contains a track.

struct TrackRecord {
   long    data[1];
};
Fields
data
Discussion

An array of track data.
Programming Info
C interface file: Movies.h*/
struct TrackRecord {
   long    data[1];
};
typedef struct TrackRecord  TrackRecord  ;
/*Track

Abst_Track

typedef TrackRecord * Track;
Availability
Available in Mac OS X v10.0 and later.*/
typedef TrackRecord * Track;

/*MediaRecord

Undocumented

struct MediaRecord {
   long    data[1];
};
Fields
data
Discussion

Undocumented
Programming Info
C interface file: Movies.h*/
struct MediaRecord {
   long    data[1];
};
typedef struct MediaRecord  MediaRecord;
/*Media

Abst_Media

typedef MediaRecord * Media;
Availability
Available in Mac OS X v10.0 and later.*/
typedef MediaRecord * Media;

/*MovieRecord

Undocumented

struct MovieRecord {
   long    data[1];
};
Fields
data
Discussion

Undocumented
Programming Info
C interface file: Movies.h*/
struct MovieRecord {
   long    data[1];
};
typedef  struct MovieRecord MovieRecord;
/*Abst_Movie

typedef MovieRecord * Movie;
Availability
Available in Mac OS X v10.0 and later.*/
typedef MovieRecord * Movie;


/*DataHandler

Abst_DataHandler

typedef ComponentInstance DataHandler;
Availability
Available in Mac OS X v10.0 and later.
Movies.h*/
typedef ComponentInstance DataHandler;


/*QTAtomContainer

Abst_QTAtomContainer

typedef Handle QTAtomContainer;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Handle QTAtomContainer;

//Functions

/*MovieAudioExtractionFillBuffer

Extracts audio from a movie.

OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList            *ioData,
   UInt32                     *outFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
ioNumFrames

A pointer to the number of PCM frames to be extracted.
ioData

A pointer to an AudioBufferList allocated by the caller to hold the extracted audio data.
outFlags

A bit flag that indicates when extraction is complete: kMovieAudioExtractionComplete The extraction process is complete. Value is (1L << 0). See these constants: 
Return Value

An error code. Returns noErr if there is no error.
Discussion

You call this function repeatedly; each call continues extracting audio where the last call left off. The function will extract as many of the requested PCM frames as it can, given the limits of the buffer supplied and the limits of the input movie. ioNumFrames will be updated with the exact number of valid frames being returned. When there is no more audio to extract from the movie, the function will continue to return noErr but will return no further audio data. In this case, the outFlags parameter will have its kMovieAudioExtractionComplete bit set. It is possible that the kMovieAudioExtractionComplete bit will accompany the last buffer of valid data.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/



OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList           *ioData,
   UInt32                     *outFlags );

/*EnterMovies

Initializes the Movie Toolbox and creates a private storage area for your application.

OSErr EnterMovies ( void );
Return Value

Be sure to check the value returned by this function before using any other facilities of the Movie Toolbox. See Error Codes. Returns noErr if there is no error.
Discussion

Before calling any Movie Toolbox functions, you must use EnterMovies to initialize the toolbox. Your application may call EnterMovies multiple times. The following code sample demonstrates how your application can call the Gestalt Manager to determine whether the Movie Toolbox is installed, using the selector gestaltQuickTime ('qtim'), before calling EnterMovies://Using the Gestalt Manager with the Movie Toolbox
#include <GestaltEqu.h>
#include <Movies.h>
Boolean IsQuickTimeInstalled (void)
{
    short   error;
    long    result;
 
    error =Gestalt (gestaltQuickTime, &result);
    return (error ==noErr);
}
void main (void)
{
    Boolean qtInstalled;
    .
    .
    .
    qtInstalled =IsQuickTimeInstalled ();
}
// EnterMovies coding example
// See "Discovering QuickTime," page 242
void MyInitMovieToolbox (void)
{
    InitGraf(&qd.thePort);
    InitFonts();
    InitWindows();
    InitMenus();
    TEInit();
    InitDialogs(NIL);
    EnterMovies();
}
void main (void)
{
    MyInitMovieToolbox();
    CreateMyCoolMovie();
}

Special Considerations

You should initialize any other Macintosh managers your application uses before calling EnterMovies. You do not need to balance calls to EnterMovies with calls to ExitMovies; you need to call ExitMovies only if you finish with the Movie Toolbox long before your application is ready to quit.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In\
Movies.h*/
OSErr EnterMovies ( void );

/*MovieAudioExtractionSetProperty

Sets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_SummaryChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the property value.
inPropValueAddress

A const void pointer that points to the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );

/*MovieAudioExtractionBegin

Begins a movie audio extraction session.

OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
flags

Reserved; must be 0.
outSession

A pointer to an opaque session object.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function before doing any movie audio extraction, because you will pass the object returned by outSession to the other movie audio extraction functions. The format of the extracted audio defaults to the summary channel layout of the movie (all right channels mixed together, all left surround channels mixed together, and so on.), 32-bit float, de-interleaved, with the sample rate set to the highest sample rate found in the movie. You can set the audio format to be something else, as long as it is uncompressed and you do it before your first call to MovieAudioExtractionFillBuffer.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession );

/*BeginMediaEdits

Starts a media-editing session.

OSErr BeginMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use EndMediaEdits to end a media-editing session. You must call BeginMediaEdits before you add samples to a media with the AddMediaSample function. You must also call BeginMediaEdits before calling InsertTrackSegment if you wish InsertTrackSegment to copy media samples instead of copying the segment by reference.// BeginMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr BeginMediaEdits (
   Media    theMedia );

/*NewTrackMedia

Creates a media for a new track.

Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack.
mediaType

The type of media to create; see Media Identifiers. The Movie Toolbox uses this value to find the correct media handler for the new media. If the Movie Toolbox cannot locate an appropriate media handler, it returns an error.
timeScale

Defines the media's time coordinate system.
dataRef

The data reference. This parameter contains a handle to the information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter. If you are creating a new media that refers to existing media data, you can use the GetMediaDataRef function to obtain information about the existing data reference. You can then supply information about that reference to this function. Set this parameter to NIL to use the file that is associated with the movie or if the movie does not have a movie file. For example, if you have created the movie using CreateMovieFile or NewMovieFromFile, the Movie Toolbox assumes that the movie's data resides in the file specified at that time. If you have created the movie using the NewMovieFromScrap or NewMovie functions, the movie does not have a movie file.
dataRefType

The type of data reference; see Data References. If the data reference is an alias, you must set this parameter to rAliasType. See Inside Macintosh: Files for more information about aliases and the Alias Manager.
Return Value

A media identifier, referring to the actual data samples used by the track. If the function cannot create a new media, it sets the returned value to NIL.
Discussion

The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewTrackMedia coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType );

/*MovieAudioExtractionGetProperty

Gets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

The actual size of the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);

/*MovieAudioExtractionGetPropertyInfo

Gets information about a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
outPropType

A pointer to the type of the returned property's value.
outPropValueSize

A pointer to the size of the returned property's value.
outPropFlags

On return, a pointer to flags representing the requested information about the item's property.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags );

/*MovieAudioExtractionGetProperty

Gets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

The actual size of the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);

/*sertMediaIntoTrack

Inserts a reference to a media segment into a track.

OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack or GetMovieTrack.
trackStart

A time value specifying where the segment is to be inserted. This time value must be expressed in the movie's time scale. If you set this parameter to -1, the media data is added to the end of the track.
mediaTime

A time value specifying the starting point of the segment in the media. This time value must be expressed in the media's time scale.
mediaDuration

A time value specifying the duration of the media's segment. This time value must be expressed in the media's time scale.
mediaRate

The media's rate. A value of 1.0 indicates the media's natural playback rate. This value should be positive and not 0.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the segment in the media by providing a starting time and duration. You specify the point in the destination track by providing a time in the track. InsertMediaIntoTrack then inserts the media segment into the track at the specified location. The Movie Toolbox determines the duration of the segment in the track based on the media rate and duration information you provide.

Use this function after you have added samples to a media. If you play the track before you call this function, the track does not contain the new media data.

Here's an example of using this function to add atom containers to a track://InsertMediaIntoTrack coding example
long descSize;
QTVRSampleDescriptionHandle qtvrSampleDesc;
 
// Create a QTVR sample description handle
descSize =sizeof(QTVRSampleDescription) + GetHandleSize((Handle) vrWorld)
                            - sizeof(UInt32);
qtvrSampleDesc =(QTVRSampleDescriptionHandle) NewHandleClear (descSize);
(*qtvrSampleDesc)->
size =descSize;
(*qtvrSampleDesc)->
type =kQTVRQTVRType;
 
// Copy the VR world atom container data into the QTVR sample description
BlockMove (*((Handle) vrWorld), &((*qtvrSampleDesc)->
data),
                            GetHandleSize((Handle) vrWorld));
// Now add it to the QTVR track's media
err =BeginMediaEdits (qtvrMedia);
err =AddMediaSample (qtvrMedia, (Handle) nodeInfo, 0,
    GetHandleSize((Handle) nodeInfo), duration,
    (SampleDescriptionHandle) qtvrSampleDesc, 1, 0, &sampleTime);
err =EndMediaEdits (qtvrMedia);
InsertMediaIntoTrack (qtvrTrack, trackTime, sampleTime, duration, 1L<<16);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate );

/*GetMediaDuration

Returns the duration of a media.

TimeValue GetMediaDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The media's duration.
Discussion

The following code sample illustrates the use of GetMediaDuration:// GetMediaDuration coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetMediaDuration (
   Media    theMedia );

/*EndMediaEdits

Ends a media-editing session.

OSErr EndMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code sample illustrates the use of EndMediaEdits:// EndMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr EndMediaEdits (
   Media    theMedia );

/*GetMediaTrack

Determines the track that uses a specified media.

Track GetMediaTrack (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The track identifier of the track that uses the specified media.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track GetMediaTrack (
   Media    theMedia );

/*CloseMovieStorage

Closes an open movie storage container.

OSErr CloseMovieStorage (
   DataHandler    dh );
Parameters
dh

The data handler component that was returned by a previous call to CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 6. Supersedes CloseMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CloseMovieStorage (
   DataHandler    dh );

/*AddMovieToStorage

Adds a movie to a storage container that was created by CreateMovieStorage.

OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dh

The data handler component that was returned by CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function calls PutMovieIntoStorage internally. If you are writing a custom data handler, make sure it implements DataHGetDataRef. Also implement DataHScheduleData64 and DataHGetFileSize64, or DataHScheduleData and DataHGetFileSize if the data handler does not support 64-bit file offsets, plus DataHWrite64, or DataHWrite if it does not support 64-bit offsets.
Version Notes

Introduced in QuickTime 6. Supersedes AddMovieResource.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh );

/*MovieAudioExtractionEnd

Ends a movie audio extraction session.

OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function when movie audio extraction is complete.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session );

/*NewMovieFromDataRef

Creates a movie from any device with a corresponding data handler.

OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
m

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
flags

Flags (see below) that control the operation of this function. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
id

A pointer to the field that specifies the resource containing the movie data that is to be loaded. If the field referred to by the id parameter is set to 0, the Movie Toolbox loads the first movie resource it finds in the specified file. The toolbox then returns the movie's resource ID number in the field referred to by the id parameter. An enumerated constant (see below) is available. See these constants: 
movieInDataForkResID
dataRef

The default data reference. This parameter contains a handle to the information that identifies the file to be used to resolve any data references and as a starting point for any Alias Manager searches. The type of information stored in the handle depends upon the value of the dataRefType parameter. For example, if your application is loading the movie from a file, you would refer to the file's alias in this parameter and set the dataRefType parameter to rAliasType. If you do not want to identify a default data reference, set the parameter to NIL.
dataRefType

The type of data reference. If the data reference is an alias, you must set the parameter to rAliasType, indicating that the reference is an alias.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function is intended for use by specialized applications that need to instantiate movies from devices not visible to the file system. Most applications should continue to use NewMovieFromFile. You are not restricted to instantiating a movie from a file stored on a Macintosh HFS volume. With this function, you can instantiate a movie from any device.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType );

/*CreateMovieStorage

Creates an empty storage location to hold a movie and opens a data handler to the stored movie with write permission.

OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie );
Parameters
dataRef

A handle to a QuickTime data reference.
dataRefType

The data reference type. See Data References.
creator

The creator type of the new container (for example, 'TV0D', the creator type for Apple's movie player).
scriptTag

Constants (see below) that specify the script for the new container. See these constants: 
createMovieFileFlags

Constants (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
newMovieActive
outDataHandler

A pointer to a field that is to receive the data handler for the opened movie container. Your application must use this value when calling other Movie Toolbox functions. If you pass NIL, the Movie Toolbox creates the movie container but does not open it.
newmovie

A pointer to a field that is to receive the returned identifier of the new movie. If the function could not create a new movie, it sets this returned value to NIL. If you pass NIL, the Movie Toolbox does not create a movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are writing a custom data handler, make sure it supports DataHGetDataRef. It must also support DataHWrite64, or DataHWrite if 64-bit offsets are not supported.
Version Notes

Introduced in QuickTime 6. Supersedes CreateMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie );

/*AddMediaSample2

Adds sample data and a description to a media.

OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
dataIn

A handle to the sample data. The function adds this data to the media specified by theMedia. You specify the number of bytes of sample data with the size parameter.
size

The number of bytes of sample data to be added to the media. This parameter indicates the total number of bytes in the sample data to be added to the media, not the number of bytes per sample. Use the numberOfSamples parameter to indicate the number of samples that are contained in the sample data.
decodeDurationPerSample

The duration of each sample to be added, representing the amount of time that passes while the sample data is being displayed. You must specify this parameter in the media's time scale. For example, if you are adding sound that was sampled at 22 kHz to a media that contains a sound track with the same time scale, you would set durationPerSample to 1. Similarly, if you are adding video that was recorded at 10 frames per second to a video media that has a time scale of 600, you would set this parameter to 60. Note that this is the duration per sample, regardless of the number of samples being added.
displayOffset

A 64-bit time value that specifies the offset between the decode time (the start time of the track plus the duration of all previous samples) and the display time. This value is normally zero unless the sample is frame reordering compressed video.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a SoundDescription structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the sample data to be added to the media. The Movie Toolbox considers the value of this parameter as well as the value of the size parameter when it determines the size of each sample that it adds to the media. You should set the value of this parameter so that the resulting sample size represents a reasonable compromise between total data retrieval time and the overhead associated with input and output. You should also consider the speed of the data storage device; CD-ROM devices are much slower than hard disks, for example, and should therefore have a smaller sample size. For a video media, set a sample size that corresponds to the size of a frame. For a sound media, choose a number of samples that corresponds to between 0.5 and 1.0 seconds of sound. In general, you should not create groups of sound samples that are less than 2 KB in size or greater than 15 KB. Typically, a sample size of about 8 KB is reasonable for most storage devices.
sampleFlags

Flags that control the add operation; set unused flags to 0: mediaSampleNotSync Indicates that the sample to be added is not a sync sample. Set this flag to 1 if the sample is not a sync sample; set it to 0 if the sample is a sync sample. See these constants: 
mediaSampleNotSync
sampleDecodeTimeOut

A pointer to a time value that represents the sample decode time. After adding the sample data to the media, the function returns in this parameter the time where the sample was inserted. If you don't want to receive this information, set this parameter to NIL.
Return Value

An error code. Returns noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

Your application specifies the sample and the media for the operation. This function updates the media so that it contains the sample data. One call to this function can add several samples to a media. This function replaces AddMediaSample; it adds 64-bit support and support for frame reordering video compression (display offset).
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut );

/*QTNewDataReferenceFromFullPathCFString

Creates an alias data reference from a CFString that represents the full pathname of a file.

OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
filePath

A CFString that represents the full pathname of a file.
pathStyle

A constant (see below) that identifies the syntax of the pathname. See these constants: 
kQTNativeDefaultPathStyle
kQTPOSIXPathStyle
kQTHFSPathStyle
kQTWindowsPathStyle
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

You need to specify the syntax of the pathname as one of the QTPathStyle constants. The new alias data reference created can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );

/*QTSoundDescriptionCreate

Creates a sound description structure of the requested kind from an AudioStreamBasicDescription, optional audio channel layout, and optional magic cookie.

OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie
ByteCount                      inMagicCookieSize
QTSoundDescriptionKind         inRequestedKind
SoundDescriptionHandle         *outSoundDesc );
Parameters
inASBD

A description of the format.
inLayout

The audio channel layout (can be NULL if there isn't one).
inLayoutSize

The size of the audio channel layout (should be 0 if inLayout is NULL).
inMagicCookie

The magic cookie for the decompressor (can be NULL if the decompressor doesn't require one).
inMagicCookieSize

The size of the magic cookie (should be 0 if the inMagicCookie parameter is NULL).
inRequestedKind

The kind of sound description to create. 
outSoundDesc

The resulting sound description. The caller must dispose of it with DisposeHandle.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie,
ByteCount                      inMagicCookieSize,
QTSoundDescriptionKind         inRequestedKind,
SoundDescriptionHandle         *outSoundDesc );

/*DisposeMovie

Frees any memory being used by a movie, including the memory used by the movie's tracks and media structures.

void DisposeMovie (
   Movie    theMovie );
Parameters
theMovie

Identifies the movie to be freed. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, or NewMovieFromHandle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

Your application should call this function when it is done working with a movie, as shown in the following example:// DisposeMovie coding example
// See "Discovering QuickTime," page 85
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile | createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);      // See "Creating a Track," below
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void DisposeMovie (
   Movie    theMovie );

/*NewMovieTrack

Creates a new movie track, without a media.

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
width

A fixed number denoting the display width of the track, in pixels.
height

A fixed number denoting the display height of the track, in pixels. Together, the height and width parameters define the track's display rectangle. The upper-left corner of this rectangle lies at (0,0) in the movie's rectangle. The height and width parameters therefore establish the lower-right corner of the track's display rectangle. If you are creating a track that is not displayed, such as a sound track, set the height and width parameters to 0.
trackVolume

The volume setting of the track as a 16-bit, fixed-point number. The high-order 8 bits specify the integer portion; the low-order 8 bits specify the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. Set this parameter to kFullVolume to play the track at its full, natural volume. Set this parameter to kNoVolume to set the volume to 0. See these constants: 
Return Value

The identifier of the new track.
Discussion

Immediately after creating a new track, you should call NewTrackMedia to create a media for the track; a track without a media is of no use. The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewMovieTrack coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Special Considerations

When you add a track to a movie, the Movie Toolbox automatically adjusts the display Rect structure of the movie. You may want to detect these changes by calling GetMovieBox so that you can adjust the size of the movie's display window.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume );

/*GetMoviesError

Returns the contents of the current error value and resets the current error value to 0.

OSErr GetMoviesError ( void );
Return Value

See Error Codes. Returns noErr if there is no error in the current error value.
Discussion

The Movie Toolbox provides two error values to your application: the current error and the sticky error. The current error is the result code from the last Movie Toolbox function; it is updated each time your application calls a Movie Toolbox function. The following code sample shows a typical use:// GetMoviesError coding example
// See "Discovering QuickTime," page 256
OSErr QTUtils_SaveMovie (Movie theMovie)
{
    StandardFileReply   mySFReply;
    StringPtr   myPrompt =QTUtils_ConvertCToPascalString(kSavePrompt);
    StringPtr   myFileName =
                    QTUtils_ConvertCToPascalString(kSaveMovieFileName);
    OSErr       myErr =noErr;
    if (theMovie ==NIL)
        return(invalidMovie);
    StandardPutFile(myPrompt, myFileName, &mySFReply);
    if (mySFReply.sfGood) {
        FlattenMovieData(   theMovie,
                            flattenAddMovieToDataFork,
                            &mySFReply.sfFile,
                            FOUR_CHAR_CODE('TVOD'),
                            smSystemScript,
                            createMovieFileDeleteCurFile);
        myErr =GetMoviesError();
    }
    free(myPrompt);
    free(myFileName);
    return(myErr);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMoviesError ( void );

/*QTSoundDescriptionSetProperty

Sets a particular property of a sound description.

OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress );
Parameters
inDesc

The sound description being modified.
inPropClass

The class of the property being set. 
inPropID

The ID of the property being set.
inPropValueSize

The size of the property value buffer.
inPropValueAddress

A pointer to the property value buffer. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

The following constants identify sound description properties.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress );

/*SetMovieGWorld

Establishes a movie's display coordinate system by setting the graphics world for displaying the movie.

void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
port

Points to the movie's CGrafPort structure or graphics world. Set this parameter to NIL to use the current graphics port.
gdh

A handle to the movie's GDevice structure. Set this parameter to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's graphics device.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Special Considerations

When you use this function, the Movie Toolbox remembers the current background color and background pattern. These are used for erasing in the default movie uncover function; see SetMovieCoverProcs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh );

/*SetMovieVisualContext

Targets a movie to render into a visual context.

OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext;
Parameters
movie

The movie.
visualContext

The visual context that the movie will render into. May be NULL..
Return Value

An error code. Returns noErr if there is no error. Returns memFullErr if memory cannot be allocated. Returns kQTVisualContextNotAllowed if the movie is not able to render using a visual context. Returns paramErr if the movie is NULL.
Discussion

When SetMovieVisualContext succeeds, it will retain the QTVisualContext object for its own use. If visualContext is NULL, the movie will not render any visual media. SetMovieVisualContext will fail if a different movie is already using the visual context, so you should first disassociate the other movie by calling SetMovieVisualContext with a NULL visualContext. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext);

/*PrerollMovie

Prepares a portion of a movie for playback.

OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to play.
Rate

The rate at which you anticipate playing the movie. You specify the movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

When your application calls PrerollMovie, the Movie Toolbox tells the appropriate media handlers to prepare to play the movie. The media handlers may then load the movie data and perform any other necessary preparations to play the movie, such as allocating sound channels and starting up image-decompression sequences. In this manner, you can eliminate playback stutter when the movie starts playing.

If your application uses QuickTime's Movie Toolbox to play back movies, there are two choices for how to preroll the movie. Like the movie controller, the Movie Toolbox provides a single function call, StartMovie, which will both preroll the movie and start it playing. Unlike the movie controller, the Movie Toolbox function doesn't allow you to specific the rate to play the movie at, but instead assumes the movie's preferred rate.

Calling StartMovie, just like the movie controller's preroll and play action, first prerolls the movie and then sets it playing. If your application requires more control, the Movie Toolbox provides lower level functions that give you more control:// PrerollMovie coding example
StartMovie(theMovie);
TimeValue timeNow;
Fixed playRate;
timeNow =GetMovieTime(theMovie, NIL);
playRate =GetMoviePreferredRate(theMovie);
PrePrerollMovie(theMovie, timeNow, playRate, NIL, NIL);
PrerollMovie(theMovie, timeNow, playRate);
SetMovieRate(theMovie, playRate);

Special Considerations

You should always call PrePrerollMovie before calling this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate );

/*GetMovieTime

Returns a movie's current time both as a time value and in a time structure.

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
currentTime

A pointer to a TimeRecord structure. The function updates this time structure to contain the movie's current time. If you don't want this information, set this parameter to NIL.
Return Value

The time value of the current time.
Discussion

This function returns the movie's current time value in two formats: as a time value and in a time structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime );

/*MoviesTask

Services active movies.

void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle. If you set this parameter to NIL, the Movie Toolbox services all of your active movies.
maxMilliSecToUse

Determines the maximum number of milliseconds that MoviesTask can work before returning. If this parameter is 0, MoviesTask services every active movie exactly once and then returns. If the parameter is nonzero, MoviesTask services as many movies as it can in the allotted time before returning. Once the MoviesTask function starts servicing a movie, it cannot stop until it has completely met the requirements of the movie. Consequently, the MoviesTask function may execute for a longer time than that specified in maxMilliSecToUse. However, the function does not start servicing a new movie if the time specified by maxMilliSecToUse has elapsed. The preferred way to use MoviesTask is to set the maxMilliSecToUse parameter to 0; however, if you just want to play one movie, you can call MoviesTask on that one. If your rate is 0, MoviesTask draws that frame and no other.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

You should call MoviesTask as often as possible from your application's main event loop. Note that you should call this function after you have performed your own event processing. MoviesTask services only active movies, and only enabled tracks within those active movies.
Special Considerations

Note that the MoviesTask function services only your movies. Your application must give other applications the opportunity to call MoviesTask for their movies.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse );

/*UpdateMovie

Ensures that the Movie Toolbox properly displays your movie after it has been uncovered.

OSErr UpdateMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application should call this function during window updating. Don't call MoviesTask at this time; you will observe better display behavior if you call it at the end of your update processing.

This function does not actually update the movie's graphics world. Rather, it invalidates the movie's display state so that the Movie Toolbox redraws the movie the next time you call MoviesTask. If you need to force a movie to be redrawn outside of a window update sequence, your application can call this function and then call MoviesTask to service the movie. The Movie Toolbox determines the portion of the screen to update by examining the graphics port's visible region.

The following code snippet uses this function in a Macintosh Window Manager update sequence:// UpdateMovie coding example
#include <Events.h>
#include <ToolUtils.h>
#include "Movies.h"
void DoUpdate (WindowRef theWindow, Movie theMovie)
{
    BeginUpdate (theWindow);
    UpdateMovie (theMovie);
    EndUpdate (theWindow);
} // DoUpdate 

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr UpdateMovie (
   Movie    theMovie );

/*PutUserDataIntoHandle

Returns a handle to a user data structure.

OSErr PutUserDataIntoHandle (
   UserData    theUserData,
   Handle      h );
Parameters
theUserData

The user data structure.
h

A handle to the UserDataRecord structure pointed to by the theUserData parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutUserDataIntoHandle (
   UserData    theUserData,
   Handle      h );

/*NewUserDataFromHandle

Creates a new user data structure from a handle.

OSErr NewUserDataFromHandle (
   Handle      h,
   UserData    *theUserData );
Parameters
h

A handle to the data structure specified in theUserData.
theUserData

A pointer to a pointer to a new UserDataRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error. If the function fails, theUserData is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewUserDataFromHandle (
   Handle      h,
   UserData    *theUserData );

/*DisposeUserData

Disposes of a user data structure created by NewUserData.

OSErr DisposeUserData (
   UserData    theUserData );
Parameters
theUserData

The user data structure that is to be disposed of. It is acceptable but unnecessary to pass NIL in this parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DisposeUserData (
   UserData    theUserData );

/*QTSoundDescriptionGetProperty

Gets a particular property of a sound description.

OSStatus QTSoundDescriptionGetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
QTPropertyValuePtr         outPropValueAddress,
ByteCount                  *outPropValueSizeUsed);
Parameters
inDesc

The sound description being interrogated.
inPropClass

The class of the property being requested. 
inPropID

The ID of the property being requested.
inPropValueSize

The size of the property value buffer.
outPropValueAddress

A pointer to the property value buffer.
outPropValueSizeUsed

The actual size of the returned property value (can be NULL). 
Return Value

An error code. Returns noErr if there is no error.
Discussion

The following constants identify sound description properties.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionGetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
QTPropertyValuePtr         outPropValueAddress,
ByteCount                  *outPropValueSizeUsed);

/*MCDoAction

Invokes a movie controller component and makes it perform a specified action.

ComponentResult MCDoAction (
   MovieController    mc,
   short              action,
   void               *params );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
action

The action to be taken. See Movie Controller Actions.
params

A pointer to the parameter data appropriate to the action. See Movie Controller Actions for information about the parameters required for each supported action.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCDoAction (
   MovieController    mc,
   short              action,
   void               *params );

/*ExitMoviesOnThread

Indicates to QuickTime that the client will no longer be using QuickTime on the current thread.

OSErr ExitMoviesOnThread (void);
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns an appropriate operating system or QuickTime error if the operation couldn't be completed. This might occur because a previous call to EnterMoviesOnThread was not made.
Discussion

This function should be called before exiting from a spawned thread that uses QuickTime. It undoes the setup performed by EnterMoviesOnThread. Each call to EnterMoviesOnThread should be matched with a call to this function. This function should not be called on a thread without a previous call to EnterMoviesOnThread.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr ExitMoviesOnThread (void);

/*EnterMoviesOnThread

Indicates that the client will be using QuickTime on the current thread.

OSErr EnterMoviesOnThread (UInt32 inFlags);
Parameters
inFlags

Flag (see below) indicating how the executing thread will use QuickTime. Setting the thread mode is a convenience provided by this function. Pass 0 for the default options. See these constants: 
kQTEnterMoviesFlagDontSetComponentsThreadMode
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. This function returns an appropriate operating system or QuickTime error if the operation couldn't be completed. This might occur because a second call on the thread was made that used incompatible flags (for example, the first call required a shared state but a subsequent call required a private state).
Discussion

This function is analogous to EnterMovies. It initializes QuickTime and prepares QuickTime for calls from its thread. Unlike EnterMovies, this function allows the client to indicate if its access to QuickTime requires sharing of QuickTime state with the main thread. The default is to maintain a private state. 
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr EnterMoviesOnThread (UInt32 inFlags);

/*QTNewAlias

Creates a Mac OS alias to a file.

OSErr QTNewAlias (
   const FSSpec    *fss,
   AliasHandle     *alias,
   Boolean         minimal );
Parameters
fss

A pointer to an FSSpec structure that specifies a file.
alias

On return, a pointer to a handle to a new AliasRecord structure that defines an alias to the file. If the function was unable to create an alias, the handle is set to NIL. This function does not create relative aliases. For further information about Mac OS file aliases, see Chapter 4 of Inside Macintosh: Files.
minimal

If you pass TRUE, the function writes in the AliasRecord structure only the target name, parent directory ID, volume name and creation date, and volume mounting information. If you pass FALSE, it fills out the structure fully.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTNewAlias (
   const FSSpec    *fss,
   AliasHandle     *alias,
   Boolean         minimal );

/*QTLockContainer

Locks an atom container in memory.

OSErr QTLockContainer (
   QTAtomContainer    container );
Parameters
container

The atom container to be locked.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You should call this function to lock an atom container before calling QTGetAtomDataPtr to directly access a leaf atom's data. When you have finished accessing a leaf atom's data, you should call QTUnlockContainer. You may make nested pairs of calls to QTLockContainer and QTUnlockContainer; you don't need to check the current state of the container first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTLockContainer (
   QTAtomContainer    container );

/*QTFindChildByIndex

Retrieves an atom by index from the child list of the specified parent atom.

QTAtom QTFindChildByIndex (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   short              index,
   QTAtomID           *id );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
atomType

The type of the atom to be retrieved.
index

The index of the atom to be retrieved.
id

A pointer to an uninitialized QTAtomID data structure. On return, if the atom specified by index was found, the QTAtomID data structure contains the atom's ID. If you don't want this function to return the atom's ID, set the value of the id parameter to NIL.
Return Value

The found atom.
Discussion

You call this function to search for and retrieve an atom by its type and index within that type from a parent atom's child list. The following code illustrates one way to use it:// QTFindChildByIndex coding example
if ((propertyAtom =QTFindChildByIndex (sprite, kParentAtomIsContainer,
    kSpritePropertyImageIndex, 1, NIL)) ==0)
    FailOSErr (QTInsertChild (sprite, kParentAtomIsContainer,
        kSpritePropertyImageIndex, 1, 1, sizeof(short),&imageIndex,
        NIL));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
QTAtom QTFindChildByIndex (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   short              index,
   QTAtomID           *id );

/*QTGetAtomDataPtr

Retrieves a pointer to the atom data for a specified leaf atom.

OSErr QTGetAtomDataPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   long               *dataSize,
   Ptr                *atomData );
Parameters
container

The atom container that contains the leaf atom.
atom

The leaf atom whose data should be retrieved.
dataSize

On return, contains a pointer to the length, in bytes, of the leaf atom's data.
atomData

On return, contains a pointer to the leaf atom's data.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function in retrieve a pointer to a leaf atom's data so that you can access the data directly.
Special Considerations

To ensure that the pointer returned in the atomData parameter will remain valid if memory is moved, you should call QTLockContainer before you call this function. If you call QTLockContainer, you should call QTUnlockContainer when you have finished using the atomData pointer. If you pass a locked atom container to a function that resizes atom containers, the function returns an error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetAtomDataPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   long               *dataSize,
   Ptr                *atomData );

/*QTUnlockContainer

Unlocks an atom container in memory.

OSErr QTUnlockContainer (
   QTAtomContainer    container );
Parameters
container

The atom container to be unlocked.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You should call this function to unlock an atom container when you have finished accessing a leaf atom's data. You may make nested pairs of calls to QTLockContainer and this function; you don't need to check the current state of the container first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTUnlockContainer (
   QTAtomContainer    container );

/*QTDisposeAtomContainer

Disposes of an atom container.

OSErr QTDisposeAtomContainer (
   QTAtomContainer    atomData );
Parameters
atomData

The atom container to be disposed of.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to dispose of an atom container data structure that was created by QTNewAtomContainer or QTCopyAtom.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTDisposeAtomContainer (
   QTAtomContainer    atomData );

/*NewMovieFromProperties

Creates a new movie using movie properties.

OSStatus NewMovieFromProperties (
ItemCount                    inputPropertyCount,
QTNewMoviePropertyElement    *inputProperties,
ItemCount                    outputPropertyCount,
QTNewMoviePropertyElement    *outputProperties,
Movie                        *theMovie );
Parameters
inputPropertyCount

The number of properties in the array passed in inputProperties.
inputProperties

A pointer to a property array describing how to instantiate the movie. See QTNewMoviePropertyElement.
outputPropertyCount

The number of properties in the array passed in outputProperties.
outputProperties

A pointer to a property array to receive output parameters. See QTNewMoviePropertyElement. You may pass NULL if you don't want this information. The caller is responsible for calling the appropriate routines to dispose of any property values returned here. Since callers specify the property classes and IDs, they know who to call to dispose of the property values.
theMovie

A pointer to a variable that receives the new movie.
Return Value

An error code. Returns memFullErr if the function could not allocate memory, paramErr if inputProperties or theMovie is NULL, or noErr if there is no error.
Discussion

This function can be used in all the cases where an existing NewMovieFrom... call is used. When calling this function, you supply a set of input properties that describe the information required to instantiate the movie (its data reference, audio context, visual context, and so on). You can also supply a set of output properties that you may be interested in; for example, information about whether the data reference was changed. See New Movie Property Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus NewMovieFromProperties (
ItemCount                    inputPropertyCount,
QTNewMoviePropertyElement    *inputProperties,
ItemCount                    outputPropertyCount,
QTNewMoviePropertyElement    *outputProperties,
Movie                        *theMovie );

/*GoToBeginningOfMovie

Repositions a movie to play from its start.

void GoToBeginningOfMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Discussion

If the movie is in preview mode, the function goes to the start of the preview segment of the movie. In all other cases, this function goes to the start of the movie, where the movie time value is 0. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GoToBeginningOfMovie (
   Movie    theMovie );

/*GetMovieTimeBase

Returns a movie's time base.

TimeBase GetMovieTimeBase (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's TimeBaseRecord structure.
Special Considerations

The Movie Toolbox disposes of a movie's time base when you dispose of the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeBase GetMovieTimeBase (
   Movie    theMovie );

/*StopMovie

Stops the playback of a movie.

void StopMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void StopMovie (
   Movie    theMovie );

/*GetTrackMedia

Determines the media that contains a track's sample data.

Media GetTrackMedia (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The media identifier for the media that contains the track's sample data. If the function could not locate the media, it sets this returned value to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Media GetTrackMedia (
   Track    theTrack );

/*SetTimeBaseFlags

Sets the contents of the control flags of a time base.

void SetTimeBaseFlags (
   TimeBase    tb,
   long        timeBaseFlags );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
timeBaseFlags

The control flags for this time base (see below). You may set only one flag to 1. Be sure to set unused flags to 0. See these constants: 
loopTimeBase
palindromeLoopTimeBase
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTimeBaseFlags (
   TimeBase    tb,
   long        timeBaseFlags );

/*SetMoviePlayHints

Provides information to the Movie Toolbox that can influence movie playback.

void SetMoviePlayHints (
   Movie    theMovie,
   long     flags,
   long     flagsMask );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
flags

The optimizations that can be used with this movie. Each bit in the flags parameter corresponds to a specific optimization (see below). Be sure to set unused flags to 0. See these constants: 

hintsScrubMode

hintsUseSoundInterp

hintsAllowInterlace

hintsAllowBlacklining

hintsDontPurge

hintsInactive

hintsHighQuality
flagsMask

Indicates which flags in the flags parameter are to be considered in this operation. For each bit in the flags parameter that you want the Movie Toolbox to consider, you must set the corresponding bit in the flagsMask parameter to 1. Set unused flags to 0. This allows you to work with a single optimization without altering the settings of other flags.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

This function accepts a flag in which you specify optimizations that the Movie Toolbox can use during movie playback. These optimizations apply to all of the media structures used by the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMoviePlayHints (
   Movie    theMovie,
   long     flags,
   long     flagsMask );


/*SetTimeBaseMasterTimeBase

Assigns a master time base to a time base.

void SetTimeBaseMasterTimeBase (
   TimeBase            slave,
   TimeBase            master,
   const TimeRecord    *slaveZero );
Parameters
slave

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
master

The master time base to be assigned to this time base. Your application obtains this time base identifier from NewTimeBase.
slaveZero

A pointer to the time, in the time scale of the master time base, that corresponds to a 0 time value for the slave time scale. This parameter allows you to set an offset between the time base and the master time base. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A time base derives its time from either a clock component or another time base. Don't use this function to assign a master time base to a movie's time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTimeBaseMasterTimeBase (
   TimeBase            slave,
   TimeBase            master,
   const TimeRecord    *slaveZero );

/*SetTrackEnabled

Enables or disables a track.

void SetTrackEnabled (
   Track      theTrack,
   Boolean    isEnabled );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
isEnabled

Enables or disables the track. Set this parameter to TRUE to enable the track. Set this parameter to FALSE to disable the track.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox services only enabled tracks.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTrackEnabled (
   Track      theTrack,
   Boolean    isEnabled );

/*SetMovieRate

Sets a movie's playback rate.

void SetMovieRate (
   Movie    theMovie,
   Fixed    rate );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
rate

The new movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates. This value immediately changes the rate at which the movie is playing. A value of 1 starts the movie playing at normal speed, a value of 2 causes the movie to play at double speed, -2 starts the movie playing backward at double speed, and so on. A value of 0 stops the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

Use this function to change the speed at which a movie is playing. You do not normally use this function to start and stop movies; use the higher level functions StartMovie and StopMovie instead. If you start a movie using this function, you should call PrePrerollMovie and PrerollMovie first, to set up any network connections, buffers, and data structures necessary to play the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieRate (
   Movie    theMovie,
   Fixed    rate );

/*QTMetaDataRelease

Decrements the retain count of a metadata object.

void QTMetaDataRelease ( QTMetaDataRef inMetaData );
Discussion

This function releases a metadata object by decrementing its reference count. When the count becomes 0 the memory allocated to the object is freed and the object is destroyed. If you retain a metadata object you are responsible for releasing it when you no longer need it.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void QTMetaDataRelease ( QTMetaDataRef inMetaData );

/*QTMetaDataGetItemProperty

Returns a property of a metadata item.

OSStatus QTMetaDataGetItemProperty (
QTMetaDataRef         inMetaData,
QTMetaDataItem        inItem,
QTPropertyClass       inPropClass,
QTPropertyID          inPropID,
ByteCount             inPropValueSize,
QTPropertyValuePtr    outPropValueAddress,
ByteCount             *outPropValueSizeUsed );
Parameters
inMetaData

The metadata object for this operation.
inItem

The opaque, unique UInt64 identifier of the metadata item for this operation. Your application obtains this item identifier from such functions as QTMetaDataAddItem and QTMetaDataGetNextItem.
inPropClass

The class of the property being asked about.
inPropID

The ID of the property being asked about.
inPropValueSize

Size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the item's property value.
outPropValueSizeUsed

On return, the actual size of buffer space used.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, errPropNotSupported if the metatada object does not support the property being asked about, buffersTooSmall if the allocated buffer is too small to hold the property, or noErr if there is no error. See Metadata Error Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetItemProperty (
QTMetaDataRef         inMetaData,
QTMetaDataItem        inItem,
QTPropertyClass       inPropClass,
QTPropertyID          inPropID,
ByteCount             inPropValueSize,
QTPropertyValuePtr    outPropValueAddress,
ByteCount             *outPropValueSizeUsed );

/*QTMetaDataGetItemPropertyInfo

Returns information about a property of a metadata item.

OSStatus QTMetaDataGetItemPropertyInfo (
QTMetaDataRef          inMetaData,
QTMetaDataItem         inItem,
QTPropertyClass        inPropClass,
QTPropertyID           inPropID,
QTPropertyValueType    *outPropType,
ByteCount              *outPropValueSize,
UInt32                 *outPropFlags );
Parameters
inMetaData

The metadata object for this operation.
inItem

The opaque, unique UInt64 identifier of the metadata item for this operation. Your application obtains this item identifier from such functions as QTMetaDataAddItem and QTMetaDataGetNextItem.
inPropClass

The class of the property being asked about.
inPropID

The ID of the property being asked about.
outPropType

A pointer to the type of the returned property's value.
outPropValueSize

A pointer to the size of the returned property's value.
outPropFlags

On return, a pointer to flags representing the requested information about the item's property.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, errPropNotSupported if the metatada object does not support the item property being asked about, or noErr if there is no error. See Metadata Error Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetItemPropertyInfo (
QTMetaDataRef          inMetaData,
QTMetaDataItem         inItem,
QTPropertyClass        inPropClass,
QTPropertyID           inPropID,
QTPropertyValueType    *outPropType,
ByteCount              *outPropValueSize,
UInt32                 *outPropFlags );

/*QTMetaDataGetNextItem

Returns the next metadata item corresponding to a specified key.

OSStatus QTMetaDataGetNextItem (
QTMetaDataRef              inMetaData,
QTMetaDataStorageFormat    inMetaDataFormat,
QTMetaDataItem             inCurrentItem,
QTMetaDataKeyFormat        inKeyFormat,
const UInt8                *inKeyPtr,
ByteCount                  inKeySize,
QTMetaDataItem             *outNextItem );
Parameters
inMetaData

The metadata object for this operation.
inMetaDataFormat

The metadata storage format used by the object passed in inMetaData. The format may be UserData storage, iTunes metadata storage, or QuickTime metadata storage. Not all objects will include all forms of storage, and other storage formats may appear in the future. Pass kQTMetaDataStorageFormatWildcard to target all storage formats.
inCurrentItem

The opaque, unique UInt64 identifier of the current metadata item to start the search. Your application obtains this item identifier from such functions as QTMetaDataAddItem.
inKeyFormat

The format of the key.
inKeyPtr

A pointer to the key of the item to be fetched next. You may pass NULL in this parameter if you are not interested in any specific key.
inKeySize

The size of the key in bytes.
outNextItem

The ID of the next metadata item after the item specified by inCurrentItem that has the specified key.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, kQTMetaDataInvalidStorageFormatErr if the metatada storage format is invalid, kQTMetaDataInvalidKeyErr if the key or its format is invalid, kQTMetaDataNoMoreItemErr if the last item has been fetched, or noErr if there is no error. See Metadata Error Codes.
Discussion

If the item designated by inCurrentItem is kQTMetaDataItemUninitialized, the function returns the first item with the specified key in the storage format. If it refers to a valid item in the storage format, the function will return the next item with the key after the item designated by inCurrentItem.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetNextItem (
QTMetaDataRef              inMetaData,
QTMetaDataStorageFormat    inMetaDataFormat,
QTMetaDataItem             inCurrentItem,
QTMetaDataKeyFormat        inKeyFormat,
const UInt8                *inKeyPtr,
ByteCount                  inKeySize,
QTMetaDataItem             *outNextItem );

/*QTCopyMovieMetaData

Retains a movie's metadata object and returns it.

OSStatus QTCopyMovieMetaData (
Movie            inMovie,
QTMetaDataRef    *outMetaData );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
outMetaData

A pointer to an opaque metadata object wrapper associated with the movie passed in inMovie.
Return Value

Returns invalidMovie if the movie passed in inMovie is invalid, or noErr if there is no error. 
Discussion

This function returns the metadata object associated with a movie. The object has retain/release semantics. It has already been retained before returning, but you should call QTMetaDataRelease when you are done. Because the movie can be disposed of at any time, the QTMetaDataRef may be valid when the movie no longer exists. In this case, the function will fail with a kQTMetaDataInvalidMetaDataErr error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTCopyMovieMetaData (
Movie            inMovie,
QTMetaDataRef    *outMetaData );

/*GetMovieTimeScale

Returns the time scale of a movie.

TimeScale GetMovieTimeScale (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A long integer that contains the movie's time scale.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeScale GetMovieTimeScale (
   Movie    theMovie );

/*GetMovieIndTrackType

Searches for all of a movie's tracks that share a given media type or media characteristic.

Track GetMovieIndTrackType (
   Movie     theMovie,
   long      index,
   OSType    trackType,
   long      flags );
Parameters
theMovie

The movie for this operation. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
index

The index value of the track for this operation. This is not that same as the track's index value in the movie. Rather, this parameter is an index into the set of tracks that meet your other selection criteria.
trackType

Contains either a media type or a media characteristic value. The toolbox applies this value to the search, and returns information about tracks that meet this criterion. You indicate whether you have specified a media type or characteristic value by setting the flags parameter appropriately.
flags

Contains flags (see below) that control the search operation. Note that you may not set both movieTrackMediaType and movieTrackCharacteristic to 1. See these constants: 
movieTrackMediaType
movieTrackCharacteristic
movieTrackEnabledOnly
Return Value

A track identifier.
Discussion

The toolbox returns the track identifier that corresponds to the track that meets your selection criteria. If the toolbox cannot find a matching track, in returns a value of NIL. Note that the index parameter does not work the same way that is does in GetMovieIndTrack. With GetMovieIndTrackType, the index parameter specifies an index into the set of tracks that meet your other selection criteria. For example, in order to find the third track that supports the sound characteristic, you would call the function in the following manner:theTrack =GetMovieIndTrackType (theMovie, 3, AudioMediaCharacteristic, movieTrackCharacteristic);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track GetMovieIndTrackType (
   Movie     theMovie,
   long      index,
   OSType    trackType,
   long      flags );

/*GetMediaDecodeDuration

Returns the decode duration of a media.

TimeValue64 GetMediaDecodeDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's decode duration. A media's decode duration is the sum of the decode durations of its samples.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 GetMediaDecodeDuration (
   Media    theMedia );

/*GetMediaDisplayDuration

Returns the display duration of a media.

TimeValue64 GetMediaDisplayDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's display duration. A media's display duration is its display end time minus its display start time. For media without nonzero display offsets, the decode duration and display duration are the same.
Discussion

When inserting media with display offsets into a track, use display time:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 GetMediaDisplayDuration (
   Media    theMedia );

/*GetMediaSampleCount

Determines the number of samples in a media.

long GetMediaSampleCount (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

The number of samples in the media.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetMediaSampleCount (
   Media    theMedia );

/*GetMediaTimeScale

Determines a media's time scale.

TimeScale GetMediaTimeScale (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The media's time scale.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeScale GetMediaTimeScale (
   Media    theMedia );

/*GetTrackDuration

Returns the duration of a track.

TimeValue GetTrackDuration (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The duration of the specified track, expressed in the time scale of the movie that contains the track.
Discussion

The duration corresponds to the ending time of the track in the movie's time coordinate system (remember that all tracks start at movie time 0).
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetTrackDuration (
   Track    theTrack );

/*GetMediaSampleDescription

Retrieves a SampleDescription structure from a media.

void GetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
index

The index of the SampleDescription structure to retrieve. This index corresponds to the structure itself, not to the samples in the media. Index numbers start with 1.
descH

Specifies a handle that is to receive the SampleDescription structure. The Movie Toolbox correctly resizes this handle for the returned structure. If there is no description for the specified index, the function returns this handle unchanged. Your application must allocate and dispose of this handle.
Discussion

The Movie Toolbox identifies a media's sample descriptions with an index value, ranging from 1 to the number of sample descriptions in the media. Sample description indexes provide a convenient way to access each sample description in a media. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Special Considerations

The format of sample descriptions differs by media type. Sample descriptions for image data are defined by ImageDescription structures. Sample descriptions for sound are defined by SoundDescription structures. Sample descriptions for text are defined by TextDescription structures.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );

/*SampleNumToMediaDecodeTime

Finds the decode time for a specified sample.

void SampleNumToMediaDecodeTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
logicalSampleNum

A 64-bit signed integer that contains the sample number.
sampleDecodeTime

A pointer to a time value. The function updates this time value to indicate the decode time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDecodeDuration

A pointer to a time value. The function updates this time value to indicate the decode duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void SampleNumToMediaDecodeTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );

/*MediaDecodeTimeToSampleNum

Finds the sample for a specified decode time.

void MediaDecodeTimeToSampleNum (
   Media          theMedia,
   TimeValue64    decodeTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
decodeTime

A 64-bit time value that represents the decode time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a variable that is to receive the sample number. The function returns the sample number that identifies the sample that contains data for the specified decode time, or 0 if it is not found.
sampleDecodeTime

A pointer to a time value. The function updates this time value to indicate the decode time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDecodeDuration

A pointer to a time value. The function updates this time value to indicate the decode duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, invalidTime if sampleDecodeTime is out of the decode time range, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void MediaDecodeTimeToSampleNum (
   Media          theMedia,
   TimeValue64    decodeTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );

/*GetMediaSample2

Retrieves sample data from a media file.

OSErr GetMediaSample2 (
   Media                      theMedia,
   UInt8                      *dataOut,
   ByteCount                  maxDataSize,
   ByteCount                  *size,
   TimeValue64                decodeTime,
   TimeValue64                *sampleDecodeTime,
   TimeValue64                *decodeDurationPerSample,
   TimeValue64                *displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  *sampleDescriptionIndex,
   ItemCount                  maxNumberOfSamples,
   ItemCount                  *numberOfSamples,
   MediaSampleFlags           *sampleFlags );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
dataOut

A pointer to a buffer to receive sample data. The buffer must be large enough to contain at least maxDataSize bytes. If you do not want to receive sample data, pass NULL.
maxDataSize

The maximum number of bytes allocated to hold the sample data.
size

A pointer to memory where the function returns the number of bytes of sample data returned in the memory area specified by dataOut. Set this parameter to NULL if you are not interested in this information.
decodeTime

The starting time of the sample to be retrieved in decode time. You must specify this value in the media's time scale.
sampleDecodeTime

A pointer to a time value in decode time. The function updates this time value to indicate the actual time of the returned sample data. (The returned time may differ from the time you specified with the time parameter. This will occur if the time you specified falls in the middle of a sample.) If you are not interested in this information, set this parameter to NULL.
decodeDurationPerSample

A pointer to a time value in decode time. The Movie Toolbox returns the duration of each sample in the media. Set this parameter to NULL if you don't want this information.
displayOffset

A pointer to a time value. The function updates this time value to indicate the display offset of the returned sample. This time value is expressed in the media's time scale. Set this parameter to NULL if you don't want this information.
sampleDescriptionH

A handle to a SampleDescription structure. The function returns the sample description corresponding to the returned sample data. The function resizes this handle as appropriate. If you don't want a SampleDescription structure, set this parameter to NIL.
sampleDescriptionIndex

A pointer to a long integer. The function returns an index value to the SampleDescription structure that corresponds to the returned sample data. You can retrieve the structure by calling GetMediaSampleDescription and passing this index in the descH parameter. If you don't want this information, set this parameter to NIL.
maxNumberOfSamples

The maximum number of samples to be returned. The Movie Toolbox does not return more samples than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media, and returns that value in the field referenced by the numberOfSamples parameter.
numberOfSamples

A pointer to a long integer. The function updates the field referred to by this parameter with the number of samples it actually returns. If you don't want this information, set this parameter to NULL.
sampleFlags

A pointer to a short integer in which the function returns flags that describe the sample. Unused flags are set to 0. If you don't want this information, set this parameter to NULL: mediaSampleNotSync This flag is set to 1 if the sample is not a sync sample and to 0 if the sample is a sync sample. See these constants: 
mediaSampleNotSync
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, maxSizeToGrowTooSmall if the sample data is larger than maxDataSize, or noErr if there is no error.
Discussion

Whereas GetMediaSample takes a resizable Handle and a maxSizeToGrow parameter, GetMediaSample2 takes a pointer and a maxDataSize parameter. If you want to read a sample into a Handle, you can use the following code:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr GetMediaSample2 (
   Media                      theMedia,
   UInt8                      *dataOut,
   ByteCount                  maxDataSize,
   ByteCount                  *size,
   TimeValue64                decodeTime,
   TimeValue64                *sampleDecodeTime,
   TimeValue64                *decodeDurationPerSample,
   TimeValue64                *displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  *sampleDescriptionIndex,
   ItemCount                  maxNumberOfSamples,
   ItemCount                  *numberOfSamples,
   MediaSampleFlags           *sampleFlags );

/*GetMediaNextInterestingDecodeTime

Searches for decode times of interest in a media.

void GetMediaNextInterestingDecodeTime (
   Media          theMedia,
   short          interestingTimeFlags,
   TimeValue64    decodeTime,
   Fixed          rate,
   TimeValue64    *interestingDecodeTime,
   TimeValue64    *interestingDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
interestingTimeFlags

Flags that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, or nextTimeSyncSample flags to 1. Set unused flags to 0: nextTimeMediaSample Set this flag to 1 to search for the next sample. nextTimeMediaEdit Set this flag to 1 to search for the next group of samples. nextTimeSyncSample Set this flag to 1 to search for the next sync sample. nextTimeEdgeOK Set this flag to 1 to accept information about elements that begin or end at the time specified by the decodeTime parameter. When this flag is set the function returns valid information about the beginning and end of a media. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeSyncSample
nextTimeEdgeOK
decodeTime

Specifies the starting point for the search in decode time. This time value must be expressed in the media's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingDecodeTime

On return, a pointer to a 64-bit time value in decode time. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the media's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NULL if you are not interested in this information.
interestingDecodeDuration

On return, a pointer to a 64-bit time value in decode time. The Movie Toolbox returns the duration of the interesting time in the media's time coordinate system. Set this parameter to NULL if you don't want this information; this lets the function works faster.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void GetMediaNextInterestingDecodeTime (
   Media          theMedia,
   short          interestingTimeFlags,
   TimeValue64    decodeTime,
   Fixed          rate,
   TimeValue64    *interestingDecodeTime,
   TimeValue64    *interestingDecodeDuration );

/*GetTrackMovie

Determines the movie that contains a specified track.

Movie GetTrackMovie (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The identifier of the movie that contains the track.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Movie GetTrackMovie (
   Track    theTrack );

/*GetTrackNextInterestingTime

Searches for times of interest in a track.

void GetTrackNextInterestingTime (
   Track        theTrack,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
interestingTimeFlags

Contains flags (see below) that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, nextTimeTrackEdit and nextTimeSyncSample flags to 1. Set unused flags to 0. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeTrackEdit
nextTimeSyncSample
nextTimeEdgeOK
nextTimeIgnoreActiveSegment
time

Specifies a time value that establishes the starting point for the search. This time value must be expressed in the movie's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingTime

A pointer to a time value. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the movie's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NIL if you are not interested in this information.
interestingDuration

A pointer to a time value. The Movie Toolbox returns the duration of the interesting time. This time value is in the movie's time coordinate system. Set this parameter to NIL if you don't want this information; in this case, the function works more quickly.
Discussion

Some compression algorithms conserve space by eliminating duplication between consecutive frames in a sample. In this case, sync samples don't rely on preceding frames for content. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackNextInterestingTime (
   Track        theTrack,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration );


/*TrackTimeToMediaDisplayTime

Converts a track's time value to a display time value that is appropriate to the track's media, using the track's edit list.

TimeValue64 TrackTimeToMediaDisplayTime (
   TimeValue64    value,
   Track          theTrack );
Parameters
value

A 64-bit time value that represents the track's time value; it must be expressed in the time scale of the movie that contains the track.
theTrack

A track identifier, which your application obtains from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A 64-bit time value that represents the corresponding time in media display time, in the media's time coordinate system. If the track time corresponds to empty space, this function returns a value of -1.
Discussion

This function maps the track time through the track's edit list to come up with the media time. This time value contains the track's time value according to the media's time coordinate system. If the time you specified lies outside of the movie's active segment or corresponds to empty space in the track, this function returns a value of -1. Hence you can use it to determine whether a specified track edit is empty.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 TrackTimeToMediaDisplayTime (
   TimeValue64    value,
   Track          theTrack );


/*GetTrackEditRate

Returns the rate of the track edit of a specified track at an indicated time.

Fixed GetTrackEditRate (
   Track        theTrack,
   TimeValue    atTime );
Parameters
theTrack

The track identifier for which the rate of a track edit (at the time given in the atTime parameter) is to be determined.
atTime

Indicates a time value at which the rate of a track edit (of a track identified in the parameter theTrack) is to be determined.
Return Value

The rate of the track edit of the specified track at the specified time.
Discussion

This function is useful if you are stepping through track edits directly in your application or if you are a client of QuickTime's base media handler.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Fixed GetTrackEditRate (
   Track        theTrack,
   TimeValue    atTime );

/*CopyMediaMutableSampleTable

Obtains information about sample references in a media in the form of a sample table.

OSErr CopyMediaMutableSampleTable (
   Media                      theMedia,
   TimeValue64                startDecodeTime,
   TimeValue64                *sampleStartDecodeTime,
   SInt64                     maxNumberOfSamples,
   TimeValue64                maxDecodeDuration,
   QTMutableSampleTableRef    *sampleTableOut );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
startDecodeTime

A 64-bit time value that represents the starting decode time of the sample references to be retrieved. You must specify this value in the media's time scale.
sampleStartDecodeTime

A pointer to a time value. The function updates this time value to indicate the actual decode time of the first returned sample reference. If you are not interested in this information, set this parameter to NULL. The returned time may differ from the time you specified with the startDecodeTime parameter. This will occur if the time you specified falls in the middle of a sample.
maxNumberOfSamples

A 64-bit signed integer that contains the maximum number of sample references to be returned. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate to the media.
maxDecodeDuration

A 64-bit time value that represents the maximum decode duration to be returned. The function does not return samples with greater decode duration than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media.
sampleTableOut

A reference to an opaque sample table object. When you are done with the returned sample table, release it with QTSampleTableRelease.
Return Value

An error code. Returns memFullErr if it could not allocate memory, paramErr if there was an invalid parameter, or noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

To find out how many samples were returned in the sample table, call QTSampleTableGetNumberOfSamples.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr CopyMediaMutableSampleTable (
   Media                      theMedia,
   TimeValue64                startDecodeTime,
   TimeValue64                *sampleStartDecodeTime,
   SInt64                     maxNumberOfSamples,
   TimeValue64                maxDecodeDuration,
   QTMutableSampleTableRef    *sampleTableOut );

/*QTSampleTableGetNumberOfSamples

Returns the number of samples in a sample table.

SInt64 QTSampleTableGetNumberOfSamples (
   QTSampleTableRef    sampleTable );
Parameters
sampleTable

A reference to an opaque sample table object.
Return Value

A 64-bit signed integer that contains the number of samples, or 0 if sampleTable is NULL.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
SInt64 QTSampleTableGetNumberOfSamples (
   QTSampleTableRef    sampleTable );

/*QTSampleTableGetDecodeDuration

Returns the decode duration of a sample.

TimeValue64 QTSampleTableGetDecodeDuration (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A 64-bit time value that represents the decode duration of the sample. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

TimeValue64 QTSampleTableGetDecodeDuration (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );


/*QTSampleTableGetDataSizePerSample

Returns the data size of a sample.

ByteCount QTSampleTableGetDataSizePerSample (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

The size of the sample in bytes. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
ByteCount QTSampleTableGetDataSizePerSample (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );

/*QTSampleTableGetSampleFlags

Returns the media sample flags of a sample.

MediaSampleFlags QTSampleTableGetSampleFlags (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A constant that describes characteristics of the sample (see below). Returns 0 if sampleTable is NULL or if the sample number is out of range.
Discussion

This function can return one or more of the following constants:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

MediaSampleFlags QTSampleTableGetSampleFlags (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );

/*QTSampleTableCopySampleDescription

Retrieves a sample description from a sample table.

OSStatus QTSampleTableCopySampleDescription (
   QTSampleTableRef           sampleTable,
   QTSampleDescriptionID      sampleDescriptionID,
   long                       *mediaSampleDescriptionIndexOut,
   SampleDescriptionHandle    *sampleDescriptionHOut );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleDescriptionID

The sample description ID.
mediaSampleDescriptionIndexOut

A pointer to a variable to receive a media sample description index. If the sample description came from a media, this is the index that could be passed to GetMediaSampleDescription to retrieve the same sample description handle. The index will be 0 if the sample description did not come directly from a media. Pass NULL if you do not want to receive this information.
sampleDescriptionHOut

A pointer to a variable to receive a newly allocated sample description handle. Pass NULL if you do not want one. The caller is responsible for disposing the returned sample description handle using DisposeHandle.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSampleTableCopySampleDescription (
   QTSampleTableRef           sampleTable,
   QTSampleDescriptionID      sampleDescriptionID,
   long                       *mediaSampleDescriptionIndexOut,
   SampleDescriptionHandle    *sampleDescriptionHOut );

/*SampleNumToMediaDisplayTime

Finds the display time for a specified sample.

void SampleNumToMediaDisplayTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
logicalSampleNum

A 64-bit signed integer that contains the sample number.
sampleDisplayTime

A pointer to a time value. The function updates this time value to indicate the display time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDisplayDuration

A pointer to a time value. The function updates this time value to indicate the display duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

void SampleNumToMediaDisplayTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );

/*QTSampleTableGetProperty

Returns the value of a specific sample table property.

OSStatus QTSampleTableGetProperty (
   QTSampleTableRef      sampleTable,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );
Parameters
sampleTable

A reference to an opaque sample table object.
inPropClass

Pass the following constant to define the property class: kQTPropertyClass_SampleTable = 'qtst' Property of a sample table. See these constants: 
kQTPropertyClass_SampleTable
inPropID

Pass one of these constants to define the property ID: kQTSampleTablePropertyID_TotalDecodeDuration = 'tded' The total decode duration of all samples in the sample table. Read-only. kQTSampleTablePropertyID_MinDisplayOffset = '<ddd' The least display offset in the table. Negative offsets are less than positive offsets. Read-only. kQTSampleTablePropertyID_MaxDisplayOffset = '>ddd' The greatest display offset in the table. Positive offsets are greater than negative offsets. Read-only. kQTSampleTablePropertyID_MinRelativeDisplayTime = '<dis' The least display time of all samples in the table, relative to the decode time of the first sample in the table. Read-only. kQTSampleTablePropertyID_MaxRelativeDisplayTime = '>dis' The greatest display time of all samples in the table, relative to the decode time of the first sample in the table. Read-only. See these constants: 
kQTSampleTablePropertyID_TotalDecodeDuration
kQTSampleTablePropertyID_MinDisplayOffset
kQTSampleTablePropertyID_MaxDisplayOffset
kQTSampleTablePropertyID_MinRelativeDisplayTime
kQTSampleTablePropertyID_MaxRelativeDisplayTime
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

On return, the actual size of the property value written to the buffer.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSampleTableGetProperty (
   QTSampleTableRef      sampleTable,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );

/*QTSampleTableRelease

Decrements the retain count of a sample table.

void QTSampleTableRelease (
   QTSampleTableRef    sampleTable );
Parameters
sampleTable

A reference to an opaque sample table object. If you pass NULL in this parameter, nothing happens.
Discussion

If the retain count decreases to zero, the sample table is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void QTSampleTableRelease (
   QTSampleTableRef    sampleTable );

/*MediaDisplayTimeToSampleNum

Finds the sample number for a specified display time.

void MediaDisplayTimeToSampleNum (
   Media          theMedia,
   TimeValue64    displayTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
displayTime

A 64-bit time value that represents the display time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a long integer that is to receive the sample number. The function returns the sample number that identifies the sample for the specified display time, or 0 if it is not found.
sampleDisplayTime

A pointer to a time value. The function updates this time value to indicate the display time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDisplayDuration

A pointer to a time value. The function updates this time value to indicate the display duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, invalidTime if sampleDisplayTime is out of the display time range, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void MediaDisplayTimeToSampleNum (
   Media          theMedia,
   TimeValue64    displayTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );

/*GetMediaAdvanceDecodeTime

Returns the advance decode time of a media.

TimeValue64 GetMediaAdvanceDecodeTime (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's advance decode time. A media's advance decode time is the absolute value of the greatest-magnitude negative display offset of its samples, or 0 if there are no samples with negative display offsets. This is the amount that the decode time axis must be adjusted ahead of the display time axis to ensure that no sample's adjusted decode time is later than its display time. For media without nonzero display offsets, the advance decode time is 0.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

TimeValue64 GetMediaAdvanceDecodeTime (
   Media    theMedia );

/*GetTrackDimensions

Determines a track's source rectangle.

void GetTrackDimensions (
   Track    theTrack,
   Fixed    *width,
   Fixed    *height );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
width

A pointer to a fixed-point number. The Movie Toolbox returns the width, in pixels, of the track's rectangle. This value corresponds to the x coordinate of the lower-right corner of the track's rectangle.
height

A pointer to a fixed-point number. The Movie Toolbox returns the height, in pixels, of the track's rectangle. This value corresponds to the y coordinate of the lower-right corner of the track's rectangle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackDimensions (
   Track    theTrack,
   Fixed    *width,
   Fixed    *height );

/*QTSampleTableGetDisplayOffset

Returns the offset from decode time to display time of a sample.

TimeValue64 QTSampleTableGetDisplayOffset (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A 64-bit time value that represents the offset from decode time to display time of the sample. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 QTSampleTableGetDisplayOffset (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );

/*QTSampleTableGetSampleDescriptionID

Returns the sample description ID of a sample.

QTSampleDescriptionID QTSampleTableGetSampleDescriptionID (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

The sample's sample description ID. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
QTSampleDescriptionID QTSampleTableGetSampleDescriptionID (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );

/*QTNewDataReferenceFromCFURL

Creates a URL data reference from a CFURL.

OSErr QTNewDataReferenceFromCFURL (
   CFURLRef    url,
   UInt32      flags,
   Handle      *outDataRef,
   OSType      *outDataRefType );
Parameters
url

A reference to a Core Foundation struct that represents the URL to which you want a URL data reference. These structs contain two parts: the string and a base URL, which may be empty. With a relative URL, the string alone does not fully specify the address; with an absolute URL it does.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See “Error Codes” in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

The new URL data reference returned can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Carbon status: Supported; C interface file: Movies.h*/
OSErr QTNewDataReferenceFromCFURL (
   CFURLRef    url,
   UInt32      flags,
   Handle      *outDataRef,
   OSType      *outDataRefType );

/*PutMovieIntoHandle

Creates a new movie resource.

OSErr PutMovieIntoHandle (
   Movie     theMovie,
   Handle    publicMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
publicMovie

The handle that is to receive the new movie resource. The function resizes the handle if necessary.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this handle to store a QuickTime movie in a specialized storage format.
Special Considerations

Note that you cannot use this new movie with other Movie Toolbox functions, except for NewMovieFromHandle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieIntoHandle (
   Movie     theMovie,
   Handle    publicMovie );


/*NewMovieFromHandle

Creates a movie in memory from a movie resource or a handle you obtained from PutMovieIntoHandle.

OSErr NewMovieFromHandle (
   Movie      *theMovie,
   Handle     h,
   short      newMovieFlags,
   Boolean    *dataRefWasChanged );
Parameters
theMovie

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
h

A handle to the movie resource from which the movie is to be loaded.
newMovieFlags

Flags (see below) that control the operation of NewMovieFromHandle. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
dataRefWasChanged

A pointer to a Boolean value. The toolbox sets the value to TRUE if any references were changed. Set the dataRefWasChanged parameter to NIL if you don't want to receive this information.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovieFromHandle. To change the graphics world for the new movie, your application should use SetMovieGWorld.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr NewMovieFromHandle (
   Movie      *theMovie,
   Handle     h,
   short      newMovieFlags,
   Boolean    *dataRefWasChanged );

/*DetachMovieFromCurrentThread

Detaches a movie from the current thread.

OSErr DetachMovieFromCurrentThread (Movie m);
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr DetachMovieFromCurrentThread (Movie m);


/*AttachMovieToCurrentThread

Attaches a movie to the current thread.

OSErr AttachMovieToCurrentThread (Movie m);
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr AttachMovieToCurrentThread (Movie m);

/*QTGetEffectSpeed

Returns the speed of the effect, expressed in frames per second.

OSErr QTGetEffectSpeed (
   QTAtomContainer    parameters,
   Fixed              *pFPS );
Parameters
parameters

Contains parameter values for the effect.
pFPS

The speed of the effect is returned in this parameter, expressed in frames per second. Effects can also return the pre-defined constant effectIsRealtime (see below) as their speed. See these constants: 
effectIsRealtime
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The value returned should not be treated as an absolute measurement of effect performance. In particular, most effects only return one value, regardless of parameter settings and hardware. This value is an estimate of execution speed on a reference hardware platform. Actual performance will vary depending on hardware, configuration and parameter options.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetEffectSpeed (
   QTAtomContainer    parameters,
   Fixed              *pFPS );


/*QTCountChildrenOfType

Returns the number of atoms of a given type in the child list of the specified parent atom.

short QTCountChildrenOfType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         childType );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
childType

The atom type for this operation. To retrieve the total number of atoms in the child list, set this parameter to 0. 
Return Value

The number of atoms of a given type in the child list of the specified parent atom.
Discussion

You can call this function to determine the number of atoms of a specified type in a parent atom's child list. If the total number of atoms in the parent atom's child list is 0, the parent atom is a leaf atom.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short QTCountChildrenOfType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         childType );

/*QTNextChildAnyType

Returns the next atom in the child list of the specified parent atom.

OSErr QTNextChildAnyType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtom             currentChild,
   QTAtom             *nextChild );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
currentChild

The last atom retrieved by this function. To retrieve the first atom in the child list, set the value of currentChild to 0.
nextChild

A pointer to an uninitialized QT atom data structure. On return, the data structure contains the offset of the next atom in the child list after the atom specified by currentChild, or 0 if the atom specified by currentChild was the last atom in the list.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to iterate through all the atoms in a parent atom's child list, regardless of their types and IDs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTNextChildAnyType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtom             currentChild,
   QTAtom             *nextChild );

/*QTGetAtomTypeAndID

Retrieves an atom's type and ID.

OSErr QTGetAtomTypeAndID (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomType         *atomType,
   QTAtomID           *id );
Parameters
container

The atom container that contains the atom.
atom

The atom whose type and ID should be retrieved.
atomType

A pointer to an atom type. On return, this parameter points to the type of the specified atom. You can pass NIL for this parameter if you don't need this information.
id

A pointer to an atom ID. On return, this parameter points to the ID of the specified atom. You can pass NIL for this parameter if you don't need this information.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetAtomTypeAndID (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomType         *atomType,
   QTAtomID           *id );

#ifdef __cplusplus
}
#endif
#endif