#ifndef QUICKDRAW_H
#include <QD/QD.h>
#endif
int InitCursor(){};



/*DisposeGWorld

Disposes of all the memory allocated for an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DisposeGWorld (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. In this parameter, pass the pointer returned to your application by the NewGWorld function when you created the offscreen graphics world. 
Discussion

The DisposeGWorld function disposes of all the memory allocated for the specified offscreen graphics world, including the pixel map, color table, pixel image, and GDevice structure (if one was created).

Call DisposeGWorld only when your application no longer needs the pixel image associated with this offscreen graphics world. If this offscreen graphics world was the current device, the current device is reset to the device stored in the global variable MainDevice. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void DisposeGWorld (GWorldPtr offscreenGWorld){
//TODO
};


/*SetRect

Assigns coordinates to a rectangle. 

void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom
);
Parameters
r

A pointer to the rectangle to set.
left

The horizontal coordinate of the new upper-left corner of the rectangle.
top

The vertical coordinate of the new upper-left corner of the rectangle.
right

The horizontal coordinate of the new lower-right corner of the rectangle.
bottom

The vertical coordinate of the new lower-right corner of the rectangle.
Discussion

The SetRect function assigns the coordinates you specify in the left, top, right, and bottom parameters to the rectangle that you specify in the r parameter. This function is provided to help you shorten your program text. If you want a more readable text, at the expense of source text length, you can instead assign integers (or points) directly into the fields of a Rect structure.

You can use a rectangle to specify locations and sizes for various graphics operations.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom){
//TODO
};


/*LockPixels

Prevents the base address for an offscreen pixel image from being moved while you draw into or copy from its pixel map. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Boolean LockPixels (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. To get a handle to an offscreen pixel map, use the GetGWorldPixMap function . 
Return Value

If the base address for an offscreen pixel image hasn’t been purged by the Memory Manager or is not purgeable, LockPixels returns TRUE as its function result, and your application can draw into or copy from the offscreen pixel map. However, if the base address for an offscreen pixel image has been purged, LockPixels returns FALSE to indicate that you can perform no drawing to or copying from the pixel map. At that point, your application should either call the UpdateGWorld function to reallocate the offscreen pixel image and then reconstruct it, or draw directly in a window instead of preparing the image in an offscreen graphics world. 
Discussion

You must call LockPixels before drawing to or copying from an offscreen graphics world. 

The baseAddr field of the PixMap structure for an offscreen graphics world contains a handle instead of a pointer (which is what the baseAddr field for an onscreen pixel map contains). The LockPixels function dereferences the PixMap handle into a pointer. When you use the UnlockPixels function the handle is recovered.

As soon as you are finished drawing into and copying from the offscreen pixel image, call the UnlockPixels function. 
Special Considerations

The LockPixels function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
Boolean LockPixels (
   PixMapHandle pm){
//TODO
};


/*GetGWorldPixMap

Obtains the pixel map created for an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PixMapHandle GetGWorldPixMap (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. Pass the pointer returned to your application by the NewGWorld function when you created the offscreen graphics world. 
Return Value

A handle to the pixel map created for an offscreen graphics world. Your application can, in turn, pass the handle returned by GetGWorldPixMap as a parameter to other QuickDraw functions that accept a handle to a pixel map.

On a system running only basic QuickDraw, the GetGWorldPixMap function returns the handle to a 1-bit pixel map that your application can supply as a parameter to the other functions related to offscreen graphics worlds. However, your application should not supply this handle to color QuickDraw functions.

Special Considerations

To ensure compatibility on systems running basic QuickDraw instead of Color QuickDraw, use GetGWorldPixMap whenever you need to gain access to the bitmap created for a graphics world—that is, do not dereference the GWorldPtr structure for that graphics world.
Version Notes

The GetGWorldPixMap function is not available in systems preceding System 7. You can make sure that the GetGWorldPixMap function is available by using the Gestalt function with the gestaltSystemVersion selector. Test the low-order word in the response parameter; if the value is $0700 or greater, then GetGWorldPixMap is available.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
PixMapHandle GetGWorldPixMap (
   GWorldPtr offscreenGWorld){
//TODO
};


/*GetGWorldDevice

Obtains a handle to the GDevice structure associated with an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetGWorldDevice (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. The pointer returned to your application by the NewGWorld function. 
Return Value

A handle to the GDevice structure associated with the offscreen graphics world specified by the offscreenGWorld parameter. 


If you created the offscreen world by specifying the noNewDevice flag, the GDevice structure is for one of the screen devices or is the GDevice structure that you specified to NewGWorld or UpdateGWorld.

If you point to a GrafPort or CGrafPort structure in the offscreenGWorld parameter, GetGWorldDevice returns the current device.

Special Considerations

The GetGWorldDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
GDHandle GetGWorldDevice (
   GWorldPtr offscreenGWorld){
//TODO
};


/*GetGWorld

Saves the current graphics port (basic, color, or offscreen) and the current GDevice structure. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetGWorld (
   CGrafPtr * port,
   GDHandle * gdh
);
Parameters
port

On return, a pointer to the current graphics port in the port parameter. This parameter can return values of type GrafPtr, CGrafPtr, or GWorldPtr, depending on whether the current graphics port is a basic graphics port, color graphics port, or offscreen graphics world. 
gdh

On return, a pointer to a handle to the GDevice structure for the current device. 
Discussion

After using GetGWorld to save a graphics port and a GDevice structure, use the SetGWorld function to restore them. 
Special Considerations

The GetGWorld function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void GetGWorld (
   CGrafPtr * port,
   GDHandle * gdh){
//TODO
};


/*SetGWorld

Changes the current graphics port (basic, color, or offscreen). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetGWorld (
   CGrafPtr port,
   GDHandle gdh
);
Parameters
port

A pointer to an offscreen graphics world, color graphics port, or basic graphics port. Specify values of type GrafPtr, CGrafPtr, or GWorldPtr, depending on whether you want to set the current graphics port to be a basic graphics port, color graphics port, or offscreen graphics world. Any drawing your application performs then occurs in this graphics port. 
gdh

A handle to a GDevice structure. If you pass a pointer to an offscreen graphics world in the port parameter, set this parameter to NULL, because SetGWorld ignores this parameter and sets the current device to the device attached to the offscreen graphics world. 
Discussion

The SetGWorld function sets the current graphics port to the one specified by the port parameter and—unless you set the current graphics port to be an offscreen graphics world—sets the current device to that specified by the gdh parameter. 
Special Considerations

The SetGWorld function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/

void SetGWorld (
   CGrafPtr port,
   GDHandle gdh){
//TODO
};


/*GetPortBounds

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect){
//TODO
};

/*EraseRect

Erases a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void EraseRect (
   const Rect * r
);
Parameters
r

The rectangle to erase.
Discussion

Using the patCopy pattern mode, the EraseRect function draws the interior of the rectangle that you specify in the r parameter with the background pattern for the current graphics port. This effectively erases the rectangle, making the shape blend into the background pattern of the graphics port. For example, use EraseRect to erase the port rectangle for a window before redrawing into the window.

This function leaves the location of the graphics pen unchanged. 
Special Considerations

The EraseRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void EraseRect (
   const Rect * r){
//TODO
};

/*CopyBits

Copies a portion of a bitmap or a pixel map from one graphics port or offscreen graphics world into another graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);
Parameters
srcBits

The source BitMap structure. 
dstBits

The destination BitMap structure.
srcRect

The source rectangle.
dstRect

The destination rectangle.
mode

One of the eight source modes in which the copy is to be performed. See Source, Pattern, and Arithmetic Transfer Mode Constants. The CopyBits function always dithers images when shrinking them between pixel maps on direct devices. 

When transferring pixels from a source pixel map to a destination pixel map, color QuickDraw interprets the source mode constants differently than basic QuickDraw does.

When you use CopyBits on a computer running color QuickDraw, you can also specify one of the transfer modes in the mode parameter.
maskRgn

A region to use as a clipping mask. You can pass a region handle to specify a mask region the resulting image is always clipped to this mask region and to the boundary rectangle of the destination bitmap. If the destination bitmap is the current graphics port’s bitmap, it is also clipped to the intersection of the graphics port’s clipping region and visible region. If you do not want to clip to a masking region, just pass NULL for this parameter. 
Discussion

The CopyBits function transfers any portion of a bitmap between two basic graphics ports, or any portion of a pixel map between two color graphics ports. Use CopyBits to move offscreen graphic images into an onscreen window, to blend colors for the image in a pixel map, and to shrink and expand images.

Specify a source bitmap in the srcBits parameter and a destination bitmap in the dstBits parameter. When copying images between color graphics ports, you must coerce each CGrafPort structure to a GrafPort structure, dereference the portBits fields of each, and then pass these “bitmaps” in the srcBits and dstBits parameters. If your application copies a pixel image from a color graphics port called MyColorPort, for example, you could specify (* GrafPtr(MyColorPort)).portBits in the srcBits parameter. In a CGrafPort structure, the high 2 bits of the portVersion field are set. This field, which shares the same position in a CGrafPort structure as the portBits.rowBytes field in a GrafPort structure, indicates to CopyBits that you have passed it a handle to a pixel map rather than a bitmap.

Using the srcRect and dstRect parameters, you can specify identically or differently sized source and destination rectangles; for differently sized rectangles, CopyBits scales the source image to fit the destination. If the bit image is a circle in a square source rectangle, and the destination rectangle is not square, the bit image appears as an oval in the destination. When you specify rectangles in the srcRect and dstRect parameters, use the local coordinate systems of, respectively, the source and destination graphics ports.

The CopyDeepMask function combines the functions of the CopyBits and CopyMask functions. 
Special Considerations

When you use the CopyBits function to transfer an image between pixel maps, the source and destination images may be of different pixel depths, of different sizes, and they may have different color tables. However, CopyBits assumes that the destination pixel map uses the same color table as the color table for the current GDevice structure. (This is because the Color Manager requires an inverse table for translating the color table from the source pixel map to the destination pixel map.) 

The CopyBits function applies the foreground and background colors of the current graphics port to the image in the destination pixel map (or bitmap), even if the source image is a bitmap. This causes the foreground color to replace all black pixels in the destination and the background color to replace all white pixels. To avoid unwanted coloring of the image, use the RGBForeColor function to set the foreground to black and use the RGBBackColor function to set the background to white before calling CopyBits.

The source bitmap or pixel map must not occupy more memory than half the available stack space. The stack space required by CopyBits is roughly five times the value of the rowBytes field of the source pixel map: one rowBytes value for the pixel map (or bitmap), an additional rowBytes value for dithering, another rowBytes value when stretching or shrinking the source pixel map into the destination, another rowBytes value for any color map changing, and a fifth additional rowBytes value for any color aliasing. If there is insufficient memory to complete a CopyBits operation in Color QuickDraw, the QDError function returns the result code –143.

If you use CopyBits to copy between two graphics ports that overlap, you must first use the LocalToGlobal function to convert to global coordinates, and then specify the global variable screenBits for both the srcBits and dstBits parameters.

The CopyBits function may move or purge memory blocks in the application heap; do not call this function at interrupt time.

If you are reading directly from a NuBus video card with a base address of Fs00000 and there is not a card in the slot (s–1) below it, CopyBits reads addresses less than the base address of the pixel map. This causes a bus error. To work around the problem, remap the baseAddr field of the pixel map in your video card to at least 20 bytes above the NuBus boundary; an address link of Fs000020 precludes the problem.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn){
//TODO
};


/*QDFlushPortBuffer

Calls the Quartz compositor to flush all new drawing in a Carbon window to the display. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region
);
Parameters
port

A window port. If the port has no back buffer, or if the port is an offscreen or printing port, this function does nothing.
region

An update region. Under normal conditions, you should pass NULL to avoid the overhead of additional region operations.
Discussion

In Mac OS X, drawing in a window port updates a back buffer associated with the window. Updates to this buffer are accumulated in a list called the dirty region. 

The back buffer is automatically flushed to the display each time through the event loop. When the event loop does not get control soon enough—for example, during an animation sequence—you can call this function to flush the port buffer to the device immediately. 

When you call this function, there are several different execution paths:
If the region parameter is NULL, the dirty region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the dirty region is set to empty.
If the region parameter specifies an update region, the intersection of the dirty region and the update region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the flushed region is subtracted from the dirty region.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region){
//TODO
};

/*UnlockPixels

Allows the Memory Manager to move the base address for the offscreen pixel map that you specify in the pm parameter. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void UnlockPixels (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. Pass the same handle that you passed previously to the LockPixels function. 
Discussion

To ensure the integrity of the data in a pixel image, call LockPixels before drawing into or copying from a pixel map; then, to prevent heap fragmentation, call UnlockPixels as soon as your application finishes drawing to and copying from the offscreen pixel map. 

The baseAddr field of the PixMap structure for an offscreen graphics world contains a handle instead of a pointer (which is what the baseAddr field for an onscreen pixel map contains). The LockPixels function dereferences the PixMap handle into a pointer. When you use the UnlockPixels function, the handle is recovered.

You don’t need to call UnlockPixels if LockPixels returns FALSE, because LockPixels doesn’t lock the memory for a pixel image if that memory has been purged. However, calling UnlockPixels on purged memory does no harm. 
Special Considerations

The UnlockPixels function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void UnlockPixels (
   PixMapHandle pm){
//TODO
};

/*SetPort

Changes the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPort (
   GrafPtr port
);
Parameters
port

A pointer to a GrafPort structure. Typically, you pass a pointer to a GrafPort structure that you previously saved with the GetPort function. The SetPort function sets this structure to be the current graphics port. 
Discussion

All QuickDraw drawing functions affect the bitmap of, and use the local coordinate system of, the current graphics port. Each graphics port has its own graphics pen and text characteristics, which remain unchanged when the graphics port isn’t selected as the current graphics port.

When your application runs in Color QuickDraw or uses offscreen graphics worlds, it should use the SetGWorld function instead of SetPort. The SetGWorld function restores the current graphics port for basic and color graphics ports as well as offscreen graphics worlds. 
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void SetPort (
   GrafPtr port){
//TODO
};

/*GetPixBaseAddr

Obtains a pointer to an offscreen pixel map. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Ptr GetPixBaseAddr (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. To get a handle to an offscreen pixel map, use the GetGWorldPixMap function. 
Return Value

A 32-bit pointer to the beginning of a pixel image. If the offscreen buffer has been purged, GetPixBaseAddr returns NULL. 
Discussion

The baseAddr field of the PixMap structure for an offscreen graphics world contains a handle instead of a pointer, which is what the baseAddr field for an onscreen pixel map contains. You must use the GetPixBaseAddr function to obtain a pointer to the PixMap structure for an offscreen graphics world.

Your application should never directly access the baseAddr field of the PixMap structure for an offscreen graphics world; instead, always use GetPixBaseAddr. If your application is using 24-bit mode, use the PixMap32Bit function to determine whether a pixel map requires 32-bit addressing mode for access to its pixel image. 
Special Considerations

Any QuickDraw functions that your application uses after calling GetPixBaseAddr may change the base address for the offscreen pixel image.

The GetPixBaseAddr function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
Ptr GetPixBaseAddr (
   PixMapHandle pm
){};

/*GetPort

Saves the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetPort (
   GrafPtr * port
);
Parameters
port

On return, a pointer to a GrafPort structure for the current graphics port. If the current graphics port is a color graphics port, GetPort coerces its CGrafPort structure into a GrafPort structure. 
Discussion

When your application runs in Color QuickDraw or uses offscreen graphics worlds, it should use the GetGWorld function instead of GetPort. The GetGWorld function saves the current graphics port for basic and color graphics ports as well as offscreen graphics worlds. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetPort (
   GrafPtr * port
){};


/*GlobalToLocal

Converts the coordinates of a point from global coordinates to the local coordinates of the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GlobalToLocal (
   Point * pt
);
Parameters
pt

A pointer to a point expressed in global coordinates (where the upper-left corner of the main screen has coordinates [0,0]). On return, this point is converted to local coordinates.
Discussion

The GlobalToLocal procedure takes a point expressed in global coordinates (where the upper-left corner of the main screen has coordinates [0,0]) and converts it into the local coordinates of the current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GlobalToLocal (
   Point * pt
){};


/*GetPenState

Determines the graphics pen’s location, size, pattern, and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetPenState (
   PenState * pnState
);
Parameters
pnState

On return, a pointer to a PenState structure holding information about the graphics pen. The GetPenState function saves the location, size, pattern, and pattern mode of the graphics pen for the current graphics port in this structure. 
Discussion

After changing the graphics pen as necessary, restore these pen states with the SetPenState function. 

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetPenState (
   PenState * pnState
){};

/*PenSize

Sets the dimensions of the graphics pen in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PenSize (
   short width,
   short height
);
Parameters
width

The pen width, as an integer from 0 to 32,767. If you set the value to 0, the pen does not draw. Values less than 0 are undefined.
height

The pen height, as an integer from 0 to 32,767. If you set the value to 0, the pen does not draw. Values less than 0 are undefined.
Discussion

The PenSize function sets the width that you specify in the width parameter and the height that you specify in the height parameter for the graphics pen in the current graphics port. All subsequent calls to the Line and LineTo functions and to the functions that draw framed shapes in the current graphics port use the new pen dimensions.

You can get the current pen dimensions from the pnSize field of the current graphics port, where the width and height are stored as a Point structure.

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PenSize (
   short width,
   short height
){};


/*PenPat

Sets the bit pattern to be used by the graphics pen in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PenPat (
   const Pattern * pat
);
Parameters
pat

A bit pattern, as defined by a Pattern structure. 
Discussion

The PenPat function sets the graphics pen to use the bit pattern defined in the Pattern structure that you specify in the pat parameter. (The standard patterns white, black, gray, ltGray, and dkGray are predefined; the initial bit pattern for the pen is black.) This pattern is stored in the pnPat field of a GrafPort structure. The QuickDraw painting functions (such as PaintRect) also use the pen’s pattern when drawing a shape.

The PenPat function also sets a bit pattern for the graphics pen in a color graphics port. The PenPat function creates a handle, of type PixPatHandle, for the bit pattern and stores this handle in the pnPixPat field of the CGrafPort structure. This pattern always uses the graphics port’s current foreground and background colors.

To define your own patterns, you typically create pattern, ‘PAT’, or pattern list, ‘PAT#’, resources. 
Special Considerations

The PenPat function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PenPat (
   const Pattern * pat
){};


/*SetPenState

Restores the state of the graphics pen that was saved with the GetPenState function. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPenState (
   const PenState * pnState
);
Parameters
pnState

A PenState structure previously created with the GetPenState function. The SetPenState function sets the graphics pen’s location, size, pattern, and pattern mode in the current graphics port to the values stored in this structure. 
Discussion

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPenState (
   const PenState * pnState
){};


/*PtInRect

Determines whether a pixel below is enclosed in a rectangle. 

Boolean PtInRect (
   Point pt,
   const Rect * r
);
Parameters
pt

The point to test.
r

The rectangle to test.
Return Value

TRUE if the pixel below and to the right of the point specified in the pt parameter is enclosed in the rectangle specified in the r parameter. FALSE if it is not. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

Boolean PtInRect (
   Point pt,
   const Rect * r
){};


/*GetQDGlobalsGray

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Pattern * GetQDGlobalsGray (
   Pattern * gray
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Pattern * GetQDGlobalsGray (
   Pattern * gray
){};



/*FrameRect

Draws an outline inside a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FrameRect (
   const Rect * r
);
Parameters
r

The rectangle to frame.
Discussion

Using the pattern, pattern mode, and size of the graphics pen for the current graphics port, the FrameRect function draws an outline just inside the rectangle that you specify in the r parameter. The outline is as wide as the pen width and as tall as the pen height. The pen location does not change.

If a region is open and being formed, the outside outline of the new rectangle is mathematically added to the region’s boundary. 
Special Considerations

The FrameRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void FrameRect (
   const Rect * r
){};

/*PaintRect

Paints a rectangle with the graphics pen’s pattern and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PaintRect (
   const Rect * r
);
Parameters
r

The rectangle to paint.
Discussion

The PaintRect function draws the interior of the rectangle that you specify in the r parameter with the pen pattern for the current graphics port, according to the pattern mode for the current graphics port. The pen location does not change.

Use the FillRect to draw the interior of a rectangle with a pen pattern different from that for the current graphics port. 
Special Considerations

The PaintRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PaintRect (
   const Rect * r
){};




/*RGBForeColor

Changes the color of the “ink” used for framing and painting. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void RGBForeColor (
   const RGBColor * color
);
Parameters
color

An RGBColor structure. 
Discussion

If the current port is defined by a CGrafPort structure, QuickDraw supplies its rgbFgColor field with the RGB value that you specify in the color parameter, and places the pixel value most closely matching that color in the fgColor field. For indexed devices, the pixel value is an index to the current device’s CLUT. For direct devices, the value is the 16-bit or 32-bit equivalent to the RGB value.

If the current port is defined by a GrafPort structure, basic QuickDraw supplies its fgColor field with a color value determined by taking the high bit of each of the red, green, and blue components of the color that you supply in the color parameter. Basic QuickDraw uses that 3-bit number to select a color from its eight-color system. 

You can also use Palette Manager functions to set the foreground color.

To determine the current foreground color, use the GetForeColor function.

QuickDraw ignores the foreground and background colors when your application draws with a pixel pattern. Assign a pixel pattern to the foreground pattern used by the graphics pen; by using the BackPixPat function to assign a pixel pattern as the background pattern for the current color graphics port; and by using the FillCRect, FillCOval, FillCRoundRect, FillCArc, FillCRgn, and FillCPoly functions to fill shapes with a pixel pattern. 
Special Considerations

The RGBForeColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

The RGBForeColor function is available for basic QuickDraw only in System 7. To set the foreground color for basic graphics ports on older versions of system software, use the ForeColor function.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void RGBForeColor (
   const RGBColor * color
){};


/*NewRgn

Begins creating a new region. (Deprecated in Mac OS X v10.4.)

RgnHandle NewRgn ();
Return Value

A handle to the new region. 
Discussion

The NewRgn function allocates space for a new, variable-size region and initializes it to the empty region defined by the rectangle (0,0,0,0). This is the only function that creates a new region; other functions merely alter the size or shape of existing regions.

To begin defining a region, use the OpenRgn function.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

The NewRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.

Use the Memory Manager function MaxMem to determine whether the memory for the region is valid before using NewRgn.

Ensure that the memory for a region is valid before calling this function to manipulate that region if there isn’t sufficient memory, the system may crash. Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in color QuickDraw. Before defining a region, you can use the Memory Manager function MaxMem to determine whether the memory for the region is valid. You can determine the current size of an existing region by calling the Memory Manager function GetHandleSize. When you record drawing operations in an open region, the resulting region description may overflow the 32 KB or 64 KB limit. Should this happen in color QuickDraw, the QDError function returns the result code regionTooBigError.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
RgnHandle NewRgn (){};


/*OpenRgn

Begins defining a region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void OpenRgn ();
Discussion

The OpenRgn function allocates temporary memory to start saving lines and framed shapes for processing as a region definition. Call OpenRgn only after initializing a region with the NewRgn function.

The NewRgn function stores the definition for a region in a Region structure.

While a region is open, all calls to Line, LineTo, and the functions that draw framed shapes (except arcs) affect the outline of the region. Only the line endpoints and shape boundaries affect the region definition—the pattern mode, pattern, and size do not affect it.

When you are finished defining the region, call the CloseRgn function.

The OpenRgn function calls HidePen, so no drawing occurs on the screen while the region is open (unless you call ShowPen just after OpenRgn, or you called ShowPen previously without balancing it by a call to HidePen). Since the pen hangs below and to the right of the pen location, drawing lines with even the smallest pen changes pixels that lie outside the region you define.

The outline of a region is mathematically defined and infinitely thin, and it separates the bit or pixel image into two groups of pixels: those within the region and those outside it. 

A region should consist of one or more closed loops. Each framed shape itself constitutes a loop. Any lines drawn with the Line or LineTo function should connect with each other or with a framed shape. Even if the onscreen presentation of a region is clipped, the definition of a region is not; you can define a region anywhere on the coordinate plane with complete disregard for the location of various graphics port entities on that plane.

When a region is open, the current graphics port’s rgnSave field contains a handle to information related to the region definition. If you want to temporarily disable the collection of lines and shapes, you can save the current value of this field, set the field to NULL, and later restore the saved value to resume the region definition. Also, calling SetPort while a region is being formed discontinues formation of the region until another call to SetPort resets the region’s original graphics port.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in Color QuickDraw. You can determine the current size of an existing region by calling the Memory Manager function GetHandleSize. When you structure drawing operations in an open region, the resulting region description may overflow the 32 KB or 64 KB limit. Should this happen in Color QuickDraw, the QDError function returns the result code regionTooBigError. 

Do not call OpenRgn while another region or a polygon is already open. When you are finished constructing the region, use the CloseRgn function, which is described next.

The OpenRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void OpenRgn (){};


/*MoveTo

Moves the graphics pen to a particular location in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void MoveTo (
   short h,
   short v
);
Parameters
h

The horizontal coordinate of the graphics pen’s new position.
v

The vertical coordinate of the graphics pen’s new position.
Discussion

The MoveTo function changes the graphics pen’s current location to the new horizontal coordinate you specify in the h parameter and the new vertical coordinate you specify in the v parameter. Specify the new location in the local coordinates of the current graphics port. The MoveTo function performs no drawing. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void MoveTo (
   short h,
   short v
){};
/*LineTo

Draws a line from the graphics pen’s current location to a new location. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void LineTo (
   short h,
   short v
);
Parameters
h

The horizontal coordinate of the graphics pen’s new location.
v

The vertical coordinate of the graphics pen’s new location.
Discussion

The LineTo function draws a line from the graphics pen’s current location in the current graphics port to the new location (h,v), which you specify in the local coordinates of the current graphics port. If you are using LineTo to draw a region or polygon, its outline is infinitely thin and is not affected by the values of the pnSize, pnMode, or pnPat field of the graphics port. 
Special Considerations

The LineTo function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/


void LineTo (
   short h,
   short v
){};


/*CloseRgn

Organizes a collection of lines and shapes into a region definition. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CloseRgn (
   RgnHandle dstRgn
);
Parameters
dstRgn

The handle to the region to close. This handle should be a region handle returned by the NewRgn function. 
Discussion

The CloseRgn function stops the collection of lines and framed shapes, organizes them into a region definition, and saves the result in the region whose handle you pass in the dstRgn parameter. 

The CloseRgn function does not create the destination region; you must have already allocated space for it by using the OpenRgn function. The CloseRgn function calls the ShowPen function, balancing the call to the HidePen function made by OpenRgn. 

When you no longer need the memory occupied by the region, use the DisposeRgn function.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in Color QuickDraw. When you structure drawing operations in an open region, the resulting region description may overflow this limit. Should this happen in Color QuickDraw, the QDError function returns the result code regionTooBigError. Since the resulting region is potentially corrupt, the CloseRgn function returns an empty region if it detects QDError has returned regionTooBigError.

The CloseRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void CloseRgn (
   RgnHandle dstRgn
){};

/*DisposeRgn

Releases the memory occupied by a region. (Deprecated in Mac OS X v10.4.)

void DisposeRgn (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to dispose. This handle should be a region handle returned by the NewRgn function. 
Discussion

Use DisposeRgn only after you are completely through with a region. 
Special Considerations

The DisposeRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void DisposeRgn (
   RgnHandle rgn
){};

/*InsetRect

Shrinks or expands a rectangle. 

void InsetRect (
   Rect * r,
   short dh,
   short dv
);
Parameters
r

A pointer to the rectangle to alter.
dh

The horizontal distance to move the left and right sides in toward or outward from the center of the rectangle.
dv

The vertical distance to move the top and bottom sides in toward or outward from the center of the rectangle.
Discussion

The InsetRect function shrinks or expands the rectangle that you specify in the r parameter: the left and right sides are moved in by the amount you specify in the dh parameter; the top and bottom are moved toward the center by the amount you specify in the dv parameter. If the value you pass in dh or dv is negative, the appropriate pair of sides is moved outward instead of inward. The effect is to alter the size by 2*dh horizontally and 2*dv vertically, with the rectangle remaining centered in the same place on the coordinate plane.

If the resulting width or height becomes less than 1, the rectangle is set to the empty rectangle (0,0,0,0).

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

void InsetRect (
   Rect * r,
   short dh,
   short dv
){};


















