#import <Foundation/NSString.h>

/*Constants

The following constants specify the movie attributes that you can get and set using the movieAttributes and setMovieAttributes methods. To get or set a single attribute, use attributeForKey or setAttribute.
Constant	
Description
QTMovieActiveSegmentAttribute	
The active segment of a QTMovie object; the value for this key is of type NSValue, interpreted as a QTTimeRange structure. 

Available in Mac OS X v10.3 and later.
QTMovieAutoAlternatesAttribute	
The auto-alternate state of a QTMovie object. The value for this key is of type NSNumber, interpreted as a BOOL. 

Available in Mac OS X v10.3 and later.
QTMovieCopyrightAttribute	
The copyright string of a QTMovie object; the value for this key is of type NSString. 

Available in Mac OS X v10.3 and later.
QTMovieCreationTimeAttribute	
The creation time of a QTMovie object; the value for this key is of type NSDate.

Available in Mac OS X v10.3 and later.
QTMovieCurrentSizeAttribute	
The current size of a QTMovie object; the value for this key is of type NSValue, interpreted as an NSSize structure.

Available in Mac OS X v10.3 and later.
QTMovieCurrentTimeAttribute	
The current time of a QTMovie object; the value for this key is of type NSValue, interpreted as a QTTime structure. 

Available in Mac OS X v10.3 and later.
QTMovieDataSizeAttribute	
The data size of a QTMovie. The value for this key is of type NSNumber, which is interpreted as a long long.

Available in Mac OS X v10.3 and later.
QTMovieDelegateAttribute	
The delegate for a QTMovie object. The value for this key is of type NSObject. 

Available in Mac OS X v10.3 and later.
QTMovieDisplayNameAttribute	
The display name of a QTMovie object. A display name is stored as user data in a movie file and hence may differ from the base name of the movie’s filename or URL. The value for this key is of type NSString.

Available in Mac OS X v10.3 and later.
QTMovieDontInteractWithUserAttribute	
When set in a dictionary passed to movieWithAttributes or initWithAttributes, this prevents QuickTime from interacting with the user during movie initialization. The value for this key is of type NSNumber, interpreted as a BOOL. 

Available in Mac OS X v10.3 and later.
QTMovieDurationAttribute	
The duration of a QTMovie object; the value for this key is of type NSValue, interpreted as a QTTime structure.

Available in Mac OS X v10.3 and later.
QTMovieEditableAttribute	
The editable setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie can be edited.

Available in Mac OS X v10.3 and later.
QTMovieFileNameAttribute	
The file name string of a QTMovie object; the value for this key is of type NSString.

Available in Mac OS X v10.3 and later.
QTMovieHasAudioAttribute	
The audio data setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie contains audio data.

Available in Mac OS X v10.3 and later.
QTMovieHasDurationAttribute	
The duration setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie has a duration. (Some types of movies, for instance QuickTime VR movies, have no duration.)

Available in Mac OS X v10.3 and later.
QTMovieHasVideoAttribute	
The video data setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie contains video data.

Available in Mac OS X v10.3 and later.
QTMovieIsActiveAttribute	
The active setting; the value for this key is of type NSNumber, interpreted as a BOOL. 

Available in Mac OS X v10.3 and later.
QTMovieIsInteractiveAttribute	
The interactive setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie is interactive.

Available in Mac OS X v10.3 and later.
QTMovieIsLinearAttribute	
The linear setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie is linear, as opposed to a non-linear QuickTime VR movie. 

Available in Mac OS X v10.3 and later.
QTMovieIsSteppableAttribute	
The steppable setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie can step from frame to frame.

Available in Mac OS X v10.3 and later.
QTMovieLoadStateAttribute	
The load state value; the value for this key is of type NSNumber, interpreted as a long.

Available in Mac OS X v10.3 and later.
QTMovieLoopsAttribute	
The looping setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie is set to loop.

Available in Mac OS X v10.3 and later.
QTMovieLoopsBackAndForthAttribute	
The palindrome looping setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie is set to loop back and forth. Note that QTMovieLoopsAttribute and QTMovieLoopsBackAndForthAttribute are independent and indeed exclusive. QTMovieLoopsAttribute is used to get and set the state of normal looping; QTMovieLoopsBackAndForthAttribute is used to get and set the state of palindrome looping. 

Available in Mac OS X v10.3 and later.
QTMovieModificationTimeAttribute	
The modification time of a QTMovie object; the value for this key is of type NSDate.

Available in Mac OS X v10.3 and later.
QTMovieMutedAttribute	
The mute setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie volume is muted.

Available in Mac OS X v10.3 and later.
QTMovieNaturalSizeAttribute	
The natural size of a QTMovie object; the value for this key is of type NSValue, interpreted as an NSSize structure.

Available in Mac OS X v10.3 and later.
QTMoviePlaysAllFramesAttribute	
The play-all-frames setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie will play all frames.

Available in Mac OS X v10.3 and later.
QTMoviePlaysSelectionOnlyAttribute	
The play-selection setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie will play only the current selection.

Available in Mac OS X v10.3 and later.
QTMoviePosterTimeAttribute	
The movie poster time of a QTMovie object; the value for this key is of type NSValue, interpreted as a QTTime structure.

Available in Mac OS X v10.3 and later.
QTMoviePreferredMutedAttribute	
The preferred mute setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie preferred mute setting is muted.

Available in Mac OS X v10.3 and later.
QTMoviePreferredRateAttribute	
The preferred rate; the value for this key is of type NSNumber, interpreted as a float.

Available in Mac OS X v10.3 and later.
QTMoviePreferredVolumeAttribute	
The preferred volume; the value for this key is of type NSNumber, interpreted as a float.

Available in Mac OS X v10.3 and later.
QTMoviePreviewModeAttribute	
The preview mode setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie is in preview mode.

Available in Mac OS X v10.3 and later.
QTMoviePreviewRangeAttribute	
The preview range of a QTMovie object; the value for this key is of type NSValue, interpreted as a QTTimeRange structure.

Available in Mac OS X v10.3 and later.
QTMovieRateAttribute	
The movie rate; the value for this key is of type NSNumber, interpreted as a float.

Available in Mac OS X v10.3 and later.
QTMovieRateChangesPreservePitchAttribute	
When the playback rate is not unity, audio must be resampled in order to play at the new rate. The default resampling affects the pitch of the audio (for example, playing at 2x speed raises the pitch by an octave, 1/2x lowers an octave). If this property is set on the Movie, an alternative algorithm is used, which alters the speed without changing the pitch. As this is more computationally expensive, this property may be silently ignored on some slow CPUs.

Available in Mac OS X v10.3 and later.
QTMovieSelectionAttribute	
The selection range of a QTMovie object; the value for this key is of type NSValue, interpreted as a QTTimeRange structure.

Available in Mac OS X v10.3 and later.
QTMovieTimeScaleAttribute	
The movie time scale; the value for this key is of type NSNumber, interpreted as a long.

Available in Mac OS X v10.3 and later.
QTMovieURLAttribute	
The URL of a QTMovie object; the value for this key is of type NSURL.

Available in Mac OS X v10.3 and later.
QTMovieVolumeAttribute	
The movie volume; the value for this key is of type NSNumber, interpreted as a float.

Available in Mac OS X v10.3 and later.


The following constants specify items in dictionaries passed to QTMovie notifications and delegate methods. 
Constant	
Description
QTMovieMessageNotificationParameter	
Used as a key in the userInfo dictionary passed to the QTMovieMessageNotification notification to indicate the message. The associated value is an NSString.

Available in Mac OS X v10.3 and later.
QTMovieRateDidChangeNotificationParameter	
Used as a key in the userInfo dictionary passed to the QTMovieRateDidChangeNotification notification to indicate the new playback rate. The associated value is an NSNumber that holds a float.

Available in Mac OS X v10.3 and later.
QTMovieStatusFlagsNotificationParameter	
Used as a key in the userInfo dictionary passed to the QTMovieStatusStringPostedNotification notification to indicate status flags. The associated value is an NSNumber that holds a long.

Available in Mac OS X v10.3 and later.
QTMovieStatusCodeNotificationParameter	
Used as a key in the userInfo dictionary passed to the QTMovieStatusStringPostedNotification notification to indicate a status code (or error code). The associated value is an NSNumber that holds an int.

Available in Mac OS X v10.3 and later.
QTMovieStatusStringNotificationParameter	
Used as a key in the userInfo dictionary passed to the QTMovieStatusStringPostedNotification notification to indicate a status string.

Available in Mac OS X v10.3 and later.
QTMovieTargetIDNotificationParameter	
Used as a key in the dictionary passed to the externalMovie: delegate method to indicate that the delegate should return a QTMovie object that has the movie ID specified by the key’s value.

Available in Mac OS X v10.3 and later.
QTMovieTargetNameNotificationParameter	
Used as a key in the dictionary passed to the externalMovie: delegate method to indicate that the delegate should return a QTMovie object that has the movie name specified by the key’s value.

Available in Mac OS X v10.3 and later.


The following constants are dictionary keys that you can use to specify movie attributes, using the writeToFile method.
Constant	
Description
QTMovieExport	
The movie export setting; the value for this key is of type NSNumber, interpreted as a BOOL. 

Available in Mac OS X v10.3 and later.
QTMovieExportType	
The movie export type; the value for this key is of type NSNumber, interpreted as a long.

Available in Mac OS X v10.3 and later.
QTMovieFlatten	
The movie flatten setting; the value for this key is of type NSNumber, interpreted as a BOOL. 

Available in Mac OS X v10.3 and later.
QTMovieExportSettings	
Information to come.

Available in Mac OS X v10.3 and later.
QTMovieExportManufacturer	
The export manufacturer value; the value for this key is of type NSNumber, interpreted as a long.

Available in Mac OS X v10.3 and later.


The following constants are dictionary keys that you can use to specify movie attributes, using the addImage method.
Constant	
Description
QTAddImageCodecType	
The image codec string; the value for this key is of type NSString.

Available in Mac OS X v10.3 and later.
QTAddImageCodecQuality	
The image codec value; the value for this key is of type NSNumber.

Available in Mac OS X v10.3 and later.


The following constants are data locators that you can use to specify movie attributes, using the movieWithAttributes and initWithAttributes methods.
Constant	
Description
QTMovieDataReferenceAttribute	
The data reference of a QTMovie object. 

Available in Mac OS X v10.3 and later.
QTMoviePasteboardAttribute	
The pasteboard setting of a QTMovie object.

Available in Mac OS X v10.3 and later.
QTMovieDataAttribute	
The data of a QTMovie object.

Available in Mac OS X v10.3 and later.


The following constants are movie instantiation options that you can use to specify movie attributes, using the movieWithAttributes and initWithAttributes methods.
Constant	
Description
QTMovieFileOffsetAttribute	
The file offset value; the value for this key is of type NSNumber, interpreted as a long long.

Available in Mac OS X v10.3 and later.
QTMovieResolveDataRefAttribute	
The resolved data reference setting; the value for this key is of type NSNumber, interpreted as a BOOL. 
QTMovieAskUnresolvedDataRefAttribute	
The unresolved data reference setting; the value for this key is of type NSNumber, interpreted as a BOOL. 
QTMovieOpenAsyncOKAttribute	
The open async setting; the value for this key is of type NSNumber, interpreted as a BOOL. 

Available in Mac OS X v10.3 and later.*/
NSString *QTMovieActiveSegmentAttribute =1 ;	
NSString *QTMovieAutoAlternatesAttribute=1;
NSString *QTMovieCopyrightAttribute =1	;
 NSString *QTMovieCreationTimeAttribute=1;	
 NSString *QTMovieCurrentSizeAttribute	=1;
 NSString *QTMovieCurrentTimeAttribute=1;	
 NSString *QTMovieDataSizeAttribute	=1;
 NSString *QTMovieDelegateAttribute	=1;
 NSString *QTMovieDisplayNameAttribute	=1;
 NSString *QTMovieDontInteractWithUserAttribute=1	;
 NSString *QTMovieDurationAttribute	=1;
 NSString *QTMovieEditableAttribute=1	;
 NSString *QTMovieFileNameAttribute	=1;
 NSString *QTMovieHasAudioAttribute	=1;
 NSString *QTMovieHasDurationAttribute=1;	
 NSString *QTMovieHasVideoAttribute	=1;
 NSString *QTMovieIsActiveAttribute	=1;
 NSString *QTMovieIsInteractiveAttribute	=1;
 NSString *QTMovieIsLinearAttribute	=1;
 NSString *QTMovieIsSteppableAttribute	=1;
 NSString *QTMovieLoadStateAttribute=1	;
 NSString *QTMovieLoopsAttribute=1	;
 NSString *QTMovieLoopsBackAndForthAttribute=1	;
 NSString *QTMovieModificationTimeAttribute	=1;
 NSString *QTMovieMutedAttribute=1	;
 NSString *QTMovieNaturalSizeAttribute=1	;
 NSString *QTMoviePlaysAllFramesAttribute=1	;
 NSString *QTMoviePlaysSelectionOnlyAttribute	=1;
 NSString *QTMoviePosterTimeAttribute=1	;
 NSString *QTMoviePreferredMutedAttribute	=1;
 NSString *QTMoviePreferredRateAttribute=1	;
 NSString *QTMoviePreferredVolumeAttribute	=1;
 NSString *QTMoviePreviewModeAttribute	=1;
 NSString *QTMoviePreviewRangeAttribute	=1;
 NSString *QTMovieRateAttribute=1	;
 NSString *QTMovieRateChangesPreservePitchAttribute	=1;
 NSString *QTMovieSelectionAttribute	=1;
 NSString *QTMovieTimeScaleAttribute	=1;
 NSString *QTMovieURLAttribute	=1;
 NSString *QTMovieVolumeAttribute	=1;
 NSString *QTMovieRateDidChangeNotificationParameter	=1;
 NSString *QTMovieStatusFlagsNotificationParameter=1	;
 NSString *QTMovieStatusCodeNotificationParameter	=1;
 NSString *QTMovieStatusStringNotificationParameter	=1;
 NSString *QTMovieTargetIDNotificationParameter	=1;
 NSString *QTMovieTargetNameNotificationParameter=1	;
 NSString *QTMovieExport	=1;
 NSString *QTMovieExportType	=1;
 NSString *QTMovieFlatten	=1;
 NSString *QTMovieExportSettings=1	;
 NSString *QTMovieExportManufacturer=1	;
 NSString *QTAddImageCodecType	=1;
 NSString *QTAddImageCodecQuality	=1;
 NSString *QTMovieDataReferenceAttribute=1	;
 NSString *QTMoviePasteboardAttribute	=1;
 NSString *QTMovieDataAttribute	=1;
 NSString *QTMovieFileOffsetAttribute=1	;
 NSString *QTMovieResolveDataRefAttribute=1	;
 NSString *QTMovieAskUnresolvedDataRefAttribute	=1;
 NSString *QTMovieOpenAsyncOKAttribute	=1;


/*Constants

The following constants specify the media attributes that you can get and set using the mediaAttributes and setMediaAttributes methods. To get or set a single attribute, use attributeForKey: or setAttribute:.

Note: The QTMediaTypeAttribute attribute indicates the type of media data contained in a QTMedia object. These constants are used to indicate media types, as shown in the portion of the table beginning with the QTMediaTypeVideo constant. 

Constant	
Description
QTMediaCreationTimeAttribute	
The creation time of a QTMedia object; the value for this key is of type NSDate.

Available in Mac OS X v10.3 and later.
QTMediaDurationAttribute	
The duration of a QTMedia object; the value for this key is of type NSValue, interpreted as a QTTime.

Available in Mac OS X v10.3 and later.
QTMediaModificationTimeAttribute	
The modification time of a QTMedia object; the value for this key is of type NSDate.

Available in Mac OS X v10.3 and later.
QTMediaSampleCountAttribute	
The media sample count; the value for this key is of type NSNumber, interpreted as a long.

Available in Mac OS X v10.3 and later.
QTMediaQualityAttribute	
The media quality; the value for this key is of type NSNumber, interpreted as a short.

Available in Mac OS X v10.3 and later.
QTMediaTimeScaleAttribute	
The media time scale; the value for this key is of type NSNumber, interpreted as a long.

Available in Mac OS X v10.3 and later.
QTMediaTypeAttribute	
The media type; the value for this key is of type NSString; see below for the values this attribute can return.

Available in Mac OS X v10.3 and later.
QTMediaTypeVideo	
Video media.

Available in Mac OS X v10.3 and later.
QTMediaTypeSound	
Sound media.

Available in Mac OS X v10.3 and later.
QTMediaTypeText	
Text media.

Available in Mac OS X v10.3 and later.
QTMediaTypeBase	
Base media.

Available in Mac OS X v10.3 and later.
QTMediaTypeMPEG	
MPEG media

Available in Mac OS X v10.3 and later.
QTMediaTypeMusic	
Music media

Available in Mac OS X v10.3 and later.
QTMediaTypeTimeCode	
Timecode media.

Available in Mac OS X v10.3 and later.
QTMediaTypeSprite	
Sprite media.

Available in Mac OS X v10.3 and later.
QTMediaTypeFlash	
Flash media.

Available in Mac OS X v10.3 and later.
QTMediaTypeMovie	
Movie media.

Available in Mac OS X v10.3 and later.
QTMediaTypeTween	
Tween media.

Available in Mac OS X v10.3 and later.
QTMediaType3D	
3D media.

Available in Mac OS X v10.3 and later.
QTMediaTypeSkin	
Skin media

Available in Mac OS X v10.3 and later.
QTMediaTypeQTVR	
QuickTime VR media.

Available in Mac OS X v10.3 and later.
QTMediaTypeHint	
Hint media.

Available in Mac OS X v10.3 and later.
QTMediaTypeStream	
Stream media.

Available in Mac OS X v10.3 and later.*/
NSString  *QTMediaCreationTimeAttribute =1; //?
 NSString  *QTMediaDurationAttribute =1 ;//?
 NSString  *QTMediaModificationTimeAttribute	=1; //?
 NSString  *QTMediaSampleCountAttribute	=1; //?
 NSString  *QTMediaQualityAttribute	=1 ;//?
 NSString  *QTMediaTimeScaleAttribute	=1; //?
 NSString  *QTMediaTypeAttribute	=1 ;//?
 NSString  *QTMediaTypeVideo	=1 ;//?
 NSString  *QTMediaTypeSound	=1 ;//?
 NSString  *QTMediaTypeText	=1 ;//?
 NSString  *QTMediaTypeBase	=1; //?
 NSString  *QTMediaTypeMPEG	=1; //?
 NSString  *QTMediaTypeMusic	=1; //?
 NSString  *QTMediaTypeTimeCode=1; //?
 NSString  *QTMediaTypeSprite	=1; //?
 NSString  *QTMediaTypeFlash	=1 ;//?
 NSString  *QTMediaTypeMovie	=1 ;//?
 NSString  *QTMediaTypeTween	=1 ;//?
 NSString  *QTMediaType3D	=1 ;//?
 NSString  *QTMediaTypeSkin=1 ;//?
 NSString  *QTMediaTypeQTVR	=1 ;//?
 NSString  *QTMediaTypeHint	=1 ;//?
 NSString  *QTMediaTypeStream	=1; //?
