#import <QuartzCore/CIFilter.h>

@implementation CIFilter


/*filterNamesInCategories:

Gets all published filter names that match all the specified categories.

+ (NSArray *)filterNamesInCategories:(NSArray *)categories
Parameters
categories

One or more filter categories. Pass nil to get all filters in all categories.
Return Value

An array that contains all published filter names that match all the categories specified by the categories argument.
Discussion

When you pass more than one filter category, this method returns the intersection of the filters in the categories. For example, if you pass the categories kCICategoryBuiltIn and kCICategoryGenerator, you obtain all the filters that are members of both the built-in and generator categories. But if you pass in kCICategoryGenerator and kCICategoryStylize, you will not get any filters returned to you because there are no filters that are members of both the generator and stylize categories. If you want to obtain all stylize and generator filters, you must call the filterNamesInCategories: method for each category separately and then merge the results.
Availability
Mac OS X v10.4 and later.*/
+ (NSArray *)filterNamesInCategories:(NSArray *)categories{}

/*filterWithName:

Creates a CIFilter object for a specific kind of filter. 

+ (CIFilter *)filterWithName:(NSString *)name
Parameters
name

The name of the filter. 
Return Value

A CIFilter object whose input values are undefined.
Discussion

You should call setDefaults after you call this method or set values individually by calling setValue:forKey.
Availability
Mac OS X v10.4 and later.
See Also
+ filterWithName:keysAndValues:*/
+ (CIFilter *)filterWithName:(NSString *)name{}
/*filterWithName:keysAndValues:

Creates a CIFilter object for a specific kind of filter and initialized the input values.

+ (CIFilter *)filterWithName:(NSString *)name keysAndValues:key0, ... 
Parameters
name

The name of the filter.
key0

A list of key-value pairs to set as input values to the filter. Each key is a constant that specifies the name of the input value to set, and must be followed by a value. You signal the end of the list by passing a nil value.
Return Value

A CIFilter object whose input values are initialized.
Availability
Mac OS X v10.4 and later.*/
+ (CIFilter *)filterWithName:(NSString *)name keysAndValues:key0, ... {}


/*setDefaults

Sets all input values for a filter to default values.

- (void)setDefaults
Discussion

Input values whose default values are not defined are left unchanged.
Availability
Mac OS X v10.4 and later.*/
- (void)setDefaults{}



@end