#ifndef QUICKTIME_H
#include <QuickTime/QuickTime.h>
#endif




/*SCAudioFillBuffer

Used is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format.

ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);
Parameters
ci

The client’s connection to a StdAudio Compression component.
inInputDataProc

The proc address of the function that will be called to supply data in the kQTSCAudioPropertyID_InputBasicDescription format to SCAudio.
inInputDataProcRefCon

The client refcon that will be passed to the user-provided SCAudioInputDataProc function.
ioOutputDataPacketSize

On input, the number of desired packets. On output, the actual number of packets delivered (can be fewer than the input desired packets).
outOutputData

An AudioBufferList providing sufficiently large buffers to hold the requested number of packets.
outPacketDescription

An array of AudioStreamPacketDescriptions. If the requested output format requires external framing information––that is, a VBR format such as AAC–– allocate and pass an array of packet descriptions as large as the number of packets you are requesting.
Discussion

SCAudioFillBuffer preserves the same style API as the Core Audio AudioConverterFillComplexBuffer API, which is part of the AudioToolbox framework and resides in AudioConverter.h. 

This function has the same parameters as AudioConverterFillComplexBuffer, but internally it has an audio converter, a matrix mixer, and another audio converter. It is based on a “pull” model: You pull on the audio converter for some output, and specify the buffer in which you want to put it. You have already configured the format that it is going to return to you. You also provide it with an input proc and it will call back that input proc and specify however many samples of audio you have. For example, if you want five packets of AAC audio coming out the back end, and at the front end you happen to have PCM de-interleaved, the routine will ask you for the samples. The difference is you can now have different numbers of channels going in or out. For example, at the same time you are doing the compression from PCM to AAC, you can also go from 5.1 to stereo.

SCAudioFillBuffer is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format. The StdAudio component can perform any combination of decompression/mixing/compression, combining the facilities of Core Audio AudioConverters and Matrix Mixer AudioUnits. The behavior of the SCAudioFillBuffer call (signalling end of data, and so on) is identical to the AudioConverter's AudioConverterFillComplexBuffer API.

One important difference between the AudioConverter and SCAudio component is that the SCAudio compression APIs can do mixing as well as n -> n channels conversion. If you want to compress, decompress, or transcode audio using the SCAudioFillBuffer interface, you configure the StandardCompressionSubTypeAudio component with the desired input and output formats (or use the SCRequestImageSettings API to present a dialog and let a user select an output format), then you call SCAudioFillBuffer, providing an SCAudioInputDataProc callback, which is called for audio in the specified source format.
Version Notes

Introduced in QuickTime 7.1 for Windows and QuickTime 7 for Mac OS X. 
Availability
Carbon status: Supported C interface file: QuickTimeComponents.h
Declared In
QuickTimeComponents.h*/
ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);


/*MovieAudioExtractionFillBuffer

Extracts audio from a movie.

OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList            *ioData,
   UInt32                     *outFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
ioNumFrames

A pointer to the number of PCM frames to be extracted.
ioData

A pointer to an AudioBufferList allocated by the caller to hold the extracted audio data.
outFlags

A bit flag that indicates when extraction is complete: kMovieAudioExtractionComplete The extraction process is complete. Value is (1L << 0). See these constants: 
Return Value

An error code. Returns noErr if there is no error.
Discussion

You call this function repeatedly; each call continues extracting audio where the last call left off. The function will extract as many of the requested PCM frames as it can, given the limits of the buffer supplied and the limits of the input movie. ioNumFrames will be updated with the exact number of valid frames being returned. When there is no more audio to extract from the movie, the function will continue to return noErr but will return no further audio data. In this case, the outFlags parameter will have its kMovieAudioExtractionComplete bit set. It is possible that the kMovieAudioExtractionComplete bit will accompany the last buffer of valid data.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/



OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList           *ioData,
   UInt32                     *outFlags ){
//TODO
};

/*EnterMovies

Initializes the Movie Toolbox and creates a private storage area for your application.

OSErr EnterMovies ( void );
Return Value

Be sure to check the value returned by this function before using any other facilities of the Movie Toolbox. See Error Codes. Returns noErr if there is no error.
Discussion

Before calling any Movie Toolbox functions, you must use EnterMovies to initialize the toolbox. Your application may call EnterMovies multiple times. The following code sample demonstrates how your application can call the Gestalt Manager to determine whether the Movie Toolbox is installed, using the selector gestaltQuickTime ('qtim'), before calling EnterMovies://Using the Gestalt Manager with the Movie Toolbox
#include <GestaltEqu.h>
#include <Movies.h>
Boolean IsQuickTimeInstalled (void)
{
    short   error;
    long    result;
 
    error =Gestalt (gestaltQuickTime, &result);
    return (error ==noErr);
}
void main (void)
{
    Boolean qtInstalled;
    .
    .
    .
    qtInstalled =IsQuickTimeInstalled ();
}
// EnterMovies coding example
// See "Discovering QuickTime," page 242
void MyInitMovieToolbox (void)
{
    InitGraf(&qd.thePort);
    InitFonts();
    InitWindows();
    InitMenus();
    TEInit();
    InitDialogs(NIL);
    EnterMovies();
}
void main (void)
{
    MyInitMovieToolbox();
    CreateMyCoolMovie();
}

Special Considerations

You should initialize any other Macintosh managers your application uses before calling EnterMovies. You do not need to balance calls to EnterMovies with calls to ExitMovies; you need to call ExitMovies only if you finish with the Movie Toolbox long before your application is ready to quit.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In\
Movies.h*/
OSErr EnterMovies ( void ){
//TODO
};

/*QTGetComponentProperty

Returns the value of a specific component property.

ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed ){
//TODO
};



/*MovieAudioExtractionSetProperty

Sets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_SummaryChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the property value.
inPropValueAddress

A const void pointer that points to the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress ){
//TODO
};


/*MovieAudioExtractionBegin

Begins a movie audio extraction session.

OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
flags

Reserved; must be 0.
outSession

A pointer to an opaque session object.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function before doing any movie audio extraction, because you will pass the object returned by outSession to the other movie audio extraction functions. The format of the extracted audio defaults to the summary channel layout of the movie (all right channels mixed together, all left surround channels mixed together, and so on.), 32-bit float, de-interleaved, with the sample rate set to the highest sample rate found in the movie. You can set the audio format to be something else, as long as it is uncompressed and you do it before your first call to MovieAudioExtractionFillBuffer.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession ){
//TODO
};


/*QTGetComponentPropertyInfo

Returns information about the properties of a component.

ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
outPropType

A pointer to memory allocated to hold the property type on return. This pointer may be NULL.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return. This pointer may be NULL.
outPropertyFlags

A pointer to memory allocated to hold property flags on return.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags ){
//TODO
};


/*BeginMediaEdits

Starts a media-editing session.

OSErr BeginMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use EndMediaEdits to end a media-editing session. You must call BeginMediaEdits before you add samples to a media with the AddMediaSample function. You must also call BeginMediaEdits before calling InsertTrackSegment if you wish InsertTrackSegment to copy media samples instead of copying the segment by reference.// BeginMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr BeginMediaEdits (
   Media    theMedia ){
//TODO
};


/*NewTrackMedia

Creates a media for a new track.

Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack.
mediaType

The type of media to create; see Media Identifiers. The Movie Toolbox uses this value to find the correct media handler for the new media. If the Movie Toolbox cannot locate an appropriate media handler, it returns an error.
timeScale

Defines the media's time coordinate system.
dataRef

The data reference. This parameter contains a handle to the information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter. If you are creating a new media that refers to existing media data, you can use the GetMediaDataRef function to obtain information about the existing data reference. You can then supply information about that reference to this function. Set this parameter to NIL to use the file that is associated with the movie or if the movie does not have a movie file. For example, if you have created the movie using CreateMovieFile or NewMovieFromFile, the Movie Toolbox assumes that the movie's data resides in the file specified at that time. If you have created the movie using the NewMovieFromScrap or NewMovie functions, the movie does not have a movie file.
dataRefType

The type of data reference; see Data References. If the data reference is an alias, you must set this parameter to rAliasType. See Inside Macintosh: Files for more information about aliases and the Alias Manager.
Return Value

A media identifier, referring to the actual data samples used by the track. If the function cannot create a new media, it sets the returned value to NIL.
Discussion

The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewTrackMedia coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType ){
//TODO
};


/*MovieAudioExtractionGetProperty

Gets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

The actual size of the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed){
//TODO
};


/*MovieAudioExtractionGetPropertyInfo

Gets information about a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
outPropType

A pointer to the type of the returned property's value.
outPropValueSize

A pointer to the size of the returned property's value.
outPropFlags

On return, a pointer to flags representing the requested information about the item's property.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags ){
//TODO
};


/*sertMediaIntoTrack

Inserts a reference to a media segment into a track.

OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack or GetMovieTrack.
trackStart

A time value specifying where the segment is to be inserted. This time value must be expressed in the movie's time scale. If you set this parameter to -1, the media data is added to the end of the track.
mediaTime

A time value specifying the starting point of the segment in the media. This time value must be expressed in the media's time scale.
mediaDuration

A time value specifying the duration of the media's segment. This time value must be expressed in the media's time scale.
mediaRate

The media's rate. A value of 1.0 indicates the media's natural playback rate. This value should be positive and not 0.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the segment in the media by providing a starting time and duration. You specify the point in the destination track by providing a time in the track. InsertMediaIntoTrack then inserts the media segment into the track at the specified location. The Movie Toolbox determines the duration of the segment in the track based on the media rate and duration information you provide.

Use this function after you have added samples to a media. If you play the track before you call this function, the track does not contain the new media data.

Here's an example of using this function to add atom containers to a track://InsertMediaIntoTrack coding example
long descSize;
QTVRSampleDescriptionHandle qtvrSampleDesc;
 
// Create a QTVR sample description handle
descSize =sizeof(QTVRSampleDescription) + GetHandleSize((Handle) vrWorld)
                            - sizeof(UInt32);
qtvrSampleDesc =(QTVRSampleDescriptionHandle) NewHandleClear (descSize);
(*qtvrSampleDesc)->
size =descSize;
(*qtvrSampleDesc)->
type =kQTVRQTVRType;
 
// Copy the VR world atom container data into the QTVR sample description
BlockMove (*((Handle) vrWorld), &((*qtvrSampleDesc)->
data),
                            GetHandleSize((Handle) vrWorld));
// Now add it to the QTVR track's media
err =BeginMediaEdits (qtvrMedia);
err =AddMediaSample (qtvrMedia, (Handle) nodeInfo, 0,
    GetHandleSize((Handle) nodeInfo), duration,
    (SampleDescriptionHandle) qtvrSampleDesc, 1, 0, &sampleTime);
err =EndMediaEdits (qtvrMedia);
InsertMediaIntoTrack (qtvrTrack, trackTime, sampleTime, duration, 1L<<16);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate ){
//TODO
};


/*GetMediaDuration

Returns the duration of a media.

TimeValue GetMediaDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The media's duration.
Discussion

The following code sample illustrates the use of GetMediaDuration:// GetMediaDuration coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetMediaDuration (
   Media    theMedia ){
//TODO
};


/*EndMediaEdits

Ends a media-editing session.

OSErr EndMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code sample illustrates the use of EndMediaEdits:// EndMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr EndMediaEdits (
   Media    theMedia ){
//TODO
};


/*GetMediaTrack

Determines the track that uses a specified media.

Track GetMediaTrack (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The track identifier of the track that uses the specified media.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track GetMediaTrack (
   Media    theMedia ){
//TODO
};


/*CloseMovieStorage

Closes an open movie storage container.

OSErr CloseMovieStorage (
   DataHandler    dh );
Parameters
dh

The data handler component that was returned by a previous call to CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 6. Supersedes CloseMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CloseMovieStorage (
   DataHandler    dh ){
//TODO
};


/*AddMovieToStorage

Adds a movie to a storage container that was created by CreateMovieStorage.

OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dh

The data handler component that was returned by CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function calls PutMovieIntoStorage internally. If you are writing a custom data handler, make sure it implements DataHGetDataRef. Also implement DataHScheduleData64 and DataHGetFileSize64, or DataHScheduleData and DataHGetFileSize if the data handler does not support 64-bit file offsets, plus DataHWrite64, or DataHWrite if it does not support 64-bit offsets.
Version Notes

Introduced in QuickTime 6. Supersedes AddMovieResource.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh ){
//TODO
};

/*MovieAudioExtractionEnd

Ends a movie audio extraction session.

OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function when movie audio extraction is complete.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session ){
//TODO
};

/*NewMovieFromDataRef

Creates a movie from any device with a corresponding data handler.

OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
m

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
flags

Flags (see below) that control the operation of this function. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
id

A pointer to the field that specifies the resource containing the movie data that is to be loaded. If the field referred to by the id parameter is set to 0, the Movie Toolbox loads the first movie resource it finds in the specified file. The toolbox then returns the movie's resource ID number in the field referred to by the id parameter. An enumerated constant (see below) is available. See these constants: 
movieInDataForkResID
dataRef

The default data reference. This parameter contains a handle to the information that identifies the file to be used to resolve any data references and as a starting point for any Alias Manager searches. The type of information stored in the handle depends upon the value of the dataRefType parameter. For example, if your application is loading the movie from a file, you would refer to the file's alias in this parameter and set the dataRefType parameter to rAliasType. If you do not want to identify a default data reference, set the parameter to NIL.
dataRefType

The type of data reference. If the data reference is an alias, you must set the parameter to rAliasType, indicating that the reference is an alias.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function is intended for use by specialized applications that need to instantiate movies from devices not visible to the file system. Most applications should continue to use NewMovieFromFile. You are not restricted to instantiating a movie from a file stored on a Macintosh HFS volume. With this function, you can instantiate a movie from any device.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType ){
//TODO
};


/*CreateMovieStorage

Creates an empty storage location to hold a movie and opens a data handler to the stored movie with write permission.

OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie );
Parameters
dataRef

A handle to a QuickTime data reference.
dataRefType

The data reference type. See Data References.
creator

The creator type of the new container (for example, 'TV0D', the creator type for Apple's movie player).
scriptTag

Constants (see below) that specify the script for the new container. See these constants: 
createMovieFileFlags

Constants (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
newMovieActive
outDataHandler

A pointer to a field that is to receive the data handler for the opened movie container. Your application must use this value when calling other Movie Toolbox functions. If you pass NIL, the Movie Toolbox creates the movie container but does not open it.
newmovie

A pointer to a field that is to receive the returned identifier of the new movie. If the function could not create a new movie, it sets this returned value to NIL. If you pass NIL, the Movie Toolbox does not create a movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are writing a custom data handler, make sure it supports DataHGetDataRef. It must also support DataHWrite64, or DataHWrite if 64-bit offsets are not supported.
Version Notes

Introduced in QuickTime 6. Supersedes CreateMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie ){
//TODO
};


/*AddMediaSample2

Adds sample data and a description to a media.

OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
dataIn

A handle to the sample data. The function adds this data to the media specified by theMedia. You specify the number of bytes of sample data with the size parameter.
size

The number of bytes of sample data to be added to the media. This parameter indicates the total number of bytes in the sample data to be added to the media, not the number of bytes per sample. Use the numberOfSamples parameter to indicate the number of samples that are contained in the sample data.
decodeDurationPerSample

The duration of each sample to be added, representing the amount of time that passes while the sample data is being displayed. You must specify this parameter in the media's time scale. For example, if you are adding sound that was sampled at 22 kHz to a media that contains a sound track with the same time scale, you would set durationPerSample to 1. Similarly, if you are adding video that was recorded at 10 frames per second to a video media that has a time scale of 600, you would set this parameter to 60. Note that this is the duration per sample, regardless of the number of samples being added.
displayOffset

A 64-bit time value that specifies the offset between the decode time (the start time of the track plus the duration of all previous samples) and the display time. This value is normally zero unless the sample is frame reordering compressed video.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a SoundDescription structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the sample data to be added to the media. The Movie Toolbox considers the value of this parameter as well as the value of the size parameter when it determines the size of each sample that it adds to the media. You should set the value of this parameter so that the resulting sample size represents a reasonable compromise between total data retrieval time and the overhead associated with input and output. You should also consider the speed of the data storage device; CD-ROM devices are much slower than hard disks, for example, and should therefore have a smaller sample size. For a video media, set a sample size that corresponds to the size of a frame. For a sound media, choose a number of samples that corresponds to between 0.5 and 1.0 seconds of sound. In general, you should not create groups of sound samples that are less than 2 KB in size or greater than 15 KB. Typically, a sample size of about 8 KB is reasonable for most storage devices.
sampleFlags

Flags that control the add operation; set unused flags to 0: mediaSampleNotSync Indicates that the sample to be added is not a sync sample. Set this flag to 1 if the sample is not a sync sample; set it to 0 if the sample is a sync sample. See these constants: 
mediaSampleNotSync
sampleDecodeTimeOut

A pointer to a time value that represents the sample decode time. After adding the sample data to the media, the function returns in this parameter the time where the sample was inserted. If you don't want to receive this information, set this parameter to NIL.
Return Value

An error code. Returns noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

Your application specifies the sample and the media for the operation. This function updates the media so that it contains the sample data. One call to this function can add several samples to a media. This function replaces AddMediaSample; it adds 64-bit support and support for frame reordering video compression (display offset).
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut ){
//TODO
};


/*QTNewDataReferenceFromFullPathCFString

Creates an alias data reference from a CFString that represents the full pathname of a file.

OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
filePath

A CFString that represents the full pathname of a file.
pathStyle

A constant (see below) that identifies the syntax of the pathname. See these constants: 
kQTNativeDefaultPathStyle
kQTPOSIXPathStyle
kQTHFSPathStyle
kQTWindowsPathStyle
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

You need to specify the syntax of the pathname as one of the QTPathStyle constants. The new alias data reference created can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType ){
//TODO
};

/*QTSoundDescriptionCreate

Creates a sound description structure of the requested kind from an AudioStreamBasicDescription, optional audio channel layout, and optional magic cookie.

OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie
ByteCount                      inMagicCookieSize
QTSoundDescriptionKind         inRequestedKind
SoundDescriptionHandle         *outSoundDesc );
Parameters
inASBD

A description of the format.
inLayout

The audio channel layout (can be NULL if there isn't one).
inLayoutSize

The size of the audio channel layout (should be 0 if inLayout is NULL).
inMagicCookie

The magic cookie for the decompressor (can be NULL if the decompressor doesn't require one).
inMagicCookieSize

The size of the magic cookie (should be 0 if the inMagicCookie parameter is NULL).
inRequestedKind

The kind of sound description to create. 
outSoundDesc

The resulting sound description. The caller must dispose of it with DisposeHandle.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie,
ByteCount                      inMagicCookieSize,
QTSoundDescriptionKind         inRequestedKind,
SoundDescriptionHandle         *outSoundDesc ){
//TODO
};


/*DisposeMovie

Frees any memory being used by a movie, including the memory used by the movie's tracks and media structures.

void DisposeMovie (
   Movie    theMovie );
Parameters
theMovie

Identifies the movie to be freed. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, or NewMovieFromHandle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

Your application should call this function when it is done working with a movie, as shown in the following example:// DisposeMovie coding example
// See "Discovering QuickTime," page 85
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile | createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);      // See "Creating a Track," below
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void DisposeMovie (
   Movie    theMovie ){
//TODO
};


/*QTSetComponentProperty

Sets the value of a specific component property.

ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress ){
//TODO
};


/*SCRequestImageSettings

Displays the standard image dialog box to the user and shows default settings you have established.

ComponentResult SCRequestImageSettings (
   ComponentInstance    ci );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to retrieve the user's preferences for compressing a single image; use SCRequestSequenceSettings when you are working with an image sequence. Both functions manipulate the compression settings that the component stores for you.

The component derives the current settings when you may supply an image to the component from which it can derive default settings. If you have not set any defaults, but you do supply a test image for the dialog, the component examines the test image and derives appropriate default values based upon its characteristics. If you have not set any defaults and do not supply a test image, the component uses its own default values.
Special Considerations

You may modify the settings by using SCSetInfo. You may customize the dialog boxes by specifying a modal-dialog hook function or a custom button. You may use the custom button to invoke an ancillary dialog box that is specific to your application.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCRequestImageSettings (
   ComponentInstance    ci ){
//TODO
};


/*NewMovieTrack

Creates a new movie track, without a media.

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
width

A fixed number denoting the display width of the track, in pixels.
height

A fixed number denoting the display height of the track, in pixels. Together, the height and width parameters define the track's display rectangle. The upper-left corner of this rectangle lies at (0,0) in the movie's rectangle. The height and width parameters therefore establish the lower-right corner of the track's display rectangle. If you are creating a track that is not displayed, such as a sound track, set the height and width parameters to 0.
trackVolume

The volume setting of the track as a 16-bit, fixed-point number. The high-order 8 bits specify the integer portion; the low-order 8 bits specify the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. Set this parameter to kFullVolume to play the track at its full, natural volume. Set this parameter to kNoVolume to set the volume to 0. See these constants: 
Return Value

The identifier of the new track.
Discussion

Immediately after creating a new track, you should call NewTrackMedia to create a media for the track; a track without a media is of no use. The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewMovieTrack coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Special Considerations

When you add a track to a movie, the Movie Toolbox automatically adjusts the display Rect structure of the movie. You may want to detect these changes by calling GetMovieBox so that you can adjust the size of the movie's display window.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume ){
//TODO
};


/*GetMoviesError

Returns the contents of the current error value and resets the current error value to 0.

OSErr GetMoviesError ( void );
Return Value

See Error Codes. Returns noErr if there is no error in the current error value.
Discussion

The Movie Toolbox provides two error values to your application: the current error and the sticky error. The current error is the result code from the last Movie Toolbox function; it is updated each time your application calls a Movie Toolbox function. The following code sample shows a typical use:// GetMoviesError coding example
// See "Discovering QuickTime," page 256
OSErr QTUtils_SaveMovie (Movie theMovie)
{
    StandardFileReply   mySFReply;
    StringPtr   myPrompt =QTUtils_ConvertCToPascalString(kSavePrompt);
    StringPtr   myFileName =
                    QTUtils_ConvertCToPascalString(kSaveMovieFileName);
    OSErr       myErr =noErr;
    if (theMovie ==NIL)
        return(invalidMovie);
    StandardPutFile(myPrompt, myFileName, &mySFReply);
    if (mySFReply.sfGood) {
        FlattenMovieData(   theMovie,
                            flattenAddMovieToDataFork,
                            &mySFReply.sfFile,
                            FOUR_CHAR_CODE('TVOD'),
                            smSystemScript,
                            createMovieFileDeleteCurFile);
        myErr =GetMoviesError();
    }
    free(myPrompt);
    free(myFileName);
    return(myErr);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMoviesError ( void ){
//TODO
};


/*QTSoundDescriptionSetProperty

Sets a particular property of a sound description.

OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress );
Parameters
inDesc

The sound description being modified.
inPropClass

The class of the property being set. 
inPropID

The ID of the property being set.
inPropValueSize

The size of the property value buffer.
inPropValueAddress

A pointer to the property value buffer. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

The following constants identify sound description properties.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress ){
//TODO
};


/*SCAudioFillBuffer

Used is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format.

ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);
Parameters
ci

The clients connection to a StdAudio Compression component.
inInputDataProc

The proc address of the function that will be called to supply data in the kQTSCAudioPropertyID_InputBasicDescription format to SCAudio.
inInputDataProcRefCon

The client refcon that will be passed to the user-provided SCAudioInputDataProc function.
ioOutputDataPacketSize

On input, the number of desired packets. On output, the actual number of packets delivered (can be fewer than the input desired packets).
outOutputData

An AudioBufferList providing sufficiently large buffers to hold the requested number of packets.
outPacketDescription

An array of AudioStreamPacketDescriptions. If the requested output format requires external framing information??that is, a VBR format such as AAC?? allocate and pass an array of packet descriptions as large as the number of packets you are requesting.
Discussion

SCAudioFillBuffer preserves the same style API as the Core Audio AudioConverterFillComplexBuffer API, which is part of the AudioToolbox framework and resides in AudioConverter.h. 

This function has the same parameters as AudioConverterFillComplexBuffer, but internally it has an audio converter, a matrix mixer, and another audio converter. It is based on a pull model: You pull on the audio converter for some output, and specify the buffer in which you want to put it. You have already configured the format that it is going to return to you. You also provide it with an input proc and it will call back that input proc and specify however many samples of audio you have. For example, if you want five packets of AAC audio coming out the back end, and at the front end you happen to have PCM de-interleaved, the routine will ask you for the samples. The difference is you can now have different numbers of channels going in or out. For example, at the same time you are doing the compression from PCM to AAC, you can also go from 5.1 to stereo.

SCAudioFillBuffer is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format. The StdAudio component can perform any combination of decompression/mixing/compression, combining the facilities of Core Audio AudioConverters and Matrix Mixer AudioUnits. The behavior of the SCAudioFillBuffer call (signalling end of data, and so on) is identical to the AudioConverter's AudioConverterFillComplexBuffer API.

One important difference between the AudioConverter and SCAudio component is that the SCAudio compression APIs can do mixing as well as n -> n channels conversion. If you want to compress, decompress, or transcode audio using the SCAudioFillBuffer interface, you configure the StandardCompressionSubTypeAudio component with the desired input and output formats (or use the SCRequestImageSettings API to present a dialog and let a user select an output format), then you call SCAudioFillBuffer, providing an SCAudioInputDataProc callback, which is called for audio in the specified source format.
Version Notes

Introduced in QuickTime 7.1 for Windows and QuickTime 7 for Mac OS X. 
Availability
Carbon status: Supported C interface file: QuickTimeComponents.h
Declared In
QuickTimeComponents.h*/
ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription){
//TODO
};


/*SetMovieGWorld

Establishes a movie's display coordinate system by setting the graphics world for displaying the movie.

void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
port

Points to the movie's CGrafPort structure or graphics world. Set this parameter to NIL to use the current graphics port.
gdh

A handle to the movie's GDevice structure. Set this parameter to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's graphics device.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Special Considerations

When you use this function, the Movie Toolbox remembers the current background color and background pattern. These are used for erasing in the default movie uncover function; see SetMovieCoverProcs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh ){
//TODO
};


/*SetMovieVisualContext

Targets a movie to render into a visual context.

OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext;
Parameters
movie

The movie.
visualContext

The visual context that the movie will render into. May be NULL..
Return Value

An error code. Returns noErr if there is no error. Returns memFullErr if memory cannot be allocated. Returns kQTVisualContextNotAllowed if the movie is not able to render using a visual context. Returns paramErr if the movie is NULL.
Discussion

When SetMovieVisualContext succeeds, it will retain the QTVisualContext object for its own use. If visualContext is NULL, the movie will not render any visual media. SetMovieVisualContext will fail if a different movie is already using the visual context, so you should first disassociate the other movie by calling SetMovieVisualContext with a NULL visualContext. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext){
//TODO
};


/*PrerollMovie

Prepares a portion of a movie for playback.

OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to play.
Rate

The rate at which you anticipate playing the movie. You specify the movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

When your application calls PrerollMovie, the Movie Toolbox tells the appropriate media handlers to prepare to play the movie. The media handlers may then load the movie data and perform any other necessary preparations to play the movie, such as allocating sound channels and starting up image-decompression sequences. In this manner, you can eliminate playback stutter when the movie starts playing.

If your application uses QuickTime's Movie Toolbox to play back movies, there are two choices for how to preroll the movie. Like the movie controller, the Movie Toolbox provides a single function call, StartMovie, which will both preroll the movie and start it playing. Unlike the movie controller, the Movie Toolbox function doesn't allow you to specific the rate to play the movie at, but instead assumes the movie's preferred rate.

Calling StartMovie, just like the movie controller's preroll and play action, first prerolls the movie and then sets it playing. If your application requires more control, the Movie Toolbox provides lower level functions that give you more control:// PrerollMovie coding example
StartMovie(theMovie);
TimeValue timeNow;
Fixed playRate;
timeNow =GetMovieTime(theMovie, NIL);
playRate =GetMoviePreferredRate(theMovie);
PrePrerollMovie(theMovie, timeNow, playRate, NIL, NIL);
PrerollMovie(theMovie, timeNow, playRate);
SetMovieRate(theMovie, playRate);

Special Considerations

You should always call PrePrerollMovie before calling this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate ){
//TODO
};


/*GetMovieTime

Returns a movie's current time both as a time value and in a time structure.

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
currentTime

A pointer to a TimeRecord structure. The function updates this time structure to contain the movie's current time. If you don't want this information, set this parameter to NIL.
Return Value

The time value of the current time.
Discussion

This function returns the movie's current time value in two formats: as a time value and in a time structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime ){
//TODO
};


/*MoviesTask

Services active movies.

void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle. If you set this parameter to NIL, the Movie Toolbox services all of your active movies.
maxMilliSecToUse

Determines the maximum number of milliseconds that MoviesTask can work before returning. If this parameter is 0, MoviesTask services every active movie exactly once and then returns. If the parameter is nonzero, MoviesTask services as many movies as it can in the allotted time before returning. Once the MoviesTask function starts servicing a movie, it cannot stop until it has completely met the requirements of the movie. Consequently, the MoviesTask function may execute for a longer time than that specified in maxMilliSecToUse. However, the function does not start servicing a new movie if the time specified by maxMilliSecToUse has elapsed. The preferred way to use MoviesTask is to set the maxMilliSecToUse parameter to 0; however, if you just want to play one movie, you can call MoviesTask on that one. If your rate is 0, MoviesTask draws that frame and no other.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

You should call MoviesTask as often as possible from your application's main event loop. Note that you should call this function after you have performed your own event processing. MoviesTask services only active movies, and only enabled tracks within those active movies.
Special Considerations

Note that the MoviesTask function services only your movies. Your application must give other applications the opportunity to call MoviesTask for their movies.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse ){
//TODO
};


/*UpdateMovie

Ensures that the Movie Toolbox properly displays your movie after it has been uncovered.

OSErr UpdateMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application should call this function during window updating. Don't call MoviesTask at this time; you will observe better display behavior if you call it at the end of your update processing.

This function does not actually update the movie's graphics world. Rather, it invalidates the movie's display state so that the Movie Toolbox redraws the movie the next time you call MoviesTask. If you need to force a movie to be redrawn outside of a window update sequence, your application can call this function and then call MoviesTask to service the movie. The Movie Toolbox determines the portion of the screen to update by examining the graphics port's visible region.

The following code snippet uses this function in a Macintosh Window Manager update sequence:// UpdateMovie coding example
#include <Events.h>
#include <ToolUtils.h>
#include "Movies.h"
void DoUpdate (WindowRef theWindow, Movie theMovie)
{
    BeginUpdate (theWindow);
    UpdateMovie (theMovie);
    EndUpdate (theWindow);
} // DoUpdate

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr UpdateMovie (
   Movie    theMovie ){
//TODO
};


/*QTOpenGLTextureContextCreate
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Creates a new OpenGL texture context for a specified OpenGL context and pixel format.

OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Parameters
allocator

The allocator used to create the texture context.
cglContext

A pointer to an opaque CGLPContextObj structure representing the OpenGL context used to create textures. You can create this structure using CGLCreateContext.
cglPixelFormat

The pixel format object that specifies buffer types and other attributes of the new context.
attributes

A dictionary of attributes.
newTextureContext

A pointer to a variable to receive the new OpenGL texture context.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext ){
//TODO
};

/*QTVisualContextSetAttribute

Sets a visual context attribute.

OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue );
Parameters
visualContext

The visual context.
attributeKey

Identifier of attribute to set
attributeValue

The value of the attribute to set, or NULL to remove a value. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue ){
//TODO
};


/*QTVisualContextRelease

Releases a visual context object.

void QTVisualContextRelease (
   QTVisualContextRef visualContext
);
Parameters
visualContext

A reference to a visual context object. If you pass NULL, nothing happens.
Discussion

When the retain count decreases to zero, the visual context is disposed.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
void QTVisualContextRelease (
   QTVisualContextRef visualContext){
//TODO
};


/*QTVisualContextCopyImageForTime

Retrieves an image buffer from the visual context, indexed by the provided time.

OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage
);
Parameters
visualContext

The visual context.
allocator

Allocator used to create new CVImageBufferRef.
timeStamp

Time in question. Pass NULL to request the image at the current time.
newImage

Points to variable to receive the new image.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You should not request image buffers further ahead of the current time than the read-ahead time specified with the kQTVisualContextExpectedReadAheadKey attribute. You may skip images by passing later times, but you may not pass an earlier time than passed to a previous call to this function.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage){
//TODO
};


/*QTVisualContextTask

Enables the visual context to release internally held resources for later use.

void QTVisualContextTask (
   QTVisualContextRef visualContext
);
Parameters
visualContext

The visual context.
Discussion

For optimal resource management, this function should be called in every rendering pass. It should be called after old images have been released, new images have been used and all rendering has been flushed to the screen. The call is not mandatory.
Version Notes

Introduced in QuickTime 7
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

void QTVisualContextTask (
   QTVisualContextRef visualContext){
//TODO
};


/*QTVisualContextIsNewImageAvailable

Queries whether a new image is available for a given time.

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp
);
Parameters
visualContext

The visual context.
timeStamp

Time in question.
Return Value

A Boolean.
Discussion

This function returns TRUE if there is a image available for the specified time that is different from the last image retrieved from QTVisualContextCopyImageForTime.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp){
//TODO
};

/*SGNewChannel

Creates a sequence grabber channel and assigns a channel component to the channel.

ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
channelType

The type of channel to open (see below). This value corresponds to the component subtype value of the channel component. See these constants: 
VideoMediaType
SoundMediaType
ref

A pointer to the frameChannel field in the SeqGrabFrameInfo structure that is to receive a reference to the channel that is added to the sequence grabber component. If the sequence grabber component successfully locates and connects to an appropriate channel component, the sequence grabber component returns a reference to the channel component into this field.
Return Value

See Error Codes. If the sequence grabber component cannot open a connection, it sets the result code to a nonzero value. It returns noErr if there is no error.
Discussion

The channel component is responsible for providing digitized data to the sequence grabber component. You specify the type of channel component to be added to the sequence grabber component, as shown in the following sample code:// SGNewChannel coding example
// See "Discovering QuickTime," page 263
void MakeMyGrabChannels (SeqGrabComponent    seqGrab,
                            SGChannel        *sgchanVideo,
                            SGChannel        *sgchanSound,
                            const Rect       *rect,
                            Boolean          bWillRecord)
{
    OSErr           nErr;
    long            lUsage;
    // figure out the usage
    lUsage =seqGrabPreview;                // always previewing
    if (bWillRecord)
        lUsage |=seqGrabRecord;            // sometimes recording
    // create a video channel
    nErr =SGNewChannel(seqGrab, VideoMediaType, sgchanVideo);
    if (nErr ==noErr) {
        // set boundaries for new video channel
        nErr =SGSetChannelBounds(*sgchanVideo, rect);
        // set usage for new video channel
        if (nErr ==noErr)
            nErr =SGSetChannelUsage(*sgchanVideo, lUsage |
                                        seqGrabPlayDuringRecord);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanVideo);
            *sgchanVideo =NIL;
        }
    }
    // create a sound channel
    nErr =SGNewChannel(seqGrab, SoundMediaType, sgchanSound);
    if (nErr ==noErr) {
        // set usage of new sound channel
        nErr =SGSetChannelUsage(*sgchanSound, lUsage);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanSound);
            *sgchanSound =NIL;
        }
    }
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref ){
//TODO
};


/*SGGetChannelRefCon

Returns a reference constant that was previously set by SGSetChannelRefCon.

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A pointer to the reference constant set by SGSetChannelRefCon, normally used to point to a data structure containing information your sequence grabber channel needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h&*/

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon ){
//TODO
};


/*SGSetChannelRefCon

Sets the value of a reference constant that is passed to your callback functions for channel components.

ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A reference constant value that your component should pass to the callback functions that have been assigned to this channel. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon ){
//TODO
};


/*QTAddComponentPropertyListener

Installs a callback to monitor a component property.

ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inDispatchProc

A Universal Procedure Pointer to a QTComponentPropertyListenerProc callback.
inUserData

A pointer to user data that will be passed to the callback. You may pass NULL in this parameter.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData ){
//TODO
};


/*SGSetDataProc

Specifies a data function for use by the sequence grabber.

ComponentResult SGSetDataProc (
   SeqGrabComponent    s,
   SGDataUPP           proc,
   long                refCon );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
proc

A pointer to your data function. To remove your data function, set this parameter to NIL.
refCon

A reference constant. The sequence grabber provides this value to your data callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetDataProc (
   SeqGrabComponent    s,
   SGDataUPP           proc,
   long                refCon ){
//TODO
};


/*ICMDecompressionSessionRelease

Decrements the retain count of a decompression session.

void ICMDecompressionSessionRelease (
   ICMDecompressionSessionRef    session );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMDecompressionSessionRelease (
   ICMDecompressionSessionRef    session ){
//TODO
};


/*ICMDecompressionSessionSetNonScheduledDisplayTime

Sets the display time for a decompression session, and requests display of the non-scheduled queued frame at that display time, if there is one.

OSStatus ICMDecompressionSessionSetNonScheduledDisplayTime (
   ICMDecompressionSessionRef   session,
   TimeValue64                  displayTime,
   TimeScale                    displayTimeScale,
   UInt32                       flags );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. 
displayTime

A display time. Usually this is the display time of a non-scheduled queued frame. 
displayTimeScale

The timescale according to which displayTime should be interpreted. 
flags

Reserved; set to 0. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionSetNonScheduledDisplayTime (
   ICMDecompressionSessionRef   session,
   TimeValue64                  displayTime,
   TimeScale                    displayTimeScale,
   UInt32                       flags ){
//TODO
};


/*ICMDecompressionSessionDecodeFrame

Queues a frame for decompression.

OSStatus ICMDecompressionSessionDecodeFrame (
   ICMDecompressionSessionRef         session,
   const UInt8                        *data,
   ByteCount                          dataSize,
   ICMDecompressionFrameOptionsRef    frameOptions,
   const ICMFrameTimeRecord           *frameTime,
   void                               *sourceFrameRefCon );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. 
data

A pointer to the compressed data for this frame. The data must remain in this location until ICMDecompressionTrackingCallbackProc is called with the kICMDecompressionTracking_ReleaseSourceData flag set in decompressionTrackingFlags.
dataSize

The number of bytes of compressed data. You may not pass 0 in this parameter. 
frameOptions

A reference to a frame decompression options object containing options for this frame. You can create this object by calling ICMDecompressionFrameOptionsCreate.
frameTime

A pointer to a structure describing the frame's timing information. 
sourceFrameRefCon

Your reference value for the frame. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMDecompressionSessionDecodeFrame (
   ICMDecompressionSessionRef         session,
   const UInt8                        *data,
   ByteCount                          dataSize,
   ICMDecompressionFrameOptionsRef    frameOptions,
   const ICMFrameTimeRecord           *frameTime,
   void                               *sourceFrameRefCon ){
//TODO
};


/*ICMDecompressionSessionOptionsRelease

Decrements the retain count of a decompression session options object.

void ICMDecompressionSessionOptionsRelease (
   ICMDecompressionSessionOptionsRef   options );
Parameters
options

A reference to a decompression session options object. This reference is returned by ICMDecompressionSessionOptionsCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

void ICMDecompressionSessionOptionsRelease (
   ICMDecompressionSessionOptionsRef   options ){
//TODO
};


/*ICMDecompressionSessionCreate

Creates a session for decompressing video frames.

OSStatus ICMDecompressionSessionCreate (
   CFAllocatorRef                       allocator,
   ImageDescriptionHandle               desc,
   ICMDecompressionSessionOptionsRef    decompressionOptions,
   CFDictionaryRef                      destinationPixelBufferAttributes,
   ICMDecompressionTrackingCallbackRecord    *trackingCallback,
   ICMDecompressionSessionRef                *decompressionSessionOut );
Parameters
allocator

An allocator for the session. Pass NULL to use the default allocator. 
desc

An image description for the source frames. 
decompressionOptions

A decompression session options reference. This reference is returned by ICMDecompressionSessionOptionsCreate. The session will retain the object. You may change some options during the session by modifying the object. You may also pass NULL.
destinationPixelBufferAttributes

Requirements for emitted pixel buffers. You may pass NULL.
trackingCallback

A pointer to a structure that designates a callback to be called for information about queued frames and pixel buffers containing decompressed frames. See ICMDecompressionTrackingCallbackRecord and ICMDecompressionTrackingCallbackProc.
decompressionSessionOut

A pointer to a variable to receive a reference to the new decompression session. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

Frames are returned through calls to the callback pointed to by trackingCallback.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionCreate (
   CFAllocatorRef                       allocator,
   ImageDescriptionHandle               desc,
   ICMDecompressionSessionOptionsRef    decompressionOptions,
   CFDictionaryRef                      destinationPixelBufferAttributes,
   ICMDecompressionTrackingCallbackRecord    *trackingCallback,
   ICMDecompressionSessionRef                *decompressionSessionOut ){
//TODO
};


/*ICMDecompressionSessionOptionsCreate

Creates a decompression session options object.

OSStatus ICMDecompressionSessionOptionsCreate (
   CFAllocatorRef                      allocator,
   ICMDecompressionSessionOptionsRef   *options );
Parameters
allocator

An allocator. Pass NULL to use the default allocator.
options

On return, a reference to a decompression session options object.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionOptionsCreate (
   CFAllocatorRef                      allocator,
   ICMDecompressionSessionOptionsRef   *options ){
//TODO
};


/*ICMImageDescriptionGetProperty

Returns a particular property of a image description handle.

OSStatus ICMImageDescriptionGetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ComponentValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed );
Parameters
inDesc

The image description handle being interrogated.
inPropClass

The class of property being requested.
inPropID

The ID of the property being requested.
inPropValueSize

The size of the property value buffer.
outPropValueAddress

Points to the buffer to receive the property value.
outPropValueSizeUsed

Points to a variable to receive the actual size of returned property value. (This can be NULL). 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine returns a particular property of a image description handle.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMImageDescriptionGetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ComponentValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed ){
//TODO
};


/*ICMDecompressionSessionOptionsSetProperty

Sets the value of a specific property of a decompression session options object.

OSStatus ICMDecompressionSessionOptionsSetProperty (
   ICMDecompressionSessionOptionsRef   options,
   ComponentPropertyClass              inPropClass,
   ComponentPropertyID                 inPropID,
   ByteCount                           inPropValueSize,
   ConstComponentValuePtr              inPropValueAddress );
Parameters
options

A decompression session options reference. This reference is returned by ICMDecompressionSessionOptionsCreate.
inPropClass

Pass the following constant to define the property class: kComponentPropertyClassPropertyInfo = 'pnfo' The property information class. See these constants: 
kComponentPropertyClassPropertyInfo
inPropID

Pass one of these constants to define the property ID: kComponentPropertyInfoList = 'list' An array of CFData values, one for each property. kComponentPropertyCacheSeed = 'seed' A property cache seed value. kComponentPropertyCacheFlags = 'flgs' One of the kComponentPropertyCache flags: kComponentPropertyCacheFlagNotPersistentProperty metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamicProperty metadata should not cached at all. kComponentPropertyExtendedInfo = 'meta' A CFDictionary with extended property information. See these constants: 
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyCacheFlags
kComponentPropertyExtendedInfo
inPropValueSize

The size of the property value to be set.
inPropValueAddress

A pointer to the value of the property to be set.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionOptionsSetProperty (
   ICMDecompressionSessionOptionsRef   options,
   ComponentPropertyClass              inPropClass,
   ComponentPropertyID                 inPropID,
   ByteCount                           inPropValueSize,
   ConstComponentValuePtr              inPropValueAddress ){
//TODO
};


/*SGGetChannelDeviceAndInputNames

Returns the sequence grabber's current device and input names.

ComponentResult SGGetChannelDeviceAndInputNames (
   SGChannel    c,
   Str255       outDeviceName,
   Str255       outInputName,
   short        *outInputNumber );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
outDeviceName

The current device names for display to the user.
outInputName

The current input names for display to the user.
outInputNumber

A pointer to the number of currently selected inputs.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This is a utility call that lets you find out the sequence grabber's current device and input names, instead of having to call GetDeviceList and walk it yourself. Pass NIL for parameters you are not interested in.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelDeviceAndInputNames (
   SGChannel    c,
   Str255       outDeviceName,
   Str255       outInputName,
   short        *outInputNumber ){
//TODO
};


/*SGGetChannelDeviceList

Retrieves a list of the devices that are valid for a specified channel.

ComponentResult SGGetChannelDeviceList (
   SGChannel       c,
   long            selectionFlags,
   SGDeviceList    *list );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
selectionFlags

Flags (see below) that control the data you are to return for each device. See these constants: 
sgDeviceListWithIcons
sgDeviceListDontCheckAvailability
sgDeviceListIncludeInputs
list

A pointer to a pointer to an SGDeviceListRecord structure. The channel creates this structure and returns a pointer to it in the field referred to by this parameter. Applications use SGDisposeDeviceList to dispose of the memory used by the list.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function can be useful for retrieving the name of the current device. Retrieve the device list and use the selectedIndex field to determine which device is currently in use.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelDeviceList (
   SGChannel       c,
   long            selectionFlags,
   SGDeviceList    *list ){
//TODO
};


/*SGDisposeDeviceList

Disposes of a device list.

ComponentResult SGDisposeDeviceList (
   SeqGrabComponent    s,
   SGDeviceList        list );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
list

A pointer to a pointer to an SGDeviceListRecord structure. The sequence grabber disposes of the memory used by this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGDisposeDeviceList (
   SeqGrabComponent    s,
   SGDeviceList        list ){
//TODO
};


/*SGGetSrcVideoBounds

Determines the size of the source video boundary rectangle.

ComponentResult SGGetSrcVideoBounds (
   SGChannel    c,
   Rect         *r );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
r

A pointer to a Rect structure that is to receive information about your channel's source video boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

For video channel components that work with video digitizer components, the source video boundary rectangle corresponds to the video digitizer's active source rectangle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetSrcVideoBounds (
   SGChannel    c,
   Rect         *r ){
//TODO
};


/*SGGetChannelSampleDescription

Retrieves a channel's sample description structure.

ComponentResult SGGetChannelSampleDescription (
   SGChannel    c,
   Handle       sampleDesc );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
sampleDesc

A handle that is to receive the structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The channel returns a structure that is appropriate to the type of data being captured. For video channels, the channel component returns an ImageDescription structure; for sound channels, it receives a SoundDescription structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelSampleDescription (
   SGChannel    c,
   Handle       sampleDesc ){
//TODO
};


/*SGGetChannelTimeScale

Lets the sequence grabber retrieve a channel's time scale.

ComponentResult SGGetChannelTimeScale (
   SGChannel    c,
   TimeScale    *scale );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
scale

A pointer to a time scale. Your channel component places information about its time scale into this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The time scale you return typically corresponds to the time scale of the media that has been created by your channel. Applications may use this time scale in their data functions.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelTimeScale (
   SGChannel    c,
   TimeScale    *scale ){
//TODO
};


/*SGGetChannelBounds

Determines a channel's display boundary rectangle.

ComponentResult SGGetChannelBounds (
   SGChannel    c,
   Rect         *bounds );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bounds

A pointer to a Rect structure that is to receive information about your channel's display boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelBounds (
   SGChannel    c,
   Rect         *bounds ){
//TODO
};



/*SGSetGWorld

Establishes the graphics port and device for a sequence grabber component.

ComponentResult SGSetGWorld (
   SeqGrabComponent    s,
   CGrafPtr            gp,
   GDHandle            gd );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
gp

The destination graphics port, which must be a color graphics port. The sequence grabber component always sets this parameter to a valid value. To use the current graphics port, the parameter is set to NIL.
gd

A handle to the destination graphics device. The sequence grabber component always sets this parameter to a valid value.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You must call this function if you are working with any channels that collect visual data. If you are working only with data that has no visual representation, you do not need to call this function. The sequence grabber component performs this operation implicitly when you call SGInitialize and the component uses your application's current graphics port. To set it to a specified window, use code such as the following:// SGSetGWorld coding example
// See "Discovering QuickTime," page 262
SeqGrabComponent MakeMySequenceGrabber (WindowRef pMacWnd)
{
    SeqGrabComponent    seqGrab =NIL;
    OSErr               nErr =noErr;
    // open the default sequence grabber
    seqGrab =OpenDefaultComponent(SeqGrabComponentType, 0);
    if (seqGrab !=NIL) {
        // initialize the default sequence grabber component
        nErr =SGInitialize(seqGrab);
        if (nErr ==noErr) {
        // set its graphics world to the specified window
            nErr =SGSetGWorld(seqGrab, (CGrafPtr)pMacWnd, NIL);
        }
    }
    if (nErr && (seqGrab !=NIL)) {    // clean up on failure
        CloseComponent(seqGrab);
        seqGrab =NIL;
    }
    return seqGrab;
}

Special Considerations

You cannot call this function during a record or preview operation, or after you have prepared the sequence grabber component for a record or preview operation by calling SGPrepare. The window in which the sequence grabber is to draw video frames as defined by this function must be visible before you call SGPrepare; otherwise, the sequence grabber does not display the frames properly.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetGWorld (
   SeqGrabComponent    s,
   CGrafPtr            gp,
   GDHandle            gd ){
//TODO
};


/*SGSetChannelBounds

Specifies a channel's display boundary rectangle.

ComponentResult SGSetChannelBounds (
   SGChannel     c,
   const Rect    *bounds );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bounds

A pointer to a Rect structure that defines your channel's display boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetChannelBounds (
   SGChannel     c,
   const Rect    *bounds){
//TODO
};


/*QTNewGWorld

Creates an offscreen graphics world that may have a non-Macintosh pixel format.

OSErr QTNewGWorld (
   GWorldPtr      *offscreenGWorld,
   OSType         PixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags );
Parameters
offscreenGWorld

On return, a pointer to the offscreen graphics world created by this routine.
PixelFormat

The new graphics world's pixel format; see Pixel Formats. This function won't work with planar pixel formats; use QTNewGWorldFromPtr instead. See the ICMPixelFormatInfo structure for a discussion of planar and chunky formats.
boundsRect

A pointer to the boundary rectangle and port rectangle for the offscreen pixel map. This becomes the boundary rectangle for the GDevice structure, if this function creates one. If you specify 0 in the PixelFormat parameter, the function interprets the boundaries in global coordinates that it uses to determine which screens intersect the rectangle. It then uses the pixel format, color table, and GDevice structure from the screen with the greatest pixel depth from among all screens whose boundary rectangles intersect this rectangle. Typically, your application supplies this parameter with the port rectangle for the onscreen window into which your application will copy the pixel image from this offscreen world.
cTable

A handle to a ColorTable structure. If you pass NIL in this parameter, the function uses the default color table for the pixel format that you specify in the PixelFormat parameter. If you set the PixelFormat parameter to 0, the function ignores the cTable parameter and instead copies and uses the color table of the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. If you use this function on a computer that supports only basic QuickDraw, you may specify only NIL in this parameter.
aGDevice

A handle to a GDevice structure that is used only when you specify the noNewDevice flag in the flags parameter, in which case the function attaches this structure to the new offscreen graphics world. If you set the PixelFormat parameter to 0, or if you do not set the noNewDevice flag, the function ignores this parameter, so you should set it to NIL. If you set the PixelFormat parameter to 0, the function uses the GDevice structure for the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. You should pass NIL in this parameter if the computer supports only basic QuickDraw. Generally, your application should never create GDevice structures for offscreen graphics worlds.
flags

Constants (see below) that identify options available to your application. You can set a combination of these flags. If you don't wish to use any of them, pass 0 in this parameter. In this case the default behavior is to create an offscreen graphics world where the base address for the offscreen pixel image is unpurgeable, the graphics world uses an existing GDevice structure (if you pass 0 in the depth parameter) or creates a new GDevice structure, it uses memory in your application heap, and it allows graphics accelerators to cache the offscreen pixel image. See these constants: 
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr QTNewGWorld (
   GWorldPtr      *offscreenGWorld,
   OSType         PixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags ){
//TODO
};

/*ICMImageDescriptionSetProperty

Sets a particular property of a image description handle.

OSStatus ICMImageDescriptionSetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstComponentValuePtr inPropValueAddress );
Parameters
inDesc

The image description handle being modified.
inPropClass

The class of property being set.
inPropID

The ID of the property being set.
inPropValueSize

The size of property value.
inPropValueAddress

Points to the property value buffer. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMImageDescriptionSetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstComponentValuePtr inPropValueAddress ){
//TODO
};


/*SGInitialize

Initializes the sequence grabber component.

ComponentResult SGInitialize (
   SeqGrabComponent    s );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before you can call this function you must establish a connection to the sequence grabber component. Use OpenDefaultComponent or OpenComponent to establish a component connection, as shown below:// SGInitialize coding example
// See "Discovering QuickTime," page 262
SeqGrabComponent MakeMySequenceGrabber (WindowRef pMacWnd)
{
    SeqGrabComponent    seqGrab =NIL;
    OSErr               nErr =noErr;
    // open the default sequence grabber
    seqGrab =OpenDefaultComponent(SeqGrabComponentType, 0);
    if (seqGrab !=NIL) {
        // initialize the default sequence grabber component
        nErr =SGInitialize(seqGrab);
        if (nErr ==noErr) {
        // set its graphics world to the specified window
            nErr =SGSetGWorld(seqGrab, (CGrafPtr)pMacWnd, NIL);
        }
    }
    if (nErr && (seqGrab !=NIL)) {    // clean up on failure
        CloseComponent(seqGrab);
        seqGrab =NIL;
    }
    return seqGrab;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGInitialize (
   SeqGrabComponent    s ){
//TODO
};


/*(SGSetDataRef

Specifies the destination data reference for a record operation.

ComponentResult SGSetDataRef (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
dataRef

A handle to the information that identifies the destination container.
dataRefType

The type of data reference. If the data reference is an alias, you must set the parameter to rAliasType.
whereFlags

Contains flags (see below) that control the record operation. You must set either seqGrabToDisk or seqGrabToMemory to 1. Set unused flags to 0. See these constants: 
seqGrabToDisk
seqGrabToMemory
seqGrabDontUseTempMemory
seqGrabAppendToFile
seqGrabDontAddMovieResource
seqGrabDontMakeMovie
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows you to specify the destination for a record operation using a data reference, and to specify other options that govern the operation. This function is similar to SGSetDataOutput, and provides you with an alternative way to specify the destination.
Special Considerations

If you are performing a preview operation, you don't need to use this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetDataRef (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags ){
//TODO
};


/*SGGetSettings

Retrieves the current settings of all channels used by the sequence grabber.

ComponentResult SGGetSettings (
   SeqGrabComponent    s,
   UserData            *ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ud

A pointer to a space where the sequence grabber returns a pointer to a UserDataRecord structure that contains the configuration information. Your application is responsible for disposing of this structure when it is done with it.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetSettings (
   SeqGrabComponent    s,
   UserData            *ud,
   long                flags ){
//TODO
};


/*SGGetIndChannel

Collects information about all of the channel components currently in use by a sequence grabber component.

ComponentResult SGGetIndChannel (
   SeqGrabComponent    s,
   short               index,
   SGChannel           *ref,
   OSType              *chanType );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
index

Specifies an index value that identifies the channel to be queried. The first channel has an index value of 1.
ref

A pointer to a field to receive a value identifying your connection to the channel. If you do not want to receive this information, set this parameter to NIL.
chanType

A pointer to a field to receive the channel's subtype value (see below). This value indicates the media type supported by the channel component. See these constants: 
VideoMediaType
SoundMediaType
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetIndChannel (
   SeqGrabComponent    s,
   short               index,
   SGChannel           *ref,
   OSType              *chanType ){
//TODO
};


/*SGSetSettings

Configures a sequence grabber and its channels.

ComponentResult SGSetSettings (
   SeqGrabComponent    s,
   UserData            ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ud

A UserDataRecord structure that contains the configuration information to be used by the sequence grabber.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The sequence grabber disposes of any of its current channels before applying this configuration information. It then opens connections to new channels as appropriate.
Special Considerations

You can restore saved settings by using NewUserDataFromHandle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetSettings (
   SeqGrabComponent    s,
   UserData            ud,
   long                flags ){
//TODO
};



/*SGGetChannelSettings

Retrieves the current settings of a channel used by the sequence grabber.

ComponentResult SGGetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            *ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
ud

On return, a pointer to a UserDataRecord structure that contains the configuration information.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            *ud,
   long                flags ){
//TODO
};


/*SGDisposeChannel

Removes a channel from a sequence grabber component.

ComponentResult SGDisposeChannel (
   SeqGrabComponent    s,
   SGChannel           c );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The reference that identifies the channel you want to close. You obtain this reference from SGNewChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGDisposeChannel (
   SeqGrabComponent    s,
   SGChannel           c ){
//TODO
};



/*SGSetChannelSettings

Configures a sequence grabber channel.

ComponentResult SGSetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
ud

A UserDataRecord structure that contains the configuration information to be used by the channel component.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            ud,
   long                flags ){
//TODO
};


/*SGSetMaximumRecordTime

Limits the duration of a record operation

ComponentResult SGSetMaximumRecordTime (
   SeqGrabComponent    s,
   unsigned long       ticks );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ticks

The maximum duration for the record operation, in system ticks (sixtieths of a second). Set this parameter to 0 to remove the time limit from the operation.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

By default, there is no time limit on a record operation. If you do not set a limit, a record operation will run until it exhausts the Operating System resources or you call SGStop. Memory and disk space are the two major limiting factors.
Special Considerations

You must call this function before you start a sequence grabber record operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetMaximumRecordTime (
   SeqGrabComponent    s,
   unsigned long       ticks ){
//TODO
};


/*SGIdle

Provides processing time for sequence grabber components.

ComponentResult SGIdle (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

After starting a preview or record operation, the application calls this function as often as possible. The sequence grabber component then calls your SGIdle function. This continues until the calling application stops the operation by calling SGStop.Your SGIdle function reports several status and error conditions by means of its result code. If your component returns a nonzero result code during a record operation, the application should call SGStop so that the sequence grabber component can store the data it has collected.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGIdle (
   SeqGrabComponent    s ){
//TODO
};

/*SGStartRecord

Instructs the sequence grabber component to begin collecting data from its channels.

ComponentResult SGStartRecord (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStartRecord (
   SeqGrabComponent    s ){
//TODO
};


/*SGStop

Stops a preview or record operation.

ComponentResult SGStop (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

It is dangerous to allow an update event to occur during recording. Many digitizers capture directly to the screen, and an update event will result in data loss.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStop (
   SeqGrabComponent    s ){
//TODO
};


/*SGPause

Suspends or restarts a sequence grabber record or preview operation.

ComponentResult SGPause (
   SeqGrabComponent    s,
   Byte                pause );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
pause

A constant (see below) that instructs your component to suspend or restart the current operation. See these constants: 
seqGrabUnpause
seqGrabPause
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your component should not release any system resources or temporary memory associated with the current operation. You should be ready to restart the operation immediately.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGPause (
   SeqGrabComponent    s,
   Byte                pause ){
//TODO
};


/*SGGetPause

Determines whether the sequence grabber is paused.

ComponentResult SGGetPause (
   SeqGrabComponent    s,
   Byte                *paused );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
paused

A pointer to a field that is to receive a constant (see below) that indicates whether the sequence grabber is currently paused. See these constants: 
seqGrabUnpause
seqGrabPause
seqGrabPauseForMenu
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetPause (
   SeqGrabComponent    s,
   Byte                *paused ){
//TODO
};


/*PutUserDataIntoHandle

Returns a handle to a user data structure.

OSErr PutUserDataIntoHandle (
   UserData    theUserData,
   Handle      h );
Parameters
theUserData

The user data structure.
h

A handle to the UserDataRecord structure pointed to by the theUserData parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutUserDataIntoHandle (
   UserData    theUserData,
   Handle      h ){
//TODO
};


/*NewUserDataFromHandle

Creates a new user data structure from a handle.

OSErr NewUserDataFromHandle (
   Handle      h,
   UserData    *theUserData );
Parameters
h

A handle to the data structure specified in theUserData.
theUserData

A pointer to a pointer to a new UserDataRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error. If the function fails, theUserData is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewUserDataFromHandle (
   Handle      h,
   UserData    *theUserData ){
//TODO
};


/*DisposeUserData

Disposes of a user data structure created by NewUserData.

OSErr DisposeUserData (
   UserData    theUserData );
Parameters
theUserData

The user data structure that is to be disposed of. It is acceptable but unnecessary to pass NIL in this parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DisposeUserData (
   UserData    theUserData ){
//TODO
};

/*SGSetChannelUsage

Specifies how a channel is to be used by the sequence grabber component.

ComponentResult SGSetChannelUsage (
   SGChannel    c,
   long         usage );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
usage

Contains flags (see below) specifying how your channel is to be used. The sequence grabber component may set more than one of these flags to 1. It sets unused flags to 0. See these constants: 
seqGrabRecord
seqGrabPreview
seqGrabPlayDuringRecord
seqGrabLowLatencyCapture
seqGrabAlwaysUseTimeBase
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier. Flags added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelUsage (
   SGChannel    c,
   long         usage ){
//TODO
};


/*SGSettingsDialog

Causes a sequence grabber to display its settings dialog box to the user.

ComponentResult SGSettingsDialog (
   SeqGrabComponent         s,
   SGChannel                c,
   short                    numPanels,
   ConstComponentListPtr    panelList,
   long                     flags,
   SGModalFilterUPP         proc,
   long                     procRefNum );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
numPanels

The number of panel components to be listed in the panel component pop-up menu. You specify the panel components with the panelList parameter. You may use these parameters to limit the user's choice of panel components. If you set this parameter to 0 and the panelList parameter to NIL, the sequence grabber lists all available panel components.
panelList

A pointer to an array of component identifiers. The sequence grabber presents only these components in the panel component pop-up menu. You specify the number of identifiers in the array with the numPanels parameter. If you set this parameter to NIL, the sequence grabber lists all available panel components.
flags

Either set this to 0 or to seqGrabSettingsPreviewOnly (see below). See these constants: 
seqGrabSettingsPreviewOnly
proc

Specifies an SGModalFilterProc callback. Because the sequence grabber's settings dialog box is a movable modal dialog box, you must supply an event filter function to process update events in your window.
procRefNum

A reference constant to be passed to your filter callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. If the user clicks OK and the settings are acceptable to the panel and channel components, this function returns a result code of noErr.
Discussion

Because the user may change several channel configuration parameters, your application should retrieve new configuration information from the channel so that you can update any values you save, such as the channel's display boundaries or the channel device. In particular, the video rectangle for the channels may have to be adjusted.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSettingsDialog (
   SeqGrabComponent         s,
   SGChannel                c,
   short                    numPanels,
   ConstComponentListPtr    panelList,
   long                     flags,
   SGModalFilterUPP         proc,
   long                     procRefNum ){
//TODO
};


/*SGGetChannelPlayFlags

Retrieves the playback control flags that you set with SGSetChannelPlayFlags.

ComponentResult SGGetChannelPlayFlags (
   SGChannel    c,
   long         *playFlags );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
playFlags

A pointer to a long integer that is to receive flags (see below) that influence channel playback. Set unused flags to 0. See these constants: 
channelPlayNormal
channelPlayFast
channelPlayHighQuality
channelPlayAllData
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelPlayFlags (
   SGChannel    c,
   long         *playFlags ){
//TODO
};


/*SGSetChannelPlayFlags

Adjusts the speed and quality with which the sequence grabber displays data from a channel.

ComponentResult SGSetChannelPlayFlags (
   SGChannel    c,
   long         playFlags );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
playFlags

A long integer that contains flags (see below) that influence channel playback. A sequence grabber component must use one of these values. See these constants: 
channelPlayNormal
channelPlayFast
channelPlayHighQuality
channelPlayAllData
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelPlayFlags (
   SGChannel    c,
   long         playFlags ){
//TODO
};


/*SGGetChannelUsage

Determines how the sequence grabber component is using a channel.

ComponentResult SGGetChannelUsage (
   SGChannel    c,
   long         *usage );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
usage

A pointer to a location that is to receive flags (see below) that specify how your channel is to be used. You may set more than one of these flags to 1. Set unused flags to 0. See these constants: 
seqGrabRecord
seqGrabPreview
seqGrabPlayDuringRecord
seqGrabLowLatencyCapture
seqGrabAlwaysUseTimeBase
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier. Flags added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelUsage (
   SGChannel    c,
   long         *usage ){
//TODO
};

/*QTMLGrabMutex

Confers ownership of a mutex created by QTMLCreateMutex.

void QTMLGrabMutex (
   QTMLMutex    mu );
Parameters
mu

A mutex object.
Discussion

Call this function when you require exclusive ownership of the resource guarded by a mutex. This function will return when you have gained this ownership. In the case where another thread or process holds the mutex, this function waits until that process or thread relinquishes control. If you need to determine if you can grab the mutex, without actually grabbing it, call QTMLTryGrabMutex.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
void QTMLGrabMutex (
   QTMLMutex    mu ){
//TODO
};


/*QTMLCreateMutex

Creates a synchronization object to facilitate mutually exclusive access to a Windows data structure.

QTMLMutex QTMLCreateMutex ( void );
Discussion

This function creates a mutex object for guarded access to data structures and routines that require mutually exclusive access. In a multithreaded preemptive environment, such as Windows NT, you can use the various mutex utility functions such as QTMLGrabMutex to protect a shared resource from simultaneous access by multiple threads or processes. Mutex objects are used throughout QTML to provide such protection.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
QTMLMutex QTMLCreateMutex ( void ){
//TODO
};


/*QTMLDestroyMutex

Deallocates a synchronization object created by QTMLCreateMutex.

void QTMLDestroyMutex (
   QTMLMutex    mu );
Parameters
mu

A mutex object.
Discussion

Call this function to deallocate the mutex object created by QTMLCreateMutex.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
void QTMLDestroyMutex (
   QTMLMutex    mu ){
//TODO
};


/*QTMLReturnMutex

Releases ownership of a QTMLMutex object.

void QTMLReturnMutex (
   QTMLMutex    mu );
Parameters
mu

A mutex object.
Discussion

Call this function to balance a call to QTMLGrabMutex when you are ready to relinquish control of the mutex and corresponding shared resource. By making this call, you allow other processes or threads waiting for the release of this mutex to gain access.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
void QTMLReturnMutex (
   QTMLMutex    mu ){
//TODO
};


/*SGPrepare

Instructs a sequence grabber to get ready to begin a preview or record operation.

ComponentResult SGPrepare (
   SeqGrabComponent    s,
   Boolean             prepareForPreview,
   Boolean             prepareForRecord );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
prepareForPreview

The sequence grabber component sets this parameter to TRUE to prepare for a preview operation. The sequence grabber component may set both the prepareForPreview and prepareForRecord parameters to TRUE.
prepareForRecord

The sequence grabber component sets this parameter to TRUE to prepare for a record operation. The sequence grabber component may set both the prepareForPreview and prepareForRecord parameters to TRUE.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If you do not call this function before starting a record or preview operation, the sequence grabber component makes these preparations when you start the operation. You cannot call this function after you start a preview or record operation. If you call this function without subsequently starting a record or preview operation, you should call SGRelease. This allows the sequence grabber component to release any system resources it allocated when you called this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGPrepare (
   SeqGrabComponent    s,
   Boolean             prepareForPreview,
   Boolean             prepareForRecord ){
//TODO
};


/*SGStartPreview

Instructs the sequence grabber to begin processing data from its channels.

ComponentResult SGStartPreview (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your channel component should immediately present the data to the user in the appropriate format, according to your channel's configuration. Display video data in the destination display region; play sound data at the specified volume settings.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStartPreview (
   SeqGrabComponent    s ){
//TODO
};


/*QTSoundDescriptionGetProperty

Gets a particular property of a sound description.

OSStatus QTSoundDescriptionGetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
QTPropertyValuePtr         outPropValueAddress,
ByteCount                  *outPropValueSizeUsed);
Parameters
inDesc

The sound description being interrogated.
inPropClass

The class of the property being requested. 
inPropID

The ID of the property being requested.
inPropValueSize

The size of the property value buffer.
outPropValueAddress

A pointer to the property value buffer.
outPropValueSizeUsed

The actual size of the returned property value (can be NULL). 
Return Value

An error code. Returns noErr if there is no error.
Discussion

The following constants identify sound description properties.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionGetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
QTPropertyValuePtr         outPropValueAddress,
ByteCount                  *outPropValueSizeUsed){
//TODO
};

/*SGRelease

Instructs the sequence grabber to release any system resources it allocated when you called SGPrepare.

ComponentResult SGRelease (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You cannot call this function during a record or preview operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGRelease (
   SeqGrabComponent    s ){
//TODO
};
/*MCDoAction

Invokes a movie controller component and makes it perform a specified action.

ComponentResult MCDoAction (
   MovieController    mc,
   short              action,
   void               *params );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
action

The action to be taken. See Movie Controller Actions.
params

A pointer to the parameter data appropriate to the action. See Movie Controller Actions for information about the parameters required for each supported action.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCDoAction (
   MovieController    mc,
   short              action,
   void               *params ){
//TODO
};


/*ExitMoviesOnThread

Indicates to QuickTime that the client will no longer be using QuickTime on the current thread.

OSErr ExitMoviesOnThread (void);
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns an appropriate operating system or QuickTime error if the operation couldn't be completed. This might occur because a previous call to EnterMoviesOnThread was not made.
Discussion

This function should be called before exiting from a spawned thread that uses QuickTime. It undoes the setup performed by EnterMoviesOnThread. Each call to EnterMoviesOnThread should be matched with a call to this function. This function should not be called on a thread without a previous call to EnterMoviesOnThread.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr ExitMoviesOnThread (void){
//TODO
};


/*EnterMoviesOnThread

Indicates that the client will be using QuickTime on the current thread.

OSErr EnterMoviesOnThread (UInt32 inFlags);
Parameters
inFlags

Flag (see below) indicating how the executing thread will use QuickTime. Setting the thread mode is a convenience provided by this function. Pass 0 for the default options. See these constants: 
kQTEnterMoviesFlagDontSetComponentsThreadMode
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. This function returns an appropriate operating system or QuickTime error if the operation couldn't be completed. This might occur because a second call on the thread was made that used incompatible flags (for example, the first call required a shared state but a subsequent call required a private state).
Discussion

This function is analogous to EnterMovies. It initializes QuickTime and prepares QuickTime for calls from its thread. Unlike EnterMovies, this function allows the client to indicate if its access to QuickTime requires sharing of QuickTime state with the main thread. The default is to maintain a private state. 
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr EnterMoviesOnThread (UInt32 inFlags){
//TODO
};

/*QTNewAlias

Creates a Mac OS alias to a file.

OSErr QTNewAlias (
   const FSSpec    *fss,
   AliasHandle     *alias,
   Boolean         minimal );
Parameters
fss

A pointer to an FSSpec structure that specifies a file.
alias

On return, a pointer to a handle to a new AliasRecord structure that defines an alias to the file. If the function was unable to create an alias, the handle is set to NIL. This function does not create relative aliases. For further information about Mac OS file aliases, see Chapter 4 of Inside Macintosh: Files.
minimal

If you pass TRUE, the function writes in the AliasRecord structure only the target name, parent directory ID, volume name and creation date, and volume mounting information. If you pass FALSE, it fills out the structure fully.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTNewAlias (
   const FSSpec    *fss,
   AliasHandle     *alias,
   Boolean         minimal ){
//TODO
};


/*GraphicsImportDraw

Draws an imported image.

ComponentResult GraphicsImportDraw (
   GraphicsImportComponent    ci );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function draws the image currently in use by the graphics import component to the graphics port and device specified by GraphicsImportSetGWorld. GraphicsImportDraw takes into account all settings previously specified for the image, such as the source rectangle, transformation matrix, clipping region, graphics mode, and image quality.
Special Considerations

The base graphics importer's drawing function uses the results of GraphicsImportGetImageDescription and GraphicsImportGetDataOffsetAndSize to create a decompression sequence, which it uses to draw the image. Subsequent draw operations with the same connection may reuse the decompression sequence. Other graphics importers may override this behavior.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportDraw (
   GraphicsImportComponent    ci ){
//TODO
};

/*GraphicsImportSetProgressProc

Installs a progress procedure to call while drawing an imported image.

ComponentResult GraphicsImportSetProgressProc (
   GraphicsImportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
progressProc

Points to an ICMProgressProc callback. If you pass a value of -1, QuickTime provides a standard progress function. If you want to remove the existing progress function, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets a progress function that will be installed in the image decompression sequence used to draw the image.
Special Considerations

If your progress function does any drawing, you should take care to set a safe graphics state before doing so, and to restore the graphics state afterwards. In particular, the current graphics device may be an offscreen device.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetProgressProc (
   GraphicsImportComponent     ci,
   ICMProgressProcRecordPtr    progressProc ){
//TODO
};


/*GraphicsImportSetGWorld

Sets the graphics port and device for drawing an imported image.

ComponentResult GraphicsImportSetGWorld (
   GraphicsImportComponent    ci,
   CGrafPtr                   port,
   GDHandle                   gd );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
port

A pointer to the CGrafPort structure that defines the destination graphics port or graphics world. Set to NIL to use the current port.
gd

A handled to the GDevice structure that defines the destination graphics device. Set to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's device.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The graphics world is initialized to the current port and device when the graphics importer component is opened. Use this function to select another port or device.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetGWorld (
   GraphicsImportComponent    ci,
   CGrafPtr                   port,
   GDHandle                   gd ){
//TODO
};


/*GraphicsImportSetBoundsRect

Defines the rectangle in which to draw an imported image.

ComponentResult GraphicsImportSetBoundsRect (
   GraphicsImportComponent    ci,
   const Rect                 *bounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
bounds

A pointer to a Rect structure that describes the bounding rectangle into which the image will be drawn.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You use this function to define the rectangle into which the graphics image should be drawn. The function creates a transformation matrix to map the image's natural bounds to the specified bounds and then calls GraphicsImportSetMatrix.
Special Considerations

Because this function affects the transformation matrix, you should use GraphicsImportSetMatrix instead of this function if you also need to specify more complex transformations of the matrix.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetBoundsRect (
   GraphicsImportComponent    ci,
   const Rect                 *bounds ){
//TODO
};

/*GraphicsImportGetNaturalBounds

Returns the bounding rectangle of an imported image.

ComponentResult GraphicsImportGetNaturalBounds (
   GraphicsImportComponent    ci,
   Rect                       *naturalBounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
naturalBounds

A pointer to a Rect structure that describes the size of the bounding rectangle for the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to determine the native size of the image associated with a graphics importer component. The natural bounds are always zero-based. This is a convenience function that simply calls GraphicsImportGetImageDescription and extracts the width and height fields.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetNaturalBounds (
   GraphicsImportComponent    ci,
   Rect                       *naturalBounds ){
//TODO
};


/*NewICMProgressUPP

Allocates a Universal Procedure Pointer for the ICMProgressProc callback.

ICMProgressUPP NewICMProgressUPP (
   ICMProgressProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewICMProgressProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ICMProgressUPP NewICMProgressUPP (
   ICMProgressProcPtr    userRoutine ){
//TODO
};

/*GetGraphicsImporterForDataRef

Locates and opens a graphics importer component that can be used to draw the image from specified data reference.

OSErr GetGraphicsImporterForDataRef (
   Handle               dataRef,
   OSType               dataRefType,
   ComponentInstance    *gi );
Parameters
dataRef

The data reference to be drawn using a graphics importer component.
dataRefType

The type of data reference pointed to by the dataRef parameter; see Data References. For alias-based data references, the dataRef handle contains an AliasRecord and dataRefType is set to rAliasType.
gi

On return, contains a pointer to the ComponentInstance of the graphics importer. If no graphics importer can be found, this parameter will be set to NIL. If GetGraphicsImporterForDataRef is able to locate a graphics importer for the data reference, the returned graphics importer ComponentInstance will already be set up to draw from the specified data reference to the current port.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function tries to locate a graphics importer component for the specified data reference by checking the file extension (such as .GIF or .JPG), the Macintosh file type, and the MIME type of the file. The file extension is retrieved from the data reference by using DataHGetFileName to call the data handler associated with the data reference. If a graphics importer cannot be found using the file's type, file extension, or MIME type, GetGraphicsImporterForDataRef asks each graphics importer to validate the file, until it either finds an importer that can handle the file or exhausts the list of possible importers. This validation attempt can be quite time-consuming; to bypass it, call GetGraphicsImporterForDataRefWithFlags instead.
Special Considerations

The caller of GetGraphicsImporterForDataRef is responsible for closing the returned ComponentInstance using CloseComponent. You must call CloseComponent when you are finished with the importer.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr GetGraphicsImporterForDataRef (
   Handle               dataRef,
   OSType               dataRefType,
   ComponentInstance    *gi ){
//TODO
};


/*GraphicsExportDoExport

Performs a graphics export operation.

ComponentResult GraphicsExportDoExport (
   GraphicsExportComponent    ci,
   unsigned long              *actualSizeWritten );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
actualSizeWritten

Points to a variable to receive the number of bytes written. If you are not interested in this information, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before calling this function , you must specify an input image, using one of the GraphicsExportSetInput... functions, and a destination for the output image file, using one of the GraphicsExportSetOutput... functions.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportDoExport (
   GraphicsExportComponent    ci,
   unsigned long              *actualSizeWritten ){
//TODO
};

/*GraphicsImportSetQuality

Sets the image quality value for an imported image.

ComponentResult GraphicsImportSetQuality (
   GraphicsImportComponent    ci,
   CodecQ                     quality );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
quality

Contains a constant (see below) that defines the desired image quality for decompression. Values for this parameter are on the same scale as compression quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The quality parameter controls how precisely the decompressor decompresses the image data. Some decompressors may choose to ignore some image data to improve decompression speed.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetQuality (
   GraphicsImportComponent    ci,
   CodecQ                     quality ){
//TODO
};


/*GraphicsExportSetProgressProc

Installs a progress function in a graphics export operation.

ComponentResult GraphicsExportSetProgressProc (
   GraphicsExportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
progressProc

Points to an ICMProgressProc callback. If you pass a value of -1, QuickTime provides a standard progress function. If you want to remove the existing progress function, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is always implemented by the base graphics exporter.
Special Considerations

If your progress function does any drawing, you should take care to set a safe graphics state before doing so, and to restore the graphics state afterwards. In particular, the current graphics device may be an offscreen device.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetProgressProc (
   GraphicsExportComponent     ci,
   ICMProgressProcRecordPtr    progressProc ){
//TODO
};

/*GraphicsExportSetCompressionQuality

Defines the compression quality for a graphics export operation.

ComponentResult GraphicsExportSetCompressionQuality (
   GraphicsExportComponent    ci,
   CodecQ                     spatialQuality );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
spatialQuality

A constant (see below) that defines the currently specified quality value. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This setting is only supported by lossy compression methods.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetCompressionQuality (
   GraphicsExportComponent    ci,
   CodecQ                     spatialQuality ){
//TODO
};


/*GraphicsExportSetOutputFile

Defines the output file for a graphics export operation.

ComponentResult GraphicsExportSetOutputFile (
   GraphicsExportComponent    ci,
   const FSSpec               *theFile );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
theFile

an FSSpec structure that identifies the file.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetOutputFile (
   GraphicsExportComponent    ci,
   const FSSpec               *theFile ){
//TODO
};

/*GraphicsExportSetInputGraphicsImporter

Specifies that the source image for a graphics export operation is to be drawn by a graphics importer instance.

ComponentResult GraphicsExportSetInputGraphicsImporter (
   GraphicsExportComponent    ci,
   GraphicsImportComponent    grip );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
grip

The source graphics importer component instance.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You can use this function to specify a source before you call GraphicsExportDoExport. The source can be a QuickTime graphics importer component instance, a QuickDraw Picture, a graphics world, a PixMap structure, or a piece of compressed data described by an ImageDescription structure. Compressed data can be in a file, handle, pointer, or other data reference. The application must make sure that the source is not disposed of before the graphics exporter instance is closed or given a new source. All of the get and set functions for these sources are implemented by the base graphics exporter; format-specific importers should delegate all of them.
Special Considerations

It is the caller's responsibility to dispose of the graphics importer.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetInputGraphicsImporter (
   GraphicsExportComponent    ci,
   GraphicsImportComponent    grip ){
//TODO
};


/*QTLockContainer

Locks an atom container in memory.

OSErr QTLockContainer (
   QTAtomContainer    container );
Parameters
container

The atom container to be locked.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You should call this function to lock an atom container before calling QTGetAtomDataPtr to directly access a leaf atom's data. When you have finished accessing a leaf atom's data, you should call QTUnlockContainer. You may make nested pairs of calls to QTLockContainer and QTUnlockContainer; you don't need to check the current state of the container first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTLockContainer (
   QTAtomContainer    container ){
//TODO
};


/*QTFindChildByIndex

Retrieves an atom by index from the child list of the specified parent atom.

QTAtom QTFindChildByIndex (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   short              index,
   QTAtomID           *id );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
atomType

The type of the atom to be retrieved.
index

The index of the atom to be retrieved.
id

A pointer to an uninitialized QTAtomID data structure. On return, if the atom specified by index was found, the QTAtomID data structure contains the atom's ID. If you don't want this function to return the atom's ID, set the value of the id parameter to NIL.
Return Value

The found atom.
Discussion

You call this function to search for and retrieve an atom by its type and index within that type from a parent atom's child list. The following code illustrates one way to use it:// QTFindChildByIndex coding example
if ((propertyAtom =QTFindChildByIndex (sprite, kParentAtomIsContainer,
    kSpritePropertyImageIndex, 1, NIL)) ==0)
    FailOSErr (QTInsertChild (sprite, kParentAtomIsContainer,
        kSpritePropertyImageIndex, 1, 1, sizeof(short),&imageIndex,
        NIL));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
QTAtom QTFindChildByIndex (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   short              index,
   QTAtomID           *id ){
//TODO
};


/*QTGetAtomDataPtr

Retrieves a pointer to the atom data for a specified leaf atom.

OSErr QTGetAtomDataPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   long               *dataSize,
   Ptr                *atomData );
Parameters
container

The atom container that contains the leaf atom.
atom

The leaf atom whose data should be retrieved.
dataSize

On return, contains a pointer to the length, in bytes, of the leaf atom's data.
atomData

On return, contains a pointer to the leaf atom's data.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function in retrieve a pointer to a leaf atom's data so that you can access the data directly.
Special Considerations

To ensure that the pointer returned in the atomData parameter will remain valid if memory is moved, you should call QTLockContainer before you call this function. If you call QTLockContainer, you should call QTUnlockContainer when you have finished using the atomData pointer. If you pass a locked atom container to a function that resizes atom containers, the function returns an error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetAtomDataPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   long               *dataSize,
   Ptr                *atomData ){
//TODO
};


/*QTUnlockContainer

Unlocks an atom container in memory.

OSErr QTUnlockContainer (
   QTAtomContainer    container );
Parameters
container

The atom container to be unlocked.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You should call this function to unlock an atom container when you have finished accessing a leaf atom's data. You may make nested pairs of calls to QTLockContainer and this function; you don't need to check the current state of the container first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTUnlockContainer (
   QTAtomContainer    container ){
//TODO
};


/*QTDisposeAtomContainer

Disposes of an atom container.

OSErr QTDisposeAtomContainer (
   QTAtomContainer    atomData );
Parameters
atomData

The atom container to be disposed of.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to dispose of an atom container data structure that was created by QTNewAtomContainer or QTCopyAtom.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTDisposeAtomContainer (
   QTAtomContainer    atomData ){
//TODO
};

/*GraphicsExportGetMIMETypeList

Returns MIME types and other information about the graphics format in a graphics export operation.

ComponentResult GraphicsExportGetMIMETypeList (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
qtAtomContainerPtr

Receives a newly-created QuickTime atom container that contains information about the graphics format.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates and returns a QuickTime atom container that contains the format's name, as a string in an atom of type 'desc' (kMimeInfoDescriptionTag), and optionally the MIME type as a string in an atom of type 'mime'[atom] (kMimeInfoMimeTypeTag).
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsExportGetMIMETypeList (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr ){
//TODO
};

/*GraphicsExportGetDefaultFileNameExtension

Returns the suggested file name extension for a graphics export operation.

ComponentResult GraphicsExportGetDefaultFileNameExtension (
   GraphicsExportComponent    ci,
   OSType                     *fileNameExtension );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
fileNameExtension

Points to a location to receive the file name extension.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

File name extensions are returned as upper-case big-endian four-character codes. For example, the extension .png would be returned as 'PNG ' (0x504E4720).
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportGetDefaultFileNameExtension (
   GraphicsExportComponent    ci,
   OSType                     *fileNameExtension ){
//TODO
};


/*NewMovieFromProperties

Creates a new movie using movie properties.

OSStatus NewMovieFromProperties (
ItemCount                    inputPropertyCount,
QTNewMoviePropertyElement    *inputProperties,
ItemCount                    outputPropertyCount,
QTNewMoviePropertyElement    *outputProperties,
Movie                        *theMovie );
Parameters
inputPropertyCount

The number of properties in the array passed in inputProperties.
inputProperties

A pointer to a property array describing how to instantiate the movie. See QTNewMoviePropertyElement.
outputPropertyCount

The number of properties in the array passed in outputProperties.
outputProperties

A pointer to a property array to receive output parameters. See QTNewMoviePropertyElement. You may pass NULL if you don't want this information. The caller is responsible for calling the appropriate routines to dispose of any property values returned here. Since callers specify the property classes and IDs, they know who to call to dispose of the property values.
theMovie

A pointer to a variable that receives the new movie.
Return Value

An error code. Returns memFullErr if the function could not allocate memory, paramErr if inputProperties or theMovie is NULL, or noErr if there is no error.
Discussion

This function can be used in all the cases where an existing NewMovieFrom... call is used. When calling this function, you supply a set of input properties that describe the information required to instantiate the movie (its data reference, audio context, visual context, and so on). You can also supply a set of output properties that you may be interested in; for example, information about whether the data reference was changed. See New Movie Property Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus NewMovieFromProperties (
ItemCount                    inputPropertyCount,
QTNewMoviePropertyElement    *inputProperties,
ItemCount                    outputPropertyCount,
QTNewMoviePropertyElement    *outputProperties,
Movie                        *theMovie ){
//TODO
};


/*GoToBeginningOfMovie

Repositions a movie to play from its start.

void GoToBeginningOfMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Discussion

If the movie is in preview mode, the function goes to the start of the preview segment of the movie. In all other cases, this function goes to the start of the movie, where the movie time value is 0. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GoToBeginningOfMovie (
   Movie    theMovie ){
//TODO
};

/*GetMovieTimeBase

Returns a movie's time base.

TimeBase GetMovieTimeBase (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's TimeBaseRecord structure.
Special Considerations

The Movie Toolbox disposes of a movie's time base when you dispose of the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeBase GetMovieTimeBase (
   Movie    theMovie ){
//TODO
};


/*StopMovie

Stops the playback of a movie.

void StopMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void StopMovie (
   Movie    theMovie ){
//TODO
};


/*GetTrackMedia

Determines the media that contains a track's sample data.

Media GetTrackMedia (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The media identifier for the media that contains the track's sample data. If the function could not locate the media, it sets this returned value to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Media GetTrackMedia (
   Track    theTrack ){
//TODO
};


/*SetTimeBaseFlags

Sets the contents of the control flags of a time base.

void SetTimeBaseFlags (
   TimeBase    tb,
   long        timeBaseFlags );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
timeBaseFlags

The control flags for this time base (see below). You may set only one flag to 1. Be sure to set unused flags to 0. See these constants: 
loopTimeBase
palindromeLoopTimeBase
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTimeBaseFlags (
   TimeBase    tb,
   long        timeBaseFlags ){
//TODO
};

/*SetMoviePlayHints

Provides information to the Movie Toolbox that can influence movie playback.

void SetMoviePlayHints (
   Movie    theMovie,
   long     flags,
   long     flagsMask );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
flags

The optimizations that can be used with this movie. Each bit in the flags parameter corresponds to a specific optimization (see below). Be sure to set unused flags to 0. See these constants: 

hintsScrubMode

hintsUseSoundInterp

hintsAllowInterlace

hintsAllowBlacklining

hintsDontPurge

hintsInactive

hintsHighQuality
flagsMask

Indicates which flags in the flags parameter are to be considered in this operation. For each bit in the flags parameter that you want the Movie Toolbox to consider, you must set the corresponding bit in the flagsMask parameter to 1. Set unused flags to 0. This allows you to work with a single optimization without altering the settings of other flags.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

This function accepts a flag in which you specify optimizations that the Movie Toolbox can use during movie playback. These optimizations apply to all of the media structures used by the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMoviePlayHints (
   Movie    theMovie,
   long     flags,
   long     flagsMask ){
//TODO
};

int GetMovieTrackCount(int a){
//TODO
};

int GetMovieIndTrack(int a, int b){
//TODO
};

int GetMediaHandlerDescription(int a, int b, int c, int d){
//TODO
};


/*SetTimeBaseMasterTimeBase

Assigns a master time base to a time base.

void SetTimeBaseMasterTimeBase (
   TimeBase            slave,
   TimeBase            master,
   const TimeRecord    *slaveZero );
Parameters
slave

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
master

The master time base to be assigned to this time base. Your application obtains this time base identifier from NewTimeBase.
slaveZero

A pointer to the time, in the time scale of the master time base, that corresponds to a 0 time value for the slave time scale. This parameter allows you to set an offset between the time base and the master time base. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A time base derives its time from either a clock component or another time base. Don't use this function to assign a master time base to a movie's time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTimeBaseMasterTimeBase (
   TimeBase            slave,
   TimeBase            master,
   const TimeRecord    *slaveZero ){
//TODO
};


/*SetTrackEnabled

Enables or disables a track.

void SetTrackEnabled (
   Track      theTrack,
   Boolean    isEnabled );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
isEnabled

Enables or disables the track. Set this parameter to TRUE to enable the track. Set this parameter to FALSE to disable the track.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox services only enabled tracks.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTrackEnabled (
   Track      theTrack,
   Boolean    isEnabled ){
//TODO
};


/*SetMovieRate

Sets a movie's playback rate.

void SetMovieRate (
   Movie    theMovie,
   Fixed    rate );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
rate

The new movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates. This value immediately changes the rate at which the movie is playing. A value of 1 starts the movie playing at normal speed, a value of 2 causes the movie to play at double speed, -2 starts the movie playing backward at double speed, and so on. A value of 0 stops the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

Use this function to change the speed at which a movie is playing. You do not normally use this function to start and stop movies; use the higher level functions StartMovie and StopMovie instead. If you start a movie using this function, you should call PrePrerollMovie and PrerollMovie first, to set up any network connections, buffers, and data structures necessary to play the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieRate (
   Movie    theMovie,
   Fixed    rate ){
//TODO
};


/*QTMetaDataRelease

Decrements the retain count of a metadata object.

void QTMetaDataRelease ( QTMetaDataRef inMetaData );
Discussion

This function releases a metadata object by decrementing its reference count. When the count becomes 0 the memory allocated to the object is freed and the object is destroyed. If you retain a metadata object you are responsible for releasing it when you no longer need it.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void QTMetaDataRelease ( QTMetaDataRef inMetaData ){
//TODO
};

/*QTMetaDataGetItemProperty

Returns a property of a metadata item.

OSStatus QTMetaDataGetItemProperty (
QTMetaDataRef         inMetaData,
QTMetaDataItem        inItem,
QTPropertyClass       inPropClass,
QTPropertyID          inPropID,
ByteCount             inPropValueSize,
QTPropertyValuePtr    outPropValueAddress,
ByteCount             *outPropValueSizeUsed );
Parameters
inMetaData

The metadata object for this operation.
inItem

The opaque, unique UInt64 identifier of the metadata item for this operation. Your application obtains this item identifier from such functions as QTMetaDataAddItem and QTMetaDataGetNextItem.
inPropClass

The class of the property being asked about.
inPropID

The ID of the property being asked about.
inPropValueSize

Size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the item's property value.
outPropValueSizeUsed

On return, the actual size of buffer space used.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, errPropNotSupported if the metatada object does not support the property being asked about, buffersTooSmall if the allocated buffer is too small to hold the property, or noErr if there is no error. See Metadata Error Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetItemProperty (
QTMetaDataRef         inMetaData,
QTMetaDataItem        inItem,
QTPropertyClass       inPropClass,
QTPropertyID          inPropID,
ByteCount             inPropValueSize,
QTPropertyValuePtr    outPropValueAddress,
ByteCount             *outPropValueSizeUsed ){
//TODO
};


/*QTMetaDataGetItemPropertyInfo

Returns information about a property of a metadata item.

OSStatus QTMetaDataGetItemPropertyInfo (
QTMetaDataRef          inMetaData,
QTMetaDataItem         inItem,
QTPropertyClass        inPropClass,
QTPropertyID           inPropID,
QTPropertyValueType    *outPropType,
ByteCount              *outPropValueSize,
UInt32                 *outPropFlags );
Parameters
inMetaData

The metadata object for this operation.
inItem

The opaque, unique UInt64 identifier of the metadata item for this operation. Your application obtains this item identifier from such functions as QTMetaDataAddItem and QTMetaDataGetNextItem.
inPropClass

The class of the property being asked about.
inPropID

The ID of the property being asked about.
outPropType

A pointer to the type of the returned property's value.
outPropValueSize

A pointer to the size of the returned property's value.
outPropFlags

On return, a pointer to flags representing the requested information about the item's property.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, errPropNotSupported if the metatada object does not support the item property being asked about, or noErr if there is no error. See Metadata Error Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetItemPropertyInfo (
QTMetaDataRef          inMetaData,
QTMetaDataItem         inItem,
QTPropertyClass        inPropClass,
QTPropertyID           inPropID,
QTPropertyValueType    *outPropType,
ByteCount              *outPropValueSize,
UInt32                 *outPropFlags ){
//TODO
};

/*QTMetaDataGetNextItem

Returns the next metadata item corresponding to a specified key.

OSStatus QTMetaDataGetNextItem (
QTMetaDataRef              inMetaData,
QTMetaDataStorageFormat    inMetaDataFormat,
QTMetaDataItem             inCurrentItem,
QTMetaDataKeyFormat        inKeyFormat,
const UInt8                *inKeyPtr,
ByteCount                  inKeySize,
QTMetaDataItem             *outNextItem );
Parameters
inMetaData

The metadata object for this operation.
inMetaDataFormat

The metadata storage format used by the object passed in inMetaData. The format may be UserData storage, iTunes metadata storage, or QuickTime metadata storage. Not all objects will include all forms of storage, and other storage formats may appear in the future. Pass kQTMetaDataStorageFormatWildcard to target all storage formats.
inCurrentItem

The opaque, unique UInt64 identifier of the current metadata item to start the search. Your application obtains this item identifier from such functions as QTMetaDataAddItem.
inKeyFormat

The format of the key.
inKeyPtr

A pointer to the key of the item to be fetched next. You may pass NULL in this parameter if you are not interested in any specific key.
inKeySize

The size of the key in bytes.
outNextItem

The ID of the next metadata item after the item specified by inCurrentItem that has the specified key.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, kQTMetaDataInvalidStorageFormatErr if the metatada storage format is invalid, kQTMetaDataInvalidKeyErr if the key or its format is invalid, kQTMetaDataNoMoreItemErr if the last item has been fetched, or noErr if there is no error. See Metadata Error Codes.
Discussion

If the item designated by inCurrentItem is kQTMetaDataItemUninitialized, the function returns the first item with the specified key in the storage format. If it refers to a valid item in the storage format, the function will return the next item with the key after the item designated by inCurrentItem.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetNextItem (
QTMetaDataRef              inMetaData,
QTMetaDataStorageFormat    inMetaDataFormat,
QTMetaDataItem             inCurrentItem,
QTMetaDataKeyFormat        inKeyFormat,
const UInt8                *inKeyPtr,
ByteCount                  inKeySize,
QTMetaDataItem             *outNextItem ){
//TODO
};


/*QTCopyMovieMetaData

Retains a movie's metadata object and returns it.

OSStatus QTCopyMovieMetaData (
Movie            inMovie,
QTMetaDataRef    *outMetaData );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
outMetaData

A pointer to an opaque metadata object wrapper associated with the movie passed in inMovie.
Return Value

Returns invalidMovie if the movie passed in inMovie is invalid, or noErr if there is no error. 
Discussion

This function returns the metadata object associated with a movie. The object has retain/release semantics. It has already been retained before returning, but you should call QTMetaDataRelease when you are done. Because the movie can be disposed of at any time, the QTMetaDataRef may be valid when the movie no longer exists. In this case, the function will fail with a kQTMetaDataInvalidMetaDataErr error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTCopyMovieMetaData (
Movie            inMovie,
QTMetaDataRef    *outMetaData ){
//TODO
};


/*GetMovieTimeScale

Returns the time scale of a movie.

TimeScale GetMovieTimeScale (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A long integer that contains the movie's time scale.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeScale GetMovieTimeScale (
   Movie    theMovie ){
//TODO
};


/*GetMovieIndTrackType

Searches for all of a movie's tracks that share a given media type or media characteristic.

Track GetMovieIndTrackType (
   Movie     theMovie,
   long      index,
   OSType    trackType,
   long      flags );
Parameters
theMovie

The movie for this operation. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
index

The index value of the track for this operation. This is not that same as the track's index value in the movie. Rather, this parameter is an index into the set of tracks that meet your other selection criteria.
trackType

Contains either a media type or a media characteristic value. The toolbox applies this value to the search, and returns information about tracks that meet this criterion. You indicate whether you have specified a media type or characteristic value by setting the flags parameter appropriately.
flags

Contains flags (see below) that control the search operation. Note that you may not set both movieTrackMediaType and movieTrackCharacteristic to 1. See these constants: 
movieTrackMediaType
movieTrackCharacteristic
movieTrackEnabledOnly
Return Value

A track identifier.
Discussion

The toolbox returns the track identifier that corresponds to the track that meets your selection criteria. If the toolbox cannot find a matching track, in returns a value of NIL. Note that the index parameter does not work the same way that is does in GetMovieIndTrack. With GetMovieIndTrackType, the index parameter specifies an index into the set of tracks that meet your other selection criteria. For example, in order to find the third track that supports the sound characteristic, you would call the function in the following manner:theTrack =GetMovieIndTrackType (theMovie, 3, AudioMediaCharacteristic, movieTrackCharacteristic);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track GetMovieIndTrackType (
   Movie     theMovie,
   long      index,
   OSType    trackType,
   long      flags ){
//TODO
};


/*GetMediaDecodeDuration

Returns the decode duration of a media.

TimeValue64 GetMediaDecodeDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's decode duration. A media's decode duration is the sum of the decode durations of its samples.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 GetMediaDecodeDuration (
   Media    theMedia ){
//TODO
};


/*GetMediaDisplayDuration

Returns the display duration of a media.

TimeValue64 GetMediaDisplayDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's display duration. A media's display duration is its display end time minus its display start time. For media without nonzero display offsets, the decode duration and display duration are the same.
Discussion

When inserting media with display offsets into a track, use display time:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 GetMediaDisplayDuration (
   Media    theMedia ){
//TODO
};

/*GetMediaSampleCount

Determines the number of samples in a media.

long GetMediaSampleCount (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

The number of samples in the media.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetMediaSampleCount (
   Media    theMedia ){
//TODO
};

/*GetMediaTimeScale

Determines a media's time scale.

TimeScale GetMediaTimeScale (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The media's time scale.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeScale GetMediaTimeScale (
   Media    theMedia ){
//TODO
};


/*GetTrackDuration

Returns the duration of a track.

TimeValue GetTrackDuration (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The duration of the specified track, expressed in the time scale of the movie that contains the track.
Discussion

The duration corresponds to the ending time of the track in the movie's time coordinate system (remember that all tracks start at movie time 0).
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetTrackDuration (
   Track    theTrack ){};


/*GetMediaSampleDescription

Retrieves a SampleDescription structure from a media.

void GetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
index

The index of the SampleDescription structure to retrieve. This index corresponds to the structure itself, not to the samples in the media. Index numbers start with 1.
descH

Specifies a handle that is to receive the SampleDescription structure. The Movie Toolbox correctly resizes this handle for the returned structure. If there is no description for the specified index, the function returns this handle unchanged. Your application must allocate and dispose of this handle.
Discussion

The Movie Toolbox identifies a media's sample descriptions with an index value, ranging from 1 to the number of sample descriptions in the media. Sample description indexes provide a convenient way to access each sample description in a media. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Special Considerations

The format of sample descriptions differs by media type. Sample descriptions for image data are defined by ImageDescription structures. Sample descriptions for sound are defined by SoundDescription structures. Sample descriptions for text are defined by TextDescription structures.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH ){
//TODO
};

/*SampleNumToMediaDecodeTime

Finds the decode time for a specified sample.

void SampleNumToMediaDecodeTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
logicalSampleNum

A 64-bit signed integer that contains the sample number.
sampleDecodeTime

A pointer to a time value. The function updates this time value to indicate the decode time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDecodeDuration

A pointer to a time value. The function updates this time value to indicate the decode duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void SampleNumToMediaDecodeTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration ){};


/*MediaDecodeTimeToSampleNum

Finds the sample for a specified decode time.

void MediaDecodeTimeToSampleNum (
   Media          theMedia,
   TimeValue64    decodeTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
decodeTime

A 64-bit time value that represents the decode time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a variable that is to receive the sample number. The function returns the sample number that identifies the sample that contains data for the specified decode time, or 0 if it is not found.
sampleDecodeTime

A pointer to a time value. The function updates this time value to indicate the decode time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDecodeDuration

A pointer to a time value. The function updates this time value to indicate the decode duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, invalidTime if sampleDecodeTime is out of the decode time range, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void MediaDecodeTimeToSampleNum (
   Media          theMedia,
   TimeValue64    decodeTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration ){};


/*GetMediaSample2

Retrieves sample data from a media file.

OSErr GetMediaSample2 (
   Media                      theMedia,
   UInt8                      *dataOut,
   ByteCount                  maxDataSize,
   ByteCount                  *size,
   TimeValue64                decodeTime,
   TimeValue64                *sampleDecodeTime,
   TimeValue64                *decodeDurationPerSample,
   TimeValue64                *displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  *sampleDescriptionIndex,
   ItemCount                  maxNumberOfSamples,
   ItemCount                  *numberOfSamples,
   MediaSampleFlags           *sampleFlags );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
dataOut

A pointer to a buffer to receive sample data. The buffer must be large enough to contain at least maxDataSize bytes. If you do not want to receive sample data, pass NULL.
maxDataSize

The maximum number of bytes allocated to hold the sample data.
size

A pointer to memory where the function returns the number of bytes of sample data returned in the memory area specified by dataOut. Set this parameter to NULL if you are not interested in this information.
decodeTime

The starting time of the sample to be retrieved in decode time. You must specify this value in the media's time scale.
sampleDecodeTime

A pointer to a time value in decode time. The function updates this time value to indicate the actual time of the returned sample data. (The returned time may differ from the time you specified with the time parameter. This will occur if the time you specified falls in the middle of a sample.) If you are not interested in this information, set this parameter to NULL.
decodeDurationPerSample

A pointer to a time value in decode time. The Movie Toolbox returns the duration of each sample in the media. Set this parameter to NULL if you don't want this information.
displayOffset

A pointer to a time value. The function updates this time value to indicate the display offset of the returned sample. This time value is expressed in the media's time scale. Set this parameter to NULL if you don't want this information.
sampleDescriptionH

A handle to a SampleDescription structure. The function returns the sample description corresponding to the returned sample data. The function resizes this handle as appropriate. If you don't want a SampleDescription structure, set this parameter to NIL.
sampleDescriptionIndex

A pointer to a long integer. The function returns an index value to the SampleDescription structure that corresponds to the returned sample data. You can retrieve the structure by calling GetMediaSampleDescription and passing this index in the descH parameter. If you don't want this information, set this parameter to NIL.
maxNumberOfSamples

The maximum number of samples to be returned. The Movie Toolbox does not return more samples than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media, and returns that value in the field referenced by the numberOfSamples parameter.
numberOfSamples

A pointer to a long integer. The function updates the field referred to by this parameter with the number of samples it actually returns. If you don't want this information, set this parameter to NULL.
sampleFlags

A pointer to a short integer in which the function returns flags that describe the sample. Unused flags are set to 0. If you don't want this information, set this parameter to NULL: mediaSampleNotSync This flag is set to 1 if the sample is not a sync sample and to 0 if the sample is a sync sample. See these constants: 
mediaSampleNotSync
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, maxSizeToGrowTooSmall if the sample data is larger than maxDataSize, or noErr if there is no error.
Discussion

Whereas GetMediaSample takes a resizable Handle and a maxSizeToGrow parameter, GetMediaSample2 takes a pointer and a maxDataSize parameter. If you want to read a sample into a Handle, you can use the following code:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr GetMediaSample2 (
   Media                      theMedia,
   UInt8                      *dataOut,
   ByteCount                  maxDataSize,
   ByteCount                  *size,
   TimeValue64                decodeTime,
   TimeValue64                *sampleDecodeTime,
   TimeValue64                *decodeDurationPerSample,
   TimeValue64                *displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  *sampleDescriptionIndex,
   ItemCount                  maxNumberOfSamples,
   ItemCount                  *numberOfSamples,
   MediaSampleFlags           *sampleFlags ){};


/*GetMediaNextInterestingDecodeTime

Searches for decode times of interest in a media.

void GetMediaNextInterestingDecodeTime (
   Media          theMedia,
   short          interestingTimeFlags,
   TimeValue64    decodeTime,
   Fixed          rate,
   TimeValue64    *interestingDecodeTime,
   TimeValue64    *interestingDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
interestingTimeFlags

Flags that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, or nextTimeSyncSample flags to 1. Set unused flags to 0: nextTimeMediaSample Set this flag to 1 to search for the next sample. nextTimeMediaEdit Set this flag to 1 to search for the next group of samples. nextTimeSyncSample Set this flag to 1 to search for the next sync sample. nextTimeEdgeOK Set this flag to 1 to accept information about elements that begin or end at the time specified by the decodeTime parameter. When this flag is set the function returns valid information about the beginning and end of a media. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeSyncSample
nextTimeEdgeOK
decodeTime

Specifies the starting point for the search in decode time. This time value must be expressed in the media's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingDecodeTime

On return, a pointer to a 64-bit time value in decode time. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the media's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NULL if you are not interested in this information.
interestingDecodeDuration

On return, a pointer to a 64-bit time value in decode time. The Movie Toolbox returns the duration of the interesting time in the media's time coordinate system. Set this parameter to NULL if you don't want this information; this lets the function works faster.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void GetMediaNextInterestingDecodeTime (
   Media          theMedia,
   short          interestingTimeFlags,
   TimeValue64    decodeTime,
   Fixed          rate,
   TimeValue64    *interestingDecodeTime,
   TimeValue64    *interestingDecodeDuration ){};

/*GetTrackMovie

Determines the movie that contains a specified track.

Movie GetTrackMovie (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The identifier of the movie that contains the track.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Movie GetTrackMovie (
   Track    theTrack ){};


/*GetTrackNextInterestingTime

Searches for times of interest in a track.

void GetTrackNextInterestingTime (
   Track        theTrack,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
interestingTimeFlags

Contains flags (see below) that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, nextTimeTrackEdit and nextTimeSyncSample flags to 1. Set unused flags to 0. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeTrackEdit
nextTimeSyncSample
nextTimeEdgeOK
nextTimeIgnoreActiveSegment
time

Specifies a time value that establishes the starting point for the search. This time value must be expressed in the movie's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingTime

A pointer to a time value. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the movie's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NIL if you are not interested in this information.
interestingDuration

A pointer to a time value. The Movie Toolbox returns the duration of the interesting time. This time value is in the movie's time coordinate system. Set this parameter to NIL if you don't want this information; in this case, the function works more quickly.
Discussion

Some compression algorithms conserve space by eliminating duplication between consecutive frames in a sample. In this case, sync samples don't rely on preceding frames for content. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackNextInterestingTime (
   Track        theTrack,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration ){};



/*TrackTimeToMediaDisplayTime

Converts a track's time value to a display time value that is appropriate to the track's media, using the track's edit list.

TimeValue64 TrackTimeToMediaDisplayTime (
   TimeValue64    value,
   Track          theTrack );
Parameters
value

A 64-bit time value that represents the track's time value; it must be expressed in the time scale of the movie that contains the track.
theTrack

A track identifier, which your application obtains from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A 64-bit time value that represents the corresponding time in media display time, in the media's time coordinate system. If the track time corresponds to empty space, this function returns a value of -1.
Discussion

This function maps the track time through the track's edit list to come up with the media time. This time value contains the track's time value according to the media's time coordinate system. If the time you specified lies outside of the movie's active segment or corresponds to empty space in the track, this function returns a value of -1. Hence you can use it to determine whether a specified track edit is empty.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 TrackTimeToMediaDisplayTime (
   TimeValue64    value,
   Track          theTrack ){};


/*GetTrackEditRate

Returns the rate of the track edit of a specified track at an indicated time.

Fixed GetTrackEditRate (
   Track        theTrack,
   TimeValue    atTime );
Parameters
theTrack

The track identifier for which the rate of a track edit (at the time given in the atTime parameter) is to be determined.
atTime

Indicates a time value at which the rate of a track edit (of a track identified in the parameter theTrack) is to be determined.
Return Value

The rate of the track edit of the specified track at the specified time.
Discussion

This function is useful if you are stepping through track edits directly in your application or if you are a client of QuickTime's base media handler.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Fixed GetTrackEditRate (
   Track        theTrack,
   TimeValue    atTime ){};


/*CopyMediaMutableSampleTable

Obtains information about sample references in a media in the form of a sample table.

OSErr CopyMediaMutableSampleTable (
   Media                      theMedia,
   TimeValue64                startDecodeTime,
   TimeValue64                *sampleStartDecodeTime,
   SInt64                     maxNumberOfSamples,
   TimeValue64                maxDecodeDuration,
   QTMutableSampleTableRef    *sampleTableOut );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
startDecodeTime

A 64-bit time value that represents the starting decode time of the sample references to be retrieved. You must specify this value in the media's time scale.
sampleStartDecodeTime

A pointer to a time value. The function updates this time value to indicate the actual decode time of the first returned sample reference. If you are not interested in this information, set this parameter to NULL. The returned time may differ from the time you specified with the startDecodeTime parameter. This will occur if the time you specified falls in the middle of a sample.
maxNumberOfSamples

A 64-bit signed integer that contains the maximum number of sample references to be returned. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate to the media.
maxDecodeDuration

A 64-bit time value that represents the maximum decode duration to be returned. The function does not return samples with greater decode duration than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media.
sampleTableOut

A reference to an opaque sample table object. When you are done with the returned sample table, release it with QTSampleTableRelease.
Return Value

An error code. Returns memFullErr if it could not allocate memory, paramErr if there was an invalid parameter, or noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

To find out how many samples were returned in the sample table, call QTSampleTableGetNumberOfSamples.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr CopyMediaMutableSampleTable (
   Media                      theMedia,
   TimeValue64                startDecodeTime,
   TimeValue64                *sampleStartDecodeTime,
   SInt64                     maxNumberOfSamples,
   TimeValue64                maxDecodeDuration,
   QTMutableSampleTableRef    *sampleTableOut ){};



/*QTSampleTableGetNumberOfSamples

Returns the number of samples in a sample table.

SInt64 QTSampleTableGetNumberOfSamples (
   QTSampleTableRef    sampleTable );
Parameters
sampleTable

A reference to an opaque sample table object.
Return Value

A 64-bit signed integer that contains the number of samples, or 0 if sampleTable is NULL.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
SInt64 QTSampleTableGetNumberOfSamples (
   QTSampleTableRef    sampleTable ){};


/*QTSampleTableGetDecodeDuration

Returns the decode duration of a sample.

TimeValue64 QTSampleTableGetDecodeDuration (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A 64-bit time value that represents the decode duration of the sample. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

TimeValue64 QTSampleTableGetDecodeDuration (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){};


/*QTSampleTableGetDataSizePerSample

Returns the data size of a sample.

ByteCount QTSampleTableGetDataSizePerSample (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

The size of the sample in bytes. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
ByteCount QTSampleTableGetDataSizePerSample (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){};


/*QTSampleTableGetSampleFlags

Returns the media sample flags of a sample.

MediaSampleFlags QTSampleTableGetSampleFlags (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A constant that describes characteristics of the sample (see below). Returns 0 if sampleTable is NULL or if the sample number is out of range.
Discussion

This function can return one or more of the following constants:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

MediaSampleFlags QTSampleTableGetSampleFlags (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){};


/*QTSampleTableCopySampleDescription

Retrieves a sample description from a sample table.

OSStatus QTSampleTableCopySampleDescription (
   QTSampleTableRef           sampleTable,
   QTSampleDescriptionID      sampleDescriptionID,
   long                       *mediaSampleDescriptionIndexOut,
   SampleDescriptionHandle    *sampleDescriptionHOut );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleDescriptionID

The sample description ID.
mediaSampleDescriptionIndexOut

A pointer to a variable to receive a media sample description index. If the sample description came from a media, this is the index that could be passed to GetMediaSampleDescription to retrieve the same sample description handle. The index will be 0 if the sample description did not come directly from a media. Pass NULL if you do not want to receive this information.
sampleDescriptionHOut

A pointer to a variable to receive a newly allocated sample description handle. Pass NULL if you do not want one. The caller is responsible for disposing the returned sample description handle using DisposeHandle.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSampleTableCopySampleDescription (
   QTSampleTableRef           sampleTable,
   QTSampleDescriptionID      sampleDescriptionID,
   long                       *mediaSampleDescriptionIndexOut,
   SampleDescriptionHandle    *sampleDescriptionHOut ){};



/*SampleNumToMediaDisplayTime

Finds the display time for a specified sample.

void SampleNumToMediaDisplayTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
logicalSampleNum

A 64-bit signed integer that contains the sample number.
sampleDisplayTime

A pointer to a time value. The function updates this time value to indicate the display time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDisplayDuration

A pointer to a time value. The function updates this time value to indicate the display duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

void SampleNumToMediaDisplayTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration ){};



/*QTSampleTableGetProperty

Returns the value of a specific sample table property.

OSStatus QTSampleTableGetProperty (
   QTSampleTableRef      sampleTable,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );
Parameters
sampleTable

A reference to an opaque sample table object.
inPropClass

Pass the following constant to define the property class: kQTPropertyClass_SampleTable = 'qtst' Property of a sample table. See these constants: 
kQTPropertyClass_SampleTable
inPropID

Pass one of these constants to define the property ID: kQTSampleTablePropertyID_TotalDecodeDuration = 'tded' The total decode duration of all samples in the sample table. Read-only. kQTSampleTablePropertyID_MinDisplayOffset = '<ddd' The least display offset in the table. Negative offsets are less than positive offsets. Read-only. kQTSampleTablePropertyID_MaxDisplayOffset = '>ddd' The greatest display offset in the table. Positive offsets are greater than negative offsets. Read-only. kQTSampleTablePropertyID_MinRelativeDisplayTime = '<dis' The least display time of all samples in the table, relative to the decode time of the first sample in the table. Read-only. kQTSampleTablePropertyID_MaxRelativeDisplayTime = '>dis' The greatest display time of all samples in the table, relative to the decode time of the first sample in the table. Read-only. See these constants: 
kQTSampleTablePropertyID_TotalDecodeDuration
kQTSampleTablePropertyID_MinDisplayOffset
kQTSampleTablePropertyID_MaxDisplayOffset
kQTSampleTablePropertyID_MinRelativeDisplayTime
kQTSampleTablePropertyID_MaxRelativeDisplayTime
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

On return, the actual size of the property value written to the buffer.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSampleTableGetProperty (
   QTSampleTableRef      sampleTable,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed ){};



/*QTSampleTableRelease

Decrements the retain count of a sample table.

void QTSampleTableRelease (
   QTSampleTableRef    sampleTable );
Parameters
sampleTable

A reference to an opaque sample table object. If you pass NULL in this parameter, nothing happens.
Discussion

If the retain count decreases to zero, the sample table is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void QTSampleTableRelease (
   QTSampleTableRef    sampleTable ){};



/*MediaDisplayTimeToSampleNum

Finds the sample number for a specified display time.

void MediaDisplayTimeToSampleNum (
   Media          theMedia,
   TimeValue64    displayTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
displayTime

A 64-bit time value that represents the display time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a long integer that is to receive the sample number. The function returns the sample number that identifies the sample for the specified display time, or 0 if it is not found.
sampleDisplayTime

A pointer to a time value. The function updates this time value to indicate the display time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDisplayDuration

A pointer to a time value. The function updates this time value to indicate the display duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, invalidTime if sampleDisplayTime is out of the display time range, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void MediaDisplayTimeToSampleNum (
   Media          theMedia,
   TimeValue64    displayTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration ){};



/*GetMediaAdvanceDecodeTime

Returns the advance decode time of a media.

TimeValue64 GetMediaAdvanceDecodeTime (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's advance decode time. A media's advance decode time is the absolute value of the greatest-magnitude negative display offset of its samples, or 0 if there are no samples with negative display offsets. This is the amount that the decode time axis must be adjusted ahead of the display time axis to ensure that no sample's adjusted decode time is later than its display time. For media without nonzero display offsets, the advance decode time is 0.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

TimeValue64 GetMediaAdvanceDecodeTime (
   Media    theMedia ){};




/*GetTrackDimensions

Determines a track's source rectangle.

void GetTrackDimensions (
   Track    theTrack,
   Fixed    *width,
   Fixed    *height );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
width

A pointer to a fixed-point number. The Movie Toolbox returns the width, in pixels, of the track's rectangle. This value corresponds to the x coordinate of the lower-right corner of the track's rectangle.
height

A pointer to a fixed-point number. The Movie Toolbox returns the height, in pixels, of the track's rectangle. This value corresponds to the y coordinate of the lower-right corner of the track's rectangle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackDimensions (
   Track    theTrack,
   Fixed    *width,
   Fixed    *height ){};


/*QTSampleTableGetDisplayOffset

Returns the offset from decode time to display time of a sample.

TimeValue64 QTSampleTableGetDisplayOffset (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A 64-bit time value that represents the offset from decode time to display time of the sample. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 QTSampleTableGetDisplayOffset (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){};


/*QTSampleTableGetSampleDescriptionID

Returns the sample description ID of a sample.

QTSampleDescriptionID QTSampleTableGetSampleDescriptionID (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

The sample's sample description ID. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
QTSampleDescriptionID QTSampleTableGetSampleDescriptionID (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){};


/*MovieExportAddDataSource

Defines a data source for use with an export operation performed by MovieExportFromProceduresToDataRef.

ComponentResult MovieExportAddDataSource (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    scale,
   long                         *trackID,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
trackType

The type of media provided by this data source. This normally corresponds to a QuickTime media type such as VideoMediaType or SoundMediaType.
scale

The time scale for time values passed to getDataProc parameter. If the source data is being taken from a QuickTime track, this value is typically the media's time scale.
trackID

An identifier for the data source. This identifier is returned from the call.
getPropertyProc

A MovieExportGetPropertyProc callback that provides information about processing source samples.
getDataProc

A MovieExportGetDataProc callback the export component uses to request sample data.
refCon

Passed to the procedures specified in the getPropertyProc and getDataProc parameters. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before starting an export operation, all the data sources must be defined by calling this function once for each data source.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportAddDataSource (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    scale,
   long                         *trackID,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon ){};



/*MovieExportNewGetDataAndPropertiesProcs

Returns MovieExportGetPropertyProc and MovieExportGetDataProc callbacks that can be passed to MovieExportAddDataSource to create a new data source.

ComponentResult MovieExportNewGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    *scale,
   Movie                        theMovie,
   Track                        theTrack,
   TimeValue                    startTime,
   TimeValue                    duration,
   MovieExportGetPropertyUPP    *getPropertyProc,
   MovieExportGetDataUPP        *getDataProc,
   void                         **refCon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
trackType

The format of the data to be generated by the returned MovieExportGetDataProc.
scale

The time scale returned from this function; this should be passed on to MovieExportAddDataSource with the procedures.
theMovie

The movie for this operation, supplied by the Movie Toolbox. Your component may use this identifier to obtain sample data from the movie or to obtain information about the movie.
theTrack

The track for this operation. This track identifier is supplied by the Movie Toolbox.
startTime

The starting point of the track or movie segment to be converted. This time value is expressed in the movie's time coordinate system.
duration

The duration of the track or movie segment to be converted. This duration value is expressed in the movie's time coordinate system.
getPropertyProc

A MovieExportGetPropertyProc callback that provides information about processing source samples.
getDataProc

A MovieExportGetDataProc callback that the export component uses to request sample data.
refCon

Passed to the procedures specified in the getPropertyProc and getDataProc parameters. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function exists in order to provide a standard way of getting data using this protocol out of a movie or track. The returned procedures must be disposed by calling MovieExportDisposeGetDataAndPropertiesProcs.
Special Considerations

This function is only implemented by movie data export components.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportNewGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    *scale,
   Movie                        theMovie,
   Track                        theTrack,
   TimeValue                    startTime,
   TimeValue                    duration,
   MovieExportGetPropertyUPP    *getPropertyProc,
   MovieExportGetDataUPP        *getDataProc,
   void                         **refCon ){};


/*MovieExportDoUserDialog

Requests that a component display its user dialog box.

ComponentResult MovieExportDoUserDialog (
   MovieExportComponent    ci,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration,
   Boolean                 *canceled );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
theMovie

The movie containing the data to be exported.
onlyThisTrack

Specifies that the export component should only attempt to export the data from a single track. If this parameter is set to NIL, the exporter should attempt to export the entire movie, or all of the tracks in the movie that it can export. For example, an audio export component might export multiple audio tracks, mixing them if necessary. If this parameter is not NIL, the exporter should attempt to export only the specified track.
startTime

The movie time at which to begin the export operation. If you pass 0, the operation should start at the beginning of the movie or track.
duration

The duration, in movie timescale units, of the segment to be exported. To export the entire movie, or an entire track, pass in the value returned by GetMovieDuration or GetTrackDuration, minus the value passed in startTime, as described above.
canceled

A pointer to a Boolean value. Your component should set this value to TRUE if the user cancels the dialog box, otherwise FALSE. If the user cancels the dialog box, your component should revert to its settings as they were before executing this function.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportDoUserDialog (
   MovieExportComponent    ci,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration,
   Boolean                 *canceled ){};


/*QTNewDataReferenceFromCFURL

Creates a URL data reference from a CFURL.

OSErr QTNewDataReferenceFromCFURL (
   CFURLRef    url,
   UInt32      flags,
   Handle      *outDataRef,
   OSType      *outDataRefType );
Parameters
url

A reference to a Core Foundation struct that represents the URL to which you want a URL data reference. These structs contain two parts: the string and a base URL, which may be empty. With a relative URL, the string alone does not fully specify the address; with an absolute URL it does.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See “Error Codes” in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

The new URL data reference returned can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Carbon status: Supported; C interface file: Movies.h*/
OSErr QTNewDataReferenceFromCFURL (
   CFURLRef    url,
   UInt32      flags,
   Handle      *outDataRef,
   OSType      *outDataRefType ){};


/*DisposeMovieExportGetPropertyUPP

Disposes of a MovieExportGetPropertyUPP pointer.

void DisposeMovieExportGetPropertyUPP (
   MovieExportGetPropertyUPP    userUPP );
Parameters
userUPP

A MovieExportGetPropertyUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeMovieExportGetPropertyUPP (
   MovieExportGetPropertyUPP    userUPP ){};
/*DisposeMovieExportGetDataUPP

Disposes of a MovieExportGetDataUPP pointer.

void DisposeMovieExportGetDataUPP (
   MovieExportGetDataUPP    userUPP );
Parameters
userUPP

A MovieExportGetDataUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeMovieExportGetDataUPP (
   MovieExportGetDataUPP    userUPP ){};


/*MovieExportDisposeGetDataAndPropertiesProcs

Disposes of the memory associated with the procedures returned by MovieExportNewGetDataAndPropertiesProcs.

ComponentResult MovieExportDisposeGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
getPropertyProc

A MovieExportGetPropertyProc callback that provides information about processing source samples.
getDataProc

A MovieExportGetDataProc callback that the export component uses to request sample data.
refCon

Passed to the procedures specified in the getPropertyProc and getDataProc parameters. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportDisposeGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon ){};


/*NewMovieExportGetPropertyUPP

Allocates a Universal Procedure Pointer for the MovieExportGetPropertyProc callback.

MovieExportGetPropertyUPP NewMovieExportGetPropertyUPP (
   MovieExportGetPropertyProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieExportGetPropertyProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
MovieExportGetPropertyUPP NewMovieExportGetPropertyUPP (
   MovieExportGetPropertyProcPtr    userRoutine ){};

/*NewMovieExportGetDataUPP

Allocates a Universal Procedure Pointer for the MovieExportGetDataProc callback.

MovieExportGetDataUPP NewMovieExportGetDataUPP (
   MovieExportGetDataProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieExportGetDataProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
MovieExportGetDataUPP NewMovieExportGetDataUPP (
   MovieExportGetDataProcPtr    userRoutine ){};



/*MovieExportFromProceduresToDataRef

Exports data provided by MovieExportAddDataSource to a specified location.

ComponentResult MovieExportFromProceduresToDataRef (
   MovieExportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
dataRef

The data reference for the export operation.
dataRefType

The type identifier for the data reference specified by dataRef.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function exports data provided by MovieExportAddDataSource to a location specified by dataRef and dataRefType. Typically dataRef contains a Macintosh file alias and dataRefType is set to rAliasType.
Special Considerations

Movie data export components that support export operations from procedures must set the canMovieExportFromProcedures flag in their component flags.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportFromProceduresToDataRef (
   MovieExportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType ){};


/*GraphicsImportCreateCGImage

Imports an image as a Core Graphics CGImage.

ComponentResult GraphicsImportCreateCGImage (
   GraphicsImportComponent    ci,
   CGImageRef                 *imageRefOut,
   UInt32                     flags );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
imageRefOut

A reference to the CG image to be created.
flags

A flag that determines the settings to use.
kGraphicsImportCreateCGImageUsingCurrentSettings

Use the current settings.
Return Value

See “Error Codes” in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Carbon status: Supported; C interface file: ImageCompression.h*/
ComponentResult GraphicsImportCreateCGImage (
   GraphicsImportComponent    ci,
   CGImageRef                 *imageRefOut,
   UInt32                     flags ){};

/*GetGraphicsImporterForFile

Locates and opens a graphics importer component that can be used to draw a specified file.

OSErr GetGraphicsImporterForFile (
   const FSSpec         *theFile,
   ComponentInstance    *gi );
Parameters
theFile

The file to be drawn using a graphics importer component.
gi

On return, contains a pointer to the ComponentInstance of the graphics importer. If no graphics importer can be found for the specified file, the gi will be set to NIL. If GetGraphicsImporterForFile is able to locate a graphics importer for the file, the returned graphics importer ComponentInstance will already be set up to draw the specified file to the current port.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function first tries to locate a graphics importer component for the specified file based on its file type. If it is unable to locate a graphics importer component based on the Macintosh file type, or the call is made on a non-Macintosh file, GetGraphicsImporterForFile will try to locate a graphics importer component based on the file extension (such as .JPG or .GIF). If a graphics importer cannot be found using the file's type or extension, GetGraphicsImporterForFile asks each graphics importer to validate the file, until it either finds an importer that can handle the file or exhausts the list of possible importers. This validation attempt can be quite time-consuming. To bypass the validation attempt, call GetGraphicsImporterForFileWithFlags instead. The following code sample illustrates the use of GetGraphicsImporterForFile:// Get a graphics importer for the image file, determine the natural size
// of the image, and draw the image
// See "Discovering QuickTime," page 274
void drawFile(const FSSpec *fss, const Rect *boundsRect)
    {
        GraphicsImportComponent gi;
        GetGraphicsImporterForFile(fss, &gi);
        GraphicsImportSetBoundsRect(gi, boundsRect);
        GraphicsImportDraw(gi);
        CloseComponent(gi);
    }

Special Considerations

The caller of GetGraphicsImporterForFile is responsible for closing the returned ComponentInstance using CloseComponent.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetGraphicsImporterForFile (
   const FSSpec         *theFile,
   ComponentInstance    *gi ){};


/*MakeImageDescriptionForPixMap

Fills out an ImageDescription structure corresponding to a PixMap structure.

OSErr MakeImageDescriptionForPixMap (
   PixMapHandle              pixmap,
   ImageDescriptionHandle    *idh );
Parameters
pixmap

A handle to a PixMap structure.
idh

The handle of an ImageDescription structure. On entry, this parameter normally points to an ImageDescription structure whose contents are NIL. On return, the structure is correctly filled out for the selected PixMap.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr MakeImageDescriptionForPixMap (
   PixMapHandle              pixmap,
   ImageDescriptionHandle    *idh ){};


/*DecompressSequenceBegin

Obsolete. See DecompressSequenceBeginS.

OSErr DecompressSequenceBegin (
   ImageSequence             *seqID,
   ImageDescriptionHandle    desc,
   CGrafPtr                  port,
   GDHandle                  gdh,
   const Rect                *srcRect,
   MatrixRecordPtr           matrix,
   short                     mode,
   RgnHandle                 mask,
   CodecFlags                flags,
   CodecQ                    accuracy,
   DecompressorComponent     codec );
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr DecompressSequenceBegin (
   ImageSequence             *seqID,
   ImageDescriptionHandle    desc,
   CGrafPtr                  port,
   GDHandle                  gdh,
   const Rect                *srcRect,
   MatrixRecordPtr           matrix,
   short                     mode,
   RgnHandle                 mask,
   CodecFlags                flags,
   CodecQ                    accuracy,
   DecompressorComponent     codec ){};

/*DecompressSequenceFrameS

Queues a frame for decompression and specifies the size of the compressed data; new applications should use DecompressSequenceFrameWhen.

OSErr DecompressSequenceFrameS (
   ImageSequence                 seqID,
   Ptr                           data,
   long                          dataSize,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc );
Parameters
seqID

Contains the unique sequence identifier that was returned by the DecompressSequenceBegin function.
data

Points to the compressed image data. This pointer must contain a 32-bit clean address.
dataSize

The size of the data buffer.
inFlags

Contains flags (see below) that provide further control information. See these constants: 
codecFlagNoScreenUpdate
codecFlagDontOffscreen
codecFlagOnlyScreenUpdate
outFlags

Contains status flags (see below). The decompressor updates these flags at the end of the decompression operation. See these constants: 
codecFlagUsedNewImageBuffer
codecFlagUsedImageBuffer
codecFlagDontUseNewImageBuffer
codecFlagInterlaceUpdate
codecFlagCatchUpDiff
asyncCompletionProc

Points to an ICMCompletionProcRecord structure. The compressor calls your completion function when an asynchronous decompression operation is complete. You can cause the decompression to be performed asynchronously by specifying a completion function. If you specify asynchronous operation, you must not read the decompressed image until the decompressor indicates that the operation is complete by calling your completion function. Set asyncCompletionProc to NIL to specify synchronous decompression. If you set asyncCompletionProc to -1, the operation is performed asynchronously but the decompressor does not call your completion function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function accepts the same parameters as the DecompressSequenceFrame function, with the addition of the dataSize parameter.
Special Considerations

New applications should use DecompressSequenceFrameWhen.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr DecompressSequenceFrameS (
   ImageSequence                 seqID,
   Ptr                           data,
   long                          dataSize,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc ){};


/*CDSequenceEnd

Indicates the end of processing for an image sequence.

OSErr CDSequenceEnd (
   ImageSequence    seqID );
Parameters
seqID

Contains the unique sequence identifier that was returned by DecompressSequenceBegin or CompressSequenceBegin.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CDSequenceEnd (
   ImageSequence    seqID ){};


/*SetIdentityMatrix

Sets the contents of a matrix so that it performs no transformation.

void SetIdentityMatrix (
   MatrixRecord    *matrix );
Parameters
matrix

A pointer to a MatrixRecord structure. The function updates the contents of this matrix so that the matrix describes the identity matrix.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void SetIdentityMatrix (
   MatrixRecord    *matrix ){};

/*RotateMatrix

Modifies the contents of a matrix so that it defines a rotation operation.

void RotateMatrix (
   MatrixRecord    *m,
   Fixed           degrees,
   Fixed           aboutX,
   Fixed           aboutY );
Parameters
m

A pointer to a MatrixRecord structure.
degrees

The number of degrees of rotation.
aboutX

The x coordinate of the anchor point of rotation.
aboutY

The y coordinate of the anchor point of rotation.
Discussion

This function updates the contents of a matrix so that the matrix describes a rotation operation; that is, it concatenates the rotation transformations onto whatever was initially in the matrix structure. You specify the direction and amount of rotation with the degrees parameter. You specify the point of rotation with the aboutX and aboutY parameters.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void RotateMatrix (
   MatrixRecord    *m,
   Fixed           degrees,
   Fixed           aboutX,
   Fixed           aboutY ){};


/*TranslateMatrix

Adds a translation value to a specified matrix.

void TranslateMatrix (
   MatrixRecord    *m,
   Fixed           deltaH,
   Fixed           deltaV );
Parameters
m

A pointer to the MatrixRecord structure for this operation.
deltaH

The value to be added to the x coordinate translation value.
deltaV

The value to be added to the y coordinate translation value.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
void TranslateMatrix (
   MatrixRecord    *m,
   Fixed           deltaH,
   Fixed           deltaV ){};

/*GraphicsImportSetMatrix

Defines the transformation matrix to use for drawing an imported image.

ComponentResult GraphicsImportSetMatrix (
   GraphicsImportComponent    ci,
   const MatrixRecord         *matrix );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
matrix

A pointer to a matrix structure that specifies how to transform the image during decompression. For example, you can use a transformation matrix to scale or rotate the image. To set the matrix to identity, pass NIL in this parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function establishes the transformation matrix to be applied to an image, which determines where and how it will be drawn.
Special Considerations

This function affects the bounding rectangle defined for the image. You can specify where an image will be drawn by setting either a transformation matrix or a bounding rectangle, but it is usually more convenient for applications to set a bounding rectangle using the GraphicsImportSetBoundsRect function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetMatrix (
   GraphicsImportComponent    ci,
   const MatrixRecord         *matrix ){};

/*GraphicsImportGetBoundsRect

Returns the bounding rectangle for drawing an imported image.

ComponentResult GraphicsImportGetBoundsRect (
   GraphicsImportComponent    ci,
   Rect                       *bounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
bounds

A pointer to a Rect structure describing the bounding rectangle that has been defined for the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This is a convenience function. It is implemented by calling GraphicsImportGetMatrix and GraphicsImportGetNaturalBounds and using the results to calculate the drawing rectangle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetBoundsRect (
   GraphicsImportComponent    ci,
   Rect                       *bounds ){};


/*GraphicsImportSetSourceRect

Sets the source rectangle to use for an imported image.

ComponentResult GraphicsImportSetSourceRect (
   GraphicsImportComponent    ci,
   const Rect                 *sourceRect );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
sourceRect

A pointer to a Rect structure defining the portion of the image to decompress. This rectangle must lie within the boundary rectangle of the source image. Set to NIL to use the entire image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function provides a way to use only a portion of the source image.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetSourceRect (
   GraphicsImportComponent    ci,
   const Rect                 *sourceRect ){};



/*GraphicsImportSetFlags

Sets the flags for a graphics importer component.

ComponentResult GraphicsImportSetFlags (
   GraphicsImportComponent    ci,
   long                       flags );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
flags

The new flags (see below) to use. See these constants: 
kGraphicsImporterDontDoGammaCorrection
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetFlags (
   GraphicsImportComponent    ci,
   long                       flags ){};

/*GraphicsImportSetClip

Defines the clipping region for drawing an imported image.

ComponentResult GraphicsImportSetClip (
   GraphicsImportComponent    ci,
   RgnHandle                  clipRgn );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
clipRgn

A handle to a MacRegion structure that defines the clipping region in the destination coordinate system. Set to NIL to disable clipping. The graphics import component makes a copy of this region.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Because all drawing operations ignore the port clipping region, you must use this function to clip an image. The graphics importer component draws only that portion of the image that lies within the specified clipping region.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetClip (
   GraphicsImportComponent    ci,
   RgnHandle                  clipRgn ){};

/*ICMCompressorSourceFrameGetFrameOptions

Retrieves the frame compression options for a source frame.

ICMCompressionFrameOptionsRef ICMCompressorSourceFrameGetFrameOptions (
   ICMCompressorSourceFrameRef   sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

A compression session frame options reference representing options for this frame. A frame options object is created by ICMCompressionFrameOptionsCreate.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ICMCompressionFrameOptionsRef ICMCompressorSourceFrameGetFrameOptions (
   ICMCompressorSourceFrameRef   sourceFrame ){};


/*ICMCompressionSessionOptionsGetAllowTemporalCompression

Retrieves the allow temporal compression flag.

Boolean ICMCompressionSessionOptionsGetAllowTemporalCompression (
   ICMCompressionSessionOptionsRef   options );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
Return Value

Returns TRUE if temporal compression is allowed, FALSE otherwise.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
Boolean ICMCompressionSessionOptionsGetAllowTemporalCompression (
   ICMCompressionSessionOptionsRef   options ){};


/*ICMCompressionFrameOptionsGetForceKeyFrame

Retrieves the force key frame flag.

Boolean ICMCompressionFrameOptionsGetForceKeyFrame (
   ICMCompressionFrameOptionsRef   options );
Parameters
options

A compression frame options reference. This reference is returned by ICMCompressionFrameOptionsCreate.
Return Value

Returns TRUE if frames are forced to be compressed as key frames, FALSE otherwise.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
Boolean ICMCompressionFrameOptionsGetForceKeyFrame (
   ICMCompressionFrameOptionsRef   options ){};

/*ICMCompressorSourceFrameRetain

Increments the retain count of a source frame object.

ICMCompressorSourceFrameRef ICMCompressorSourceFrameRetain (
   ICMCompressorSourceFrameRef    sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame. If you pass NULL, nothing happens.
Return Value

A reference to the object passed in sourceFrame, for convenience.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ICMCompressorSourceFrameRef ICMCompressorSourceFrameRetain (
   ICMCompressorSourceFrameRef    sourceFrame ){};


/*ICMCompressorSourceFrameRelease

Decrements the retain count of a source frame object.

void ICMCompressorSourceFrameRelease (
   ICMCompressorSourceFrameRef    sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMCompressorSourceFrameRelease (
   ICMCompressorSourceFrameRef    sourceFrame ){};

/*ICMCompressorSourceFrameGetDisplayNumber

Retrieves a source frames display number.

long ICMCompressorSourceFrameGetDisplayNumber (
   ICMCompressorSourceFrameRef   sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

The display number of the source frame.
Discussion

The ICM tags source frames with display numbers in the order that they are passed to ICMCompressionSessionEncodeFrame. The first display number is 1. Compressors may compare these numbers to work out whether prediction is forward or backward, even when display times are not provided. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
long ICMCompressorSourceFrameGetDisplayNumber (
   ICMCompressorSourceFrameRef   sourceFrame ){};
/*ICMCompressionSessionOptionsGetAllowFrameReordering

Retrieves the allow frame reordering flag.

Boolean ICMCompressionSessionOptionsGetAllowFrameReordering (
   ICMCompressionSessionOptionsRef   options );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
Return Value

Returns TRUE if frame reordering is allowed, FALSE otherwise.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/


Boolean ICMCompressionSessionOptionsGetAllowFrameReordering (
   ICMCompressionSessionOptionsRef   options ){};


/*ICMCompressorSourceFrameGetDisplayTimeStampAndDuration

Retrieves the display time stamp and duration of a source frame.

OSStatus ICMCompressorSourceFrameGetDisplayTimeStampAndDuration (
   ICMCompressorSourceFrameRef    sourceFrame,
   TimeValue64                    *displayTimeStampOut,
   TimeValue64                    *displayDurationOut,
   TimeScale                      *timeScaleOut,
   ICMValidTimeFlags              *validTimeFlagsOut );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
displayTimeStampOut

A pointer to the source frame's display time stamp.
displayDurationOut

A pointer to the source frame's display duration.
timeScaleOut

A pointer to the source frame's display time scale.
validTimeFlagsOut

A pointer to one of these display time flags for the source frame: kICMValidTime_DisplayTimeStampIsValid = 1L<<0 The value of displayTimeStamp is valid. kICMValidTime_DisplayDurationIsValid = 1L<<1 The value of displayDuration is valid. See these constants: 
kICMValidTime_DisplayTimeStampIsValid
kICMValidTime_DisplayDurationIsValid
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressorSourceFrameGetDisplayTimeStampAndDuration (
   ICMCompressorSourceFrameRef    sourceFrame,
   TimeValue64                    *displayTimeStampOut,
   TimeValue64                    *displayDurationOut,
   TimeScale                      *timeScaleOut,
   ICMValidTimeFlags              *validTimeFlagsOut ){};


/*ICMCompressionSessionOptionsGetProperty

Retrieves the value of a specific property of a compression session options object.

OSStatus ICMCompressionSessionOptionsGetProperty (
   ICMCompressionSessionOptionsRef   options,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   ByteCount                         inPropValueSize,
   ComponentValuePtr                 outPropValueAddress,
   ByteCount                         *outPropValueSizeUsed );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
inPropClass

Pass the following constant to define the property class: kComponentPropertyClassPropertyInfo = 'pnfo' The property information class. See these constants: 
kComponentPropertyClassPropertyInfo
inPropID

Pass one of these constants to define the property ID: kComponentPropertyInfoList = 'list' An array of CFData values, one for each property. kComponentPropertyCacheSeed = 'seed' A property cache seed value. kComponentPropertyCacheFlags = 'flgs' One of the kComponentPropertyCache flags: kComponentPropertyCacheFlagNotPersistentProperty metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamicProperty metadata should not cached at all. kComponentPropertyExtendedInfo = 'meta' A CFDictionary with extended property information. See these constants: 
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyCacheFlags
kComponentPropertyExtendedInfo
outPropType

A pointer to the type of the returned property's value.
outPropValueAddress

A pointer to a variable to receive the returned property's value.
outPropValueSizeUsed

On return, a pointer to the number of bytes actually used to store the property.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionOptionsGetProperty (
   ICMCompressionSessionOptionsRef   options,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   ByteCount                         inPropValueSize,
   ComponentValuePtr                 outPropValueAddress,
   ByteCount                         *outPropValueSizeUsed ){};


/*ICMEncodedFrameCreateMutable

Called by a compressor to create an encoded-frame token corresponding to a given source frame.

OSStatus ICMEncodedFrameCreateMutable (
   ICMCompressorSessionRef       session,
   ICMCompressorSourceFrameRef   sourceFrame,
   ByteCount                     bufferSize,
   ICMMutableEncodedFrameRef     *frameOut );
Parameters
session

A reference to the compression session between the ICM and an image compressor component.
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
bufferSize

The size of the frame buffer in bytes.
frameOut

On return, a reference to an encoded frame object with write capabilities.
Return Value

An error code. Returns noErr if there is no error.
Discussion

The encoded frame will initially show 0 for mediaSampleFlags; if the frame is not a key frame, the compressor must call ICMEncodedFrameSetMediaSampleFlags to set mediaSampleNotSync. If the frame is droppable, the compressor should set mediaSampleDroppable. If the frame is a partial key frame, the compressor should set mediaSamplePartialSync.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMEncodedFrameCreateMutable (
   ICMCompressorSessionRef       session,
   ICMCompressorSourceFrameRef   sourceFrame,
   ByteCount                     bufferSize,
   ICMMutableEncodedFrameRef     *frameOut ){};


/*ICMEncodedFrameGetDataPtr

Gets the data buffer for an encoded frame.

UInt8 *ICMEncodedFrameGetDataPtr (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

A pointer to the object's data buffer.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
UInt8 *ICMEncodedFrameGetDataPtr (
   ICMEncodedFrameRef   frame ){};

/*ICMCompressorSourceFrameGetPixelBuffer

Retrieves a source frames pixel buffer.

CVPixelBufferRef ICMCompressorSourceFrameGetPixelBuffer (
   ICMCompressorSourceFrameRef   sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

A reference to the pixel buffer containing the source frame's image being compressed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
CVPixelBufferRef ICMCompressorSourceFrameGetPixelBuffer (
   ICMCompressorSourceFrameRef   sourceFrame ){};


/*ICMEncodedFrameSetDataSize

Sets the data size of the compressed frame in an encoded frame's buffer.

OSStatus ICMEncodedFrameSetDataSize (
   ICMMutableEncodedFrameRef   frame,
   ByteCount                   dataSize );
Parameters
frame

A reference to an encoded frame object with write capabilities.
dataSize

The data size of the compressed frame in the encoded frame object's buffer.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMEncodedFrameSetDataSize (
   ICMMutableEncodedFrameRef   frame,
   ByteCount                   dataSize ){};


/*ICMEncodedFrameSetMediaSampleFlags

Sets the media sample flags for an encoded frame.

OSStatus ICMEncodedFrameSetMediaSampleFlags (
   ICMMutableEncodedFrameRef   frame,
   MediaSampleFlags            mediaSampleFlags );
Parameters
frame

A reference to an encoded frame object with write capabilities.
mediaSampleFlags

The object's media sample flags. These flags are listed in the header file Movies.h.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMEncodedFrameSetMediaSampleFlags (
   ICMMutableEncodedFrameRef   frame,
   MediaSampleFlags            mediaSampleFlags ){};



/*ICMEncodedFrameSetFrameType

Sets the frame type for an encoded frame.

OSStatus ICMEncodedFrameSetFrameType (
   ICMMutableEncodedFrameRef   frame,
   ICMFrameType                frameType );
Parameters
frame

A reference to an encoded frame object with write capabilities.
frameType

The frame type to be set: kICMFrameType_I = 'I' An I frame. kICMFrameType_P = 'P' A P frame. kICMFrameType_B = 'B' A B frame. kICMFrameType_Unknown = 0 A frame of unknown type. See these constants: 
kICMFrameType_I
kICMFrameType_P
kICMFrameType_B
kICMFrameType_Unknown
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMEncodedFrameSetFrameType (
   ICMMutableEncodedFrameRef   frame,
   ICMFrameType                frameType ){};


/*ICMCompressorSessionEmitEncodedFrame

Called by a compressor to output an encoded frame corresponding to one or more source frames.

OSStatus ICMCompressorSessionEmitEncodedFrame (
   ICMCompressorSessionRef       session,
   ICMMutableEncodedFrameRef     encodedFrame,
   long                          numberOfSourceFrames,
   ICMCompressorSourceFrameRef   sourceFrames[] );
Parameters
session

A reference to the compression session between the ICM and an image compressor component.
encodedFrame

A reference to an encoded frame object with write capabilities.
numberOfSourceFrames

The number of source frames encoded in the encoded frame.
sourceFrames

References to frames that have been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

An error code. Returns noErr if there is no error.
Discussion

Encoded frames may correspond to more than one source frame only if allowFrameTimeChanges is set in the compression session's compressionSessionOptions.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMCompressorSessionEmitEncodedFrame (
   ICMCompressorSessionRef       session,
   ICMMutableEncodedFrameRef     encodedFrame,
   long                          numberOfSourceFrames,
   ICMCompressorSourceFrameRef   sourceFrames[] ){};

/*ICMEncodedFrameRelease

Decrements the retain count of an encoded frame object.

void ICMEncodedFrameRelease (
   ICMEncodedFrameRef    frame );
Parameters
frame

A reference to an encoded frame object. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMEncodedFrameRelease (
   ICMEncodedFrameRef    frame ){};


/*ICMCompressionSessionOptionsRelease

Decrements the retain count of a compression session options object.

void ICMCompressionSessionOptionsRelease (
   ICMCompressionSessionOptionsRef    options );
Parameters
options

A reference to a compression session options object. This reference is returned by ICMCompressionSessionOptionsCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMCompressionSessionOptionsRelease (
   ICMCompressionSessionOptionsRef    options ){};



/*ICMCompressionFrameOptionsGetFrameType

Retrieves the frame type setting.

ICMFrameType ICMCompressionFrameOptionsGetFrameType (
   ICMCompressionFrameOptionsRef   options );
Parameters
options

A compression frame options reference. This reference is returned by ICMCompressionFrameOptionsCreate.
Return Value

On return, one of the frame types listed below.
Discussion

This function can return one of these constants:
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ICMFrameType ICMCompressionFrameOptionsGetFrameType (
   ICMCompressionFrameOptionsRef   options ){};


/*ICMCompressionSessionOptionsRetain

Increments the retain count of a compression session options object.

ICMCompressionSessionOptionsRef ICMCompressionSessionOptionsRetain (
   ICMCompressionSessionOptionsRef    options );
Parameters
options

A reference to a compression session options object. This reference is returned by ICMCompressionSessionOptionsCreate. If you pass NULL, nothing happens.
Return Value

A copy of the object reference passed in options, for convenience.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

ICMCompressionSessionOptionsRef ICMCompressionSessionOptionsRetain (
   ICMCompressionSessionOptionsRef    options ){};
/*ICMCompressionSessionOptionsGetMaxKeyFrameInterval

Retrieves the maximum key frame interval.

SInt32 ICMCompressionSessionOptionsGetMaxKeyFrameInterval (
   ICMCompressionSessionOptionsRef   options );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
Return Value

Returns the maximum key frame interval.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

SInt32 ICMCompressionSessionOptionsGetMaxKeyFrameInterval (
   ICMCompressionSessionOptionsRef   options ){};



/*PutMovieIntoHandle

Creates a new movie resource.

OSErr PutMovieIntoHandle (
   Movie     theMovie,
   Handle    publicMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
publicMovie

The handle that is to receive the new movie resource. The function resizes the handle if necessary.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this handle to store a QuickTime movie in a specialized storage format.
Special Considerations

Note that you cannot use this new movie with other Movie Toolbox functions, except for NewMovieFromHandle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieIntoHandle (
   Movie     theMovie,
   Handle    publicMovie ){};


/*NewMovieFromHandle

Creates a movie in memory from a movie resource or a handle you obtained from PutMovieIntoHandle.

OSErr NewMovieFromHandle (
   Movie      *theMovie,
   Handle     h,
   short      newMovieFlags,
   Boolean    *dataRefWasChanged );
Parameters
theMovie

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
h

A handle to the movie resource from which the movie is to be loaded.
newMovieFlags

Flags (see below) that control the operation of NewMovieFromHandle. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
dataRefWasChanged

A pointer to a Boolean value. The toolbox sets the value to TRUE if any references were changed. Set the dataRefWasChanged parameter to NIL if you don't want to receive this information.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovieFromHandle. To change the graphics world for the new movie, your application should use SetMovieGWorld.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr NewMovieFromHandle (
   Movie      *theMovie,
   Handle     h,
   short      newMovieFlags,
   Boolean    *dataRefWasChanged ){};

/*DetachMovieFromCurrentThread

Detaches a movie from the current thread.

OSErr DetachMovieFromCurrentThread (Movie m);
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr DetachMovieFromCurrentThread (Movie m){};


/*AttachMovieToCurrentThread

Attaches a movie to the current thread.

OSErr AttachMovieToCurrentThread (Movie m);
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr AttachMovieToCurrentThread (Movie m){};



/*GetCodecInfo

Returns information about a single compressor component.

OSErr GetCodecInfo (
   CodecInfo         *info,
   CodecType         cType,
   CodecComponent    codec );
Parameters
info

A pointer to a CodecInfo structure. GetCodecInfo returns detailed information about the appropriate compressor component in this structure.
cType

Set this parameter to a valid compressor type constant; see Codec Identifiers. If you want information about any compressor of the type specified by this parameter, set the codec parameter to 0. The Image Compression Manager then returns information about the first compressor it finds of the type you have specified.
codec

Set this parameter to the component identifier of the specific compressor for the request, or to 0 for any compressor. Component identifiers are available in the CodecNameSpecList structure returned by GetCodecNameList.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetCodecInfo (
   CodecInfo         *info,
   CodecType         cType,
   CodecComponent    codec ){};



/*ImageCodecGetParameterList

Returns a parameter description atom container for a specified effect component instance.

ComponentResult ImageCodecGetParameterList (
   ComponentInstance    ci,
   QTAtomContainer      *parameterDescription );
Parameters
ci

An effect component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
parameterDescription

The returned atom container for this component instance.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns the parameter description for the effect specified by the component instance ci, as a handle containing an 'atms' resource of ID 1. The handle should be detached if it has been read in from a resource. Each parameter of the effect is described in the parameter description, with details of its name, type, legal values and hints about how a user interface to the parameter should be constructed.
Special Considerations

The calling application is responsible for disposing of the QT atom container returned in parameterDescription. The application should do this by calling QTDisposeAtomContainer once it has finished using the parameter description.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/

ComponentResult ImageCodecGetParameterList (
   ComponentInstance    ci,
   QTAtomContainer      *parameterDescription ){};


/*QTGetEffectSpeed

Returns the speed of the effect, expressed in frames per second.

OSErr QTGetEffectSpeed (
   QTAtomContainer    parameters,
   Fixed              *pFPS );
Parameters
parameters

Contains parameter values for the effect.
pFPS

The speed of the effect is returned in this parameter, expressed in frames per second. Effects can also return the pre-defined constant effectIsRealtime (see below) as their speed. See these constants: 
effectIsRealtime
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The value returned should not be treated as an absolute measurement of effect performance. In particular, most effects only return one value, regardless of parameter settings and hardware. This value is an estimate of execution speed on a reference hardware platform. Actual performance will vary depending on hardware, configuration and parameter options.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetEffectSpeed (
   QTAtomContainer    parameters,
   Fixed              *pFPS ){};


/*QTCountChildrenOfType

Returns the number of atoms of a given type in the child list of the specified parent atom.

short QTCountChildrenOfType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         childType );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
childType

The atom type for this operation. To retrieve the total number of atoms in the child list, set this parameter to 0. 
Return Value

The number of atoms of a given type in the child list of the specified parent atom.
Discussion

You can call this function to determine the number of atoms of a specified type in a parent atom's child list. If the total number of atoms in the parent atom's child list is 0, the parent atom is a leaf atom.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short QTCountChildrenOfType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         childType ){};


/*MovieImportGetSettingsAsAtomContainer

Retrieves the current settings from the movie import component.

ComponentResult MovieImportGetSettingsAsAtomContainer (
   MovieImportComponent    ci,
   QTAtomContainer         *settings );
Parameters
ci

A movie data import component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
settings

The address where the reference to the newly created atom container should be stored by the call.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The caller is responsible for disposing of the returned QT atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieImportGetSettingsAsAtomContainer (
   MovieImportComponent    ci,
   QTAtomContainer         *settings ){};


/*MovieExportGetSettingsAsAtomContainer

Retrieves the current settings from the movie export component.

ComponentResult MovieExportGetSettingsAsAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         *settings );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
settings

The address where the newly-created atom container should be stored by the call. The caller is responsible for disposing of the returned QT atom container.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Applications can call this function to obtain a correctly formatted atom container to use with MovieExportSetSettingsFromAtomContainer. This might be done after a call to MovieExportDoUserDialog, for example, to apply the user-obtained settings to a series of exports.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportGetSettingsAsAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         *settings ){};



/*GraphicsExportGetSettingsAsAtomContainer

Retrieves the current settings from a graphics exporter component.

ComponentResult GraphicsExportGetSettingsAsAtomContainer (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
qtAtomContainerPtr

Points to a variable to receive a new QuickTime atom container containing the current graphics exporter component settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

The caller is responsible for disposing of the returned atom container.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportGetSettingsAsAtomContainer (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr ){};


/*GraphicsImportGetExportSettingsAsAtomContainer

Retrieves settings for image files exported by the graphics importer.

ComponentResult GraphicsImportGetExportSettingsAsAtomContainer (
   GraphicsImportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
qtAtomContainerPtr

A pointer to a QuickTime atom container that is to receive the settings information.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates and returns a new QuickTime atom container which holds information about how images will be saved by GraphicsImportExportImageFile.
Special Considerations

It is the responsibility of the caller to dispose of this atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportGetExportSettingsAsAtomContainer (
   GraphicsImportComponent    ci,
   void                       *qtAtomContainerPtr ){};


/*QTVideoOutputGetDisplayModeList

Returns a list of the display modes supported by a video output component.

ComponentResult QTVideoOutputGetDisplayModeList (
   QTVideoOutputComponent    vo,
   QTAtomContainer           *outputs );
Parameters
vo

The instance of a video output component. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
outputs

A pointer to the QT atom container that lists the video modes supported by this component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

After your software calls this function, it must dispose of the QT atom container returned by the function by calling QTDisposeAtomContainer.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult QTVideoOutputGetDisplayModeList (
   QTVideoOutputComponent    vo,
   QTAtomContainer           *outputs ){};


/*VDIIDCGetFeatures

Places atoms in a QuickTime atom container that specify the current capabilities of a camera and the state of its IIDC features.

VideoDigitizerError VDIIDCGetFeatures (
   VideoDigitizerComponent    ci,
   QTAtomContainer            *container );
Parameters
ci

The component instance that identifies your connection to a video digitizer component. The digitizer's subtype must be vdSubtypeIIDC ('iidc').
container

Upon return, a pointer to a QuickTime atom container containing atoms of type vdIIDCAtomTypeFeature for each IIDC camera feature. If the camera has not implemented any IIDC features the container returns empty.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Discussion

The digitizer creates the container, and it is the responsibility of the client to ultimately delete it if the routine does not return an error. Since the values that this function retrieves might change underneath the client, they should not be cached but should be retrieved each time they are needed.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDIIDCGetFeatures (
   VideoDigitizerComponent    ci,
   QTAtomContainer            *container ){};


/*GetMaxCompressionSize

Determines the maximum size an image will be after compression.

OSErr GetMaxCompressionSize (
   PixMapHandle           src,
   const Rect             *srcRect,
   short                  colorDepth,
   CodecQ                 quality,
   CodecType              cType,
   CompressorComponent    codec,
   long                   *size );
Parameters
src

A handle to the source image. The source image must be stored in a pixel map structure. The compressor uses only the image's size and pixel depth to determine the maximum size of the compressed image.
srcRect

A pointer to a rectangle defining the portion of the source image that is to be compressed. You may set this parameter to NIL if you are interested only in information about quality settings. GetCompressionTime then uses the bounds of the source pixel map.
colorDepth

The depth at which the image is to be compressed. If you set this parameter to 0, the Image Compression Manager determines the appropriate value for the source image. Values of 1, 2, 4, 8, 16, 24, and 32 indicate the number of bits per pixel for color images. Values of 34, 36, and 40 indicate 2-bit, 4-bit, and 8-bit grayscale, respectively, for grayscale images. Your program can determine which depths are supported by a given compressor by examining the compressor information structure returned by GetCodecInfo.
quality

A constant (see below) that defines the desired compressed image quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
cType

You must set this parameter to a valid compressor type constant; see Codec Identifiers.
codec

A compressor identifier. Specify a particular compressor by setting this parameter to its compressor identifier. Alternatively, you may use a special identifier (see below). You can also specify a component instance. This may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
size

A pointer to a field to receive the size, in bytes, of the compressed image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns the maximum resulting size for the specified image and parameters. Your application may then use this information to allocate memory for the compression operation. The following code sample illustrates its use:// GetMaxCompressionSize coding example
// See "Discovering QuickTime," page 286
PicHandle GetQTCompressedPict (PixMapHandle hpmImage)
{
    long                    lMaxCompressedSize =0;
    Handle                  hCompressedData =NIL;
    Ptr                     pCompressedData;
    ImageDescriptionHandle  hImageDesc =NIL;
    OSErr                   nErr;
    PicHandle               hpicPicture =NIL;
    Rect                    rectImage =(**hpmImage).bounds;
    CodecType               dwCodecType =kJPEGCodecType;
    CodecComponent          codec =(CodecComponent)anyCodec;
    CodecQ                  dwSpatialQuality =codecNormalQuality;
    short                   nDepth =0;          // let ICM choose depth
    nErr =GetMaxCompressionSize(hpmImage, &rectImage, nDepth,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        (CompressorComponent)codec,
                                        &lMaxCompressedSize);
    if (nErr !=noErr)
        return NIL;
 
    hImageDesc =(ImageDescriptionHandle)NewHandle(4);
    hCompressedData =NewHandle(lMaxCompressedSize);
    if ((hCompressedData !=NIL) && (hImageDesc !=NIL)) {
        MoveHHi(hCompressedData);
        HLock(hCompressedData);
        pCompressedData =StripAddress(*hCompressedData);
 
        nErr =CompressImage(hpmImage,
                                        &rectImage,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        hImageDesc,
                                        pCompressedData);
 
        if (nErr ==noErr) {
            ClipRect(&rectImage);
            hpicPicture =OpenPicture(&rectImage);
            nErr =DecompressImage(pCompressedData,
                                        hImageDesc,
                                        hpmImage,
                                        &rectImage,
                                        &rectImage,
                                        srcCopy,
                                        NIL);
            ClosePicture();
        }
        if (theErr || (GetHandleSize((Handle)hpicPicture) ==
                                            sizeof(Picture))) {
            KillPicture(hpicPicture);
            hpicPicture =NIL;
        }
    }
    if (hImageDesc !=NIL)
        DisposeHandle((Handle)hImageDesc);
    if (hCompressedData !=NIL)
        DisposeHandle(hCompressedData);
    return hpicPicture;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetMaxCompressionSize (
   PixMapHandle           src,
   const Rect             *srcRect,
   short                  colorDepth,
   CodecQ                 quality,
   CodecType              cType,
   CompressorComponent    codec,
   long                   *size ){};

/*CompressImage

Compresses a single-frame image that is currently stored as a pixel map structure.

OSErr CompressImage (
   PixMapHandle              src,
   const Rect                *srcRect,
   CodecQ                    quality,
   CodecType                 cType,
   ImageDescriptionHandle    desc,
   Ptr                       data );
Parameters
src

A handle to the image to be compressed. The image must be stored in a pixel map structure.
srcRect

A pointer to a rectangle defining the portion of the image to compress.
quality

A constant (see below) that defines the desired compressed image quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
cType

A compressor type; see Codec Identifiers.
desc

A handle that is to receive a formatted ImageDescription structure. The Image Compression Manager resizes this handle for the returned image description structure. Your application should store this image description with the compressed image data.
data

Points to a location to receive the compressed image data. It is your program's responsibility to make sure that this location can receive at least as much data as indicated by the GetMaxCompressionSize function. The Image Compression Manager places the actual size of the compressed image into the dataSize field of the ImageDescription structure structure referred to by the desc parameter. This pointer must contain a 32-bit clean address.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The following code sample illustrates the process of compressing and decompressing a pixel map.// CompressImage coding example
// See "Discovering QuickTime," page 286
PicHandle GetQTCompressedPict (PixMapHandle hpmImage)
{
    long                    lMaxCompressedSize =0;
    Handle                  hCompressedData =NIL;
    Ptr                     pCompressedData;
    ImageDescriptionHandle  hImageDesc =NIL;
    OSErr                   nErr;
    PicHandle               hpicPicture =NIL;
    Rect                    rectImage =(**hpmImage).bounds;
    CodecType               dwCodecType =kJPEGCodecType;
    CodecComponent          codec =(CodecComponent)anyCodec;
    CodecQ                  dwSpatialQuality =codecNormalQuality;
    short                   nDepth =0;          // let ICM choose depth
    nErr =GetMaxCompressionSize(hpmImage, &rectImage, nDepth,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        (CompressorComponent)codec,
                                        &lMaxCompressedSize);
    if (nErr !=noErr)
        return NIL;
 
    hImageDesc =(ImageDescriptionHandle)NewHandle(4);
    hCompressedData =NewHandle(lMaxCompressedSize);
    if ((hCompressedData !=NIL) && (hImageDesc !=NIL)) {
        MoveHHi(hCompressedData);
        HLock(hCompressedData);
        pCompressedData =StripAddress(*hCompressedData);
 
        nErr =CompressImage(hpmImage,
                                        &rectImage,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        hImageDesc,
                                        pCompressedData);
 
        if (nErr ==noErr) {
            ClipRect(&rectImage);
            hpicPicture =OpenPicture(&rectImage);
            nErr =DecompressImage(pCompressedData,
                                        hImageDesc,
                                        hpmImage,
                                        &rectImage,
                                        &rectImage,
                                        srcCopy,
                                        NIL);
            ClosePicture();
        }
        if (theErr || (GetHandleSize((Handle)hpicPicture) ==
                                            sizeof(Picture))) {
            KillPicture(hpicPicture);
            hpicPicture =NIL;
        }
    }
    if (hImageDesc !=NIL)
        DisposeHandle((Handle)hImageDesc);
    if (hCompressedData !=NIL)
        DisposeHandle(hCompressedData);
    return hpicPicture;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CompressImage (
   PixMapHandle              src,
   const Rect                *srcRect,
   CodecQ                    quality,
   CodecType                 cType,
   ImageDescriptionHandle    desc,
   Ptr                       data ){};







/*DecompressImage

Decompresses a single-frame image into a pixel map structure.

OSErr DecompressImage (
   Ptr                       data,
   ImageDescriptionHandle    desc,
   PixMapHandle              dst,
   const Rect                *srcRect,
   const Rect                *dstRect,
   short                     mode,
   RgnHandle                 mask );
Parameters
data

Points to the compressed image data. This pointer must contain a 32-bit clean address.
desc

A handle to the ImageDescription structure that describes the compressed image.
dst

A handle to the pixel map where the decompressed image is to be displayed. Set the current graphics port to the port that contains this pixel map.
srcRect

A pointer to a rectangle defining the portion of the image to decompress. This rectangle must lie within the boundary rectangle of the compressed image, which is defined by (0,0) and ((**desc).width,(**desc).height). If you want to decompress the entire source image, set this parameter to NIL. If the parameter is NIL, the rectangle is set to the rectangle structure of the ImageDescription structure.
dstRect

A pointer to the rectangle into which the decompressed image is to be loaded. The compressor scales the source image to fit into this destination rectangle.
mode

The transfer mode for the operation, as listed in Graphics Transfer Modes.
mask

A handle to a clipping region in the destination coordinate system. If specified, the compressor applies this mask to the destination image. If you do not want to mask bits in the destination, set this parameter to NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Note that DecompressImage is invoked through the StdPix function. The following code sample illustrates the process of compressing and decompressing a pixel map.// DecompressImage coding example
// See "Discovering QuickTime," page 286
PicHandle GetQTCompressedPict (PixMapHandle hpmImage)
{
    long                    lMaxCompressedSize =0;
    Handle                  hCompressedData =NIL;
    Ptr                     pCompressedData;
    ImageDescriptionHandle  hImageDesc =NIL;
    OSErr                   nErr;
    PicHandle               hpicPicture =NIL;
    Rect                    rectImage =(**hpmImage).bounds;
    CodecType               dwCodecType =kJPEGCodecType;
    CodecComponent          codec =(CodecComponent)anyCodec;
    CodecQ                  dwSpatialQuality =codecNormalQuality;
    short                   nDepth =0;          // let ICM choose depth
    nErr =GetMaxCompressionSize(hpmImage, &rectImage, nDepth,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        (CompressorComponent)codec,
                                        &lMaxCompressedSize);
    if (nErr !=noErr)
        return NIL;
 
    hImageDesc =(ImageDescriptionHandle)NewHandle(4);
    hCompressedData =NewHandle(lMaxCompressedSize);
    if ((hCompressedData !=NIL) && (hImageDesc !=NIL)) {
        MoveHHi(hCompressedData);
        HLock(hCompressedData);
        pCompressedData =StripAddress(*hCompressedData);
 
        nErr =CompressImage(hpmImage,
                                        &rectImage,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        hImageDesc,
                                        pCompressedData);
 
        if (nErr ==noErr) {
            ClipRect(&rectImage);
            hpicPicture =OpenPicture(&rectImage);
            nErr =DecompressImage(pCompressedData,
                                        hImageDesc,
                                        hpmImage,
                                        &rectImage,
                                        &rectImage,
                                        srcCopy,
                                        NIL);
            ClosePicture();
        }
        if (theErr || (GetHandleSize((Handle)hpicPicture) ==
                                            sizeof(Picture))) {
            KillPicture(hpicPicture);
            hpicPicture =NIL;
        }
    }
    if (hImageDesc !=NIL)
        DisposeHandle((Handle)hImageDesc);
    if (hCompressedData !=NIL)
        DisposeHandle(hCompressedData);
    return hpicPicture;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr DecompressImage (
   Ptr                       data,
   ImageDescriptionHandle    desc,
   PixMapHandle              dst,
   const Rect                *srcRect,
   const Rect                *dstRect,
   short                     mode,
   RgnHandle                 mask ){};


/*DataHGetInfoFlags

Provides information about the operation of a data handler component.

ComponentResult DataHGetInfoFlags (
   DataHandler    dh,
   UInt32         *flags );
Parameters
dh

A data handler component.
flags

Flags (see below) that provide information about the data handler. See these constants: 
kDataHInfoFlagNeverStreams
kDataHInfoFlagCanUpdateDataRefs
kDataHInfoFlagNeedsNetworkBandwidth
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult DataHGetInfoFlags (
   DataHandler    dh,
   UInt32         *flags ){};

/*VDGetDeviceNameAndFlags

Returns the current name and device visibility of a video digitizer.

VideoDigitizerError VDGetDeviceNameAndFlags (
   VideoDigitizerComponent    ci,
   Str255                     outName,
   UInt32                     *outNameFlags );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
outName

The video digitizer device name.
outNameFlags

A pointer to a constant (see below) that determines whether to show or hide the VDIG device. See these constants: 
vdDeviceFlagShowInputsAsDevices
vdDeviceFlagHideDevice
Return Value

An error return of type ComponentResult. See Error Codes. Returns noErr if there is no error.
Discussion

This routine is designed to give the VDIG more control over how it is presented to the user, and to clarify the distinction between devices and inputs. Historically, the assumption has been that there is one component registered per device and that the component name is displayed. This function lets a component choose its name after registration. When this function is called, it is also a good time to check for hardware and register further VDIG components if needed, allowing for lazy initialization when the application needs to find a VDIG rather than initializing at every launch or replug.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetDeviceNameAndFlags (
   VideoDigitizerComponent    ci,
   Str255                     outName,
   UInt32                     *outNameFlags ){};
/*VDGetNumberOfInputs

Returns the number of input video sources that a video digitizer component supports.

VideoDigitizerError VDGetNumberOfInputs (
   VideoDigitizerComponent    ci,
   short                      *inputs );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
inputs

A pointer to an integer that is to receive the number of input video sources supported by the specified component. Video digitizer components number video sources sequentially, starting at 0. So, if a digitizer component supports two inputs, this function sets the field referred to by the inputs parameter to 1.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

All video digitizer components must support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetNumberOfInputs (
   VideoDigitizerComponent    ci,
   short                      *inputs ){};


/*VDGetInputName

Gets the name of a video input.

VideoDigitizerError VDGetInputName (
   VideoDigitizerComponent    ci,
   long                       videoInput,
   Str255                     name );
Parameters
ci

Specifies the video digitizer component for this operation. Applications can obtain this reference from OpenComponent or OpenDefaultComponent.
videoInput

The input video source for this request. Video digitizer components number video sources sequentially, starting at 0. So, to request information about the first video source, an application sets this parameter to 0. Applications can get the number of video sources supported by a video digitizer component by calling VDGetNumberOfInputs.
name

The video input source's name string.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetInputName (
   VideoDigitizerComponent    ci,
   long                       videoInput,
   Str255                     name ){};


/*VDGetInput

Returns data that identifies the currently active input video source.

VideoDigitizerError VDGetInput (
   VideoDigitizerComponent    ci,
   short                      *input );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
input

A pointer to a short integer that is to receive the identifier for the currently active input video source. Video digitizer components number video sources sequentially, starting at 0. So, if the first source is active, this function sets the field referred to by the input parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

All video digitizer components must support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDGetInput (
   VideoDigitizerComponent    ci,
   short                      *input ){};

/*VDGetSoundInputDriver

Retrieves information about a video digitizer's sound input driver.

VideoDigitizerError VDGetSoundInputDriver (
   VideoDigitizerComponent    ci,
   Str255                     soundDriverName );
Parameters
ci

Identifies the application's connection to the video digitizer component. An application obtains this value from OpenComponent or OpenDefaultComponent.
soundDriverName

A pointer to a string. The video digitizer returns the name of its sound input driver. If the digitizer does not have an associated driver, it returns a result code of digiUnimpErr.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDGetSoundInputDriver (
   VideoDigitizerComponent    ci,
   Str255                     soundDriverName ){};


/*VDGetDataRate

Retrieves information that describes the performance capabilities of a video digitizer.

VideoDigitizerError VDGetDataRate (
   VideoDigitizerComponent    ci,
   long                       *milliSecPerFrame,
   Fixed                      *framesPerSecond,
   long                       *bytesPerSecond );
Parameters
ci

Identifies the application's connection to the video digitizer component. An application obtains this value from OpenComponent or OpenDefaultComponent.
milliSecPerFrame

A pointer to a long integer. The video digitizer returns a value that indicates the number of milliseconds of synchronous overhead involved in digitizing a single frame. This value includes the average delay incurred between the time when the digitizer requests a frame from its associated device, and the time at which the device delivers the frame.
framesPerSecond

A pointer to a fixed value. The video digitizer supplies the maximum rate at which it can capture video. Note that this value may differ from the rate that the application set with VDSetFrameRate.
bytesPerSecond

A pointer to a long integer. Video digitizers that can return compressed image data return a value that indicates the approximate number of bytes per second that the digitizer is generating compressed data, given the current compression and frame rate settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetDataRate (
   VideoDigitizerComponent    ci,
   long                       *milliSecPerFrame,
   Fixed                      *framesPerSecond,
   long                       *bytesPerSecond ){};


/*VDGetImageDescription

Retrieves an ImageDescription structure from a video digitizer.

VideoDigitizerError VDGetImageDescription (
   VideoDigitizerComponent    ci,
   ImageDescriptionHandle     desc );
Parameters
ci

Identifies the application's connection to the video digitizer component. An application obtains this value from OpenComponent or OpenDefaultComponent.
desc

A handle. The video digitizer fills this handle with an ImageDescription structure containing information about the digitizer's current compression settings. The digitizer resizes the handle appropriately. It is the application's responsibility to dispose of this handle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetImageDescription (
   VideoDigitizerComponent    ci,
   ImageDescriptionHandle     desc ){};


/*VDGetCurrentFlags

Returns status information about a specified video digitizer component.

VideoDigitizerError VDGetCurrentFlags (
   VideoDigitizerComponent    ci,
   long                       *inputCurrentFlag,
   long                       *outputCurrentFlag );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
inputCurrentFlag

A pointer to a long integer that is to receive the current input state flags for the video digitizer component; see Video Digitizer Capabilities.
outputCurrentFlag

A pointer to a long integer that is to receive the current output state flags for the video digitizer component; see Video Digitizer Capabilities.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is often more convenient than VDGetDigitizerInfo. For example, this function provides a simple mechanism for determining whether a video digitizer is receiving a valid input signal. An application can retrieve the current input state flags and test the high-order bit by examining the sign of the returned value. If the value is negative (that is, the high-order bit, digiInSignalLock, is set to 1), the digitizer component is receiving a valid input signal.
Special Considerations

All video digitizer components must support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetCurrentFlags (
   VideoDigitizerComponent    ci,
   long                       *inputCurrentFlag,
   long                       *outputCurrentFlag ){};


/*QTNextChildAnyType

Returns the next atom in the child list of the specified parent atom.

OSErr QTNextChildAnyType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtom             currentChild,
   QTAtom             *nextChild );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
currentChild

The last atom retrieved by this function. To retrieve the first atom in the child list, set the value of currentChild to 0.
nextChild

A pointer to an uninitialized QT atom data structure. On return, the data structure contains the offset of the next atom in the child list after the atom specified by currentChild, or 0 if the atom specified by currentChild was the last atom in the list.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to iterate through all the atoms in a parent atom's child list, regardless of their types and IDs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTNextChildAnyType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtom             currentChild,
   QTAtom             *nextChild ){};



/*QTGetAtomTypeAndID

Retrieves an atom's type and ID.

OSErr QTGetAtomTypeAndID (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomType         *atomType,
   QTAtomID           *id );
Parameters
container

The atom container that contains the atom.
atom

The atom whose type and ID should be retrieved.
atomType

A pointer to an atom type. On return, this parameter points to the type of the specified atom. You can pass NIL for this parameter if you don't need this information.
id

A pointer to an atom ID. On return, this parameter points to the ID of the specified atom. You can pass NIL for this parameter if you don't need this information.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetAtomTypeAndID (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomType         *atomType,
   QTAtomID           *id ){};








































