#ifndef ATSLAYOUTTYPES_H
#define ATSLAYOUTTYPES_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef SFNTLAYOUTTYPES_H
#include <ATS/SFNTLayoutTypes.h>
#endif

#ifndef ATSTYPES_H
#include <ATS/ATSTypes.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*Glyph Origin Selectors

Specify which glyph origin to use to determine the width of the typographic glyph bounds.

enum {
   kATSUseCaretOrigins           = 0,
   kATSUseDeviceOrigins          = 1,
   kATSUseFractionalOrigins      = 2,
   kATSUseOriginFlags            = 3
};
Constants
kATSUseCaretOrigins

Specifies to use the caret origin to determine the width of the typographic glyph bounds. The caret origin is halfway between two characters. 

Available in Mac OS X v10.0 and later.
kATSUseDeviceOrigins

Specifies to use the glyph origin in device space to determine the width of the typographic glyph bounds. This is useful if you need to adjust text on the screen.

Available in Mac OS X v10.0 and later.
kATSUseFractionalOrigins

Specifies to use the glyph origin in fractional absolute positions (which are uncorrected for display device) to determine the width of the typographic glyph bounds. This provides the ideal position of laid-out text and is useful if you need to scale text on the screen. The glyph origin is also used to obtain the width of the typographic bounding rectangle when you call the function ATSUMeasureText.

Available in Mac OS X v10.0 and later.
kATSUseOriginFlags

The number of glyph origin selectors.

Available in Mac OS X v10.0 and later.
Discussion

You can pass a glyph bounds selector in the iTypeOfBounds parameter of the function ATSUGetGlyphBounds to indicate whether the width of the resulting typographic glyph bounds is determined using the caret origin, glyph origin in device space, or glyph origin in fractional absolute positions.*/

enum {
   kATSUseCaretOrigins           = 0,
   kATSUseDeviceOrigins          = 1,
   kATSUseFractionalOrigins      = 2,
   kATSUseOriginFlags            = 3
};


/*ATSTrapezoid

Contains the coordinates of the typographic bounding trapezoid for the final layout of a line a text.

struct ATSTrapezoid {
   FixedPoint upperLeft;
   FixedPoint upperRight;
   FixedPoint lowerRight;
   FixedPoint lowerLeft;
};
Fields
upperLeft

A structure of type FixedPoint that contains the upper left coordinates (assuming a horizontal line of text) of the typographic glyph bounds. 
upperRight

A structure of type FixedPoint that contains the upper right coordinates (assuming a horizontal line of text) of the typographic glyph bounds.
lowerRight

A structure of type FixedPoint that identifies the lower right coordinates (assuming a horizontal line of text) of the typographic glyph bounds.
lowerLeft

A structure of type FixedPoint that identifies the lower left coordinates (assuming a horizontal line of text) of the typographic glyph bounds.
Discussion

The dimensions of the resulting trapezoid are relative to the coordinates specified in the iTextBasePointX and iTextBasePointY parameters. The width of the glyph bounds is determined based on the value passed in the iTypeOfBounds parameter. 

The function ATSUGetGlyphBounds passes back an array of structures of type ATSTrapezoid to specify the enclosing trapezoid(s) of a final laid-out line of text. If the range of text spans directional boundaries, ATSUGetGlyphBounds produces multiple trapezoids defining these regions.
Version Notes

In ATSUI 1.1, the function ATSUGetGlyphBounds can pass back a maximum of 31 bounding trapezoids. In ATSUI 1.2, ATSUGetGlyphBounds can pass back as many as 127 bounding trapezoids.*/

typedef struct ATSTrapezoid {
   FixedPoint upperLeft;
   FixedPoint upperRight;
   FixedPoint lowerRight;
   FixedPoint lowerLeft;
}ATSTrapezoid;


/*Glyph Property Flags

Specify properties for a glyph.

typedef UInt32 ATSGlyphInfoFlags;
enum {
   kATSGlyphInfoAppleReserved    = 0x1FFBFFE8,
   kATSGlyphInfoIsAttachment     = (unsigned long)x80000000,
   kATSGlyphInfoIsLTHanger       = 0x40000000,
   kATSGlyphInfoIsRBHanger       = 0x20000000,
   kATSGlyphInfoTerminatorGlyph  = 0x00080000,
   kATSGlyphInfoIsWhiteSpace     = 0x00040000,
   kATSGlyphInfoHasImposedWidth  = 0x00000010,
   kATSGlyphInfoByteSizeMask     = 0x00000007
};
Constants
kATSGlyphInfoAppleReserved

This flag is reserved by Apple. If you try to use it you may get an invalid value error.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoIsAttachment

Specifies that the glyph attaches to another glyph.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoIsLTHanger

Specifies that the glyph can hang off the left or top edge of a line.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoIsRBHanger

Specifies that the glyph can hang off the right or bottom edge of a line.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoTerminatorGlyph

Specifies that the glyph is not truly a glyph, but an end-marker to allow the calculation of the previous glyph's advance.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoIsWhiteSpace

Specifies that the glyph is a whitespace glyph.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoHasImposedWidth

Specifies that the glyph has an imposed width (that is, an advance width) specified by the style.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoByteSizeMask

Specifies the size of the character that spawned the glyph. This is a three-bit mask that you can use to obtain the size of the original character that spawned a glyph. If you perform a logical and operation between this mask and an ATSGlyphInfoFlags flag, you obtain the size in bytes of the original character (0 - 7 bytes).

Available in Mac OS X v10.2 and later.
Discussion

Glyph information flags are set in the individual ATSLayoutRecord structure and apply only to the ATSGlyphRef reference in that structure. The flags are used by the ATSUI to tag a glyph with one or more specific properties.*/

typedef UInt32 ATSGlyphInfoFlags;
enum {
   kATSGlyphInfoAppleReserved    = 0x1FFBFFE8,
   kATSGlyphInfoIsAttachment     = (unsigned long)0x80000000,
   kATSGlyphInfoIsLTHanger       = 0x40000000,
   kATSGlyphInfoIsRBHanger       = 0x20000000,
   kATSGlyphInfoTerminatorGlyph  = 0x00080000,
   kATSGlyphInfoIsWhiteSpace     = 0x00040000,
   kATSGlyphInfoHasImposedWidth  = 0x00000010,
   kATSGlyphInfoByteSizeMask     = 0x00000007
};



/*ATSULineRef

Represents a reference to a structure that specifies a line of text. 

typedef struct ATSGlyphVector *ATSULineRef;
Discussion

You get an ATSUI line reference from ATSUI when your layout operation override callback is invoked. The line reference refers to the line that ATSUI is in the process of laying out.

From within your callback, you pass an ATSUI line reference to the function ATSUDirectGetLayoutDataArrayPtrFromLineRef to obtain layout data for that line. The only way you can obtain an ATSUI line reference is from inside your layout operation override callback. An ATSUI line reference is not valid is outside of the callback.
Availability
Available in Mac OS X v10.2 and later.*/
typedef struct ATSGlyphVector *ATSULineRef;



/*Layout Operation Selectors

Specify a layout operation. 

typedef UInt32 ATSULayoutOperationSelector;
enum {
   kATSULayoutOperationNone      = 0x00000000,
   kATSULayoutOperationJustification = 0x00000001,
   kATSULayoutOperationMorph     = 0x00000002,
   kATSULayoutOperationKerningAdjustment = 0x00000004,
   kATSULayoutOperationBaselineAdjustment = 0x00000008,
   kATSULayoutOperationTrackingAdjustment = 0x00000010,
   kATSULayoutOperationPostLayoutAdjustment = 0x00000020,
   kATSULayoutOperationAppleReserved = (unsigned long)xFFFFFFC0
};
Constants
kATSULayoutOperationNone

Specifies that no layout operation is currently selected.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationJustification

Specifies the justification operation.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationMorph

Specifies the character-morphing operation.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationKerningAdjustment

Specifies the kerning-adjustment operation.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationBaselineAdjustment

Specifies the baseline-adjustment operation.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationTrackingAdjustment

Specifies the tracking-adjustment operation.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationPostLayoutAdjustment

Specifies the period of time after ATSUI has completed its layout operations.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationAppleReserved

This selector is reserved for future use.

Available in Mac OS X v10.2 and later.
Discussion

You can use layout operation selectors to specify to ATSUI which operations to override. These selectors can also be passed from ATSUI to your application to indicate which operation is currently in progress.*/

typedef UInt32 ATSULayoutOperationSelector;
enum {
   kATSULayoutOperationNone      = 0x00000000,
   kATSULayoutOperationJustification = 0x00000001,
   kATSULayoutOperationMorph     = 0x00000002,
   kATSULayoutOperationKerningAdjustment = 0x00000004,
   kATSULayoutOperationBaselineAdjustment = 0x00000008,
   kATSULayoutOperationTrackingAdjustment = 0x00000010,
   kATSULayoutOperationPostLayoutAdjustment = 0x00000020,
   kATSULayoutOperationAppleReserved = (unsigned long)0xFFFFFFC0
};

/*Layout Callback Status Values

Specify the status of a layout operation override callback.

typedef UInt32 ATSULayoutOperationCallbackStatus;
enum {
   kATSULayoutOperationCallbackStatusHandled = 0x00000000,
   kATSULayoutOperationCallbackStatusContinue = 0x00000001
};
Constants
kATSULayoutOperationCallbackStatusHandled

Specifies that your callback function has handled the operation which triggered the callback. This indicates to ATSUI that it does not need to perform any further processing for the layout operation.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationCallbackStatusContinue

Specifies that your callback function has not handled the operation which triggered the callback. This indicates to ATSUI that needs to perform its own processing for the layout operation.

Available in Mac OS X v10.2 and later.
Discussion

You must return one of these status values from your ATSUDirectLayoutOperationOverrideProcPtr callback function to indicate to ATSUI whether or not your callback handled the layout operation.*/

typedef UInt32 ATSULayoutOperationCallbackStatus;
enum {
   kATSULayoutOperationCallbackStatusHandled = 0x00000000,
   kATSULayoutOperationCallbackStatusContinue = 0x00000001
};


/*ATSUDirectLayoutOperationOverrideProcPtr

Defines a pointer to a layout operation callback that overrides an ATSUI layout operation.

typedef CALLBACK_API_C (OSStatus, ATSUDirectLayoutOperationOverrideProcPtr
)
   ATSULayoutOperationSelector iCurrentOperation,
   ATSULineRef iLineRef,
   UInt32 iRefCon,
   void *iOperationCallbackParameterPtr,
   ATSULayoutOperationCallbackStatus *oCallbackStatus
);

If you name your function MyLayoutOperationOverrideCallback, you would declare it like this:

OSStatus MyLayoutOperationOverrideCallback
(
   ATSULayoutOperationSelector iCurrentOperation,
   ATSULineRef iLineRef,
   UInt32 iRefCon,
   void *iOperationCallbackParameterPtr,
   ATSULayoutOperationCallbackStatus *oCallbackStatus
);
Parameters
iCurrentOperation

The operation that triggered the callback. This value is passed to your callback by ATSUI. If you write a callback that handles more than one layout operation, you can use this value to determine which operation you should handle.
iLineRef

An ATSULineRef value that specifies the line of text on which your callback will operation. Your callback gets called for each line of text associated with the text layout object on which you installed the callback.
iRefCon

An unsigned 32-bit integer. This is an optional value. You can use this value to specify any data your application needs, such as user preference data. 
iOperationCallbackParameterPtr

A pointer. This is currently unused and should be set to NULL.
oCallbackStatus

A layout callback status value. On output, you must supply a status value to indicate to ATSUI whether or not your callback handled the operation. See “Layout Callback Status Values” for a list of the constants you can supply.
Discussion

ATSUI calls your layout operation override function each time the layout operation you specify is invoked. You associate a universal procedure pointer with a text layout object by treating the callback as a layout attribute. That is, you set up a triple (tag, size, value) to specify the layout operation your callback handles, then you call the function ATSUSetLayoutControls to associate the triple with the text layout object whose layout operation you want to override. The attribute tag you specify is kATSULayoutOperationOverrideTag. The attribute value you specify is an ATSULayoutOperationOverrideSpecifier structure that contains a selector for a layout operation and a pointer to your callback function.

To provide a pointer to your layout operation override callback, you create a universal procedure pointer (UPP) of type ATSUDirectLayoutOperationOverrideUPP, using the function NewATSUDirectLayoutOperationOverrideUPP. You can do so with code similar to the following:ATSUDirectLayoutOperationOverrideUPP MyLayoutOperationOverrideUPP;
MyLayoutOperationOverrideUPP = NewATSUDirectLayoutOperationOverrideUPP
                                (&MyLayoutOperationOverrideCallback);


When your layout operation is completed, you should use the function DisposeATSUDirectLayoutOperationOverrideUPP to dispose of the universal procedure pointer associated with your layout operation override function. However, if you plan to use the same layout operation override function in subsequent layout operations, you can reuse the same UPP, rather than dispose of it and later create a new UPP.

You are limited to the ATSUI functions you can call from within your callback. You can call only those functions that have do not trigger ATSUI to perform the layout operation again. Otherwise, you run the risk of causing infinite recursion. Most functions that use “create”, “get”, or “copy” semantics are safe to use within your callback. If you call one of the restricted functions, the function returns immediately with the error kATSUInvalidCallInsideCallbackErr.*/
typedef CALLBACK_API_C (OSStatus, ATSUDirectLayoutOperationOverrideProcPtr)(
   ATSULayoutOperationSelector iCurrentOperation,
   ATSULineRef iLineRef,
   UInt32 iRefCon,
   void *iOperationCallbackParameterPtr,
   ATSULayoutOperationCallbackStatus *oCallbackStatus
);




/*ATSUDirectLayoutOperationOverrideUPP

Defines a universal procedure pointer to a layout operation callback.

typedef ATSUDirectLayoutOperationOverrideProcPtr ATSUDirectLayoutOperationOverrideUPP;
Discussion

For more information, see the description of the ATSUDirectLayoutOperationOverrideProcPtr callback function.*/
typedef ATSUDirectLayoutOperationOverrideProcPtr ATSUDirectLayoutOperationOverrideUPP;


/*ATSULayoutOperationOverrideSpecifier

Contains an layout operation selector and a pointer to a layout operation override callback.

struct ATSULayoutOperationOverrideSpecifier {
   ATSULayoutOperationSelector  operationSelector;
   ATSUDirectLayoutOperationOverrideUPP  overrideUPP;
};
typedef struct ATSULayoutOperationOverrideSpecifier ATSULayoutOperationOverrideSpecifier;
Fields
operationSelector

A layout operation selector that specifies the operation for which the callback should be invoked. See “Layout Operation Selectors” for the selectors you can specify.
overrideUPP

A universal procedure pointer to a layout operation override callback.
Discussion

You can pass this structure as an attribute value for the layout attribute tag kATSULayoutOperationOverrideTag.
Availability
Available in Mac OS X v10.2 and later.*/

struct ATSULayoutOperationOverrideSpecifier {
   ATSULayoutOperationSelector  operationSelector;
   ATSUDirectLayoutOperationOverrideUPP  overrideUPP;
};
typedef struct ATSULayoutOperationOverrideSpecifier ATSULayoutOperationOverrideSpecifier;


/*ATSLayoutRecord

Contains basic layout information for a single glyph. 

struct ATSLayoutRecord {
   ATSGlyphRef         glyphID;
   ATSGlyphInfoFlags   flags;
   ByteCount           originalOffset;
   Fixed               realPos;
};
typedef struct ATSLayoutRecord ATSLayoutRecord;
Fields
glyphID

A reference to a glyph ID.
flags

A flag that specifies the glyph’s properties. See “Glyph Property Flags” for the constants you can use. 
originalOffset

The byte offset of the character with which this glyph is associated.
realPos

A Fixed value that specifies the real position of the glyph. This is the x-coordinate of the glyph.
Availability
Available in Mac OS X v10.2 and later.*/
struct ATSLayoutRecord {
   ATSGlyphRef         glyphID;
   ATSGlyphInfoFlags   flags;
   ByteCount           originalOffset;
   Fixed               realPos;
};
typedef struct ATSLayoutRecord ATSLayoutRecord;


#ifdef __cplusplus
}
#endif

#endif