
#import <AppKit/AppKitDefines.h>
#import <Foundation/NSObject.h>
#import <Foundation/NSRange.h>

@class NSArray, NSDictionary, NSString, NSURL;


@interface NSSpeechSynthesizer : NSObject {}
/*setDelegate:

Sets the receiver’s delegate.

- (void)setDelegate:(id)delegate
Parameters
delegate

Object to be the receiver’s delegate.
Availability
Available in Mac OS X v10.3 and later.
See Also
– delegate*/
- (void)setDelegate:(id)delegate;

/*stopSpeaking

Stops synthesis in progress.

- (void)stopSpeaking
Discussion

If the receiver is currently generating speech, synthesis is halted, and the message speechSynthesizer:didFinishSpeaking: is sent to the delegate.
Availability
Available in Mac OS X v10.3 and later.
See Also
– isSpeaking
– startSpeakingString:
– startSpeakingString:toURL:*/
- (void)stopSpeaking;

/*startSpeakingString:

Begins speaking synthesized text through the system’s default sound output device.

- (BOOL)startSpeakingString:(NSString *)text
Parameters
text

Text to synthesize. When nil or empty, no synthesis occurs.
Return Value

YES when synthesis starts successfully, NO otherwise.
Discussion

If the receiver is currently speaking synthesized speech when startSpeakingString: is called, that process is stopped before text is spoken.

When synthesis of text finishes normally or is stopped, the message speechSynthesizer:didFinishSpeaking: is sent to the delegate.
Availability
Available in Mac OS X v10.3 and later.
See Also
– isSpeaking
– startSpeakingString:toURL:
– stopSpeaking*/
- (BOOL)startSpeakingString:(NSString *)text;
@end






