#ifndef ALIASES_H
#define ALIASES_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef FILES_H
#include <CarbonCore/Files.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Matching Constants

Specify the matching criteria for the alias matching functions.

enum {
   kARMMountVol = 0x00000001,
   kARMNoUI = 0x00000002,
   kARMMultVols = 0x00000008,
   kARMSearch = 0x00000100,
   kARMSearchMore = 0x00000200,
   kARMSearchRelFirst = 0x00000400,
   kARMTryFileIDFirst = 0x00000800
};
Constants
kARMMountVol

Automatically try to mount the target’s volume if it is not mounted.

Available in Mac OS X v10.0 and later.
kARMNoUI

Stop if a search requires user interaction, such as a password dialog box when mounting a remote volume. If user interaction is needed and kARMNoUI is in effect, the search fails.

Available in Mac OS X v10.0 and later.
kARMMultVols

Search all mounted volumes. The search begins with the volume on which the target resided when the record was created. When you specify a fast search of all mounted volumes, MatchAlias performs a formal fast search only on the volume described in the alias record. On all other volumes it looks for the target by ID or by name in the directory with the specified parent directory ID. When you specify an exhaustive search of multiple volumes, MatchAlias performs the same search on all volumes. When resolving an alias record created by NewAliasMinimalFromFullPath, MatchAlias ignores this flag.

Available in Mac OS X v10.0 and later.
kARMSearch

Perform a fast search for the alias target. If kARMSearchRelFirst is not set, perform an absolute search first, followed by a relative search only if the value of the fromFile parameter is not NULL and the list of matches is not full.

Available in Mac OS X v10.0 and later.
kARMSearchMore

Perform an exhaustive search for the alias target. On HFS volumes, the exhaustive search uses the File Manager function PBCatSearch to identify candidates with matching creation date, type, and creator. The PBCatSearch function is available only on HFS volumes and only on systems running version 7.0 or later. On MFS volumes or HFS volumes that do not support PBCatSearch, the exhaustive search makes a series of indexed calls to File Manager functions, using the same search criteria. If you set kARMSearchMore and either or both of kARMSearch and kARMSearchRelFirst, MatchAlias performs the fast search first.

Available in Mac OS X v10.0 and later.
kARMSearchRelFirst

If kARMSearch is also set, perform a relative search before the absolute search. (If kARMSearch is also set and the target is found through the absolute search, MatchAlias sets the needsUpdate flag to true.) If neither kARMSearch nor kARMSearchMore is set, perform only a relative search. If kARMSearch is not set but kARMSearchMore is set, perform a relative search followed by an exhaustive search.

Available in Mac OS X v10.0 and later.
kARMTryFileIDFirst

Perform a search using the file ID of the target before searching using the path.

Available in Mac OS X v10.2 and later.
Discussion

The FSMatchAlias, FSMatchAliasNoUI, MatchAliasNoUI and MatchAlias functions use these constants to specify the matching criteria by passing a sum of these constants in the rulesMask parameter. You must specify at least one of the last three parameters: kARMSearch, kARMSearchMore, and kARMSearchRelFirst.*/
enum {
   kARMMountVol = 0x00000001,
   kARMNoUI = 0x00000002,
   kARMMultVols = 0x00000008,
   kARMSearch = 0x00000100,
   kARMSearchMore = 0x00000200,
   kARMSearchRelFirst = 0x00000400,
   kARMTryFileIDFirst = 0x00000800
};


/*Volume Mount Options

Specify how an alias should be resolved.

enum {
   kResolveAliasFileNoUI = 0x00000001,
   kResolveAliasTryFileIDFirst = 0x00000002
};
Constants
kResolveAliasFileNoUI

The Alias Manager should resolve the alias without presenting a user interface.

Available in Mac OS X v10.0 and later.
kResolveAliasTryFileIDFirst

The Alias Manager should search for the alias target using file IDs before searching using the path.

Available in Mac OS X v10.2 and later.
Discussion

The FSResolveAliasWithMountFlags, FSResolveAliasFileWithMountFlags, ResolveAliasWithMountFlags, ResolveAliasFileWithMountFlags, and ResolveAliasFileWithMountFlagsNoUI functions take these constants in the mountFlags parameter, allowing you to specify how the alias should be resolved.*/
enum {
   kResolveAliasFileNoUI = 0x00000001,
   kResolveAliasTryFileIDFirst = 0x00000002
};

/*Alias Resource Type

Specifies the file type of an alias resource file.

enum {
   rAliasType = 'alis'
};*/
enum {
   rAliasType = 'alis'
};


/*AliasRecord

Defines an alias record.

struct AliasRecord {
   OSType userType;
   unsigned short aliasSize;
};
typedef struct AliasRecord              AliasRecord;
typedef AliasRecord *                   AliasPtr;
typedef AliasPtr *                      AliasHandle;
Fields
userType

A 4-byte field that can contain application-specific data. When an alias record is created, this field contains 0. Your application can use this field for its own purposes.
aliasSize

The size, in bytes, assigned to the alias record at the time of its creation or updating. This is the total size of the record, including the userType and aliasSize fields, as well as the variable-length data that is private to the Alias Manager.
Discussion

The Alias Manager uses alias records to store information that allows it to locate an object in the file system. 
Availability
Available in Mac OS X v10.0 and later.*/
struct AliasRecord {
   OSType userType;
   unsigned short aliasSize;
};
typedef struct AliasRecord              AliasRecord;
typedef AliasRecord *                   AliasPtr;
typedef AliasPtr *                      AliasHandle;

/*AliasPtr

Abst_AliasPtr

typedef AliasRecord * AliasPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef AliasRecord * AliasPtr;

/*AliasHandle

Abst_AliasHandle

typedef AliasPtr * AliasHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef AliasPtr * AliasHandle;

/*NewAliasMinimalFromFullPath

Creates an alias record that contains only the full pathname of the target. (Deprecated in Mac OS X v10.4. Use FSNewAliasMinimal or FSNewAliasMinimalUnicode instead.)

Not recommended

OSErr NewAliasMinimalFromFullPath (
   short fullPathLength,
   const void * fullPath,
   ConstStr32Param zoneName,
   ConstStr31Param serverName,
   AliasHandle * alias
);
Parameters
fullPathLength

The number of characters in the full pathname of the target.
fullPath

A pointer to a buffer that contains the full pathname of the target. The full pathname starts with the name of the volume, includes all of the directory names in the path to the target, and ends with the target name. (For a description of pathnames, see the documentation for the File Manager.)
zoneName

The AppleTalk zone name of the AppleShare volume on which the target resides. Set this parameter to a null string if you do not need it.
serverName

The AppleTalk server name of the AppleShare volume on which the target resides. Set this parameter to a null string if you do not need it.
alias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets alias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The NewAliasMinimalFromFullPath function creates an alias record that identifies the target by full pathname. You can call NewAliasMinimalFromFullPath to create an alias record for a file that doesn’t exist or that resides on an unmounted volume.

The NewAliasMinimalFromFullPath function uses the standard alias record data structure, but it fills in only the information provided in the input parameters. You can therefore use NewAliasMinimalFromFullPath to create alias records for targets on unmounted volumes. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSNewAliasMinimal or FSNewAliasMinimalUnicode instead.
Declared In
Aliases.h*/
OSErr NewAliasMinimalFromFullPath (
   short fullPathLength,
   const void * fullPath,
   ConstStr32Param zoneName,
   ConstStr31Param serverName,
   AliasHandle * alias
);

/*ResolveAlias

Identifies the single most likely target of an alias record. (Deprecated in Mac OS X v10.4. Use FSResolveAlias instead.)

Not recommended

OSErr ResolveAlias (
   const FSSpec * fromFile,
   AliasHandle alias,
   FSSpec * target,
   Boolean * wasChanged
);
Parameters
fromFile

A pointer to the starting point for a relative search. If you pass a fromFile parameter of NULL, ResolveAlias performs only an absolute search. If you pass a pointer to a valid FSSpec structure in the fromFile parameter, ResolveAlias performs a relative search for the target, followed by an absolute search only if the relative search fails. If you want to perform an absolute search followed by a relative search, you must use the MatchAlias function.
alias

A handle to the alias record to be resolved and, if necessary, updated.
target

A pointer to the target of the alias record. This parameter must be a valid FSSpec structure.
wasChanged

A pointer to a Boolean value indicating whether the alias record to be resolved was updated because it contained some outdated information about the target. If it updates the alias record, ResolveAlias sets the wasChanged parameter to true. Otherwise, it sets it to false. (ResolveAlias never updates a minimal alias, so it never sets wasChanged to true when resolving a minimal alias.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The ResolveAlias function performs a fast search for the target of the alias. If the resolution is successful, ResolveAlias returns (in the target parameter) the FSSpec structure for the target file system object, updates the alias record if necessary, and reports (through the wasChanged parameter) whether the record was updated. If the target is on an unmounted AppleShare volume, ResolveAlias automatically mounts the volume. If the target is on an unmounted ejectable volume, ResolveAlias asks the user to insert the volume. The ResolveAlias function exits after it finds one acceptable target.

After it identifies a target, ResolveAlias compares some key information about the target with the information in the alias record. (The description of the MatchAlias function lists the key information.) If the information differs, ResolveAlias updates the record to match the target.

When it finds the specified volume and parent directory but fails to find the target file or directory in that location, ResolveAlias returns a result code of fnfErr and fills in the target parameter with a complete FSSpec structure describing the target (that is, the volume reference number, parent directory ID, and filename or folder name). The FSSpec structure is valid, although the object it describes does not exist. This information is intended as a "hint" that lets you explore possible solutions to the resolution failure. You can, for example, pass the FSSpec structure to the File Manager function FSpCreate to create a replacement for a missing file.

The ResolveAlias function displays the standard dialog boxes when it needs input from the user, such as a name and password for mounting a remote volume. The user can cancel the resolution through these dialog boxes. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSResolveAlias instead.
Declared In
Aliases.h*/
OSErr ResolveAlias (
   const FSSpec * fromFile,
   AliasHandle alias,
   FSSpec * target,
   Boolean * wasChanged
);

/*FSResolveAlias

Returns an FSRef to the single most likely target of an alias record.

OSErr FSResolveAlias (
   const FSRef * fromFile,
   AliasHandle alias,
   FSRef * target,
   Boolean * wasChanged
);
Parameters
fromFile

A pointer to an FSRef specifying the starting point for a relative search. If you pass NULL in this parameter, FSResolveAlias performs only an absolute search. If you pass a pointer to a valid FSRef in the fromFile parameter, FSResolveAlias performs a relative search for the target, followed by an absolute search only if the relative search fails. If you want to perform an absolute search followed by a relative search, you must use the FSMatchAlias function.
alias

A handle to the alias record to be resolved and, if necessary, updated.
target

A pointer to an FSRef. On successful return, this FSRef describes the target of the alias record. This parameter must point to a valid FSRef structure.
wasChanged

A pointer to a Boolean value indicating, on return, whether the alias record in the alias parameter was updated because it contained some outdated information about the target. If it updates the alias record, FSResolveAlias sets the wasChanged parameter to true. Otherwise, it sets it to false. (FSResolveAlias never updates a minimal alias, so it never sets wasChanged to true when resolving a minimal alias.
Return Value

A result code. When it finds the specified volume and parent directory but fails to find the target file or directory in that location, FSResolveAlias returns fnfErr. Note that the FSRef in the alias parameter is not valid in this case.
Discussion

The FSResolveAlias function performs a fast search for the target of the alias. If the resolution is successful, FSResolveAlias returns (in the target parameter) the FSRef for the target file system object, updates the alias record if necessary, and reports (through the wasChanged parameter) whether the record was updated. If the target is on an unmounted AppleShare volume, FSResolveAlias automatically mounts the volume. If the target is on an unmounted ejectable volume, FSResolveAlias asks the user to insert the volume. The FSResolveAlias function exits after it finds one acceptable target.

After it identifies a target, FSResolveAlias compares some key information about the target with the information in the alias record. If the information differs, FSResolveAlias updates the record to match the target.

The FSResolveAlias function displays the standard dialogs when it needs input from the user, such as a name and password for mounting a remote volume. The user can cancel the resolution through these dialogs. 
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/

OSErr FSResolveAlias (
   const FSRef * fromFile,
   AliasHandle alias,
   FSRef * target,
   Boolean * wasChanged
);

/*FSNewAlias

Creates a new alias record, given a file system reference (FSRef) to the target file or directory.

OSErr FSNewAlias (
   const FSRef * fromFile,
   const FSRef * target,
   AliasHandle * inAlias
);
Parameters
fromFile

A pointer to a file system reference specifying the starting point for a relative path, to be used later in a relative search. If you do not need relative path information in the structure, pass a fromFile value of NULL. If you want FSNewAlias to record relative path information, pass a pointer to a valid FSRef in this parameter. The two files or directories, specified in the fromFile and target parameters, must reside on the same volume.
target

A pointer to an FSRef for the target of the alias record.
inAlias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets inAlias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The FSNewAlias function creates an alias record that describes the specified target. It allocates the storage, fills in the record, and puts a record handle to that storage in the inAlias parameter. FSNewAlias records the full pathname of the target and a collection of other information relevant to locating the target, verifying the target, and mounting the target’s volume, if necessary. You can have FSNewAlias store relative path information as well by supplying a starting point for a relative path. 
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/OSErr FSNewAlias (
   const FSRef * fromFile,
   const FSRef * target,
   AliasHandle * inAlias
);

/*FSIsAliasFile

Determines whether a file system object is an alias file, a data file, or a folder.

OSErr FSIsAliasFile (
   const FSRef * fileRef,
   Boolean * aliasFileFlag,
   Boolean * folderFlag
);
Parameters
fileRef

A pointer to a file system object. 
aliasFileFlag

A pointer to a Boolean variable. On return, a value of TRUE indicates that the object specified in the fileRef parameter is an alias file. A value of FALSE indicates that the object is not an alias file. 
folderFlag

A pointer to a Boolean variable. On return, a value of TRUE indicates that the object specified in the fileRef parameter is a folder. A value of FALSE indicates that the object is a file. 
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

Table 1 summarizes the information that this function provides about the object specified in the fileRef parameter: 
Table 1  Information about a file system object
Alias flag	
Folder flag	
Object kind 

T	
F	
Alias file

F	
F	
Data file

F	
T	
Folder


Note that if fileRef is an alias file, this function does not provide any information about the object to which the alias refers. To find out whether this object is a file or a folder, you can use FSResolveAliasFile.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/

OSErr FSIsAliasFile (
   const FSRef * fileRef,
   Boolean * aliasFileFlag,
   Boolean * folderFlag
);

/*FSResolveAliasFileWithMountFlags

Resolves an alias contained in an alias file.

OSErr FSResolveAliasFileWithMountFlags (
   FSRef * theRef,
   Boolean resolveAliasChains,
   Boolean * targetIsFolder,
   Boolean * wasAliased,
   unsigned long mountFlags
);
Parameters
theRef

A pointer to a file system reference (FSRef) for the alias file you plan to open. If the function completes successfully, this FSRef describes the file or the directory referred to by the alias file.
resolveAliasChains

A Boolean value. Set this parameter to TRUE if you want FSResolveAliasFileWithMountFlags to resolve all aliases in a chain (for example, an alias file that refers to an alias file and so on), stopping only when it reaches the target file. Set this parameter to FALSE if you want to resolve only one alias file, even if the target is another alias file. 
targetIsFolder

A pointer to a Boolean value. The FSResolveAliasFileWithMountFlags function returns TRUE in this parameter if the FSRef in the parameter theRef points to a directory or a volume; otherwise, FSResolveAliasFileWithMountFlags returns FALSE in this parameter. 
wasAliased

A pointer to a Boolean value. The FSResolveAliasFileWithMountFlags function returns TRUE in this parameter if the FSRef in the parameter theRef points to an alias; otherwise, FSResolveAliasFileWithMountFlags returns FALSE in this parameter. 
mountFlags

Options controlling how the alias file is resolved. See “Volume Mount Options” for a description of the values you can use here. Set this parameter to kResolveAliasFileNoUI to prevent any user interaction, including disk switch alerts, while the alias is being resolved.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The function FSResolveAliasFileWithMountFlags is identical to FSResolveAliasFile with the exception that it provides the mountFlags parameter, allowing callers additional control over how the alias file is resolved.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/
OSErr FSResolveAliasFileWithMountFlags (
   FSRef * theRef,
   Boolean resolveAliasChains,
   Boolean * targetIsFolder,
   Boolean * wasAliased,
   unsigned long mountFlags
);


/*NewAliasMinimal

Creates a short alias record quickly. (Deprecated in Mac OS X v10.4. Use FSNewAliasMinimal instead.)

Not recommended

OSErr NewAliasMinimal (
   const FSSpec * target,
   AliasHandle * alias
);
Parameters
target

A pointer to an FSSpec structure for the target of the alias record.
alias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets alias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The NewAliasMinimal function creates an alias record that contains only the minimum information necessary to describe the target: the target name, the parent directory ID, the volume name and creation date, and the volume mounting information. The NewAliasMinimal function uses the standard alias record data structure, but it fills in only parts of the record.

The ResolveAlias function never updates a minimal alias record. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSNewAliasMinimal instead.
Declared In
Aliases.h*/

OSErr NewAliasMinimal (
   const FSSpec * target,
   AliasHandle * alias
);


#ifdef __cplusplus
}
#endif

#endif