#ifndef FILES_H
#define FILES_H


#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef OSUTILS_H
#include <CarbonCore/OSUtils.h>
#endif

#ifndef TEXTCOMMON_H
#include <CarbonCore/TextCommon.h>
#endif

#ifndef UTCUTILS_H
#include <CarbonCore/UTCUtils.h>
#endif



#ifndef FINDER_H
#include <CarbonCore/Finder.h>
#endif


#ifndef CFURL_H
#include <CoreFoundation/CFURL.h>
#endif

#ifndef CFRUNLOOP_H
#include <CoreFoundation/CFRunLoop.h>
#endif


#ifndef  CFUUID_H
#include <CoreFoundation/CFUUID.h>
#endif


#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/acl.h>
#include <DiskArbitration/DADisk.h>


#include <AvailabilityMacros.h>

#include <HYS/CarbonCore/Files.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*Allocation Flags

Indicate how new space is to be allocated.

typedef UInt16 FSAllocationFlags;
enum {
   kFSAllocDefaultFlags = 0x0000,
   kFSAllocAllOrNothingMask = 0x0001,
   kFSAllocContiguousMask = 0x0002,
   kFSAllocNoRoundUpMask = 0x0004,
   kFSAllocReservedMask = 0xFFF8
};
Constants
kFSAllocDefaultFlags

Allocate as much as possible, not necessarily contiguous.

Available in Mac OS X v10.0 and later.
kFSAllocAllOrNothingMask

This bit is set when an allocation must allocate the total requested amount, or else fail with nothing allocated; when this bit is not set, the allocation may complete successfully but allocate less than requested.

Available in Mac OS X v10.0 and later.
kFSAllocContiguousMask

This bit is set when an allocation should allocate one contiguous range of space on the volume. If this bit is clear, multiple discontiguous extents may be allocated to fulfill the request.

Available in Mac OS X v10.0 and later.
kFSAllocNoRoundUpMask

This bit is set when an allocation should no round up to the clump size. If ths bit is clear, then additional space beyond the amount requested may be allocated; this is done by some volume formats (including HFS and HFS Plus) to avoid many small allocation requests. If the bit is set, no additional allocation is done (except where required by the volume format, such as rounding up to a multiple of the allocation block size).

Available in Mac OS X v10.0 and later.
kFSAllocReservedMask

Reserved; set to zero.

Available in Mac OS X v10.0 and later.
Discussion

If the kAllocContiguousMask bit is set, then then any newly allocated space must be in one contiguous extent (preferably contiguous with any space already allocated). If kAllocAllOrNothingMask is set, then the entire requestCount bytes must be allocated for the call to succeed; if not set, as many bytes as possible will be allocated (without error). If kFSAllocNoRoundUpMask is set, then no additional space is allocated (such as rounding up to a multiple of a clump size); if clear, the volume format may allocate more space than requested as an attempt to reduce fragmentation.*/

typedef UInt16 FSAllocationFlags;
enum {
   kFSAllocDefaultFlags = 0x0000,
   kFSAllocAllOrNothingMask = 0x0001,
   kFSAllocContiguousMask = 0x0002,
   kFSAllocNoRoundUpMask = 0x0004,
   kFSAllocReservedMask = 0xFFF8
};


/*Cache Constants

Indicate whether or not data should be cached.

enum {
   pleaseCacheBit = 4,
   pleaseCacheMask = 0x0010,
   noCacheBit = 5,
   noCacheMask = 0x0020,
   rdVerifyBit = 6,
   rdVerifyMask = 0x0040,
   rdVerify = 64,
   forceReadBit = 6,
   forceReadMask = 0x0040,
   newLineBit = 7,
   newLineMask = 0x0080,
   newLineCharMask = 0xFF00
};
Constants
pleaseCacheBit

Indicates that the data should be cached.

Available in Mac OS X v10.0 and later.
pleaseCacheMask

Requests that the data be cached, if possible. You should cache reads and writes if you read or write the same portion of a file multiple times.

Available in Mac OS X v10.0 and later.
noCacheBit

Indicates that data should not be cached.

Available in Mac OS X v10.0 and later.
noCacheMask

Requests that the data not be cached, if possible. You should not cache reads and writes if you read or write data from a file only once.

Available in Mac OS X v10.0 and later.
rdVerifyBit

Indicates that all reads should come from the source and be verified against the data in memory.

Available in Mac OS X v10.0 and later.
rdVerifyMask

Requests that all reads (not writes) come directly from the source and be verified against the data in memory. This flushes the cache and sends all read requests to the data source.

Available in Mac OS X v10.0 and later.
rdVerify

This is the old name of rdVerifyMask. Both request that all reads come directly from the source of the data and be compared against the data in memory.

Available in Mac OS X v10.0 and later.
forceReadBit

Indicates that reads should come from the disk.

Available in Mac OS X v10.0 and later.
forceReadMask

Forces reads from disk, bypassing all caches. Clients can use this to verify that data is stored correctly on the media (eg., to verify after writing) by reading the data into a different buffer while setting the bit, and then comparing the newly read data with the previously written data.

The forceReadMask is the same as the rdVerifyMask used in the older APIs. The actual implementation of the rdVerifyMask in the older APIs actually caused the “force read” behavior, and only compared the data in partial sectors. FSReadFork cleans up this behavior by always letting the client do all of the compares.

Available in Mac OS X v10.0 and later.
newLineBit

Indicates that newline mode should be used for reads.

Available in Mac OS X v10.0 and later.
newLineMask

Requests that newline mode be used for reads. In newline mode, the read stops when one of the following conditions is met:
The requested number of bytes have been read.
The end-of-file is reached.
The newline character has been read. If the newline character is found, it will be the last character put into the buffer and the number of bytes read will include it.

Available in Mac OS X v10.0 and later.
newLineCharMask

Available in Mac OS X v10.0 and later.
Discussion

For the FSReadFork and FSWriteFork functions, and their parameter block equivalents, you may add either of the pleaseCacheMask or noCacheMask constants to one of the Position Mode Constants to hint whether the data should be cached or not. 

The pleaseCacheBit and the noCacheBit are mutually exclusive and only one should be set at a time. If neither bit is set, the program has indicated that it doesn’t care if the data is cached or not.*/
enum {
   pleaseCacheBit = 4,
   pleaseCacheMask = 0x0010,
   noCacheBit = 5,
   noCacheMask = 0x0020,
   rdVerifyBit = 6,
   rdVerifyMask = 0x0040,
   rdVerify = 64,
   forceReadBit = 6,
   forceReadMask = 0x0040,
   newLineBit = 7,
   newLineMask = 0x0080,
   newLineCharMask = 0xFF00
};


/*IOCompletionProcPtr

Defines a pointer to a completion function. Your completion function is executed by the File Manager after the completion of an asynchronous File Manager function call.

typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

If you name your function MyIOCompletionProc, you would declare it like this:

void MyIOCompletionProc (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the parameter block that was passed to the asynchronous File Manager function.
Return Value
Discussion

When you execute an asynchronous File Manager function (an Async function), you can specify a completion routine by passing the routine’s address in the ioCompletion field of the parameter block passed to the function. Because you requested asynchronous execution, the File Manager places an I/O request in the file I/O queue and returns control to your application—possibly even before the actual I/O operation is completed. The File Manager takes requests from the queue one at a time and processes them meanwhile, your application is free to do other processing.

A function executed asynchronously returns control to your application with the result code noErr as soon as the call is placed in the file I/O queue. This result code does not indicate that the call has successfully completed, but simply indicates that the call was successfully placed in the queue. To determine when the call is actually completed, you can inspect the ioResult field of the parameter block. This field is set to a positive number when the call is made and set to the actual result code when the call is completed. If you specify a completion routine, it is executed after the result code is placed in ioResult.

The File Manager, when the File Sharing or AppleShare file server is active, will execute requests in arbitrary order. That means that if there is a request that depends on the completion of a previous request, it is an error for your program to issue the second request until the completion of the first request. For example, issuing a write request and then issuing a read request for the same data isn't guaranteed to read back what was written unless the read request isn't made until after the write request completes.

Request order can also change if a call results in a disk switch dialog to bring an offline volume back online. 
Special Considerations

Because a completion routine is executed at interrupt time, it should not allocate, move, or purge memory (either directly or indirectly) and should not depend on the validity of handles to unlocked blocks.

If your completion routine uses application global variables, it must also ensure that register A5 contains the address of the boundary between your application global variables and your application parameters.*/
typedef union ParamBlockRec ParamBlockRec;
typedef ParamBlockRec * ParmBlkPtr;

typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

/*IOCompletionUPP

A universal procedure pointer to an application-defined completion function.

typedef IOCompletionProcPtr IOCompletionUPP;
Discussion

See IOCompletionProcPtr.*/
typedef IOCompletionProcPtr IOCompletionUPP;

/*IOParam

Defines a parameter block used by low-level I/O functions.

struct IOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioRefNum;
   SInt8 ioVersNum;
   SInt8 ioPermssn;
   Ptr ioMisc;
   Ptr ioBuffer;
   long ioReqCount;
   long ioActCount;
   short ioPosMode;
   long ioPosOffset;
};
typedef struct IOParam IOParam;
typedef IOParam * IOParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioRefNum

The file reference number of an open file.
ioVersNum

A version number. This field is no longer used and you should always set it to 0.
ioPermssn

The access mode. See File Access Permission Constants.
ioMisc

Depending on the function called, this field contains either a new logical end-of-file (for the PBGetEOFSync/ PBGetEOFAsync and PBSetEOFSync/ PBSetEOFAsync functions), a new version number, or a pointer to a new pathname (for the PBHRenameSync/ PBHRenameAsync functions). Because ioMisc is of type Ptr, you’ll need to perform type coercion to interpret the value of ioMisc correctly when it contains an end-of-file (a LongInt value) or version number (a SignedByte value).
ioBuffer

A pointer to a data buffer into which data is written by PBReadSync and PBReadAsync calls; and from which data is read by PBWriteSync and PBWriteAsync calls.
ioReqCount

The requested number of bytes to be read, written, or allocated.
ioActCount

The number of bytes actually read, written, or allocated.
ioPosMode

The positioning mode (base location) for positioning the file mark. Bits 0 and 1 of this field indicate how to position the mark; you can use the constants described in Position Mode Constants to set or test their value.

You can also use the constants described in Cache Constants to indicate whether the data should be cached.
ioPosOffset

The offset to be used in conjunction with the base location specified in the ioPosMode field.
Availability
Available in Mac OS X v10.0 and later.*/
struct IOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioRefNum;
   SInt8 ioVersNum;
   SInt8 ioPermssn;
   Ptr ioMisc;
   Ptr ioBuffer;
   long ioReqCount;
   long ioActCount;
   short ioPosMode;
   long ioPosOffset;
};
typedef struct IOParam IOParam;
typedef IOParam * IOParamPtr;


/*FileParam

Defines a parameter block used by low-level functions for getting and setting file information.

struct FileParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioFlVersNum;
   FInfo ioFlFndrInfo;
   unsigned long ioFlNum;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
};
typedef struct FileParam FileParam;
typedef FileParam * FileParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFRefNum

The file reference number of an open file.
ioFVersNum

A file version number. This field is no longer used. File version numbers are an artifact of the obsolete MFS, and are not supported on HFS volumes. You should always set this field to 0.
filler1

Reserved.
ioFDirIndex

A directory index for use with the PBHGetFInfoSync and PBHGetFInfoAsync functions.
ioFlAttrib

File attributes. See File Attribute Constants for the meaning of the bits in this field.
ioFlVersNum

A file version number. This feature is no longer supported, and you must always set this field to 0.
ioFlFndrInfo

Information used by the Finder. 
ioFlNum

A file ID.
ioFlStBlk

The first allocation block of the data fork. This field contains 0 if the file’s data fork is empty.
ioFlLgLen

The logical length (logical end-of-file) of the data fork.
ioFlPyLen

The physical length (physical end-of-file) of the data fork.
ioFlRStBlk

The first allocation block of the resource fork. This field contains 0 if the file’s resource fork is empty.
ioFlRLgLen

The logical length (logical end-of-file) of the resource fork.
ioFlRPyLen

The physical length (physical end-of-file) of the resource fork.
ioFlCrDat

The date and time of the file’s creation, specified in seconds since midnight, January 1, 1904.
ioFlMdDat

The date and time of the last modification to the file, specified in seconds since midnight, January 1, 1904.
Availability
Available in Mac OS X v10.0 and later.*/
struct FileParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioFlVersNum;
   FInfo ioFlFndrInfo;
   unsigned long ioFlNum;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
};
typedef struct FileParam FileParam;
typedef FileParam * FileParamPtr;

/*VolumeParam

Defines a parameter block used by low-level volume manipulation functions.

struct VolumeParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler2;
   short ioVolIndex;
   unsigned long ioVCrDate;
   unsigned long ioVLsBkUp;
   unsigned short ioVAtrb;
   unsigned short ioVNmFls;
   unsigned short ioVDirSt;
   short ioVBlLn;
   unsigned short ioVNmAlBlks;
   unsigned long ioVAlBlkSiz;
   unsigned long ioVClpSiz;
   unsigned short ioAlBlSt;
   unsigned long ioVNxtFNum;
   unsigned short ioVFrBlk;
};
typedef struct VolumeParam VolumeParam;
typedef VolumeParam * VolumeParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler2

Reserved.
ioVolIndex

The volume index.
ioVCrDate

The date and time of the volume’s initialization.
ioVLsBkUp

The date and time the volume information was last modified. (This field is not changed when information is written to a file and does not necessarily indicate when the volume was flushed.
ioVAtrb

The volume attributes. See Volume Information Attribute Constants for the meanings of the bits in this field.
ioVNmFls

The number of files in the root directory.
ioVDirSt

The first block of the volume directory.
ioVBlLn

Length of directory in blocks.
ioVNmAlBlks

The number of allocation blocks.
ioVAlBlkSiz

The size of allocation blocks.
ioVClpSiz

The volume clump size.
ioAlBlSt

The first block in the volume map.
ioVNxtFNum

The next unused file number.
ioVFrBlk

The number of unused allocation blocks.
Availability
Available in Mac OS X v10.0 and later.*/
struct VolumeParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler2;
   short ioVolIndex;
   unsigned long ioVCrDate;
   unsigned long ioVLsBkUp;
   unsigned short ioVAtrb;
   unsigned short ioVNmFls;
   unsigned short ioVDirSt;
   short ioVBlLn;
   unsigned short ioVNmAlBlks;
   unsigned long ioVAlBlkSiz;
   unsigned long ioVClpSiz;
   unsigned short ioAlBlSt;
   unsigned long ioVNxtFNum;
   unsigned short ioVFrBlk;
};
typedef struct VolumeParam VolumeParam;
typedef VolumeParam * VolumeParamPtr;

/*CntrlParam

Defines a parameter block used by Device Manager control and status functions.

struct CntrlParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioCRefNum;
   short csCode;
   short csParam[11];
};
typedef struct CntrlParam CntrlParam;
typedef CntrlParam * CntrlParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioCRefNum

The driver reference number for the I/O operation.
csCode

A value identifying the type of control or status request. Each driver may interpret this number differently.
csParam

The control or status information passed to or from the driver. This field is declared generically as an array of eleven integers. Each driver may interpret the contents of this field differently. Refer to the driver's documentation for specific information.
Availability
Available in Mac OS X v10.0 and later.*/

struct CntrlParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioCRefNum;
   short csCode;
   short csParam[11];
};
typedef struct CntrlParam CntrlParam;
typedef CntrlParam * CntrlParamPtr;

/*SlotDevParam

Defines a parameter block used by low-level Device Manager functions which access a single slot device.

struct SlotDevParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioSRefNum;
   SInt8 ioSVersNum;
   SInt8 ioSPermssn;
   Ptr ioSMix;
   short ioSFlags;
   SInt8 ioSlot;
   SInt8 ioID;
};
typedef struct SlotDevParam SlotDevParam;
typedef SlotDevParam * SlotDevParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioSRefNum

The driver reference number.
ioSVersNum

The slot version number.
ioSPermssn

Permissions.
ioSMix

Reserved.
ioSFlags

Flags determining the number of additional fields. You should clear all of the bits in this field.
ioSlot

The slot number.
ioID

The slot resource ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct SlotDevParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioSRefNum;
   SInt8 ioSVersNum;
   SInt8 ioSPermssn;
   Ptr ioSMix;
   short ioSFlags;
   SInt8 ioSlot;
   SInt8 ioID;
};
typedef struct SlotDevParam SlotDevParam;
typedef SlotDevParam * SlotDevParamPtr;

/*MultiDevParam

Defines a parameter block used by low-level Device manager functions which access multiple devices.

struct MultiDevParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioMRefNum;
   SInt8 ioMVersNum;
   SInt8 ioMPermssn;
   Ptr ioMMix;
   short ioMFlags;
   Ptr ioSEBlkPtr;
};
typedef struct MultiDevParam MultiDevParam;
typedef MultiDevParam * MultiDevParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioMRefNum

The driver reference number.
ioMVersNum

The slot version number.
ioMPermssn

Permissions.
ioMMix

Reserved.
ioMFlags

Flags specifying the number of additional fields. You should set the fMulti bit (bit 0) of this field and clear all of the other bits.
ioSEBlkPtr

A pointer to an external parameter block that is customized for the devices installed in the slot.
Availability
Available in Mac OS X v10.0 and later.*/
struct MultiDevParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioMRefNum;
   SInt8 ioMVersNum;
   SInt8 ioMPermssn;
   Ptr ioMMix;
   short ioMFlags;
   Ptr ioSEBlkPtr;
};
typedef struct MultiDevParam MultiDevParam;
typedef MultiDevParam * MultiDevParamPtr;

/*ParamBlockRec

Describes the basic File Manager parameter block.

union ParamBlockRec {
   IOParam ioParam;
   FileParam fileParam;
   VolumeParam volumeParam;
   CntrlParam cntrlParam;
   SlotDevParam slotDevParam;
   MultiDevParam multiDevParam;
};
typedef union ParamBlockRec ParamBlockRec;
typedef ParamBlockRec * ParmBlkPtr;
Fields
ioParam
fileParam
volumeParam
cntrlParam
slotDevParam
multiDevParam
Availability
Available in Mac OS X v10.0 and later.*/
union ParamBlockRec {
   IOParam ioParam;
   FileParam fileParam;
   VolumeParam volumeParam;
   CntrlParam cntrlParam;
   SlotDevParam slotDevParam;
   MultiDevParam multiDevParam;
};
typedef union ParamBlockRec ParamBlockRec;
typedef ParamBlockRec * ParmBlkPtr;


/*FSVolumeOperation


typedef struct OpaqueFSVolumeOperation * FSVolumeOperation;
Availability
Available in Mac OS X v10.2 and later.*/
typedef struct OpaqueFSVolumeOperation * FSVolumeOperation;

/*FSCatalogInfoBitmap

Describes which fields of the FSCatalogInfo structure you wish to retrieve or set.

typedef UInt32 FSCatalogInfoBitmap;
Discussion

If the bit corresponding to a particular field is not set in the bitmap, then that field is not changed in the FSCatalogInfo structure if it is an output parameter, and that field is ignored if the FSCatalogInfo structure is an input parameter. See Catalog Information Bitmap Constants for a description of the constants you should use with this data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 FSCatalogInfoBitmap;

/*FSVolumeRefNum

Identifies a particular mounted volume.

typedef SInt16 FSVolumeRefNum;
Discussion

This data type is the same as the 16-bit volume refnum previously passed in the ioVRefNum fields of a parameter block; this is simply a new type name for the old data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 FSVolumeRefNum;

/*HFSUniStr255

Used by the File Manager to return Unicode strings.

struct HFSUniStr255 {
   UInt16 length;
   UniChar unicode[255];
};
typedef struct HFSUniStr255 HFSUniStr255;
Fields
length

The number of unicode characters in the string.
unicode

The string, in unicode characters.
Discussion

This data type is a string of up to 255 16-bit Unicode characters, with a preceding 16-bit length (number of characters). Note that only the first length characters have meaningful values; the remaining characters may be set to arbitrary values. A caller should always assume that the entire structure will be modified, even if the actual string length is less than 255. 
Availability
Available in Mac OS X v10.0 and later.*/
struct HFSUniStr255 {
   UInt16 length;
   UniChar unicode[255];
};
typedef struct HFSUniStr255 HFSUniStr255;

/*FSSpec

Specifies the name and location of a file or directory.

struct FSSpec {
   short vRefNum;
   long parID;
   StrFileName name;
};
typedef struct FSSpec FSSpec;
typedef FSSpec * FSSpecPtr;
Fields
vRefNum

The volume reference number of the volume containing the specified file or directory.
parID

The parent directory ID of the specified file or directory (the directory ID of the directory containing the given file or directory).
name

The name of the specified file or directory. In Carbon, this name must be a leaf name; the name cannot contain a semicolon.
Discussion

The FSSpec structure can describe only a file or a directory, not a volume. A volume can be identified by its root directory, although the system software never uses an FSSpec structure to describe a volume. The directory ID of the root’s parent directory is fsRtParID. The name of the root directory is the same as the name of the volume.

If you need to convert a file specification into an FSSpec structure, call the function FSMakeFSSpec . Do not fill in the fields of an FSSpec structure yourself. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FSSpec {
   short vRefNum;
   long parID;
   StrFileName name;
};
typedef struct FSSpec FSSpec;
typedef FSSpec * FSSpecPtr;


/*FSCatalogInfo

Holds basic information about a file or directory.

struct FSCatalogInfo {
   UInt16 nodeFlags;
   FSVolumeRefNum volume;
   UInt32 parentDirID;
   UInt32 nodeID;
   UInt8 sharingFlags;
   UInt8 userPrivileges;
   UInt8 reserved1;
   UInt8 reserved2;
   UTCDateTime createDate;
   UTCDateTime contentModDate;
   UTCDateTime attributeModDate;
   UTCDateTime accessDate;
   UTCDateTime backupDate;
   UInt32 permissions[4];
   UInt8 finderInfo[16];
   UInt8 extFinderInfo[16];
   UInt64 dataLogicalSize;
   UInt64 dataPhysicalSize;
   UInt64 rsrcLogicalSize;
   UInt64 rsrcPhysicalSize;
   UInt32 valence;
   TextEncoding textEncodingHint;
};
typedef struct FSCatalogInfo FSCatalogInfo;
typedef FSCatalogInfo * FSCatalogInfoPtr;
Fields
nodeFlags

Node flags. This field has two defined bits that indicate whether an object is a file or folder, and whether a file is locked (constants kFSNodeIsDirectoryMask and kFSNodeLockedMask). See Catalog Information Node Flags for the values you can use here.
volume

The object's volume reference. 
parentDirID

The ID of the directory that contains the given object. The root directory of a volume always has ID fsRtDirID (2); the parent of the root directory is ID fsRtParID (1). Note that there is no object with ID fsRtParID; this is merely used when the File Manager is asked for the parent of the root directory.
nodeID

The file or directory ID.
sharingFlags

The object’s sharing flags. See Catalog Information Sharing Flags for the meaning of the bits defined for this field.
userPrivileges

The user's effective AFP privileges (same as ioACUser in the old HFileInfo and DirInfo structures). See User Privileges Constants.
reserved1

Reserved.
reserved2

Reserved.
createDate

The date and time of the creation of the object. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, FSGetCatalogInfo, PBGetCatalogInfoSync, and PBGetCatalogInfoAsync return 0 in this field. 
contentModDate

The date and time that the data or resource fork was last modified.
attributeModDate

The date and time that an attribute of the object (such as a fork other than the data or resource fork) was last modified.
accessDate

The date and time that the object was last accessed. The Mac OS 9 File Manager does not automatically update the accessDate field; it exists primarily for use by other operating systems (notably Mac OS X).
backupDate

The date and time of the object’s last backup. This field is not updated by the File Manager a backup utility may use this field if it wishes. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, FSGetCatalogInfo, PBGetCatalogInfoSync, and PBGetCatalogInfoAsync return 0 in this field.
permissions

User and group permission information. The Mac OS 8 and 9 File Manager does not use or enforce this permission information. It could be used by a file server program or other operating system (primarily Mac OS X). In Mac OS X, this array contains the file system permissions of the returned item. To use this information, coerce the parameter to a FSPermissionInfo structure.
finderInfo

Basic Finder information for the object. This information is available in the catalog information, instead of in a named fork, for historical reasons. The File Manager does not interpret the contents of these fields. To use this information, coerce the parameter to a FileInfo or FolderInfo structure.
extFinderInfo

Extended Finder information for the object. This information is available in the catalog information, instead of in a named fork, for historical reasons. The File Manager does not interpret the contents of these fields. To use this information, coerce the parameter to an ExtendedFileInfo or ExtendedFolderInfo structure.
dataLogicalSize

The size of the data fork in bytes (the fork’s logical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
dataPhysicalSize

The amount of disk space, in bytes, occupied by the data fork (the fork’s physical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
rsrcLogicalSize

The size of the resource fork (the fork’s logical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
rsrcPhysicalSize

The amount of disk space occupied by the resource fork (the fork’s physical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
valence

For folders only, the number of items (files plus directories) contained within the directory. For files, it is set to zero. Many volume formats do not store a field containing a directory’s valence. For those volume formats, this field is very expensive to compute. Think carefully before you ask the File Manager to return this field.
textEncodingHint

The textEncodingHint field is used in conjunction with the Unicode filename of the object. It is an optional hint that can be used by the volume format when converting the Unicode to some other encoding. For example, HFS Plus stores this value and uses it when converting the name to a Mac OS encoding, such as when the name is returned by PBGetCatInfoSync or PBGetCatInfoAsync. As another example, HFS volumes use this value to convert the Unicode name to a Mac OS encoded name stored on disk. If the entire Unicode name can be converted to a single Mac OS encoding, then that encoding should be used as the textEncodingHint; otherwise, a text encoding corresponding to the first characters of the name will probably provide the best user experience. 

If a textEncodingHint is not supplied when a file or directory is created or renamed, the volume format will use a default value. This default value may not be the best possible choice for the given filename. Whenever possible, a client should supply a textEncodingHint.

Discussion

The FSCatalogInfoBitmap type is used to indicate which fields of the FSCatalogInfo should be set or retrieved. If the bit corresponding to a particular field is not set, then that field is not changed if the FSCatalogInfo is an output parameter, and that field is ignored if the FSCatalogInfo is an input parameter. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FSCatalogInfo {
   UInt16 nodeFlags;
   FSVolumeRefNum volume;
   UInt32 parentDirID;
   UInt32 nodeID;
   UInt8 sharingFlags;
   UInt8 userPrivileges;
   UInt8 reserved1;
   UInt8 reserved2;
   UTCDateTime createDate;
   UTCDateTime contentModDate;
   UTCDateTime attributeModDate;
   UTCDateTime accessDate;
   UTCDateTime backupDate;
   UInt32 permissions[4];
   UInt8 finderInfo[16];
   UInt8 extFinderInfo[16];
   UInt64 dataLogicalSize;
   UInt64 dataPhysicalSize;
   UInt64 rsrcLogicalSize;
   UInt64 rsrcPhysicalSize;
   UInt32 valence;
   TextEncoding textEncodingHint;
};
typedef struct FSCatalogInfo FSCatalogInfo;
typedef FSCatalogInfo * FSCatalogInfoPtr;


/*FSRef

Identifies a directory or file, including a volume’s root directory.

struct FSRef {
   UInt8 hidden[80];
};
typedef struct FSRef FSRef;
typedef FSRef * FSRefPtr;
Discussion

This data type’s purpose is similar to an FSSpec except that an FSRef is completely opaque. An FSRef contains whatever information is needed to find the given object; the internal structure of an FSRef is likely to vary based on the volume format, and may vary based on the particular object being identified.

The client of the File Manager cannot examine the contents of an FSRef to extract information about the parent directory or the object’s name. Similarly, an FSRef cannot be constructed directly by the client; the FSRef must be constructed and returned via the File Manager. There is no need to call the File Manager to dispose an FSRef.

To determine the volume, parent directory and name associated with an FSRef, or to get an equivalent FSSpec, use the FSGetCatalogInfo call. 
Availability
Available in Mac OS X v10.0 and later.*/

struct FSRef {
   UInt8 hidden[80];
};
typedef struct FSRef FSRef;
typedef FSRef * FSRefPtr;


/*IOCompletionProcPtr

Defines a pointer to a completion function. Your completion function is executed by the File Manager after the completion of an asynchronous File Manager function call.

typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

If you name your function MyIOCompletionProc, you would declare it like this:

void MyIOCompletionProc (
   ParmBlkPtr paramBlock
);IOCompletionProcPtr

Defines a pointer to a completion function. Your completion function is executed by the File Manager after the completion of an asynchronous File Manager function call.

typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

If you name your function MyIOCompletionProc, you would declare it like this:

void MyIOCompletionProc (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the parameter block that was passed to the asynchronous File Manager function.
Return Value
Discussion

When you execute an asynchronous File Manager function (an Async function), you can specify a completion routine by passing the routine’s address in the ioCompletion field of the parameter block passed to the function. Because you requested asynchronous execution, the File Manager places an I/O request in the file I/O queue and returns control to your application—possibly even before the actual I/O operation is completed. The File Manager takes requests from the queue one at a time and processes them meanwhile, your application is free to do other processing.

A function executed asynchronously returns control to your application with the result code noErr as soon as the call is placed in the file I/O queue. This result code does not indicate that the call has successfully completed, but simply indicates that the call was successfully placed in the queue. To determine when the call is actually completed, you can inspect the ioResult field of the parameter block. This field is set to a positive number when the call is made and set to the actual result code when the call is completed. If you specify a completion routine, it is executed after the result code is placed in ioResult.

The File Manager, when the File Sharing or AppleShare file server is active, will execute requests in arbitrary order. That means that if there is a request that depends on the completion of a previous request, it is an error for your program to issue the second request until the completion of the first request. For example, issuing a write request and then issuing a read request for the same data isn't guaranteed to read back what was written unless the read request isn't made until after the write request completes.

Request order can also change if a call results in a disk switch dialog to bring an offline volume back online. 
Special Considerations

Because a completion routine is executed at interrupt time, it should not allocate, move, or purge memory (either directly or indirectly) and should not depend on the validity of handles to unlocked blocks.

If your completion routine uses application global variables, it must also ensure that register A5 contains the address of the boundary between your application global variables and your application parameters.
Parameters
paramBlock

A pointer to the parameter block that was passed to the asynchronous File Manager function.
Return Value
Discussion

When you execute an asynchronous File Manager function (an Async function), you can specify a completion routine by passing the routine’s address in the ioCompletion field of the parameter block passed to the function. Because you requested asynchronous execution, the File Manager places an I/O request in the file I/O queue and returns control to your application—possibly even before the actual I/O operation is completed. The File Manager takes requests from the queue one at a time and processes them meanwhile, your application is free to do other processing.

A function executed asynchronously returns control to your application with the result code noErr as soon as the call is placed in the file I/O queue. This result code does not indicate that the call has successfully completed, but simply indicates that the call was successfully placed in the queue. To determine when the call is actually completed, you can inspect the ioResult field of the parameter block. This field is set to a positive number when the call is made and set to the actual result code when the call is completed. If you specify a completion routine, it is executed after the result code is placed in ioResult.

The File Manager, when the File Sharing or AppleShare file server is active, will execute requests in arbitrary order. That means that if there is a request that depends on the completion of a previous request, it is an error for your program to issue the second request until the completion of the first request. For example, issuing a write request and then issuing a read request for the same data isn't guaranteed to read back what was written unless the read request isn't made until after the write request completes.

Request order can also change if a call results in a disk switch dialog to bring an offline volume back online. 
Special Considerations

Because a completion routine is executed at interrupt time, it should not allocate, move, or purge memory (either directly or indirectly) and should not depend on the validity of handles to unlocked blocks.

If your completion routine uses application global variables, it must also ensure that register A5 contains the address of the boundary between your application global variables and your application parameters.*/
typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);


/*IOCompletionUPP

A universal procedure pointer to an application-defined completion function.

typedef IOCompletionProcPtr IOCompletionUPP;
Discussion

See IOCompletionProcPtr.*/
typedef IOCompletionProcPtr IOCompletionUPP;

/*FSRefParam

Defines a parameter block used by low-level HFS Plus functions.

struct FSRefParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   ConstStringPtr ioNamePtr;
   short ioVRefNum;
   SInt16 reserved1;
   UInt8 reserved2;
   UInt8 reserved3;
   const FSRef * ref;
   FSCatalogInfoBitmap whichInfo;
   FSCatalogInfo * catInfo;
   UniCharCount nameLength;
   const UniChar * name;
   long ioDirID;
   FSSpec * spec;
   FSRef * parentRef;
   FSRef * newRef;
   TextEncoding textEncodingHint;
   HFSUniStr255 * outName;
};
typedef struct FSRefParam FSRefParam;
typedef FSRefParam * FSRefParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—you should set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, or 0 for the default volume.
reserved1

Reserved.
reserved2

Reserved.
reserved3

Reserved.
ref

The FSRef describing the file or directory which is the target of the call. 
whichInfo

An FSCatalogInfoBitmap which describes the fields of the catalog information structure passed in the catInfo field which are to be retrieved or set.
catInfo

A catalog inforFSRefParam

Defines a parameter block used by low-level HFS Plus functions.

struct FSRefParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   ConstStringPtr ioNamePtr;
   short ioVRefNum;
   SInt16 reserved1;
   UInt8 reserved2;
   UInt8 reserved3;
   const FSRef * ref;
   FSCatalogInfoBitmap whichInfo;
   FSCatalogInfo * catInfo;
   UniCharCount nameLength;
   const UniChar * name;
   long ioDirID;
   FSSpec * spec;
   FSRef * parentRef;
   FSRef * newRef;
   TextEncoding textEncodingHint;
   HFSUniStr255 * outName;
};
typedef struct FSRefParam FSRefParam;
typedef FSRefParam * FSRefParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—you should set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, or 0 for the default volume.
reserved1

Reserved.
reserved2

Reserved.
reserved3

Reserved.
ref

The FSRef describing the file or directory which is the target of the call. 
whichInfo

An FSCatalogInfoBitmap which describes the fields of the catalog information structure passed in the catInfo field which are to be retrieved or set.
catInfo

A catalog information structure containing information about the specified file or directory. 
nameLength

The length of the file or directory’s name, for the PBCreateSync, PBCreateAsync, PBRenameSync, and PBRenameAsync functions.
name

A pointer to the file or directory’s Unicode name, for the PBCreateSync, PBCreateAsync, PBRenameSync, and PBRenameAsync functions.
ioDirID

The directory ID of the specified file or directory’s parent directory.
spec

The target or source FSRef. 
parentRef

The secondary or destination FSRef. (Or the ref of the directory to move another file or directory to). 
newRef

The output FSRef (ie, a new FSRef ).
textEncodingHint

A text encoding hint for the file or directory’s Unicode name, used by the PBMakeFSRefSync, PBMakeFSRefAsync, PBRenameSync, and PBRenameAsync functions. 
outName

On output, a pointer to the Unicode name of the file or directory, used by the PBGetCatalogInfoSync and PBGetCatalogInfoAsync functions.
Availability
Available in Mac OS X v10.0 and later.mation structure containing information about the specified file or directory. 
nameLength

The length of the file or directory’s name, for the PBCreateSync, PBCreateAsync, PBRenameSync, and PBRenameAsync functions.
name

A pointer to the file or directory’s Unicode name, for the PBCreateSync, PBCreateAsync, PBRenameSync, and PBRenameAsync functions.
ioDirID

The directory ID of the specified file or directory’s parent directory.
spec

The target or source FSRef. 
parentRef

The secondary or destination FSRef. (Or the ref of the directory to move another file or directory to). 
newRef

The output FSRef (ie, a new FSRef ).
textEncodingHint

A text encoding hint for the file or directory’s Unicode name, used by the PBMakeFSRefSync, PBMakeFSRefAsync, PBRenameSync, and PBRenameAsync functions. 
outName

On output, a pointer to the Unicode name of the file or directory, used by the PBGetCatalogInfoSync and PBGetCatalogInfoAsync functions.
Availability
Available in Mac OS X v10.0 and later.*/
struct FSRefParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   ConstStringPtr ioNamePtr;
   short ioVRefNum;
   SInt16 reserved1;
   UInt8 reserved2;
   UInt8 reserved3;
   const FSRef * ref;
   FSCatalogInfoBitmap whichInfo;
   FSCatalogInfo * catInfo;
   UniCharCount nameLength;
   const UniChar * name;
   long ioDirID;
   FSSpec * spec;
   FSRef * parentRef;
   FSRef * newRef;
   TextEncoding textEncodingHint;
   HFSUniStr255 * outName;
};
typedef struct FSRefParam FSRefParam;
typedef FSRefParam * FSRefParamPtr;


/*Root Directory Constants

Specify the directory IDs of the root directory of a volume and its parent.

enum {
   fsRtParID = 1,
   fsRtDirID = 2
};
Constants
fsRtParID

Represents the directory ID of the root directory’s parent directory. The root directory has no parent this constant is used when specifying the root directory to functions which require the parent directory ID to identify directories. 

Available in Mac OS X v10.0 and later.
fsRtDirID

Represents the directory ID of the volume’s root directory.

Available in Mac OS X v10.0 and later.*/
enum {
   fsRtParID = 1,
   fsRtDirID = 2
};

/*File Attribute Constants

Define file and directory attributes returned by the PBGetCatInfoSync and PBGetCatInfoAsync functions.

enum {
   kioFlAttribLockedBit = 0,
   kioFlAttribLockedMask = 0x01,
   kioFlAttribResOpenBit = 2,
   kioFlAttribResOpenMask = 0x04,
   kioFlAttribDataOpenBit = 3,
   kioFlAttribDataOpenMask = 0x08,
   kioFlAttribDirBit = 4,
   kioFlAttribDirMask = 0x10,
   ioDirFlg = 4,
   ioDirMask = 0x10,
   kioFlAttribCopyProtBit = 6,
   kioFlAttribCopyProtMask = 0x40,
   kioFlAttribFileOpenBit = 7,
   kioFlAttribFileOpenMask = 0x80,
   kioFlAttribInSharedBit = 2,
   kioFlAttribInSharedMask = 0x04,
   kioFlAttribMountedBit = 3,
   kioFlAttribMountedMask = 0x08,
   kioFlAttribSharePointBit = 5,
   kioFlAttribSharePointMask = 0x20
};
Constants
kioFlAttribLockedBit

Indicates that the file or directory is locked. Use the functions PBHSetFLockSync and PBHSetFLockAsync to lock a file or directory. Use the functions PBHRstFLockSync and PBHRstFLockAsync to unlock a file or directory.

Available in Mac OS X v10.0 and later.
kioFlAttribLockedMask

Tests if the file or directory is locked.

Available in Mac OS X v10.0 and later.
kioFlAttribResOpenBit

Indicates that the resource fork is open. On Mac OS X, this bit is not set if the resource fork of the file has been opened by a process other than the process making the call to PBHGetCatInfo or PBHGetFInfo.

Available in Mac OS X v10.0 and later.
kioFlAttribResOpenMask

Tests if the resource fork is open.

Available in Mac OS X v10.0 and later.
kioFlAttribDataOpenBit

Indicates that the data fork is open. On Mac OS X, this bit is not set if the data fork of the file has been opened by a process other than the process making the call to PBHGetCatInfo or PBHGetFInfo.

Available in Mac OS X v10.0 and later.
kioFlAttribDataOpenMask

Tests if the data fork is open.

Available in Mac OS X v10.0 and later.
kioFlAttribDirBit

Indicates that this is a directory, not a file. This bit is always clear for files, and is always set for directories.

Available in Mac OS X v10.0 and later.
kioFlAttribDirMask

Tests if this is a directory.

Available in Mac OS X v10.0 and later.
ioDirFlg

Indicates that this is a directory; this is the old name of the kioFlAttribDirBit.

Available in Mac OS X v10.0 and later.
ioDirMask

Tests if this is a directory; this is the old name of the kioFlAttribDirMask.

Available in Mac OS X v10.0 and later.
kioFlAttribCopyProtBit

Indicates that the file is “copy-protected” by the AppleShare server.

Available in Mac OS X v10.0 and later.
kioFlAttribCopyProtMask

Tests if the file is “copy-protected” by the AppleShare server.

Available in Mac OS X v10.0 and later.
kioFlAttribFileOpenBit

Indicates that the file is open. This bit is set if either the data or the resource fork are open. On Mac OS X, this bit is not set if the file has been opened by a process other than the process making the call to PBHGetCatInfo or PBHGetFInfo.

Available in Mac OS X v10.0 and later.
kioFlAttribFileOpenMask

Tests if the file is open. The file is open if either the data or the resource fork are open. 

Available in Mac OS X v10.0 and later.
kioFlAttribInSharedBit

Indicates that the directory is within a shared area of the directory hierarchy.

Available in Mac OS X v10.0 and later.
kioFlAttribInSharedMask

Tests if the directory is within a shared area of the directory hierarchy.

Available in Mac OS X v10.0 and later.
kioFlAttribMountedBit

Indicates that the directory is a share point that is mounted by a user.

Available in Mac OS X v10.0 and later.
kioFlAttribMountedMask

Tests if the directory is a share point that is mounted by a user.

Available in Mac OS X v10.0 and later.
kioFlAttribSharePointBit

Indicates that the directory is a share point.

Available in Mac OS X v10.0 and later.
kioFlAttribSharePointMask

Tests if the directory is a share point.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the ioFlAttrib fields of the HFileInfo and DirInfo structures returned by the functions PBGetCatInfoSync and PBGetCatInfoAsync .*/
enum {
   kioFlAttribLockedBit = 0,
   kioFlAttribLockedMask = 0x01,
   kioFlAttribResOpenBit = 2,
   kioFlAttribResOpenMask = 0x04,
   kioFlAttribDataOpenBit = 3,
   kioFlAttribDataOpenMask = 0x08,
   kioFlAttribDirBit = 4,
   kioFlAttribDirMask = 0x10,
   ioDirFlg = 4,
   ioDirMask = 0x10,
   kioFlAttribCopyProtBit = 6,
   kioFlAttribCopyProtMask = 0x40,
   kioFlAttribFileOpenBit = 7,
   kioFlAttribFileOpenMask = 0x80,
   kioFlAttribInSharedBit = 2,
   kioFlAttribInSharedMask = 0x04,
   kioFlAttribMountedBit = 3,
   kioFlAttribMountedMask = 0x08,
   kioFlAttribSharePointBit = 5,
   kioFlAttribSharePointMask = 0x20
};



/*IOCompletionProcPtr

Defines a pointer to a completion function. Your completion function is executed by the File Manager after the completion of an asynchronous File Manager function call.

typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

If you name your function MyIOCompletionProc, you would declare it like this:

void MyIOCompletionProc (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the parameter block that was passed to the asynchronous File Manager function.
Return Value
Discussion

When you execute an asynchronous File Manager function (an Async function), you can specify a completion routine by passing the routine’s address in the ioCompletion field of the parameter block passed to the function. Because you requested asynchronous execution, the File Manager places an I/O request in the file I/O queue and returns control to your application—possibly even before the actual I/O operation is completed. The File Manager takes requests from the queue one at a time and processes them meanwhile, your application is free to do other processing.

A function executed asynchronously returns control to your application with the result code noErr as soon as the call is placed in the file I/O queue. This result code does not indicate that the call has successfully completed, but simply indicates that the call was successfully placed in the queue. To determine when the call is actually completed, you can inspect the ioResult field of the parameter block. This field is set to a positive number when the call is made and set to the actual result code when the call is completed. If you specify a completion routine, it is executed after the result code is placed in ioResult.

The File Manager, when the File Sharing or AppleShare file server is active, will execute requests in arbitrary order. That means that if there is a request that depends on the completion of a previous request, it is an error for your program to issue the second request until the completion of the first request. For example, issuing a write request and then issuing a read request for the same data isn't guaranteed to read back what was written unless the read request isn't made until after the write request completes.

Request order can also change if a call results in a disk switch dialog to bring an offline volume back online. 
Special Considerations

Because a completion routine is executed at interrupt time, it should not allocate, move, or purge memory (either directly or indirectly) and should not depend on the validity of handles to unlocked blocks.

If your completion routine uses application global variables, it must also ensure that register A5 contains the address of the boundary between your application global variables and your application parameters.*/
typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

/*IOCompletionUPP

A universal procedure pointer to an application-defined completion function.

typedef IOCompletionProcPtr IOCompletionUPP;
Discussion

See IOCompletionProcPtr.*/
typedef IOCompletionProcPtr IOCompletionUPP;

/*IOCompletionUPP

A universal procedure pointer to an application-defined completion function.

typedef IOCompletionProcPtr IOCompletionUPP;
Discussion

See IOCompletionProcPtr.*/
typedef IOCompletionProcPtr IOCompletionUPP;


/*ObjParam

Defines a parameter block used by low-level HFS user and group information functions.

struct ObjParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler7;
   short ioObjType;
   StringPtr ioObjNamePtr;
   long ioObjID;
};
typedef struct ObjParam ObjParam;
typedef ObjParam * ObjParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler7

Reserved.
ioObjType

A function code. The values passed in this field are determined by the function to which you pass this parameter block.
ioObjNamePtr

A pointer to the returned creator/group name.
ioObjID

The creator/group ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct ObjParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler7;
   short ioObjType;
   StringPtr ioObjNamePtr;
   long ioObjID;
};
typedef struct ObjParam ObjParam;
typedef ObjParam * ObjParamPtr;


/*AccessParam

Defines a parameter block used by low-level HFS file and directory access rights manipulation functions.

struct AccessParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler3;
   short ioDenyModes;
   short filler4;
   SInt8 filler5;
   SInt8 ioACUser;
   long filler6;
   long ioACOwnerID;
   long ioACGroupID;
   long ioACAccess;
   long ioDirID;
};
typedef struct AccessParam AccessParam;
typedef AccessParam * AccessParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler3

Reserved.
ioDenyModes

Access mode information.
filler4

Reserved.
filler5

Reserved.
ioACUser

The user’s access rights for the specified directory.
filler6

Reserved.
ioACOwnerID

The owner ID.
ioACGroupID

The group ID.
ioACAccess

The directory access privileges.
ioDirID
Availability
Available in Mac OS X v10.0 and later.*/
struct AccessParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler3;
   short ioDenyModes;
   short filler4;
   SInt8 filler5;
   SInt8 ioACUser;
   long filler6;
   long ioACOwnerID;
   long ioACGroupID;
   long ioACAccess;
   long ioDirID;
};
typedef struct AccessParam AccessParam;
typedef AccessParam * AccessParamPtr;

/*HFileParam

Defines a parameter block used by low-level HFS functions for file creation, deletion, and information retrieval.

struct HFileParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioFlVersNum;
   FInfo ioFlFndrInfo;
   long ioDirID;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
};
typedef struct HFileParam HFileParam;
typedef HFileParam * HFileParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFRefNum

The file reference number of an open file.
ioFVersNum

A file version number. This field is no longer used. File version numbers are an artifact of the obsolete MFS, and are not supported on HFS volumes. You should always set this field to 0.
filler1

Reserved.
ioFDirIndex

A directory index for use with the PBHGetFInfoSync and PBHGetFInfoAsync functions.
ioFlAttrib

File attributes. See File Attribute Constants for the meaning of the bits in this field.
ioFlVersNum

A file version number. This feature is no longer supported, and you must always set this field to 0.
ioFlFndrInfo

Information used by the Finder. 
ioDirID

A directory ID.
ioFlStBlk

The first allocation block of the data fork. This field contains 0 if the file’s data fork is empty.
ioFlLgLen

The logical length (logical end-of-file) of the data fork.
ioFlPyLen

The physical length (physical end-of-file) of the data fork.
ioFlRStBlk

The first allocation block of the resource fork. This field contains 0 if the file’s resource fork is empty.
ioFlRLgLen

The logical length (logical end-of-file) of the resource fork.
ioFlRPyLen

The physical length (physical end-of-file) of the resource fork.
ioFlCrDat

The date and time of the file’s creation, specified in seconds since midnight, January 1, 1904.
ioFlMdDat

The date and time of the last modification to the file, specified in seconds since midnight, January 1, 1904.
Availability
Available in Mac OS X v10.0 and later.*/
struct HFileParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioFlVersNum;
   FInfo ioFlFndrInfo;
   long ioDirID;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
};
typedef struct HFileParam HFileParam;
typedef HFileParam * HFileParamPtr;

/*HVolumeParam

Defines a parameter block used by low-level HFS volume manipulation functions.

struct HVolumeParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler2;
   short ioVolIndex;
   unsigned long ioVCrDate;
   unsigned long ioVLsMod;
   short ioVAtrb;
   unsigned short ioVNmFls;
   unsigned short ioVBitMap;
   unsigned short ioAllocPtr;
   unsigned short ioVNmAlBlks;
   unsigned long ioVAlBlkSiz;
   unsigned long ioVClpSiz;
   unsigned short ioAlBlSt;
   unsigned long ioVNxtCNID;
   unsigned short ioVFrBlk;
   unsigned short ioVSigWord;
   short ioVDrvInfo;
   short ioVDRefNum;
   short ioVFSID;
   unsigned long ioVBkUp;
   short ioVSeqNum;
   unsigned long ioVWrCnt;
   unsigned long ioVFilCnt;
   unsigned long ioVDirCnt;
   long ioVFndrInfo[8];
};
typedef struct HVolumeParam HVolumeParam;
typedef HVolumeParam * HVolumeParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler2

Reserved.
ioVolIndex

A volume index for use with the PBHGetVInfoSync and PBHGetVInfoAsync functions.
ioVCrDate

The date and time of the volume’s initialization.
ioVLsMod

The date and time the volume information was last modified. (This field is not changed when information is written to a file and does not necessarily indicate when the volume was flushed.
ioVAtrb

The volume attributes. See Volume Information Attribute Constants for the meanings of the bits in this field.
ioVNmFls

The number of files in the root directory of the volume. For performance reasons, the Carbon File Manager does not return the number of files in this field; instead, it sets ioVNmFls to 0.

To determine the number of files in the root directory of a volume in Carbon, call PBGetCatInfoAsync or PBGetCatInfoSync for the root directory. The number of files in the root directory is returned in the ioDrNmFls field.
ioVBitMap

The first block of the volume bitmap.
ioAllocPtr

The block at which the next new file starts. Used internally.
ioVNmAlBlks

The number of allocation blocks.
ioVAlBlkSiz

The size of allocation blocks.
ioVClpSiz

The clump size.
ioAlBlSt

The first block in the volume map.
ioVNxtCNID

The next unused catalog node ID.
ioVFrBlk

The number of unused allocation blocks.
ioVSigWord

A signature word identifying the type of volume it’s $D2D7 for MFS volumes and $4244 for volumes that support HFS calls.
ioVDrvInfo

The drive number of the drive containing the volume.
ioVDRefNum

For online volumes, the reference number of the I/O driver for the drive identified by the ioVDrvInfo field.
ioVFSID

The file-system identifier. It indicates which file system is servicing the volume it’s zero for File Manager volumes and nonzero for volumes handled by an external file system.
ioVBkUp

The date and time the volume was last backed up; this is 0 if the volume has never been backed up.
ioVSeqNum

Used internally.
ioVWrCnt

The volume write count.
ioVFilCnt

The total number of files on the volume.
ioVDirCnt

The total number of directories (not including the root directory) on the volume.
ioVFndrInfo

Information used by the Finder.
Availability
Available in Mac OS X v10.0 and later.*/
struct HVolumeParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler2;
   short ioVolIndex;
   unsigned long ioVCrDate;
   unsigned long ioVLsMod;
   short ioVAtrb;
   unsigned short ioVNmFls;
   unsigned short ioVBitMap;
   unsigned short ioAllocPtr;
   unsigned short ioVNmAlBlks;
   unsigned long ioVAlBlkSiz;
   unsigned long ioVClpSiz;
   unsigned short ioAlBlSt;
   unsigned long ioVNxtCNID;
   unsigned short ioVFrBlk;
   unsigned short ioVSigWord;
   short ioVDrvInfo;
   short ioVDRefNum;
   short ioVFSID;
   unsigned long ioVBkUp;
   short ioVSeqNum;
   unsigned long ioVWrCnt;
   unsigned long ioVFilCnt;
   unsigned long ioVDirCnt;
   long ioVFndrInfo[8];
};
typedef struct HVolumeParam HVolumeParam;

/*FIDParam

Defines a parameter block used by low-level HFS file ID functions.

struct FIDParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler14;
   StringPtr ioDestNamePtr;
   long filler15;
   long ioDestDirID;
   long filler16;
   long filler17;
   long ioSrcDirID;
   short filler18;
   long ioFileID;
};
typedef struct FIDParam FIDParam;
typedef FIDParam * FIDParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler14

Reserved.
ioDestNamePtr

A pointer to the name of the destination file.
filler15

Reserved.
ioDestDirID

The parent directory ID of the destination file.
filler16

Reserved.
filler17

Reserved.
ioSrcDirID

The parent directory ID of the source file.
filler18

Reserved.
ioFileID

The file ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct FIDParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler14;
   StringPtr ioDestNamePtr;
   long filler15;
   long ioDestDirID;
   long filler16;
   long filler17;
   long ioSrcDirID;
   short filler18;
   long ioFileID;
};
typedef struct FIDParam FIDParam;
typedef FIDParam * FIDParamPtr;

/*DirInfo

Defines a structure which holds catalog information about a directory.

struct DirInfo {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioACUser;
   DInfo ioDrUsrWds;
   long ioDrDirID;
   unsigned short ioDrNmFls;
   short filler3[9];
   unsigned long ioDrCrDat;
   unsigned long ioDrMdDat;
   unsigned long ioDrBkDat;
   DXInfo ioDrFndrInfo;
   long ioDrParID;
};
typedef struct DirInfo DirInfo;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFRefNum

The file reference number of an open file.
ioFVersNum

A file version number. This field is no longer used. File version numbers are an artifact of the obsolete MFS, and are not supported on HFS volumes. You should always set this field to 0.
filler1

Reserved.
ioFDirIndex

A file and directory index. If this field contains a positive number, PBGetCatInfoSync and PBGetCatInfoAsync return information about the file or directory having that directory index in the directory specified by the ioVRefNum field. (If ioVRefNum contains a volume reference number, the specified directory is that volume’s root directory.) 

If this field contains 0, PBGetCatInfoSync and PBGetCatInfoAsync return information about the file or directory whose name is specified in the ioNamePtr field and that is located in the directory specified by the ioVRefNum field. (Once again, if ioVRefNum contains a volume reference number, the specified directory is that volume’s root directory.)

If this field contains a negative number, PBGetCatInfoSync and PBGetCatInfoAsync ignore the ioNamePtr field and returns information about the directory specified in the ioDirID field. If both ioDirID and ioVRefNum are set to 0, PBGetCatInfoSync and PBGetCatInfoAsync return information about the current default directory.
ioFlAttrib

File or directory attributes. See File Attribute Constants for the meaning of the bits in this field.
ioACUser

The user’s access rights for the specified directory. See User Privileges Constants for the meaning of the bits in this field.
ioDrUsrWds

Information used by the Finder. 
ioDrDirID

A directory ID. On input to PBGetCatInfoSync and PBGetCatInfoAsync , this field contains a directory ID, which is used only if the value of the ioFDirIndex field is negative. On output, this field contains the directory ID of the specified directory.
ioDrNmFls

The number of files in the directory.
filler3

Reserved.
ioDrCrDat

The date and time of the directory’s creation, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the creation date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970, and that is the value which will be returned if you later try to retrieve the creation date. 

Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates.
ioDrMdDat

The date and time of the last modification to the directory, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the modification date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970.
ioDrBkDat

The date and time that the directory was last backed up, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the backup date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970. 

Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates.
ioDrFndrInfo

Additional information used by the Finder. 
ioDrParID

The directory ID of the specified directory’s parent directory.
refCon
Availability
Available in Mac OS X v10.0 and later.*/
struct DirInfo {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioACUser;
   DInfo ioDrUsrWds;
   long ioDrDirID;
   unsigned short ioDrNmFls;
   short filler3[9];
   unsigned long ioDrCrDat;
   unsigned long ioDrMdDat;
   unsigned long ioDrBkDat;
   DXInfo ioDrFndrInfo;
   long ioDrParID;
};
typedef struct DirInfo DirInfo;

/*CatPositionRec

Defines a catalog position structure, which maintains the current position of a catalog search between calls to PBCatSearchSync or PBCatSearchAsync.

struct CatPositionRec {
   long initialize;
   short priv[6];
};
typedef struct CatPositionRec CatPositionRec;
Fields
initialize

The starting point of the catalog search. To start searching at the beginning of a catalog, specify 0 in this field. To resume a previous search, pass the value returned by the previous call to PBCatSearchSync or PBCatSearchAsync.
priv

An array of integers that is used internally by PBCatSearchSync and PBCatSearchAsync.
Discussion

When you call the PBCatSearchSync or PBCatSearchAsync function to search a volume’s catalog file, you can specify, in the ioCatPosition field of the parameter block passed to PBCatSearchSync and PBCatSearchAsync, a catalog position structure. If a catalog search consumes more time than is allowed by the ioSearchTime field, PBCatSearchSync and PBCatSearchAsync store a directory-location index in that structure; when you call PBCatSearchSync or PBCatSearchAsync again, it uses that structure to resume searching where it left off. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CatPositionRec {
   long initialize;
   short priv[6];
};
typedef struct CatPositionRec CatPositionRec;

/*HFileInfo

Defines a structure which holds catalog information about a file.

struct HFileInfo {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioACUser;
   FInfo ioFlFndrInfo;
   long ioDirID;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
   unsigned long ioFlBkDat;
   FXInfo ioFlXFndrInfo;
   long ioFlParID;
   long ioFlClpSiz;
};
typedef struct HFileInfo HFileInfo;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFRefNum

The file reference number of an open file.
ioFVersNum

A file version number. This field is no longer used. File version numbers are an artifact of the obsolete MFS, and are not supported on HFS volumes. You should always set this field to 0.
filler1

Reserved.
ioFDirIndex

A file and directory index. If this field contains a positive number, PBGetCatInfoSync and PBGetCatInfoAsync return information about the file or directory having that directory index in the directory specified by the ioVRefNum field. (If ioVRefNum contains a volume reference number, the specified directory is that volume’s root directory.) 

If this field contains 0, PBGetCatInfoSync or PBGetCatInfoAsync returns information about the file or directory whose name is specified in the ioNamePtr field and that is located in the directory specified by the ioVRefNum field. (Once again, if ioVRefNum contains a volume reference number, the specified directory is that volume’s root directory.)

If this field contains a negative number, PBGetCatInfoSync or PBGetCatInfoAsync ignores the ioNamePtr field and returns information about the directory specified in the ioDirID field. If both ioDirID and ioVRefNum are set to 0, PBGetCatInfoSync or PBGetCatInfoAsync returns information about the current default directory.
ioFlAttrib

File or directory attributes. See File Attribute Constants for the meaning of the bits in this field.
ioACUser

The user’s access rights for the specified directory. See User Privileges Constants for the meaning of the bits in this field.
ioFlFndrInfo

Finder information. 
ioDirID

A directory ID or file ID. On input to PBGetCatInfoSync or PBGetCatInfoAsync , this field contains a directory ID (which is used only if the ioFDirIndex field is negative). On output, this field contains the file ID of the specified file.
ioFlStBlk

The first allocation block of the data fork. This field contains 0 if the file’s data fork is empty.
ioFlLgLen

The logical length (logical end-of-file) of the data fork.
ioFlPyLen

The physical length (physical end-of-file) of the data fork.
ioFlRStBlk

The first allocation block of the resource fork.
ioFlRLgLen

The logical length (logical end-of-file) of the resource fork.
ioFlRPyLen

The physical length (physical end-of-file) of the resource fork.
ioFlCrDat

The date and time of the file’s creation, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the creation date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970, and that is the value which will be returned if you later try to retrieve the creation date. 

Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates.
ioFlMdDat

The date and time of the last modification to the file, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the modification date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970.
ioFlBkDat

The date and time that the file was last backed up, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the backup date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970. 

Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates.
ioFlXFndrInfo

Additional Finder information. 
ioFlParID

The directory ID of the file’s parent directory.
ioFlClpSiz

The clump size to be used when writing the file if it’s 0, the volume’s clump size is used when the file is opened.
Availability
Available in Mac OS X v10.0 and later.*/
struct HFileInfo {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioACUser;
   FInfo ioFlFndrInfo;
   long ioDirID;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
   unsigned long ioFlBkDat;
   FXInfo ioFlXFndrInfo;
   long ioFlParID;
   long ioFlClpSiz;
};
typedef struct HFileInfo HFileInfo;

/*ForeignPrivParam

Defines a parameter block used by low-level HFS foreign privileges functions.

struct ForeignPrivParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long ioFiller21;
   long ioFiller22;
   Ptr ioForeignPrivBuffer;
   long ioForeignPrivActCount;
   long ioForeignPrivReqCount;
   long ioFiller23;
   long ioForeignPrivDirID;
   long ioForeignPrivInfo1;
   long ioForeignPrivInfo2;
   long ioForeignPrivInfo3;
   long ioForeignPrivInfo4;
};
typedef struct ForeignPrivParam ForeignPrivParam;
typedef ForeignPrivParam * ForeignPrivParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchrForeignPrivParam

Defines a parameter block used by low-level HFS foreign privileges functions.

struct ForeignPrivParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long ioFiller21;
   long ioFiller22;
   Ptr ioForeignPrivBuffer;
   long ioForeignPrivActCount;
   long ioForeignPrivReqCount;
   long ioFiller23;
   long ioForeignPrivDirID;
   long ioForeignPrivInfo1;
   long ioForeignPrivInfo2;
   long ioForeignPrivInfo3;
   long ioForeignPrivInfo4;
};
typedef struct ForeignPrivParam ForeignPrivParam;
typedef ForeignPrivParam * ForeignPrivParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFiller21

Reserved.
ioFiller22

Reserved.
ioForeignPrivBuffer

A pointer to a buffer containing access-control information about the foreign file system.
ioForeignPrivActCount

The size of the buffer pointed to by the ioForeignPrivBuffer field.
ioForeignPrivReqCount

The amount of the buffer pointed to by the ioForeignPrivBuffer field that was actually used to hold data.
ioFiller23

Reserved.
ioForeignPrivDirID

The parent directory ID of the foreign file or directory.
ioForeignPrivInfo1

A long word that may contain privileges data.
ioForeignPrivInfo2

A long word that may contain privileges data.
ioForeignPrivInfo3

A long word that may contain privileges data.
ioForeignPrivInfo4

A long word that may contain privileges data.
Availability
Available in Mac OS X v10.0 and later.onous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFiller21

Reserved.
ioFiller22

Reserved.
ioForeignPrivBuffer

A pointer to a buffer containing access-control information about the foreign file system.
ioForeignPrivActCount

The size of the buffer pointed to by the ioForeignPrivBuffer field.
ioForeignPrivReqCount

The amount of the buffer pointed to by the ioForeignPrivBuffer field that was actually used to hold data.
ioFiller23

Reserved.
ioForeignPrivDirID

The parent directory ID of the foreign file or directory.
ioForeignPrivInfo1

A long word that may contain privileges data.
ioForeignPrivInfo2

A long word that may contain privileges data.
ioForeignPrivInfo3

A long word that may contain privileges data.
ioForeignPrivInfo4

A long word that may contain privileges data.
Availability
Available in Mac OS X v10.0 and later.*/

struct ForeignPrivParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long ioFiller21;
   long ioFiller22;
   Ptr ioForeignPrivBuffer;
   long ioForeignPrivActCount;
   long ioForeignPrivReqCount;
   long ioFiller23;
   long ioForeignPrivDirID;
   long ioForeignPrivInfo1;
   long ioForeignPrivInfo2;
   long ioForeignPrivInfo3;
   long ioForeignPrivInfo4;
};
typedef struct ForeignPrivParam ForeignPrivParam;
typedef ForeignPrivParam * ForeignPrivParamPtr;

/*CInfoPBRec

Defines a catalog information parameter block for file and directory information.

union CInfoPBRec {
   HFileInfo hFileInfo;
   DirInfo dirInfo;
};
typedef union CInfoPBRec CInfoPBRec;
typedef CInfoPBRec * CInfoPBPtr;
Fields
hFileInfo
dirInfo
Availability
Available in Mac OS X v10.0 and later.*/
union CInfoPBRec {
   HFileInfo hFileInfo;
   DirInfo dirInfo;
};
typedef union CInfoPBRec CInfoPBRec;
typedef CInfoPBRec * CInfoPBPtr;


/*CSParam

Defines a parameter block used by low-level HFS catalog search functions.

struct CSParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   FSSpecPtr ioMatchPtr;
   long ioReqMatchCount;
   long ioActMatchCount;
   long ioSearchBits;
   CInfoPBPtr ioSearchInfo1;
   CInfoPBPtr ioSearchInfo2;
   long ioSearchTime;
   CatPositionRec ioCatPosition;
   Ptr ioOptBuffer;
   long ioOptBufSize;
};
typedef struct CSParam CSParam;
typedef CSParam * CSParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioMatchPtr

A pointer to an array of FSSpec structures in which the file and directory names that match the selection criteria are returned. The array must be large enough to hold the largest possible number of FSSpec structures, as determined by the ioReqMatchCount field.
ioReqMatchCount

The maximum number of matches to return. This number should be the number of FSSpec structures that will fit in the memory pointed to by the ioMatchPtr field. You can use this field to avoid a possible excess of matches for criteria that prove to be too general (or to limit the length of a search if the ioSearchTime field isn’t used).
ioActMatchCount

The number of actual matches found.
ioSearchBits

The fields of the parameter blocks in the ioSearchInfo1 and ioSearchInfo2 fields that are relevant to the search. See Catalog Search Bits for more information.
ioSearchInfo1

A pointer to a CInfoPBRec parameter block that contains the search information. For values that match by mask and value (Finder information, for example), set the bits in the structure passed in the ioSearchInfo2 field, and set the matching values in this structure. For values that match against a range (such as dates), set the lower bounds for the range in this struture.
ioSearchInfo2

A pointer to a second CSParam

Defines a parameter block used by low-level HFS catalog search functions.

struct CSParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   FSSpecPtr ioMatchPtr;
   long ioReqMatchCount;
   long ioActMatchCount;
   long ioSearchBits;
   CInfoPBPtr ioSearchInfo1;
   CInfoPBPtr ioSearchInfo2;
   long ioSearchTime;
   CatPositionRec ioCatPosition;
   Ptr ioOptBuffer;
   long ioOptBufSize;
};
typedef struct CSParam CSParam;
typedef CSParam * CSParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioMatchPtr

A pointer to an array of FSSpec structures in which the file and directory names that match the selection criteria are returned. The array must be large enough to hold the largest possible number of FSSpec structures, as determined by the ioReqMatchCount field.
ioReqMatchCount

The maximum number of matches to return. This number should be the number of FSSpec structures that will fit in the memory pointed to by the ioMatchPtr field. You can use this field to avoid a possible excess of matches for criteria that prove to be too general (or to limit the length of a search if the ioSearchTime field isn’t used).
ioActMatchCount

The number of actual matches found.
ioSearchBits

The fields of the parameter blocks in the ioSearchInfo1 and ioSearchInfo2 fields that are relevant to the search. See Catalog Search Bits for more information.
ioSearchInfo1

A pointer to a CInfoPBRec parameter block that contains the search information. For values that match by mask and value (Finder information, for example), set the bits in the structure passed in the ioSearchInfo2 field, and set the matching values in this structure. For values that match against a range (such as dates), set the lower bounds for the range in this struture.
ioSearchInfo2

A pointer to a second CInfoPBRec parameter block that contains the search information. For values that match by mask and value (Finder information, for example), set the bits in this structure, and set the matching values in the structure passed in the ioSearchInfo1 field. For values that match against a range (such as dates), set the upper bounds for the range in this struture.
ioSearchTime

A time limit on a search, in Time Manager format. Use this field to limit the run time of a single call to PBCatSearchSync or PBCatSearchAsync. A value of 0 imposes no time limit. If the value of this field is positive, it is interpreted as milliseconds. If the value of this field is negative, it is interpreted as negated microseconds.
ioCatPosition

A position in the catalog where searching should begin. Use this field to keep an index into the catalog when breaking down the PBCatSearchSync or PBCatSearchAsync search into a number of smaller searches. This field is valid whenever PBCatSearchSync or PBCatSearchAsync exits because it either spends the maximum time allowed by ioSearchTime or finds the maximum number of matches allowed by ioReqMatchCount.

To start at the beginning of the catalog, set the initialize field of ioCatPosition to 0. Before exiting after an interrupted search, PBCatSearchSync or PBCatSearchAsync sets that field to the next catalog entry to be searched.

To resume where the previous call stopped, pass the entire CatPositionRec structure returned by the previous call as input to the next.
ioOptBuffer

A pointer to an optional read buffer. The ioOptBuffer and ioOptBufSize fields let you specify a part of memory as a read buffer, increasing search speed.
ioOptBufSize

The size of the buffer pointed to by ioOptBuffer. Buffer size effectiveness varies with models and configurations, but a 16 KB buffer is likely to be optimal. The size should be at least 1024 bytes and should be an integral multiple of 512 bytes.
Availability
Available in Mac OS X v10.0 and later.CInfoPBRec parameter block that contains the search information. For values that match by mask and value (Finder information, for example), set the bits in this structure, and set the matching values in the structure passed in the ioSearchInfo1 field. For values that match against a range (such as dates), set the upper bounds for the range in this struture.
ioSearchTime

A time limit on a search, in Time Manager format. Use this field to limit the run time of a single call to PBCatSearchSync or PBCatSearchAsync. A value of 0 imposes no time limit. If the value of this field is positive, it is interpreted as milliseconds. If the value of this field is negative, it is interpreted as negated microseconds.
ioCatPosition

A position in the catalog where searching should begin. Use this field to keep an index into the catalog when breaking down the PBCatSearchSync or PBCatSearchAsync search into a number of smaller searches. This field is valid whenever PBCatSearchSync or PBCatSearchAsync exits because it either spends the maximum time allowed by ioSearchTime or finds the maximum number of matches allowed by ioReqMatchCount.

To start at the beginning of the catalog, set the initialize field of ioCatPosition to 0. Before exiting after an interrupted search, PBCatSearchSync or PBCatSearchAsync sets that field to the next catalog entry to be searched.

To resume where the previous call stopped, pass the entire CatPositionRec structure returned by the previous call as input to the next.
ioOptBuffer

A pointer to an optional read buffer. The ioOptBuffer and ioOptBufSize fields let you specify a part of memory as a read buffer, increasing search speed.
ioOptBufSize

The size of the buffer pointed to by ioOptBuffer. Buffer size effectiveness varies with models and configurations, but a 16 KB buffer is likely to be optimal. The size should be at least 1024 bytes and should be an integral multiple of 512 bytes.
Availability
Available in Mac OS X v10.0 and later.*/

struct CSParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   FSSpecPtr ioMatchPtr;
   long ioReqMatchCount;
   long ioActMatchCount;
   long ioSearchBits;
   CInfoPBPtr ioSearchInfo1;
   CInfoPBPtr ioSearchInfo2;
   long ioSearchTime;
   CatPositionRec ioCatPosition;
   Ptr ioOptBuffer;
   long ioOptBufSize;
};
typedef struct CSParam CSParam;
typedef CSParam * CSParamPtr;

/*WDParam

Defines a parameter block used by low-level HFS working directory functions.

struct WDParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioWDCreated;
   short ioWDIndex;
   long ioWDProcID;
   short ioWDVRefNum;
   short filler10;
   long filler11;
   long filler12;
   long filler13;
   long ioWDDirID;
};
typedef struct WDParam WDParam;
typedef WDParam * WDParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler9

An index to working directories.
ioWDIndex

The working directory user identifier.
ioWDProcID

The volume reference number for the working directory.
ioWDVRefNum

Reserved.
filler10

Reserved.
filler11

Reserved.
filler12

Reserved.
filler13

The working directory’s directory ID.
ioWDDirID

The working directory’s directory ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct WDParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioWDCreated;
   short ioWDIndex;
   long ioWDProcID;
   short ioWDVRefNum;
   short filler10;
   long filler11;
   long filler12;
   long filler13;
   long ioWDDirID;
};
typedef struct WDParam WDParam;
typedef WDParam * WDParamPtr;


/*HIOParam

Defines a parameter block used by low-level HFS I/O functions.

struct HIOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioRefNum;
   SInt8 ioVersNum;
   SInt8 ioPermssn;
   Ptr ioMisc;
   Ptr ioBuffer;
   long ioReqCount;
   long ioActCount;
   short ioPosMode;
   long ioPosOffset;
};
typedef struct HIOParam HIOParam;
typedef HIOParam * HIOParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioRefNum

The file reference number of an open file.
ioVersNum

A version number. This field is no longer used and you should always set it to 0.
ioPermssn

The access mode. See File Access Permission Constants.
ioMisc

Depending on the function called, this field contains either a logical end-of-file, a new version number, a pointer to an access path buffer, or a pointer to a new pathname. Because ioMisc is of type Ptr, you’ll need to perform type coercion to interpret the value of ioMisc correctly when it contains an end-of-file (a LongInt value) or version number (a SignedByte value).
ioBuffer

A pointer to a data buffer into which data is written by PBReadSync and PBReadAsync calls, and from which data is read by PBWriteSync and PBWriteAsync calls.
ioReqCount

The requested number of bytes to be read, written, or allocated.
ioActCount

The number of bytes actually read, written, or allocated.
ioPosMode

The positioning mode (base location) for setting the mark. Bits 0 and 1 of this field indicate how to position the mark; you can use the constants described in Position Mode Constants to set or test their value.

You can also use the constants described in Cache Constants to indicate whether or not to cache the data.
ioPosOffset

The offset to be used in conjunction with the base location specified in the ioPosMode field.
Availability
Available in Mac OS X v10.0 and later.*/
struct HIOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioRefNum;
   SInt8 ioVersNum;
   SInt8 ioPermssn;
   Ptr ioMisc;
   Ptr ioBuffer;
   long ioReqCount;
   long ioActCount;
   short ioPosMode;
   long ioPosOffset;
};
typedef struct HIOParam HIOParam;
typedef HIOParam * HIOParamPtr;

/*CopyParam

Defines a parameter block used by low-level HFS file copying functions.

struct CopyParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioDstVRefNum;
   short filler8;
   StringPtr ioNewName;
   StringPtr ioCopyName;
   long ioNewDirID;
   long filler14;
   long filler15;
   long ioDirID;
};
typedef struct CopyParam CopyParam;
typedef CopyParam * CopyParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioDstVRefNum

A volume reference number for the destination volume.
filler8

Reserved.
ioNewName

A pointer to the destination pathname.
ioCopyName

A pointer to an optional name.
ioNewDirID

A destination directory ID.
filler14

Reserved.
filler15

Reserved.
ioDirID

A directory ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct CopyParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioDstVRefNum;
   short filler8;
   StringPtr ioNewName;
   StringPtr ioCopyName;
   long ioNewDirID;
   long filler14;
   long filler15;
   long ioDirID;
};
typedef struct CopyParam CopyParam;
typedef CopyParam * CopyParamPtr;


/*HParamBlockRec

Describes the HFS parameter block.

union HParamBlockRec {
   HIOParam ioParam;
   HFileParam fileParam;
   HVolumeParam volumeParam;
   AccessParam accessParam;
   ObjParam objParam;
   CopyParam copyParam;
   WDParam wdParam;
   FIDParam fidParam;
   CSParam csParam;
   ForeignPrivParam foreignPrivParam;
};
typedef union HParamBlockRec HParamBlockRec;
typedef HParamBlockRec * HParmBlkPtr;
Fields
ioParam

A parameter block used by low-level HFS I/O functions. See HIOParam. 
fileParam

A parameter block used by low-level HFS functions for file creation, deletion, and information retrieval. See HFileParam. 
volumeParam

A parameter block used by low-level HFS volume manipulation functions. See HVolumeParam. 
accessParam

A parameter block used by low-level HFS file and directory access rights manipulation functions. See AccessParam. 
objParam

A parameter block used by low-level HFS user and group information functions. See ObjParam. 
copyParam

A parameter block used by low-level HFS file copying functions. See CopyParam. 
wdParam

A parameter block used by low-level HFS working directory functions. See WDParam. 
fidParam

A parameter block used by low-level HFS file ID functions. See FIDParam. 
csParam

A parameter block used by low-level HFS catalog search functions. See CSParam. 
foreignPrivParam

A parameter block used by low-level HFS foreign privileges functions. See ForeignPrivParam. 
Availability
Available in Mac OS X v10.0 and later.*/
union HParamBlockRec {
   HIOParam ioParam;
   HFileParam fileParam;
   HVolumeParam volumeParam;
   AccessParam accessParam;
   ObjParam objParam;
   CopyParam copyParam;
   WDParam wdParam;
   FIDParam fidParam;
   CSParam csParam;
   ForeignPrivParam foreignPrivParam;
};
typedef union HParamBlockRec HParamBlockRec;
typedef HParamBlockRec * HParmBlkPtr;

/*GetVolParmsInfoBuffer

Defines a volume attributes buffer, used by the PBHGetVolParmsSync and PBHGetVolParmAsync functions to return volume information.

struct GetVolParmsInfoBuffer {
   short vMVersion;
   long vMAttrib;
   Handle vMLocalHand;
   long vMServerAdr;
   long vMVolumeGrade;
   short vMForeignPrivID;
   long vMExtendedAttributes;
   void * vMDeviceID;
   UniCharCount vMMaxNameLength;
};
typedef struct GetVolParmsInfoBuffer GetVolParmsInfoBuffer;
Fields
vMVersion

The version number of the attributes buffer structure. Currently this field returns 1, 2, 3 or 4. Version 3 is introduced to support the HFS Plus APIs.
vMAttrib

A 32-bit quantity that encodes information about the volume attributes. See Volume Attribute Constants for the meaning of the bits in this field.
vMLocalHand

A handle to private data for shared volumes. On creation of the VCB (right after mounting), this field is a handle to a 2-byte block of memory. The Finder uses this for its local window list storage, allocating and deallocating memory as needed. It is disposed of when the volume is unmounted. Your application should treat this field as reserved.
vMServerAdr

For AppleTalk server volumes, this field contains the internet address of an AppleTalk server volume. Your application can inspect thiGetVolParmsInfoBuffer

Defines a volume attributes buffer, used by the PBHGetVolParmsSync and PBHGetVolParmAsync functions to return volume information.

struct GetVolParmsInfoBuffer {
   short vMVersion;
   long vMAttrib;
   Handle vMLocalHand;
   long vMServerAdr;
   long vMVolumeGrade;
   short vMForeignPrivID;
   long vMExtendedAttributes;
   void * vMDeviceID;
   UniCharCount vMMaxNameLength;
};
typedef struct GetVolParmsInfoBuffer GetVolParmsInfoBuffer;
Fields
vMVersion

The version number of the attributes buffer structure. Currently this field returns 1, 2, 3 or 4. Version 3 is introduced to support the HFS Plus APIs.
vMAttrib

A 32-bit quantity that encodes information about the volume attributes. See Volume Attribute Constants for the meaning of the bits in this field.
vMLocalHand

A handle to private data for shared volumes. On creation of the VCB (right after mounting), this field is a handle to a 2-byte block of memory. The Finder uses this for its local window list storage, allocating and deallocating memory as needed. It is disposed of when the volume is unmounted. Your application should treat this field as reserved.
vMServerAdr

For AppleTalk server volumes, this field contains the internet address of an AppleTalk server volume. Your application can inspect this field to tell which volumes belong to which server; the value of this field is 0 if the volume does not have a server.
vMVolumeGrade

The relative speed rating of the volume. The scale used to determine these values is currently uncalibrated. In general, lower values indicate faster speeds. A value of 0 indicates that the volume’s speed is unrated. The buffer version returned in the vMVersion field must be greater than 1 for this field to be meaningful.
vMForeignPrivID

An integer representing the privilege model supported by the volume. Currently two values are defined for this field: 0 represents a standard HFS or HFS Plus volume that might or might not support the AFP privilege model; fsUnixPriv represents a volume that supports the A/UX privilege model. The buffer version returned in the vMVersion field must be greater than 1 for this field to be meaningful.
vMExtendedAttributes

Contains bits that describe a volume’s extended attributes. For this field to be meaningful, the vMVersion must be greater than 2. See Extended Volume Attributes for the meaning of the bits in this field.
vMDeviceID

A device name identifying the device in /dev that corresponds to the volume. You can use this string to build a POSIX path to the device for use with IOKit APIs.
vMMaxNameLength
Discussion

Volumes that implement the HFS Plus APIs must use version 3 (or newer) of the GetVolParmsInfoBuffer. Volumes that don’t implement the HFS Plus APIs may still implement version 3 of the GetVolParmsInfoBuffer. If the version of the GetVolParmsInfoBuffer is 2 or less, or the bSupportsHFSPlusAPIs bit is clear (zero), then the volume does not implement the HFS Plus APIs, and they are being emulated for that volume by the File Manager itself.

If a volume does not implement the HFS Plus APIs, and supports version 2 or earlier of the GetVolParmsInfoBuffer, it cannot itself describe whether it supports the FSCatalogSearch or FSExchangeObjects calls. The compatibility layer will implement the FSCatalogSearch call if the volume supports the PBCatSearch call (i.e. the bHasCatSearch bit of vMAttrib is set). The compatibility layer will implement the FSExchangeObjects call if the volume supports PBExchangeFiles (i.e. the bHasFileIDs bit of vMAttrib is set). 
Availability
Available in Mac OS X v10.0 and later.s field to tell which volumes belong to which server; the value of this field is 0 if the volume does not have a server.
vMVolumeGrade

The relative speed rating of the volume. The scale used to determine these values is currently uncalibrated. In general, lower values indicate faster speeds. A value of 0 indicates that the volume’s speed is unrated. The buffer version returned in the vMVersion field must be greater than 1 for this field to be meaningful.
vMForeignPrivID

An integer representing the privilege model supported by the volume. Currently two values are defined for this field: 0 represents a standard HFS or HFS Plus volume that might or might not support the AFP privilege model; fsUnixPriv represents a volume that supports the A/UX privilege model. The buffer version returned in the vMVersion field must be greater than 1 for this field to be meaningful.
vMExtendedAttributes

Contains bits that describe a volume’s extended attributes. For this field to be meaningful, the vMVersion must be greater than 2. See Extended Volume Attributes for the meaning of the bits in this field.
vMDeviceID

A device name identifying the device in /dev that corresponds to the volume. You can use this string to build a POSIX path to the device for use with IOKit APIs.
vMMaxNameLength
Discussion

Volumes that implement the HFS Plus APIs must use version 3 (or newer) of the GetVolParmsInfoBuffer. Volumes that don’t implement the HFS Plus APIs may still implement version 3 of the GetVolParmsInfoBuffer. If the version of the GetVolParmsInfoBuffer is 2 or less, or the bSupportsHFSPlusAPIs bit is clear (zero), then the volume does not implement the HFS Plus APIs, and they are being emulated for that volume by the File Manager itself.

If a volume does not implement the HFS Plus APIs, and supports version 2 or earlier of the GetVolParmsInfoBuffer, it cannot itself describe whether it supports the FSCatalogSearch or FSExchangeObjects calls. The compatibility layer will implement the FSCatalogSearch call if the volume supports the PBCatSearch call (i.e. the bHasCatSearch bit of vMAttrib is set). The compatibility layer will implement the FSExchangeObjects call if the volume supports PBExchangeFiles (i.e. the bHasFileIDs bit of vMAttrib is set). 
Availability
Available in Mac OS X v10.0 and later.*/
struct GetVolParmsInfoBuffer {
   short vMVersion;
   long vMAttrib;
   Handle vMLocalHand;
   long vMServerAdr;
   long vMVolumeGrade;
   short vMForeignPrivID;
   long vMExtendedAttributes;
   void * vMDeviceID;
   UniCharCount vMMaxNameLength;
};
typedef struct GetVolParmsInfoBuffer GetVolParmsInfoBuffer;

/*Volume Information Bitmap Constants

Indicate what volume information to set or retrieve.

enum {
   kFSVolInfoNone = 0x0000,
   kFSVolInfoCreateDate = 0x0001,
   kFSVolInfoModDate = 0x0002,
   kFSVolInfoBackupDate = 0x0004,
   kFSVolInfoCheckedDate = 0x0008,
   kFSVolInfoFileCount = 0x0010,
   kFSVolInfoDirCount = 0x0020,
   kFSVolInfoSizes = 0x0040,
   kFSVolInfoBlocks = 0x0080,
   kFSVolInfoNextAlloc = 0x0100,
   kFSVolInfoRsrcClump = 0x0200,
   kFSVolInfoDataClump = 0x0400,
   kFSVolInfoNextID = 0x0800,
   kFSVolInfoFinderInfo = 0x1000,
   kFSVolInfoFlags = 0x2000,
   kFSVolInfoFSInfo = 0x4000,
   kFSVolInfoDriveInfo = 0x8000,
   kFSVolInfoGettableInfo = 0xFFFF,
   kFSVolInfoSettableInfo = 0x3004
};
Constants
kFSVolInfoNone

No volume information.

Available in Mac OS X v10.0 and later.
kFSVolInfoCreateDate

Retrieve the creation date of the volume.

Available in Mac OS X v10.0 and later.
kFSVolInfoModDate

Retrieve the date of the volume’s last modification.

Available in Mac OS X v10.0 and later.
kFSVolInfoBackupDate

Retrieve or set the date of the volume’s last backup.

Available in Mac OS X v10.0 and later.
kFSVolInfoCheckedDate

Retrieve the date that the volume was last checked for consistency.

Available in Mac OS X v10.0 and later.
kFSVolInfoFileCount

Retrieve the number of files on the volume.

Available in Mac OS X v10.0 and later.
kFSVolInfoDirCount

Retrieve the number of directories on the volume.

Available in Mac OS X v10.0 and later.
kFSVolInfoSizes

Retrieve the total number of bytes on the volume and the number of unused bytes on the volume (in the totalBytes and freeBytes fields).

Available in Mac OS X v10.0 and later.
kFSVolInfoBlocks

Retrieve the block information: the block size, the number of total blocks on the volume, and the number of free blocks on the volume. 

Available in Mac OS X v10.0 and later.
kFSVolInfoNextAlloc

Retrieve the address at which to start the next allocation.

Available in Mac OS X v10.0 and later.
kFSVolInfoRsrcClump

Retrieve the resource fork clump size.

Available in Mac OS X v10.0 and later.
kFSVolInfoDataClump

Retrieve the data fork clump size.

Available in Mac OS X v10.0 and later.
kFSVolInfoNextID

Retrieve the next available catalog node ID.

Available in Mac OS X v10.0 and later.
kFSVolInfoFinderInfo

Retrieve or set the volume’s Finder information.

Available in Mac OS X v10.0 and later.
kFSVolInfoFlags

Retrieve or set the volume’s flags. See Volume Information Flags for more information on the volume’s flags.

Available in Mac OS X v10.0 and later.
kFSVolInfoFSInfo

Retrieve the filesystem ID and signature.

Available in Mac OS X v10.0 and later.
kFSVolInfoDriveInfo

Retrieve the drive information: the drive number and driver reference number.

Available in Mac OS X v10.0 and later.
kFSVolInfoGettableInfo

Retrieve all of the gettable information.

Available in Mac OS X v10.0 and later.
kFSVolInfoSettableInfo

Set all of the settable information. Currently, this is the backup date, Finder information, and flags.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used with the FSVolumeInfoBitmap data type to indicate what volume information to set or retrieve with the functions FSSetVolumeInfo and FSGetVolumeInfo , and their corresponding parameter block calls*/
enum {
   kFSVolInfoNone = 0x0000,
   kFSVolInfoCreateDate = 0x0001,
   kFSVolInfoModDate = 0x0002,
   kFSVolInfoBackupDate = 0x0004,
   kFSVolInfoCheckedDate = 0x0008,
   kFSVolInfoFileCount = 0x0010,
   kFSVolInfoDirCount = 0x0020,
   kFSVolInfoSizes = 0x0040,
   kFSVolInfoBlocks = 0x0080,
   kFSVolInfoNextAlloc = 0x0100,
   kFSVolInfoRsrcClump = 0x0200,
   kFSVolInfoDataClump = 0x0400,
   kFSVolInfoNextID = 0x0800,
   kFSVolInfoFinderInfo = 0x1000,
   kFSVolInfoFlags = 0x2000,
   kFSVolInfoFSInfo = 0x4000,
   kFSVolInfoDriveInfo = 0x8000,
   kFSVolInfoGettableInfo = 0xFFFF,
   kFSVolInfoSettableInfo = 0x3004
};


/*FSVolumeInfoBitmap

Describes which fields of the FSVolumeInfo structure you wish to retrieve or set.

typedef UInt32 FSVolumeInfoBitmap;
Discussion

If the bit corresponding to a particular field is not set in the bitmap, then that field is not changed in the FSVolumeInfo structure if it is an output parameter, and that field is ignored if the FSVolumeInfo structure is an input parameter. See Volume Information Bitmap Constants for a description of the constants you should use with this data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 FSVolumeInfoBitmap;

/*FSVolumeInfo

Used when getting or setting information about a volume.

struct FSVolumeInfo {
   UTCDateTime createDate;
   UTCDateTime modifyDate;
   UTCDateTime backupDate;
   UTCDateTime checkedDate;
   UInt32 fileCount;
   UInt32 folderCount;
   UInt64 totalBytes;
   UInt64 freeBytes;
   UInt32 blockSize;
   UInt32 totalBlocks;
   UInt32 freeBlocks;
   UInt32 nextAllocation;
   UInt32 rsrcClumpSize;
   UInt32 dataClumpSize;
   UInt32 nextCatalogID;
   UInt8 finderInfo[32];
   UInt16 flags;
   UInt16 filesystemID;
   UInt16 signature;
   UInt16 driveNumber;
   short driverRefNum;
};
typedef struct FSVolumeInfo FSVolumeInfo;
typedef FSVolumeInfo * FSVolumeInfoPtr;
Fields
createDate

The date and time the volume was created. A value of 0 means that the volume creation date is unknown. 
modifyDate

The last time when the volume was modified in any way. A value of 0 means “never” or “unknown.
backupDate

Indicates when the volume was last backed up. This field is for use by backup utilities. A value of 0 means “never” or “unknown.
checkedDate

The last date and time that the volume was checked for consistency. A value of 0 means “never” or “unknown.
fileCount

The total number of files on the volume, or 0 if unknown.
folderCount

The total number of folders on the volume, or 0 if unknown. Note that no root directory counts.
totalBytes

The size of the volume in bytes.
freeBytes

The number of bytes of free space on the volume.
blockSize

The size of an allocation block, in bytes. This field is only appropriate for volume formats (such as HFS and HFS Plus) that allocate space in fixed-size pieces; other volume formats may not have a similar concept, and may set this field to zero.
totalBlocks

The total number of allocation blocks on the volume. This field is only appropriate for volume formats (such as HFS and HFS Plus) that allocate space in fixed-size pieces; other volume formats may not have a similar concept, and may set this field to zero.
freeBlocks

The number of unused allocation blocks on the volume. This field is only appropriate for volume formats (such as HFS and HFS Plus) that allocate space in fixed-size pieces; other volume formats may not have a similar concept, and may set this field to zero.
nextAllocation

A hint for where to start searching for free space during an allocation. This field is only appropriate for volume formats (such as HFS and HFS Plus) that allocate space in fixed-size pieces; other volume formats may not have a similar concept, and may set this field to zero.
rsrcClumpSize

Default resource fork clump size. When a fork is automatically grown as it is written, the File Manager attempts to allocate space that is a multiple of the clump size. This field is zero for volume formats that don’t support the notion of a clump size.
dataClumpSize

Default data fork clump size. When a fork is automatically grown as it is written, the File Manager attempts to allocate space that is a multiple of the clump size. This field is zero for volume formats that don’t support the notion of a clump size.
nextCatalogID

The next unused catalog node ID. Some volume formats (such as HFS and HFS Plus) use a monotonically increasing number for the catalog node ID (i.e. File ID or Directory ID) of newly created files and directories. For those volume formats, the nextCatalogID is the next file/directory ID that will be assigned. For other volume formats, this field will be zero.
finderInfo

Information used by Finder, such as the Directory ID of the System Folder. Some volume formats do not support Finder information for a volume and will set this field to all zeroes.
flags

This field contains bit flags holding informaiton about the volume. See Volume Information Flags for the attribute constants you can use here.
filesystemID

Identifies the filesystem implementation that is handling the volume; this is zero for HFS and HFS Plus volumes.
signature

This field is used to distinguish between volume formats supported by a single filesystem implementation.
driveNumber

The drive number for the drive (drive queue element) associated with the volume. Mac OS X does not support drive numbers; in Mac OS X, the File Manager always returns a value of 1 in this field.
driverRefNum

The driver reference number for the drive (drive queue element) associated with the volume.
Discussion

This structure contains information about a volume as a whole information about a volume’s root directory would use the FSCatalogInfo structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FSVolumeInfo {
   UTCDateTime createDate;
   UTCDateTime modifyDate;
   UTCDateTime backupDate;
   UTCDateTime checkedDate;
   UInt32 fileCount;
   UInt32 folderCount;
   UInt64 totalBytes;
   UInt64 freeBytes;
   UInt32 blockSize;
   UInt32 totalBlocks;
   UInt32 freeBlocks;
   UInt32 nextAllocation;
   UInt32 rsrcClumpSize;
   UInt32 dataClumpSize;
   UInt32 nextCatalogID;
   UInt8 finderInfo[32];
   UInt16 flags;
   UInt16 filesystemID;
   UInt16 signature;
   UInt16 driveNumber;
   short driverRefNum;
};
typedef struct FSVolumeInfo FSVolumeInfo;

/*File Access Permission Constants

Specify the type of read and write access to a file or fork.

enum {
   fsCurPerm = 0x00,
   fsRdPerm = 0x01,
   fsWrPerm = 0x02,
   fsRdWrPerm = 0x03,
   fsRdWrShPerm = 0x04,
   fsRdDenyPerm = 0x10,
   fsWrDenyPerm = 0x20
};
Constants
fsCurPerm

Requests whatever permissions are currently allowed. If write access in unavailable (because the file is locked or the file is already open with write permission), then read permission is granted. Otherwise read/write permission is granted.

Available in Mac OS X v10.0 and later.
fsRdPerm

Requests permission to read the file.

Available in Mac OS X v10.0 and later.
fsWrPerm

Requests permission to write to the file. If write permission is granted, no other access paths are granted write permission. Note, however, that the File Manager does not support write-only access to a file. Thus, fsWrPerm is synonymous with fsRdWrPerm.

Available in Mac OS X v10.0 and later.
fsRdWrPerm

Requests exclusive read and write permission. If exclusive read/ write permission is granted, no other users are granted permission to write to the file. Other users may, however, be granted permission to read the file.

Available in Mac OS X v10.0 and later.
fsRdWrShPerm

Requests shared read and write permission. Shared read and write permission allows mutiple access paths for reading and writing. This is safe only if there is some way of locking portions of the file before writing to them. On volumes that support range locking, you can use the functions PBLockRangeSync and PBUnlockRangeSync to lock and unlock ranges of bytes within a file. Applications running in Mac OS X version 10.4 or later should use the functions FSLockRange and FSUnlockRange for this purpose. 

Available in Mac OS X v10.0 and later.
fsRdDenyPerm

Requests that any other paths be prevented from having read access. A path cannot be opened if you request read permission (with the fsRdPerm constant) but some other path has requested deny-read access. Similarly, the path cannot be opened if you request deny-read permission, but some other path already has read access. This constant is used with the PBHOpenDenySync and PBHOpenRFDenySync functions. 

Available in Mac OS X v10.0 and later.
fsWrDenyPerm

Requests that any other paths be prevented from having write access. A path cannot be opened if you request write permission (with the fsWrPerm constant) but some other path has requested deny-write access. Similarly, the path cannot be opened if you request deny-write permission, but some other path already has write access. This constant is used with the PBHOpenDenySync and PBHOpenRFDenySync functions.

Available in Mac OS X v10.0 and later.
Discussion

Use these constants to request a type of access to a file or fork, or to deny a type of access to a file or fork to other paths that may request access.

Note that it is possible, in Mac OS 8 and 9, to open a file residing on read-only media with write access. In Mac OS X, however, you cannot open a file with write access on read-only media; the attempt to open the file fails with a wrPermErr error.*/
enum {
   fsCurPerm = 0x00,
   fsRdPerm = 0x01,
   fsWrPerm = 0x02,
   fsRdWrPerm = 0x03,
   fsRdWrShPerm = 0x04,
   fsRdDenyPerm = 0x10,
   fsWrDenyPerm = 0x20
};

/*Position Mode Constants

Together with an offset, specify a position within a fork.

enum {
   fsAtMark = 0,
   fsFromStart = 1,
   fsFromLEOF = 2,
   fsFromMark = 3
};
Constants
fsAtMark

The starting point is the access path’s current position. The offset is ignored.

Available in Mac OS X v10.0 and later.
fsFromStart

The starting point is offset bytes from the start of the fork. The offset must be non-negative.

Available in Mac OS X v10.0 and later.
fsFromLEOF

The starting point is offset bytes from the logical end of the fork. The offset must not be positive.

Available in Mac OS X v10.0 and later.
fsFromMark

The starting point is offset bytes from the access path’s current position. The offset may be positive or negative.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the ioPosMode and positionMode fields and parameters of the HFS and HFS Plus file access functions. These functions include those for reading from and writing to files or forks, changing the current position within a file or fork, changing the size of a file or fork, and allocating space to a file or fork.

For the FSReadFork and FSWriteFork calls, you may also add either of the pleaseCacheMask or noCacheMask constants to hint whether the data should be cached or not. See Cache Constants.*/
enum {
   fsAtMark = 0,
   fsFromStart = 1,
   fsFromLEOF = 2,
   fsFromMark = 3
};

/*Catalog Information Bitmap Constants

Specify what file or fork information to get or set.

enum {
   kFSCatInfoNone = 0x00000000,
   kFSCatInfoTextEncoding = 0x00000001,
   kFSCatInfoNodeFlags = 0x00000002,
   kFSCatInfoVolume = 0x00000004,
   kFSCatInfoParentDirID = 0x00000008,
   kFSCatInfoNodeID = 0x00000010,
   kFSCatInfoCreateDate = 0x00000020,
   kFSCatInfoContentMod = 0x00000040,
   kFSCatInfoAttrMod = 0x00000080,
   kFSCatInfoAccessDate = 0x00000100,
   kFSCatInfoBackupDate = 0x00000200,
   kFSCatInfoPermissions = 0x00000400,
   kFSCatInfoFinderInfo = 0x00000800,
   kFSCatInfoFinderXInfo = 0x00001000,
   kFSCatInfoValence = 0x00002000,
   kFSCatInfoDataSizes = 0x00004000,
   kFSCatInfoRsrcSizes = 0x00008000,
   kFSCatInfoSharingFlags = 0x00010000,
   kFSCatInfoUserPrivs = 0x00020000,
   kFSCatInfoUserAccess = 0x00080000,
   kFSCatInfoSetOwnership = 0x00100000,
   kFSCatInfoAllDates = 0x000003E0,
   kFSCatInfoGettableInfo = 0x0003FFFF,
   kFSCatInfoSettableInfo = 0x00001FE3,
   kFSCatInfoReserved = 0xFFFC0000
};
Constants
kFSCatInfoNone

No catalog information.

Available in Mac OS X v10.0 and later.
kFSCatInfoTextEncoding

Retrieve or set the text encoding hint, in the textEncodingHint field.

Available in Mac OS X v10.0 and later.
kFSCatInfoNodeFlags

Retrieve or set the catalog node flags. Currently, you can only set bits 0 and 4. See Catalog Information Node Flags for more information on these flags.

Available in Mac OS X v10.0 and later.
kFSCatInfoVolume

Retrieve the volume reference number of the volume on which the file or directory resides.

Available in Mac OS X v10.0 and later.
kFSCatInfoParentDirID

Retrieve the parent directory ID.

Available in Mac OS X v10.0 and later.
kFSCatInfoNodeID

Retrieve the file or directory ID.

Available in Mac OS X v10.0 and later.
kFSCatInfoCreateDate

Retrieve or set the creation date.

Available in Mac OS X v10.0 and later.
kFSCatInfoContentMod

Retrieve or set the date that the resource or data fork was last modified.

Available in Mac OS X v10.0 and later.
kFSCatInfoAttrMod

Retrieve or set the date that an attribute or named fork was last modified.

Available in Mac OS X v10.0 and later.
kFSCatInfoAccessDate

Retrieve or set the date that the fork or file was last accessed.

Available in Mac OS X v10.0 and later.
kFSCatInfoBackupDate

Retrieve or set the date that the fork or file was last backed up.

Available in Mac OS X v10.0 and later.
kFSCatInfoPermissions

Retrieve or set the file or fork’s permissions.

Available in Mac OS X v10.0 and later.
kFSCatInfoFinderInfo

Retrieve or set the file or fork’s Finder information.

Available in Mac OS X v10.0 and later.
kFSCatInfoFinderXInfo

Retrieve or set the file or fork’s extended Finder information.

Available in Mac OS X v10.0 and later.
kFSCatInfoValence

For folders only, retrieve the valence of the folder. For files, this is zero.

Available in Mac OS X v10.0 and later.
kFSCatInfoDataSizes

Retrieve the logical and physical size of the data fork.

Available in Mac OS X v10.0 and later.
kFSCatInfoRsrcSizes

Retrieve the logical and physical size of the resource fork.

Available in Mac OS X v10.0 and later.
kFSCatInfoSharingFlags

Retrieve the fork or file’s sharing flags: kioFlAttribMountedBit, kioFlAttribSharePointBit. See File Attribute Constants for more information on these bits.

Available in Mac OS X v10.0 and later.
kFSCatInfoUserPrivs

Retrieve the file’s user privileges.

Available in Mac OS X v10.0 and later.
kFSCatInfoUserAccess

Available in Mac OS X v10.1 and later.
kFSCatInfoSetOwnership

Attempt to set the file’s user and group (UID and GID). If the File Manager cannot set the the user or group ID, the call fails. (Mac OS X only).

Available in Mac OS X v10.3 and later.
kFSCatInfoAllDates

Retrieve or set all of the date information for the fork or file: creation date, modification dates, access date, backup date, etc.

Available in Mac OS X v10.0 and later.
kFSCatInfoGettableInfo

Retrieve all gettable data.

Available in Mac OS X v10.0 and later.
kFSCatInfoSettableInfo

Set all settable data. This includes the flags, dates, permissions, Finder info, and text encoding hint.

Available in Mac OS X v10.0 and later.
kFSCatInfoReserved

Represents bits that are currently reserved.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the FSCatalogInfoBitmap type to specify what file or fork information to get or set. If used with the FSGetCatalogInfo or FSGetCatalogInfoBulk functions, these constants tell the File Manager which fields to return information in. If used with the FSSetCatalogInfo function, these constants tell the File Manager which fields you’ve filled out with values that it should use to change the fork or file’s catalog information.*/
enum {
   kFSCatInfoNone = 0x00000000,
   kFSCatInfoTextEncoding = 0x00000001,
   kFSCatInfoNodeFlags = 0x00000002,
   kFSCatInfoVolume = 0x00000004,
   kFSCatInfoParentDirID = 0x00000008,
   kFSCatInfoNodeID = 0x00000010,
   kFSCatInfoCreateDate = 0x00000020,
   kFSCatInfoContentMod = 0x00000040,
   kFSCatInfoAttrMod = 0x00000080,
   kFSCatInfoAccessDate = 0x00000100,
   kFSCatInfoBackupDate = 0x00000200,
   kFSCatInfoPermissions = 0x00000400,
   kFSCatInfoFinderInfo = 0x00000800,
   kFSCatInfoFinderXInfo = 0x00001000,
   kFSCatInfoValence = 0x00002000,
   kFSCatInfoDataSizes = 0x00004000,
   kFSCatInfoRsrcSizes = 0x00008000,
   kFSCatInfoSharingFlags = 0x00010000,
   kFSCatInfoUserPrivs = 0x00020000,
   kFSCatInfoUserAccess = 0x00080000,
   kFSCatInfoSetOwnership = 0x00100000,
   kFSCatInfoAllDates = 0x000003E0,
   kFSCatInfoGettableInfo = 0x0003FFFF,
   kFSCatInfoSettableInfo = 0x00001FE3,
   kFSCatInfoReserved = 0xFFFC0000
};


/*FSCatalogInfoBitmap

Describes which fields of the FSCatalogInfo structure you wish to retrieve or set.

typedef UInt32 FSCatalogInfoBitmap;
Discussion

If the bit corresponding to a particular field is not set in the bitmap, then that field is not changed in the FSCatalogInfo structure if it is an output parameter, and that field is ignored if the FSCatalogInfo structure is an input parameter. See Catalog Information Bitmap Constants for a description of the constants you should use with this data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 FSCatalogInfoBitmap;

/*FSVolumeRefNum

Identifies a particular mounted volume.

typedef SInt16 FSVolumeRefNum;
Discussion

This data type is the same as the 16-bit volume refnum previously passed in the ioVRefNum fields of a parameter block; this is simply a new type name for the old data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 FSVolumeRefNum;


/*FSIterator

Refers to a position within the catalog, used when iterating over files and folders in a directory.

typedef struct OpaqueFSIterator * FSIterator;
Discussion

This data type is like a file reference number because it maintains state internally to the File Manager and must be explicitly opened and closed.

An FSIterator is returned by FSOpenIterator and is passed as input to FSGetCatalogInfoBulk , FSCatalogSearch and FSCloseIterator. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueFSIterator * FSIterator;

/*Iterator Flags

Indicate whether an iterator iterates over subtrees or just the immediate children of the container.

enum {
   kFSIterateFlat = 0,
   kFSIterateSubtree = 1,
   kFSIterateDelete = 2,
   kFSIterateReserved = 0xFFFFFFFC
};
typedef OptionBits FSIteratorFlags;
Constants
kFSIterateFlat

Iterate over the immediate children of the container only. 

Available in Mac OS X v10.0 and later.
kFSIterateSubtree

Iterate over the entire subtree rooted at the container.

Available in Mac OS X v10.0 and later.
kFSIterateDelete

Available in Mac OS X v10.0 and later.
kFSIterateReserved

Available in Mac OS X v10.0 and later.*/
enum {
   kFSIterateFlat = 0,
   kFSIterateSubtree = 1,
   kFSIterateDelete = 2,
   kFSIterateReserved = 0xFFFFFFFC
};
typedef OptionBits FSIteratorFlags;

/*FSVolumeMountProcPtr


typedef void (*FSVolumeMountProcPtr) (
   FSVolumeOperation volumeOp,
   void * clientData,
   OSStatus err,
   FSVolumeRefNum mountedVolumeRefNum
);

If you name your function MyFSVolumeMountProc, you would declare it like this:

void MyFSVolumeMountProc (
   FSVolumeOperation volumeOp,
   void * clientData,
   OSStatus err,
   FSVolumeRefNum mountedVolumeRefNum
);
Parameters
volumeOp
clientData
err
mountedVolumeRefNum*/

typedef void (*FSVolumeMountProcPtr) (
   FSVolumeOperation volumeOp,
   void * clientData,
   OSStatus err,
   FSVolumeRefNum mountedVolumeRefNum
);


/*FSVolumeMountUPP


typedef void (*FSVolumeMountProcPtr) (
   FSVolumeOperation volumeOp,
   void * clientData,
   OSStatus err,
   FSVolumeRefNum mountedVolumeRefNum
);

typedef FSVolumeMountProcPtr FSVolumeMountUPP;
Discussion

For more information, see the description of the FSVolumeMountProcPtr callback function.*/
typedef FSVolumeMountProcPtr FSVolumeMountUPP;


/*FSForkIOParam

Defines a parameter block used by low-level HFS Plus fork I/O functions.

struct FSForkIOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   void * reserved1;
   SInt16 reserved2;
   SInt16 forkRefNum;
   UInt8 reserved3;
   SInt8 permissions;
   const FSRef * ref;
   Ptr buffer;
   UInt32 requestCount;
   UInt32 actualCount;
   UInt16 positionMode;
   SInt64 positionOffset;
   FSAllocationFlags allocationFlags;
   UInt64 allocationAmount;
   UniCharCount forkNameLength;
   const UniChar * forkName;
   CatPositionRec forkIterator;
   HFSUniStr255 * outForkName;
};
typedef struct FSForkIOParam FSForkIOParam;
typedef FSForkIOParam * FSForkIOParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
reserved1

Reserved.
reserved2

Reserved.
forkRefNum

A reference number for a fork.
reserved3

Reserved.
permissions

The desired type of access to the specified fork.
ref

An FSRef for the file or directory to open. 
buffer

A pointer to a data buffer.
requestCount

The number of bytes requested for the given operation.
actualCount

The actual number of bytes completed by the call.
positionMode

A constant indicating the base location within the file for the start of the operation. See Position Mode Constants for the meaning of the constants you can use in this field.
positionOffset

The offset from the base location specified in the positionMode offset for the start of the operation.
allocationFlags

A set of bit flags used by the FSAllocateFork function to control how space is allocated. See Allocation Flags for a descsription of the defined flags.
allocationAmount

For the FSAllocateFork function, the amount of space, in bytes, to allocate.
forkNameLength

The length of the file or directory name passed in the forkName field, in Unicode characters.
forkName

A pointer to the file or directory’s Unicode name. This field is an input parameter functions which return the file or directory name in the parameter block use the outForkName field.
forkIterator

A fork iterator. 
outForkName

A pointer to the file or directory’s Unicode name this is an output parameter. For functions which require the file or directory name as an input argument, you should pass a pointer to that name in the forkName field and pass the length of the name in the forkNameLength field. 
Availability
Available in Mac OS X v10.0 and later.*/

struct FSForkIOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   void * reserved1;
   SInt16 reserved2;
   SInt16 forkRefNum;
   UInt8 reserved3;
   SInt8 permissions;
   const FSRef * ref;
   Ptr buffer;
   UInt32 requestCount;
   UInt32 actualCount;
   UInt16 positionMode;
   SInt64 positionOffset;
   FSAllocationFlags allocationFlags;
   UInt64 allocationAmount;
   UniCharCount forkNameLength;
   const UniChar * forkName;
   CatPositionRec forkIterator;
   HFSUniStr255 * outForkName;
};
typedef struct FSForkIOParam FSForkIOParam;
typedef FSForkIOParam * FSForkIOParamPtr;


/*DrvQEl

Defines a drive queue element.

struct DrvQEl {
   QElemPtr qLink;
   short qType;
   short dQDrive;
   short dQRefNum;
   short dQFSID;
   unsigned short dQDrvSz;
   unsigned short dQDrvSz2;
};
typedef struct DrvQEl DrvQEl;
typedef DrvQEl * DrvQElPtr;
Fields
qLink

A pointer to the next entry in the drive queue. 
qType

Used to specify the size of the drive. If the value of this field is 0, the number of logical blocks on the drive is contained in the dQDrvSz field alone. If the value of this field is 1, both the dQDrvSz field and the dQDrvSz2 field are used to store the number of blocks; in that case, the dQDrvSz2 field contains the high-order word of this number and dQDrvSz contains the low-order word.
dQDrive

The drive number of the drive.
dQRefNum

The driver reference number of the driver controlling the device on which the volume is mounted.
dQFSID

An identifier for the file system handling the volume in the drive it’s zero for volumes handled by the File Manager and nonzero for volumes handled by other file systems.
dQDrvSz

The number of logical blocks on the drive.
dQDrvSz2

An additional field to handle large drives. This field is only used if the qType field is 1.
Discussion

The File Manager maintains a list of all disk drives connected to the computer. It maintains this list in the drive queue, which is a standard operating system queue. The drive queue is initially created at system startup time. Elements are added to the queue at system startup time or when you call the AddDrive function. The drive queue can support any number of drives, limited only by memory space. Each element in the drive queue contains information about the corresponding drive. 
Availability
Available in Mac OS X v10.0 and later.*/
struct DrvQEl {
   QElemPtr qLink;
   short qType;
   short dQDrive;
   short dQRefNum;
   short dQFSID;
   unsigned short dQDrvSz;
   unsigned short dQDrvSz2;
};
typedef struct DrvQEl DrvQEl;
typedef DrvQEl * DrvQElPtr;


//function


/*FSOpenIterator

Creates a catalog iterator that can be used to iterate over the contents of a directory or volume.

OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
);
Parameters
container

A pointer to an FSRef for the directory to iterate. The set of items to iterate over can either be the objects directly contained in the directory, or all items directly or indirectly contained in the directory (in which case, the specified directory is the root of the subtree to iterate). See FSRef for a description of the FSRef data type.
iteratorFlags

A set of flags which controls whether the iterator iterates over subtrees or just the immediate children of the container. See Iterator Flags for a description of the flags defined for this parameter.

Iteration over subtrees which do not originate at the root directory of a volume are not currently supported, and passing the kFSIterateSubtree flag in this parameter returns errFSBadIteratorFlags. To determine whether subtree iterators are supported, check that the bSupportsSubtreeIterators bit returned by PBHGetVolParmsSync or PBHGetVolParmsAsync is set.
iterator

On return, a pointer to the new FSIterator. You can pass this iterator to the FSGetCatalogInfoBulk or FSCatalogSearch functions and their parameter block-based counterparts.

The iterator is automatically initialized so that the next use of the iterator returns the first item. The order that items are returned in is volume format dependent and may be different for two different iterators created with the same container and flags.

See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Catalog iterators must be closed when you are done using them, whether or not you have iterated over all the items. Iterators are automatically closed upon process termination, just like open files. However, you should use the FSCloseIterator function, or one of the related parameter block functions, PBCloseIteratorSync and PBCloseIteratorAsync , to close an iterator to free up any system resources allocated to the iterator.

Before calling this function, you should check that it is present, by calling the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
);

/*FSGetCatalogInfoBulk

Returns information about one or more objects from a catalog iterator. This function can return information about multiple objects in a single call.

OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
);
Parameters
iterator

The iterator to use. You can obtain a catalog iterator with the function FSOpenIterator, or with one of the related parameter block calls, PBOpenIteratorSync and PBOpenIteratorAsync. Currently, the iterator must be created with the kFSIterateFlat option. See FSIterator for a description of the FSIterator data type.
maximumObjects

The maximum number of items to return for this call. 
actualObjects

On return, a pointer to the actual number of items found for this call.
containerChanged

On return, a pointer to a value indicating whether or not the container’s contents have changed since the previous FSGetCatalogInfoBulk call. If true, the contents have changed. Objects may still be returned, even though the container has changed. If so, note that if the container has changed, then the total set of items returned may be incorrect: some items may be returned multiple times, and some items may not be returned at all.

This parameter is optional if you don’t want this information returned, pass a NULL pointer. 

On versions of Mac OS X prior to 10.2, this parameter is unset. On Mac OS X version 10.2, this parameter is always set to false. To find out whether the container has changed since the last call to FSGetCatalogInfoBulk, check the modification date of the container.
whichInfo

A bitmap specifying the catalog information fields to return for each item. If you don’t wish any catalog information returned, pass the constant kFSCatInfoNone in this parameter. For a description of the bits in this parameter, see Catalog Information Bitmap Constants.
catalogInfos

A pointer to an array of catalog information structures; one for each returned item. On input, the catalogInfos parameter should point to an array of maximumObjects catalog information structures.

This parameter is optional; if you do not wish any catalog information returned, pass NULL here.

refs

A pointer to an array of FSRef structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSRef structures. 

This parameter is optional; if you do not wish any FSRef structures returned, pass NULL here.
specs

A pointer to an array of FSSpec structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSSpec structures. 

This parameter is optional; if you do not wish any FSSpec structures returned, pass NULL here.
names

A pointer to an array of names; one for each returned item. If you want the Unicode name for each item found, set this parameter to point to an array of maximumObjectsHFSUniStr255 structures. Otherwise, set it to NULL. 
Return Value

A result code. See “File Manager Result Codes”. When all of the iterator’s objects have been returned, the call will return errFSNoMoreItems.
Discussion

The FSGetCatalogInfoBulk call may complete and return noErr with fewer than maximumObjects items returned. This may be due to various reasons related to the internal implementation. In this case, you may continue to make FSGetCatalogInfoBulk calls using the same iterator.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
);

/*FSMakeFSRefUnicode

Constructs an FSRef for a file or directory, given a parent directory and a Unicode name. 

OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);
Parameters
parentRef

A pointer to the FSRef of the parent directory of the file or directory for which to create a new FSRef. See FSRef for a description of the FSRef data type.
nameLength

The length of the file or directory name. 
name

A pointer to the Unicode name for the file or directory. The name must be a leaf name; partial or full pathnames are not allowed. If you have a partial or full pathname in Unicode, you will have to parse it yourself and make multiple calls to FSMakeFSRefUnicode. 
textEncodingHint

The suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef

On return, if the function returns a result of noErr, a pointer to the new FSRef.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);

/*FSCloseIterator

Closes a catalog iterator. 

OSErr FSCloseIterator (
   FSIterator iterator
);
Parameters
iterator

The catalog iterator to be closed. FSCloseIterator releases memory and other system resources used by the iterator, making the iterator invalid. See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function releases memory and other system resources used by the iterator. The iterator becomes invalid. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseIterator (
   FSIterator iterator
);

/*FSCloseFork

Closes an open fork.

OSErr FSCloseFork (
   SInt16 forkRefNum
);
Parameters
forkRefNum

The reference number of the fork to close. After the call to this function, the reference number in this parameter is invalid. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSCloseFork function causes all data written to the fork to be written to disk, in the same manner as the FSFlushFork function, before it closes the fork. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseFork (
   SInt16 forkRefNum
);

/*FSReadFork

Reads data from an open fork.

OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
);
Parameters
forkRefNum

The reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.

The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. 

If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.

See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read.

positionOffset

The offset from the base location for the start of the read. 
requestCount

The number of bytes to read. 
buffer

A pointer to the buffer where the data will be returned. 
actualCount

On return, a pointer to the number of bytes actually read. The value pointed to by the actualCount parameter should be equal to the value in the requestCount parameter unless there was an error during the read operation.

This parameter is optional; if you don’t want this information returned, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned.
Discussion

FSReadFork reads data starting at the position specified by the positionMode and positionOffset parameters. The function reads up to requestCount bytes into the buffer pointed to by the buffer parameter and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode parameter and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
);

/*FSOpenFork

Opens any fork of a file or directory for streaming access.

OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
);
Parameters
ref

A pointer to an FSRef specifying the file or directory owning the fork to open. See FSRef for a description of the FSRef data type.
forkNameLength

The length of the fork name in Unicode characters. 
forkName

A pointer to the Unicode name of the fork to open. You can obtain the string constants for the data fork and resource fork names using the FSGetDataForkName and FSGetResourceForkName functions. All volume formats should support data and resource forks; other named forks may be supported by some volume formats. 
permissions

A constant indicating the type of access which you wish to have to the fork via the returned fork reference. This parameter is the same as the permission parameter passed to the FSpOpenDF and FSpOpenRF functions. For a description of the types of access which you can request, see File Access Permission Constants. 
forkRefNum

On return, a pointer to the fork reference number for accessing the open fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSOpenFork will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

When you use this function to open a file on a local volume and pass in a permissions value of fsCurPerm, fsWrPerm, or fsRdWrPerm , Mac OS X does not guarantee exclusive file access. Before making any assumptions about the underlying file access, you should always check to see whether the Supports Exclusive Locks feature is available. If this feature is not available, your application cannot know whether another application has access to the same file. For more information, see ADC Technical Note TN2037. 

To access named forks or forks larger than 2GB, you must use the FSOpenFork function or one of the corresponding parameter block calls: PBOpenForkSync and PBOpenForkAsync. To determine if the FSOpenFork function is present, call the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
);

/*FSGetCatalogInfo

Returns catalog information about a file or directory. You can use this function to map an FSRef to an FSSpec.

OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
);
Parameters
ref

A pointer to an FSRef specifying the file or directory for which to retrieve information. See FSRef for a description of the FSRef data type. 
whichInfo

A bitmap specifying the catalog information fields to return. If you don’t want any catalog information, set whichInfo to the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits in this parameter.
catalogInfo

On return, a pointer to a catalog information structure containing the information about the file or directory. Only the information specified in the whichInfo parameter is returned. If you don’t want any catalog information, pass NULL here. See FSCatalogInfo for a description of the FSCatalogInfo data type.
outName

On return, a pointer to the Unicode name of the file or directory is returned here. This parameter is optional; if you do not wish the name returned, pass NULL here. See HFSUniStr255 for a description of the HFSUniStr255 data type.
fsSpec

On return, a pointer to the FSSpec for the file or directory. This parameter is optional; if you do not wish the FSSpec returned, pass NULL here. See FSSpec for a description of the FSSpec data type.
parentRef

On return, a pointer to the FSRef for the object's parent directory. This parameter is optional; if you do not wish the parent directory returned, pass NULL here.

If the object specified in the ref parameter is a volume’s root directory, then the FSRef returned here will not be a valid FSRef, since the root directory has no parent object.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
);

/*FSPathMakeRef

Converts a path into an FSRef structure.

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory
);
Parameters
path

The path for which to return an FSRef. This path can be used by POSIX-style calls. 
ref

On return, a pointer to the FSRef. 
isDirectory

A Boolean value indicating whether the object at specified by the given path is a directory. This parameter is optional and can be NULL. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory
);

/*FSGetVolumeInfo

Returns information about a volume.

OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory
);
Parameters
volume

If you wish to obtain information on a particular volume, pass that volume’s reference number here. If you wish to index through the list of mounted volumes, pass the constant kFSInvalidVolumeRefNum in this parameter. See FSVolumeRefNum for a description of the FSVolumeRefNum data type.
volumeIndex

The index of the desired volume, or 0 to use the volume reference number in the volume parameter. 
actualVolume

On return, a pointer to the volume reference number of the volume. This is useful when indexing over all mounted volumes. If you don’t want this information (if, for instance, you supplied a particular volume reference number in the volume) parameter, set actualVolume to NULL.
whichInfo

A bitmap specifying which volume information fields to get and return in the info parameter. If you don’t want information about the volume returned in the info parameter, set whichInfo to kFSVolInfoNone. See Volume Information Bitmap Constants for a description of the bits in this parameter.
info

On return, a pointer to the volume information. If you don’t want this output, set this parameter to NULL. See FSVolumeInfo for a description of the FSVolumeInfo data type.
volumeName

On return, a pointer to the Unicode name of the volume. If you do not wish the name returned, pass NULL. See HFSUniStr255 for a description of the HFSUniStr255 data type.
rootDirectory

On return, a pointer to the FSRef for the volume’s root directory. If you do not wish the root directory returned, pass NULL. See FSRef for a description of the FSRef data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You can specify a particular volume or index through the list of mounted volumes. To get information on a particular volume, pass the volume reference number of the desired volume in the volume parameter and set the volumeIndex parameter to zero. To index through the list of mounted volumes, pass kFSInvalidVolumeRefNum in the volume parameter and set volumeIndex to the index, starting at 1 with the first call to FSGetVolumeInfo.

When indexing through the list of mounted volumes, you may encounter an error with a particular volume. The terminating error code for full traversal of this list is nsvErr. In order to completely traverse the entire list, you may have to bump the index count when encountering other errors (for example, ioErr).

To get information about the root directory of a volume, use the FSGetCatalogInfo function, or one of the corresponding parameter block calls, PBGetCatalogInfoSync and PBGetCatalogInfoAsync. 
Special Considerations

After an operation that changes the amount of free space on the volume—such as deleting a file—there may be a delay before a call to FSGetVolumeInfo returns the updated amount. This is because the File Manager caches and periodically updates file system information, to reduce the number of calls made to retrieve the information from the file system. Currently, the File Manager updates its information every 15 seconds. This primarily affects NFS volumes. DOS, SMB, UFS and WebDAV volumes were also affected by this in previous versions of Mac OS X, but behave correctly in Mac OS X version 10.3 and later.
Availability
Available in Mac OS X v10.0 and later.*/
OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory
);

/*PBHGetVolParmsSync

Returns information about the characteristics of a volume.

OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the volume’s name. You can use a either a name or a volume specification to specify the volume. If you use a volume specification to specify the volume, you should set the ioNamePtr field to NULL. 
ioVRefNum 

On input, a volume specification. You can use a either a name or a volume specification to specify the volume. A volume specification can be a volume reference number, drive number, or 0 for the default volume. 
ioBuffer 

On input, a pointer to a GetVolParmsInfoBuffer record; you must allocate this memory to hold the returned attributes. On return, the PBHGetVolParmsSync function places the attributes information in the bufferVolumes that implement the HFS Plus APIs must use version 3 (or newer) of the GetVolParmsInfoBuffer structure. If the version of the GetVolParmsInfoBuffer is 2 or less, or the bSupportsHFSPlusAPIs bit is clear, then the volume does not implement the HFS Plus APIs and they are being emulated for that volume by the File Manager. 
ioReqCount 

On input, the size, in bytes, of the buffer area pointed to in the ioBuffer field. 
ioActCount 

On output, the size of the data actually returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock
);

/*FSMakeFSSpec

Creates an FSSpec structure describing a file or directory. (Deprecated in Mac OS X v10.4. Use FSMakeFSRefUnicode instead.)

OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec
);
Parameters
vRefNum

A volume specification for the volume containing the file or directory. This parameter can contain a volume reference number, a drive number, or 0 to specify the default volume. 
dirID

The parent directory ID of the target object. If the directory is sufficiently specified in the fileName parameter, the dirID parameter can be set to 0. If the fileName parameter contains an empty string, FSMakeFSSpec creates an FSSpec structure for the directory specified by the dirID parameter. 
fileName

A full or partial pathname. If the fileName parameter specifies a full pathname, FSMakeFSSpec ignores both the vRefNum and dirID parameters. A partial pathname might identify only the final target, or it might include one or more parent directory names. If fileName specifies a partial pathname, then vRefNum, dirID, or both must be valid. 
spec

A pointer to a file system specification to be filled in by FSMakeFSSpec. The FSMakeFSSpec function fills in the fields of the file system specification using the information contained in the other three parameters. If your application receives any result code other than noErr or fnfErr, all fields of the resulting FSSpec structure are set to 0. 

The file system specification structure that you pass in this parameter should not share storage space with the input pathname; the name field may be initialized to the empty string before the pathname has been processed. For example, fileName should not refer to the name field of the output file system specification.

Return Value

A result code. See “File Manager Result Codes”.
Discussion

You should call FSMakeFSSpec, or one of the corresponding parameter block functions, PBMakeFSSpecSync and PBMakeFSSpecAsync , whenever you want to create an FSSpec structure. You should not create an FSSpec by filling in the fields of the structure yourself.

If the specified volume is mounted and the specified parent directory exists, but the target file or directory doesn’t exist in that location, FSMakeFSSpec fills in the structure and then returns fnfErr instead of noErr. The structure is valid, but it describes a target that doesn’t exist. You can use the structure for other operations, such as creating a file with the FSpCreate function. 
Carbon Porting Notes

Non-Carbon applications can also specify a working directory reference number in the vRefNum parameter. However, because working directories are not supported in Carbon, you cannot specify a working directory reference number if you wish your application to be Carbon-compatible.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec
);

/*PBGetCatInfoSync

Returns catalog information about a file or directory. (Deprecated in Mac OS X v10.4. Use PBGetCatalogInfoSync instead.)

OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock
);
Parameters
paramBlock

A pointer to an HFS catalog information parameter block. See CInfoPBRec for a description of the CInfoPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBGetCatInfoSync function returns information about a file or directory, depending on the values you specify in the ioFDirIndex, ioNamePtr, ioVRefNum, and ioDirID or ioDrDirID fields. If you need to determine whether the information returned is for a file or a directory, you can test bit 4 of the ioFlAttrib field; if that bit is set, the information returned describes a directory.

The PBGetCatInfoSync function selects a file or directory according to these rules:
If the value of ioFDirIndex is positive, ioNamePtr is not used as an input parameter and PBGetCatInfoSync returns information about the file or directory whose directory index is ioFDirIndex in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). If ioNamePtr is not NULL, then it must point to a Str31 buffer where the file or directory name will be returned. 
If the value of ioFDirIndex is 0, PBGetCatInfoSync returns information about the file or directory specified by ioNamePtr in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (again, this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). 
If the value of ioFDirIndex is negative, PBGetCatInfoSync ignores the ioNamePtr field and returns information about the directory specified in the ioDrDirID field. If ioNamePtr is not NULL, then it must point to a Str31 buffer where the directory name will be returned. 

With files, PBGetCatInfoSync is similar to PBHGetFInfoSync but returns some additional information. If the object is a file, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, the name of the file is returned in this field, if the file is open. If you do not want the name of the file returned, pass NULL in this field. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFRefNum 

On output, a file reference number. If the file is open, the reference number of the first access path found is returned here. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the file attributes. See File Attribute Constants for the meaning of the file attributes. 
ioFlFndrInfo 

On output, information used by the Finder. 
ioDirID 

On input, a directory ID. On output, the file ID. You might need to save the value of ioDirID before calling PBGetCatInfoSync if you make subsequent calls with the same parameter block. 
ioFlStBlk 

On output, the first allocation block of the data fork. 
ioFlLgLen 

On output, the logical size (the logical end-of-file) of the data fork, in bytes. 
ioFlPyLen 

On output, the physical size (the physical end-of-file) of the data fork, in bytes. 
ioFlRStBlk 

On output, the first allocation block of the resource fork. 
ioFlRLgLen 

On output, the logical size of the resource fork, in bytes. 
ioFlRPyLen 

On output, the physical size of the resource fork, in bytes. 
ioFlCrDat 

On output, the date and time of the file’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioFlCrDat field to 0. 
ioFlMdDat 

On output, the date and time of the file’s last modification. 
ioFlBkDat 

On output, the date and time of the file’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioFlBkDat field to 0. 
ioFlXFndrInfo 

On output, additional information used by the Finder. 
ioFlParID 

On output, the directory ID of the file’s parent directory. 
ioFlClpSiz 

On output, the file’s clump size. 

You can also use PBGetCatInfoSync to determine whether a file has a file ID reference. The value of the file ID is returned in the ioDirID field. Because that parameter could also represent a directory ID, call PBResolveFileIDRefSync to see if the value is a real file ID. If you want to determine whether a file ID reference exists for a file and create one if it doesn’t, use PBCreateFileIDRefSync , which will either create a file ID or return fidExists.

If the object is a directory, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, a pointer to the directory’s name. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the directory attributes. See File Attribute Constants for the meaning of the bits in this field.The bits in this field for directories are read-only. You cannot alter directory attributes by setting these bits using the functions PBSetCatInfoSync or PBSetCatInfoAsync. Instead, you can call the PBHSetFLockSync and PBHRstFLockSync functions to lock and unlock a directory, and the PBShareSync and PBUnshareSync functions to enable and disable file sharing on local directories. 
ioACUser 

On output, the directory access rights. The PBGetCatInfoSync function returns the information in this field only for shared volumes. As a result, you should set this field to 0 before calling PBGetCatInfoSync. PBGetCatInfoSync does not return the blank access privileges bit in this field; to determine whether a directory has blank access privileges, use the PBHGetDirAccessSync function. See User Privileges Constants for a description of the constants that may be returned here. 
ioDrUsrWds 

On output, information used by the Finder. 
ioDrDirID 

On input, if you wish to obtain information about a specific directory, that directory’s ID. Otherwise, if the object returned is a directory, this field contains the directory ID on output. 
ioDrNmFls 

On output, the number of files in the directory. 
ioDrCrDat 

On output, the date and time of the directory’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioDrCrDat field to 0.
ioDrMdDat 

On output, the date and time of the directory’s last modification. 
ioDrBkDat 

On output, the date and time of the directory’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioDrBkDat field to 0.
ioDrFndrInfo 

On output, additional information used by the Finder. 
ioDrParID 

On output, the directory ID of the directory’s parent directory. 

To get information on a file or directory with named forks, or on a file larger than 2GB, use one of the FSGetCatalogInfo , PBGetCatalogInfoSync , or PBGetCatalogInfoAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock
);

/*FSpOpenDF

Opens the data fork of a file. (Deprecated in Mac OS X v10.4. Use FSOpenFork instead.)

OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);
Parameters
spec

A pointer to an FSSpec structure specifying the file whose data fork is to be opened. See FSSpec for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the file’s data fork. In most cases, you can simply set the permission parameter to fsCurPerm. Some applications request fsRdWrPerm, to ensure that they can both read from and write to a file. For a description of the types of access that you can request, see File Access Permission Constants. 
refNum

On return, a pointer to the file reference number for accessing the open data fork. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpOpenDF is not available, you can use the function HOpenDF instead.

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. If you try to open a fork larger than 2GB with the FSpOpenDF function, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);

/*GetEOF

Determines the current logical size of an open file. (Deprecated in Mac OS X v10.4. Use FSGetForkSize instead.)

OSErr GetEOF (
   short refNum,
   long * logEOF
);
Parameters
refNum

The file reference number of an open file. 
logEOF

On return, a pointer to the logical size (the logical end-of-file) of the given file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To determine the size of a named fork other than the data or resource forks, or of a fork larger than 2 GB, use the FSGetForkSize function, or one of the corresponding parameter block functions, PBGetForkSizeSync and PBGetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetEOF (
   short refNum,
   long * logEOF
);

/*FSRead

Reads any number of bytes from an open file. (Deprecated in Mac OS X v10.4. Use FSReadFork instead.)

OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr
);
Parameters
refNum

The file reference number of the open file from which to read. 
count

On input, a pointer to the number of bytes to read; on output, a pointer to the number of bytes actually read. 
buffPtr

A pointer to the data buffer into which the data will be read. This buffer is allocated by your application and must be at least as large as the count parameter. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read operation begins at the current mark, you might want to set the mark first by calling the SetFPos function. If you try to read past the logical end-of-file, FSRead reads in all the data up to the end-of-file, moves the mark to the end-of-file, and returns eofErr as its function result. Otherwise, FSRead moves the file mark to the byte following the last byte read and returns noErr.

The low-level functions PBReadSync and PBReadAsync let you set the mark without having to call SetFPos. Furthermore, if you want to read data in newline mode, you must use PBReadSync or PBReadAsync instead of FSRead. For a description of the PBReadSync and PBReadAsync functions, see the Device Manager Reference .

If you wish to read from named forks other than the data or resource forks, or from files larger than 2GB, you must use the FSReadFork function, or one of its corresponding parameter block calls, PBReadForkSync and PBReadForkAsync. If you attempt to use FSRead to read from a file larger than 2GB, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr
);

/*FSClose

Closes an open file. (Deprecated in Mac OS X v10.4. Use FSCloseFork instead.)

OSErr FSClose (
   short refNum
);
Parameters
refNum

The file reference number of the open file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSClose function removes the access path for the specified file and writes the contents of the volume buffer to the volume.

The FSClose function calls the PBFlushFileSync function internally to write the file’s bytes onto the volume. To ensure that the file’s catalog entry is updated, you should call FlushVol after you call FSClose. 
Special Considerations

Make sure that you do not call FSClose with a file reference number of a file that has already been closed. Attempting to close the same file twice may result in loss of data on a volume.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSClose (
   short refNum
);

/*FSRefMakePath

Converts an FSRef into a path.

OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize
);
Parameters
ref

The FSRef to convert into a path. 
path

On return, a pointer to the path. This path can be used by POSIX-style calls. 
pathSize

The size of the path. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize
);

/*FSGetDataForkName

Returns a Unicode string constant for the name of the data fork.

OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName
);
Parameters
dataForkName

On input, a pointer to an HFSUniStr255 structure. On return, this structure contains the Unicode name of the data fork. Currently, this is the empty string. See HFSUniStr255 for a description of the HFSUniStr255 data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

There is no parameter block-based form of this call since it is not dispatched to individual volume formats, and does not require any I/O. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName
);

/*FSGetForkSize

Returns the size of an open fork. 

OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize
);
Parameters
forkRefNum

The reference number of the open fork. You can obtain this fork reference number with the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
forkSize

On return, a pointer to the logical size (the logical end-of-file) of the fork, in bytes. The size returned is the total number of bytes that can be read from the fork; the amount of space actually allocated on the volume (the physical size) will probably be larger. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

To determine whether the FSGetForkSize function is present, call the Gestalt function. If FSGetForkSize is present, but is not directly supported by a volume, the File Manager will call PBGetEOFSync; however, you will not be able to determine the size of a fork other than the data or resource fork, or of a fork larger than 2 GB. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize
);

/*FSEjectVolumeSync

Ejects a volume.

OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter
);
Parameters
vRefNum

The volume reference number of the volume to eject. 
flags

Options for future use.
dissenter

On return, a pointer to the pid of the process which denied the unmount if the eject is denied.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function ejects the volume specified by the vRefNum parameter. If the volume cannot be ejected the pid of the process which denied the unmount will be returned in the dissenter parameter. This function returns after the eject is complete. Ejecting a volume will result in the unmounting of other volumes on the same device.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter
);

/*PBMakeFSRefSync

Creates an FSRef for a file or directory, given an FSSpec.

OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock
);
Parameters
paramBlock

A pointer to a file system reference parameter block. See FSRefParam for a description of the FSRefParam data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

For the parameter block based calls, the fields of the source FSSpec are passed as separate parameters (in the ioNamePtr, ioVRefNum, and ioDirID fields). This allows the call to be dispatched to external file systems the same way as other FSp calls are. 

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file or directory for which you wish to create an FSRef. 
ioVRefNum 

On input, a volume specification for the volume containing the file or directory. This can be a volume reference number, a drive number, or 0 for the default volume. 
ioDirID 

On input, the directory ID of the file or directory’s parent directory. 
newRef 

On input, a pointer to an FSRef structure. On output, this FSRef refers to the specified file or directory. 

To obtain an FSSpec from an FSRef, use the PBGetCatalogInfoSync function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock
);
/*FSCreateFileUnicode

Creates a new file with a Unicode name.

OSErr FSCreateFileUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec
);
Parameters
parentRef

A pointer to an FSRef for the directory where the file is to be created. See FSRef for a description of the FSRef data type.
nameLength

The length of the file's name. 
name

A pointer to the Unicode name for the new file. 
whichInfo

A bitmap specifying which catalog information fields to set for the new file. You specify the values for these fields in the catalogInfo parameter. If you do not wish to set catalog information for the new file, pass the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits defined for this parameter.
catalogInfo

A pointer to the FSCatalogInfo structure which specifies the values of the new file’s catalog information. Specify which fields to set in the whichInfo parameter.

This parameter is optional; specify NULL if you do not wish to set catalog information for the new file.

newRef

On return, a pointer to the FSRef for the new file. If you do not want the FSRef returned, specify NULL.
newSpec

On return, a pointer to the FSSpec for the new file. If you do not want the FSSpec returned, specify NULL. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You may optionally set catalog information for the new file using the whichInfo and catalogInfo parameters; this is equivalent to calling FSSetCatalogInfo , or one of the corresponding parameter block functions, PBSetCatalogInfoSync and PBSetCatalogInfoAsync , after creating the file. 

If possible, you should set the textEncodingHint field of the catalog information structure specified in the catalogInfo parameter. This will be used by the volume format when converting the Unicode filename to other encodings. 
Special Considerations

If the FSCreateFileUnicode function is present, but is not implemented by a particular volume, the File Manager will emulate this function by making the appropriate call to PBHCreateSync. However, if the function is not directly supported by the volume, you will not be able to use the long Unicode filenames, or other features added with HFS Plus. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FSCreateFileUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec
);


/*FSSetCatalogInfo

Sets catalog information about a file or directory.

OSErr FSSetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo
);
Parameters
ref

A pointer to an FSRef specifying the file or directory whose information is to be changed. See FSRef for a description of the FSRef data type.
whichInfo

A bitmap specifying which catalog information fields to set. Only some of the catalog information fields may be set. These fields are given by the constant kFSCatInfoSettableInfo; no other bits may be set in the whichInfo parameter. See Catalog Information Bitmap Constants for a description of the bits in this parameter.

To set the user ID (UID) and group ID (GID) on Mac OS X, specify the kFSCatInfoSetOwnership flag in this parameter. The File Manager attempts to set the user and group ID to the values specified in the permissions field of the catalog information structure. If FSSetCatalogInfo cannot set the user and group IDs, it returns an error.
catalogInfo

A pointer to the structure containing the new catalog information. Only some of the catalog information fields may be set. The fields which may be set are:
createDate
contentModDate
attributeModDate
accessDate
backupDate
permissions
finderInfo
extFinderInfo
textEncodingHint

On Mac OS 9, you may also set the kFSNodeLockedBit bit in the nodeFlags field if you are changing catalog information for a file.

Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSSetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo
);

/*FSDeleteObject

Deletes a file or an empty directory. 

OSErr FSDeleteObject (
   const FSRef * ref
);
Parameters
ref

A pointer to an FSRef specifying the file or directory to be deleted. If the object to be deleted is a directory, it must be empty (it must contain no files or folders). See FSRef for a description of the FSRef data type.
Return Value

A result code. See “File Manager Result Codes”. On Mac OS 8 and 9, if you attempt to delete a folder for which there is an open catalog iterator, FSDeleteObject returns the error fBsyErr. On Mac OS X, a similar attempt to delete a folder while another process has an open iterator will succeed and FSDeleteObject returns noErr. Iteration, however, will continue to work until the iterator is closed.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSDeleteObject (
   const FSRef * ref
);

/*FSDisposeVolumeOperation

Releases the memory associated with a volume operation. 

OSStatus FSDisposeVolumeOperation (
   FSVolumeOperation volumeOp
);
Parameters
volumeOp

The FSVolumeOperation to release. 
Return Value

A result code. See “File Manager Result Codes”. This function will return paramErr if the FSVolumeOperation is in use.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSDisposeVolumeOperation (
   FSVolumeOperation volumeOp
);

/*FSMountServerVolumeAsync

Mounts a server volume asynchronously.

OSStatus FSMountServerVolumeAsync (
   CFURLRef url,
   CFURLRef mountDir,
   CFStringRef user,
   CFStringRef password,
   FSVolumeOperation volumeOp,
   void * clientData,
   OptionBits flags,
   FSVolumeMountUPP callback,
   CFRunLoopRef runloop,
   CFStringRef runloopMode
);
Parameters
url

The server to mount. 
mountDir

The directory to mount the server to. If this parameter is NULL, the default location is used. 
user

A string to pass as the user for authentication. This parameter can be NULL. 
password

A string to pass as the password for authenticated log in. This parameter can be NULL. 
volumeOp

An FSVolumeOperation returned by the FSCreateVolumeOperation function. 
clientData

A pointer to client data associated with the operation. This parameter can be NULL.
flags

Options for future use.
callback

A function to call when the mount is complete. This parameter can be NULL. 
runloop

The runloop to run on. 
runloopMode

The mode for the runloop. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function will start the process to mount the server specified by the url parameter at the location specified by the mountDir parameter. If mountDir is NULL, the default location is used. An optional user and password can be passed in for authentication. If no user or password is provided then the underlying file system will handle authentication if required. If a callback function is provided, that function will be called when the mount operation is complete. Once this function returns noErr the status of the operation can be found using the FSGetAsyncMountStatus function.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/


OSStatus FSMountServerVolumeAsync (
    CFURLRef url,
  CFURLRef mountDir,
   CFStringRef user,
   CFStringRef password,
   FSVolumeOperation volumeOp,
   void * clientData,
   OptionBits flags,
   FSVolumeMountUPP callback,
   CFRunLoopRef runloop,
   CFStringRef runloopMode
);

/*NewFSVolumeMountUPP


FSVolumeMountUPP NewFSVolumeMountUPP (
   FSVolumeMountProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the FSVolumeMountUPP data type.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
FSVolumeMountUPP NewFSVolumeMountUPP (
   FSVolumeMountProcPtr userRoutine
);

/*FSCreateVolumeOperation

Returns an FSVolumeOperation which can be used for an asynchronous volume operation. 

OSStatus FSCreateVolumeOperation (
   FSVolumeOperation * volumeOp
);
Parameters
volumeOp

The new FSVolumeOperation. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

When the operation is completed the FSVolumeOperation should be disposed of to free the memory associated with the operation using FSDisposeVolumeOperation.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSCreateVolumeOperation (
   FSVolumeOperation * volumeOp
);

/*FSpMakeFSRef

Creates an FSRef for a file or directory, given an FSSpec.

OSErr FSpMakeFSRef (
   const FSSpec * source,
   FSRef * newRef
);
Parameters
source

A pointer to the FSSpec for the file or directory. This parameter must point to a valid FSSpec for an existing file or directory; if it does not, the call will return fnfErr. See FSSpec for a description of the FSSpec data type.
newRef

On input, a pointer to an FSRef structure. On return, a pointer to the FSRef for the file or directory specified in the FSSpec pointed to in the source parameter. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To obtain an FSSpec from an FSRef, use the FSGetCatalogInfo function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSpMakeFSRef (
   const FSSpec * source,
   FSRef * newRef
);

/*FSCompareFSRefs

Determines whether two FSRef structures refer to the same file or directory.

OSErr FSCompareFSRefs (
   const FSRef * ref1,
   const FSRef * ref2
);
Parameters
ref1

A pointer to the first FSRef to compare. For a description of the FSRef data type, see FSRef.
ref2

A pointer to the second FSRef to compare.
Return Value

A result code. See “File Manager Result Codes”. If the two FSRef structures refer to the same file or directory, then noErr is returned. If they refer to objects on different volumes, then diffVolErr is returned. If they refer to different files or directories on the same volume, then errFSRefsDifferent is returned. This function may return other errors, including nsvErr, fnfErr, dirNFErr, and volOffLinErr.
Discussion

You must use FSCompareFSRefs, or one of the corresponding parameter block functions, PBCompareFSRefsSync and PBCompareFSRefsAsync , to compare FSRef structures. It is not possible to compare the FSRef structures directly since some bytes may be uninitialized, case-insensitive text, or contain hint information.

Some volume formats may be able to tell that two FSRef structures would refer to two different files or directories, without having to actually find those objects. In this case, the volume format may return errFSRefsDifferent even if one or both objects no longer exist. Similarly, if the FSRef structures are for objects on different volumes, the File Manager will return diffVolErr even if one or both volumes are no longer mounted. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FSCompareFSRefs (
   const FSRef * ref1,
   const FSRef * ref2
);

/*FSCreateDirectoryUnicode

Creates a new directory (folder) with a Unicode name. 

OSErr FSCreateDirectoryUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec,
   UInt32 * newDirID
);
Parameters
parentRef

A pointer to an FSRef specifying the parent directory where the new directory is to be created. See FSRef for a description of the FSRef data type.
nameLength

The length of the new directory's Unicode name. 
name

A pointer to the Unicode name of the new directory. 
whichInfo

A bitmap specifying which catalog information fields to set for the new directory. Specify the values for these fields in the catalogInfo parameter. 

If you do not wish to set catalog information for the new directory, specify the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits defined for this parameter.
catalogInfo

A pointer to the FSCatalogInfo structure which specifies the values for the catalog information fields for the new directory. Specify which fields to set in the whichInfo parameter.

This parameter is optional; specify NULL if you do not wish to set catalog information for the new directory.

See FSCatalogInfo for a description of the FSCatalogInfo data type.
newRef

On return, a pointer to the FSRef for the new directory. This parameter is optional; specify NULL if you do not want the FSRef returned.
newSpec

On return, a pointer to the FSSpec for the new directory. This parameter is optional; specify NULL if you do not want the FSSpec returned. See FSSpec for a description of the FSSpec data type.
newDirID

On return, a pointer to the directory ID of the directory. This parameter is optional; specify NULL if you do not want the directory ID returned. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You may optionally set catalog information for the new directory using the whichInfo and catalogInfo parameters; this is equivalent to calling FSSetCatalogInfo , or one of the corresponding parameter block functions, PBSetCatalogInfoSync and PBSetCatalogInfoAsync , after creating the directory. 

If possible, you should set the textEncodingHint field of the catalog information structure specified in the catalogInfo parameter. This will be used by the volume format when converting the Unicode filename to other encodings. 
Special Considerations

If the FSCreateDirectoryUnicode function is present, but is not implemented by a particular volume, the File Manager will emulate this function by making the appropriate call to PBDirCreateSync. However, if the function is not directly supported by the volume, you will not be able to use the long Unicode directory names, or other features added with HFS Plus. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCreateDirectoryUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec,
   UInt32 * newDirID
);

/*FSWrite

Writes any number of bytes to an open file. (Deprecated in Mac OS X v10.4. Use FSWriteFork instead.)

OSErr FSWrite (
   short refNum,
   long * count,
   const void * buffPtr
);
Parameters
refNum

The file reference number of the open file to which to write. 
count

On input, a pointer to the number of bytes to write to the file. In Carbon on Mac OS 9 and X, passing 0 in this parameter will return a paramErr error.

On output, a pointer to the number of bytes actually written.

buffPtr

A pointer to the data buffer containing the data to write. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSWrite function takes the specified number of bytes from the data buffer and attempts to write them to the file. Because the write operation begins at the current mark, you might want to set the mark first by calling the SetFPos function.

If the write operation completes successfully, FSWrite moves the file mark to the byte following the last byte written and returns noErr. If you try to write past the logical end-of-file, FSWrite moves the logical end-of-file. If you try to write past the physical end-of-file, FSWrite adds one or more clumps to the file and moves the physical end-of-file accordingly.

The low-level functions PBWriteSync and PBWriteAsync let you set the mark without having to call SetFPos. For a description of the PBWriteSync and PBWriteAsync functions, see the Device Manager Reference .

If you wish to write to named forks other than the data or resource forks, or grow files larger than 2GB, you must use the FSWriteFork function, or one of its corresponding parameter block calls, PBWriteForkSync and PBWriteForkAsync. If you attempt to use FSWrite to write to a file larger than 2GB, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/


OSErr FSWrite (
   short refNum,
   long * count,
   const void * buffPtr
);

/*FSpCreate

Creates a new file. (Deprecated in Mac OS X v10.4. Use FSCreateFileUnicode instead.)

OSErr FSpCreate (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
);
Parameters
spec

A pointer to an FSSpec structure specifying the file to be created. See FSSpec for a description of the FSSpec data type.
creator

The creator of the new file. See the documentation for the Finder Interface for more information on file creators. 
fileType

The file type of the new file. See the documentation for the Finder Interface for more information on file types.
scriptTag

The code of the script system in which the filename is to be displayed. If you have established the name and location of the new file using either the NavAskSaveChanges or NavCustomAskSaveChanges function, specify the script code returned in the reply structure. Otherwise, specify the system script by setting the scriptTag parameter to the value smSystemScript.

For more information about the functions NavAskSaveChanges and NavCustomAskSaveChanges, see Programming With Navigation Services. See the Script Manager Reference for a description of the smSystemScript constant.

Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpCreate function creates a new file (both data and resource forks) with the specified type, creator, and script code. The new file is unlocked and empty. The date and time of creation and last modification are set to the current date and time.

Files created using FSpCreate are not automatically opened. If you want to write data to the new file, you must first open the file using one of the file access functions, FSpOpenDF , HOpenDF , PBHOpenDFSync or PBHOpenDFAsync.

The resource fork of the new file exists but is empty. You’ll need to call one of the Resource Manager functions HCreateResFile or FSpCreateResFile to create a resource map in the file before you can open it by calling one of the Resource Manager functions HOpenResFile or FSpOpenResFile).

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpCreate is not available, you can use the function HCreate instead. To create a file with a Unicode filename, use the function FSCreateFileUnicode , or one of the corresponding parameter block calls, PBCreateFileUnicodeSync and PBCreateFileUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpCreate (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
);

/*FSpDelete

Deletes a file or directory. (Deprecated in Mac OS X v10.4. Use FSDeleteObject instead.)

OSErr FSpDelete (
   const FSSpec * spec
);
Parameters
spec

A pointer to an FSSpec structure specifying the file or directory to delete. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”. If you attempt to delete an open file or a non-empty directory, FSpDelete returns the result code fBsyErr. FSpDelete also returns the result code fBsyErr if the directory has an open working directory associated with it.
Discussion

If the specified target is a file, both forks of the file are deleted. The file ID reference, if any, is removed. A file must be closed before you can delete it. Similarly, a directory must be empty before you can delete it. 

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpDelete is not available, you can use the function HDelete instead. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpDelete (
   const FSSpec * spec
);

/*PBSetCatInfoSync

Modifies catalog information for a file or directory. (Deprecated in Mac OS X v10.4. Use PBSetCatalogInfoSync instead.)

OSErr PBSetCatInfoSync (
   CInfoPBPtr paramBlock
);
Parameters
paramBlock

A pointer to an HFS catalog information parameter block. See CInfoPBRec for a description of the CInfoPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBSetCatInfoSync function sets information about a file or directory. When used to set information about a file, it works much as PBHSetFInfoSync does, but lets you set some additional information.

If the object is a file, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFlFndrInfo 

On input, Finder information for the file. 
ioDirID 

On input, the parent directory ID of the file. 
ioFlCrDat 

On input, the date and time of the file’s creation. 
ioFlMdDat 

On input, the date and time of the file’s last modification. 
ioFlBkDat 

On input, the date and time of the file’s last backup. 
ioFlXFndrInfo 

On input, extended Finder information. 

If the object is a directory, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDrUsrWds 

On input, information used by the Finder. 
ioDrDirID 

On input, the directory ID. 
ioDrCrDat 

On input, the date and time of the directory’s creation. 
ioDrMdDat 

On input, the date and time of the directory’s last modification. 
ioDrBkDat 

On input, the date and time of the directory’s last backup. 
ioDrFndrInfo 

On input, additional information used by the Finder. 

To modify the catalog information for a named fork other than the data and resource fork, or to modify other catalog information maintained on HFS Plus volumes that is not modifiable through PBSetCatInfoSync, use one of the functions, FSSetCatalogInfo , PBSetCatalogInfoSync , or PBSetCatalogInfoAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBSetCatInfoSync (
   CInfoPBPtr paramBlock
);

/*SetFPos

Sets the position of the file mark. (Deprecated in Mac OS X v10.4. Use FSSetForkPosition instead.)

OSErr SetFPos (
   short refNum,
   short posMode,
   long posOff
);
Parameters
refNum

The file reference number of an open file. 
posMode

A constant specifying how to position the file mark; this parameter must contain one of the values described in Position Mode Constants.
posOff

The offset from the base location specified by the posMode parameter for the new file mark position. If you specify fsFromLEOF in the posMode parameter, the value in the posOff parameter must be less than or equal to 0. If you specify fsAtMark, the value in the posOff parameter is ignored. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read and write operations performed by the functions FSRead and FSWrite begin at the current mark, you may want to call SetFPos to reposition the file mark before reading from or writing to the file.

To set the file mark position for a named fork other than the data and resource forks, or to position the file mark at a point more than 2GB into the file, use the FSSetForkPosition function, or one of the corresponding parameter block calls, PBSetForkPositionSync and PBSetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr SetFPos (
   short refNum,
   short posMode,
   long posOff
);

/*SetEOF

Sets the logical size of an open file. (Deprecated in Mac OS X v10.4. Use FSSetForkSize instead.)

OSErr SetEOF (
   short refNum,
   long logEOF
);
Parameters
refNum

The file reference number of an open file. 
logEOF

The new logical size (the logical end-of-file) of the given file. If you set the logEOF parameter to 0, all space occupied by the file on the volume is released. The file still exists, but it contains 0 bytes. Setting a file fork’s end-of-file to 0 is therefore not the same as deleting the file, which removes both file forks at once. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you attempt to set the logical end-of-file beyond the physical end-of-file, the physical end-of-file is set 1 byte beyond the end of the next free allocation block if there isn’t enough space on the volume, no change is made, and SetEOF returns dskFulErr as its function result.

To ensure that your changes to the file are written to disk, call one of the functions, FlushVol , PBFlushVolSync , or PBFlushVolAsync. To set the size of a named fork other than the data and resource forks, or to grow the size of a file beyond 2GB, you must use the FSSetForkSize function, or one of the corresponding parameter block calls, PBSetForkSizeSync and PBSetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr SetEOF (
   short refNum,
   long logEOF
);

/*GetFPos

Returns the current position of the file mark. (Deprecated in Mac OS X v10.4. Use FSGetForkPosition instead.)

OSErr GetFPos (
   short refNum,
   long * filePos
);
Parameters
refNum

The file reference number of an open file. 
filePos

On return, a pointer to the current position of the mark. The position value is zero-based; that is, the value of filePos is 0 if the file mark is positioned at the beginning of the file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read and write operations performed by the functions FSRead and FSWrite begin at the current mark, you should call GetFPos, or one of the parameter block functions, PBGetFPosSync and PBGetFPosAsync , to determine the current position of the file mark before reading from or writing to the file.

To determine the current position of a named fork, or of a fork larger than 2GB, use the FSGetForkPosition function, or one of the corresponding parameter block calls, PBGetForkPositionSync and PBGetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetFPos (
   short refNum,
   long * filePos
);

/*FSpSetFInfo

Sets the Finder information about a file. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr FSpSetFInfo (
   const FSSpec * spec,
   const FInfo * fndrInfo
);
Parameters
spec

A pointer to an FSSpec structure specifying the file for which to set the Finder information. See FSSpec for a description of the FSSpec data type.
fndrInfo

A pointer to the new Finder information. For a description of the FInfo data type, see the Finder Interface Reference.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpSetFInfo function changes the Finder information in the volume catalog entry for the specified file. FSpSetFInfo allows you to set only the original Finder information—the information in the FInfo or DInfo structures, not the information in the FXInfo or DXInfo structures. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpSetFInfo (
   const FSSpec * spec,
   const FInfo * fndrInfo
);

/*PBSetFPosAsync

Sets the position of the file mark. (Deprecated in Mac OS X v10.4. Use PBSetForkPositionAsync instead.)

OSErr PBSetFPosAsync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. 
ioRefNum 

On input, the file reference number for an open file. 
ioPosMode 

On input, a constant indicating how to position the mark; this field must contain one of the values described in Position Mode Constants. 
ioPosOffset 

On input, the offset from the base location specified by the ioPosMode field for the file mark. If you specify fsAtMark in the ioPosMode field, the mark is left wherever it’s currently positioned and the value in the ioPosOffset field is ignored. If you specify fsFromLEOF, the value in ioPosOffset must be less than or equal to 0. On output, the position at which the mark was actually set. 

The PBSetFPosAsync function sets the mark of the specified file to the position specified by the ioPosMode and ioPosOffset fields. If you try to set the mark past the logical end-of-file, PBSetFPosAsync moves the mark to the end-of-file and returns eofErr as its function result.

To set the file mark position for a named fork other than the data and resource forks, or to position the file mark at a point more than 2GB into the file, use the FSSetForkPosition function, or one of the corresponding parameter block calls, PBSetForkPositionSync and PBSetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBSetFPosAsync (
   ParmBlkPtr paramBlock
);

/*PBWriteForkAsync

Writes data to an open fork.

void PBWriteForkAsync (
   FSForkIOParam * paramBlock
);
Parameters
paramBlock

A pointer to a fork I/O parameter block. See FSForkIOParam for a description of the FSForkIOParam.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. If there is not enough space on the volume to write requestCount bytes, then dskFulErr is returned. 
forkRefNum 

On input, the reference number of the fork to which to write. You should have previously opened the fork using the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode 

On input, a constant specifying the base location within the fork for the start of the write. See Position Mode Constants for a description of the constants which you can use to specify the base location.The caller can also use this parameter to hint to the File Manager whether the data being written should or should not be cached. See Cache Constants for further description of the constants that you can use to indicate your preference for caching. 
positionOffset 

On input, the offset from the base location for the start of the write. 
requestCount 

On input, the number of bytes to write. 
buffer 

A pointer to a buffer containing the data to write. 
actualCount 

On output, the number of bytes actually written. The value in the actualCount field will be equal to the value in the requestCount field unless there was an error during the write operation. 

PBWriteForkAsync writes data starting at the position specified by the positionMode and positionOffset fields. The function attempts to write requestCount bytes from the buffer pointed to by the buffer field and sets the fork’s current position to the byte immediately after the last byte written (that is, the initial position plus actualCount).

When writing data to a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your write requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

void PBWriteForkAsync (
   FSForkIOParam * paramBlock
);

/*PBReadForkAsync

Reads data from an open fork.

void PBReadForkAsync (
   FSForkIOParam * paramBlock
);
Parameters
paramBlock

A pointer to a fork I/O parameter block. See FSForkIOParam for a description of the FSForkIOParam data type.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned. 
forkRefNum 

On input, the reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode 

On input, a constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read. 
positionOffset 

On input, the offset from the base location for the start of the read. 
requestCount 

On input, the number of bytes to read. The value that you pass in this field should be greater than zero. 
buffer 

A pointer to the buffer where the data will be returned. 
actualCount 

On output, the number of bytes actually read. The value in this field should be equal to the value in the requestCount field unless there was an error during the read operation. 

PBReadForkAsync reads data starting at the position specified by the positionMode and positionOffset fields. The function reads up to requestCount bytes into the buffer pointed to by the buffer field and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode field and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Version Notes

Note that on Mac OS 8 and 9, it is possible to call PBReadForkAsync with a value of 0 in the requestCount field; however, this behavior is not supported on Mac OS X. On OS X, PBReadForkAsync returns a paramErr error if the value in the requestCount field is 0.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

void PBReadForkAsync (
   FSForkIOParam * paramBlock);

/*NewIOCompletionUPP

Creates a new universal procedure pointer (UPP) to your completion function.

IOCompletionUPP NewIOCompletionUPP (
   IOCompletionProcPtr userRoutine
);
Parameters
userRoutine

A pointer to a completion callback function. See IOCompletionProcPtr for a description of the IOCompletionProcPtr data type.
Return Value

A universal procedure pointer to your completion function. See IOCompletionUPP for a description of the IOCompletionUPP data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
IOCompletionUPP NewIOCompletionUPP (
   IOCompletionProcPtr userRoutine
);

/*FSpGetFInfo

Obtains the Finder information for a file. (Deprecated in Mac OS X v10.4. Use FSGetCatalogInfo instead.)

OSErr FSpGetFInfo (
   const FSSpec * spec,
   FInfo * fndrInfo
);
Parameters
spec

A pointer to an FSSpec structure specifying the file. See FSSpec for a description of the FSSpec data type.
fndrInfo

On return, a pointer to information used by the Finder. The FSpGetFInfo function returns the Finder information from the volume catalog entry for the specified file. The function provides only the original Finder information—the information in the FInfo or DInfo structures, not the information in the FXInfo or DXInfo structures. For a description of the FInfo structure, see the Finder Interface Reference.
Return Value

A result code. If the specified object is a folder, this function returns fnfErr. For other possible return values, see “File Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpGetFInfo (
   const FSSpec * spec,
   FInfo * fndrInfo
);

/*PBHGetFInfoSync

Obtains information about a file. (Deprecated in Mac OS X v10.4. Use PBGetCatalogInfoSync instead.)

OSErr PBHGetFInfoSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are: 
ioNamePtr 

On input, a pointer to a pathname. If the value of the ioFDirIndex field is negative or 0, PBHGetFInfoSync returns information about the file in the volume specified by the reference number in the ioVRefNum field and having the name given here.On output, a pointer to the name of the file, if the file is open. If you do not wish the name returned, pass NULL here. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the file, or 0 for the default volume. 
ioFRefNum 

On output, the reference number of the first access path found, if the file is open and if the ioFDirIndex field is negative or 0; if the ioFDirIndex field is positive... 
ioFDirIndex 

On input, a directory index. If this value is positive, the function returns information about the file having the directory index specified here, on the volume specified in the ioVRefNum field and in the directory specified in the ioDirID field.If this value is negative or 0, the function returns information about the file on the specified volume, having the name pointed to in the ioNamePtr field. 
ioFlAttrib 

On output, the file attributes. See File Attribute Constants for a description of the file attributes. 
ioFlFndrInfo 

On output, Finder information about the file. For a description of the FInfo data type, see the Finder Interface Reference . 
ioDirID 

On input, the parent directory ID of the file. On output, the file’s file ID. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 
ioFlStBlk 

On ouput, the first allocation block of the data fork. 
ioFlLgLen 

On output, the logical size (the logical end-of-file) of the file’s data fork, in bytes. 
ioFlPyLen 

On output, the physical size (the physical end-of-file) of the file’s data fork, in bytes. 
ioFlRStBlk 

On output, the first allocation block of the resource fork. 
ioFlRLgLen 

On output, the logical size of the resource fork, in bytes. 
ioFlRPyLen 

On output, the physical size of the resource fork, in bytes. 
ioFlCrDat 

On output, the date and time of the file’s creation. 
ioFlMdDat 

On output, the date and time of the file’s last modification. 

You should call PBHGetFInfoSync just before PBHSetFInfoSync , so that the current information is present in the parameter block. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHGetFInfoSync (
   HParmBlkPtr paramBlock
);

/*PBCreateFileIDRefSync

Establishes a file ID reference for a file.

OSErr PBCreateFileIDRefSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the FIDParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.PBCreateFileIDRefSync returns the result code fidExists if a file ID reference already exists for the file.
Discussion

Most applications do not need to use this function. In general, you should track files using alias records, as described in the Alias Manager documentation. The Alias Manager uses file IDs internally as part of its search algorithms for finding the target of an alias record.

Given a volume reference number, filename, and parent directory ID, the PBCreateFileIDRefSync function creates a structure to hold the name and parent directory ID of the specified file. The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the file’s name. 
ioVRefNum 

On input, a volume reference number for the volume containing the file. 
ioSrcDirID 

On input, the file’s parent directory ID. 
ioFileID 

On output, a file ID. If a file ID reference already exists for the file, PBCreateFileIDRefSync supplies the file ID but returns the result code fidExists. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBCreateFileIDRefSync (
   HParmBlkPtr paramBlock
);

/*FSpRename

Renames a file or directory. (Deprecated in Mac OS X v10.4. Use FSRenameUnicode instead.)

OSErr FSpRename (
   const FSSpec * spec,
   ConstStr255Param newName
);
Parameters
spec

A pointer to an FSSpec structure specifying the file or directory to rename. See FSSpec for a description of the FSSpec data type.
newName

The new name of the file or directory. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If a file ID reference for the specified file exists, it remains with the renamed file.

If you want to change the name of a new copy of an existing file, you should use the FSpExchangeFiles function instead. To rename a file or directory using a long Unicode name, use the FSRenameUnicode function or one of the corresponding parameter block calls, PBRenameUnicodeSync and PBRenameUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpRename (
   const FSSpec * spec,
   ConstStr255Param newName
);

/*HGetVol

Determines the current default volume and default directory. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr HGetVol (
   StringPtr volName,
   short * vRefNum,
   long * dirID
);
Parameters
volName

On return, a pointer to the name of the default volume. If you do not want the name of the default volume returned, set this parameter to NULL. 
vRefNum

On return, a pointer to the volume reference number of the default volume. 
dirID

On return, a pointer to the directory ID of the default directory. 
Return Value

A result code. See “File Manager Result Codes”.
Version Notes

When CarbonLib is not present, the HGetVol function returns a working directory reference number in the vRefNum parameter if the previous call to HSetVol (or one of the corresponding parameter block calls) passed in a working directory reference number.
Carbon Porting Notes

Carbon applications should use HGetVol and HSetVol to get and set the default directory. the functions GetVol and SetVol, as well as working directories, are no longer supported. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr HGetVol (
   StringPtr volName,
   short * vRefNum,
   long * dirID
);

/*FSpOpenRF

Opens the resource fork of a file. (Deprecated in Mac OS X v10.4. Use FSOpenFork instead.)

OSErr FSpOpenRF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);
Parameters
spec

A pointer to an FSSpec structure specifying the file whose resource fork is to be opened. See FSSpec for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the file’s resource fork. For a description of the types of access you can request, see File Access Permission Constants. 
refNum

On return, a pointer to the file reference number for accessing the open resource fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSpOpenRF will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpOpenRF is not available, you can use the function HOpenRF instead. 

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync or PBOpenForkAsync. If you try to open a fork larger than 2GB with the FSpOpenRF function, you will receive an error message. 
Special Considerations

Generally, your application should use Resource Manager functions rather than File Manager functions to access a file’s resource fork. The FSpOpenRF function does not read the resource map into memory and is generally useful only for applications (such as utilities that copy files) that need block-level access to a resource fork. 

You should not use the resource fork of a file to hold non-resource data. Many parts of the system software assume that a resource fork always contains resource data.

Because there is no support for locking and unlocking file ranges on local disks with Carbon on Mac OS X, regardless of whether File Sharing is enabled, you cannot open more than one path to a resource fork with read/ write permission. If you try to open a more than one path to a file's resource fork with fsRdWrShPerm permission, only the first attempt will succeed. Subsequent attempts will return an invalid reference number and the ResError function will return the error opWrErr.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpOpenRF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);

#ifdef __cplusplus
}
#endif

#endif