//inc
#ifndef FINDER_H
#define FINDER_H



#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

/*kCustomIconResource


enum {
   kCustomIconResource = -16455
};*/

enum {
   kCustomIconResource = -16455
};


/*Finder Flags

Specify flags used by the Finder.

enum {
   kIsOnDesk = 0x0001,
   kColor = 0x000E,
   kIsShared = 0x0040,
   kHasNoINITs = 0x0080,
   kHasBeenInited = 0x0100,
   kHasCustomIcon = 0x0400,
   kIsStationery = 0x0800,
   kNameLocked = 0x1000,
   kHasBundle = 0x2000,
   kIsInvisible = 0x4000,
   kIsAlias = 0x8000
};
Constants
kIsOnDesk

Unused and reserved in System 7; set to 0. 

Available in Mac OS X v10.0 and later.
kColor

Three bits of color coding. 

Available in Mac OS X v10.0 and later.
kIsShared

The file is an application that can be executed by multiple users simultaneously. Defined only for applications; otherwise, set to 0. 

Available in Mac OS X v10.0 and later.
kHasNoINITs

The file contains no 'INIT' resources; set to 0. Reserved for directories; set to 0. 

Available in Mac OS X v10.0 and later.
kHasBeenInited

The Finder has recorded information from the file's bundle resource into the desktop database and given the file or folder a position on the desktop. 

Available in Mac OS X v10.0 and later.
kHasCustomIcon

The file or directory contains a customized icon. 

Available in Mac OS X v10.0 and later.
kIsStationery

For a file, this bit indicates that the file is a stationery pad. For directories, this bit is reserved--in which case, set to 0. 

Available in Mac OS X v10.0 and later.
kNameLocked

The file or directory can't be renamed from the Finder, and the icon cannot be changed. 

Available in Mac OS X v10.0 and later.
kHasBundle

For a file, this bit indicates that the file contains a bundle resource. For directories, this bit is reserved--in which case, set to 0. 

Available in Mac OS X v10.0 and later.
kIsInvisible

The file or directory is invisible from the Finder and from the Navigation Services dialogs. 

Available in Mac OS X v10.0 and later.
kIsAlias

For a file, this bit indicates that the file is an alias file. For directories, this bit is reserved--in which case, set to 0. 

Available in Mac OS X v10.0 and later.*/
enum {
   kIsOnDesk = 0x0001,
   kColor = 0x000E,
   kIsShared = 0x0040,
   kHasNoINITs = 0x0080,
   kHasBeenInited = 0x0100,
   kHasCustomIcon = 0x0400,
   kIsStationery = 0x0800,
   kNameLocked = 0x1000,
   kHasBundle = 0x2000,
   kIsInvisible = 0x4000,
   kIsAlias = 0x8000
};


/*DXInfo

Defines an extended directory information structure.

struct DXInfo {
   Point frScroll;
   SInt32 frOpenChain;
   SInt8 frScript;
   SInt8 frXFlags;
   SInt16 frComment;
   SInt32 frPutAway;
};
typedef struct DXInfo DXInfo;
Fields
frScroll

Scroll position within the Finder window. The Finder does not necessarily save this position immediately upon user action. 
frOpenChain

Chain of directory IDs for open folders. The Finder numbers directory IDs. The Finder does not necessarily save this information immediately upon user action. 
frScript

Extended flags. If the high-bit is set, the script system for displaying the folder's name. Ordinarily, the Finder (and the Standard File Package) displays the names of all desktop objects in the current system script, which depends on the region-specific configuration of the system. The high bit of the byte in the fdScript field is set by default to 0, which causes the Finder to display the folder's name in the current system script. If the high bit is set to 1, the Finder (and the Standard File Package) displays the filename and directory name in the script whose code is recorded in the remaining 7 bits. However, as of system software version 7.1, the Window Manager and Dialog Manager do not support multiple simultaneous scripts, so the system script is always used for displaying filenames and directory names in dialog boxes, window titles, and other user interface elements used by the Finder. Therefore, until the system software's script capability is fully implemented, you should treat this field as reserved. 
frXFlags

Extended flags. See “Extended Finder Flags”.
frComment

Reserved (set to 0). If the high-bit is clear, an ID number for the comment that is displayed in the information window when the user selects a folder and chooses the Get Info command from the File menu. The numbers that identify comments are assigned by the Finder. 
frPutAway

If the user moves the folder onto the desktop, the directory ID of the folder from which the user moves it. 
Availability
Available in Mac OS X v10.0 and later.*/
struct DXInfo {
   Point frScroll;
   SInt32 frOpenChain;
   SInt8 frScript;
   SInt8 frXFlags;
   SInt16 frComment;
   SInt32 frPutAway;
};
typedef struct DXInfo DXInfo;

/*DInfo

Defines a directory information structure.

struct DInfo {
   Rect frRect;
   UInt16 frFlags;
   Point frLocation;
   SInt16 frView;
};
typedef struct DInfo DInfo;
Fields
frRect

The rectangle for the window that the Finder displays when the user opens the folder. 
frFlags

Reserved. 
frLocation

Location of the folder in the parent window. 
frView

The manner in which folders are displayed; this is set by the user with commands from the View menu of the Finder. 
Discussion

The Finder manipulates the fields in the directory information record. Your application shouldn't have to check or set any of these fields directly 
Availability
Available in Mac OS X v10.0 and later.*/
struct DInfo {
   Rect frRect;
   UInt16 frFlags;
   Point frLocation;
   SInt16 frView;
};
typedef struct DInfo DInfo;

/*FXInfo

Defines an extended file information structure.

struct FXInfo {
   SInt16 fdIconID;
   SInt16 fdReserved[3];
   SInt8 fdScript;
   SInt8 fdXFlags;
   SInt16 fdComment;
   SInt32 fdPutAway;
};
typedef struct FXInfo FXInfo;
Fields
fdIconID

An ID number for the file's icon; the numbers that identify icons are assigned by the Finder. 
fdReserved

Reserved. 
fdScript

Extended flags. Script code if high-bit is set. 
fdXFlags

Extended flags. 
fdComment

Reserved (set to 0). If the high-bit is clear, an ID number for the comment that is displayed in the information window when the user selects a file and chooses the Get Info command from the File menu. The numbers that identify comments are assigned by the Finder. 
fdPutAway

If the user moves the file onto the desktop, the directory ID of the folder from which the user moves the file. 
Discussion

The Finder manipulates the fields in the extended file information records ; your application shouldn't have to check or set any of these fields directly. 
Availability
Available in Mac OS X v10.0 and later.*/

struct FXInfo {
   SInt16 fdIconID;
   SInt16 fdReserved[3];
   SInt8 fdScript;
   SInt8 fdXFlags;
   SInt16 fdComment;
   SInt32 fdPutAway;
};
typedef struct FXInfo FXInfo;


/*FInfo

Defines a file information structure.

struct FInfo {
   OSType fdType;
   OSType fdCreator;
   UInt16 fdFlags;
   Point fdLocation;
   SInt16 fdFldr;
};
typedef struct FInfo FInfo;
Fields
fdType

File type.
fdCreator

The signature of the application that created the file.
fdFlags

Finder flags. See “Finder Flags”.
fdLocation

The location--specified in coordinates local to the window--of the file's icon within its window. 
fdFldr

The window in which the file's icon appears; this information is meaningful only to the Finder. 
Discussion

You typically set a file's type and creator when you create the file. The Finder manipulates the other fields in the file information record, which is a data structure of type FInfo. After you have created a file, you can use the File Manager function FSpGetFInfo to return the file information record, then change the fdType and fdCreator fields by using the File Manager function FSpSetFInfo 
Availability
Available in Mac OS X v10.0 and later.*/
struct FInfo {
   OSType fdType;
   OSType fdCreator;
   UInt16 fdFlags;
   Point fdLocation;
   SInt16 fdFldr;
};
typedef struct FInfo FInfo;


/*FolderInfo

Defines a directory information structure. The FolderInfo structure is preferred over the DInfo structure.

struct FolderInfo {
   Rect windowBounds;
   UInt16 finderFlags;
   Point location;
   UInt16 reservedField;
};
typedef struct FolderInfo FolderInfo;
Fields
windowBounds

The rectangle for the window that the Finder displays when the user opens the folder. 
finderFlags

Finder flags. See Finder Flags.
location

Location of the folder in the parent window. 
reservedField

Reserved. Set to 0.
Availability
Available in Mac OS X v10.0 and later.
Folders.h*/
struct FolderInfo {
   Rect windowBounds;
   UInt16 finderFlags;
   Point location;
   UInt16 reservedField;
};
typedef struct FolderInfo FolderInfo;


/*FileInfo

Defines a file information structure. The FileInfo structure is preferred over the FInfo structure.

struct FileInfo {
   OSType fileType;
   OSType fileCreator;
   UInt16 finderFlags;
   Point location;
   UInt16 reservedField;
};
typedef struct FileInfo FileInfo;
Fields
fileType

File type.
fileCreator

The signature of the application that created the file.
finderFlags

Finder flags. See “Finder Flags”.
location

The location--specified in coordinates local to the window--of the file's icon within its window. 
reservedField

The window in which the file's icon appears; this information is meaningful only to the Finder. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FileInfo {
   OSType fileType;
   OSType fileCreator;
   UInt16 finderFlags;
   Point location;
   UInt16 reservedField;
};
typedef struct FileInfo FileInfo;



#endif