#ifndef  OSUTILS_H
#define OSUTILS_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef MACMEMORY_H
#include <CarbonCore/MacMemory.h>
#endif

#ifndef PATCHES_H
#include <CarbonCore/Patches.h>
#endif


#ifndef DATETIMEUTILS_H
#include <CarbonCore/DateTimeUtils.h>
#endif

#ifndef CFSTRING_H
#include <CoreFoundation/CFString.h>
#endif

#include <HYS/CarbonCore/OSUtils.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*SysEnvRec

Contains information about the system environment.

struct SysEnvRec {
   short environsVersion;
   short machineType;
   short systemVersion;
   short processor;
   Boolean hasFPU;
   Boolean hasColorQD;
   short keyBoardType;
   short atDrvrVersNum;
   short sysVRefNum;
};
typedef struct SysEnvRec SysEnvRec;
Fields
environsVersion

The version number of the SysEnvirons function that was used to fill in the record.

When you call the SysEnvirons function, you specify a version number to ensure that you receive a system environment record that matches your expectations. If you request a more recent version of SysEnvirons than is available, SysEnvirons places its own version number in the environsVersion field and returns a function result envVersTooBig.
machineType

A code for the Macintosh model. See “Macintosh Model Codes”. Use the Gestalt function to obtain information about machine types not listed among these constants.
systemVersion

The version number of the current System file, represented as two byte-long numbers with one or more implied decimal points. The value $0410, for example, represents system software version 4.1.

If you call SysEnvirons when a system earlier than 4.1 is running, the MPW glue places $0 in this field and returns a result code of envNotPresent.
processor

A code for the microprocessor. See “Microprocessor Codes”.
hasFPU

A Boolean value that indicates whether hardware floating-point processing is available.
hasColorQD

A Boolean value that indicates whether Color QuickDraw is present. This field says nothing about the presence of a color monitor.
keyBoardType

A code for the keyboard type. See “Keyboard Constants”. Use the Gestalt function to obtain information about keyboard types not listed among these constants.

If the Apple Desktop Bus is in use, this field returns the keyboard type of the keyboard on which the last keystroke was made.
atDrvrVersNum

The version number of the AppleTalk driver (specifically, the .MPP driver) currently installed. If AppleTalk is not loaded, this field is 0.
sysVRefNum

The working-directory reference number of the folder or volume that holds the open System file.
Discussion

The SysEnvirons function fills in a system environment record, which describes some aspects of the software and hardware environment. 
Availability
Available in Mac OS X v10.0 and later.*/

struct SysEnvRec {
   short environsVersion;
   short machineType;
   short systemVersion;
   short processor;
   Boolean hasFPU;
   Boolean hasColorQD;
   short keyBoardType;
   short atDrvrVersNum;
   short sysVRefNum;
};
typedef struct SysEnvRec SysEnvRec;



/*QElem

Contains information about a queue element.

struct QElem {
   QElem * qLink;
   short qType;
   short qData[1];
};
typedef struct QElem QElem;
typedef QElem * QElemPtr;
Fields
qLink

The type of the queue element. For a description of the values which you can use in this field, see “Queue Types”. 
qType

A variable array of data. The type of data and the length depend upon the queue type, specified in the qType field.
qData
Discussion

A queue element is a single entry in a queue. Each operating-system queue created and maintained by the Macintosh Operating System consists of a queue header and a linked list of queue elements. The exact structure of an element in an operating-system queue depends on the type of the queue. The QElem data type defines the available queue elements.
Availability
Available in Mac OS X v10.0 and later.
Contains information about a queue element.*/

struct QElem {
   struct QElem * qLink;
   short qType;
   short qData[1];
};
typedef struct QElem QElem;
typedef QElem * QElemPtr;

/*QHdr

A Windows queue header structure.

struct QHdr {
   short       qFlags;
   short       pad;
   long        MutexID;
   QElemPtr    qHead;
   QElemPtr    qTail;
};
Fields
qFlags
Discussion

Undocumented
pad
Discussion

Unused.
MutexID
Discussion

Undocumented
qHead
Discussion

Undocumented
qTail
Discussion

Undocumented
Related Functions
CDSequenceSetSourceDataQueue
Dequeue
Enqueue
InitializeQHdr
TerminateQHdr 
Declared In
ImageCompression.h*/
struct QHdr {
   short       qFlags;
   short       pad;
   long        MutexID;
   QElemPtr    qHead;
   QElemPtr    qTail;
};
typedef  struct QHdr QHdr;

/*QHdrPtr

Represents a type used by the Compression and Decompression API.

typedef QHdr * QHdrPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef QHdr * QHdrPtr;



/*Dequeue

Removes a queue element directly from an operating-system queue or from a queue that you have created.

OSErr Dequeue (
   QElemPtr qElement,
   QHdrPtr qHeader
);
Parameters
qElement

A pointer to a queue element to remove from a queue. 
qHeader

A pointer to a queue header. 
Return Value

A result code. See “Memory Management Utilities Result Codes”.
Discussion

The Dequeue function attempts to find the queue element specified by the qElement parameter in the queue specified by the qHeader parameter. If Dequeue finds the element, it removes the element from the queue, adjusts the other elements in the queue accordingly, and returns noErr. Otherwise, it returns qErr, indicating that it could not find the element in the queue. The Dequeue function does not deallocate the memory occupied by the queue element.

For a description of the QElem record, see QElem; for a description of the QHdr record, see QHdr.

The Dequeue function disables interrupts as it searches through the queue for the element to be removed. The time during which interrupts are disabled depends on the length of the queue and the position of the entry in the queue. The Dequeue function can be called at interrupt time. However, the Dequeue function is ordinarily used only by system software and, whenever possible, you should manipulate an operating-system queue indirectly, by calling special-purpose removal functions. You can use the Queue Utilities functions for directly manipulating queues that you create. Use the following functions instead of Dequeue:
SlotVRemove

Removes a slot-based VBL task. This function is available with the Vertical Retrace Manager.
VRemove

Removes a system-based VBL task. This function is available with the Vertical Retrace Manager.
WaitNextEvent

Removes an Event. This function is available with the Event manager.
SIntRemove

Removes a slot interrupt task. This function is available with the Slot Manager.
NMRemove

Removes a Notification request. This function is available with the Notification Manager.
SleepQRemove

Removes a Sleep task. This function is available with the Power Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
OSErr Dequeue (
   QElemPtr qElement,
   QHdrPtr qHeader
);

/*Enqueue

Adds elements directly to an operating-system queue or a queue that you create.

void Enqueue (
   QElemPtr qElement,
   QHdrPtr qHeader
);
Parameters
qElement

A pointer to the queue element to add to a queue. 
qHeader

A pointer to a queue header. 
Discussion

The Enqueue function adds the queue element specified by the qElement parameter to the end of the queue specified by the qHeader parameter. The specified queue header is updated to reflect the new queue element.

For a description of the QElem record, see QElem; for a description of the QHdr record, see QHdr.

Because interrupt functions are likely to manipulate operating-system queues, interrupts are disabled for a short time while the specified queue is updated. You can call the Enqueue function at interrupt time. However, the Enqueue function is ordinarily used only by system software. Whenever possible, you should manipulate an operating-system queue indirectly, by calling special-purpose functions whenever possible, instead of the Enqueue function. You can use the Queue Utilities functions for directly manipulating queues that you create. Use the following functions instead of Enqueue:
SlotVInstall

Installs a slot-based VBL task. This function is available with the Vertical Retrace Manager.
VInstall

Installs a system-based VBL task. This function is available with the Vertical Retrace Manager.
AddDrive

Adds a disk drive. This function is available with the Device Manager.
PPostEvent and PostEvent

Installs an Event. This function is available with the Event manager.
DTInstall

Installs a deferred task. This function is available with the Memory Management Utilities.
SIntInstall

Installs a slot interrupt task. This function is available with the Slot Manager.
NMInstall

Installs a Notification request. This function is available with the Notification Manager.
SleepQInstall

Installs a Sleep task. This function is available with the Power Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void Enqueue (
   QElemPtr qElement,
   QHdrPtr qHeader
);

/*TickCount

Obtains the current number of ticks (a tick is approximately 1/60 of a second) since the system last started up.

UInt32 TickCount ();
Discussion

The TickCount function returns an unsigned 32-bit integer that indicates the current number of ticks since the system last started up. You can use this value to compare the number of ticks that have elapsed since a given event or other action occurred. For example, you could compare the current value returned by TickCount with the value of the when field of an event structure.

The tick count is incremented during the vertical retrace interrupt, but this interrupt can be disabled. Your application should not rely on the tick count to increment with absolute precision. Your application also should not assume that the tick count always increments by 1 an interrupt task might keep control for more than one tick. If your application keeps track of the previous tick count and then compares this value with the current tick count, your application should compare the two values by checking for a “greater than or equal” condition rather than “equal to previous tick count plus 1.”

Do not rely on the tick count being exact; it is usually accurate to within one tick, but this level of accuracy is not guaranteed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
UInt32 TickCount ();

/*MakeDataExecutable

Notifies the system that the specified data is subject to execution.

void MakeDataExecutable (
   void * baseAddress,
   unsigned long length
);
Parameters
baseAddress

The starting address of the data to be flushed.
length

The length of the data pointed to by the baseAddress parameter.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void MakeDataExecutable (
   void * baseAddress,
   unsigned long length
);

/*Delay

Delays execture for the specified amount of time.

void Delay (
   unsigned long numTicks,
   unsigned long * finalTicks
);
Parameters
numTicks
finalTicks
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/

void Delay (
   unsigned long numTicks,
   unsigned long * finalTicks
);

/*SetCurrentA5

Sets the value in register A5 to the value of the low-memory global variable CurrentA5. (Deprecated in Mac OS X v10.4. There is no replacement because Mac OS X doesn’t use the A5 variable.)

long SetCurrentA5 ();
Return Value

The value in the A5 register before SetCurrentA5 changes it to the value of the low-memory global variable CurrentA5. 
Discussion

The CurrentA5 variable points to the boundary between the parameters and global variables of the current application.

You cannot reliably call SetCurrentA5 in code that executes at interrupt time unless you first guarantee that your application is the current process (for example, by calling the Process Manager function GetCurrentProcess). In general, you should call SetCurrentA5 at noninterrupt time and then pass the returned value to the interrupt code. 
Carbon Porting Notes

68K-specific. Does nothing in PowerPC native code. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/
long SetCurrentA5 ();

/*SetA5

Sets the A5 register to the address specified. (Deprecated in Mac OS X v10.4. There is no replacement because Mac OS X doesn’t use the A5 variable.)

long SetA5 (
   long newA5
);
Parameters
newA5

The value to which the A5 register is to be changed. 
Return Value

The value in the A5 register before SetA5 changes it to newA5. 
Discussion

In interrupt code that accesses application global variables, use the SetA5 function first to restore a value previously saved using SetCurrentA5, and then, at the end of the code, to restore the A5 register to the value it had before the first call to SetA5. 
Carbon Porting Notes

68K-specific. Does nothing in PowerPC native code. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/

long SetA5 (
   long newA5
);

#ifdef __cplusplus
}
#endif
#endif