#ifndef PEFBINARYFORMAT_H
#define PEFBINARYFORMAT_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif


#include <HYS/CarbonCore/PEFBinaryFormat.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

/*kPEFWeakImportLibMask


enum {
   kPEFWeakImportLibMask = 0x40,
   kPEFInitLibBeforeMask = 0x80
};
Constants
kPEFWeakImportLibMask

Available in Mac OS X v10.0 and later.
kPEFInitLibBeforeMask

Available in Mac OS X v10.0 and later.
Discussion
Version Notes
Carbon Porting Notes*/
enum {
   kPEFWeakImportLibMask = 0x40,
   kPEFInitLibBeforeMask = 0x80
};



/*kPEFRelocBySectDWithSkip


enum {
   kPEFRelocBySectDWithSkip = 0x00,
   kPEFRelocBySectC = 0x20,
   kPEFRelocBySectD = 0x21,
   kPEFRelocTVector12 = 0x22,
   kPEFRelocTVector8 = 0x23,
   kPEFRelocVTable8 = 0x24,
   kPEFRelocImportRun = 0x25,
   kPEFRelocSmByImport = 0x30,
   kPEFRelocSmSetSectC = 0x31,
   kPEFRelocSmSetSectD = 0x32,
   kPEFRelocSmBySection = 0x33,
   kPEFRelocIncrPosition = 0x40,
   kPEFRelocSmRepeat = 0x48,
   kPEFRelocSetPosition = 0x50,
   kPEFRelocLgByImport = 0x52,
   kPEFRelocLgRepeat = 0x58,
   kPEFRelocLgSetOrBySection = 0x5A,
   kPEFRelocUndefinedOpcode = 0xFF
};
Constants
kPEFRelocBySectDWithSkip

Available in Mac OS X v10.0 and later.
kPEFRelocBySectC

Available in Mac OS X v10.0 and later.
kPEFRelocBySectD

Available in Mac OS X v10.0 and later.
kPEFRelocTVector12

Available in Mac OS X v10.0 and later.
kPEFRelocTVector8

Available in Mac OS X v10.0 and later.
kPEFRelocVTable8

Available in Mac OS X v10.0 and later.
kPEFRelocImportRun

Available in Mac OS X v10.0 and later.
kPEFRelocSmByImport

Available in Mac OS X v10.0 and later.
kPEFRelocSmSetSectC

Available in Mac OS X v10.0 and later.
kPEFRelocSmSetSectD

Available in Mac OS X v10.0 and later.
kPEFRelocSmBySection

Available in Mac OS X v10.0 and later.
kPEFRelocIncrPosition

Available in Mac OS X v10.0 and later.
kPEFRelocSmRepeat

Available in Mac OS X v10.0 and later.
kPEFRelocSetPosition

Available in Mac OS X v10.0 and later.
kPEFRelocLgByImport

Available in Mac OS X v10.0 and later.
kPEFRelocLgRepeat

Available in Mac OS X v10.0 and later.
kPEFRelocLgSetOrBySection

Available in Mac OS X v10.0 and later.
kPEFRelocUndefinedOpcode

Available in Mac OS X v10.0 and later.
Discussion
Version Notes
Carbon Porting Notes*/

enum {
   kPEFRelocBySectDWithSkip = 0x00,
   kPEFRelocBySectC = 0x20,
   kPEFRelocBySectD = 0x21,
   kPEFRelocTVector12 = 0x22,
   kPEFRelocTVector8 = 0x23,
   kPEFRelocVTable8 = 0x24,
   kPEFRelocImportRun = 0x25,
   kPEFRelocSmByImport = 0x30,
   kPEFRelocSmSetSectC = 0x31,
   kPEFRelocSmSetSectD = 0x32,
   kPEFRelocSmBySection = 0x33,
   kPEFRelocIncrPosition = 0x40,
   kPEFRelocSmRepeat = 0x48,
   kPEFRelocSetPosition = 0x50,
   kPEFRelocLgByImport = 0x52,
   kPEFRelocLgRepeat = 0x58,
   kPEFRelocLgSetOrBySection = 0x5A,
   kPEFRelocUndefinedOpcode = 0xFF
};


/*kPEFRelocBasicOpcodeRange


enum {
   kPEFRelocBasicOpcodeRange = 128
};
Constants
kPEFRelocBasicOpcodeRange

Available in Mac OS X v10.0 and later.
Discussion
Version Notes
Carbon Porting Notes*/

enum {
   kPEFRelocBasicOpcodeRange = 128
};


/*PEFLoaderRelocationHeader


struct PEFLoaderRelocationHeader {
   UInt16 sectionIndex;
   UInt16 reservedA;
   UInt32 relocCount;
   UInt32 firstRelocOffset;
};
typedef struct PEFLoaderRelocationHeader PEFLoaderRelocationHeader;
Fields
sectionIndex
reservedA
relocCount
firstRelocOffset
Discussion
Version Notes
Carbon Porting Notes
Availability
Available in Mac OS X v10.0 and later.*/

struct PEFLoaderRelocationHeader {
   UInt16 sectionIndex;
   UInt16 reservedA;
   UInt32 relocCount;
   UInt32 firstRelocOffset;
};
typedef struct PEFLoaderRelocationHeader PEFLoaderRelocationHeader;


/*kPEFCodeSymbol


enum {
   kPEFCodeSymbol = 0x00,
   kPEFDataSymbol = 0x01,
   kPEFTVectorSymbol = 0x02,
   kPEFTOCSymbol = 0x03,
   kPEFGlueSymbol = 0x04,
   kPEFUndefinedSymbol = 0x0F,
   kPEFWeakImportSymMask = 0x80
};
Constants
kPEFCodeSymbol

Available in Mac OS X v10.0 and later.
kPEFDataSymbol

Available in Mac OS X v10.0 and later.
kPEFTVectorSymbol

Available in Mac OS X v10.0 and later.
kPEFTOCSymbol

Available in Mac OS X v10.0 and later.
kPEFGlueSymbol

Available in Mac OS X v10.0 and later.
kPEFUndefinedSymbol

Available in Mac OS X v10.0 and later.
kPEFWeakImportSymMask

Available in Mac OS X v10.0 and later.
Discussion
Version Notes
Carbon Porting Notes*/
enum {
   kPEFCodeSymbol = 0x00,
   kPEFDataSymbol = 0x01,
   kPEFTVectorSymbol = 0x02,
   kPEFTOCSymbol = 0x03,
   kPEFGlueSymbol = 0x04,
   kPEFUndefinedSymbol = 0x0F,
   kPEFWeakImportSymMask = 0x80
};


/*kPEFPkDataZero


enum {
   kPEFPkDataZero = 0,
   kPEFPkDataBlock = 1,
   kPEFPkDataRepeat = 2,
   kPEFPkDataRepeatBlock = 3,
   kPEFPkDataRepeatZero = 4
};
Constants
kPEFPkDataZero

Available in Mac OS X v10.0 and later.
kPEFPkDataBlock

Available in Mac OS X v10.0 and later.
kPEFPkDataRepeat

Available in Mac OS X v10.0 and later.
kPEFPkDataRepeatBlock

Available in Mac OS X v10.0 and later.
kPEFPkDataRepeatZero

Available in Mac OS X v10.0 and later.
Discussion
Version Notes
Carbon Porting Notes*/

enum {
   kPEFPkDataZero = 0,
   kPEFPkDataBlock = 1,
   kPEFPkDataRepeat = 2,
   kPEFPkDataRepeatBlock = 3,
   kPEFPkDataRepeatZero = 4
};

/*kPEFPkDataOpcodeShift


enum {
   kPEFPkDataOpcodeShift = 5,
   kPEFPkDataCount5Mask = 0x1F,
   kPEFPkDataMaxCount5 = 31,
   kPEFPkDataVCountShift = 7,
   kPEFPkDataVCountMask = 0x7F,
   kPEFPkDataVCountEndMask = 0x80
};
Constants
kPEFPkDataOpcodeShift

Available in Mac OS X v10.0 and later.
kPEFPkDataCount5Mask

Available in Mac OS X v10.0 and later.
kPEFPkDataMaxCount5

Available in Mac OS X v10.0 and later.
kPEFPkDataVCountShift

Available in Mac OS X v10.0 and later.
kPEFPkDataVCountMask

Available in Mac OS X v10.0 and later.
kPEFPkDataVCountEndMask

Available in Mac OS X v10.0 and later.
Discussion
Version Notes
Carbon Porting Notes*/

enum {
   kPEFPkDataOpcodeShift = 5,
   kPEFPkDataCount5Mask = 0x1F,
   kPEFPkDataMaxCount5 = 31,
   kPEFPkDataVCountShift = 7,
   kPEFPkDataVCountMask = 0x7F,
   kPEFPkDataVCountEndMask = 0x80
};





/*kPEFCodeSection


enum {
   kPEFCodeSection = 0,
   kPEFUnpackedDataSection = 1,
   kPEFPackedDataSection = 2,
   kPEFConstantSection = 3,
   kPEFExecDataSection = 6,
   kPEFLoaderSection = 4,
   kPEFDebugSection = 5,
   kPEFExceptionSection = 7,
   kPEFTracebackSection = 8
};
Constants
kPEFCodeSection

Available in Mac OS X v10.0 and later.
kPEFUnpackedDataSection

Available in Mac OS X v10.0 and later.
kPEFPackedDataSection

Available in Mac OS X v10.0 and later.
kPEFConstantSection

Available in Mac OS X v10.0 and later.
kPEFExecDataSection

Available in Mac OS X v10.0 and later.
kPEFLoaderSection

Available in Mac OS X v10.0 and later.
kPEFDebugSection

Available in Mac OS X v10.0 and later.
kPEFExceptionSection

Available in Mac OS X v10.0 and later.
kPEFTracebackSection

Available in Mac OS X v10.0 and later.
Discussion
Version Notes
Carbon Porting Notes*/

enum {
   kPEFCodeSection = 0,
   kPEFUnpackedDataSection = 1,
   kPEFPackedDataSection = 2,
   kPEFConstantSection = 3,
   kPEFExecDataSection = 6,
   kPEFLoaderSection = 4,
   kPEFDebugSection = 5,
   kPEFExceptionSection = 7,
   kPEFTracebackSection = 8
};


/*PEFImportedLibrary


struct PEFImportedLibrary {
   UInt32 nameOffset;
   UInt32 oldImpVersion;
   UInt32 currentVersion;
   UInt32 importedSymbolCount;
   UInt32 firstImportedSymbol;
   UInt8 options;
   UInt8 reservedA;
   UInt16 reservedB;
};
typedef struct PEFImportedLibrary PEFImportedLibrary;
Fields
nameOffset
oldImpVersion
currentVersion
importedSymbolCount
firstImportedSymbol
options
reservedA
reservedB
Discussion
Version Notes
Carbon Porting Notes
Availability
Available in Mac OS X v10.0 and later.*/
struct PEFImportedLibrary {
   UInt32 nameOffset;
   UInt32 oldImpVersion;
   UInt32 currentVersion;
   UInt32 importedSymbolCount;
   UInt32 firstImportedSymbol;
   UInt8 options;
   UInt8 reservedA;
   UInt16 reservedB;
};
typedef struct PEFImportedLibrary PEFImportedLibrary;


/*PEFLoaderInfoHeader


struct PEFLoaderInfoHeader {
   SInt32 mainSection;
   UInt32 mainOffset;
   SInt32 initSection;
   UInt32 initOffset;
   SInt32 termSection;
   UInt32 termOffset;
   UInt32 importedLibraryCount;
   UInt32 totalImportedSymbolCount;
   UInt32 relocSectionCount;
   UInt32 relocInstrOffset;
   UInt32 loaderStringsOffset;
   UInt32 exportHashOffset;
   UInt32 exportHashTablePower;
   UInt32 exportedSymbolCount;
};
typedef struct PEFLoaderInfoHeader PEFLoaderInfoHeader;
Fields
mainSection
mainOffset
initSection
initOffset
termSection
termOffset
importedLibraryCount
totalImportedSymbolCount
relocSectionCount
relocInstrOffset
loaderStringsOffset
exportHashOffset
exportHashTablePower
exportedSymbolCount
Discussion
Version Notes
Carbon Porting Notes
Availability
Available in Mac OS X v10.0 and later.*/
struct PEFLoaderInfoHeader {
   SInt32 mainSection;
   UInt32 mainOffset;
   SInt32 initSection;
   UInt32 initOffset;
   SInt32 termSection;
   UInt32 termOffset;
   UInt32 importedLibraryCount;
   UInt32 totalImportedSymbolCount;
   UInt32 relocSectionCount;
   UInt32 relocInstrOffset;
   UInt32 loaderStringsOffset;
   UInt32 exportHashOffset;
   UInt32 exportHashTablePower;
   UInt32 exportedSymbolCount;
};
typedef struct PEFLoaderInfoHeader PEFLoaderInfoHeader;


/*PEFSectionHeader


struct PEFSectionHeader {
   SInt32 nameOffset;
   UInt32 defaultAddress;
   UInt32 totalLength;
   UInt32 unpackedLength;
   UInt32 containerLength;
   UInt32 containerOffset;
   UInt8 sectionKind;
   UInt8 shareKind;
   UInt8 alignment;
   UInt8 reservedA;
};
typedef struct PEFSectionHeader PEFSectionHeader;
Fields
nameOffset
defaultAddress
totalLength
unpackedLength
containerLength
containerOffset
sectionKind
shareKind
alignment
reservedA
Discussion
Version Notes
Carbon Porting Notes
Availability
Available in Mac OS X v10.0 and later.*/

struct PEFSectionHeader {
   SInt32 nameOffset;
   UInt32 defaultAddress;
   UInt32 totalLength;
   UInt32 unpackedLength;
   UInt32 containerLength;
   UInt32 containerOffset;
   UInt8 sectionKind;
   UInt8 shareKind;
   UInt8 alignment;
   UInt8 reservedA;
};
typedef struct PEFSectionHeader PEFSectionHeader;




/*kPEFTag1


enum {
   kPEFTag1 = 'Joy!',
   kPEFTag2 = 'peff',
   kPEFVersion = 0x00000001
};
Constants
kPEFTag1

Available in Mac OS X v10.0 and later.
kPEFTag2

Available in Mac OS X v10.0 and later.
kPEFVersion

Available in Mac OS X v10.0 and later.
Discussion
Version Notes
Carbon Porting Notes*/

enum {
   kPEFTag1 = 'Joy!',
   kPEFTag2 = 'peff',
   kPEFVersion = 0x00000001
};




/*PEFContainerHeader


struct PEFContainerHeader {
   OSType tag1;
   OSType tag2;
   OSType architecture;
   UInt32 formatVersion;
   UInt32 dateTimeStamp;
   UInt32 oldDefVersion;
   UInt32 oldImpVersion;
   UInt32 currentVersion;
   UInt16 sectionCount;
   UInt16 instSectionCount;
   UInt32 reservedA;
};
typedef struct PEFContainerHeader PEFContainerHeader;
Fields
tag1
tag2
architecture
formatVersion
dateTimeStamp
oldDefVersion
oldImpVersion
currentVersion
sectionCount
instSectionCount
reservedA
Discussion
Version Notes
Carbon Porting Notes
Availability
Available in Mac OS X v10.0 and later.*/
struct PEFContainerHeader {
   OSType tag1;
   OSType tag2;
   OSType architecture;
   UInt32 formatVersion;
   UInt32 dateTimeStamp;
   UInt32 oldDefVersion;
   UInt32 oldImpVersion;
   UInt32 currentVersion;
   UInt16 sectionCount;
   UInt16 instSectionCount;
   UInt32 reservedA;
};
typedef struct PEFContainerHeader PEFContainerHeader;



#endif