#ifndef CGPATH_H
#define CGPATH_H

#include <CoreGraphics/CGBase.h>
#include <CoreGraphics/CGAffineTransform.h>
#include <CoreFoundation/CFBase.h>

/*Path Drawing Modes

Specify ways of rendering a path.

enum CGPathDrawingMode {
   kCGPathFill,
   kCGPathEOFill,
   kCGPathStroke,
   kCGPathFillStroke,
   kCGPathEOFillStroke
};
typedef enum CGPathDrawingMode CGPathDrawingMode;
Constants
kCGPathFill

Render the area contained within the path using the non-zero winding number rule. 

Available in Mac OS X v10.0 and later.
kCGPathEOFill

Render the area within the path using the even-odd rule. 

Available in Mac OS X v10.0 and later.
kCGPathStroke

Render a line along the path. 

Available in Mac OS X v10.0 and later.
kCGPathFillStroke

First fill and then stroke the path, using the nonzero winding number rule.

Available in Mac OS X v10.0 and later.
kCGPathEOFillStroke

First fill and then stroke the path, using the even-odd rule. 

Available in Mac OS X v10.0 and later.
Discussion

To draw a shape, you set the current path to that shape and then paint the shape by stroking, filling, or both stroking and filling. Stroking is the process of painting a line along the current path. Filling is the process of painting the area contained within the path.

When you fill the current path, Quartz fills each subpath independently. Any subpath that has not been explicitly closed is closed implicitly by the fill routines. There are two different methods of filling paths: the nonzero winding number rule and the even-odd rule.

The default fill rule is called the nonzero winding number rule. To understand how this rule works, draw a line in any direction, starting from a given point and moving to infinity. Starting with a count of 0, add one to the count every time a path segment crosses the line from left to right, and subtract one every time a path segment crosses the line from right to left. If the result is 0, the point is outside the path and is not filled.

Alternately, using the even-odd rule, you draw a line in any direction, starting from a given point and moving to infinity. Count the number of path segments that the line crosses. If the result is odd, the point is inside the path and therefore filled. If the result is even, the point is outside the path and is not filled.

You can pass a path drawing mode constant to the function CGContextDrawPath to specify how Quartz should paint a graphics context’s current path.*/
enum CGPathDrawingMode {
   kCGPathFill,
   kCGPathEOFill,
   kCGPathStroke,
   kCGPathFillStroke,
   kCGPathEOFillStroke
};
typedef enum CGPathDrawingMode CGPathDrawingMode;



#endif