#import <Foundation/Foundation.h>
#import <AvailabilityMacros.h>

@class DRFolder;

/*DRFilesystemInclusionMask constants

enum { 
    DRFilesystemInclusionMaskISO9660 = (
        1<<0), 
    DRFilesystemInclusionMaskJoliet = (
        1<<1), 
    DRFilesystemInclusionMaskUDF = (
        1<<2), 
    DRFilesystemInclusionMaskHFSPlus = (
        1<<3) 
};  
Constants
DRFilesystemInclusionMaskISO9660
Indicates the object should be included in the ISO9660 filesytem
DRFilesystemInclusionMaskJoliet
Indicates the object should be included in the Joliet filesytem
DRFilesystemInclusionMaskUDF
Indicates the object should be included in the UDF filesytem
DRFilesystemInclusionMaskHFSPlus
Indicates the object should be included in the HFS+ filesytem
Discussion 

Mask constants for determing the presence of a DRFSObject in a specific filesystem*/

enum { 
    DRFilesystemInclusionMaskISO9660 = (
        1<<0), 
    DRFilesystemInclusionMaskJoliet = (
        1<<1), 
    DRFilesystemInclusionMaskUDF = (
        1<<2), 
    DRFilesystemInclusionMaskHFSPlus = (
        1<<3) 
};  


/*DRFilesystemInclusionMask


Mask value determing the presence of a DRFSObject in a specific filesystem. 
typedef UInt32 DRFilesystemInclusionMask;  
Discussion 

The filesystem mask is a bitfield which contains a 1 if the object will appear in the corresponding filesystem, and 0 otherwise.*/
typedef UInt32 DRFilesystemInclusionMask;  

@interface DRFSObject : NSObject 

/*setExplicitFilesystemMask:


Sets the filesystems the receiver will be included on. 
private

- (void) setExplicitFilesystemMask:(DRFilesystemInclusionMask)mask; 
Parameters
mask
A filesystem mask
Discussion 

The effective mask for an item cannot be more inclusive than the effective mask of it's parent. If the mask set for a child is more inclusive than its parent's mask, those filesystems not allowed by the parent will be stripped from the resulting effective mask of the child.*/
- (void) setExplicitFilesystemMask:(DRFilesystemInclusionMask)mask; 

@end
