
#import <Foundation/Foundation.h>

#import <DiscRecordingEngine/DRCoreDevice.h>
#import <DiscRecordingEngine/DRMSF.h>

#import <AvailabilityMacros.h>

/*DRDeviceMediaInfoKey

extern NSString* const DRDeviceMediaInfoKey;  
Discussion 

One of the keys in the dictionary returned by the status method. NSDictionary of information describing the media currently in the device. This key may not be present if no media is inserted. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRDeviceMediaInfoKey;  

/*DRDeviceMediaTypeKey

extern NSString* const DRDeviceMediaTypeKey;  
Discussion 

One of the keys in the DRDeviceMediaInfoKey dictionary. NSString containing the type of media inserted in the device. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRDeviceMediaTypeKey; 

/*DRDeviceMediaTypeCDR

extern NSString* const DRDeviceMediaTypeCDR;  
Discussion 

One of the possible values of the DRDeviceMediaTypeKey . Media is a CD-R. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRDeviceMediaTypeCDR;  

/*DRDeviceMediaTypeCDRW

extern NSString* const DRDeviceMediaTypeCDRW;  
Discussion 

One of the possible values of the DRDeviceMediaTypeKey . Media is a CD-RW. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRDeviceMediaTypeCDRW;  


@interface DRDevice : NSObject 

/*status


Returns a dictionary of information describing the media in the device. 
private

- (NSDictionary*) status; 
Return Value

An NSDictionary containing media information. 
Discussion 

In addition to information about the media (type, space available/used, etc), the dictionary returned includes those pieces of information about the device itself which are in part determined by the media (i.e., maximum burn speed).*/
- (NSDictionary*) status; 

@end

//@interface DRDevice (InfoConvenience)

//@end

//@interface DRDevice (StatusConvenience)

//@end
