#ifndef  AXVALUE_H
#define AXVALUE_H

#include <CoreServices/CoreServices.h>
#include <CoreFoundation/CoreFoundation.h>


#include <AvailabilityMacros.h>

#ifdef __cplusplus
extern "C" {
#endif

/*AXValueRef

typedef const struct __AXValue *AXValueRef;  */
typedef const struct __AXValue *AXValueRef;

/*AXValueType

See Also:
AXValueType Wrappers
typedef enum { 
    kAXValueCGPointType = 1, 
    kAXValueCGSizeType = 2, 
    kAXValueCGRectType = 3,  
    kAXValueCFRangeType = 4,  
    kAXValueAXErrorType = 5,  
    kAXValueIllegalType = 0  
} AXValueType;  
Constants
kAXValueCGPointType
a wrapper for CGPoint; see CoreGraphics.h
kAXValueCGSizeType
a wrapper for CGSize; see CoreGraphics.h
kAXValueCGRectType
a wrapper for CGRect; see CoreGraphics.h
kAXValueCFRangeType
a wrapper for CFRange; see CFBase.h
kAXValueAXErrorType
See AXError.h
kAXValueIllegalType
a wrapper for unsupported structures
Discussion 

These are AXValueType wrappers for other structures. You must use the AXValueCreate and AXValueGetValue functions to convert between the wrapped structure and the native structure.*/
typedef enum { 
    kAXValueCGPointType = 1, 
    kAXValueCGSizeType = 2, 
    kAXValueCGRectType = 3,  
    kAXValueCFRangeType = 4,  
    kAXValueAXErrorType = 5,  
    kAXValueIllegalType = 0  
} AXValueType;  


/*AXValueGetType

extern AXValueType AXValueGetType(
    AXValueRef value);  
Parameters
value


Discussion 

Returns the structure type encoded in value. If the type is not recognized, it returns kAXValueIllegalType.*/
extern AXValueType AXValueGetType(
    AXValueRef value);  

/*AXValueGetValue

extern Boolean AXValueGetValue(
    AXValueRef value,
    AXValueType theType,
    void *valuePtr);  
Parameters
value


Discussion 

Decodes the structure stored in value and copies it into valuePtr. If the structure stored in value is not the same as requested by theType, the function returns false.*/
extern Boolean AXValueGetValue(
    AXValueRef value,
    AXValueType theType,
    void *valuePtr);  

/*AXValueCreate

extern AXValueRef AXValueCreate (
    AXValueType theType,
    const void *valuePtr);  
Parameters
theType
valuePtr


Discussion 

Encodes a structure pointed to by valuePtr into a CFTypeRef.*/
extern AXValueRef AXValueCreate (
    AXValueType theType,
    const void *valuePtr);  

#ifdef __cplusplus
}
#endif

#endif