#ifndef MACAPPLICATION_H
#define MACAPPLICATION_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef MENUS_H
#include <HIToolbox/Menus.h>
#endif

#ifndef HIOBJECT_H
#include <HIToolbox/HIObject.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*GetApplicationTextEncoding

Returns the application text encoding for Resource Manager resources.

TextEncoding GetApplicationTextEncoding ();
Return Value

See the Text Encoding Conversion Manager documentation for a description of the TextEncoding data type.
Discussion

Your application needs to use the application text encoding when it creates a CFStringRef from text stored in Resource Manager resources. Typically the text uses a Mac encoding such as MacRoman or MacJapanese. 
Availability
Available in CarbonLib 1.2 and later.
Available in Mac OS X 10.0 and later.
Declared In
MacApplication.h*/
TextEncoding GetApplicationTextEncoding ();

/*BeginCGContextForApplicationDockTile

Allocates a context reference (CGContextRef). 

CGContextRef BeginCGContextForApplicationDockTile ();
Return Value

A reference to a context reference. See the Quartz 2D documentation for a description of the CGContextRef data type.
Discussion

You can use this context to draw into your application Dock tile with Quartz. You must call the function EndCGContextForApplicationDockTile to lock your application tile in the Dock. Do not call the function CGEndContext for this purpose as it is not designed to work with a context reference for an application Dock tile. 
Availability
Not available in Carbon.
Available in Mac OS X 10.0 and later.
Declared In
MacApplication.h*/
CGContextRef BeginCGContextForApplicationDockTile ();

/*EndCGContextForApplicationDockTile

Disposes of the context reference (CGContextRef ) for your application tile and frees the lock on the application Dock tile.

void EndCGContextForApplicationDockTile (
   CGContextRef inContext
);
Parameters
inContext

A reference to the context you want to end. The context is invalid after this call and should no longer be used. 
Discussion

You must call the function EndCGContextForApplicationDockTile when you use the function BeginCGContextForApplicationDockTile. Do not use the function CGEndContext as the context associated with the application’s Dock tile won’t be disposed of and the lock on the application Dock tile won’t be freed. 
Availability
Not available in Carbon.
Available in Mac OS X 10.0 and later.
Declared In
MacApplication.h*/
void EndCGContextForApplicationDockTile (
   CGContextRef inContext
);

/*RestoreApplicationDockTileImage

Restores your application Dock icon to the application icon. 

OSStatus RestoreApplicationDockTileImage ();
Return Value

A result code.
Discussion

If you’ve called the functions SetApplicationDockTileImage or OverlayApplicationDockTileImage, you can use the function RestoreApplicationDockTileImage to restore the Dock icon to the original application icon. 
Availability
Not available in Carbon.
Available in Mac OS X 10.0 and later.
Declared In
MacApplication.h*/

OSStatus RestoreApplicationDockTileImage ();

#ifdef __cplusplus
}
#endif

#endif