#ifndef MACTEXTEDITOR_H
#define MACTEXTEDITOR_H


#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef DRAG_H
#include <HIToolbox/Drag.h>
#endif

#ifndef MACWINDOWS_H
#include <HIToolbox/MacWindows.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif

#ifndef HIVIEW_H
#include <HIToolbox/HIView.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Supported File Types

Represents a file type.

typedef OSType TXNFileType;
enum {
   kTXNTextensionFile = 'txtn',
   kTXNTextFile = 'TEXT',
   kTXNPictureFile = 'PICT',
   kTXNMovieFile = 'MooV',
   kTXNSoundFile = 'sfil',
   kTXNAIFFFile = 'AIFF',
   kTXNUnicodeTextFile = 'utxt'
};
Constants
kTXNTextensionFile

A file that contains Unicode or Mac OS text. By default, it contains Unicode text. Files are saved in a private format.

Available in Mac OS X v10.0 and later.
kTXNTextFile

A file that contains plain text data. 

Available in Mac OS X v10.0 and later.
kTXNPictureFile

A file that contains graphics data in PICT format.

Available in Mac OS X v10.0 and later.
kTXNMovieFile

A file that contains movie data in 'MooV' format.

Available in Mac OS X v10.0 and later.
kTXNSoundFile

A file that contains sound data in 'sfil' format.

Available in Mac OS X v10.0 and later.
kTXNAIFFFile

A file that contains sound data in 'aiff' format.

Available in Mac OS X v10.0 and later.
kTXNUnicodeTextFile

A file that contains Unicode text data.

Available in Mac OS X v10.0 and later.*/
typedef OSType TXNFileType;
enum {
   kTXNTextensionFile = 'txtn',
   kTXNTextFile = 'TEXT',
   kTXNPictureFile = 'PICT',
   kTXNMovieFile = 'MooV',
   kTXNSoundFile = 'sfil',
   kTXNAIFFFile = 'AIFF',
   kTXNUnicodeTextFile = 'utxt'
};

/*Supported Data Types

Specifies the type of data being requested from or passed to an MLTE function.

typedef OSType TXNDataType;
enum {
   kTXNTextData = 'TEXT',
   kTXNPictureData = 'PICT',
   kTXNMovieData = 'moov',
   kTXNSoundData = 'snd ',
   kTXNUnicodeTextData = 'utxt'
};
Constants
kTXNTextData

Text data.

Available in Mac OS X v10.0 and later.
kTXNPictureData

Graphics (PICT) data.

Available in Mac OS X v10.0 and later.
kTXNMovieData

Movie or sound data.

Available in Mac OS X v10.0 and later.
kTXNSoundData

Sound data.

Available in Mac OS X v10.0 and later.
kTXNUnicodeTextData

Unicode text data.

Available in Mac OS X v10.0 and later.
Discussion

Used in the TXNGetDataEncoded function.*/
typedef OSType TXNDataType;
enum {
   kTXNTextData = 'TEXT',
   kTXNPictureData = 'PICT',
   kTXNMovieData = 'moov',
   kTXNSoundData = 'snd ',
   kTXNUnicodeTextData = 'utxt'
};

/*Data Offsets

Specifies offsets to use when manipulating data in a text object. Offsets in MLTE are always character offsets.

typedef UInt32 TXNOffset;
enum {
   kTXNUseCurrentSelection = 0xFFFFFFFF,
   kTXNStartOffset = 0,
   kTXNEndOffset = 0x7FFFFFFF
};
Constants
kTXNUseCurrentSelection

Use the current selection.

Available in Mac OS X v10.0 and later.
kTXNStartOffset

The first offset of the text in a text object.

Available in Mac OS X v10.0 and later.
kTXNEndOffset

The last offset of the text in a text object.

Available in Mac OS X v10.0 and later.
Discussion

These constants can be passed and returned in functions that have the parameter of type TXNOffset.*/
typedef UInt32 TXNOffset;
enum {
   kTXNUseCurrentSelection = 0xFFFFFFFF,
   kTXNStartOffset = 0,
   kTXNEndOffset = 0x7FFFFFFF
};

/*TXNObject

Contains private variables and functions necessary to represent text and handle text formatting at a document level. 

typedef struct OpaqueTXNObject * TXNObject;
Discussion

You obtain a structure of type TXNObject from the TXNNewObject function. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueTXNObject * TXNObject;

/*TXNRevert

Reverts to the last saved version of a document. 

OSStatus TXNRevert (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNRevert function with files that contain only text as well as files that were created using MLTE. If the file was not previously saved, the document reverts to an empty document. To revert to data that is embedded in a private file type, use the TXNSetSelection function to select all of the current data and then use the TXNSetDataFromFile function to read in the old data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNRevert (
   TXNObject iTXNObject
);

/*TXNPageSetup

Displays the Page Setup dialog for the current default printer and manages changes, such as reformatting the text, in response to page layout changes.

OSStatus TXNPageSetup (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPageSetup (
   TXNObject iTXNObject
);

/*TXNPrint

Prints the document so it is formatted to fit the page size selected for the printer. 

OSStatus TXNPrint (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that identifies the document you want to print. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPrint (
   TXNObject iTXNObject
);

/*TXNGetDataEncoded

Copies the text in a specified range, and if necessary, translates the text to match your application’s preferred encoding. 

OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);
Parameters
iTXNObject

The text object that contains the data you want to copy.
iStartOffset

The absolute offset from which data copying should begin. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The absolute offset at which data copying should end. You can use the TXNGetSelection function to get the absolute offsets of the current selection.
oDataHandle

A pointer to a handle. On return, a handle to the requested data. TXNGetDataEncoded allocates the handle as necessary. Your application must dispose of the handle. If there is no text in the range specified, the returned handle is NULL, and the function returns noErr.
encoding

The type of data to be encoded. See Supported Data Types for a full description of possible values. You should specify either the kTXNTextData or kTXNUnicodeTextData constant. If the iEncoding parameter specifies an encoding different from that used to store the text data internally, the Conversion Manager translates the data to the specified type (text or Unicode). If the iEncoding parameter is not recognized, the data is returned in the current encoding. On systems that do not use ATSUI version 1.1 or later, the current encoding is the Mac OS encoding. Otherwise, the current encoding is Unicode. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);

/*HITextViewGetTXNObject

Obtains the text object associated with an HITextView.

TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView)
);
Parameters
inTextView

The HITextView associated with the text object you want to retrieve.
Return Value

Returns the text object associated with the given view.
Discussion

You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. See HITextViewCreate for a list of the functions that return an error if you pass a text object that comes from an HITextView.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView);

/*TXNSetData

Replaces a range of data (text, graphics, and so forth).

OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data.
iDataType

The type of the replacement data. See Supported Data Types for a description of possible values. 
iDataPtr

A pointer to the data that will replace the data that is in the range specified by the iStartOffset and iEndOffset parameters.
iDataSize

The size of the data (in bytes) to which iDataPtr points.
iStartOffset

The beginning of the range of data to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The end of the range to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. If you want to insert text, the ending and starting offsets should be the same value.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

If you have a text object that has word wrap disabled, and you want to avoid horizontal scrolling, you can try the following. After you call the function TXNSetData, call TXNSetSelection with the value of the ending offset set to what it was before you called TXNSetData. Then, call the function TXNShowSelection to scroll the text back into view.

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);

/*TXNSetDataFromCFURLRef

Replaces a range of data with the contents of a file. (Deprecated in Mac OS X v10.4. Use TXNReadFromCFURL instead.)

Not recommended.

OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data. You can either call the function TXNCreateObject to allocate a text object or you can call the function HITextViewGetTXNObject to obtain the text object associated with an HITextView. 
iURL

A reference to the Core Foundation URL that specifies the file which contains the data you want to add to the object. 
iStartOffset

The starting position at which to insert the file into the document. If you want to replace the current selection, set the iStartOffset parameter to kTXNCurrentSelection. If you want to replace the entire document, set the iStartOffset parameter to 0. Offsets in MLTE are always character offsets.
iEndOffset

The ending position of the range being replaced by the file. You can use the TXNGetSelection function to get the absolute offsets of the current selection. Offsets in MLTE are always character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Your application must open the file and set the iStartOffset parameter to the appropriate value before you call the TXNSetDataFromCFURLRef function. If you want to embed MLTE data within private data or other MLTE data, you must set the file position to the appropriate position.

In the (now deprecated) function TXNNewObject your could pass a file reference and MLTE supported functionality to revert back to the original file reference. When you call the function TXNSetDataFromURLRef, MLTE saves the CFURLRef. If you change the contents of the text object and then call the function TXNRevert, the document reverts to the contents specified by the saved CFURLRef.
Availability
Available in Mac OS X v10.3 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);

/*TXNSetSelection

Specifies the selection range or the position of the insertion point. 

OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document for which you want to set the selection range or insertion point position. 
iStartOffset

The new starting offset. Offset values are character offsets. 
iEndOffset

The new ending offset. Offset values are character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNSetSelection function to highlight an initial default value in a document, such as a data-entry form, or to position the insertion point at the start of the field where you want the user to enter a value. To position the insertion point, specify the same value for the iStartOffset and iEndOffset parameters. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);

/*TXNShowSelection

Scrolls the current selection into view.

void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);
Parameters
iTXNObject

The text object for the current text area. 
iShowEnd

A Boolean value. If you set this to true, the end of the selection is scrolled into view. Otherwise, the beginning of the selection is scrolled into view. 
Discussion

You can use this to scroll text into view after you have called the TXNFind function and the matching text is not in the current view of the text object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);

/*TXNWriteRangeToCFURL

Writes a range of a text object to a file or to a special file bundle.

OSStatus TXNWriteRangeToCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFDictionaryRef iDocumentAttributes,
   CFURLRef iFileURL
);
Parameters
iTXNObject

The text object having a range that is to be written.
iStartOffset

The offset in iTXNObject at which to start writing data to iFileURL.
iEndOffset

The offset in iTXNObject at which to stop writing data to iFileURL. 
iDataOptions

A CFDictionaryRef that specifies options for writing out the data. See Data Option Key Value Constants for a list of the supported options. If this parameter is NULL, the data is written out using MLTE’s native format.
iDocumentAttributes

The document attributes that are to be embedded in the data stream. This parameter is only supported when writing out the data using one of the following formats: RTF and MLTE native format. Only the key / values defined in Document Attribute Keys are written out. The content of the dictionary is ignored for any other format. If the dictionary is NULL, no attributes are added to the data stream.
iFileURL

CFURLRef for an existing file or directory, whichever is appropriate for the file type. On return, iFileURL contains a copy of the data in the given range for the iTXNObject with the format and encoding specified by iDataOptions. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

This function writes a range of a text object to a file or a special file bundle (directory). It supports several document formats and encodings, which can be specified in the data options dictionary. Clients can specify additional document attributes when data is written out using a file format, such as RTF and native MLTE file format) that supports such attributes.
Availability
Available in Mac OS X v10.4 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNWriteRangeToCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFDictionaryRef iDocumentAttributes,
   CFURLRef iFileURL
);

/*TXNReadFromCFURL

Reads data from a CFURLRef into a TXNObject.

OSStatus TXNReadFromCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFURLRef iFileURL,
   CFDictionaryRef * oDocumentAttributes
);
Parameters
iTXNObject

The text object into which data read from iFileURL is to be added.
iStartOffset

The offset in iTXNObject at which to start placing data read from iFileURL.
iEndOffset

The offset in iTXNObject at which to stop placing data read from iFileURL. 
iDataOptions

Options for reading the data. See Data Option Key Value Constants for a list of the supported options. If this parameter is NULL, the data is read in using MLTE’s native format.
iFileURL

A CFURLRef to the data that is to be added to the text object specified by inTXNObject.
oDocumentAttributes

A value of type CFDictionary that, on return, contains the document attributes present in the data stream, if the file format supports them; otherwise this parameter is NULL. The native MLTE file format and RTF support embedded document attributes. See Document Attribute Keys for a list of supported attributes. If this parameter is NULL, no document attributes are written out.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

This function reads data from a file or a special file bundle (directory) into a text object. Offset parameters are used to specify whether the new data is inserted, appended or replaces an existing data range in the text object. Clients can specify the document format and encoding of the data using the iDataOptions parameter. This functions also returns the document attributes present in the data stream. Document attributes are supported only for the rich text file formats supported by MLTE, which are RTF and MLTE native file format.

If the caller passes a pointer to a CFDictionaryRef, this function returns a reference to a dictionary of attributes, if there is one, that the caller is responsible for releasing. In all other cases, this function sets the reference to NULL. Here is some sample code:CFDictionaryRef oDocumentAttributes = NULL;
status = TXNReadFromCFRUL (....,&oDocumentAttributes);
if (oDocumentAttributes != NULL) ::CFReleases(oDocumentAttributes);

Availability
Available in Mac OS X v10.4 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNReadFromCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFURLRef iFileURL,
   CFDictionaryRef * oDocumentAttributes
);


#ifdef __cplusplus
}
#endif
#endif