#ifndef TEXTEDIT_H
#define TEXTEDIT_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#include <HYS/HIToolbox/TextEdit.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
typedef struct TERec TERec;

/*TEPtr

Defines a pointer to a TextEdit record.

typedef TTERec* TEPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef TERec* TEPtr;

/*TEClickLoopProcPtr

Defines a pointer to a click-loop callback.

typedef Boolean (*TEClickLoopProcPtr) (
   TEPtr pTE
);

If you name your function MyTEClickLoopProc, you would declare it like this:

Boolean TEClickLoopProcPtr (
   TEPtr pTE
);*/
typedef Boolean (*TEClickLoopProcPtr) (
   TEPtr pTE
);

/*TEClickLoopUPP

Defines a universal procedure pointer (UPP) to a click-loop callback.

typedef TEClickLoopProcPtr TEClickLoopUPP;
Discussion

For more information, see the description of the TEClickLoopUPP () callback function*/
typedef TEClickLoopProcPtr TEClickLoopUPP;


/*TERec

Stores display and editing information for TextEdit.

struct TERec {
   Rect destRect;
   Rect viewRect;
   Rect selRect;
   short lineHeight;
   short fontAscent;
   Point selPoint;
   short selStart;
   short selEnd;
   short active;
   WordBreakUPP wordBreak;
   TEClickLoopUPP clickLoop;
   long clickTime;
   short clickLoc;
   long caretTime;
   short caretState;
   short just;
   short teLength;
   Handle hText;
   long hDispatchRec;
   short clikStuff;
   short crOnly;
   short txFont;
   StyleField txFace;
   short txMode;
   short txSize;
   GrafPtr inPort;
   HighHookUPP highHook;
   CaretHookUPP caretHook;
   short nLines;
   short lineStarts[16001];
};
typedef struct TERec TERec;
typedef TERec * TEPtr;
Fields
destRect

The destination rectangle, in local coordinates. 
viewRect

The view rectangle, in local coordinates.
selRect

The selection rectangle, whose boundaries are defined in local coordinates. This value is the current selection range or insertion point.
lineHeight

The vertical spacing of lines of text. Vertical spacing may be fixed or it may vary from line to line, depending upon specific text attributes. If the value of lineHeight is greater than 0, this field specifies the fixed vertical distance from the ascent line of one line of text down to the ascent line of the next.

If the value of lineHeight is less than 1, then this field specifies the vertical distance from the ascent line of one line of text down to the ascent line of the next calculated independently for each line, based on the maximum value for any individual character attribute on that line.
fontAscent

The font ascent line. If the value of fontAscent is greater than 0, this field specifies how far above the base line the pen is positioned to begin drawing the caret or highlighting.

For single-spaced text, this is the height of the text in pixels (the height of the tallest characters in the font from the base line). If the value of fontAscent is less than 1, this field specifies the font ascent calculated independently for each line, based on maximum value for any individual character attribute on that line.
selPoint

The point selected with the mouse, in the local coordinates of the current graphics port. The assembly-language offset for this field is named teSelPoint. 
selStart

The byte offset of the beginning of a selection range. Note that byte offset 0 refers to the first byte in the text buffer.
selEnd

The byte offset of the end of a selection range. To include that byte, this value must be 1 greater than the position of the last byte offset of the text.
active

This field is used internally by TextEdit. It is set when an edit structure is activated through TEActivate and then reset when the edit structure is rendered inactive through TEDeactivate. To ensure future compatibility, use TEActivate or TEDeactivate to access this field.
wordBreak

A universal procedure pointer to the structure’s word selection break function. This function determines the word that is highlighted when the user double-clicks in the text and the position at which text is wrapped at the end of a line. 
clickLoop

A universal procedure pointer to the click loop function.The specified click loop function is called repeatedly by the TEClick function as long as the mouse button is held down within the text. 
clickTime

This field is for internal use only.
clickLoc

This field is for internal use only.
caretTime

This field is for internal use only.
caretState

This field is for internal use only.
just

The type of text alignment: default (according to primary line direction), left, center, or right.
teLength

The number of bytes in the text to be edited. For two-byte systems, potentially twice the number of characters. Initially set to zero. The maximum length is 32767 bytes.
hText

A handle to the text. Initially, it points to a zero-length block of text in the heap. 
hDispatchRec

A handle to the TextEdit dispatch structure. This field is for internal use only; do not modify this field, or copy it to another edit structure. Each edit structure has its own dispatch structure. Attempting to use the dispatch structure of one edit structure with another edit structure can cause TextEdit to crash.
clikStuff

This field is for internal use only. TextEdit sets this field to reflect whether the most recent mouse-down event occurred on the leading or trailing edge of a glyph. TextEdit uses this value in determining a caret position.
crOnly

A value specifying whether or not text wraps at the right edge of the destination rectangle. If crOnly is positive, text does wrap. Otherwise, new lines are displayed only at Carriage Returns.

If crOnly is negative, new lines are specified explicitly by Return characters only; text does not wrap at the edge of the destination rectangle. (This is useful in an application similar to a programming-language editor, where you may not want a single line of code to be split onto two lines.
txFont

The font of all the text in the edit structure, if the txSize field of this edit structure ≥ 0. If you change this value, the entire text of this edit structure has the new characteristic when it is redrawn also remember to change the lineHeight and fontAscent fields.

If the txSize field is –1, this field combines with txFace to hold a handle to the associated style structure.
txFace

The character attributes of all the text in an edit structure, if the txSize field of this edit structure ≥ 0. If you change this value, the entire text of this edit structure has the new characteristic when it is redrawn also, remember to change the lineHeight and fontAscent fields as well.

If the txSize field is –1, this field combines with txFont to hold a handle to the associated style structure.

txMode

The pen mode of all the text in the edit structure. If you change this value, the entire text of this edit structure has the new characteristic when it is redrawn; also, remember to change the lineHeight and fontAscent fields as well.
txSize

Depending on its value, txSize either contains the point size of all of the text or it acts as a flag indicating whether or not there is associated character attribute information. If txSize ≥ 0, this is a monostyled edit structure, that is, all text is set in a single font, size, and face, and the value of txSize is the size of the text. If txSize is –1, the edit structure contains associated character attribute information and the txFont and txFace fields combine to form a handle to the style structure.
inPort

A pointer to the graphics port associated with this edit structure. 
highHook

A pointer to the function that deals with text highlighting. In assembly language, the highHook field is located at the offset teHiHook. 
caretHook

A pointer to the function that controls the appearance of the caret. In assembly language, the caretHook field is located at the offset teCarHook. 
nLines

The number of lines in the text.
lineStarts

An array containing the character position of the first character in each line. It is declared to have 16001 elements to comply with Pascal range checking. This is a dynamic data structure, having only as many elements as needed. TextEdit calculates these values internally, so do not change the elements of the lineStarts array. Because this data structure grows and shrinks, the size of the edit structure changes.
Discussion

The edit structure, defined by the TERec data type, stores the display and editing information for TextEdit. Along with various subsidiary data structures, the style structure, defined by the TEStyleRec data type, stores the character attribute information for the text of the edit structure.

The edit structure contains display, storage, styling, and other information. Although some fields are used differently for multistyled edit structures and monostyled edit structures, the structure of an edit structure is the same whether the text is multistyled or monostyled. 
Availability
Available in Mac OS X v10.0 and later.*/
struct TERec {
   Rect destRect;
   Rect viewRect;
   Rect selRect;
   short lineHeight;
   short fontAscent;
   Point selPoint;
   short selStart;
   short selEnd;
   short active;
   WordBreakUPP wordBreak;
   TEClickLoopUPP clickLoop;
   long clickTime;
   short clickLoc;
   long caretTime;
   short caretState;
   short just;
   short teLength;
   Handle hText;
   long hDispatchRec;
   short clikStuff;
   short crOnly;
   short txFont;
   StyleField txFace;
   short txMode;
   short txSize;
   GrafPtr inPort;
   HighHookUPP highHook;
   CaretHookUPP caretHook;
   short nLines;
   short lineStarts[16001];
};
//typedef struct TERec TERec;
//typedef TERec * TEPtr;

/*TEHandle

Defines a handle to a TextEdit record pointer.

typedef TEPtr* TEHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef TEPtr* TEHandle;

/*Sets the text alignment as in:   
 teJustLeft                  = 0,
    teJustCenter                = 1,
    teJustRight                 = -1,
    teForceLeft                 = -2, // new names for the
                                 Justification (word alignment) styles 
    teFlushDefault              = 0, //flush according to the line
                                 direction 
    teCenter                    = 1, //center justify (word alignment) 
    teFlushRight                = -1,//flush right for all scripts */
enum {
teJustLeft                  = 0,
    teJustCenter                = 1,
    teJustRight                 = -1,
    teForceLeft                 = -2, /* new names for the
                                 Justification (word alignment) styles */
    teFlushDefault              = 0, /*flush according to the line
                                 direction */
    teCenter                    = 1, /*center justify (word alignment) */
    teFlushRight                = -1,/*flush right for all scripts */
};

//function

/*TETextBox

Draws the indicated text in a given rectangle, with the specified alignment. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TETextBox (
   const void * text,
   long length,
   const Rect * box,
   short just
);
Parameters
text

A pointer to the text to be drawn.
length

The number of bytes comprising the text.
box

A pointer to the rectangle where the text is to be drawn. The rectangle is specified in local coordinates (of the current graphics port) and must be at least as wide as the first character drawn. (A good rule of thumb is to make the rectangle at least 20 pixels wide. 
just

The kind of justification (alignment) used for the specified text.
Discussion

The TETextBox function provides you with an easy way to display static text to a user. It creates its own monostyled edit structure, which it deletes when finished with it, so you cannot edit the text it draws. The TETextBox function breaks a line of text correctly. You can specify how text is aligned in the box using any of the “Text Alignment Constants”. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TETextBox (
   const void * text,
   long length,
   const Rect * box,
   short just
);

#ifdef __cplusplus
}
#endif

#endif