#ifndef QUICKDRAW_H
#define QUICKDRAW_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef COREGRAPHICS_H
#include <CoreGraphics/CoreGraphics.h>
#endif

#ifndef QUICKDRAWTEXT_H
#include <QD/QuickdrawText.h>
#endif

#ifndef CMTYPES_H
#include <ColorSync/CMTypes.h>
#endif

#include <HYS/QD/Quickdraw.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*kQDGrafVerbFrame

enum {
   kQDGrafVerbFrame = 0,
   kQDGrafVerbPaint = 1,
   kQDGrafVerbErase = 2,
   kQDGrafVerbInvert = 3,
   kQDGrafVerbFill = 4
};*/
enum {
   kQDGrafVerbFrame = 0,
   kQDGrafVerbPaint = 1,
   kQDGrafVerbErase = 2,
   kQDGrafVerbInvert = 3,
   kQDGrafVerbFill = 4
};


/*PrinterStatusOpcode

typedef SInt32 PrinterStatusOpcode;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt32 PrinterStatusOpcode;

/*GrafVerb

typedef SInt8 GrafVerb;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt8 GrafVerb;

/*Color Constants

enum {
   blackColor = 33,
   whiteColor = 30,
   redColor = 205,
   greenColor = 341,
   blueColor = 409,
   cyanColor = 273,
   magentaColor = 137,
   yellowColor = 69
};
Constants
blackColor

Represents black.

Available in Mac OS X v10.0 and later.
whiteColor

Represents white.

Available in Mac OS X v10.0 and later.
redColor

Represents red.

Available in Mac OS X v10.0 and later.
greenColor

Represents green.

Available in Mac OS X v10.0 and later.
blueColor

Represents blue.

Available in Mac OS X v10.0 and later.
cyanColor

Represents cyan.

Available in Mac OS X v10.0 and later.
magentaColor

Represents magenta.

Available in Mac OS X v10.0 and later.
yellowColor

Represents yellow.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the color parameter of the ForeColor and BackColor functions to specify one of the eight basic QuickDraw colors.*/

enum {
   blackColor = 33,
   whiteColor = 30,
   redColor = 205,
   greenColor = 341,
   blueColor = 409,
   cyanColor = 273,
   magentaColor = 137,
   yellowColor = 69
};


/*QDErr

typedef short QDErr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef short QDErr;


/*Cursor ID Constants

enum {
   sysPatListID = 0,
   iBeamCursor = 1,
   crossCursor = 2,
   plusCursor = 3,
   watchCursor = 4
};
Constants
iBeamCursor

The I-beam cursor; to select text

Available in Mac OS X v10.0 and later.
crossCursor

The crosshairs cursor; to draw graphics 

Available in Mac OS X v10.0 and later.
plusCursor

The plus sign cursor; to select cells

Available in Mac OS X v10.0 and later.
watchCursor

The wristwatch cursor; to indicate a short operation in progress

Available in Mac OS X v10.0 and later.
Discussion

When passing a value to the Show_Cursor function, use the Cursors data type to represent the kind of cursor to show.*/
enum {
   sysPatListID = 0,
   iBeamCursor = 1,
   crossCursor = 2,
   plusCursor = 3,
   watchCursor = 4
};

/*Bits16

typedef  short Bits16[16];
Discussion

The Bits16 array is used by the Cursor structure to hold a black-and-white, 16-by-16 pixel square image. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef  short Bits16[16];

/*Redefined API Names

Some names defined in the Macintosh application programming interfaces conflict with identical names in the Windows API. In these cases, the QTML header file QTMLMapNames.h avoids these conflicts by redefining the affected names with the prefix Mac added.

In Table 2-2, names listed in the first column refer to the original Macintosh function or data structure name; the second column gives the redefined or newly mapped names.
Table 3-1  Redefined API names
Original Macintosh API name	
Mapped name

AnimatePalette	
MacAnimatePalette

AppendMenu	
MacAppendMenu

CloseDriver	
MacCloseDriver

CloseWindow	
MacCloseWindow

CompareString	
MacCompareString

CopyRgn	
MacCopyRgn

DeleteMenu	
MacDeleteMenu

DrawMenuBar	
MacDrawMenuBar

DrawText	
MacDrawText

EqualRect	
MacEqualRect

EqualRgn	
MacEqualRgn

FillRect	
MacFillRect

FillRgn	
MacFillRgn

FindWindow	
MacFindWindow

FlushInstructionCache	
MacFlushInstructionCache

FrameRect	
MacFrameRect

FrameRgn	
MacFrameRgn

GetClassInfo	
MacGetClassInfo

GetCurrentThread	
MacGetCurrentThread

GetCursor	
MacGetCursor

GetDoubleClickTime	
MacGetDoubleClickTime

GetFileSize	
MacGetFileSize

GetItem	
MacGetItem

GetMenu	
MacGetMenu

GetNextWindow	
MacGetNextWindow

GetParent	
MacGetParent

GetPath	
MacGetPath

GetPixel	
MacGetPixel

InsertMenu	
MacInsertMenu

InsertMenuItem	
MacInsertMenuItem

InsetRect	
MacInsetRect

InvertRect	
MacInvertRect

InvertRgn	
MacInvertRgn

IsWindowVisible	
MacIsWindowVisible

LineTo	
MacLineTo

LoadResource	
MacLoadResource

MoveWindow	
MacMoveWindow

OffsetRect	
MacOffsetRect

OffsetRgn	
MacOffsetRgn

OpenDriver	
MacOpenDriver

PaintRgn	
MacPaintRgn

Polygon	
MacPolygon

PtInRect	
MacPtInRect

Region	
MacRegion

ReplaceText	
MacReplaceText

ResizePalette	
MacResizePalette

SendMessage	
MacSendMessage

SetCursor	
MacSetCursor

SetItem	
MacSetItem

SetPort	
MacSetPort

SetRect	
MacSetRect

SetRectRgn	
MacSetRectRgn

ShowCursor	
MacShowCursor

ShowWindow	
MacShowWindow

StartSound	
MacStartSound

StopSound	
MacStopSound

TokenType	
MacTokenType

UnionRect	
MacUnionRect

UnionRgn	
MacUnionRgn

XorRgn	
MacXorRgn*/
#define 	MacSetCursor SetCursor
#define 	MacGetCursor GetCursor
#define     MacSetPort      SetPort
#define     MacPtInRect      PtInRect	
#define     MacSetRect       SetRect	
#define       MacInsetRect InsetRect	
#define MacOffsetRect OffsetRect	
#define MacEqualRect EqualRect	
#define MacPaintRgn PaintRgn	


/*Pixel Formats

enum {
   k16LE555PixelFormat = 'L555',
   k16LE5551PixelFormat = '5551',
   k16BE565PixelFormat = 'B565',
   k16LE565PixelFormat = 'L565',
   k24BGRPixelFormat = '24BG',
   k32BGRAPixelFormat = 'BGRA',
   k32ABGRPixelFormat = 'ABGR',
   k32RGBAPixelFormat = 'RGBA',
   kYUVSPixelFormat = 'yuvs',
   kYUVUPixelFormat = 'yuvu',
   kYVU9PixelFormat = 'YVU9',
   kYUV411PixelFormat = 'Y411',
   kYVYU422PixelFormat = 'YVYU',
   kUYVY422PixelFormat = 'UYVY',
   kYUV211PixelFormat = 'Y211',
   k2vuyPixelFormat = '2vuy'
};*/
enum {
   k16LE555PixelFormat = 'L555',
   k16LE5551PixelFormat = '5551',
   k16BE565PixelFormat = 'B565',
   k16LE565PixelFormat = 'L565',
   k24BGRPixelFormat = '24BG',
   k32BGRAPixelFormat = 'BGRA',
   k32ABGRPixelFormat = 'ABGR',
   k32RGBAPixelFormat = 'RGBA',
   kYUVSPixelFormat = 'yuvs',
   kYUVUPixelFormat = 'yuvu',
   kYVU9PixelFormat = 'YVU9',
   kYUV411PixelFormat = 'Y411',
   kYVYU422PixelFormat = 'YVYU',
   kUYVY422PixelFormat = 'UYVY',
   kYUV211PixelFormat = 'Y211',
   k2vuyPixelFormat = '2vuy'
};


/*k1MonochromePixelFormat

enum {
   k1MonochromePixelFormat = 0x00000001,
   k2IndexedPixelFormat = 0x00000002,
   k4IndexedPixelFormat = 0x00000004,
   k8IndexedPixelFormat = 0x00000008,
   k16BE555PixelFormat = 0x00000010,
   k24RGBPixelFormat = 0x00000018,
   k32ARGBPixelFormat = 0x00000020,
   k1IndexedGrayPixelFormat = 0x00000021,
   k2IndexedGrayPixelFormat = 0x00000022,
   k4IndexedGrayPixelFormat = 0x00000024,
   k8IndexedGrayPixelFormat = 0x00000028
};*/
enum {
   k1MonochromePixelFormat = 0x00000001,
   k2IndexedPixelFormat = 0x00000002,
   k4IndexedPixelFormat = 0x00000004,
   k8IndexedPixelFormat = 0x00000008,
   k16BE555PixelFormat = 0x00000010,
   k24RGBPixelFormat = 0x00000018,
   k32ARGBPixelFormat = 0x00000020,
   k1IndexedGrayPixelFormat = 0x00000021,
   k2IndexedGrayPixelFormat = 0x00000022,
   k4IndexedGrayPixelFormat = 0x00000024,
   k8IndexedGrayPixelFormat = 0x00000028
};

/*Source, Pattern, and Arithmetic Transfer Mode Constants

enum {
   srcCopy = 0,
   srcOr = 1,
   srcXor = 2,
   srcBic = 3,
   notSrcCopy = 4,
   notSrcOr = 5,
   notSrcXor = 6,
   notSrcBic = 7,
   patCopy = 8,
   patOr = 9,
   patXor = 10,
   patBic = 11,
   notPatCopy = 12,
   notPatOr = 13,
   notPatXor = 14,
   notPatBic = 15,
   grayishTextOr = 49,
   hilitetransfermode = 50,
   hilite = 50,
   blend = 32,
   addPin = 33,
   addOver = 34,
   subPin = 35,
   addMax = 37,
   adMax = 37,
   subOver = 38,
   adMin = 39,
   ditherCopy = 64,
   transparent = 36
};
Constants
srcCopy

For basic graphics ports, force the destination pixel black where the source pixel is black; where the source pixel is white, force the destination pixel white.

For color graphics ports, determines how close the color of the source pixel is to black, and assigns this relative amount of foreground color to the destination pixel. Determines how close the color of the source pixel is to white, and assigns this relative amount of background color to the destination pixel.

Available in Mac OS X v10.0 and later.
srcOr

For basic graphics ports, forces the destination pixel black if the source pixel is black; where the source pixel is white, leaves the destination pixel unaltered.

For color graphics ports, determines how close the color of the source pixel is to black, and assigns this relative amount of foreground color to the destination pixel.

Available in Mac OS X v10.0 and later.
srcXor

For basic and color graphics ports, inverts destination pixel where the source pixel is black. For a basic graphics port, where the source pixel is white, leaves the destination pixel unaltered. 

For a color graphics port, for a colored destination pixel, uses the complement of its color if the pixel is direct, or inverts its index if the pixel is indexed.

Available in Mac OS X v10.0 and later.
srcBic

For a basic graphics port, forces destination pixel white where source pixel is black; where source pixel is white, leaves the destination pixel unaltered.

For a color graphics port, determines how close the color of the source pixel is to black, and assigns this relative amount of background color to the destination pixel.

Available in Mac OS X v10.0 and later.
notSrcCopy

For a basic graphics port, forces the destination pixel white where the source pixel is black; where the source pixel is white, forces the destination pixel black.

For a color graphics port, determines how close the color of the source pixel is to black, and assigns this relative amount of background color to the destination pixel. Determines how close the color of the source pixel is to white, and assigns this relative amount of foreground color to the destination pixel.

Available in Mac OS X v10.0 and later.
notSrcOr

For a basic graphics port, leaves the destination pixel unaltered where the source pixel is black; where the source pixel is white, forces the destination pixel black.

For a color graphics port, determines how close the color of the source pixel is to white, and assigns this relative amount of foreground color to the destination pixel.

Available in Mac OS X v10.0 and later.
notSrcXor

For basic and color graphics ports, where the source pixel is white, inverts the destination pixel. For a basic graphics port, where the source pixel is black, leaves the destination pixel unaltered.

For a color graphics port, for a colored destination pixel, uses the complement of its color if the pixel is direct, or inverts its index if the pixel is indexed.

Available in Mac OS X v10.0 and later.
notSrcBic

For a basic graphics port, where the source pixel is black, leaves the destination pixel unaltered; where the source pixel is white, forces the destination pixel white.

For a color graphics port, determines how close the color of the source pixel is to white, and assigns this relative amount of background color to the destination pixel.

Available in Mac OS X v10.0 and later.
patCopy

Where the pattern pixel is black, applies foreground color to the destination pixel; where the pattern pixel is white, applies background color to the destination pixel.

Available in Mac OS X v10.0 and later.
patOr

Where the pattern pixel is black, inverts the destination pixel; where the pattern pixel is white, leaves the destination pixel unaltered.

Available in Mac OS X v10.0 and later.
patXor

Where the pattern pixel is black, inverts the destination pixel; where the pattern pixel is white, leaves the destination pixel unaltered.

Available in Mac OS X v10.0 and later.
patBic

Where the pattern pixel is black, applies the background color to destination pixel; where the pattern pixel is white, leaves the destination pixel unaltered.

Available in Mac OS X v10.0 and later.
notPatCopy

Where the pattern pixel is black, applies background color to destination pixel; where the pattern pixel is white, applies foreground color to the destination pixel

Available in Mac OS X v10.0 and later.
notPatOr

Where the pattern pixel is black, leaves the destination pixel unaltered; where the pattern pixel is white, applies foreground color to the destination pixel

Available in Mac OS X v10.0 and later.
notPatXor

Where the pattern pixel is black, leaves the destination pixel unaltered; where the pattern pixel is white, inverts the destination pixel

Available in Mac OS X v10.0 and later.
notPatBic

Where the pattern pixel is black, leaves the destination pixel unaltered; where the pattern pixel is white, applies background color to the destination pixel.

Available in Mac OS X v10.0 and later.
grayishTextOr

Draws dimmed text on the screen. You can use it for black-and-white or color graphics ports. The grayishTextOr transfer mode is not considered a standard transfer mode because currently it is not stored in pictures, and printing with it is undefined. (It does not pass through the QuickDraw bottleneck functions.)

Available in Mac OS X v10.0 and later.
hilite

Adds highlighting to the source or pattern mode. With highlighting, QuickDraw replaces the background color with the highlight color when your application copies images between graphics ports. This has the visual effect of using a highlighting pen to select the object. (The global variable HiliteRGB is read from parameter RAM when the machine starts. Basic graphics ports use the color stored in the HiliteRGB global variable as the highlight color. Color graphics ports default to the HiliteRGB global variable, but can be overridden by the HiliteColor function.)

For text, specifies that the caret position should be determined according to the primary line direction, based on the value of SysDirection.

Available in Mac OS X v10.0 and later.
blend

Replaces the destination pixel with a blend of the source and destination pixel colors. If the destination is a bitmap or 1-bit pixel map, reverts to srcCopy mode.

Available in Mac OS X v10.0 and later.
addPin

Replaces the destination pixel with the sum of the source and destination pixel colors-- up to a maximum allowable values. If the destination is a bitmap or 1-bit pixel map, reverts to srcBic mode.

Available in Mac OS X v10.0 and later.
addOver

Replaces the destination pixel with the sum of the source and destination pixel colors, except if the value of the red, green, or blue component exceeds 65,536, then addOver subtracts 65,536 from that value. If the destination is a bitmap or 1-bit pixel map, reverts to srcXor mode.

Available in Mac OS X v10.0 and later.
subPin

Replaces the destination pixel with the difference of the source and destination pixel colors, but not less than a minimum allowable value. If the destination is a bitmap or 1-bit pixel map, reverts to srcOr mode.

Available in Mac OS X v10.0 and later.
addMax

Compares the source and destination pixels, and replaces the destination pixel with the color containing the greater saturation of each of the RGB components. If the destination is a bitmap or 1-bit pixel map, reverts to srcBic mode.

Available in Mac OS X v10.0 and later.
subOver

Replaces the destination pixel with the difference of the source and destination pixel colors, except if the value of the red, green, or blue component is less than 0, then it adds the negative result to 65,536. if the destination is a bitmap or 1-bit pixel map, revert to srcXor mode.

Available in Mac OS X v10.0 and later.
adMin

Compares the source and destination pixels, and replaces the destination pixel with the color containing the lesser saturation of each of the RGB components. If the destination is a bitmap or 1-bit pixel map, reverts to srcOr mode.

Available in Mac OS X v10.0 and later.
ditherCopy

On computers running System 7, you can add dithering to any source mode by adding this constant or the value it represents to the source mode.

Dithering is a technique that mixes existing colors to create the effect of additional colors. It also improves images that you shrink or that you copy from a direct pixel device to an indexed device.

Available in Mac OS X v10.0 and later.
transparent

Replaces the destination pixel with the source pixel if the source pixel is not equal to the background color. The transparent mode replaces the destination pixel with the source pixel if the source pixel isn’t equal to the background color. This mode is most useful in 8-bit, 4-bit, or 2-bit color modes.

Available in Mac OS X v10.0 and later.
Discussion

CopyBits uses the source and arithmetic transfer mode constants in the mode parameter to specify the manner in which pixels are transferred from a source pixel map to a destination pixel map.

PenMode uses the pattern mode constants in the mode parameter to specify source modes for transferring the bits from a source bitmap to a destination bitmap.

The TextMode function uses these constants to set the transfer mode in the graphics port txMode field. 

The transfer mode determines the interplay between what an application is drawing (the source) and what already exists on the display device (the destination), resulting in the text display.

There are two basic kinds of modes: pattern ( pat) and source ( src). 

The pattern mode constants are patCopy, patOr, patXor, patBic, notPatCopy, notPatOr, notPatXor, and notPatBic.

Source is the kind that you use for drawing text. There are four basic Boolean operations: Copy, Or, Xor, and Bic (bit clear), each of which has an inverse variant in which the source is inverted before the transfer, yielding eight operations in all. Basic QuickDraw supports these eight transfer modes. Color QuickDraw interprets the source mode constants differently than basic QuickDraw does. Color QuickDraw enables your application to achieve color effects within those basic transfer modes, and offers an additional set of transfer modes that perform arithmetic operations on the RGB values of the source and destination pixels. Other transfer modes are grayishTextOr, transparent mode, and text mask mode.

The arithmetic transfer modes are addOver, addPin, subOver, subPin, addMax, adMax, adMin, and blend. For color, the arithmetic modes change the destination pixels by performing arithmetic operations on the source and destination pixels. Arithmetic transfer modes calculate pixel values by adding, subtracting, or averaging the RGB components of the source and destination pixels. They are most useful for 8-bit color, but they work on 4-bit and 2-bit color also. When the destination bitmap is one bit deep, the mode reverts to the basic transfer mode that best approximates the arithmetic mode requested.*/
enum {
   srcCopy = 0,
   srcOr = 1,
   srcXor = 2,
   srcBic = 3,
   notSrcCopy = 4,
   notSrcOr = 5,
   notSrcXor = 6,
   notSrcBic = 7,
   patCopy = 8,
   patOr = 9,
   patXor = 10,
   patBic = 11,
   notPatCopy = 12,
   notPatOr = 13,
   notPatXor = 14,
   notPatBic = 15,
   grayishTextOr = 49,
   hilitetransfermode = 50,
   hilite = 50,
   blend = 32,
   addPin = 33,
   addOver = 34,
   subPin = 35,
   addMax = 37,
   adMax = 37,
   subOver = 38,
   adMin = 39,
   ditherCopy = 64,
   transparent = 36
};


/*RgnHandle

typedef struct OpaqueRgnHandle * RgnHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueRgnHandle * RgnHandle;

/*BitMap

struct BitMap {
   Ptr baseAddr;
   short rowBytes;
   Rect bounds;
};
typedef struct BitMap BitMap;
typedef BitMap * BitMapPtr;
Fields
baseAddr

A pointer to the beginning of the bit image.
rowBytes

The offset in bytes from one row of the image to the next. The value of the rowBytes field must be less than $4000.
bounds

The bitmap’s boundary rectangle by default, the entire main screen.
Discussion

A bitmap, which is a data structure of type BitMap, defines a bit image in terms of the QuickDraw coordinate plane. (A bit image is a collection of bits in memory that form a grid.)

A bitmap has three parts: a pointer to a bit image, the row width of that image, and a boundary rectangle that links the local coordinate system of a graphics port to QuickDraw’s global coordinate system and defines the area of the bit image into which QuickDraw can draw.

The width of the boundary rectangle determines how many bits of one row are logically owned by the bitmap. This width must not exceed the number of bits in each row of the bit image. The height of the boundary rectangle determines how many rows of the image are logically owned by the bitmap. The number of rows enclosed by the boundary rectangle must not exceed the number of rows in the bit image.

The boundary rectangle defines the local coordinate system used by the port rectangle for a graphics port (described next). The upper-left corner (which for a window is called the window origin) of the port rectangle usually has a vertical coordinate of 0 and a horizontal coordinate of 0, although you can use the function SetOrigin to change the coordinates of the window origin. 
Availability
Available in Mac OS X v10.0 and later.*/
struct BitMap {
   Ptr baseAddr;
   short rowBytes;
   Rect bounds;
};
typedef struct BitMap BitMap;
typedef BitMap * BitMapPtr;

/*GrafPtr

typedef struct OpaqueGrafPtr * GrafPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueGrafPtr * GrafPtr;

/*CGrafPtr

typedef GrafPtr CGrafPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef GrafPtr CGrafPtr;

/*ITab

struct ITab {
   long iTabSeed;
   short iTabRes;
   Byte iTTable[1];
};
typedef struct ITab ITab;
typedef ITab * ITabPtr;
typedef ITabPtr * ITabHandle;
Fields
iTabSeed

The iTabSeed value, initially set from the corresponding CLUT’s ctSeed field. If at any time these do not match, then the color table was changed, and the inverse table needs to be rebuilt.
iTabRes

The resolution of this inverse table.
iTTable

An array of index values. The size of the iTabTable field in bytes is 23*iTabRes.
Discussion

The ITab data structure contains the inverse table information that the Color Manager uses for fast mapping of RGB color values. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ITab {
   long iTabSeed;
   short iTabRes;
   Byte iTTable[1];
};
typedef struct ITab ITab;
typedef ITab * ITabPtr;
typedef ITabPtr * ITabHandle;



/*RGBColor

struct RGBColor {
   unsigned short red;
   unsigned short green;
   unsigned short blue;
};
typedef struct RGBColor RGBColor;
typedef RGBColor * RGBColorPtr;
Fields
red

An unsigned integer specifying the red value of the color.
green

An unsigned integer specifying the green value of the color.
blue

An unsigned integer specifying the blue value of the color.
Discussion

You usually specify a color to QuickDraw by creating an RGBColor structure in which you assign the red, green, and blue values of the foreground color. For example, when you want to set the foreground color for drawing, you create an RGBColor structure that defines the foreground color you desire; then you pass that structure as a parameter to the RGBForeColor function. 

In an RGBColor structure, three 16-bit unsigned integers give the intensity values for the three additive primary colors. 
Availability
Available in Mac OS X v10.0 and later.*/
struct RGBColor {
   unsigned short red;
   unsigned short green;
   unsigned short blue;
};
typedef struct RGBColor RGBColor;
typedef RGBColor * RGBColorPtr;


/*ColorSpec

struct ColorSpec {
   short value;
   RGBColor rgb;
};
typedef struct ColorSpec ColorSpec;
typedef ColorSpec * ColorSpecPtr;
Fields
value

The pixel value assigned by QuickDraw for the color specified in the rgb field of this structure. QuickDraw assigns a pixel value based on the capabilities of the user’s screen. For indexed devices, the pixel value is an index number assigned by QuickDraw to the closest color available on the indexed device for direct devices, this value expresses the best available red, green, and blue values for the color on the direct device.
rgb

An RGBColor structure that fully specifies the color whose approximation QuickDraw specifies in the value field. 
Discussion

When creating a PixMap structure for an indexed device, QuickDraw creates a ColorTable structure that defines the best colors available for the pixel image on that graphics device. QuickDraw also stores a ColorTable structure for the currently available colors in the graphics device’s CLUT. 

One of the fields in a ColorTable structure requires a value of type cSpecArray, which is defined as an array of ColorSpec structures. Typically, your application never needs to create ColorTable structures or ColorSpec structures. For completeness, the data structure of type ColorSpec is shown here. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ColorSpec {
   short value;
   RGBColor rgb;
};
typedef struct ColorSpec ColorSpec;
typedef ColorSpec * ColorSpecPtr;

/*CSpecArray

typedef ColorSpec CSpecArray[1];
Availability
Available in Mac OS X v10.0 and later.*/
typedef ColorSpec CSpecArray[1];


/*ColorTable

struct ColorTable {
   long ctSeed;
   short ctFlags;
   short ctSize;
   CSpecArray ctTable;
};
typedef struct ColorTable ColorTable;
typedef ColorTable * CTabPtr;
typedef CTabPtr * CTabHandle;
Fields
ctSeed

Identifies a particular instance of a color table. QuickDraw uses the ctSeed value to compare an indexed device’s color table with its associated inverse table (a table it uses for fast color lookup).When the color table for a graphics device has been changed, QuickDraw needs to rebuild the inverse table.
ctFlags

Flags that distinguish pixel map color tables from color tables in GDevice structures.
ctSize

One less than the number of entries in the table.
ctTable

An array of ColorSpec entries, each containing a pixel value and a color specified by an RGBColor structure. 
Discussion

When creating a PixMap structure for a particular graphics device, QuickDraw creates a ColorTable structure that defines the best colors available for the pixel image on that particular graphics device. QuickDraw also creates a ColorTable structure of all available colors for use by the CLUT on indexed devices.

Typically, your application needs to create ColorTable structures only if it uses the Palette Manager. 

Your application should never need to directly change the fields of a ColorTable structure. If you find it absolutely necessary for your application to do so, immediately use the CTabChanged function to notify QuickDraw that your application has changed the ColorTable structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ColorTable {
   long ctSeed;
   short ctFlags;
   short ctSize;
   CSpecArray ctTable;
};
typedef struct ColorTable ColorTable;
typedef ColorTable * CTabPtr;
typedef CTabPtr * CTabHandle;



/*CTabPtr

Abst_CTabPtr

typedef ColorTable * CTabPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ColorTable * CTabPtr;

/*CTabHandle

Abst_CTabHandle

typedef CTabPtr * CTabHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef CTabPtr * CTabHandle;



/*PixMap

Contains information about the dimensions and contents of a pixel image, as well as its storage format, depth, resolution, and color usage.

struct PixMap {
   Ptr           baseAddr;
   short         rowBytes;
   Rect          bounds;
   short         pmVersion;
   short         packType;
   long          packSize;
   Fixed         hRes;
   Fixed         vRes;
   short         pixelType;
   short         pixelSize;
   short         cmpCount;
   short         cmpSize;
   OSType        pixelFormat;
   CTabHandle    pmTable;
   void *        pmExt;
};
Fields
baseAddr
Discussion

For an onscreen pixel image, a pointer to the first byte of the image. For optimal performance, this should be a multiple of 4. The baseAddr field of the PixMap record for an offscreen graphics world contains a handle instead of a pointer. Your application should never directly access the baseAddr field of the PixMap record for an offscreen graphics world.
rowBytes
Discussion

The offset in bytes from one row of the image to the next. The value must be even, less than 0x4000, and for best performance it should be a multiple of 4. The high 2 bits of rowBytes are used as flags. If bit 15 =1, the data structure pointed to is a PixMap structure; otherwise it is a BitMap structure.
bounds
Discussion

The boundary rectangle, which links the local coordinate system of a graphics port to QuickDraw's global coordinate system and defines the area of the bit image into which QuickDraw can draw. By default, the boundary rectangle is the entire main screen. Do not use the value of this field to determine the size of the screen; instead use the value of the gdRect field of the GDevice structure for the screen.
pmVersion
Discussion

The version number of Color QuickDraw that created this PixMap structure. The value of pmVersion is normally 0. If pmVersion is 4, Color QuickDraw treats the PixMap record's baseAddr field as 32-bit clean. All other flags are private. Most applications never need to set this field
packType
Discussion

The packing algorithm used to compress image data. Color QuickDraw currently supports a packType of 0, which means no packing, and values of 1 to 4 for packing direct pixels.
packSize
Discussion

The size of the packed image in bytes. When the packType field contains the value 0, this field is always set to 0.
hRes
Discussion

The horizontal resolution of the pixel image in pixels per inch. By default, this value is 0x00480000 (for 72 pixels per inch).
vRes
Discussion

The vertical resolution of the pixel image in pixels per inch. By default, this value is 0x00480000 (for 72 pixels per inch).
pixelType
Discussion

The storage format for a pixel image. Indexed pixels are indicated by a value of 0. Direct pixels are specified by a value of RGBDirect, or 16. In the PixMap record of the GDevice structure for a direct device, this field is set to RGBDirect when the screen depth is set.
pixelSize
Discussion

The number of bits used to represent a pixel. Indexed pixels can have sizes of 1, 2, 4, and 8 bits; direct pixel sizes are 16 and 32 bits.
cmpCount
Discussion

The number of components used to represent a color for a pixel. With indexed pixels, each pixel is a single value representing an index in a color table, and therefore this field contains the value 1; the index is the single component. With direct pixels, each pixel contains three components (one integer each for the intensities of red, green, and blue) so this field contains the value 3.
cmpSize
Discussion

The size in bits of each component for a pixel. Color QuickDraw expects that the sizes of all components are the same, and that the value of the cmpCount field multiplied by the value of the cmpSize field is less than or equal to the value in the pixelSize field.

For an indexed pixel value, which has only one component, the value of the cmpSize field is the same as the value of the pixelSize field; that is, 1, 2, 4, or 8. For direct pixels there are two additional possibilities. A 16-bit pixel, which has three components, has a cmpSize value of 5; this leaves an unused high-order bit, which Color QuickDraw sets to 0. A 32-bit pixel, which has three components (red, green, and blue), has a cmpSize value of 8; this leaves an unused high-order byte, which Color QuickDraw sets to 0.

If presented with a 32-bit image (for example, in the CopyBits procedure) Color QuickDraw passes whatever bits are there, and it does not set the high byte to 0. Generally, therefore, your application should clear the memory for the image to 0 before creating a 16-bit or 32-bit image.
planeBytes
Discussion

The offset in bytes from one drawing plane to the next. This field is set to 0.
pmTable
Discussion

A handle to a ColorTable structure for the colors in this pixel map.
pmReserved
Discussion

Reserved. This field must be set to 0 for future compatibility.
pixelFormat
Discussion

The way the pixels are arranged; see Pixel Formats.
pmTable
Discussion

Color map for this structure.
pmExt
Discussion

Handle to a PixMapExtension structure. Set to NIL if there is no extension.
Discussion

The pixel map for a window's color graphics port always consists of the pixel depth, color table, and boundary rectangle of the main screen, even if the window is created on or moved to an entirely different screen.
Version Notes

Earlier versions of this structure were different in the last three fields; see the C interface file for details.
Programming Info
C interface file: Quickdraw.h*/
struct PixMap {
   Ptr           baseAddr;
   short         rowBytes;
   Rect          bounds;
   short         pmVersion;
   short         packType;
   long          packSize;
   Fixed         hRes;
   Fixed         vRes;
   short         pixelType;
   short         pixelSize;
   short         cmpCount;
   short         cmpSize;
   OSType        pixelFormat;
   CTabHandle    pmTable;
   void *        pmExt;
};
typedef  struct PixMap PixMap;



/*PixMapPtr

Abst_PixMapPtr

typedef PixMap * PixMapPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef PixMap * PixMapPtr;

/*PixMapHandle

Abst_PixMapHandle

typedef PixMapPtr * PixMapHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef PixMapPtr * PixMapHandle;


/*GDevice

struct GDevice {
   short gdRefNum;
   short gdID;
   short gdType;
   ITabHandle gdITable;
   short gdResPref;
   SProcHndl gdSearchProc;
   CProcHndl gdCompProc;
   short gdFlags;
   PixMapHandle gdPMap;
   long gdRefCon;
   GDHandle gdNextGD;
   Rect gdRect;
   long gdMode;
   short gdCCBytes;
   short gdCCDepth;
   Handle gdCCXData;
   Handle gdCCXMask;
   long gdReserved;
};
typedef struct GDevice GDevice;
typedef GDevice * GDPtr;
typedef GDPtr * GDHandle;
Fields
gdRefNum

The reference number of the driver for the screen associated with the video device. For most video devices, this information is set at system startup time.
gdID

Reserved. If you create your own GDevice structure, set this field to 0.
gdType

The general type of graphics device. See Graphics Device Type Constants for a description of the values which you can use in this field.
gdITable

A handle to the inverse table for color mapping. 
gdResPref

The preferred resolution for inverse tables.
gdSearchProc

A handle to the list of search functions. Its value is NULL for the default function. 
gdCompProc

A handle to a list of complement functions. Its value is NULL for the default function. 
gdFlags

The GDevice structure’s attributes. To set the attribute bits in the gdFlags field, use the SetDeviceAttribute function. Do not set gdFlags directly in the GDevice structure.
gdPMap

A handle to a PixMap structure giving the dimension of the image buffer, along with the characteristics of the graphics device (resolution, storage format, color depth, and color table). For GDevice structures, the high bit of the global variable 

(((**TheGDevice).**gdPMap).**pmTable).ctFlags

is always set.

gdRefCon

A value used by system software to pass device-related parameters. Since a graphics device is shared, do not store data here.
gdNextGD

A handle to the next graphics device in the device list. If this is the last graphics device in the device list, the field contains 0. 
gdRect

The boundary rectangle of the graphics device represented by the GDevice structure. The main screen has the upper-left corner of the rectangle set to (0,0). All other graphics devices are relative to this point.
gdMode

The current setting for the graphics device mode. This value is passed to the video driver to set its pixel depth and to specify color or black and white; applications do not need this information.
gdCCBytes

The rowBytes value of the expanded cursor. Your application should not change this field.
gdCCDepth

The depth of the expanded cursor. Your application should not change this field.
gdCCXData

A handle to the cursor’s expanded data. Your application should not change this field.
gdCCXMask

A handle to the cursor’s expanded mask. Your application should not change this field.
gdReserved

Reserved for future expansion; it must be set to 0 for future compatibility.
Discussion

Color QuickDraw stores state information for video devices and offscreen graphics worlds in GDevice structures. When the system starts up, it allocates and initializes one handle to a GDevice structure for each video device it finds. When you use the Offscreen Graphics Devices function, NewGWorld, Color QuickDraw automatically creates a GDevice structure for the new offscreen graphics world. The system links these GDevice structures in a list, called the device list. (You can find a handle to the first element in the device list in the global variable DeviceList.) By default, the GDevice structure corresponding to the first video device found is marked as the current device. All other graphics devices in the list are initially marked as inactive. 

When the user moves a window or creates a window on another screen, and your application draws into that window, Color QuickDraw automatically makes the video device for that screen the current device. Color QuickDraw stores that information in the global variable TheGDevice. 

GDevice structures that correspond to video devices have drivers associated with them. These drivers can be used to change the mode of the video device from black and white to color and to change the pixel depth. Application-created GDevice structures usually don’t require drivers. 

Your application should never need to directly change the fields of a GDevice structure. If you find it absolutely necessary for your application to so, immediately use the GDeviceChanged function to notify QuickDraw that your application has changed the GDevice structure. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct GDevice GDevice;
typedef GDevice * GDPtr;
typedef GDPtr * GDHandle;

struct GDevice {
   short gdRefNum;
   short gdID;
   short gdType;
   ITabHandle gdITable;
   short gdResPref;
   SProcHndl gdSearchProc;
   CProcHndl gdCompProc;
   short gdFlags;
   PixMapHandle gdPMap;
   long gdRefCon;
   GDHandle gdNextGD;
   //int  gdNextGD; //hys
   Rect gdRect;
   long gdMode;
   short gdCCBytes;
   short gdCCDepth;
   Handle gdCCXData;
   Handle gdCCXMask;
   long gdReserved;
};





/*Picture

struct Picture {
   short picSize;
   Rect picFrame;
};
typedef struct Picture Picture;
typedef Picture * PicPtr;
typedef PicPtr * PicHandle;
Fields
picSize

The size of the rest of this structure for a version 1 picture. To maintain compatibility with the version 1 picture format, the picSize field was not changed for the version 2 picture or extended version 2 formats. The information in this field is used only for version 1 pictures, which cannot exceed 32 KB in size. Because version 2 and extended version 2 pictures can be much larger than the 32 KB limit imposed by the 2-byte picSize field, you should use the Memory Manager function GetHandleSize to determine the size of a picture in memory; you should use the File Manager function PBGetFInfo to determine the size of a picture in a 'PICT' file; and you should use the Resource Manager function GetMaxResourceSize to determine the size of a 'PICT' resource.
picFrame

The bounding rectangle for the picture defined in the rest of this structure. The DrawPicture function uses this rectangle to scale the picture if you draw it into a destination rectangle of a different size.
Discussion

When you use the OpenCPicture or OpenPicture function, QuickDraw begins collecting your subsequent drawing commands in a Picture structure. (You use the ClosePicture function to complete a picture definition.) When you use the GetPicture function to retrieve a picture stored in a resource, GetPicture reads the resource into memory as a Picture structure. By using the DrawPicture procedure, you can draw onscreen the picture defined by the commands stored in the Picture structure.

A picture opcode is a number that the DrawPicture function uses to determine what object to draw or what mode to change for subsequent drawing. Generally, donot read or write this picture data directly. Instead, use the OpenCPicture (or OpenPicture), ClosePicture, and DrawPicture functions to process these opcodes.

The Picture structure can also contain picture comments. Created by applications using the PicComment function, picture comments contain data or commands for special processing by output devices, such as PostScript printers. 

You can use File Manager functions to save the picture in a file of type 'PICT', you can use Resource Manager functions to save the picture in a resource of type 'PICT', and you can use the Scrap Manager function PutScrap to store the picture in 'PICT' scrap format. 
Availability
Available in Mac OS X v10.0 and later.*/
struct Picture {
   short picSize;
   Rect picFrame;
};
typedef struct Picture Picture;
typedef Picture * PicPtr;
typedef PicPtr * PicHandle;

/*PicPtr

Abst_PicPtr

typedef Picture * PicPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Picture * PicPtr;

/*PicHandle

Abst_PicHandle

typedef PicPtr * PicHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef PicPtr * PicHandle;

/*GrafPtr

typedef struct OpaqueGrafPtr * GrafPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueGrafPtr * GrafPtr;

/*WindowPtr

Defines a window pointer. 

typedef struct OpaqueWindowPtr * WindowPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueWindowPtr * WindowPtr;

/*WindowRef

Represents a window. 

typedef WindowPtr WindowRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef WindowPtr WindowRef;

/*DialogPtr

typedef struct OpaqueDialogPtr * DialogPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueDialogPtr * DialogPtr;

/*Pattern

struct Pattern {
   UInt8 pat[8];
};
typedef struct Pattern Pattern;
typedef Pattern * PatPtr;
typedef PatPtr * PatHandle;
Discussion

Your application typically does not create Pattern structures. Although you can create Pattern structures in your program code, it is usually easier to create bit patterns using the pattern, ‘PAT’, or pattern list, ‘PAT#’, resource.

A bit pattern is a 64-bit image, organized as an 8-by-8 bit square, that defines a repeating design or tone. When a pattern is drawn, it is aligned so that adjacent areas of the same pattern in the same graphics port form a continuous, coordinated pattern. QuickDraw provides predefined patterns in global variables named white, black, gray, ltGray, and dkGray. The row width of a pattern is 1 byte. 
Availability
Available in Mac OS X v10.0 and later.*/
struct Pattern {
   UInt8 pat[8];
};
typedef struct Pattern Pattern;
typedef Pattern * PatPtr;
typedef PatPtr * PatHandle;

/*PenState

struct PenState {
   Point pnLoc;
   Point pnSize;
   short pnMode;
   Pattern pnPat;
};
typedef struct PenState PenState;
Fields
pnLoc

For the current graphics port at the time the GetPenState function was called, the value of that graphics port’s pnLoc field. This value is the point where QuickDraw begins drawing next. The location of the graphics pen is a point in the graphics port’s coordinate system, not a pixel in a bit image. The upper-left corner of the pen is at the pen location the graphics pen hangs below and to the right of this point.
pnSize

For the current graphics port at the time the GetPenState function was called, the value of that graphics port’s pnSize field. The graphics pen is rectangular in shape, and its width and height are specified by the values in the pnSize field. The default size is a 1-by-1 bit square; the width and height can range from 0 by 0 to 32,767 by 32,767. If either the pen width or the pen height is 0, the pen does not draw. Heights or widths of less than 0 are undefined.
pnMode

The pattern mode—that is, for the current graphics port at the time the GetPenState function was called, the value of that graphics port’s pnMode field. This value determines how the pen pattern is to affect what’s already in the bit image when lines or shapes are drawn. When the graphics pen draws, QuickDraw first determines what bits in the bit image are affected, finds their corresponding bits in the pattern, and then transfers the bits from the pattern into the image according to this mode, which specifies one of eight Boolean transfer operations. The resulting bit is stored into its proper place in the bit image.
pnPat

For the current graphics port at the time the GetPenState function was called, the pen pattern for that graphics port. This pattern determines how the bits under the graphics pen are affected when lines or shapes are drawn. 
Discussion

The GetPenState function saves the location, size, pattern, and pattern mode of the graphics pen for the current graphics port in a PenState structure, which is a data structure of type PenState. After changing the graphics pen as necessary, you can later restore these pen states with the SetPenState function. 
Availability
Available in Mac OS X v10.0 and later.*/
struct PenState {
   Point pnLoc;
   Point pnSize;
   short pnMode;
   Pattern pnPat;
};
typedef struct PenState PenState;

/*CWindowPtr

typedef WindowPtr CWindowPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef WindowPtr CWindowPtr;

/*Cursor

struct Cursor {
   Bits16 data;
   Bits16 mask;
   Point hotSpot;
};
typedef struct Cursor Cursor;
typedef Cursor * CursPtr;
Fields
data

Cursor image data, which must begin on a word boundary. 
mask

The cursor’s mask. QuickDraw uses the mask to crop the cursor’s outline into a background color or pattern. QuickDraw then draws the cursor into this shape.
hotSpot

A point in the image that aligns a point (not a bit) in the image with the mouse location on the screen. Whenever the user moves the mouse, the low-level interrupt-driven mouse functions move the cursor. When the user clicks, the Event Manager function WaitNextEvent reports the location of the cursor’s hot spot in global coordinates.
Discussion

Your application typically does not create Cursor structures. Although you can create a Cursor structure and its associated Bits16 array in your program code, it is usually easier to create a black-and-white cursor in a cursor resource,‘CURS’.

A cursor is a 256-pixel, black-and-white image in a 16-by-16 pixel square. When your application uses the GetCursor function to get a cursor from a 'CURS' resource, GetCursor loads the resource into memory as a Cursor structure. Your application then displays the color cursor by using the SetCursor function.

The cursor appears on the screen as a 16-by-16 pixel square. The appearance of each bit if the square is determined by the corresponding bits in the data and the mask and, if the mask bit is 0, by the pixel under the cursor. The four possible combinations of values for the data bit and the mask bit are:
Data bit 0, Mask bit 1The resulting pixel on the screen is white. 
Data bit 1, Mask bit 1The resulting pixel on the screen is black. 
Data bit 0, Mask bit 0The resulting pixel on the screen is the same as the pixel under the cursor. 
Data bit 1, Mask bit 0The resulting pixel on the screen is the inverse of the pixel under the cursor. 

Notice that if all mask bits are 0, the cursor is completely transparent, in that the image under the cursor can still be viewed. Pixels under the white part of the cursor appear unchanged; under the black part of the cursor, black pixels show through as white.

Basic QuickDraw supplies a predefined cursor in the global variable named arrow; this is the standard arrow cursor. 
Availability
Available in Mac OS X v10.0 and later.*/

struct Cursor {
   Bits16 data;
   Bits16 mask;
   Point hotSpot;
};
typedef struct Cursor Cursor;
typedef Cursor * CursPtr;

/*GrafPtr

typedef struct OpaqueGrafPtr * GrafPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueGrafPtr * GrafPtr;

/*QDTextProcPtr

typedef void (*QDTextProcPtr) (
   short byteCount,
   const void * textBuf,
   Point numer,
   Point denom
);

If you name your function MyQDTextProc, you would declare it like this:

void QDTextProcPtr (
   short byteCount,
   const void * textBuf,
   Point numer,
   Point denom
);*/

typedef void (*QDTextProcPtr) (
   short byteCount,
   const void * textBuf,
   Point numer,
   Point denom
);

/*QDTextUPP

typedef QDTextProcPtr QDTextUPP;*/
typedef QDTextProcPtr QDTextUPP;

/*QDLineProcPtr

typedef void (*QDLineProcPtr) (
   Point newPt
);

If you name your function MyQDLineProc, you would declare it like this:

void QDLineProcPtr (
   Point newPt
);*/
typedef void (*QDLineProcPtr) (
   Point newPt
);


/*QDLineUPP

typedef QDLineProcPtr QDLineUPP;*/
typedef QDLineProcPtr QDLineUPP;

/*QDRectProcPtr

typedef void (*QDRectProcPtr) (
   GrafVerb verb,
   const Rect * r
);

If you name your function MyQDRectProc, you would declare it like this:

void QDRectProcPtr (
   GrafVerb verb,
   const Rect * r
);*/
typedef void (*QDRectProcPtr) (
   GrafVerb verb,
   const Rect * r
);

/*QDRectUPP

typedef QDRectProcPtr QDRectUPP;*/
typedef QDRectProcPtr QDRectUPP;

/*QDRRectProcPtr

typedef void (*QDRRectProcPtr) (
   GrafVerb verb,
   const Rect * r,
   short ovalWidth,
   short ovalHeight
);

If you name your function MyQDRRectProc, you would declare it like this:

void QDRRectProcPtr (
   GrafVerb verb,
   const Rect * r,
   short ovalWidth,
   short ovalHeight
);*/
typedef void (*QDRRectProcPtr) (
   GrafVerb verb,
   const Rect * r,
   short ovalWidth,
   short ovalHeight
);


/*QDRRectUPP

typedef QDRRectProcPtr QDRRectUPP;*/
typedef QDRRectProcPtr QDRRectUPP;

/*QDOvalProcPtr

typedef void (*QDOvalProcPtr) (
   GrafVerb verb,
   const Rect * r
);

If you name your function MyQDOvalProc, you would declare it like this:

void QDOvalProcPtr (
   GrafVerb verb,
   const Rect * r
);*/
typedef void (*QDOvalProcPtr) (
   GrafVerb verb,
   const Rect * r
);



/*QDOvalUPP

typedef QDOvalProcPtr QDOvalUPP;*/
typedef QDOvalProcPtr QDOvalUPP;

/*QDArcProcPtr

typedef void (*QDArcProcPtr) (
   GrafVerb verb,
   const Rect * r,
   short startAngle,
   short arcAngle
);

If you name your function MyQDArcProc, you would declare it like this:

void QDArcProcPtr (
   GrafVerb verb,
   const Rect * r,
   short startAngle,
   short arcAngle
);*/
typedef void (*QDArcProcPtr) (
   GrafVerb verb,
   const Rect * r,
   short startAngle,
   short arcAngle
);

/*MacPolygon

struct MacPolygon {
   short polySize;
   Rect polyBBox;
   Point polyPoints[1];
};
typedef struct MacPolygon MacPolygon;
typedef MacPolygon Polygon;
typedef PolyPtr * PolyHandle;
Availability
Available in Mac OS X v10.0 and later.*/

struct MacPolygon {
   short polySize;
   Rect polyBBox;
   Point polyPoints[1];
};
typedef struct MacPolygon MacPolygon;
typedef MacPolygon Polygon;
typedef MacPolygon PolyPtr;
typedef PolyPtr * PolyHandle;


/*QDArcUPP

typedef QDArcProcPtr QDArcUPP;*/
typedef QDArcProcPtr QDArcUPP;

/*QDPolyProcPtr

typedef void (*QDPolyProcPtr) (
   GrafVerb verb,
   PolyHandle poly
);

If you name your function MyQDPolyProc, you would declare it like this:

void QDPolyProcPtr (
   GrafVerb verb,
   PolyHandle poly
);*/
typedef void (*QDPolyProcPtr) (
   GrafVerb verb,
   PolyHandle poly
);


/*QDPolyUPP

typedef QDPolyProcPtr QDPolyUPP;*/
typedef QDPolyProcPtr QDPolyUPP;

/*QDRgnProcPtr

typedef void (*QDRgnProcPtr) (
   GrafVerb verb,
   RgnHandle rgn
);

If you name your function MyQDRgnProc, you would declare it like this:

void QDRgnProcPtr (
   GrafVerb verb,
   RgnHandle rgn
);*/
typedef void (*QDRgnProcPtr) (
   GrafVerb verb,
   RgnHandle rgn
);


/*QDRgnUPP

typedef QDRgnProcPtr QDRgnUPP;*/
typedef QDRgnProcPtr QDRgnUPP;


/*QDBitsProcPtr

typedef void (*QDBitsProcPtr) (
   const BitMap * srcBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);

If you name your function MyQDBitsProc, you would declare it like this:

void QDBitsProcPtr (
   const BitMap * srcBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);*/
typedef void (*QDBitsProcPtr) (
   const BitMap * srcBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);

/*QDBitsUPP

typedef QDBitsProcPtr QDBitsUPP;*/
typedef QDBitsProcPtr QDBitsUPP;

/*QDCommentProcPtr

typedef void (*QDCommentProcPtr) (
   short kind,
   short dataSize,
   Handle dataHandle
);

If you name your function MyQDCommentProc, you would declare it like this:

void QDCommentProcPtr (
   short kind,
   short dataSize,
   Handle dataHandle
);*/
typedef void (*QDCommentProcPtr) (
   short kind,
   short dataSize,
   Handle dataHandle
);


/*QDCommentUPP

typedef QDCommentProcPtr QDCommentUPP;*/
typedef QDCommentProcPtr QDCommentUPP;

/*QDTxMeasProcPtr

typedef short (*QDTxMeasProcPtr) (
   short byteCount,
   const void * textAddr,
   Point * numer,
   Point * denom,
   FontInfo * info
);

If you name your function MyQDTxMeasProc, you would declare it like this:

short QDTxMeasProcPtr (
   short byteCount,
   const void * textAddr,
   Point * numer,
   Point * denom,
   FontInfo * info
);*/

typedef short (*QDTxMeasProcPtr) (
   short byteCount,
   const void * textAddr,
   Point * numer,
   Point * denom,
   FontInfo * info
);


/*QDTxMeasUPP

typedef QDTxMeasProcPtr QDTxMeasUPP;*/
typedef QDTxMeasProcPtr QDTxMeasUPP;

/*QDGetPicProcPtr

typedef void (*QDGetPicProcPtr) (
   void * dataPtr,
   short byteCount
);

If you name your function MyQDGetPicProc, you would declare it like this:

void QDGetPicProcPtr (
   void * dataPtr,
   short byteCount
);*/
typedef void (*QDGetPicProcPtr) (
   void * dataPtr,
   short byteCount
);

/*QDGetPicUPP

typedef QDGetPicProcPtr QDGetPicUPP;*/
typedef QDGetPicProcPtr QDGetPicUPP;

/*QDPutPicProcPtr

typedef void (*QDPutPicProcPtr) (
   const void * dataPtr,
   short byteCount
);

If you name your function MyQDPutPicProc, you would declare it like this:

void QDPutPicProcPtr (
   const void * dataPtr,
   short byteCount
);*/
typedef void (*QDPutPicProcPtr) (
   const void * dataPtr,
   short byteCount
);


/*QDPutPicUPP

typedef QDPutPicProcPtr QDPutPicUPP;*/
typedef QDPutPicProcPtr QDPutPicUPP;

/*QDProcs

struct QDProcs {
   QDTextUPP textProc;
   QDLineUPP lineProc;
   QDRectUPP rectProc;
   QDRRectUPP rRectProc;
   QDOvalUPP ovalProc;
   QDArcUPP arcProc;
   QDPolyUPP polyProc;
   QDRgnUPP rgnProc;
   QDBitsUPP bitsProc;
   QDCommentUPP commentProc;
   QDTxMeasUPP txMeasProc;
   QDGetPicUPP getPicProc;
   QDPutPicUPP putPicProc;
};
typedef struct QDProcs QDProcs;
typedef QDProcs * QDProcsPtr;
Fields
textProc

A pointer to the low-level function that draws text. The standard QuickDraw function is the StdText function. 
lineProc

A pointer to the low-level function that draws lines. The standard QuickDraw function is the StdLine function. 
rectProc

A pointer to the low-level function that draws rectangles. The standard QuickDraw function is the StdRect function. 
rRectProc

A pointer to the low-level function that draws rounded rectangles. The standard QuickDraw function is the StdRRect function. 
ovalProc

A pointer to the low-level function that draws ovals. The standard QuickDraw function is the StdOval function. 
arcProc

A pointer to the low-level function that draws arcs. The standard QuickDraw function is the StdArc function. 
polyProc

A pointer to the low-level function that draws polygons. The standard QuickDraw function is the StdPoly function. 
rgnProc

A pointer to the low-level function that draws regions. The standard QuickDraw function is the StdRgn function. 
bitsProc

A pointer to the low-level function that copies bitmaps. The standard QuickDraw function is the StdBits function. 
commentProc

A pointer to the lowQDProcs

struct QDProcs {
   QDTextUPP textProc;
   QDLineUPP lineProc;
   QDRectUPP rectProc;
   QDRRectUPP rRectProc;
   QDOvalUPP ovalProc;
   QDArcUPP arcProc;
   QDPolyUPP polyProc;
   QDRgnUPP rgnProc;
   QDBitsUPP bitsProc;
   QDCommentUPP commentProc;
   QDTxMeasUPP txMeasProc;
   QDGetPicUPP getPicProc;
   QDPutPicUPP putPicProc;
};
typedef struct QDProcs QDProcs;
typedef QDProcs * QDProcsPtr;
Fields
textProc

A pointer to the low-level function that draws text. The standard QuickDraw function is the StdText function. 
lineProc

A pointer to the low-level function that draws lines. The standard QuickDraw function is the StdLine function. 
rectProc

A pointer to the low-level function that draws rectangles. The standard QuickDraw function is the StdRect function. 
rRectProc

A pointer to the low-level function that draws rounded rectangles. The standard QuickDraw function is the StdRRect function. 
ovalProc

A pointer to the low-level function that draws ovals. The standard QuickDraw function is the StdOval function. 
arcProc

A pointer to the low-level function that draws arcs. The standard QuickDraw function is the StdArc function. 
polyProc

A pointer to the low-level function that draws polygons. The standard QuickDraw function is the StdPoly function. 
rgnProc

A pointer to the low-level function that draws regions. The standard QuickDraw function is the StdRgn function. 
bitsProc

A pointer to the low-level function that copies bitmaps. The standard QuickDraw function is the StdBits function. 
commentProc

A pointer to the low-level function for processing a picture comment. The standard QuickDraw function is the StdComment function. 
txMeasProc

A pointer to the low-level function for measuring text width. The standard QuickDraw function is the StdTxMeas function. 
getPicProc

A pointer to the low-level function for retrieving information from the definition of a picture. The standard QuickDraw function is the StdGetPic function. 
putPicProc

A pointer to the low-level function for saving information as the definition of a picture. The standard QuickDraw function is the StdPutPic function. 
Discussion

You need to use the QDProcs structure only if you customize one or more of QuickDraw’s low-level drawing functions. Use SetStdProcs to create a QDProcs structure.

The QDProcs structure contains pointers to low-level drawing functions. You can change the fields of this structure to point to functions of your own devising. 
Availability
Available in Mac OS X v10.0 and later.-level function for processing a picture comment. The standard QuickDraw function is the StdComment function. 
txMeasProc

A pointer to the low-level function for measuring text width. The standard QuickDraw function is the StdTxMeas function. 
getPicProc

A pointer to the low-level function for retrieving information from the definition of a picture. The standard QuickDraw function is the StdGetPic function. 
putPicProc

A pointer to the low-level function for saving information as the definition of a picture. The standard QuickDraw function is the StdPutPic function. 
Discussion

You need to use the QDProcs structure only if you customize one or more of QuickDraw’s low-level drawing functions. Use SetStdProcs to create a QDProcs structure.

The QDProcs structure contains pointers to low-level drawing functions. You can change the fields of this structure to point to functions of your own devising. 
Availability
Available in Mac OS X v10.0 and later.*/
struct QDProcs {
   QDTextUPP textProc;
   QDLineUPP lineProc;
   QDRectUPP rectProc;
   QDRRectUPP rRectProc;
   QDOvalUPP ovalProc;
   QDArcUPP arcProc;
   QDPolyUPP polyProc;
   QDRgnUPP rgnProc;
   QDBitsUPP bitsProc;
   QDCommentUPP commentProc;
   QDTxMeasUPP txMeasProc;
   QDGetPicUPP getPicProc;
   QDPutPicUPP putPicProc;
};
typedef struct QDProcs QDProcs;
typedef QDProcs * QDProcsPtr;

/*GrafPort

struct GrafPort {
   SInt16 device;
   BitMap portBits;
   Rect portRect;
   RgnHandle visRgn;
   RgnHandle clipRgn;
   Pattern bkPat;
   Pattern fillPat;
   Point pnLoc;
   Point pnSize;
   SInt16 pnMode;
   Pattern pnPat;
   SInt16 pnVis;
   SInt16 txFont;
   StyleField txFace;
   SInt16 txMode;
   SInt16 txSize;
   Fixed spExtra;
   SInt32 fgColor;
   SInt32 bkColor;
   SInt16 colrBit;
   SInt16 patStretch;
   Handle picSave;
   Handle rgnSave;
   Handle polySave;
   QDProcsPtr grafProcs;
};*/
struct GrafPort {
   SInt16 device;
   BitMap portBits;
   Rect portRect;
   RgnHandle visRgn;
   RgnHandle clipRgn;
   Pattern bkPat;
   Pattern fillPat;
   Point pnLoc;
   Point pnSize;
   SInt16 pnMode;
   Pattern pnPat;
   SInt16 pnVis;
   SInt16 txFont;
   StyleField txFace;
   SInt16 txMode;
   SInt16 txSize;
   Fixed spExtra;
   SInt32 fgColor;
   SInt32 bkColor;
   SInt16 colrBit;
   SInt16 patStretch;
   Handle picSave;
   Handle rgnSave;
   Handle polySave;
   QDProcsPtr grafProcs;
};
typedef struct GrafPort GrafPort;

/*QDOpcodeProcPtr

typedef void (*QDOpcodeProcPtr) (
   const Rect * fromRect,
   const Rect * toRect,
   UInt16 opcode,
   SInt16 version
);

If you name your function MyQDOpcodeProc, you would declare it like this:

void QDOpcodeProcPtr (
   const Rect * fromRect,
   const Rect * toRect,
   UInt16 opcode,
   SInt16 version
);*/

typedef void (*QDOpcodeProcPtr) (
   const Rect * fromRect,
   const Rect * toRect,
   UInt16 opcode,
   SInt16 version
);

/*QDOpcodeUPP

typedef QDOpcodeProcPtr QDOpcodeUPP;*/
typedef QDOpcodeProcPtr QDOpcodeUPP;

/*QDStdGlyphsProcPtr

typedef OSStatus (*QDStdGlyphsProcPtr) (
   void * dataStream,
   ByteCount size
);

If you name your function MyQDStdGlyphsProc, you would declare it like this:

OSStatus QDStdGlyphsProcPtr (
   void * dataStream,
   ByteCount size
);
Return Value*/

typedef OSStatus (*QDStdGlyphsProcPtr) (
   void * dataStream,
   ByteCount size
);


/*QDStdGlyphsUPP

typedef QDStdGlyphsProcPtr QDStdGlyphsUPP;*/
typedef QDStdGlyphsProcPtr QDStdGlyphsUPP;

/*QDPrinterStatusProcPtr

typedef OSStatus (*QDPrinterStatusProcPtr) (
   PrinterStatusOpcode opcode,
   CGrafPtr currentPort,
   void * printerStatus
);

If you name your function MyQDPrinterStatusProc, you would declare it like this:

OSStatus QDPrinterStatusProcPtr (
   PrinterStatusOpcode opcode,
   CGrafPtr currentPort,
   void * printerStatus
);
Return Value*/

typedef OSStatus (*QDPrinterStatusProcPtr) (
   PrinterStatusOpcode opcode,
   CGrafPtr currentPort,
   void * printerStatus
);


/*QDPrinterStatusUPP

typedef QDPrinterStatusProcPtr QDPrinterStatusUPP;*/
typedef QDPrinterStatusProcPtr QDPrinterStatusUPP;

/*CQDProcs

struct CQDProcs {
   QDTextUPP textProc;
   QDLineUPP lineProc;
   QDRectUPP rectProc;
   QDRRectUPP rRectProc;
   QDOvalUPP ovalProc;
   QDArcUPP arcProc;
   QDPolyUPP polyProc;
   QDRgnUPP rgnProc;
   QDBitsUPP bitsProc;
   QDCommentUPP commentProc;
   QDTxMeasUPP txMeasProc;
   QDGetPicUPP getPicProc;
   QDPutPicUPP putPicProc;
   QDOpcodeUPP opcodeProc;
   UniversalProcPtr newProc1;
   QDStdGlyphsUPP glyphsProc;
   QDPrinterStatusUPP printerStatusProc;
   UniversalProcPtr newProc4;
   UniversalProcPtr newProc5;
   UniversalProcPtr newProc6;
};
typedef struct CQDProcs CQDProcs;
typedef CQDProcs * CQDProcsPtr;
Fields
textProc

A pointer to the low-level function that draws text. The standard QuickDraw function is the StdText function. 
lineProc

A pointer to the low-level function that draws lines. The standard QuickDraw function is the StdLine function. 
rectProc

A pointer to the low-level function that draws rectangles. The standard QuickDraw function is the StdRect function. 
rRectProc

A pointer to the low-level function that draws rounded rectangles. The standard QuickDraw function is the StdRRect function. 
ovalProc

A pointer to the low-level function that draws ovals. The standard QuickDraw function is the StdOval function. 
arcProc

A pointer to the low-level function that draws arcs. The standard QuickDraw function is the StdArc function. 
polyProc

A pointer to the low-level function that draws polygons. The standard QuickDraw function is the StdPoly function. 
rgnProc

A pointer to the low-level function that draws regions. The standard QuickDraw function is the StdRgn function. 
bitsProc

A pointer to the low-level function that copies bitmaps. The standard QuickDraw function is the StdBits function. 
commentProc

A pointer to the low-level function for processing a picture comment. The standard QuickDraw function is the StdComment function. 
txMeasProc

A pointer to the low-level function for measuring text width. The standard QuickDraw function is the StdTxMeas function. 
getPicProc

A pointer to the low-level function for retrieving information from the definition of a picture. The standard QuickDraw function is the StdGetPic function. 
putPicProc

A pointer to the low-level function for saving information as the definition of a picture. The standard QuickDraw function is the StdPutPic function. 
opcodeProc

Reserved for future use. 
newProc1

Reserved for future use.
glyphsProc

Reserved for future use. 
printerStatusProc

Reserved for future use. 
newProc4

Reserved for future use.
newProc5

Reserved for future use.
newProc6

Reserved for future use.
Discussion

Use the CQDProcs structure only if you customize one or more of QuickDraw’s standard low-level drawing functions. Use the SetStdCProcs function to create a CQDProcs structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CQDProcs {
   QDTextUPP textProc;
   QDLineUPP lineProc;
   QDRectUPP rectProc;
   QDRRectUPP rRectProc;
   QDOvalUPP ovalProc;
   QDArcUPP arcProc;
   QDPolyUPP polyProc;
   QDRgnUPP rgnProc;
   QDBitsUPP bitsProc;
   QDCommentUPP commentProc;
   QDTxMeasUPP txMeasProc;
   QDGetPicUPP getPicProc;
   QDPutPicUPP putPicProc;
   QDOpcodeUPP opcodeProc;
   UniversalProcPtr newProc1;
   QDStdGlyphsUPP glyphsProc;
   QDPrinterStatusUPP printerStatusProc;
   UniversalProcPtr newProc4;
   UniversalProcPtr newProc5;
   UniversalProcPtr newProc6;
};
typedef struct CQDProcs CQDProcs;
typedef CQDProcs * CQDProcsPtr;


/*PixPat

struct PixPat {
   short patType;
   PixMapHandle patMap;
   Handle patData;
   Handle patXData;
   short patXValid;
   Handle patXMap;
   Pattern pat1Data;
};
typedef struct PixPat PixPat;
typedef PixPat * PixPatPtr;
typedef PixPatPtr * PixPatHandle;
Fields
patType

The pattern’s type. The value 0 specifies a basic QuickDraw bit pattern, the value 1 specifies a full-color pixel pattern, and the value 2 specifies an RGB pattern.
patMap

A handle to a PixMap structure that describes the pattern’s pixel image. The PixMap structure can contain indexed or direct pixels. 
patData

A handle to the pattern’s pixel image.
patXData

A handle to an expanded pixel image used internally by QuickDraw.
patXValid

A flag that, when set to –1, invalidates the expanded data.
patXMap

Reserved for use by QuickDraw.
pat1Data

A bit pattern to be used when this pattern is drawn into a GrafPort structure. The NewPixPat function sets this field to 50 percent gray. 
Discussion

Your application typically does not create PixPat structures. Although you can create such structures in your program code, it is usually easier to create pixel patterns using the pixel pattern resource, 'ppat'.

When used for a color graphics port, the basic QuickDraw functions PenPat and BackPat store pixel patterns in, respectively, the pnPixPat and bkPixPat fields of the CGrafPort structure and set the patType field of the PixPat field to 0 to indicate that the PixPat structure contains a bit pattern. Such patterns are limited to 8-by-8 pixel dimensions and, instead of being drawn in black and white, are always drawn using the colors specified in the CGrafPort structure’s rgbFgColor and rgbBkColor fields, respectively.

In a full-color pixel pattern, the patType field contains the value 1, and the pattern’s dimensions, depth, resolution, set of colors, and other characteristics are defined by a PixMap structure, referenced by the handle in the patMap field of the PixPat structure. Full-color pixel patterns contain color tables that describe the colors they use. Generally such a color table contains one entry for each color used in the pattern. For instance, if your pattern has five colors, you would probably create a 4 bits per pixel pattern that uses pixel values 0–4, and a color table with five entries, numbered 0–4, that contain the RGB specifications for those pixel values. 

However, if you don’t specify a color table for a pixel value, QuickDraw assigns a color to that pixel value. The largest unassigned pixel value becomes the foreground color the smallest unassigned pixel value is assigned the background color. Remaining unassigned pixel values are given colors that are evenly distributed between the foreground and background.

For instance, in the color table mentioned above, pixel values 5–15 are unused. Assume that the foreground color is black and the background color is white. Pixel value 15 is assigned the foreground color, black pixel value 5 is assigned the background color, white the nine pixel values between them are assigned evenly distributed shades of gray. If the PixMap structure’s color table is set to NULL, all pixel values are determined by blending the foreground and background colors.

Full-color pixel patterns are not limited to a fixed size: their height and width can be any power of 2, as specified by the height and width of the boundary rectangle for the PixMap structure specified in the patMap field. A pattern 8 bits wide, which is the size of a bit pattern, has a row width of just 1 byte, contrary to the usual rule that the rowBytes field must be even. Read this pattern type into memory using the GetPixPat function, and set it using the PenPixPat or BackPixPat functions.

The pixel map specified in the patMap field of the PixPat structure defines the pattern’s characteristics. The baseAddr field of the PixMap structure for that pixel map is ignored. For a full-color pixel pattern, the actual pixel image defining the pattern is stored in the handle in the patData field of the PixPat structure. The pattern’s pixel depth need not match that of the pixel map into which it’s transferred the depth is adjusted automatically when the pattern is drawn. QuickDraw maintains a private copy of the pattern’s pixel image, expanded to the current screen depth and aligned to the current graphics port, in the patXData field of the PixPat structure. 

In an RGB pixel pattern, the patType field contains the value 2. Using the MakeRGBPat function, your application can specify the exact color it wants to use. QuickDraw selects a pattern to approximate that color. In this way, your application can effectively increase the color resolution of the screen. RGB pixel patterns are particularly useful for dithering: mixing existing colors together to create the illusion of a third color that’s unavailable on an indexed device. The MakeRGBPat function aids in this process by constructing a dithered pattern to approximate a given absolute color. An RGB pixel pattern can display 125 different patterns on a 4-bit screen, or 2197 different patterns on an 8-bit screen.

An RGB pixel pattern has an 8-by-8 pixel pattern that is 2 bits deep. For an RGB pixel pattern, the RGBColor structure that you specify to the MakeRGBPat function defines the image; there is no image data. 

Your application should never need to directly change the fields of a PixPat structure. If you find it absolutely necessary for your application to so, immediately use the PixPatChanged function to notify QuickDraw that your application has changed the PixPat structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct PixPat {
   short patType;
   PixMapHandle patMap;
   Handle patData;
   Handle patXData;
   short patXValid;
   Handle patXMap;
   Pattern pat1Data;
};
typedef struct PixPat PixPat;
typedef PixPat * PixPatPtr;
typedef PixPatPtr * PixPatHandle;

/*QDGlobals

struct QDGlobals {
   char privates[76];
   long randSeed;
   BitMap screenBits;
   Cursor arrow;
   Pattern dkGray;
   Pattern ltGray;
   Pattern gray;
   Pattern black;
   Pattern white;
   GrafPtr thePort;
};
typedef struct QDGlobals QDGlobals;
typedef QDGlobals * QDGlobalsPtr;
Availability
Available in Mac OS X v10.0 and later.*/

struct QDGlobals {
   char privates[76];
   long randSeed;
   BitMap screenBits;
   Cursor arrow;
   Pattern dkGray;
   Pattern ltGray;
   Pattern gray;
   Pattern black;
   Pattern white;
   GrafPtr thePort;
};
typedef struct QDGlobals QDGlobals;
typedef QDGlobals * QDGlobalsPtr;

//functions


/*SetRect

Assigns coordinates to a rectangle. 

void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom
);
Parameters
r

A pointer to the rectangle to set.
left

The horizontal coordinate of the new upper-left corner of the rectangle.
top

The vertical coordinate of the new upper-left corner of the rectangle.
right

The horizontal coordinate of the new lower-right corner of the rectangle.
bottom

The vertical coordinate of the new lower-right corner of the rectangle.
Discussion

The SetRect function assigns the coordinates you specify in the left, top, right, and bottom parameters to the rectangle that you specify in the r parameter. This function is provided to help you shorten your program text. If you want a more readable text, at the expense of source text length, you can instead assign integers (or points) directly into the fields of a Rect structure.

You can use a rectangle to specify locations and sizes for various graphics operations.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom
);

/*GetPortBounds

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect
);

/*EraseRect

Erases a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void EraseRect (
   const Rect * r
);
Parameters
r

The rectangle to erase.
Discussion

Using the patCopy pattern mode, the EraseRect function draws the interior of the rectangle that you specify in the r parameter with the background pattern for the current graphics port. This effectively erases the rectangle, making the shape blend into the background pattern of the graphics port. For example, use EraseRect to erase the port rectangle for a window before redrawing into the window.

This function leaves the location of the graphics pen unchanged. 
Special Considerations

The EraseRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void EraseRect (
   const Rect * r
);

/*CopyBits

Copies a portion of a bitmap or a pixel map from one graphics port or offscreen graphics world into another graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);
Parameters
srcBits

The source BitMap structure. 
dstBits

The destination BitMap structure.
srcRect

The source rectangle.
dstRect

The destination rectangle.
mode

One of the eight source modes in which the copy is to be performed. See Source, Pattern, and Arithmetic Transfer Mode Constants. The CopyBits function always dithers images when shrinking them between pixel maps on direct devices. 

When transferring pixels from a source pixel map to a destination pixel map, color QuickDraw interprets the source mode constants differently than basic QuickDraw does.

When you use CopyBits on a computer running color QuickDraw, you can also specify one of the transfer modes in the mode parameter.
maskRgn

A region to use as a clipping mask. You can pass a region handle to specify a mask region the resulting image is always clipped to this mask region and to the boundary rectangle of the destination bitmap. If the destination bitmap is the current graphics port’s bitmap, it is also clipped to the intersection of the graphics port’s clipping region and visible region. If you do not want to clip to a masking region, just pass NULL for this parameter. 
Discussion

The CopyBits function transfers any portion of a bitmap between two basic graphics ports, or any portion of a pixel map between two color graphics ports. Use CopyBits to move offscreen graphic images into an onscreen window, to blend colors for the image in a pixel map, and to shrink and expand images.

Specify a source bitmap in the srcBits parameter and a destination bitmap in the dstBits parameter. When copying images between color graphics ports, you must coerce each CGrafPort structure to a GrafPort structure, dereference the portBits fields of each, and then pass these “bitmaps” in the srcBits and dstBits parameters. If your application copies a pixel image from a color graphics port called MyColorPort, for example, you could specify (* GrafPtr(MyColorPort)).portBits in the srcBits parameter. In a CGrafPort structure, the high 2 bits of the portVersion field are set. This field, which shares the same position in a CGrafPort structure as the portBits.rowBytes field in a GrafPort structure, indicates to CopyBits that you have passed it a handle to a pixel map rather than a bitmap.

Using the srcRect and dstRect parameters, you can specify identically or differently sized source and destination rectangles; for differently sized rectangles, CopyBits scales the source image to fit the destination. If the bit image is a circle in a square source rectangle, and the destination rectangle is not square, the bit image appears as an oval in the destination. When you specify rectangles in the srcRect and dstRect parameters, use the local coordinate systems of, respectively, the source and destination graphics ports.

The CopyDeepMask function combines the functions of the CopyBits and CopyMask functions. 
Special Considerations

When you use the CopyBits function to transfer an image between pixel maps, the source and destination images may be of different pixel depths, of different sizes, and they may have different color tables. However, CopyBits assumes that the destination pixel map uses the same color table as the color table for the current GDevice structure. (This is because the Color Manager requires an inverse table for translating the color table from the source pixel map to the destination pixel map.) 

The CopyBits function applies the foreground and background colors of the current graphics port to the image in the destination pixel map (or bitmap), even if the source image is a bitmap. This causes the foreground color to replace all black pixels in the destination and the background color to replace all white pixels. To avoid unwanted coloring of the image, use the RGBForeColor function to set the foreground to black and use the RGBBackColor function to set the background to white before calling CopyBits.

The source bitmap or pixel map must not occupy more memory than half the available stack space. The stack space required by CopyBits is roughly five times the value of the rowBytes field of the source pixel map: one rowBytes value for the pixel map (or bitmap), an additional rowBytes value for dithering, another rowBytes value when stretching or shrinking the source pixel map into the destination, another rowBytes value for any color map changing, and a fifth additional rowBytes value for any color aliasing. If there is insufficient memory to complete a CopyBits operation in Color QuickDraw, the QDError function returns the result code –143.

If you use CopyBits to copy between two graphics ports that overlap, you must first use the LocalToGlobal function to convert to global coordinates, and then specify the global variable screenBits for both the srcBits and dstBits parameters.

The CopyBits function may move or purge memory blocks in the application heap; do not call this function at interrupt time.

If you are reading directly from a NuBus video card with a base address of Fs00000 and there is not a card in the slot (s–1) below it, CopyBits reads addresses less than the base address of the pixel map. This causes a bus error. To work around the problem, remap the baseAddr field of the pixel map in your video card to at least 20 bytes above the NuBus boundary; an address link of Fs000020 precludes the problem.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);

/*QDFlushPortBuffer

Calls the Quartz compositor to flush all new drawing in a Carbon window to the display. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region
);
Parameters
port

A window port. If the port has no back buffer, or if the port is an offscreen or printing port, this function does nothing.
region

An update region. Under normal conditions, you should pass NULL to avoid the overhead of additional region operations.
Discussion

In Mac OS X, drawing in a window port updates a back buffer associated with the window. Updates to this buffer are accumulated in a list called the dirty region. 

The back buffer is automatically flushed to the display each time through the event loop. When the event loop does not get control soon enough—for example, during an animation sequence—you can call this function to flush the port buffer to the device immediately. 

When you call this function, there are several different execution paths:
If the region parameter is NULL, the dirty region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the dirty region is set to empty.
If the region parameter specifies an update region, the intersection of the dirty region and the update region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the flushed region is subtracted from the dirty region.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region
);

/*SetPort

Changes the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPort (
   GrafPtr port
);
Parameters
port

A pointer to a GrafPort structure. Typically, you pass a pointer to a GrafPort structure that you previously saved with the GetPort function. The SetPort function sets this structure to be the current graphics port. 
Discussion

All QuickDraw drawing functions affect the bitmap of, and use the local coordinate system of, the current graphics port. Each graphics port has its own graphics pen and text characteristics, which remain unchanged when the graphics port isn’t selected as the current graphics port.

When your application runs in Color QuickDraw or uses offscreen graphics worlds, it should use the SetGWorld function instead of SetPort. The SetGWorld function restores the current graphics port for basic and color graphics ports as well as offscreen graphics worlds. 
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void SetPort (
   GrafPtr port
);

/*GetPort

Saves the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetPort (
   GrafPtr * port
);
Parameters
port

On return, a pointer to a GrafPort structure for the current graphics port. If the current graphics port is a color graphics port, GetPort coerces its CGrafPort structure into a GrafPort structure. 
Discussion

When your application runs in Color QuickDraw or uses offscreen graphics worlds, it should use the GetGWorld function instead of GetPort. The GetGWorld function saves the current graphics port for basic and color graphics ports as well as offscreen graphics worlds. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetPort (
   GrafPtr * port
);

/*GlobalToLocal

Converts the coordinates of a point from global coordinates to the local coordinates of the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GlobalToLocal (
   Point * pt
);
Parameters
pt

A pointer to a point expressed in global coordinates (where the upper-left corner of the main screen has coordinates [0,0]). On return, this point is converted to local coordinates.
Discussion

The GlobalToLocal procedure takes a point expressed in global coordinates (where the upper-left corner of the main screen has coordinates [0,0]) and converts it into the local coordinates of the current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GlobalToLocal (
   Point * pt
);

/*GetPenState

Determines the graphics pen’s location, size, pattern, and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetPenState (
   PenState * pnState
);
Parameters
pnState

On return, a pointer to a PenState structure holding information about the graphics pen. The GetPenState function saves the location, size, pattern, and pattern mode of the graphics pen for the current graphics port in this structure. 
Discussion

After changing the graphics pen as necessary, restore these pen states with the SetPenState function. 

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetPenState (
   PenState * pnState
);

/*PenSize

Sets the dimensions of the graphics pen in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PenSize (
   short width,
   short height
);
Parameters
width

The pen width, as an integer from 0 to 32,767. If you set the value to 0, the pen does not draw. Values less than 0 are undefined.
height

The pen height, as an integer from 0 to 32,767. If you set the value to 0, the pen does not draw. Values less than 0 are undefined.
Discussion

The PenSize function sets the width that you specify in the width parameter and the height that you specify in the height parameter for the graphics pen in the current graphics port. All subsequent calls to the Line and LineTo functions and to the functions that draw framed shapes in the current graphics port use the new pen dimensions.

You can get the current pen dimensions from the pnSize field of the current graphics port, where the width and height are stored as a Point structure.

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PenSize (
   short width,
   short height
);

/*PenPat

Sets the bit pattern to be used by the graphics pen in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PenPat (
   const Pattern * pat
);
Parameters
pat

A bit pattern, as defined by a Pattern structure. 
Discussion

The PenPat function sets the graphics pen to use the bit pattern defined in the Pattern structure that you specify in the pat parameter. (The standard patterns white, black, gray, ltGray, and dkGray are predefined; the initial bit pattern for the pen is black.) This pattern is stored in the pnPat field of a GrafPort structure. The QuickDraw painting functions (such as PaintRect) also use the pen’s pattern when drawing a shape.

The PenPat function also sets a bit pattern for the graphics pen in a color graphics port. The PenPat function creates a handle, of type PixPatHandle, for the bit pattern and stores this handle in the pnPixPat field of the CGrafPort structure. This pattern always uses the graphics port’s current foreground and background colors.

To define your own patterns, you typically create pattern, ‘PAT’, or pattern list, ‘PAT#’, resources. 
Special Considerations

The PenPat function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PenPat (
   const Pattern * pat
);

/*SetPenState

Restores the state of the graphics pen that was saved with the GetPenState function. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPenState (
   const PenState * pnState
);
Parameters
pnState

A PenState structure previously created with the GetPenState function. The SetPenState function sets the graphics pen’s location, size, pattern, and pattern mode in the current graphics port to the values stored in this structure. 
Discussion

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPenState (
   const PenState * pnState
);

/*GetQDGlobalsGray

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Pattern * GetQDGlobalsGray (
   Pattern * gray
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Pattern * GetQDGlobalsGray (
   Pattern * gray
);

/*FrameRect

Draws an outline inside a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FrameRect (
   const Rect * r
);
Parameters
r

The rectangle to frame.
Discussion

Using the pattern, pattern mode, and size of the graphics pen for the current graphics port, the FrameRect function draws an outline just inside the rectangle that you specify in the r parameter. The outline is as wide as the pen width and as tall as the pen height. The pen location does not change.

If a region is open and being formed, the outside outline of the new rectangle is mathematically added to the region’s boundary. 
Special Considerations

The FrameRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void FrameRect (
   const Rect * r
);

/*PaintRect

Paints a rectangle with the graphics pen’s pattern and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PaintRect (
   const Rect * r
);
Parameters
r

The rectangle to paint.
Discussion

The PaintRect function draws the interior of the rectangle that you specify in the r parameter with the pen pattern for the current graphics port, according to the pattern mode for the current graphics port. The pen location does not change.

Use the FillRect to draw the interior of a rectangle with a pen pattern different from that for the current graphics port. 
Special Considerations

The PaintRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PaintRect (
   const Rect * r
);


/*PtInRect

Determines whether a pixel below is enclosed in a rectangle. 

Boolean PtInRect (
   Point pt,
   const Rect * r
);
Parameters
pt

The point to test.
r

The rectangle to test.
Return Value

TRUE if the pixel below and to the right of the point specified in the pt parameter is enclosed in the rectangle specified in the r parameter. FALSE if it is not. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

Boolean PtInRect (
   Point pt,
   const Rect * r
);

/*RGBForeColor

Changes the color of the “ink” used for framing and painting. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void RGBForeColor (
   const RGBColor * color
);
Parameters
color

An RGBColor structure. 
Discussion

If the current port is defined by a CGrafPort structure, QuickDraw supplies its rgbFgColor field with the RGB value that you specify in the color parameter, and places the pixel value most closely matching that color in the fgColor field. For indexed devices, the pixel value is an index to the current device’s CLUT. For direct devices, the value is the 16-bit or 32-bit equivalent to the RGB value.

If the current port is defined by a GrafPort structure, basic QuickDraw supplies its fgColor field with a color value determined by taking the high bit of each of the red, green, and blue components of the color that you supply in the color parameter. Basic QuickDraw uses that 3-bit number to select a color from its eight-color system. 

You can also use Palette Manager functions to set the foreground color.

To determine the current foreground color, use the GetForeColor function.

QuickDraw ignores the foreground and background colors when your application draws with a pixel pattern. Assign a pixel pattern to the foreground pattern used by the graphics pen; by using the BackPixPat function to assign a pixel pattern as the background pattern for the current color graphics port; and by using the FillCRect, FillCOval, FillCRoundRect, FillCArc, FillCRgn, and FillCPoly functions to fill shapes with a pixel pattern. 
Special Considerations

The RGBForeColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

The RGBForeColor function is available for basic QuickDraw only in System 7. To set the foreground color for basic graphics ports on older versions of system software, use the ForeColor function.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void RGBForeColor (
   const RGBColor * color
);

/*NewRgn

Begins creating a new region. (Deprecated in Mac OS X v10.4.)

RgnHandle NewRgn ();
Return Value

A handle to the new region. 
Discussion

The NewRgn function allocates space for a new, variable-size region and initializes it to the empty region defined by the rectangle (0,0,0,0). This is the only function that creates a new region; other functions merely alter the size or shape of existing regions.

To begin defining a region, use the OpenRgn function.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

The NewRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.

Use the Memory Manager function MaxMem to determine whether the memory for the region is valid before using NewRgn.

Ensure that the memory for a region is valid before calling this function to manipulate that region if there isn’t sufficient memory, the system may crash. Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in color QuickDraw. Before defining a region, you can use the Memory Manager function MaxMem to determine whether the memory for the region is valid. You can determine the current size of an existing region by calling the Memory Manager function GetHandleSize. When you record drawing operations in an open region, the resulting region description may overflow the 32 KB or 64 KB limit. Should this happen in color QuickDraw, the QDError function returns the result code regionTooBigError.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
RgnHandle NewRgn ();


/*OpenRgn

Begins defining a region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void OpenRgn ();
Discussion

The OpenRgn function allocates temporary memory to start saving lines and framed shapes for processing as a region definition. Call OpenRgn only after initializing a region with the NewRgn function.

The NewRgn function stores the definition for a region in a Region structure.

While a region is open, all calls to Line, LineTo, and the functions that draw framed shapes (except arcs) affect the outline of the region. Only the line endpoints and shape boundaries affect the region definition—the pattern mode, pattern, and size do not affect it.

When you are finished defining the region, call the CloseRgn function.

The OpenRgn function calls HidePen, so no drawing occurs on the screen while the region is open (unless you call ShowPen just after OpenRgn, or you called ShowPen previously without balancing it by a call to HidePen). Since the pen hangs below and to the right of the pen location, drawing lines with even the smallest pen changes pixels that lie outside the region you define.

The outline of a region is mathematically defined and infinitely thin, and it separates the bit or pixel image into two groups of pixels: those within the region and those outside it. 

A region should consist of one or more closed loops. Each framed shape itself constitutes a loop. Any lines drawn with the Line or LineTo function should connect with each other or with a framed shape. Even if the onscreen presentation of a region is clipped, the definition of a region is not; you can define a region anywhere on the coordinate plane with complete disregard for the location of various graphics port entities on that plane.

When a region is open, the current graphics port’s rgnSave field contains a handle to information related to the region definition. If you want to temporarily disable the collection of lines and shapes, you can save the current value of this field, set the field to NULL, and later restore the saved value to resume the region definition. Also, calling SetPort while a region is being formed discontinues formation of the region until another call to SetPort resets the region’s original graphics port.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in Color QuickDraw. You can determine the current size of an existing region by calling the Memory Manager function GetHandleSize. When you structure drawing operations in an open region, the resulting region description may overflow the 32 KB or 64 KB limit. Should this happen in Color QuickDraw, the QDError function returns the result code regionTooBigError. 

Do not call OpenRgn while another region or a polygon is already open. When you are finished constructing the region, use the CloseRgn function, which is described next.

The OpenRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void OpenRgn ();

/*MoveTo

Moves the graphics pen to a particular location in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void MoveTo (
   short h,
   short v
);
Parameters
h

The horizontal coordinate of the graphics pen’s new position.
v

The vertical coordinate of the graphics pen’s new position.
Discussion

The MoveTo function changes the graphics pen’s current location to the new horizontal coordinate you specify in the h parameter and the new vertical coordinate you specify in the v parameter. Specify the new location in the local coordinates of the current graphics port. The MoveTo function performs no drawing. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void MoveTo (
   short h,
   short v
);

/*LineTo

Draws a line from the graphics pen’s current location to a new location. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void LineTo (
   short h,
   short v
);
Parameters
h

The horizontal coordinate of the graphics pen’s new location.
v

The vertical coordinate of the graphics pen’s new location.
Discussion

The LineTo function draws a line from the graphics pen’s current location in the current graphics port to the new location (h,v), which you specify in the local coordinates of the current graphics port. If you are using LineTo to draw a region or polygon, its outline is infinitely thin and is not affected by the values of the pnSize, pnMode, or pnPat field of the graphics port. 
Special Considerations

The LineTo function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/


void LineTo (
   short h,
   short v
);

/*CloseRgn

Organizes a collection of lines and shapes into a region definition. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CloseRgn (
   RgnHandle dstRgn
);
Parameters
dstRgn

The handle to the region to close. This handle should be a region handle returned by the NewRgn function. 
Discussion

The CloseRgn function stops the collection of lines and framed shapes, organizes them into a region definition, and saves the result in the region whose handle you pass in the dstRgn parameter. 

The CloseRgn function does not create the destination region; you must have already allocated space for it by using the OpenRgn function. The CloseRgn function calls the ShowPen function, balancing the call to the HidePen function made by OpenRgn. 

When you no longer need the memory occupied by the region, use the DisposeRgn function.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in Color QuickDraw. When you structure drawing operations in an open region, the resulting region description may overflow this limit. Should this happen in Color QuickDraw, the QDError function returns the result code regionTooBigError. Since the resulting region is potentially corrupt, the CloseRgn function returns an empty region if it detects QDError has returned regionTooBigError.

The CloseRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void CloseRgn (
   RgnHandle dstRgn
);


/*DisposeRgn

Releases the memory occupied by a region. (Deprecated in Mac OS X v10.4.)

void DisposeRgn (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to dispose. This handle should be a region handle returned by the NewRgn function. 
Discussion

Use DisposeRgn only after you are completely through with a region. 
Special Considerations

The DisposeRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void DisposeRgn (
   RgnHandle rgn
);

/*InsetRect

Shrinks or expands a rectangle. 

void InsetRect (
   Rect * r,
   short dh,
   short dv
);
Parameters
r

A pointer to the rectangle to alter.
dh

The horizontal distance to move the left and right sides in toward or outward from the center of the rectangle.
dv

The vertical distance to move the top and bottom sides in toward or outward from the center of the rectangle.
Discussion

The InsetRect function shrinks or expands the rectangle that you specify in the r parameter: the left and right sides are moved in by the amount you specify in the dh parameter; the top and bottom are moved toward the center by the amount you specify in the dv parameter. If the value you pass in dh or dv is negative, the appropriate pair of sides is moved outward instead of inward. The effect is to alter the size by 2*dh horizontally and 2*dv vertically, with the rectangle remaining centered in the same place on the coordinate plane.

If the resulting width or height becomes less than 1, the rectangle is set to the empty rectangle (0,0,0,0).

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

void InsetRect (
   Rect * r,
   short dh,
   short dv
);

/*RectRgn

Changes the structure of an existing region to that of a rectangle. (Deprecated in Mac OS X v10.4.)

void RectRgn (
   RgnHandle rgn,
   const Rect * r
);
Parameters
rgn

A handle to the region to restructure as a rectangle. 
r

The rectangle structure to use.
Discussion

The RectRgn function destroys the previous structure of the SetRectRgn function, and it then sets the new structure to a rectangle that you specify in the r parameter.

As an alternative to the RectRgn function, use the SetRectRgn function, which accepts as parameters four coordinates instead of a rectangle. 

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

The RectRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void RectRgn (
   RgnHandle rgn,
   const Rect * r
);

/*GetPixBounds

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Rect * GetPixBounds (
   PixMapHandle pixMap,
   Rect * bounds
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Rect * GetPixBounds (
   PixMapHandle pixMap,
   Rect * bounds
);

/*OffsetRect

Moves a rectangle. 

void OffsetRect (
   Rect * r,
   short dh,
   short dv
);
Parameters
r

A pointer to the rectangle to move.
dh

The horizontal distance to move the rectangle.
dv

The vertical distance to move the rectangle.
Discussion

The OffsetRect function moves the rectangle that you specify in the r parameter by adding the value you specify in the dh parameter to each of its horizontal coordinates and the value you specify in the dv parameter to each of its vertical coordinates. If the dh and dv parameters are positive, the movement is to the right and down; if either is negative, the corresponding movement is in the opposite direction. The rectangle retains its shape and size; it is merely moved on the coordinate plane. The movement does not affect the screen unless you subsequently call a function to draw within the rectangle.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

void OffsetRect (
   Rect * r,
   short dh,
   short dv
);

/*ClipRect

Changes the clipping region of the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void ClipRect (
   const Rect * r
);
Parameters
r

A pointer to a rectangle for the boundary of the new clipping region. The ClipRect function changes the clipping region of the current graphics port to a region that’s equivalent to this rectangle. ClipRect doesn’t change the region handle, but it affects the clipping region itself.
Discussion

Since ClipRect makes a copy of the given rectangle, any subsequent changes you make to that rectangle do not affect the clipping region of the port.

The ClipRect function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void ClipRect (
   const Rect * r
);


/*KillPicture

Releases the memory occupied by a picture not stored in a 'PICT' resource. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void KillPicture (
   PicHandle myPicture
);
Parameters
myPicture

A handle to the picture whose memory can be released. 
Discussion

Use this function only when you are completely finished with a picture. 
Special Considerations

If you use the Window Manager function SetWindowPic to store a picture handle in the window structure, use the Window Manager function DisposeWindow or CloseWindow to release the memory allocated to the picture. These functions automatically call KillPicture for the picture.

If the picture is stored in a 'PICT' resource, use the Resource Manager function ReleaseResource instead of KillPicture. The Window Manager functions DisposeWindow and CloseWindow will not delete it. Instead, call ReleaseResource before calling DisposeWindow or CloseWindow.

The KillPicture function may move or purge memory.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void KillPicture (
   PicHandle myPicture
);


/*OpenPicture

Creates a picture which allows you to specify resolutions for your pictures. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PicHandle OpenPicture (
   const Rect * picFrame
);
Parameters
picFrame

The bounding rectangle for the picture. The DrawPicture function uses this rectangle to scale the picture if you draw it into a destination rectangle of a different size.
Return Value

A handle to a new Picture structure. OpenPicture collects your subsequent drawing commands in this structure. Use this handle when referring to the picture in subsequent functions, such as the DrawPicture function. 
Discussion

The OpenPicture function, which was created for earlier versions of system software, is described here for completeness. Use the OpenPicture function to begin defining a picture. 

The OpenPicture function calls the HidePen function, so no drawing occurs on the screen while the picture is open (unless you call the ShowPen function just after OpenPicture or you called ShowPen previously without balancing it by a call to HidePen).

The OpenPicture function creates pictures in the version 2 format on computers with Color QuickDraw when the current graphics port is a color graphics port. Pictures created in this format support color drawing operations at 72 dpi. On computers supporting only basic QuickDraw, or when the current graphics port is a basic graphics port, this function creates pictures in version 1 format. Pictures created in version 1 format support only black-and-white drawing operations at 72 dpi.

When defining a picture, you can use all other QuickDraw drawing functions, with the exception of CopyMask, CopyDeepMask, SeedFill, SeedCFill, CalcMask, and CalcCMask. You can also use the PicComment function to include picture comments in your picture definition.

After defining the picture, close it by using the ClosePicture function. To draw the picture, use the DrawPicture function. 
Special Considerations

The version 2 and version 1 picture formats support only 72-dpi resolution. The OpenCPicture function creates pictures in the extended version 2 format. The extended version 2 format, which is created by the OpenCPicture function on all Macintosh computers running System 7, permits your application to specify additional resolutions when creating images.

Version 1 pictures are limited to 32 KB. You can determine the picture size while it is being formed by calling the Memory Manager function GetHandleSize.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

PicHandle OpenPicture (
   const Rect * picFrame
);

/*ClosePicture

Completes the collection of drawing commands and picture comments that define your picture. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void ClosePicture ();
Discussion

The ClosePicture function stops collecting drawing commands and picture comments for the currently open picture. You should perform one and only one call to ClosePicture for every call to the OpenCPicture (or OpenPicture) function.

The ClosePicture function calls the ShowPen function, balancing the call made by OpenCPicture (or OpenPicture) to the HidePen function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void ClosePicture ();

/*GetQDGlobalsScreenBits

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

BitMap * GetQDGlobalsScreenBits (
   BitMap * screenBits
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
BitMap * GetQDGlobalsScreenBits (
   BitMap * screenBits
);

/*QDEndCGContext

Terminates a Quartz 2D drawing environment associated with a graphics port.

OSStatus QDEndCGContext (
   CGrafPtr port,
   CGContextRef * contextPtr
);
Parameters
port

A graphics port specified in a preceding call to QDBeginCGContext.
contextPtr

A pointer to the context obtained in the preceding call to QDBeginCGContext for the port. Upon completion, the storage pointed to by contextPtr is set to NULL.
Return Value

A result code. If noErr, the context is terminated.
Discussion

After you finish using Quartz 2D to draw in a graphics port, you should call this function to terminate the context. For more information, see QDBeginCGContext.

Before calling this function, you should do one of the following:
Call CGContextSynchronize to mark the affected areas of the port for update.
Call CGContextFlush to immediately update the destination device.
Availability
Available in Mac OS X v10.1 and later.
Declared In
Quickdraw.h*/
OSStatus QDEndCGContext (
   CGrafPtr port,
   CGContextRef * contextPtr
);


/*QDBeginCGContext

Returns a Quartz 2D drawing environment associated with a graphics port.

OSStatus QDBeginCGContext (
   CGrafPtr port,
   CGContextRef * contextPtr
);
Parameters
port

A color graphics port in which to draw. Offscreen graphics worlds with pixel depths of 1, 2, 4, and 8 are not supported. When using Quartz 2D to draw in a offscreen graphics world, alpha information is always ignored.
contextPtr

A pointer to your storage for a Quartz context. Upon completion, contextPtr points to a context associated with the port. The context matches the port’s pixel depth, width, and height. Otherwise the context is in a default state and does not necessarily match other port attributes such as foreground color, background color, or clip region.

You should not retain or release the context. When you are finished using the context, you should call QDEndCGContext.
Return Value

A result code. If noErr, the context was successfully initiated.
Discussion

Applications running in Mac OS X can use Quartz 2D to draw in a QuickDraw graphics port. When you call this function, you obtain a Quartz context that’s associated with the specified port. To improve performance, contexts returned by this function are cached and reused during subsequent calls whenever possible. 

Each block of Quartz 2D drawing code in your application should be surrounded by calls to this function and QDEndCGContext. Nested calls to this function for the same graphics port are not permitted—that is, for a given port you should not call this function more than once without an intervening call to QDEndCGContext.

While the Quartz context is in use, all Quickdraw imaging operations in the associated graphics port are disabled. This is done because the operations would fail during printing.

For information about how to use a Quartz context, see Quartz 2D Programming Guide. 
Availability
Available in Mac OS X v10.1 and later.
Declared In
Quickdraw.h*/

OSStatus QDBeginCGContext (
   CGrafPtr port,
   CGContextRef * contextPtr
);

/*SyncCGContextOriginWithPort

Synchronizes the origin in a Quartz context with the lower-left corner of the associated graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

OSStatus SyncCGContextOriginWithPort (
   CGContextRef context,
   CGrafPtr port
);
Parameters
context

A Quartz context associated with a graphics port. You can obtain such a context by calling QDBeginCGContext.
port

The graphics port associated with the context.
Return Value

A result code. If noErr, the context’s origin was successfully changed.
Discussion

If you’re using Quartz 2D to draw in a graphics port and SetOrigin is called to change the port’s origin, you can call this function to maintain the correspondence between the context’s origin and the lower-left corner of the portBounds rectangle.

When you call this function:
The current transformation matrix (CTM) is reset to its default values. Any changes you made to the CTM prior to calling this function are lost.
The CTM is translated to establish the new origin, taking the port’s current origin into account.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
OSStatus SyncCGContextOriginWithPort (
   CGContextRef context,
   CGrafPtr port
);

/*SetCursor

Sets the current cursor. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetCursor (
   const Cursor * crsr
);
Parameters
crsr

A Cursor structure for the cursor to be displayed. 
Discussion

If the cursor is hidden, it remains hidden and attains its new appearance only when it’s uncovered. If the cursor is already visible, it changes to the new appearance immediately.

You need to use the InitCursor function to initialize the standard arrow cursor and make it visible on the screen before you call SetCursor to change the cursor’s appearance. 

To display a color cursor, use the SetCCursor function. 
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

void SetCursor (
   const Cursor * crsr
);

/*GetCursor

Loads a cursor resource into memory. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CursHandle GetCursor (
   short cursorID
);
Parameters
cursorID

The resource ID for the cursor you want to display. You can supply one of the Cursor ID Constants to get a handle to one of the standard cursors.
Return Value

A handle to a Cursor structure for the cursor with the resource ID that you specify in the cursorID parameter. If the resource cannot be read into memory, GetCursor returns NULL. 
Discussion

To get a handle to a color cursor, use the GetCCursor function. 
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
CursHandle GetCursor (
   short cursorID
);


/*PtInRgn

Determines whether a pixel is within a region. (Deprecated in Mac OS X v10.4.)

Boolean PtInRgn (
   Point pt,
   RgnHandle rgn
);
Parameters
pt

The point whose pixel is to be checked.
rgn

A handle to the region to test. 
Return Value

TRUE if the pixel below and to the right of the point specified in the pt parameter is within the region whose handle is specified in the rgn parameter. FALSE if it is not. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Boolean PtInRgn (
   Point pt,
   RgnHandle rgn
);

/*GetPortVisibleRegion

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

RgnHandle GetPortVisibleRegion (
   CGrafPtr port,
   RgnHandle visRgn
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

RgnHandle GetPortVisibleRegion (
   CGrafPtr port,
   RgnHandle visRgn
);


/*GetQDGlobalsArrow

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Cursor * GetQDGlobalsArrow (
   Cursor * arrow
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Cursor * GetQDGlobalsArrow (
   Cursor * arrow
);

/*PaintOval

Paints an oval with the graphics pen’s pattern and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PaintOval (
   const Rect * r
);
Parameters
r

The rectangle that defines the oval’s boundary.
Discussion

Using the pen pattern and pattern mode for the current graphics port, the PaintOval function draws the interior of an oval just inside the bounding rectangle that you specify in the r parameter. The pen location does not change.

Use FillOval to draw the interior of an oval with a pen pattern different from that for the current graphics port. 
Special Considerations

The PaintOval function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void PaintOval (
   const Rect * r
);

/*InvertColor

Finds the complement of an RGBColor data structure. This function is used only by system software. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void InvertColor (
   RGBColor * myColor
);
Parameters
myColor

A pointer to the RGBColor data structure for which the complement is to be found.The InvertColor function returns the complement of an absolute color, using the list of complement functions in the current device data structure. The default complement function uses the one’s complement of each component of the given color. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void InvertColor (
   RGBColor * myColor
);

/*QDIsPortBuffered

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Boolean QDIsPortBuffered (
   CGrafPtr port
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Boolean QDIsPortBuffered (
   CGrafPtr port
);


/*CreateNewPortForCGDisplayID

Creates a graphics port associated with a display. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CGrafPtr CreateNewPortForCGDisplayID (
   UInt32 displayID
);
Parameters
displayID

A display identifier. If the identifier is not valid, the main display is used instead. For information about finding displays, see Quartz Display Services Reference.
Return Value

A new display port. The portBounds rectangle is the same size as the display. When you are finished using the port, you should call DisposePort to release it.
Discussion

This function returns a graphics port used to draw directly to a display. The pixel map for the new port is taken from the GDevice record corresponding to the display. There is no back buffer associated with the port.

Before calling this function, you should capture the display. For information about capturing displays, see Quartz Display Services Reference.

You should not call this function and then attempt to create a Quartz drawing environment inside the port. Instead, applications using Quartz 2D can call CGDisplayGetDrawingContext to obtain a context suitable for drawing directly to a captured display.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

CGrafPtr CreateNewPortForCGDisplayID (
   UInt32 displayID
);

/*DisposePort

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DisposePort (
   CGrafPtr port
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DisposePort (
   CGrafPtr port
);

/*GetRegionBounds

(Deprecated in Mac OS X v10.4.)

Rect * GetRegionBounds (
   RgnHandle region,
   Rect * bounds
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Rect * GetRegionBounds (
   RgnHandle region,
   Rect * bounds
);

/*GetPortBitMapForCopyBits

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

const BitMap * GetPortBitMapForCopyBits (
   CGrafPtr port
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
const BitMap * GetPortBitMapForCopyBits (
   CGrafPtr port
);

/*HideCursor

Hides the cursor if it is visible on the screen. (Deprecated in Mac OS X v10.4.)

void HideCursor ();
Discussion

The HideCursor function removes the cursor from the screen, restores the bits under the cursor image, and decrements the cursor level (which InitCursor initialized to 0). You might want to use HideCursor when the user is using the keyboard to create content in one of your application’s windows. Every call to HideCursor should be balanced by a subsequent call to the ShowCursor function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void HideCursor ();

/*ShowCursor

Displays a cursor hidden by the HideCursor or ShieldCursor functions. 

void ShowCursor ();
Discussion

ShowCursor increments the cursor level, which has been decremented by the HideCursor or ShieldCursor function and displays the cursor on the screen when the level is 0. A call to the ShowCursor function balances each previous call to the HideCursor or ShieldCursor function. The level is not incremented beyond 0, so extra calls to ShowCursor have no effect.

Low-level interrupt-driven functions link the cursor with the mouse position, so that if the cursor level is 0 and visible, the cursor automatically follows the mouse. 

If the cursor has been changed with the SetCursor function while hidden, ShowCursor displays the new cursor. 
Declared In
Quickdraw.h*/
void ShowCursor ();

/*GetMainDevice

Obtains a handle to the GDevice structure for the main screen. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetMainDevice ();
Return Value

A handle to the device for the main screen, which is the device containing the menu bar. 
Discussion

A handle to the main device is kept in the global variable MainDevice.

All existing GDevice structures are linked together in the device list. After using this function to obtain a handle to the current GDevice structure, your application can use the GetNextDevice function to obtain a handle to the next GDevice structure in the list. 
Special Considerations

The GetMainDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
GDHandle GetMainDevice ();

/*RGBBackColor

Changes the background color. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void RGBBackColor (
   const RGBColor * color
);
Parameters
color

An RGBColor structure. 
Discussion

If the current port is defined by a CGrafPort structure, QuickDraw supplies its rgbBkColor field with the RGB value that you specify in the color parameter, and places the pixel value most closely matching that color in the bkColor field. For indexed devices, the pixel value is an index to the current device’s CLUT. F or direct devices, the value is the 16-bit or 32-bit equivalent to the RGB value.

If the current port is defined by a GrafPort structure, basic QuickDraw supplies its fgColor field with a color value determined by taking the high bit of each of the red, green, and blue components of the color that you supply in the color parameter. Basic QuickDraw uses that 3-bit number to select a color from its eight-color system.

You can also use Palette Manager functions to set the background color.

To determine the current background color, use the GetBackColor function.

Because a pixel pattern already contains color, QuickDraw ignores the background color and foreground colors when your application draws with a pixel pattern. Use the PenPixPat function to assign a pixel pattern to the foreground pattern used by the graphics pen. Use the BackPixPat function to assign a pixel pattern as the background pattern for the current color graphics port. Use the FillCRect, FillCOval, FillCRoundRect, FillCArc, FillCRgn, and FillCPoly functions to fill shapes with a pixel pattern. 
Special Considerations

The RGBBackColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

This function is available for basic QuickDraw only in System 7. To set the background color for basic graphics ports on older versions of system software, use the BackColor function.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void RGBBackColor (
   const RGBColor * color
);

/*UnionRect

Calculates the smallest rectangle that encloses two rectangles. 

void UnionRect (
   const Rect * src1,
   const Rect * src2,
   Rect * dstRect
);
Parameters
src1

The first of two rectangles to enclose.
src2

The second of two rectangles to enclose.
dstRect

On return, a pointer to the smallest rectangle that encloses both of the rectangles you specify in the src1 and src2 parameters. One of the source rectangles may also be the destination.
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
void UnionRect (
   const Rect * src1,
   const Rect * src2,
   Rect * dstRect
);

/*OffsetRect

Moves a rectangle. 

void OffsetRect (
   Rect * r,
   short dh,
   short dv
);
Parameters
r

A pointer to the rectangle to move.
dh

The horizontal distance to move the rectangle.
dv

The vertical distance to move the rectangle.
Discussion

The OffsetRect function moves the rectangle that you specify in the r parameter by adding the value you specify in the dh parameter to each of its horizontal coordinates and the value you specify in the dv parameter to each of its vertical coordinates. If the dh and dv parameters are positive, the movement is to the right and down; if either is negative, the corresponding movement is in the opposite direction. The rectangle retains its shape and size; it is merely moved on the coordinate plane. The movement does not affect the screen unless you subsequently call a function to draw within the rectangle.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

void OffsetRect (
   Rect * r,
   short dh,
   short dv
);

/*CreateCGContextForPort

Creates a Quartz 2D drawing environment associated with a graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Not Recommended

OSStatus CreateCGContextForPort (
   CGrafPtr port,
   CGContextRef * contextPtr
);
Parameters
port

A color graphics port in which to draw. Offscreen graphics worlds with pixel depths of 1, 2, 4, and 8 are not supported. When using Quartz 2D to draw in a offscreen graphics world, alpha information is always ignored. Printing ports are not supported—if you specify a printing port, this function does nothing and returns a non-zero result code. 
contextPtr

A pointer to your storage for a Quartz context. Upon completion, contextPtr points to a context associated with the port. The context matches the port’s pixel depth, width, and height. Otherwise the context is in a default state and does not necessarily match other port attributes such as foreground color, background color, or clip region.

You should release this context when you no longer need it.
Return Value

A result code. If noErr, the context was successfully created.
Discussion

This function is not recommended in Mac OS X version 10.1 and later. For information about its replacement, see QDBeginCGContext.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
OSStatus CreateCGContextForPort (
   CGrafPtr port,
   CGContextRef * contextPtr
);

/*EmptyRgn

Determines whether a region is empty. (Deprecated in Mac OS X v10.4.)

Boolean EmptyRgn (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to test for emptiness. 
Return Value

TRUE if the region whose handle you pass in the rgn parameter is an empty region or FALSE if it is not. 
Discussion

The EmptyRgn function does not create an empty region. To create an empty region, you can perform any of the following operations:
Use NewRgn. 
Pass the handle to an empty region to CopyRgn. 
Pass an empty rectangle to either SetRectRgn or RectRgn. 
Call CloseRgn without a previous call to OpenRgn. 
Call CloseRgn without performing any drawing after calling OpenRgn. 
Pass an empty region to OffsetRgn. 
Pass an empty region or too large an inset to InsetRgn
Pass two nonintersecting regions to SectRgn. 
Pass two empty regions to UnionRgn. 
Pass two identical or nonintersecting regions to DiffRgn or XorRgn. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Boolean EmptyRgn (
   RgnHandle rgn
);

/*ForeColor

Changes the color of the “ink” used for framing, painting, and filling on computers that support only basic QuickDraw. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void ForeColor (
   long color
);
Parameters
color

One of eight color values. See Color Constants.
Discussion

By default, the foreground color of a GrafPort is black.

The ForeColor function sets the foreground color for the current graphics port to the color that you specify in the color parameter. When you draw with the patCopy and srcCopy transfer modes, for example, black pixels are drawn in the color you specify with ForeColor.

When printing, use the ColorBit function to set the foreground color.

All nonwhite colors appear as black on black-and-white screens. Before you use ForeColor, use the DeviceLoop function to determine the color characteristics of the current screen. 
Special Considerations

The ForeColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

In System 7, you may instead use the color QuickDraw function RGBForeColor.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void ForeColor (
   long color
);

/*BackColor

Changes a basic graphics port’s background color. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void BackColor (
   long color
);
Parameters
color

One of eight color values. See Color Constants.
Discussion

The background color is the color of the pixels in the bitmap wherever no drawing has taken place. By default the background color of a GrafPort is white.

The BackColor function sets the background color for the current graphics port to the color that you specify in the color parameter. When you draw with the patCopy and srcCopy transfer modes, for example, white pixels are drawn in the color you specify with BackColor.

All nonwhite colors appear as black on black-and-white screens. Before you use BackColor, use the DeviceLoop function to determine the color characteristics of the current screen. 
Special Considerations

The BackColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

In System 7, use the Color QuickDraw function RGBBackColor.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void BackColor (
   long color
);


/*SetPortClipRegion

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPortClipRegion (
   CGrafPtr port,
   RgnHandle clipRgn
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPortClipRegion (
   CGrafPtr port,
   RgnHandle clipRgn
);

/*GetClip

Saves the clipping region of the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetClip (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to be clipped. The GetClip function changes this region to one that’s equivalent to the clipping region of the current graphics port. The GetClip function doesn’t change the region handle. 
Discussion

You can use the GetClip and SetClip functions to preserve the current clipping region: use GetClip to save the current port’s clipping region, and use SetClip to restore it. If, for example, you want to draw a half-circle on the screen, you can set the clipping region to half of the square that would enclose the whole circle, and then draw the whole circle. Only the half within the clipping region is actually drawn in the graphics port.

The GetClip function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetClip (
   RgnHandle rgn
);

/*DrawPicture

Draws a picture on any type of output device. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DrawPicture (
   PicHandle myPicture,
   const Rect * dstRect
);
Parameters
myPicture

A handle to the picture to be drawn. You must access a picture through its handle. 

When creating pictures, the OpenCPicture and OpenPicture functions return their handles. You can use the GetPicture function to get a handle to a QuickDraw picture stored in a 'PICT' resource. To get a handle to a QuickDraw picture stored in a 'PICT' file, you must use File Manager functions. To get a picture stored in the scrap, use the Scrap Manager function GetScrap to get a handle to its data and then coerce this handle to one of type PicHandle.

dstRect

A destination rectangle, specified in coordinates local to the current graphics port, in which to draw the picture. The DrawPicture function shrinks or expands the picture as necessary to align the borders of its bounding rectangle with the rectangle you specify in this parameter. To display a picture at a resolution other than that at which it was created, your application should compute an appropriate destination rectangle by scaling its width and height by the following factor:

scale factor = destination resolution / source resolution

For example, if a picture was created at 300 dpi and you want to display it at 75 dpi, then your application should compute the destination rectangle width and height as 1/4 of those of the picture’s bounding rectangle. Use the GetPictInfo function to gather information about a picture. The PictInfo structure returned by GetPictInfo returns the picture’s resolution in its hRes and vRes fields. The sourceRect field contains the bounding rectangle for displaying the image at its optimal resolution.
Discussion

Within the rectangle that you specify in the dstRect parameter, the DrawPicture function draws the picture that you specify in the myPicture parameter. 

The DrawPicture function passes any picture comments to the StdComment function pointed to by the commentProc field of the CQDProcs or QDProcs structure, which in turn is pointed to by the grafProcs field of a CGrafPort or GrafPort structure. The default StdComment function provided by QuickDraw does no comment processing whatsoever. If you want to process picture comments when drawing a picture, use the SetStdCProcs function to assist you in changing the CQDProcs structure and use the SetStdProcs function to assist you in changing the QDProcs structure. 
Special Considerations

Always use the ClipRect function to specify a clipping region appropriate for your picture before defining it with the OpenCPicture (or OpenPicture) function. If you do not use ClipRect to specify a clipping region, OpenCPicture uses the clipping region specified in the current graphics port. If the clipping region is very large (as it is when a graphics port is initialized) and you want to scale the picture, the clipping region can become invalid when DrawPicture scales the clipping region—in which case, your picture will not be drawn. On the other hand, if the graphics port specifies a small clipping region, part of your drawing may be clipped when DrawPicture draws it. Setting a clipping region equal to the port rectangle of the current graphics port always sets a valid clipping region.

When it scales, DrawPicture changes the size of the font instead of scaling the bits. However, the widths used by bitmap fonts are not always linear. For example, the 12-point width isn’t exactly 1/2 of the 24-point width. This can cause lines of text to become slightly longer or shorter as the picture is scaled. The difference is often insignificant, but if you are trying to draw a line of text that fits exactly into a box (a spreadsheet cell, for example), the difference can become noticeable to the user—most typically, at print time. The easiest way to avoid such problems is to specify a destination rectangle that is the same size as the bounding rectangle for the picture. Otherwise, your application may need to directly process the opcodes in the picture instead of using DrawPicture.

You may also have disappointing results if the fonts contained in an image are not available on the user’s system. Before displaying a picture, your application may want to use the Picture Utilities to determine what fonts are contained in the picture, and then use Font Manager functions to determine whether the fonts are available on the user’s system. If they are not, you can use Dialog Manager functions to display an alert box warning the user of display problems.

If there is insufficient memory to draw a picture in Color QuickDraw, the QDError function returns the result code noMemForPictPlaybackErr.

The DrawPicture function may move or purge memory.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DrawPicture (
   PicHandle myPicture,
   const Rect * dstRect
);


/*SetClip

Changes the clipping region of the current graphics port (basic or color) to a region you specify. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetClip (
   RgnHandle rgn
);
Parameters
rgn

A handle to a region. The SetClip function makes this region the clipping region of the current graphics port. The SetClip function doesn’t change the region handle, but instead affects the clipping region itself. 
Discussion

Since SetClip copies the specified region into the current graphics port’s clipping region, any subsequent changes you make to the region specified in the rgn parameter do not affect the clipping region of the graphics port.

The initial clipping region of a graphics port is an arbitrarily large rectangle. You can set the clipping region to any arbitrary region, to aid you in drawing inside the graphics port—for example, to avoid drawing over scroll bars when drawing into a window, you could define a clipping region that excludes the scroll bars. 

You can use the GetClip and SetClip functions to preserve the current clipping region: use GetClip to save the current port’s clipping region, and use SetClip to restore it.

All other system software functions preserve the current clipping region.

The SetClip function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SetClip (
   RgnHandle rgn
);

/*ClipCGContextToRegion

Sets the clipping path in a Quartz 2D graphics context, using a clipping region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

OSStatus ClipCGContextToRegion (
   CGContextRef context,
   const Rect * portRect,
   RgnHandle region
);
Parameters
context

A Quartz context associated with a graphics port. You can obtain such a context by calling QDBeginCGContext.
portRect

The portRect for the graphics port associated with the context.
region

A region that represents the desired clipping path.
Return Value

A result code. If noErr, the clipping path is now the region-based path.
Discussion

This function sets the clipping path in the specified context to closely approximate the geometry of the specified region. 

Unlike clipping in Quartz 2D, this function does not intersect the new region-based path with the current clipping path—the new path simply replaces the current clipping path.

You should use this function only when absolutely necessary—it’s relatively inefficient when compared to Quartz 2D clipping functions such as CGContextClipToRect.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

OSStatus ClipCGContextToRegion (
   CGContextRef context,
   const Rect * portRect,
   RgnHandle region
);

/*GetPortClipRegion

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

RgnHandle GetPortClipRegion (
   CGrafPtr port,
   RgnHandle clipRgn
);
Return Value
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

RgnHandle GetPortClipRegion (
   CGrafPtr port,
   RgnHandle clipRgn
);

/*FrameOval

Draws an outline inside an oval. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FrameOval (
   const Rect * r
);
Parameters
r

The rectangle that defines the oval’s boundary.
Discussion

Using the pattern, pattern mode, and size of the graphics pen for the current graphics port, the FrameOval function draws an outline just inside the oval with the bounding rectangle that you specify in the r parameter. The outline is as wide as the pen width and as tall as the pen height. The pen location does not change.

If a region is open and being formed, the outside outline of the new oval is mathematically added to the region’s boundary. 
Special Considerations

The FrameOval function may move or purge memory blocks in the application; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void FrameOval (
   const Rect * r
);

/*GetPortPixMap

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PixMapHandle GetPortPixMap (
   CGrafPtr port
);
Return Value
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

PixMapHandle GetPortPixMap (
   CGrafPtr port
);

/*QDGlobalToLocalPoint

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Point * QDGlobalToLocalPoint (
   CGrafPtr port,
   Point * point
);
Availability
Available in Mac OS X v10.2 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Point * QDGlobalToLocalPoint (
   CGrafPtr port,
   Point * point
);

/*SetPt

Assigns two coordinates to a point. (Deprecated in Mac OS X v10.4.)

void SetPt (
   Point * pt,
   short h,
   short v
);
Parameters
pt

A pointer to the point to be given new coordinates. On return, this point is assigned the horizontal coordinate you specify in the h parameter and the vertical coordinate you specify in the v parameter.
h

The horizontal value of the new coordinates.
v

The vertical value of the new coordinates.
Discussion

The SetPt procedure assigns the horizontal coordinate specified in the h parameter and the vertical coordinate specified in the v parameter to the point returned in the pt parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPt (
   Point * pt,
   short h,
   short v
);

/*GetPortPenMode

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

SInt32 GetPortPenMode (
   CGrafPtr port
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
SInt32 GetPortPenMode (
   CGrafPtr port
);

/*SetPortPenMode

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPortPenMode (
   CGrafPtr port,
   SInt32 penMode
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPortPenMode (
   CGrafPtr port,
   SInt32 penMode
);

/*GetQDGlobalsThePort

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CGrafPtr GetQDGlobalsThePort ();
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
CGrafPtr GetQDGlobalsThePort ();

/*LocalToGlobal

Converts a point’s coordinates from the local coordinates of the current graphics port (basic or color) to global coordinates. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void LocalToGlobal (
   Point * pt
);
Parameters
pt

A pointer to a point in local coordinates. On return, this point is converted to global coordinates.
Discussion

The LocalToGlobal function converts the given point from the current graphics port’s local coordinate system into the global coordinate system (where the upper-left corner of the main screen has coordinates [0,0]). This global point can then be compared to other global points, or it can be changed into the local coordinates of another graphics port.

Because a rectangle is defined by two points, you can convert a rectangle into global coordinates with two calls to LocalToGlobal. In conjunction with LocalToGlobal, you can use the OffsetRect, OffsetRgn, or OffsetPoly functions to convert a rectangle, region, or polygon into global coordinates. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void LocalToGlobal (
   Point * pt
);

/*GetMaxDevice

Obtains a handle to the GDevice structure for the video device with the greatest pixel depth. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetMaxDevice (
   const Rect * globalRect
);
Parameters
globalRect

A rectangle, in global coordinates, that intersects the graphics devices that you are searching to find the one with the greatest pixel depth.
Return Value

A handle to the device with the greatest pixel depth. 
Discussion

All existing GDevice structures are linked together in the device list. After using this function to obtain a handle to the current GDevice structure, your application can use the GetNextDevice function to obtain a handle to the next GDevice structure in the list. 
Special Considerations

The GetMaxDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
GDHandle GetMaxDevice (
   const Rect * globalRect
);

/*ObscureCursor

Hides the cursor until the next time the user moves the mouse. (Deprecated in Mac OS X v10.4.)

void ObscureCursor ();
Discussion

Your application normally calls ObscureCursor when the user begins to type. Unlike HideCursor , ObscureCursor has no effect on the cursor level and must not be balanced by a call to ShowCursor. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void ObscureCursor ();

/*SectRect

Determines whether two rectangles intersect. (Deprecated in Mac OS X v10.4.)

Boolean SectRect (
   const Rect * src1,
   const Rect * src2,
   Rect * dstRect
);
Parameters
src1

The first of two rectangles to test for intersection.
src2

The second of two rectangles to test for intersection.
dstRect

On return, a pointer to the rectangle marking the intersection of the first two rectangles.
Return Value

TRUE if the specified rectangles intersect or FALSE if they do not. 
Discussion

The SectRect function calculates the rectangle that delineates the intersection of the two rectangles you specify in the src1 and src2 parameters. Rectangles that touch at a line or a point are not considered intersecting, because their intersection rectangle (actually, in this case, an intersection line or point) does not enclose any pixels in the bit image.

If the rectangles do not intersect, the destination rectangle is set to (0,0,0,0). The SectRect function works correctly even if one of the source rectangles is also the destination.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Boolean SectRect (
   const Rect * src1,
   const Rect * src2,
   Rect * dstRect
);

/*EraseRgn

Erases a region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void EraseRgn (
   RgnHandle rgn
);
Parameters
rgn

The region to erase. 
Discussion

Using the patCopy pattern mode, the EraseRgn function draws the interior of the region whose handle you pass in the rgn parameter with the background pattern for the current graphics port. 

This function leaves the location of the graphics pen unchanged.

This function depends on the local coordinate system of the current graphics port. If you draw a region in a graphics port different from the one in which you defined the region, it may not appear in the proper position in the graphics port.

If any horizontal or vertical line drawn through the region would intersect the region’s outline more than 50 times, the results of this graphics operation are undefined. 
Special Considerations

The EraseRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void EraseRgn (
   RgnHandle rgn
);

/*DiffRgn

Subtracts one region from another. (Deprecated in Mac OS X v10.4.)

void DiffRgn (
   RgnHandle srcRgnA,
   RgnHandle srcRgnB,
   RgnHandle dstRgn
);
Parameters
srcRgnA

A handle to the region to subtract from. 
srcRgnB

A handle to the region to subtract.
dstRgn

On return, a handle to the region holding the resulting area. If the first source region is empty, DiffRgn sets the destination to the empty region defined by the rectangle (0,0,0,0).

The DiffRgn function does not create the destination region; you must have already allocated memory for it by using the NewRgn function. 

The destination region may be one of the source regions, if desired.
Discussion

The DiffRgn procedure subtracts the region whose handle you pass in the srcRgnB parameter from the region whose handle you pass in the srcRgnA parameter and places the difference in the region whose handle you pass in the dstRgn parameter. If the first source region is empty, DiffRgn sets the destination to the empty region defined by the rectangle (0,0,0,0).

The DiffRgn procedure does not create the destination region; you must have already allocated memory for it by using the NewRgn function. The destination region may be one of the source regions, if desired. 
Special Considerations

The DiffRgn function may temporarily use heap space that’s twice the size of the two input regions.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DiffRgn (
   RgnHandle srcRgnA,
   RgnHandle srcRgnB,
   RgnHandle dstRgn
);

/*InsetRgn

Shrinks or expands a region. (Deprecated in Mac OS X v10.4.)

void InsetRgn (
   RgnHandle rgn,
   short dh,
   short dv
);
Parameters
rgn

A handle to the region to alter. 
dh

The horizontal distance to move points on the left and right boundaries in toward or outward from the center.
dv

The vertical distance to move points on the top and bottom boundaries in toward or outward from the center.
Discussion

The InsetRgn function moves all points on the region boundary of the region whose handle you pass in the rgn parameter inward by the vertical distance that you specify in the dv parameter and by the horizontal distance that you specify in the dh parameter. If you specify negative values for dh or dv, the InsetRgn function moves the points outward in that direction. 

The InsetRgn function leaves the region’s center at the same position, but moves the outline in (for positive values of dh and dv) or out (for negative values of dh and dv). Using InsetRgn on a rectangular region has the same effect as using the InsetRect function. 
Special Considerations

The InsetRgn function temporarily uses heap space that’s twice the size of the original region.

The InsetRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void InsetRgn (
   RgnHandle rgn,
   short dh,
   short dv
);

/*AddPt

Adds the coordinates of two points. (Deprecated in Mac OS X v10.4.)

void AddPt (
   Point src,
   Point * dst
);
Parameters
src

A point, the coordinates of which are to be added to the point in the dstPt parameter.
dst

A pointer to a point, the coordinates of which are to be added to the point in the srcPt parameter. On return, this value contains the result of adding the coordinates of the points you supplied in the srcPt and dstPt parameters.
Discussion

The AddPt function adds the coordinates of the point specified in the srcPt parameter to the coordinates of the point specified in the dstPt parameter, and returns the result in the dstPt parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void AddPt (
   Point src,
   Point * dst
);

/*QDLocalToGlobalRect

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Rect * QDLocalToGlobalRect (
   CGrafPtr port,
   Rect * bounds
);
Availability
Available in Mac OS X v10.2 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Rect * QDLocalToGlobalRect (
   CGrafPtr port,
   Rect * bounds
);

/*GetQDGlobalsLightGray

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Pattern * GetQDGlobalsLightGray (
   Pattern * ltGray
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Pattern * GetQDGlobalsLightGray (
   Pattern * ltGray
);

/*GetCTSeed

Obtains a unique seed value for a color table created by your application. This function is used by system software and your application should not need to call it. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

long GetCTSeed ();
Return Value

A unique seed value that you can use in the ctSeed field of a color table created by your application. It is greater than the value stored in the constant minSeed. 
Discussion

The seed value guarantees that the color table is recognized as distinct from the destination, and that color table translation is performed properly. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
long GetCTSeed ();

/*NewQDBitsUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDBitsUPP NewQDBitsUPP (
   QDBitsProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDBitsUPP NewQDBitsUPP (
   QDBitsProcPtr userRoutine
);

/*NewQDRgnUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDRgnUPP NewQDRgnUPP (
   QDRgnProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDRgnUPP NewQDRgnUPP (
   QDRgnProcPtr userRoutine
);

/*NewQDPolyUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDPolyUPP NewQDPolyUPP (
   QDPolyProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDPolyUPP NewQDPolyUPP (
   QDPolyProcPtr userRoutine
);

/*NewQDArcUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDArcUPP NewQDArcUPP (
   QDArcProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/


QDArcUPP NewQDArcUPP (
   QDArcProcPtr userRoutine
);


/*NewQDTextUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDTextUPP NewQDTextUPP (
   QDTextProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h */

QDTextUPP NewQDTextUPP (
   QDTextProcPtr userRoutine
);

/*NewQDRectUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDRectUPP NewQDRectUPP (
   QDRectProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
QDRectUPP NewQDRectUPP (
   QDRectProcPtr userRoutine
);

/*NewQDLineUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDLineUPP NewQDLineUPP (
   QDLineProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDLineUPP NewQDLineUPP (
   QDLineProcPtr userRoutine
);

/*NewQDOvalUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDOvalUPP NewQDOvalUPP (
   QDOvalProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
QDOvalUPP NewQDOvalUPP (
   QDOvalProcPtr userRoutine
);

/*NewQDRRectUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDRRectUPP NewQDRRectUPP (
   QDRRectProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDRRectUPP NewQDRRectUPP (
   QDRRectProcPtr userRoutine
);

/*SetStdCProcs

Obtains a CQDProcs structure with fields that point to QuickDraw’s standard low-level functions, which you can modify to change QuickDraw’s standard low-level behavior. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetStdCProcs (
   CQDProcs * procs
);
Parameters
procs

Upon completion, a CQDProcs structure with fields that point to QuickDraw’s standard low-level functions. You can change one or more fields to point to your own functions and then set the color graphics port to use this modified CQDProcs structure. 
Discussion

For each shape that QuickDraw can draw, certain functions perform basic graphics operations on the shape: framing, painting, erasing, inverting, and filling. These functions, in turn, call a low-level drawing function for the shape.

The grafProcs field determines which low-level functions are called. If that field contains a value of NULL, the standard functions are called. You can set the grafProcs field to point to a structure of pointers to your own functions, and either completely override the standard ones or call them after your functions have modified their parameters as necessary.

The SetStdCProcs function sets all the fields of the CQDProcs structure to point to the standard functions. You can then reset the ones with which you are concerned.

The functions you install in the CDQProcs structure must have the same calling sequences as the standard basic QuickDraw functions.

When drawing in a color graphics port, your application must always use SetStdCProcs instead of SetStdProcs. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetStdCProcs (
   CQDProcs * procs
);

/*GetPixDepth

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

short GetPixDepth (
   PixMapHandle pixMap
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

short GetPixDepth (
   PixMapHandle pixMap
);

/*BackPat

Changes the bit pattern used as the background pattern by the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void BackPat (
   const Pattern * pat
);
Parameters
pat

A bit pattern, as defined by a Pattern structure. 
Discussion

The BackPat function sets the bit pattern defined in the Pattern structure, which you specify in the pat parameter, to be the background pattern. (The standard bit patterns white, black, gray, ltGray, and dkGray are predefined; the initial background pattern for the graphics port is white.) This pattern is stored in the bkPat field of a GrafPort structure.

The BackPat function also sets a bit pattern for the background color in a color graphics port. The BackPat function creates a handle, of type PixPatHandle, for the bit pattern and stores this handle in the bkPixPat field of the CGrafPort structure. As in basic graphics ports, Color QuickDraw draws patterns in color graphics ports at the time of drawing, not at the time you use PenPat to set the pattern.

To define your own patterns, you typically create pattern, ‘PAT’, or pattern list, ‘PAT#’, resources. 
Special Considerations

The BackPat function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/


void BackPat (
   const Pattern * pat
);

/*FrameRoundRect

Draws an outline inside a rounded rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FrameRoundRect (
   const Rect * r,
   short ovalWidth,
   short ovalHeight
);
Parameters
r

The rectangle that defines the rounded rectangle’s boundaries.
ovalWidth

The width of the oval defining the rounded corner.
ovalHeight

The height of the oval defining the rounded corner.
Discussion

Using the pattern, pattern mode, and size of the graphics pen for the current graphics port, the FrameRoundRect function draws an outline just inside the rounded rectangle bounded by the rectangle that you specify in the r parameter. The outline is as wide as the pen width and as tall as the pen height. The pen location does not change. 

Use the ovalWidth and ovalHeight parameters to specify the diameters of curvature for the corners of the rounded rectangle.

If a region is open and being formed, the outside outline of the new rounded rectangle is mathematically added to the region’s boundary. 
Special Considerations

The FrameRoundRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void FrameRoundRect (
   const Rect * r,
   short ovalWidth,
   short ovalHeight
);

/*GetPicture

Obtains a handle to a picture stored in a 'PICT' resource. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PicHandle GetPicture (
   short pictureID
);
Parameters
pictureID

The resource ID for a 'PICT' resource.
Return Value

A handle to the picture in the specified ‘PICT’ resource. To draw the picture stored in the resource, pass this handle to the DrawPicture function. If the resource cannot be read, GetPicture returns NULL. 
Discussion

The GetPicture function calls the Resource Manager function GetResource as follows:

GetResource(‘PICT’, picID) 
Special Considerations

To release the memory occupied by a picture stored in a 'PICT' resource, use the Resource Manager function ReleaseResource.

The GetPicture function may move or purge memory.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

PicHandle GetPicture (
   short pictureID
);

/*GetCTable

Obtains a color table stored in a 'clut' resource. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CTabHandle GetCTable (
   short ctID
);
Parameters
ctID

The resource ID of a 'clut' resource.
Return Value

A handle to the color table. If the 'clut' resource with that ID is not found, GetCTable returns NULL.Before you place this handle in the pmTable field of a PixMap structure, first use the DisposeCTable function to dispose of the handle already there. 
Discussion

Before you modify a ColorTable structure, change its ctSeed field to invalidate it. To do this, use the CTabChanged function.

The GetCTable function recognizes a number of standard 'clut' resource IDs. You can obtain the default grayscale color table for a given pixel depth by calling GetCTable, adding 32 (decimal) to the pixel depth, and passing these values in the ctID parameter:
A pixel depth of 1Pass a resource ID of 33. Color table composition: black, white. 
A pixel depth of 2Pass a resource ID of 34. Color table composition: black, 33% gray, 66% gray, white. 
A pixel depth of 4Pass a resource ID of 36. Color table composition: black, 14 shades of gray, white. 
A pixel depth of 8Pass a resource ID of 40. Color table composition: black, 254 shades of gray, white. 

For full color, obtain the default color tables by adding 64 to the pixel depth and passing these values in the ctID parameter:
A pixel depth of 2Pass a resource ID of 66. Color table composition: black, 50% gray, highlight color, white. 
A pixel depth of 4Pass a resource ID of 68. Color table composition: black, 14 colors including the highlight color, white. 
A pixel depth of 8Pass a resource ID of 72. Color table composition: black, 254 colors including the highlight color, white. 
Special Considerations

The GetCTable function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

CTabHandle GetCTable (
   short ctID
);

/*EmptyRect

Determines whether a rectangle is an empty rectangle. (Deprecated in Mac OS X v10.4.)

Boolean EmptyRect (
   const Rect * r
);
Parameters
r

The rectangle to examine.
Return Value

TRUE if the rectangle that you specify in the r parameter is an empty rectangle, FALSE if it is not. A rectangle is considered empty if the bottom coordinate is less than or equal to the top coordinate or if the right coordinate is less than or equal to the left. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Boolean EmptyRect (
   const Rect * r
);

/*EqualRect

Determines whether two rectangles are equal. 

Boolean EqualRect (
   const Rect * rect1,
   const Rect * rect2
);
Parameters
rect1

The first of two rectangles to compare.
rect2

The second of two rectangles to compare.
Return Value

TRUE if the rectangles are equal, FALSE if they are not. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
Boolean EqualRect (
   const Rect * rect1,
   const Rect * rect2
);

/*GetForeColor

Obtains the color of the foreground color for the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetForeColor (
   RGBColor * color
);
Parameters
color

On return, the RGBColor structure for the current foreground color. 
Discussion

This function operates for graphics ports defined by both the GrafPort and CGrafPort structures. If the current graphics port is defined by a CGrafPort structure, the returned value is taken directly from the rgbFgColor field. 

If the current graphics port is defined by a GrafPort structure, then only eight possible RGB values can be returned. These eight values are determined by the values in a global variable named QDColors, which is a handle to a color table containing the current QuickDraw colors.

Use the RGBForeColor function to change the foreground color. 
Version Notes

This function is available for basic QuickDraw only in System 7.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetForeColor (
   RGBColor * color
);

/*PaintRgn

Paints a region with the graphics pen’s pattern and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PaintRgn (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to paint. 
Discussion

Using the pen pattern and pattern mode for the current graphics port, the PaintRgn function draws the interior of the region whose handle you pass in the rgn parameter. The pen location does not change.

This function depends on the local coordinate system of the current graphics port. If you draw a region in a graphics port different from the one in which you defined the region, it may not appear in the proper position in the graphics port.

If any horizontal or vertical line drawn through the region would intersect the region’s outline more than 50 times, the results of this graphics operation are undefined. 

Use FillRgn to draw the interior of a region with a pen pattern different from that for the current graphics port. 
Special Considerations

The PaintRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

void PaintRgn (
   RgnHandle rgn
);


#ifdef __cplusplus
}
#endif

#endif