#ifndef  DNS_SD_H
#define DNS_SD_H

#include <stdint.h>//hys

#ifdef  __cplusplus
    extern "C" {
#endif

/*(Flag Constants

enum { 
    kDNSServiceFlagsMoreComing = 0x1, 
    kDNSServiceFlagsAdd = 0x2, 
    kDNSServiceFlagsDefault = 0x4, 
    kDNSServiceFlagsNoAutoRename = 0x8, 
    kDNSServiceFlagsShared = 0x10, 
    kDNSServiceFlagsUnique = 0x20, 
    kDNSServiceFlagsBrowseDomains = 0x40, 
    kDNSServiceFlagsRegistrationDomains = 0x80, 
    kDNSServiceFlagsLongLivedQuery = 0x100, 
    kDNSServiceFlagsAllowRemoteQuery = 0x200, 
    kDNSServiceFlagsForceMulticast = 0x400 
};  
Constants
kDNSServiceFlagsMoreComing
MoreComing indicates to a callback that at least one more result is queued and will be delivered following immediately after this one. Applications should not update their UI to display browse results when the MoreComing flag is set, because this would result in a great deal of ugly flickering on the screen. Applications should instead wait until until MoreComing is not set, and then update their UI. When MoreComing is not set, that doesn't mean there will be no more answers EVER, just that there are no more answers immediately available right now at this instant. If more answers become available in the future they will be delivered as usual. 

kDNSServiceFlagsAdd
kDNSServiceFlagsAdd is set in the flags parameter and passed to your DNSServiceBrowseReply, DNSServiceDomainEnumReply, DNSServiceQueryRecordReply callback functions to indicate that a domain should be added to the list of domain names that your application maintains. A flags parameter in which kDNSServiceFlagsAdd is not set indicates that the service, domain, or record is no longer available and should be removed from the list that your application maintains. 

kDNSServiceFlagsDefault
kDNSServiceFlagsDefault is set in the flags parameter and passed to your DNSServiceDomainEnumReply callback function to indicate that the enumerated domain is a default domain. When kDNSServiceFlagsDefault is set, kDNSServiceFlagsAdd is also set. 

kDNSServiceFlagsNoAutoRename
Flag for specifying renaming behavior on name conflict when registering non-shared records. By default, name conflicts are automatically handled by renaming the service. NoAutoRename overrides this behavior - with this flag set, name conflicts will result in a callback. The NoAutorename flag is only valid if a name is explicitly specified when registering a service (ie the default name is not used.) 

kDNSServiceFlagsShared
kDNSServiceFlagsShared is set in the flags parameter and passed to DNSServiceRegisterRecord when registering a resource record over a connection with the mDNSResponder daemon. Setting kDNSServiceFlagsShared indicates that multiple records having the same full domain name on the network are allowed. For example, you would set kDNSServiceFlagsShared when registering PTR records that have the same full domain name. 

kDNSServiceFlagsUnique
kDNSServiceFlagsUnique is set in the flags parameter and passed to DNSServiceRegisterRecord when registering a resource record whose name must be unique on the network. For example, you would set kDNSServiceFlagsUnique when registering a DNS-SD SRV record. 

kDNSServiceFlagsBrowseDomains
kDNSServiceFlagsBrowseDomains is set in the flags parameter and passed to DNSServiceEnumerateDomains to indicate that domains recommended for browsing are to be enumerated. 

kDNSServiceFlagsRegistrationDomains
kDNSServiceFlagsRegistrationDomains is set in the flags parameter and passed to DNSServiceEnumerateDomains to indicate that domains recommended for registration are to be enumerated. 

kDNSServiceFlagsLongLivedQuery
kDNSServiceFlagsLongLivedQuery is set in the flags parameter and passed to DNSServiceQueryRecord in order to create a long-lived unicast query in a non-local domain. When this bit is not set, unicast queries are "one-shot"; that is, only responses that are available at the time of the call are returned. When the kDNSServiceFlagsLongLivedQuery bit is set, your DNSServiceQueryRecordReply callback function will be called to deliver responses for add and remove events that occur after the initial call. You are always responsible for freeing memory and resources associated with the service discovery reference and terminating the query. This flag has no effect on link-local multicast queries. 

kDNSServiceFlagsAllowRemoteQuery
kDNSServiceFlagsAllowRemoteQuery is set in the flags parameter and passed to DNSServiceRegister and DNSServiceRegisterRecord to create a record for which mDNSResponder will respond to remote queries from hosts that are not directly connected to the local link (that is, more than one hop away). 

kDNSServiceFlagsForceMulticast
kDNSServiceFlagsForceMulticast is set in the flags parameter and passed to DNSServiceQueryRecord and DNSServiceRegisterRecord to specify that a query or registration is to be performed by multicast DNS, even for a name in a domain that would normally be performed by unicast DNS.
Discussion 

These constants are used to set bits in the flags parameter to many DNS Service Discovery functions and callbacks.*/
enum { 
    kDNSServiceFlagsMoreComing = 0x1, 
    kDNSServiceFlagsAdd = 0x2, 
    kDNSServiceFlagsDefault = 0x4, 
    kDNSServiceFlagsNoAutoRename = 0x8, 
    kDNSServiceFlagsShared = 0x10, 
    kDNSServiceFlagsUnique = 0x20, 
    kDNSServiceFlagsBrowseDomains = 0x40, 
    kDNSServiceFlagsRegistrationDomains = 0x80, 
    kDNSServiceFlagsLongLivedQuery = 0x100, 
    kDNSServiceFlagsAllowRemoteQuery = 0x200, 
    kDNSServiceFlagsForceMulticast = 0x400 
};  


/*DNSServiceFlags

typedef uint32_t DNSServiceFlags;  */
typedef uint32_t DNSServiceFlags;  

/*Errors


Possible error code values. 
enum { 
    kDNSServiceErr_NoError = 0, 
    kDNSServiceErr_Unknown = -65537, 
    kDNSServiceErr_NoSuchName = -65538, 
    kDNSServiceErr_NoMemory = -65539, 
    kDNSServiceErr_BadParam = -65540, 
    kDNSServiceErr_BadReference = -65541, 
    kDNSServiceErr_BadState = -65542, 
    kDNSServiceErr_BadFlags = -65543, 
    kDNSServiceErr_Unsupported = -65544, 
    kDNSServiceErr_NotInitialized = -65545, 
    kDNSServiceErr_AlreadyRegistered = -65547, 
    kDNSServiceErr_NameConflict = -65548, 
    kDNSServiceErr_Invalid = -65549, 
    kDNSServiceErr_Firewall = -65550, 
    kDNSServiceErr_Incompatible = -65551, 
    kDNSServiceErr_BadInterfaceIndex = -65552, 
    kDNSServiceErr_Refused = -65553, 
    kDNSServiceErr_NoSuchRecord = -65554, 
    kDNSServiceErr_NoAuth = -65555, 
    kDNSServiceErr_NoSuchKey = -65556, 
    kDNSServiceErr_NATTraversal = -65557, 
    kDNSServiceErr_DoubleNAT = -65558, 
    kDNSServiceErr_BadTime = -65559 
};  
Constants
kDNSServiceErr_NoError
kDNSServiceErr_Unknown
0xFFFE FFFF
kDNSServiceErr_NoSuchName
kDNSServiceErr_NoMemory
kDNSServiceErr_BadParam
kDNSServiceErr_BadReference
kDNSServiceErr_BadState
kDNSServiceErr_BadFlags
kDNSServiceErr_Unsupported
kDNSServiceErr_NotInitialized
kDNSServiceErr_AlreadyRegistered
kDNSServiceErr_NameConflict
kDNSServiceErr_Invalid
kDNSServiceErr_Incompatible
Client library incompatible with daemon.
kDNSServiceErr_BadInterfaceIndex
kDNSServiceErr_Refused
kDNSServiceErr_NoSuchRecord
kDNSServiceErr_NoAuth
Discussion 

mDNS Error codes are in the range FFFE FF00 (-65792) to FFFE FFFF (-65537).*/
enum { 
    kDNSServiceErr_NoError = 0, 
    kDNSServiceErr_Unknown = -65537, 
    kDNSServiceErr_NoSuchName = -65538, 
    kDNSServiceErr_NoMemory = -65539, 
    kDNSServiceErr_BadParam = -65540, 
    kDNSServiceErr_BadReference = -65541, 
    kDNSServiceErr_BadState = -65542, 
    kDNSServiceErr_BadFlags = -65543, 
    kDNSServiceErr_Unsupported = -65544, 
    kDNSServiceErr_NotInitialized = -65545, 
    kDNSServiceErr_AlreadyRegistered = -65547, 
    kDNSServiceErr_NameConflict = -65548, 
    kDNSServiceErr_Invalid = -65549, 
    kDNSServiceErr_Firewall = -65550, 
    kDNSServiceErr_Incompatible = -65551, 
    kDNSServiceErr_BadInterfaceIndex = -65552, 
    kDNSServiceErr_Refused = -65553, 
    kDNSServiceErr_NoSuchRecord = -65554, 
    kDNSServiceErr_NoAuth = -65555, 
    kDNSServiceErr_NoSuchKey = -65556, 
    kDNSServiceErr_NATTraversal = -65557, 
    kDNSServiceErr_DoubleNAT = -65558, 
    kDNSServiceErr_BadTime = -65559 
};  


/*DNSServiceErrorType

typedef int32_t DNSServiceErrorType;  */
typedef int32_t DNSServiceErrorType;


/*DNSServiceRef

typedef struct _DNSServiceRef_t *DNSServiceRef;  
Discussion 

Opaque internal data type. Note: client is responsible for serializing access to these structures if they are shared between concurrent threads.*/
typedef struct _DNSServiceRef_t *DNSServiceRef;  


/*DNSServiceQueryRecordReply


Your application implements this callback function to receive replies from the mDNSResponder daemon in response to calling DNSServiceQueryRecord.
typedef void ( *DNSServiceQueryRecordReply) ( 
    DNSServiceRef DNSServiceRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    DNSServiceErrorType errorCode, 
    const char *fullname, 
    uint16_t rrtype, 
    uint16_t rrclass, 
    uint16_t rdlen, 
    const void *rdata, 
    uint32_t ttl, 
    void *context );  
Parameters
DNSServiceRef
The DNSServiceRef initialized by DNSServiceQueryRecord(). 

flags
Possible values are:
kDNSServiceFlagsMoreComing 
kDNSServiceFlagsAdd


interfaceIndex
The interface on which the query was resolved (the index for a given interface is determined via the if_nametoindex() family of calls). 

errorCode
Will be kDNSServiceErr_NoError on success, otherwise will indicate the failure that occurred. Other parameters are undefined if errorCode is non-zero. 

fullname
The resource record's full domain name. 

rrtype
The resource record's type (e.g. PTR, SRV,...) as defined in nameser.h. 

rrclass
The class of the resource record, as defined in nameser.h (usually 1). 

rdlen
The length, in bytes, of the resource record rdata. 

rdata
The raw rdata of the resource record. 

ttl
The resource record's time to live, in seconds. 

context
The context pointer that was passed to the callout. 

Discussion 

This is a prototype for your callback function that handles replies from DNSServiceQueryRecord. If a matching record was found, your callback function will be called and passed the matching record's resource record data, the length of that data in bytes, and the record's time-to-live value. 

If kDNSServiceMoreComing is set in flags, your callback function will be called with additional query results within the next 50 milliseconds. Applications should not update their user interface with search results until their callback function is called with a value of flags in which kDNSServiceMoreComing is not set. 

Your application is responsible for stopping the query. Remove sdRef from the run or select() loop, and call DNSServiceRefDeallocate to deallocate sdRef, which stops the query, terminates the connection with the mDNSResponder daemon, and frees the memory associated with sdRef.*/
typedef void ( *DNSServiceQueryRecordReply) ( 
    DNSServiceRef DNSServiceRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    DNSServiceErrorType errorCode, 
    const char *fullname, 
    uint16_t rrtype, 
    uint16_t rrclass, 
    uint16_t rdlen, 
    const void *rdata, 
    uint32_t ttl, 
    void *context );  


//func

/*DNSServiceRefDeallocate


Deallocates a service discovery reference.
void DNSServiceRefDeallocate(
    DNSServiceRef sdRef);  
Parameters
sdRef
A DNSServiceRef initialized by any of the DNSService calls. 

Discussion 

This call is to be used only with the DNSServiceRef defined by this API. It is not compatible with dns_service_discovery_ref objects defined in the legacy Mach-based DNSServiceDiscovery.h API.*/
void DNSServiceRefDeallocate(
    DNSServiceRef sdRef);  

/*DNSServiceProcessResult


Gets a response from the mDNSResponder daemon and calls the appropriate callback function.
DNSServiceErrorType DNSServiceProcessResult(
    DNSServiceRef sdRef);  
Parameters
sdRef
A DNSServiceRef initialized by any of the DNSService calls that take a callback parameter. 

Return Value

Returns kDNSServiceErr_NoError on success, otherwise returns an error code indicating the specific failure that occurred. 
Discussion 

Read a reply from the daemon, calling the appropriate application callback. This call will block until the daemon's response is received. Use DNSServiceRefSockFD() in conjunction with a run loop or select() to determine the presence of a response from the server before calling this function to process the reply without blocking. Call this function at any point if it is acceptable to block until the daemon's response arrives. Note that the client is responsible for ensuring that DNSServiceProcessResult() is called whenever there is a reply from the daemon - the daemon may terminate its connection with a client that does not process the daemon's responses.*/
DNSServiceErrorType DNSServiceProcessResult(
    DNSServiceRef sdRef);  

/*DNSServiceRefSockFD


Returns the socket descriptor for a service discovery reference.
int DNSServiceRefSockFD(
    DNSServiceRef sdRef);  
Parameters
sdRef
A DNSServiceRef initialized by any of the DNSService calls. 

Return Value

The DNSServiceRef's underlying socket descriptor, or -1 on error. 
Discussion 

Access underlying Unix domain socket for an initialized DNSServiceRef. The DNS Service Discovery implementation uses this socket to communicate between the client and the mDNSResponder daemon. The application MUST NOT directly read from or write to this socket. Access to the socket is provided so that it can be used as a run loop source, or in a select() loop: when data is available for reading on the socket, DNSServiceProcessResult() should be called, which will extract the daemon's reply from the socket, and pass it to the appropriate application callback. By using a run loop or select(), results from the daemon can be processed asynchronously. Without using these constructs, DNSServiceProcessResult() will block until the response from the daemon arrives. The client is responsible for ensuring that the data on the socket is processed in a timely fashion - the daemon may terminate its connection with a client that does not clear its socket buffer.*/
int DNSServiceRefSockFD(
    DNSServiceRef sdRef);  

/*DNSServiceQueryRecord


Gets the resource data from the specified resource record.
DNSServiceErrorType DNSServiceQueryRecord ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    const char *fullname, 
    uint16_t rrtype, 
    uint16_t rrclass, 
    DNSServiceQueryRecordReply callBack, 
    void *context / may be NULL *
    );  
Parameters
sdRef
A pointer to an uninitialized DNSServiceRef. If the call succeeds then it initializes the DNSServiceRef, returns kDNSServiceErr_NoError, and the query operation will run indefinitely until the client terminates it by passing this DNSServiceRef to DNSServiceRefDeallocate(). 

flags
Pass kDNSServiceFlagsLongLivedQuery to create a "long-lived" unicast query in a non-local domain. Without setting this flag, unicast queries will be one-shot - that is, only answers available at the time of the call will be returned. By setting this flag, answers (including Add and Remove events) that become available after the initial call is made will generate callbacks. This flag has no effect on link-local multicast queries. 

interfaceIndex
If non-zero, specifies the interface on which to issue the query (the index for a given interface is determined via the if_nametoindex() family of calls.) Passing 0 causes the name to be queried for on all interfaces. See "Constants for specifying an interface index" for more details. 

fullname
The full domain name of the resource record to be queried for. 

rrtype
The numerical type of the resource record to be queried for (e.g. kDNSServiceType_PTR, kDNSServiceType_SRV, etc) 

rrclass
The class of the resource record (usually kDNSServiceClass_IN). 

callBack
The function to be called when a result is found, or if the call asynchronously fails. 

context
An application context pointer which is passed to the callback function (may be NULL). 

Return Value

Returns kDNSServiceErr_NoError on success (any subsequent, asynchronous errors are delivered to the callback), otherwise returns an error code indicating the error that occurred (the callback is never invoked and the DNSServiceRef is not initialized.) 
Discussion 

This function queries the specified interfaces (if interfaceIndex is non-zero) or all interfaces (if interfaceIndex is zero) for a resource record that matches the values specified by the fullName, rrtype, and rrclass parameters. If your application needs to monitor TXT record changes, you should use this function. 

If DNSServiceQueryRecord returns kDNSServiceErr_NoError, the query was started, and sdRef is initialized. Call DNSServiceRefSockFD and pass sdRef to it to get the descriptor for the underlying socket. Use the descriptor that DNSServiceRefSockFD returns to set up a run loop or a select() loop. When the loop indicates that a response is available, call DNSServiceProcessResult and pass sdRef to it. DNSServiceProcessResult will call the callback function specified by callBack and pass to it the response from the mDNSResponder daemon. 

If you don't want to set up a run or select() loop, you can call DNSServiceProcessResult immediately after calling DNSServiceQueryRecord. In this case, DNSServiceProcessResult will block until a response from the mDNSResponder daemon becomes available. When a response becomes available, DNSServiceProcessResult will call your callback function and pass to it the response from the mDNSResponder daemon. 

Regardless of the value of the flags parameter, you always need to call DNSServiceRefDeallocate on sdRef to free the memory and resources associated with a query and terminate the query. 

For information about the callback function for DNSServiceQueryRecord, see DNSServiceQueryRecordReply.*/

DNSServiceErrorType DNSServiceQueryRecord ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    const char *fullname, 
    uint16_t rrtype, 
    uint16_t rrclass, 
    DNSServiceQueryRecordReply callBack, 
    void *context /* may be NULL */
    );  


#ifdef  __cplusplus
    }
#endif


#endif  
