#import <CoreData/NSManagedObjectID.h>

 @implementation  NSManagedObjectID 

/*isTemporaryID

Returns a Boolean that indicates whether or not the receiver is temporary.

- (BOOL)isTemporaryID
Return Value

YES if the receiver is temporary, otherwise NO.
Discussion

Most object IDs return NO. New objects inserted into a managed object context are assigned a temporary ID which is replaced with a permanent one once the object gets saved to a persistent store.
Availability
Available in Mac OS X v10.4 and later.*/
- (BOOL)isTemporaryID{}


/*URIRepresentation

Returns a URI that provides an archivable reference to the object which this ID represents.

- (NSURL *)URIRepresentation
Return Value

An NSURL object containing a URI that provides an archivable reference to the object which this ID represents.
Discussion

If the corresponding managed object has not yet been saved, the object ID (and hence URI) is a temporary value that will change when the corresponding managed object is saved.
Availability
Available in Mac OS X v10.4 and later.
See Also
managedObjectIDForURIRepresentation: (NSPersistentStoreCoordinator)
objectWithID:: (NSManagedObjectContext)*/
- (NSURL *)URIRepresentation{}


/*persistentStore

Returns the persistent store that contains the object with this ID.

- (id)persistentStore
Return Value

The persistent store that contains the object with this ID, or nil if the ID is for a newly-inserted object that has not yet been saved to a persistent store.
Availability
Available in Mac OS X v10.4 and later.*/
- (id)persistentStore{}







@end
