#include <DiscRecordingEngine/DRTrack.h>

/*DRTrackLengthKey

extern NSString* const DRTrackLengthKey;  
Discussion 

DRMSF representing the length of the track 
Availability
Introduced in Mac OS X v10.2*/
 NSString* const DRTrackLengthKey=1;  //?

/*DRBlockSizeKey

extern NSString* const DRBlockSizeKey;  
Discussion 

NSNumber containing the size in bytes of each track block. See the Mt. Fuji (INF-8090i) specification for CD/DVD devices for possible values for this property. 
Availability
Introduced in Mac OS X v10.2*/
NSString* const DRBlockSizeKey=1;  //?

/*DRDataFormKey

extern NSString* const DRDataFormKey;  
Discussion 

NSNumber containing the data form of each block in the track. See the Mt. Fuji (INF-8090i) specification for CD/DVD devices for possible values for this property. 
Availability
Introduced in Mac OS X v10.2*/
 NSString* const DRDataFormKey=1;  //?

/*DRBlockTypeKey

extern NSString* const DRBlockTypeKey;  
Discussion 

NSNumber containing the type of each track block. See the Mt. Fuji (INF-8090i) specification for CD/DVD devices for possible values for this property. 
Availability
Introduced in Mac OS X v10.2*/
 NSString* const DRBlockTypeKey=1;  //?

/*DRTrackModeKey

extern NSString* const DRTrackModeKey;  
Discussion 

NSNumber containing the track mode of the track. See the Mt. Fuji (INF-8090i) specification for CD/DVD devices for possible values for this property. 
Availability
Introduced in Mac OS X v10.2*/
 NSString* const DRTrackModeKey=1 ;  //?

/*DRSessionFormatKey

extern NSString* const DRSessionFormatKey;  
Discussion 

NSNumber containing the session format of the track. See the Mt. Fuji (INF-8090i) specification for CD/DVD devices for possible values for this property. 
Availability
Introduced in Mac OS X v10.2*/
 NSString* const DRSessionFormatKey=1;  //?



@implementation DRTrack

/*initWithProducer:


Initializes a DRTrack with the producer 
private

- (id) initWithProducer:(id)producer; 
Parameters
producer
The object to use as the data producer
Return Value

A DRTrack*/
- (id) initWithProducer:(id)producer{}


/*setProperties:


Sets the properties dictionary of the track 
private

- (void) setProperties:(NSDictionary*)properties; 
Parameters
properties
NSDictionary of the properties to set.*/
- (void) setProperties:(NSDictionary*)properties{}

/*properties


Returns the properties dictionary of the track. 
private

- (NSDictionary*) properties; 
Return Value

An NSDictionary containing the properties of the track.*/
- (NSDictionary*) properties{}



@end



 @implementation DRTrack (PropertyConvenience)
/*length


Returns the length of the track data. 
private

- (DRMSF*) length;
Return Value

A DRMSF representing the length of the track. 
Discussion 

The length returned does not include the length of the pregap. Only the length of the track data itself is returned. This is a simple wrapper to obtain the DRTrackLengthKey . If the DRTrackLengthKey property has not been set for the track this method will return a zero-length DRMSF object (0m:0s:0f).*/
- (DRMSF*) length{}


@end
